/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service;

import java.util.List;

import com.thebeastshop.pegasus.service.warehouse.cond.OffSpotGoodsCond;
import com.thebeastshop.pegasus.service.warehouse.model.OffSpotGood;

/**
 * @author xionghuan
 * @version $Id: OffSpotGoodsService.java, v 0.1 2017-08-08 上午11:54
 */
public interface OffSpotGoodsService {
   
    /**
     * 根据条件查找非现货商品
     *
     * @param cond 条件
     * @return
     */
    public List<OffSpotGood> findOffSpotGoodsListByCond(OffSpotGoodsCond cond);
    
    /**
     * 查找非现货商品包裹未发货数量详情
     *
     * @param skuCode 条件
     * @return
     */
    public List<OffSpotGood> findDetailOffSpotGoodsList(String skuCode);
    
    /**
     * 查找非现货商品包裹在途数量详情
     *
     * @param skuCode 条件
     * @return
     */
    public List<OffSpotGood> findDetailOnTheWayOffSpotGoodsList(String skuCode);

}