package com.thebeastshop.pegasus.service.warehouse.model;

import java.util.*;

import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.stock.vo.SOccupyResultVO;
import com.thebeastshop.stock.vo.SReleaseResultVO;
import com.thebeastshop.stock.vo.SStockRecordVO;

public class WhCommand {
    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.ID
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private Long id;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.CODE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private String code;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.COMMAND_STATUS
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private Integer commandStatus;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.WAREHOUSE_CODE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private String warehouseCode;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.IN_OUT_TYPE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private Integer inOutType;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.REFERENCE_CODE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private String referenceCode;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.CREATE_TIME
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private Date createTime;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.PROCESS_TIME
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private Date processTime;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.PLANED_DELIVERY_DATE
     *
     * @mbggenerated Thu Oct 26 14:45:21 CST 2017
     */
    private Date planedDeliveryDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.BATCH_NO
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private String batchNo;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.EXT1
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private String ext1;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.EXT2
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private String ext2;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.EXT3
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private String ext3;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.EXT4
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private String ext4;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.EXT5
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private String ext5;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.EXPRESS_TYPE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private Integer expressType;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.EXPRESS_NO
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private String expressNo;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.WEIGHT_DATE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private Date weightDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.WEIGHT_USER_ID
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private Long weightUserId;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.WEIGHT
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private Float weight;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.CANCEL_FLAG
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private Integer cancelFlag;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.FAILURE_START_CONNECT
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    private Integer failureStartConnect;

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.ID
     *
     * @return the value of t_wh_command.ID
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_command.PHYSICAL_WAREHOUSE_CODE
     *
     * @mbggenerated Tue Dec 12 15:47:11 CST 2017
     */
    private String physicalWarehouseCode;

    private Integer commodityStatus;
    
    private String outerOrderCode;
    
    private String singlePerson;//下单人
    
    //1:天猫，默认0
    private int optType;
    
    // self
    private String saleOrderCode;
    
    private boolean sendEcpFlag = false;

    private boolean needConfirm = false; //组合商品提醒
    
    //是否回执到第三方,1:唯品会
    private int sendThirdPartyFlag = 0;

    // 物理仓
   private String physicalWarehouseName;

    // 渠道
    private String channelName;

  // 波次类型
  private String connectType;

    // 需要创建移库单
    private boolean noCreateMoveStock;

    private String singleBarcode;//多品单件-批次号


    //占用回滚List
    private List<SOccupyResultVO> rollbackOccupyList;

    //库存释放回滚List
    private  List<SReleaseResultVO> rollbackReleaseList;

    //库存记录回滚List
    private List<SStockRecordVO> rollbackRecordList;

    public String getSinglePerson() {
		return singlePerson;
	}

	public void setSinglePerson(String singlePerson) {
		this.singlePerson = singlePerson;
	}

	public List<SOccupyResultVO> getRollbackOccupyList() {
        return rollbackOccupyList;
    }

    public void setRollbackOccupyList(List<SOccupyResultVO> rollbackOccupyList) {
        this.rollbackOccupyList = rollbackOccupyList;
    }

    public List<SReleaseResultVO> getRollbackReleaseList() {
        return rollbackReleaseList;
    }

    public void setRollbackReleaseList(List<SReleaseResultVO> rollbackReleaseList) {
        this.rollbackReleaseList = rollbackReleaseList;
    }

    public List<SStockRecordVO> getRollbackRecordList() {
        return rollbackRecordList;
    }

    public void setRollbackRecordList(List<SStockRecordVO> rollbackRecordList) {
        this.rollbackRecordList = rollbackRecordList;
    }

    public int getSendThirdPartyFlag() {
    return sendThirdPartyFlag;
  }



	public void setSendThirdPartyFlag(int sendThirdPartyFlag) {
		this.sendThirdPartyFlag = sendThirdPartyFlag;
	}

	public boolean isSendEcpFlag() {
		return sendEcpFlag;
	}

	public void setSendEcpFlag(boolean sendEcpFlag) {
		this.sendEcpFlag = sendEcpFlag;
	}

	
	public String getSaleOrderCode() {
		return saleOrderCode;
	}

	public void setSaleOrderCode(String saleOrderCode) {
		this.saleOrderCode = saleOrderCode;
	}

	public String getOuterOrderCode() {
		return outerOrderCode;
	}

	public void setOuterOrderCode(String outerOrderCode) {
		this.outerOrderCode = outerOrderCode;
	}

	public int getOptType() {
		return optType;
	}

	public void setOptType(int optType) {
		this.optType = optType;
	}

	public Long getId() {
        return id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.ID
     *
     * @param id the value for t_wh_command.ID
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.CODE
     *
     * @return the value of t_wh_command.CODE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public String getCode() {
        return code;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.CODE
     *
     * @param code the value for t_wh_command.CODE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.COMMAND_STATUS
     *
     * @return the value of t_wh_command.COMMAND_STATUS
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public Integer getCommandStatus() {
        return commandStatus;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.COMMAND_STATUS
     *
     * @param commandStatus the value for t_wh_command.COMMAND_STATUS
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setCommandStatus(Integer commandStatus) {
        this.commandStatus = commandStatus;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.WAREHOUSE_CODE
     *
     * @return the value of t_wh_command.WAREHOUSE_CODE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public String getWarehouseCode() {
        return warehouseCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.WAREHOUSE_CODE
     *
     * @param warehouseCode the value for t_wh_command.WAREHOUSE_CODE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode == null ? null : warehouseCode.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.IN_OUT_TYPE
     *
     * @return the value of t_wh_command.IN_OUT_TYPE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public Integer getInOutType() {
        return inOutType;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.IN_OUT_TYPE
     *
     * @param inOutType the value for t_wh_command.IN_OUT_TYPE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setInOutType(Integer inOutType) {
        this.inOutType = inOutType;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.REFERENCE_CODE
     *
     * @return the value of t_wh_command.REFERENCE_CODE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public String getReferenceCode() {
        return referenceCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.REFERENCE_CODE
     *
     * @param referenceCode the value for t_wh_command.REFERENCE_CODE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode == null ? null : referenceCode.trim();
    }

    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.CREATE_TIME
     *
     * @return the value of t_wh_command.CREATE_TIME
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.CREATE_TIME
     *
     * @param createTime the value for t_wh_command.CREATE_TIME
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.PROCESS_TIME
     *
     * @return the value of t_wh_command.PROCESS_TIME
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public Date getProcessTime() {
        return processTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.PROCESS_TIME
     *
     * @param processTime the value for t_wh_command.PROCESS_TIME
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setProcessTime(Date processTime) {
        this.processTime = processTime;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.BATCH_NO
     *
     * @return the value of t_wh_command.BATCH_NO
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public String getBatchNo() {
        return batchNo;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.BATCH_NO
     *
     * @param batchNo the value for t_wh_command.BATCH_NO
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo == null ? null : batchNo.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.EXT1
     *
     * @return the value of t_wh_command.EXT1
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public String getExt1() {
        return ext1;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.EXT1
     *
     * @param ext1 the value for t_wh_command.EXT1
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setExt1(String ext1) {
        this.ext1 = ext1 == null ? null : ext1.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.EXT2
     *
     * @return the value of t_wh_command.EXT2
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public String getExt2() {
        return ext2;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.EXT2
     *
     * @param ext2 the value for t_wh_command.EXT2
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setExt2(String ext2) {
        this.ext2 = ext2 == null ? null : ext2.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.EXT3
     *
     * @return the value of t_wh_command.EXT3
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public String getExt3() {
        return ext3;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.EXT3
     *
     * @param ext3 the value for t_wh_command.EXT3
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setExt3(String ext3) {
        this.ext3 = ext3 == null ? null : ext3.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.EXT4
     *
     * @return the value of t_wh_command.EXT4
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public String getExt4() {
        return ext4;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.EXT4
     *
     * @param ext4 the value for t_wh_command.EXT4
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setExt4(String ext4) {
        this.ext4 = ext4 == null ? null : ext4.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.EXT5
     *
     * @return the value of t_wh_command.EXT5
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public String getExt5() {
        return ext5;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.EXT5
     *
     * @param ext5 the value for t_wh_command.EXT5
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setExt5(String ext5) {
        this.ext5 = ext5 == null ? null : ext5.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.EXPRESS_TYPE
     *
     * @return the value of t_wh_command.EXPRESS_TYPE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public Integer getExpressType() {
        return expressType;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.EXPRESS_TYPE
     *
     * @param expressType the value for t_wh_command.EXPRESS_TYPE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.EXPRESS_NO
     *
     * @return the value of t_wh_command.EXPRESS_NO
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public String getExpressNo() {
        return expressNo;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.EXPRESS_NO
     *
     * @param expressNo the value for t_wh_command.EXPRESS_NO
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setExpressNo(String expressNo) {
        this.expressNo = expressNo == null ? null : expressNo.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.WEIGHT_DATE
     *
     * @return the value of t_wh_command.WEIGHT_DATE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public Date getWeightDate() {
        return weightDate;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.WEIGHT_DATE
     *
     * @param weightDate the value for t_wh_command.WEIGHT_DATE
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setWeightDate(Date weightDate) {
        this.weightDate = weightDate;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.WEIGHT_USER_ID
     *
     * @return the value of t_wh_command.WEIGHT_USER_ID
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public Long getWeightUserId() {
        return weightUserId;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.WEIGHT_USER_ID
     *
     * @param weightUserId the value for t_wh_command.WEIGHT_USER_ID
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setWeightUserId(Long weightUserId) {
        this.weightUserId = weightUserId;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.WEIGHT
     *
     * @return the value of t_wh_command.WEIGHT
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public Float getWeight() {
        return weight;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.WEIGHT
     *
     * @param weight the value for t_wh_command.WEIGHT
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setWeight(Float weight) {
        this.weight = weight;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.CANCEL_FLAG
     *
     * @return the value of t_wh_command.CANCEL_FLAG
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public Integer getCancelFlag() {
        return cancelFlag;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.CANCEL_FLAG
     *
     * @param cancelFlag the value for t_wh_command.CANCEL_FLAG
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setCancelFlag(Integer cancelFlag) {
        this.cancelFlag = cancelFlag;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_command.FAILURE_START_CONNECT
     *
     * @return the value of t_wh_command.FAILURE_START_CONNECT
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public Integer getFailureStartConnect() {
        return failureStartConnect;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_command.FAILURE_START_CONNECT
     *
     * @param failureStartConnect the value for t_wh_command.FAILURE_START_CONNECT
     *
     * @mbggenerated Sat May 28 16:22:33 CST 2016
     */
    public void setFailureStartConnect(Integer failureStartConnect) {
        this.failureStartConnect = failureStartConnect;
    }



    // self
    // status 指令状态[0取消 1执行中/待启动 2完成 3待质检 4质检中 5待拣货 6待分拨/拣货中 7待包装 8待交接 9发货完成 10缺货中 11收货质检完成]
    public static final Integer STATUS_CANCELED      = 0;
    public static final Integer STATUS_IN_PROCESSING = 1;
    public static final Integer STATUS_FINISHED      = 2;

    public static final Integer STATUS_WAITING_QUALITY_CONTROL = 3;
    public static final Integer STATUS_QUALITY_PROCESSING = 4;
    public static final Integer STATUS_PICKING = 5;
    public static final Integer STATUS_DISTRIBUTION = 6;
    public static final Integer STATUS_PACKING = 7;
    public static final Integer STATUS_HANDOVER = 8;
    public static final Integer STATUS_DELIVERYCOMPLETION = 9;
    public static final Integer STATUS_SHORTAGES = 10;
    public static final Integer STATUS_QUALITY_FINISHED = 11;

    // type

    //出入库类型，10调拨入库11采购入库12退货入库13样品入库15生产加工入库16串货入库19库间移入20调拨出库21采购出库22销售出库23礼品出库24样品出库25换货出库27生产加工出库29库间移出28采购退单出库30调拨库存占用33串货出库
    public static final Integer TYPE_ALLOT_IN        = 10;
    public static final Integer TYPE_PURCHASE_IN     = 11;
    public static final Integer TYPE_RETURN_IN       = 12;
    public static final Integer TYPE_SAMPLE_IN       = 13;
    public static final Integer TYPE_PRODUCE_IN      = 15;
    public static final Integer TYPE_INVENTROY_PROFIT_IN    = 14;//盘盈
    public static final Integer TYPE_MOVE_IN         = 19;
    public static final Integer TYPE_CROSSGOODS_IN    = 16;     //串货入库

    public static final Integer TYPE_ALLOT_OUT       = 20;
    public static final Integer TYPE_PURCHASE_OUT    = 21;
    public static final Integer TYPE_SALES_OUT       = 22;
    public static final Integer TYPE_GIFT_OUT        = 23;
    public static final Integer TYPE_SAMPLE_OUT      = 24;
    public static final Integer TYPE_CHANGE_OUT      = 25;
    public static final Integer TYPE_INVENTROY_LOSS_OUT   = 26;//盘亏
    public static final Integer TYPE_PRODUCE_OUT     = 27;
    public static final Integer TYPE_MOVE_OUT        = 29;
    public static final Integer TYPE_PURCHASE_RETURN_OUT = 28;
    public static final Integer TYPE_ALLOT_OCCUPY    = 30;
//    public static final Integer TYPE_RECEIVE_WASTE_OUT = 32;//报废领用出库
    public static final Integer TYPE_CROSSGOODS_OUT    = 33;    //串货出库

    public static final Integer SINGLE_YES = 1;//单件是
    public static final Integer SINGLE_NO = 0;//单件否

    private List<WhCommandSku> whCommandSkuList;

    private Map<String,List<WhCommandSku>> commSkuMap;

    public List<WhCommandSku> getWhCommandSkuList() {
        return whCommandSkuList;
    }

    public void setWhCommandSkuList(List<WhCommandSku> whCommandSkuList) {
        this.whCommandSkuList = whCommandSkuList;
    }

    public Map<String, List<WhCommandSku>> getCommSkuMap() {
        return commSkuMap;
    }

    public void setCommSkuMap(Map<String, List<WhCommandSku>> commSkuMap) {
        this.commSkuMap = commSkuMap;
    }

    public boolean isIn() {
        return this.inOutType / 10 == 1;
    }

    public boolean isOut() {
        return this.inOutType / 10 == 2 || this.inOutType == 32 || this.inOutType == 33;
    }

    public static List<Map<String,String>> getAllPutAwayTypeList(){
        List<Map<String,String>> list = new ArrayList<>();
        Map<String,String> tmp = new HashMap<>();
        tmp.put("value",TYPE_PURCHASE_IN.toString());
        tmp.put("text","采购上架");
        list.add(tmp);
        tmp = new HashMap<>();
        tmp.put("value",TYPE_ALLOT_IN.toString());
        tmp.put("text","调拨上架");
        list.add(tmp);
        tmp = new HashMap<>();
        tmp.put("value",TYPE_RETURN_IN.toString());
        tmp.put("text","退货上架");
        list.add(tmp);
        tmp = new HashMap<>();
        tmp.put("value",TYPE_PRODUCE_IN.toString());
        tmp.put("text","加工上架");
        list.add(tmp);
        return list;
    }

    public static String getPutAwayTypeName(Integer type){
        return TYPE_PURCHASE_IN.equals(type)?"采购上架":
                    TYPE_ALLOT_IN.equals(type)?"调拨上架":
                        TYPE_RETURN_IN.equals(type)?"退货上架":
                                TYPE_PRODUCE_IN.equals(type)?"加工上架":"";
    }

    public static List<Integer> getAllInType() {
        List<Integer> res = new ArrayList<>();
        res.add(TYPE_ALLOT_IN);
        res.add(TYPE_PURCHASE_IN);
        res.add(TYPE_RETURN_IN);
        res.add(TYPE_SAMPLE_IN);
        res.add(TYPE_PRODUCE_IN);
        res.add(TYPE_MOVE_IN);
        return res;
    }

    public static List<Integer> getAllOutType() {
        List<Integer> res = new ArrayList<>();
        res.add(TYPE_ALLOT_OUT);
        res.add(TYPE_PURCHASE_OUT);
        res.add(TYPE_SALES_OUT);
        res.add(TYPE_GIFT_OUT);
        res.add(TYPE_SAMPLE_OUT);
        res.add(TYPE_CHANGE_OUT);
        res.add(TYPE_PRODUCE_OUT);
        res.add(TYPE_MOVE_OUT);
        res.add(TYPE_PURCHASE_RETURN_OUT);
//        res.add(TYPE_RECEIVE_WASTE_OUT);
        return res;
    }

    public static List<Integer> getAllType() {
        List<Integer> res = new ArrayList<>();
        res.addAll(getAllInType());
        res.addAll(getAllOutType());
        return res;
    }

    public String getInOutTypeStr() {
        return getInOutTypeName(this.inOutType);
    }
    
    public static String getInOutTypeName(Integer inOutType){
    	if (inOutType == null) {
            return "";
        }

        String res;
        switch (inOutType) {
            case 10:
                res = "调拨入库";
                break;
            case 11:
                res = "采购入库";
                break;
            case 12:
                res = "退货入库";
                break;
            case 13:
                res = "样品入库";
                break;
            case 14 :
                res = "盘盈";
                break;
            case 15 :
                res = "生产加工入库";
                break;
            case 16 :
                res = "串货入库";
                break;
            case 19:
                res = "库间移入";
                break;
            case 20:
                res = "调拨出库";
                break;
            case 21:
                res = "采购出库";
                break;
            case 22:
                res = "销售出库";
                break;
            case 23:
                res = "礼品出库";
                break;
            case 24:
                res = "样品出库";
                break;
            case 25:
                res = "换货出库";
                break;
            case 26:
                res = "盘亏";
                break;
            case 27 :
                res = "生产加工出库";
                break;
            case 29:
                res = "库间移出";
                break;
            case 28:
                res = "采退出库";
                break;
            case 32:
                res = "报废出库";
                break;
            case 33 :
                res = "串货出库";
                break;
            default:
                res = "";
                break;
        }

        return res;
    }

    public static String getCommandStatusStr(Integer commandStatusParam) {
        if (commandStatusParam == null) {
            return "";
        }
        String res;
        switch (commandStatusParam) {
            case 0:
                res = "取消";
                break;
            case 1:
                res = "执行中";
                break;
            case 2:
                res = "完成";
                break;
            case 3:
                res = "待质检";
                break;
            case 4:
                res = "质检中";
                break;
            case 5:
                res = "待拣货";
                break;
            case 6:
                res = "拣货中";
                break;
            case 7:
                res = "包装中";
                break;
            case 8:
                res = "待交接";
                break;
            case 9:
                res = "发货完成";
                break;
            case 10:
                res = "缺货中";
                break;
            case 11:
                res = "收货完成";
                break;
            default:
                res = "";
                break;
        }
        return res;
    }

    //0取消1执行中2完成 3待质检 4 质检中 5待发货6拣货中7包装中8待交接9发货完成10缺货中11收货完成
    public String getCommandStatusStr() {
        return getCommandStatusStr(this.commandStatus);
    }

    private String expressTypeName;

    private String expressTypeFullName;

    private boolean specialVoice = false;

    private Integer commandCount;

    private Integer commandCancelCount;

    private String idsStr;

    private Long operatorId;

    // 无需在调用处更新 调拨单状态
    private boolean noUpdateAllot;

    public boolean isSpecialVoice() {
        return specialVoice;
    }

    public void setSpecialVoice(boolean specialVoice) {
        this.specialVoice = specialVoice;
    }

    public String getExpressTypeStr() {
        return getExpressTypeName();
    }

    public boolean isNeedConfirm() {
        return needConfirm;
    }

    public void setNeedConfirm(boolean needConfirm) {
        this.needConfirm = needConfirm;
    }

    public String getExpressTypeName() {
        if(expressTypeName != null && !expressTypeName.equals("") ){
            return expressTypeName;
        }
        String name = "";
        if (expressType == null) {
            return "";
        }else{
            WhWmsExpressInfo whWmsExpressInfo = PegasusWarehouseServiceFacade.getInstance().findExpressInfoById(Long.parseLong(expressType.toString()));
            if(whWmsExpressInfo != null){
                return whWmsExpressInfo.getName();
            }
        }
        return name;
    }

    public String getExpressTypeFullName() {
        return expressTypeFullName;
    }

    public void setExpressTypeFullName(String expressTypeFullName) {
        this.expressTypeFullName = expressTypeFullName;
    }

    public  List<WhCommandSku> getCommandSkuGroupBySku(){
        List<WhCommandSku> tmpList = getWhCommandSkuList();
        if(EmptyUtil.isEmpty(tmpList)){
            return Collections.emptyList();
        }
        List<WhCommandSku> commandSkuList = BeanUtil.buildListFrom(tmpList,WhCommandSku.class);
        Map<String,WhCommandSku> sumMap = new HashMap<>();
        for(WhCommandSku commandSku : commandSkuList){
            WhCommandSku tmp = sumMap.get(commandSku.getSkuCode());
            if(NullUtil.isNull(tmp)){
                sumMap.put(commandSku.getSkuCode(),commandSku);
            }else{
                tmp.setPlanedQuantity(tmp.getPlanedQuantity()+commandSku.getPlanedQuantity());
            }
        }
        Collection<WhCommandSku> values = sumMap.values();
        return Arrays.asList(values.toArray(new WhCommandSku[values.size()]));
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getConnectType() {
        return connectType;
    }

    public void setConnectType(String connectType) {
        this.connectType = connectType;
    }

    public boolean isNoCreateMoveStock() {
        return noCreateMoveStock;
    }

    public void setNoCreateMoveStock(boolean noCreateMoveStock) {
        this.noCreateMoveStock = noCreateMoveStock;
    }

    public void setExpressTypeName(String expressTypeName) {
        this.expressTypeName = expressTypeName;
    }

    public static String getSkuStatusName(Integer skuStatus){
        return WhWarehouseVO.getSkuStatusName(skuStatus);
    }

    public Integer getCommandCount() {
        return commandCount;
    }

    public void setCommandCount(Integer commandCount) {
        this.commandCount = commandCount;
    }

    public Integer getCommandCancelCount() {
        return commandCancelCount;
    }

    public void setCommandCancelCount(Integer commandCancelCount) {
        this.commandCancelCount = commandCancelCount;
    }

    public String getIdsStr() {
        return idsStr;
    }

    public void setIdsStr(String idsStr) {
        this.idsStr = idsStr;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public Integer getCommodityStatus() {
        return commodityStatus;
    }

    public void setCommodityStatus(Integer commodityStatus) {
        this.commodityStatus = commodityStatus;
    }

    public String getSingleBarcode() {
        return singleBarcode;
    }

    public void setSingleBarcode(String singleBarcode) {
        this.singleBarcode = singleBarcode;
    }

    public boolean isNoUpdateAllot() {
        return noUpdateAllot;
    }

    public void setNoUpdateAllot(boolean noUpdateAllot) {
        this.noUpdateAllot = noUpdateAllot;
    }
}