package com.thebeastshop.pegasus.service.warehouse.model;

import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotDiffDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhJitPackageSkuReferenceVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import com.thebeastshop.stock.vo.SOccupyResultVO;
import com.thebeastshop.stock.vo.SReleaseResultVO;
import com.thebeastshop.stock.vo.SStockRecordVO;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class WhAllotRcd  implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.ID
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private Long id;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private String code;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.ALLOT_STATUS
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private Integer allotStatus;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.ALLOT_TYPE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private Integer allotType;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.REFERENCE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private String referenceCode;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.CREATE_TIME
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private Date createTime;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.FINISH_TIME
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private Date finishTime;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.SOURCE_WAREHOUSE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private String sourceWarehouseCode;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.TARGET_WAREHOUSE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private String targetWarehouseCode;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.CONFIRM_WAREHOUSE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private String confirmWarehouseCode;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.REMARK
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private String remark;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_pre_allot_rcd.ESTIMATED_ALLOCATION_DATE
     * 预计调拨日期
     * @mbggenerated Fri Dec 23 15:22:24 CST 2016
     */
    private Date estimatedAllocationDate;
    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.REJECTED_REASON
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    private String rejectedReason;

    private Date confirmTime;

    //占用回滚List
    private List<SOccupyResultVO> rollbackOccupyList;

    //库存释放回滚List
    private  List<SReleaseResultVO> rollbackReleaseList;

    //库存记录回滚List
    private List<SStockRecordVO> rollbackRecordList;

    //预占用list，创建调拨单后释放
    private List<SStockReleaseDTO> preOccupyReleaseList;

    public List<SOccupyResultVO> getRollbackOccupyList() {
        return rollbackOccupyList;
    }

    public void setRollbackOccupyList(List<SOccupyResultVO> rollbackOccupyList) {
        this.rollbackOccupyList = rollbackOccupyList;
    }

    public List<SReleaseResultVO> getRollbackReleaseList() {
        return rollbackReleaseList;
    }

    public void setRollbackReleaseList(List<SReleaseResultVO> rollbackReleaseList) {
        this.rollbackReleaseList = rollbackReleaseList;
    }

    public List<SStockRecordVO> getRollbackRecordList() {
        return rollbackRecordList;
    }

    public void setRollbackRecordList(List<SStockRecordVO> rollbackRecordList) {
        this.rollbackRecordList = rollbackRecordList;
    }


    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database column t_wh_allot_rcd.CREATE_USER_ID
     *
     * @mbggenerated Fri Oct 13 15:13:56 CST 2017
     */
    private Integer createUserId;
    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.ID
     *
     * @return the value of t_wh_allot_rcd.ID
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public Long getId() {
        return id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.ID
     *
     * @param id the value for t_wh_allot_rcd.ID
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.CODE
     *
     * @return the value of t_wh_allot_rcd.CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public String getCode() {
        return code;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.CODE
     *
     * @param code the value for t_wh_allot_rcd.CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.ALLOT_STATUS
     *
     * @return the value of t_wh_allot_rcd.ALLOT_STATUS
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public Integer getAllotStatus() {
        return allotStatus;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.ALLOT_STATUS
     *
     * @param allotStatus the value for t_wh_allot_rcd.ALLOT_STATUS
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public void setAllotStatus(Integer allotStatus) {
        this.allotStatus = allotStatus;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.ALLOT_TYPE
     *
     * @return the value of t_wh_allot_rcd.ALLOT_TYPE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public Integer getAllotType() {
        return allotType;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.ALLOT_TYPE
     *
     * @param allotType the value for t_wh_allot_rcd.ALLOT_TYPE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public void setAllotType(Integer allotType) {
        this.allotType = allotType;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.REFERENCE_CODE
     *
     * @return the value of t_wh_allot_rcd.REFERENCE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public String getReferenceCode() {
        return referenceCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.REFERENCE_CODE
     *
     * @param referenceCode the value for t_wh_allot_rcd.REFERENCE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode == null ? null : referenceCode.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.CREATE_TIME
     *
     * @return the value of t_wh_allot_rcd.CREATE_TIME
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.CREATE_TIME
     *
     * @param createTime the value for t_wh_allot_rcd.CREATE_TIME
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateTimeStr() {
        if(getCreateTime() == null){
            return "";
        }
        return DateUtil.format(getCreateTime(),DateUtil.DEFAULT_DATETIME_FORMAT);
    }
    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.FINISH_TIME
     *
     * @return the value of t_wh_allot_rcd.FINISH_TIME
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public Date getFinishTime() {
        return finishTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.FINISH_TIME
     *
     * @param finishTime the value for t_wh_allot_rcd.FINISH_TIME
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }



    public String getFinishTimeStr() {
        if(getFinishTime() == null){
            return "";
        }
        return DateUtil.format(getFinishTime(),DateUtil.DEFAULT_DATETIME_FORMAT);
    }
    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.SOURCE_WAREHOUSE_CODE
     *
     * @return the value of t_wh_allot_rcd.SOURCE_WAREHOUSE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public String getSourceWarehouseCode() {
        return sourceWarehouseCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.SOURCE_WAREHOUSE_CODE
     *
     * @param sourceWarehouseCode the value for t_wh_allot_rcd.SOURCE_WAREHOUSE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public void setSourceWarehouseCode(String sourceWarehouseCode) {
        this.sourceWarehouseCode = sourceWarehouseCode == null ? null : sourceWarehouseCode.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.TARGET_WAREHOUSE_CODE
     *
     * @return the value of t_wh_allot_rcd.TARGET_WAREHOUSE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public String getTargetWarehouseCode() {
        return targetWarehouseCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.TARGET_WAREHOUSE_CODE
     *
     * @param targetWarehouseCode the value for t_wh_allot_rcd.TARGET_WAREHOUSE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public void setTargetWarehouseCode(String targetWarehouseCode) {
        this.targetWarehouseCode = targetWarehouseCode == null ? null : targetWarehouseCode.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.CONFIRM_WAREHOUSE_CODE
     *
     * @return the value of t_wh_allot_rcd.CONFIRM_WAREHOUSE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public String getConfirmWarehouseCode() {
        return confirmWarehouseCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.CONFIRM_WAREHOUSE_CODE
     *
     * @param confirmWarehouseCode the value for t_wh_allot_rcd.CONFIRM_WAREHOUSE_CODE
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public void setConfirmWarehouseCode(String confirmWarehouseCode) {
        this.confirmWarehouseCode = confirmWarehouseCode == null ? null : confirmWarehouseCode.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.REMARK
     *
     * @return the value of t_wh_allot_rcd.REMARK
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public String getRemark() {
        return remark;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.REMARK
     *
     * @param remark the value for t_wh_allot_rcd.REMARK
     *
     * @mbggenerated Tue Jan 19 16:57:13 CST 2016
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Date getEstimatedAllocationDate() {
        return estimatedAllocationDate;
    }

    public void setEstimatedAllocationDate(Date estimatedAllocationDate) {
        this.estimatedAllocationDate = estimatedAllocationDate;
    }
    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_rcd.CREATE_USER_ID
     *
     * @return the value of t_wh_allot_rcd.CREATE_USER_ID
     *
     * @mbggenerated Fri Oct 13 15:13:56 CST 2017
     */
    public Integer getCreateUserId() {
        return createUserId;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_rcd.CREATE_USER_ID
     *
     * @param createUserId the value for t_wh_allot_rcd.CREATE_USER_ID
     *
     * @mbggenerated Fri Oct 13 15:13:56 CST 2017
     */
    public void setCreateUserId(Integer createUserId) {
        this.createUserId = createUserId;
    }
    public String getEstimatedAllocationDateStr() {
        if(getEstimatedAllocationDate() == null){
            return "";
        }
        return DateUtil.format(getEstimatedAllocationDate(),DateUtil.DEFAULT_DATE_FORMAT);
    }
    // self
    // status
    public static final Integer STATUS_CANCELED = 0; // 0取消
    public static final Integer STATUS_WAIT_FOR_CONFIRMATION = 1; // 1待确认
    public static final Integer STATUS_WAIT_FOR_OUTBOUND = 2; // 2待出库
    public static final Integer STATUS_WAIT_FOR_INBOUND = 3; // 3待入库
    public static final Integer STATUS_FINISHED = 4; // 4完成
    public static final Integer STATUS_REJECTED = 9; // 9驳回

    // type
    public static final Integer TYPE_NORMAL = 1; // 正常
    public static final Integer TYPE_DAMAGED = 2;  // 残次
    public static final Integer TYPE_WASTED = 3;  // 报废
    public static final Integer TYPE_FIXED = 4;  // 修复
    public static final Integer TYPE_CONSUMABLE = 5;// 耗材调拨
    public static final Integer TYPE_SELL_ORDER = 6;// 销售定单
    public static final Integer TYPE_BETWEEN_CHANNELS = 7; // 渠道间调货
    public static final Integer TYPE_GIFT = 8;  // 礼品
    public static final Integer TYPE_SAMPLE = 9;  // 样品
    public static final Integer TYPE_CUSTOMIZE_OUT = 10;  // 定制商品调拨(出)
    public static final Integer TYPE_CUSTOMIZE_IN = 11;  // 定制商品调拨(入)
    public static final Integer AUTO_TRANSFER_ALLOT = 12;// 来单制作自动调拨
    public static final Integer TYPE_CROSS_BORDER_ALLOT = 16;// 海淘调拨     ---rd_7780

    public static final String IS_DIRECT_DELIVER = "1"; // 是否直发 1：直发
    
    private Integer isChannelGoods;//是否渠道分货 1：是 0：否

    private String sourcePhysicalWarehouseCode;

    private String targetPhysicalWarehouseCode;

    private String confirmPhysicalWarehouseCode;

    private String sourcePhysicalWarehouseName;

    private String targetPhysicalWarehouseName;

    private List<WhAllotRcdSku> whAllotRcdSkuList;

    private List<WhAllotDiffDetailVO> allotDiffDetailVOs;

    private String sourcePhyWarehouseName;
    
    private String targetPhyWarehouseName;

    private String sourceWarehouseName;

    private String targetWarehouseName;

    private Integer expressType;

    // 操作人
    private String operatorName;

    // 关联包裹号
    private String refPackageCode;
    // 定制信息
    private String customizationContent;

    // 不同步其它平台(默认是同步的)
    private boolean noSyncOtherPlatform = false;

    // 来单包裹关联信息 相关单据号
    private String jitPackageSkuRefCode;

    private List<PcsSkuVO> pcsSkus;

    private List<WhJitPackageSkuReferenceVO> jitPackageSkuReferenceVOs;

    private boolean needConfirm = false;


    private String logMsg;

    // 调拨差异处理 (创建调拨单)
    private boolean diffProcess;
    // 需要直接 设置为待入库
    private boolean needWaitInBound;

    // 需要更新的 rcd_sku id
    private Long needUpdateRefId;

    // 调拨差异详情记录的 allotId
    private Long oldAllotId;

    // 物理源仓类型
    private Integer sourceWarehousePhType;

    // 物理目标仓类型
    private Integer targetWarehousePhType;
    // 目标逻辑源仓类型
    private Integer targetWarehouseType;

    // 源逻辑源仓类型
    private Integer sourceWarehouseType;
    // 源逻辑仓的商品状态
    private Integer sourceWarehouseCommodityStatus;

    // 调拨差异源逻辑仓
    private String allotDiffSourceWarehouseCode;
    private String allotDiffSourceWarehouseName;

    // 调拨差异物理仓
    private String allotDiffSourcePhysicalWarehouseCode;

    private boolean secondConfirm = false;

	public Integer getIsChannelGoods() {
		return isChannelGoods;
	}

	public void setIsChannelGoods(Integer isChannelGoods) {
		this.isChannelGoods = isChannelGoods;
	}

	public List<WhAllotRcdSku> getWhAllotRcdSkuList() {
        return whAllotRcdSkuList;
    }

    public void setWhAllotRcdSkuList(List<WhAllotRcdSku> whAllotRcdSkuList) {
        this.whAllotRcdSkuList = whAllotRcdSkuList;
    }

    public List<WhAllotDiffDetailVO> getAllotDiffDetailVOs() {
        return allotDiffDetailVOs;
    }

    public void setAllotDiffDetailVOs(List<WhAllotDiffDetailVO> allotDiffDetailVOs) {
        this.allotDiffDetailVOs = allotDiffDetailVOs;
    }

    public String getSourcePhyWarehouseName() {
		return sourcePhyWarehouseName;
	}

	public void setSourcePhyWarehouseName(String sourcePhyWarehouseName) {
		this.sourcePhyWarehouseName = sourcePhyWarehouseName;
	}

	public String getTargetPhyWarehouseName() {
		return targetPhyWarehouseName;
	}

	public void setTargetPhyWarehouseName(String targetPhyWarehouseName) {
		this.targetPhyWarehouseName = targetPhyWarehouseName;
	}

	public Integer getExpressType() {
		return expressType;
	}

	public void setExpressType(Integer expressType) {
		this.expressType = expressType;
	}
	
	public String getExpressTypeStr(){
		if(expressType != null){
            WhWmsExpressInfo whWmsExpressInfo = PegasusWarehouseServiceFacade.getInstance().findExpressInfoById(Long.parseLong(expressType.toString()));
            if(whWmsExpressInfo != null){
                return whWmsExpressInfo.getName();
            }
        }
        return "";
	}
	
	public String getPlanedDeliveryDateStr(){
		return DateUtil.format(this.getCreateTime(), DateUtil.DEFAULT_DATE_FORMAT);
	}

    public String getTargetPhysicalWarehouseName() {
        return targetPhysicalWarehouseName;
    }

    public void setTargetPhysicalWarehouseName(String targetPhysicalWarehouseName) {
        this.targetPhysicalWarehouseName = targetPhysicalWarehouseName;
    }

    public String getSourcePhysicalWarehouseName() {
        return sourcePhysicalWarehouseName;
    }

    public void setSourcePhysicalWarehouseName(String sourcePhysicalWarehouseName) {
        this.sourcePhysicalWarehouseName = sourcePhysicalWarehouseName;
    }

    public boolean isNeedConfirm() {
        return needConfirm;
    }

    public void setNeedConfirm(boolean needConfirm) {
        this.needConfirm = needConfirm;
    }

    public String getLogMsg() {
        return logMsg;
    }

    public void setLogMsg(String logMsg) {
        this.logMsg = logMsg;
    }

    public boolean isDiffProcess() {
        return diffProcess;
    }

    public void setDiffProcess(boolean diffProcess) {
        this.diffProcess = diffProcess;
    }

    public boolean isNeedWaitInBound() {
        return needWaitInBound;
    }

    public void setNeedWaitInBound(boolean needWaitInBound) {
        this.needWaitInBound = needWaitInBound;
    }

    public Long getNeedUpdateRefId() {
        return needUpdateRefId;
    }

    public void setNeedUpdateRefId(Long needUpdateRefId) {
        this.needUpdateRefId = needUpdateRefId;
    }

    public Long getOldAllotId() {
        return oldAllotId;
    }

    public void setOldAllotId(Long oldAllotId) {
        this.oldAllotId = oldAllotId;
    }

    public Integer getSourceWarehousePhType() {
        return sourceWarehousePhType;
    }

    public void setSourceWarehousePhType(Integer sourceWarehousePhType) {
        this.sourceWarehousePhType = sourceWarehousePhType;
    }

    public Integer getTargetWarehousePhType() {
        return targetWarehousePhType;
    }

    public void setTargetWarehousePhType(Integer targetWarehousePhType) {
        this.targetWarehousePhType = targetWarehousePhType;
    }

    public Integer getTargetWarehouseType() {
        return targetWarehouseType;
    }

    public void setTargetWarehouseType(Integer targetWarehouseType) {
        this.targetWarehouseType = targetWarehouseType;
    }

    public Integer getSourceWarehouseType() {
        return sourceWarehouseType;
    }

    public void setSourceWarehouseType(Integer sourceWarehouseType) {
        this.sourceWarehouseType = sourceWarehouseType;
    }

    public Integer getSourceWarehouseCommodityStatus() {
        return sourceWarehouseCommodityStatus;
    }

    public void setSourceWarehouseCommodityStatus(Integer sourceWarehouseCommodityStatus) {
        this.sourceWarehouseCommodityStatus = sourceWarehouseCommodityStatus;
    }

    public String getAllotDiffSourceWarehouseCode() {
        return allotDiffSourceWarehouseCode;
    }

    public void setAllotDiffSourceWarehouseCode(String allotDiffSourceWarehouseCode) {
        this.allotDiffSourceWarehouseCode = allotDiffSourceWarehouseCode;
    }

    public String getAllotDiffSourceWarehouseName() {
        return allotDiffSourceWarehouseName;
    }

    public void setAllotDiffSourceWarehouseName(String allotDiffSourceWarehouseName) {
        this.allotDiffSourceWarehouseName = allotDiffSourceWarehouseName;
    }

    public String getAllotDiffSourcePhysicalWarehouseCode() {
        return allotDiffSourcePhysicalWarehouseCode;
    }

    public void setAllotDiffSourcePhysicalWarehouseCode(String allotDiffSourcePhysicalWarehouseCode) {
        this.allotDiffSourcePhysicalWarehouseCode = allotDiffSourcePhysicalWarehouseCode;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getSourceWarehouseName() {
        return sourceWarehouseName;
    }

    public void setSourceWarehouseName(String sourceWarehouseName) {
        this.sourceWarehouseName = sourceWarehouseName;
    }

    public String getTargetWarehouseName() {
        return targetWarehouseName;
    }

    public void setTargetWarehouseName(String targetWarehouseName) {
        this.targetWarehouseName = targetWarehouseName;
    }

    public String getRefPackageCode() {
        return refPackageCode;
    }

    public void setRefPackageCode(String refPackageCode) {
        this.refPackageCode = refPackageCode;
    }

    public String getConfirmPhysicalWarehouseCode() {
        return confirmPhysicalWarehouseCode;
    }

    public void setConfirmPhysicalWarehouseCode(String confirmPhysicalWarehouseCode) {
        this.confirmPhysicalWarehouseCode = confirmPhysicalWarehouseCode;
    }

    public String getCustomizationContent() {
        return customizationContent;
    }

    public void setCustomizationContent(String customizationContent) {
        this.customizationContent = customizationContent;
    }

    public List<WhJitPackageSkuReferenceVO> getJitPackageSkuReferenceVOs() {
        return jitPackageSkuReferenceVOs;
    }

    public void setJitPackageSkuReferenceVOs(List<WhJitPackageSkuReferenceVO> jitPackageSkuReferenceVOs) {
        this.jitPackageSkuReferenceVOs = jitPackageSkuReferenceVOs;
    }

    public String getAllotStatusStr(){
        return getAllotStatusName(getAllotStatus());
    }

    public static String getAllotStatusName(Integer allotStatus){
        return STATUS_CANCELED.equals(allotStatus)?"取消":
                STATUS_WAIT_FOR_CONFIRMATION.equals(allotStatus)?"待确认":
                        STATUS_WAIT_FOR_OUTBOUND.equals(allotStatus)?"待出库":
                                STATUS_WAIT_FOR_INBOUND.equals(allotStatus)?"待入库":
                                        STATUS_FINISHED.equals(allotStatus)?"完成":
                                                STATUS_REJECTED.equals(allotStatus)?"驳回":"";
    }

    public String getAllotTypeStr(){
        return getAllotTypeName(getAllotType());
    }

    public static String getAllotTypeName(Integer allotStatus){
        return TYPE_NORMAL.equals(allotStatus)?"正常":
                TYPE_DAMAGED.equals(allotStatus)?"残次":
                  TYPE_WASTED.equals(allotStatus)?"报废":
                   TYPE_FIXED.equals(allotStatus)?"修复":
                     TYPE_CONSUMABLE.equals(allotStatus)?"耗材调拨":
                       TYPE_SELL_ORDER.equals(allotStatus)?"销售定单":
                         TYPE_BETWEEN_CHANNELS.equals(allotStatus)?"渠道间调货":
                           TYPE_GIFT.equals(allotStatus)?"礼品":
                             TYPE_SAMPLE.equals(allotStatus)?"样品":
                               TYPE_CUSTOMIZE_OUT.equals(allotStatus)?"定制商品调拨(出)":
                                 TYPE_CUSTOMIZE_IN.equals(allotStatus)?"定制商品调拨(入)":"";
    }

    public boolean isSecondConfirm() {
        return secondConfirm;
    }

    public void setSecondConfirm(boolean secondConfirm) {
        this.secondConfirm = secondConfirm;
    }

    public boolean isNoSyncOtherPlatform() {
        return noSyncOtherPlatform;
    }

    public void setNoSyncOtherPlatform(boolean noSyncOtherPlatform) {
        this.noSyncOtherPlatform = noSyncOtherPlatform;
    }

    public String getTargetPhysicalWarehouseCode() {
        return targetPhysicalWarehouseCode;
    }

    public void setTargetPhysicalWarehouseCode(String targetPhysicalWarehouseCode) {
        this.targetPhysicalWarehouseCode = targetPhysicalWarehouseCode;
    }

    public String getSourcePhysicalWarehouseCode() {
        return sourcePhysicalWarehouseCode;
    }

    public void setSourcePhysicalWarehouseCode(String sourcePhysicalWarehouseCode) {
        this.sourcePhysicalWarehouseCode = sourcePhysicalWarehouseCode;
    }

    public String getJitPackageSkuRefCode() {
        return jitPackageSkuRefCode;
    }

    public void setJitPackageSkuRefCode(String jitPackageSkuRefCode) {
        this.jitPackageSkuRefCode = jitPackageSkuRefCode;
    }

    public List<PcsSkuVO> getPcsSkus() {
        return pcsSkus;
    }

    public void setPcsSkus(List<PcsSkuVO> pcsSkus) {
        this.pcsSkus = pcsSkus;
    }
	public String getRejectedReason() {
		return rejectedReason;
	}

	public void setRejectedReason(String rejectedReason) {
		this.rejectedReason = rejectedReason;
	}

    public List<SStockReleaseDTO> getPreOccupyReleaseList() {
        return preOccupyReleaseList;
    }

    public void setPreOccupyReleaseList(List<SStockReleaseDTO> preOccupyReleaseList) {
        this.preOccupyReleaseList = preOccupyReleaseList;
    }
}