/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.exception;

/**
 * @author Royan
 * @version $Id: WarehouseExceptionErrorCode.java, v 0.1 2015-07-29 下午2:17
 */
public class WarehouseExceptionErrorCode {

    private static final String ERROR_CODE_PREFIX                          = "WH";

    // 操作结果不符合预期
    public static final String RESULT_NOT_EXPECTED = ERROR_CODE_PREFIX + "0001";

    // 非法参数
    public static final String  ILLEGAL_PARAM = ERROR_CODE_PREFIX + "0002";

    // 同物理仓只能有一个当前类型的逻辑仓
    public static final String  PHYSICAL_WAREHOUSE_HAS_SAME_TYPE_WAREHOUSE = ERROR_CODE_PREFIX
                                                                             + "0100";

    // 占用库存失败,库存不足
    public static final String  OCCUPY_FAILED_INV_IS_NOT_ENOUGH            = ERROR_CODE_PREFIX
                                                                             + "0101";
    // 天猫占用库存失败,库存不足
    public static final String  OCCUPY_FAILED_TAMLL_IS_NOT_ENOUGH            = ERROR_CODE_PREFIX
    																			+ "0101";

    // 占用更新失败
    public static final String  UPDATE_OCCUPY_FAILED                       = ERROR_CODE_PREFIX
                                                                             + "0102";

    // 找不到仓库
    public static final String  WAREHOUSE_NOT_FIND                         = ERROR_CODE_PREFIX
                                                                             + "0103";

    // 仓库类型不符
    public static final String  WRONG_WAREHOUSE_TYPE                       = ERROR_CODE_PREFIX
                                                                             + "0104";

    // 调拨不存在
    public static final String  ALLOT_NOT_FOUND                            = ERROR_CODE_PREFIX
                                                                             + "0105";

    // 调拨更新失败
    public static final String  UPDATE_ALLOT_FAILED                        = ERROR_CODE_PREFIX
                                                                             + "0106";

    // 释放占用库存失败
    public static final String  RELEASE_OCCUPATION_FAILED                  = ERROR_CODE_PREFIX
                                                                             + "0107";

    // 不符合波次启动规则
    public static final String  INVALID_CONNECT_START = ERROR_CODE_PREFIX + "0201";

    //任务已领取
    public static final String TASK_ASSIGNED = ERROR_CODE_PREFIX+"0110";

    //调拨存在待收货的sku
    public static final String ALT_SKU_RECEIVEING = ERROR_CODE_PREFIX+"0202";

    //需要确认
    public static final String CONDITION_NEED_CHECK = ERROR_CODE_PREFIX+"0220";

    public static final String SPECIAL_ALERT_CODE = ERROR_CODE_PREFIX+"0300";

    //重复消费
    public static final String REPEATED_CONSUMPTION= ERROR_CODE_PREFIX+"0401";




}