package com.thebeastshop.pegasus.service.warehouse.enums;

/**
 * @author xw
 * @create 2019-04-03 15:08
 */
public enum WhWmsMoveStorehouseStatusEnum {

    is_binding(1, "已绑定"),
    truck_loaded(2, "已装车"),
    in_storged(3, "已入库");

    private Integer value;
    private String desc;

    WhWmsMoveStorehouseStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static WhWmsMoveStorehouseStatusEnum getEnumByValue(Integer value) {
        for (WhWmsMoveStorehouseStatusEnum e : WhWmsMoveStorehouseStatusEnum.values()) {
            if (e.getValue().equals(value)) {
                return e;
            }
        }
        return null;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByValue(Integer value) {
        WhWmsMoveStorehouseStatusEnum storehouseEnum = getEnumByValue(value);
        if (storehouseEnum != null){
            return storehouseEnum.desc;
        }
        return "";
    }
}
