package com.thebeastshop.pegasus.service.warehouse.enums;

import java.util.*;

public enum WhBondedWarehouseAllotApplyStatusEnum {

  INITIAL(0, "初始"),
  WAIT_APPROVE(1, "待审批"),
  WAIT_BUYER_CONFIRM(2, "待买手确认"),
  WAIT_HK_WAREHOUSE_DELIVERY(3, "待港仓发货"),
  WAIT_ALLOT(4, "调拨待入库"),
  ALLOT_FIHISHED(5, "调拨完成"),
  CANCEL(6, "取消"),
  REJECT(7, "驳回");


  public final static List<WhBondedWarehouseAllotApplyStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(WhBondedWarehouseAllotApplyStatusEnum.values()));

  public final static Map<Integer, String> mapAll() {
    Map<Integer, String> map = new HashMap<Integer, String>();
    for (WhBondedWarehouseAllotApplyStatusEnum statusEnum : values()) {
      map.put(statusEnum.status, statusEnum.statusDesc);
    }
    return map;
  }

  public final static List<Map<String, Object>> listMapAll() {
    List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
    for (WhBondedWarehouseAllotApplyStatusEnum statusEnum : values()) {
      Map<String, Object> map = new HashMap<String, Object>();
      map.put("status", statusEnum.status);
      map.put("statusDesc", statusEnum.statusDesc);
      listMap.add(map);
    }
    return listMap;
  }

  private Integer status;

  private String statusDesc;

  WhBondedWarehouseAllotApplyStatusEnum(Integer status, String statusDesc) {
    this.status = status;
    this.statusDesc = statusDesc;
  }

  public final static String getStatusDesc(short status) {
    return mapAll().get(status);
  }

  public Integer getStatus() {
    return status;
  }

  public String getStatusDesc() {
    return statusDesc;
  }
}
