package com.thebeastshop.pegasus.service.warehouse.enums;

import com.thebeastshop.pegasus.util.enums.EcpPushErrorTypeEnum;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum WhAutoAllotStatusEnum {

  TO_BE_CONFIRMED(0, "待确认"),
  COMPLETED(1, "已完成"),
  CANCLE(-1, "取消");

  private int val;
  private String desc;

  WhAutoAllotStatusEnum(int val, String desc) {
    this.val= val;
    this.desc = desc;
  }

  public static final List<WhAutoAllotStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(WhAutoAllotStatusEnum.values()));

  public static String getDesc(int status) {
    for (WhAutoAllotStatusEnum allotStatusEnum : WhAutoAllotStatusEnum.values()) {
      if (status == allotStatusEnum.val){
        return allotStatusEnum.desc;
      }
    }
    return "";
  }

  public int getVal() {
    return val;
  }

  public String getDesc() {
    return desc;
  }
}
