package com.thebeastshop.pegasus.service.warehouse.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum WhAutoAllotDifferenceEnum {

  NO_DIFFERENCE(0, "正常"),
  IS_JIT(1, "来单制作"),
  CROSS_BORDER(2, "跨境商品"),
  EXCLUDE_CATEGORY(3, "指定类目"),
  PRESALE_NOT_COMPLETE_ALLOT(4, "预售未分货完成"),
  LOW_STOCK(5, "库存不足"),
  PRESALE_NOT_SHIPPED(6, "预售未发货"),
  THIRDPARTY__GOODS_ERROR(7, "第三方商品异常");

  private int val;
  private String desc;

  WhAutoAllotDifferenceEnum(int val, String desc) {
    this.val= val;
    this.desc = desc;
  }

  public static final List<WhAutoAllotDifferenceEnum> ALL = Collections.unmodifiableList(Arrays.asList(
    WhAutoAllotDifferenceEnum.values()));

  public static String getDesc(int status) {
    for (WhAutoAllotDifferenceEnum allotStatusEnum : WhAutoAllotDifferenceEnum.values()) {
      if (status == allotStatusEnum.val){
        return allotStatusEnum.desc;
      }
    }
    return "";
  }

  public int getVal() {
    return val;
  }

  public String getDesc() {
    return desc;
  }
}
