package com.thebeastshop.pegasus.service.warehouse.enums;

import java.util.Arrays;
import java.util.List;

/**
 *调拨类型
 */

public enum WhAllotTypeEnum {

  TYPE_NORMAL(1, "正常"), // 正常
  TYPE_DAMAGED(2, "残次"),  // 残次
  TYPE_WASTED(3, "报废"),  // 报废
  TYPE_FIXED(4, "修复"),  // 修复
  TYPE_CONSUMABLE(5, "耗材调拨"),// 耗材调拨
  TYPE_SELL_ORDER(6, "销售订单"),// 销售定单
  TYPE_BETWEEN_CHANNELS(7, "渠道间调货"), // 渠道间调货
  TYPE_GIFT(8, "礼品"),  // 礼品
  TYPE_SAMPLE(9, "样品"),  // 样品
  TYPE_CUSTOMIZE_OUT(10, "定制商品调拨（出）"),  // 定制商品调拨(出)
  TYPE_CUSTOMIZE_IN(11, "定制商品调拨（入）"),  // 定制商品调拨(入)
  AUTO_TRANSFER_ALLOT(12, "来单制作自动调拨"),// 来单制作自动调拨
  AUTO_ALLOT(13, "自动分货调拨"),
  AUTO_ALLOT_ONLINE(14, "自动分货-线上"),
  STORE_ALLOT_APPLICATION(15, "门店调拨申请"),
  TYPE_CROSS_BORDER_ALLOT(16, "海淘调拨");

  private int val;
  private String desc;

  public static List<WhAllotTypeEnum> ALL = Arrays.asList(WhAllotTypeEnum.values());

  public static String getDesc(int val) {
    for (WhAllotTypeEnum whAllotTypeEnum : ALL) {
      if (val == whAllotTypeEnum.val) {
        return whAllotTypeEnum.desc;
      }
    }
    return "未知类型";
  }

  WhAllotTypeEnum(int val, String desc) {
    this.val = val;
    this.desc = desc;
  }

  public int getVal() {
    return val;
  }

  public String getDesc() {
    return desc;
  }

}
