package com.thebeastshop.pegasus.service.warehouse.enums;

import org.aspectj.apache.bcel.generic.GETSTATIC;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum WhAllotStoreApplicationStatusEnum {

  CANCEL((short) -1, "取消"),
  REJECT((short) 0, "审批驳回"),
  APPROVAL((short) 1, "审批中"),
  APPROVED((short) 2, "审批通过");


  public final static List<WhAllotStoreApplicationStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(WhAllotStoreApplicationStatusEnum.values()));

  public final static Map<Short, String> mapAll() {
    Map<Short, String> map = new HashMap<Short, String>();
    for (WhAllotStoreApplicationStatusEnum statusEnum : values()) {
      map.put(statusEnum.status, statusEnum.statusDesc);
    }
    return map;
  }

  public final static List<Map<String, Object>> listMapAll() {
    List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
    for (WhAllotStoreApplicationStatusEnum statusEnum : values()) {
      Map<String, Object> map = new HashMap<String, Object>();
      map.put("status", statusEnum.status);
      map.put("statusDesc", statusEnum.statusDesc);
      listMap.add(map);
    }
    return listMap;
  }

  private short status;

  private String statusDesc;

  WhAllotStoreApplicationStatusEnum(short status, String statusDesc) {
    this.status = status;
    this.statusDesc = statusDesc;
  }

  public final static String getStatusDesc(short status) {
    return mapAll().get(status);
  }

  public short getStatus() {
    return status;
  }

  public String getStatusDesc() {
    return statusDesc;
  }
}
