package com.thebeastshop.pegasus.service.warehouse.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum  WhAllotStoreApplicationRejectTypeEnum {

  STOCK_NOT_ENOUGH((short) 1, "库存不足"),
  OHTER_CHANNELS_HAVEBEEN_BOOKED((short) 2, "其它渠道已预定"),
  PRODUCTION_SCHEDULING((short) 3, "有生产任务安排"),
  RETURN_TO_SUPPLIER((short) 4 , "退回供应商"),
  OTHERS((short) 5, "其它");


  public final static List<WhAllotStoreApplicationRejectTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(WhAllotStoreApplicationRejectTypeEnum.values()));

  public final static Map<Short, String> mapAll() {
    Map<Short, String> map = new HashMap<Short, String>();
    for (WhAllotStoreApplicationRejectTypeEnum statusEnum : values()) {
      map.put(statusEnum.type, statusEnum.typeDesc);
    }
    return map;
  }

  public final static List<Map<String, Object>> listMapAll() {
    List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
    for (WhAllotStoreApplicationRejectTypeEnum statusEnum : values()) {
      Map<String, Object> map = new HashMap<String, Object>();
      map.put("type", statusEnum.type);
      map.put("typeDesc", statusEnum.typeDesc);
      listMap.add(map);
    }
    return listMap;
  }


  public final static String getRejectTypeDesc(short rejectType) {
    for (WhAllotStoreApplicationRejectTypeEnum rejectTypeEnum : WhAllotStoreApplicationRejectTypeEnum.values()) {
      if (rejectType == rejectTypeEnum.type) {
        return rejectTypeEnum.typeDesc;
      }
    }
    return "";
  }
  private short type;

  private String typeDesc;

  WhAllotStoreApplicationRejectTypeEnum(short type, String typeDesc) {
    this.type = type;
    this.typeDesc = typeDesc;
  }

  public short getType() {
    return type;
  }

  public String getTypeDesc() {
    return typeDesc;
  }
}
