package com.thebeastshop.pegasus.service.warehouse.enums;

/**
 * 仓库商品状态
 */
public enum WarehouseCommodityStatusEnum {

  LIGHT_RESIDUE(0, "轻残"),
  MIDDLE_RESIDUE(4, "中残"),
  HEAVY_RESIDUE(5, "重残"),
  GOOD(1, "良品"),
  SAMPLE(2, "样品"),
  WASTER(3, "废品"),
  DISPLAY(6, "陈列品");

  private Integer key;

  private String desc;

  WarehouseCommodityStatusEnum(Integer key, String desc) {
    this.key = key;
    this.desc = desc;
  }

  public static String getDesc(int status) {
      for (WarehouseCommodityStatusEnum commodityStatusEnum : WarehouseCommodityStatusEnum.values()) {
          if (status == commodityStatusEnum.key){
              return commodityStatusEnum.desc;
          }
      }
      return "";
  }

  public Integer getKey() {
    return key;
  }

  public String getDesc() {
    return desc;
  }
}
