package com.thebeastshop.pegasus.service.warehouse.dao;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrderSubmitKeys;
import com.thebeastshop.pegasus.service.warehouse.cond.OffSpotGoodsCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhCommandCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondAlt;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondPcsRtn;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondRecWaste;
import com.thebeastshop.pegasus.service.warehouse.model.OffSpotGood;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandExample;
import com.thebeastshop.pegasus.service.warehouse.model.WmsPurchaseReturn;
import com.thebeastshop.pegasus.service.warehouse.model.WmsPurchaseReturnSku;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandAssoExpressVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPackageInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReceiveShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhSkuInvQttVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseInvQttVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitOutStockVO;

@Repository
public interface WhCommandMapper {
    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_wh_command
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    int countByExample(WhCommandExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_wh_command
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    int deleteByExample(WhCommandExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_wh_command
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    int deleteByPrimaryKey(Long id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_wh_command
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    int insert(WhCommand record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_wh_command
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    int insertSelective(WhCommand record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_wh_command
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    List<WhCommand> selectByExample(WhCommandExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_wh_command
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    WhCommand selectByPrimaryKey(Long id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_wh_command
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    int updateByExampleSelective(@Param("record") WhCommand record, @Param("example") WhCommandExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_wh_command
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    int updateByExample(@Param("record") WhCommand record, @Param("example") WhCommandExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_wh_command
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    int updateByPrimaryKeySelective(WhCommand record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table t_wh_command
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    int updateByPrimaryKey(WhCommand record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database  t_op_sales_order  and  t_scm_operator
     *
     * @mbggenerated Fri Aug 14 15:46:21 CST 2015
     */
    String findSalesOrderAddressByCond(@Param(value = "cond")String cond);

    Integer findSalesOrderTypeByCond(@Param(value = "cond")String cond);

    // self
    List<WhCommand> findCommandByCond(WhCommandCond cond);

    List<WhCommand> findNewCommandByCond(WhCommandCond cond);

    List<OffSpotGood> findOffSpotGoodsListByCond(OffSpotGoodsCond cond);

    List<OffSpotGood> findDetailOnTheWayOffSpotGoodsList(@Param("skuCode") String skuCode);

    List<OffSpotGood> findDetailOffSpotGoodsList(@Param("skuCode") String skuCode);

    List<WhCommand> findUnDeliveryGoodsAndNoSendMailByCond(WhCommandCond cond);

    List<WhSkuInvQttVO> findWillInQttByWarehouseCode(@Param("warehouseCode") String warehouseCode);

    List<WhSkuInvQttVO> findAllotWillInQttByWarehouseCode(@Param("warehouseCode") String warehouseCode);

    List<WhSkuInvQttVO> findAllotWillInQttBySkuCode(@Param("skuCode") String skuCode);

    List<WhWarehouseInvQttVO> findWillInQttBySkuCode(@Param("skuCode") String skuCode);
    
    List<WhWarehouseInvQttVO> findNewWillInQttBySkuCode(@Param("skuCode") String skuCode);

    List<WhWarehouseInvQttVO> findAutoAllotWillInQttBySkuCode(@Param("skuCodes") List<String> skuCodes, @Param("warehouseCodes") List<String> warehouseCodes);

    List<WhWmsWaitOutStockVO> findWaitOutStockCommandByCond(WhWmsWaitOutStockCond cond);

    List<WhWmsWaitOutStockVO> findWaitOutStockCommandSaleOutByCond(WhWmsWaitOutStockCond cond);
    
    List<WhWmsWaitOutStockVO> findWaitOutStockCommandAltByCond(WhWmsWaitOutStockCondAlt cond);

    List<WhWmsWaitOutStockVO> findWaitOutStockCommandPcsRtnByCond(WhWmsWaitOutStockCondPcsRtn cond);

    List<WhWmsWaitOutStockVO> findWaitOutStockCommandRecWasteByCond(WhWmsWaitOutStockCondRecWaste cond);

    List<WhWmsWaitOutStockVO> listReceiveOrderByCond(@Param("cond")WhWmsWaitOutStockCondRecWaste cond);

    int countWaitOutStockCommandRecWasteByCond(WhWmsWaitOutStockCondRecWaste cond);
    /**
     * 单品单件top5 sku
     * */
    List<WhSkuInfoVO> findWaitOutStockCommandSkuByCond(WhWmsWaitOutStockCond cond);

    List<WhReceiveShelvesVO> findReceiveShelvesByCond(@Param("cond")WhReceiveShelvesVO cond);

    List<Long> findCommandIdsReceiveShelvesByCond(@Param("cond")WhReceiveShelvesVO cond);

    List<WhReceiveShelvesVO> findWaitClosePopCommandByCond(@Param("cond")WhReceiveShelvesVO cond);

    List<WhReceiveShelvesVO> findReceiveShelvesDetail(@Param("whInType")Integer whInType,@Param("whCommandId")Integer whCommandId);
    
    List<WhCommandAssoExpressVO> findCommandAssoExpressInfoByPackageCode(@Param("cond")WhCommandAssoExpressVO cond);

    int existExpressCode(@Param("expressCode") String expressCode,@Param("packageDeliveryId") Long packageDeliveryId);
    
    int packageAssoExpress(@Param("packageId")Long packageId,@Param("expressCode") String expressCode);
    
    int packageAssoExpressWithExpressType(@Param("vo")WhCommandAssoExpressVO vo);

    // 修改发货单快递方式
    int dispatchAssoExpressWithExpressType(@Param("vo")WhCommandAssoExpressVO vo);

    //采退关联快递单
    int purchaseReturnAssoExpress(@Param("vo")WhCommandAssoExpressVO vo);

    int packageAssoExpressSF(@Param("pi")PackageInfo pi);

    int dispatchBillAssoExpressSF(@Param("pi")PackageInfo pi);

    int packageAssoExpressZT(@Param("zt")ZTOrderSubmitKeys zt);
    int packageAssoExpressCommand(@Param("pi")PackageInfo pi);
    int packageAssoExpressDispatchBill(@Param("pi")PackageInfo pi);
    int packageAssoExpressCommandZT(@Param("zt")ZTOrderSubmitKeys zt);
    int packageAssoExpressDispatchBillZT(@Param("zt")ZTOrderSubmitKeys zt);
    int packageAssoExpressFED(@Param("pi")PackageInfo pi);

    int packageAssoTms(@Param("pi")PackageInfo pi);

    int packageAssoExpressExFresh(@Param("pi")PackageInfo pi);

    List<WhWmsCommandInfoVO> findCommandInfoByCond(@Param("cond")WhWmsCommandInfoCond cond);
    
    List<WhWmsCommandInfoVO> findNewCommandInfoByCond(@Param("cond")WhWmsCommandInfoCond cond);

    Integer countFindByCond(@Param("cond") WhWmsCommandInfoCond cond);

    List<WhWmsCommandSkuVO> findCommandSkuInfoByCond(@Param("commandIds")Set<Long> commandIds);
    
    Map<String,Object> countCommandInfoByCond(@Param("cond")WhWmsCommandInfoCond cond);
    
	WhWmsConnectInfoVO findWhWmsConnectInfoVOByCommandCode(@Param("commandCode")String commandCode);
    
    List<Map<String, Object>> findAdditionalInfosByCond(@Param("cond")WhWmsCommandInfoCond cond);
    
    int commandWithPackageExpress();
    
    int updatePurchaseOrderByPlanCode(@Param("planCode") String planCode);
    
    /**
     * 统计指令数
     * @return inoutype,commandstatus,count
     * */
    public List<WhCommandCountVO> getCommandOutCountByCond(@Param("cond")WhCommandCond cond);
    
    /**
     * 统计指令数
     * @return name,count
     * */
    public List<WhCommandCountVO> getSaleOutCommandCountByCond(@Param("cond")WhCommandCond cond);
    
    /**
     * 统计指令数
     * @return name,count
     * */
    public List<WhCommandCountVO> getAltOutCommandCountByCond(@Param("cond")WhCommandCond cond);
    
    /**
     * 统计指令数
     * @return name,count
     * */
    public List<WhCommandCountVO> getChangeOutCommandCountByCond(@Param("cond")WhCommandCond cond);

    /**
     * 统计指令数
     * @return name,count
     * */
    public List<WhCommandCountVO> getPurchaseRtnOutCommandCountByCond(@Param("cond")WhCommandCond cond);

    public WmsPurchaseReturn getPurchaseReturnByCode(String code);

    public int updatePurchaseRtn(WmsPurchaseReturn vo);

    public List<WmsPurchaseReturnSku> getPurchaseReturnSku(Long pcsRtnId);

    public int updatePurchaseRtnSku(WmsPurchaseReturnSku item);

    public Long getSupplierIdByPurchaseReturnCode(String purchaseReturnCode);

    public String getOriPhyCodeByPurchaseReturnCode(String purchaseReturnCode);

    Integer findCountReceiveShelvesByCond(@Param("cond")WhReceiveShelvesVO cond);

    Integer updatePackageStatusToOut(@Param("packageCode") String packageCode);

    Integer updatePackageStatusToAlreadyReceive(@Param("packageCode") String packageCode);


    public List<WhPackageInfoVO> findCHN2053PackageInfo();

    int updateCommandStatus(@Param("id") Long id,@Param("oldStatus") Integer oldStatus,@Param("status") Integer status);

    int batchUpdateCommandStatus(@Param("codes") List<String> codes,@Param("newStatus") Integer newStatus,@Param("oldStatus") Integer oldStatus);

    int updateCommandForHandover(@Param("cmd") WhCommand cmd);

    int batchUpdateCommandStatusAndFailure(@Param("codes") List<String> codes,@Param("newStatus") Integer newStatus);

    public List<WhCommand> findCommandByConnectIdAndBarCode(@Param("barCode")String barCode,@Param("connectId") Long connectId);

    int failureStartConnect(@Param("commandCodes")List<String> commandCodes);

    public Integer autoCloseCommandInEndMonth();

    List<String> findPackageSkuCodeByPackageCode(String warehouseCode);

    List<Map> selectReferenceCodesByCommdCodes(@Param("commdCodeList") List<String> commdCodeList);

    List<WhReleaseOccupationVO> findPackageOccupyReleaseByPackageCode(@Param("packageCode")String packageCode);

    int updatePlanedDyDateByReCodes(List<WhCommand> whCommandList);
}
