package com.thebeastshop.pegasus.service.warehouse.cond;

import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishInfoVO;
import com.thebeastshop.pegasus.util.cond.BaseQueryCond;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xw
 * @create 2018-08-14 16:19
 */
public class WhWmsReplenishInfoCond extends BaseQueryCond implements Serializable {

    private Long id;
    private List<Long> ids;

    private Integer replenishStates;

    private List<Integer> replenishStatesList;

    private String skuCode;

    private List<String> skuCodes;

    private String shelvesCode;
    private String shelvesCodeLike;

    private String houseType;

    private String physicalWarehouseCode;

    private Date createTimeStart;

    private Date createTimeEnd;

    private Long createUserId;

    private String refCode;

    private Integer refType;

    private boolean fetchSkuStock;

    private boolean sourceConnectStart;

    private boolean autoReplenish = false;

    public WhWmsReplenishInfoCond() {
    }

    public WhWmsReplenishInfoCond(String physicalWarehouseCode, String skuCode, String shelvesCode, Integer replenishStates) {
        this.physicalWarehouseCode = physicalWarehouseCode;
        this.skuCode = skuCode;
        this.shelvesCode = shelvesCode;
        this.replenishStates = replenishStates;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public Integer getReplenishStates() {
        return replenishStates;
    }

    public void setReplenishStates(Integer replenishStates) {
        this.replenishStates = replenishStates;
    }

    public List<Integer> getReplenishStatesList() {
        return replenishStatesList;
    }

    public void setReplenishStatesList(List<Integer> replenishStatesList) {
        this.replenishStatesList = replenishStatesList;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public String getShelvesCode() {
        return shelvesCode;
    }

    public void setShelvesCode(String shelvesCode) {
        this.shelvesCode = shelvesCode;
    }

    public String getShelvesCodeLike() {
        return shelvesCodeLike;
    }

    public void setShelvesCodeLike(String shelvesCodeLike) {
        this.shelvesCodeLike = shelvesCodeLike;
    }

    public String getHouseType() {
        return houseType;
    }

    public void setHouseType(String houseType) {
        this.houseType = houseType;
    }

    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    public Date getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(Date createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public Date getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(Date createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getRefCode() {
        return refCode;
    }

    public void setRefCode(String refCode) {
        this.refCode = refCode;
    }

    public Integer getRefType() {
        return refType;
    }

    public void setRefType(Integer refType) {
        this.refType = refType;
    }

    public boolean isFetchSkuStock() {
        return fetchSkuStock;
    }

    public void setFetchSkuStock(boolean fetchSkuStock) {
        this.fetchSkuStock = fetchSkuStock;
    }

    public boolean isSourceConnectStart() {
        return sourceConnectStart;
    }

    public void setSourceConnectStart(boolean sourceConnectStart) {
        this.sourceConnectStart = sourceConnectStart;
    }

    public boolean isAutoReplenish() {
        return autoReplenish;
    }

    public void setAutoReplenish(boolean autoReplenish) {
        this.autoReplenish = autoReplenish;
    }

    @Override
    public String toString() {
        return "WhWmsReplenishInfoCond{" +
                "physicalWarehouseCode='" + physicalWarehouseCode + '\'' +
                ", shelvesCode='" + shelvesCode + '\'' +
                ", skuCode='" + skuCode + '\'' +
                ", replenishStates=" + replenishStates +
                '}';
    }

    public String toCustomString() {
        return "[" +
                "物理仓='" + physicalWarehouseCode + '\'' +
                ", 拣货库位='" + shelvesCode + '\'' +
                ", SKU='" + skuCode + '\'' +
                ", 状态=" + WhWmsReplenishInfoVO.REPLENISH_STATE_MAP.get(replenishStates) +
                ']';
    }
}
