/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.cond;

import java.util.List;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import com.thebeastshop.pegasus.util.cond.BaseQueryCond;

/**
 * @author Royan
 * @version $Id: WhWarehouseCond.java, v 0.1 2015-08-03 下午4:01
 */
public class WhWarehouseCond extends BaseQueryCond {

    private String  physicalWarehouseCode;

    private Long  physicalWarehouseId;

    private String  code;

    private String  name;

    private Integer warehouseStatus;

    private Integer warehouseType;

    private List<String>  codeList;

    private List<Integer>  warehouseTypeList;

    private Integer physicalWarehouseType;				// 物理仓类型

    private List<Integer> physicalWarehouseTypeList;	// 物理仓类型

    // 商品状态
    private Integer commodityStatus;

    private Integer sort;

    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    public Long getPhysicalWarehouseId() {
        return physicalWarehouseId;
    }

    public void setPhysicalWarehouseId(Long physicalWarehouseId) {
        this.physicalWarehouseId = physicalWarehouseId;
    }

    public String getCode() {
        return EmptyUtil.isEmpty(code) ? code : SQLUtils.allLike(code);
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return EmptyUtil.isEmpty(name) ? name : SQLUtils.allLike(name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getWarehouseStatus() {
        return warehouseStatus;
    }

    public void setWarehouseStatus(Integer warehouseStatus) {
        this.warehouseStatus = warehouseStatus;
    }

    public Integer getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(Integer warehouseType) {
        this.warehouseType = warehouseType;
    }

	public List<String> getCodeList() {
		return codeList;
	}

	public void setCodeList(List<String> codeList) {
		this.codeList = codeList;
	}

	public List<Integer> getWarehouseTypeList() {
		return warehouseTypeList;
	}

	public void setWarehouseTypeList(List<Integer> warehouseTypeList) {
		this.warehouseTypeList = warehouseTypeList;
	}

	public Integer getPhysicalWarehouseType() {
		return physicalWarehouseType;
	}

	public void setPhysicalWarehouseType(Integer physicalWarehouseType) {
		this.physicalWarehouseType = physicalWarehouseType;
	}

    public Integer getCommodityStatus() {
        return commodityStatus;
    }

    public void setCommodityStatus(Integer commodityStatus) {
        this.commodityStatus = commodityStatus;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public List<Integer> getPhysicalWarehouseTypeList() {
		return physicalWarehouseTypeList;
	}

	public void setPhysicalWarehouseTypeList(List<Integer> physicalWarehouseTypeList) {
		this.physicalWarehouseTypeList = physicalWarehouseTypeList;
	}
}