/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse;

import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;

import java.util.*;

/**
 * @author Eric.Lou
 * @version $Id: WMSConstants.java, v 0.1 2016-03-21 下午3:58
 * @description wms枚举
 */
public class WMSConstants {

    /**
     * 波次类型
     * t_wh_wms_connect_info
     */
    public static class ConnectType{
        public final static String SINGLE_PRODUCT_SINGLE_PIECE = "single_product_single_piece";//单品单件
        public final static String MULTI_PRODUCT_SINGLE_PIECE = "multi_product_single_piece";//多品单件
        public final static String MULTI_PIECE_ACTIVITY= "multi_piece_activity";//多件活动
        public final static String BULK_ORDER = "bulk_order";//大宗订单
        public final static String LARGE_SIZED_PACKAGE = "large_sized_package";//大件包裹
        public final static String MULTI_PRODUCT_MULTI_PIECE = "multi_product_multi_piece";//多品多件
        public final static String RECEIVE_WASTE = "receive_waste";//报废出库
        public final static List<String> ALL = Arrays.asList(
                new String[]{MULTI_PRODUCT_MULTI_PIECE, MULTI_PRODUCT_SINGLE_PIECE,SINGLE_PRODUCT_SINGLE_PIECE,MULTI_PIECE_ACTIVITY,BULK_ORDER,LARGE_SIZED_PACKAGE,RECEIVE_WASTE});
        public final static List<Map<String, String>> ALLCN = new ArrayList<>();
        public final static List<Map<String, String>> ALLCN_MANUAL = new ArrayList<>();//可手动启动
        static {
            Map<String, String> option;
            option = new HashMap<String, String>();
            option.put("text", "多品多件");
            option.put("value", MULTI_PRODUCT_MULTI_PIECE.toString());
            ALLCN.add(option);
            ALLCN_MANUAL.add(option);//可手动启动

            option = new HashMap<String, String>();
            option.put("text", "多品单件");
            option.put("value", MULTI_PRODUCT_SINGLE_PIECE.toString());
            ALLCN.add(option);
            ALLCN_MANUAL.add(option);//可手动启动

            option = new HashMap<String, String>();
            option.put("text", "单品单件");
            option.put("value", SINGLE_PRODUCT_SINGLE_PIECE.toString());
            ALLCN.add(option);
            ALLCN_MANUAL.add(option);//可手动启动

            option = new HashMap<String, String>();
            option.put("text", "多件活动");
            option.put("value", MULTI_PIECE_ACTIVITY);
            ALLCN.add(option);

            option = new HashMap<String, String>();
            option.put("text", "大宗订单");
            option.put("value", BULK_ORDER);
            ALLCN.add(option);

            option = new HashMap<String, String>();
            option.put("text", "大件包裹");
            option.put("value", LARGE_SIZED_PACKAGE);
            ALLCN.add(option);

            option = new HashMap<String, String>();
            option.put("text", "报废出库");
            option.put("value", RECEIVE_WASTE);
            ALLCN.add(option);

        }
    }

    /**
     * 波次状态
     * t_wh_wms_connect_info
     */
    public static class ConnectStatus{
        public final static Integer CANCELED = -1;//已取消
        public final static Integer WAITING_PROCESS = 0;//待拣货
        public final static Integer PROCESSING = 1;//拣货中
        public final static Integer DISTRIBUTION = 2;//分拨中
        public final static Integer FINISHED = 9;//已完成
        public final static Integer WAITING_PACK = 3;//待打包
        public final static List<Integer> ALL = Arrays.asList(
                new Integer[]{WAITING_PROCESS , PROCESSING , DISTRIBUTION ,WAITING_PACK, FINISHED,CANCELED});
        public final static List<Map<String, String>> ALLCN = new ArrayList<>();
        static {
            Map<String, String> option;
            option = new HashMap<String, String>();
            option.put("text", "待拣货");
            option.put("value", WAITING_PROCESS.toString());
            ALLCN.add(option);
            option = new HashMap<String, String>();
            option.put("text", "拣货中");
            option.put("value", PROCESSING.toString());
            ALLCN.add(option);
            option = new HashMap<String, String>();
            option.put("text", "分拨中");
            option.put("value", DISTRIBUTION.toString());
            ALLCN.add(option);
            option = new HashMap<String, String>();
            option.put("text", "待打包");
            option.put("value", WAITING_PACK.toString());
            ALLCN.add(option);
            option = new HashMap<String, String>();
            option.put("text", "已完成");
            option.put("value", FINISHED.toString());
            option = new HashMap<String, String>();
            option.put("text", "已取消");
            option.put("value", CANCELED.toString());
            ALLCN.add(option);
        }

    }

    public static class ExpressType{
        // 快递类型 1店送2联邦3顺丰空运4顺丰陆运5圆通6德邦7顺丰(海淘)8自送9中通10安鲜达
        public static final Integer SHOP = 1;
        public static final Integer FEDEX = 2;
        public static final Integer SF_AIR = 3;
        public static final Integer SF_LAND = 4;
        public static final Integer SF_COLD_CHAIN = 12;//顺丰冷链
        public static final Integer YTO = 5;
        public static final Integer DEPPON = 6;
        public static final Integer SELF = 8;
        public static final Integer ZT = 9;
        public static final Integer EXFRESH = 10;
        public static final Integer DEFAULT = SELF;
        public final static List<Map<String, String>> ALLCN = new ArrayList<>();
        static {
            Map<String, String> option;
            option = new HashMap<String, String>();
            option.put("text", "店送");
            option.put("value", SHOP.toString());
            ALLCN.add(option);
            option = new HashMap<String, String>();
            option.put("text", "联邦");
            option.put("value", FEDEX.toString());
            ALLCN.add(option);
            option = new HashMap<String, String>();
            option.put("text", "顺丰(空运)");
            option.put("value", SF_AIR.toString());
            ALLCN.add(option);
            option = new HashMap<String, String>();
            option.put("text", "顺丰(陆运)");
            option.put("value", SF_LAND.toString());
            ALLCN.add(option);
            option = new HashMap<String, String>();
            option.put("text", "顺丰(冷链)");
            option.put("value", SF_COLD_CHAIN.toString());
            ALLCN.add(option);
            option = new HashMap<String, String>();
            option.put("text", "圆通");
            option.put("value", YTO.toString());
            ALLCN.add(option);
            option = new HashMap<String, String>();
            option.put("text", "德邦");
            option.put("value", DEPPON.toString());
            ALLCN.add(option);
            option = new HashMap<String, String>();
            option.put("text", "自送");
            option.put("value", SELF.toString());
            option = new HashMap<String, String>();
            option.put("text","安鲜达");
            option.put("value", EXFRESH.toString());
            ALLCN.add(option);
        }
    }

    /*
    *待上架表t_wh_wms_wait_putaway 逻辑删除标志 0有效 1无效
    */
    public static final Integer WMS_WAIT_PUTAWAY_FLAG_VALID = 0;
    public static final Integer WMS_WAIT_PUTAWAY_FLAG_INVALID= 1;


    /*
    *WMS占用表t_wh_wms_occupy 占用状态 0释放 1占用
    */
    public static final Integer WMS_OCCUPY_STATUS_RELEASED = 0;
    public static final Integer WMS_OCCUPY_STATUS_IN_USE= 1;


    /*
     *入库单收货质检状态 11 待收货 12待质检 13质检中 14收货完成
     */
    public static final Integer WMS_WAREHOUSING_ENTRY_STATUS_BEFORE_RECEIVE = 11;
    public static final Integer WMS_WAREHOUSING_ENTRY_STATUS_BEFORE_QC = 12;
    public static final Integer WMS_WAREHOUSING_ENTRY_STATUS_IN_QC = 13;
//    public static final Integer WMS_WAREHOUSING_ENTRY_RECEIVE_FINISH = 14;
    public final static Map<Integer, String> WMS_WAREHOUSING_ENTRY_STATUS_MAP = new HashMap(){{
        put(WhCommand.STATUS_IN_PROCESSING,"待收货");
        put(WhCommand.STATUS_WAITING_QUALITY_CONTROL,"待质检");
        put(WhCommand.STATUS_QUALITY_PROCESSING,"质检中");
        put(WhCommand.STATUS_QUALITY_FINISHED,"收货完成");
        put(WhCommand.STATUS_FINISHED,"已关闭");
    }};

}
