/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrder;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrderSubmitResponse;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSimpleVO;
import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;
import com.thebeastshop.pegasus.web.util.ecp.EcpDeliveryReceipt;
import com.thebeastshop.pegasus.web.util.ecp.EcpUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.task.TaskExecutor;
import page.Pagination;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * @author Eric.Lou
 * @version $Id: PegasusWmsServiceFacade.java, v 0.1 2016-03-23 下午2:07
 */
public class PegasusWmsServiceFacade {

    private final static Logger log = LoggerFactory
            .getLogger(PegasusWmsServiceFacade.class);

    private static PegasusWmsServiceFacade instance;

    @Autowired
    private WhWmsConnectInfoService              whWmsConnectInfoService;

    @Autowired
    private WhWmsCommandConnectService           whWmsCommandConnectService;

    @Autowired
    private WhWmsConnectParaService              whWmsConnectParaService;

    @Autowired
    private WhWmsShelvesSkuInfoService           whWmsShelvesSkuInfoService;

    @Autowired
    private WhWmsHouseShelvesService             whWmsHouseShelvesService;

    @Autowired
    private WhWmsWarehouseAreaService            whWmsWarehouseAreaService;

    @Autowired
    private WhCommandService                     whCommandService;

    @Autowired
    private WhWmsMoveStockService                whWmsMoveStockService;

    @Autowired
    private WhWmsMoveSkuService                  whWmsMoveSkuService;

    @Autowired
    private WhWmsOccupyService                   whWmsOccupyService;

    @Autowired
    private WhWmsSkuStockService                 whWmsSkuStockService;

    @Autowired
    private WhWmsConnectPickSkuService           whWmsConnectPickSkuService;

    @Autowired
    private WhWmsWaitPutawayService              whWmsWaitPutawayService;

    @Autowired
    private WhWmsSkuBarcodeService               whWmsSkuBarcodeService;

    @Autowired
    private WhWmsConnectDistributionService      whWmsConnectDistributionService;

    @Autowired
    private WhWmsWaitPutawayTaskService          whWmsWaitPutawayTaskService;

    @Autowired
    private WhWmsCommandCheckService             whWmsCommandCheckService;

    @Autowired
    private WhWmsPrdcJobTaskService              whWmsPrdcJobTaskService;
    
    @Autowired
    private WhCommandAssociateExpressService     WhCommandAssociateExpressService;

    @Autowired
    private WhWmsReportService                   whWmsReportService;

    @Autowired
    private WhWmsCommandHandoverService          whWmsCommandHandoverService;
    
    @Autowired
	private WhWmsManualInOutService              whWmsManualInOutService;

    @Autowired
    private WhWmsPrdcJobTaskDetailService        whWmsPrdcJobTaskDetailService;

//    @Autowired
//    private WhWmsTakeStockService                whWmsTakeStockService;
//
//    @Autowired
//    private WhWmsTakeStockRcdService             whWmsTakeStockRcdService;

    @Autowired
    private WhWmsReplenishService                whWmsReplenishService;

//    @Autowired
//    private WhWmsTakeStockPlanService            whWmsTakeStockPlanService;

    @Autowired
    private WhWmsInventoryService whWmsInventoryService;

    @Autowired
    private WhWmsInventoryPlanDiffService whWmsInventoryPlanDiffService;
    
    @Autowired
    private WhWmsSkuTranslateService            whWmsSkuTranslateService;

    @Autowired
    private WhWmsTaskAssignService whWmsTaskAssignService;

    @Autowired
    private WhWmsConnectAllotPackageService whWmsConnectAllotPackageService;

    @Autowired
    private WhCommandOutCancelService whCommandOutCancelService;

    @Autowired
    private WhWmsOperationRcdService whWmsOperationRcdService;

    @Autowired
    private WhThirdPartyService whThirdPartyService;

    @Autowired
    private WhWmsConnectStartConfigService whWmsConnectStartConfigService;

    @Autowired
    private WhWmsConnectStartDurationService whWmsConnectStartDurationService;

    @Autowired
    private WhWmsConnectStartForbideRuleService whWmsConnectStartForbideRuleService;

    @Autowired
    private WhWmsConnectStartRuleService whWmsConnectStartRuleService;

    @Autowired
    private WhWmsCommandPreOccupyService whWmsCommandPreOccupyService;

    @Autowired
    private WhWmsConnectStartService whWmsConnectStartService;

    @Autowired
    private WhWmsConnectActivityRuleService whWmsConnectActivityRuleService;

    @Autowired
    private WhWmsOutStockRecordService whWmsOutStockRecordService;

    @Autowired
    private WhWmsConsumableService whWmsConsumableService;

    @Autowired
    private WhExpressWaybillService whExpressWaybillService;

    @Autowired
    private TaskExecutor myScheduler;

    @Autowired
    private RedisDistributLock redisDistributLock;

    @Autowired
    private WhWmsGradeOfQualityService whWmsGradeOfQualityService;

    @Autowired
    private WhGradeOfQualityService whGradeOfQualityService;

    @Autowired
    private WhWmsReplenishRuleService whWmsReplenishRuleService;

    @Autowired
    private WhWmsReplenishInfoService whWmsReplenishInfoService;

    @Autowired
    private WhWmsReceiveShelvesDetailService whWmsReceiveShelvesDetailService;

    @Autowired
    private WhWmsMoveWarehouseService whWmsMoveWarehouseService;

    @Autowired
    private WhWmsMoveStorehouseService whWmsMoveStorehouseService;

    private PegasusWmsServiceFacade() {

    }

    public static PegasusWmsServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }

        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                log.info("[fasade init start] PegasusWmsServiceFacade");
                new ClassPathXmlApplicationContext("pegasus-service-warehouse/spring.xml");
                log.info("[fasade init finish] PegasusWmsServiceFacade");
            }
            instance = (PegasusWmsServiceFacade) SpringUtil
                    .getBean("pegasusWmsServiceFacade");
        }
        return instance;
    }

    /**
     * 条件查询仓库SkuInfo信息
     * @param cond
     * @return
     */
    public List<WhWmsShelvesSkuInfoVO> getShelvesSkuInfoByCond(WhWmsShelvesSkuInfoCond cond){
        List<WhWmsShelvesSkuInfoVO> shelvesSkuInfoVOs = whWmsShelvesSkuInfoService.getSkuInfoByCond(cond);
        return shelvesSkuInfoVOs;
    }

    public List<WhWmsSkuPickShelves> listSkuPickShelvesByCond(WhWmsSkuPickShelvesCond cond){
        return whWmsShelvesSkuInfoService.listSkuPickShelvesByCond(cond);
    }

    public List<WhWmsSkuPickShelves> listSkuPickShelvesBySkuAndPhyCode(String skuCode,String phyCode){
        WhWmsSkuPickShelvesCond cond = new WhWmsSkuPickShelvesCond();
        if (EmptyUtil.isNotEmpty(skuCode)){
            cond.setSkuCode(skuCode);
        }
        if (EmptyUtil.isNotEmpty(phyCode)){
            cond.setPhysicalWarehouseCode(phyCode);
        }
        return listSkuPickShelvesByCond(cond);
    }

    public List<WhWmsSkuPickShelves> listSkuPickShelvesBySkuCode(String skuCode){
        return whWmsShelvesSkuInfoService.listSkuPickShelvesBySkuCode(skuCode);
    }

    public List<WhWmsSkuPickShelvesVO> listSkuPickShelvesVOBySkuCode(String skuCode){
        return whWmsShelvesSkuInfoService.listSkuPickShelvesVOBySkuCode(skuCode);
    }

    /**
     * 新增仓库WhWmsShelvesSkuInfo
     * @param skuInfo
     * @return
     */
    public Boolean newWhShelvesSkuInfo(WhWmsShelvesSkuInfo skuInfo){
        return whWmsShelvesSkuInfoService.newSkuInfo(skuInfo);
    }

    public Boolean newWhShelvesSkuInfoVO(WhWmsShelvesSkuInfoVO skuInfoVO){
        return whWmsShelvesSkuInfoService.newWhShelvesSkuInfoVO(skuInfoVO);
    }

    /**
     * 更新仓库SkuInfo
     * @param skuInfo
     * @return
     */
    public Boolean updateWhShelvesSkuInfo(WhWmsShelvesSkuInfo skuInfo){
        return whWmsShelvesSkuInfoService.updateSkuInfo(skuInfo);
    }

    public Boolean updateWhShelvesSkuInfoVO(WhWmsShelvesSkuInfoVO skuInfoVO){
        return whWmsShelvesSkuInfoService.updateWhShelvesSkuInfoVO(skuInfoVO);
    }

    public boolean saveOrUpdateWhWmsSkuPickShelves(List<WhWmsSkuPickShelves> whWmsSkuPickShelves){
        return whWmsShelvesSkuInfoService.saveOrUpdateWhWmsSkuPickShelves(whWmsSkuPickShelves);
    }

    /**
     * 根据skuCode查询仓库skuInfo
     * @param skuCode
     * @return
     */
    public WhWmsShelvesSkuInfo getShelvesSkuInfoByCode(String skuCode) {
        return whWmsShelvesSkuInfoService.getSkuInfoByCode(skuCode);
    }

    public WhWmsShelvesSkuInfoVO getShelvesSkuInfoVOBySkuCode(String skuCode,boolean fetchPickShelve) {
        return whWmsShelvesSkuInfoService.getSkuInfoVOBySkuCode(skuCode,fetchPickShelve);
    }

    /**
     * 条件查询库位信息
     * @param cond
     * @return
     */
    public List<WhWmsHouseShelvesVO> getWhHouseShelvesByCond(WhWmsHouseShelvesCond cond){
        return whWmsHouseShelvesService.getHouseShelvesByCond(cond);
    }

    /**
     * 条件获取库位信息 分页用
     * @param cond
     * @return
     */
    public Pagination<WhWmsHouseShelvesVO> getHouseShelvesByCondPage(WhWmsHouseShelvesCond cond){
        return whWmsHouseShelvesService.getHouseShelvesByCondPage(cond);
    }

    /**
     * 根据库位code查询库位信息
     * @param code
     * @return
     */
    public WhWmsHouseShelvesVO getWhHouseShelvesByCode(String code){
        return whWmsHouseShelvesService.getHouseShelvesByCode(code);
    }

    public List<WhWmsHouseShelves> getHouseShelvesByCode(List<String> codes){
        return whWmsHouseShelvesService.getHouseShelvesByCode(codes);
    }

    public Map<String,WhWmsHouseShelves> getHouseShelvesMapByCode(List<String> codes){
        return whWmsHouseShelvesService.getHouseShelvesMapByCode(codes);
    }

    /**
     * 根据库位id查询库位信息
     * @param id
     * @return
     */
    public WhWmsHouseShelvesVO getWhHouseShelvesById(Integer id) {
        return whWmsHouseShelvesService.getHouseShelvesById(id);
    }

    /**
     * 新增库位
     * @param houseShelves
     * @return
     */
    public Boolean newHouseShelves(WhWmsHouseShelves houseShelves) {
        return whWmsHouseShelvesService.newHouseShelves(houseShelves);
    }

    /**
     * 更新库位信息
     * @param houseShelves
     * @return
     */
    public Boolean updateHouseShelves(WhWmsHouseShelves houseShelves) {
        return whWmsHouseShelvesService.updateHouseShelves(houseShelves);
    }

    /**
     * 根据区域获取查询区域信息
     * @param areaType
     * @return
     */
    public WhWmsWarehouseArea getAreaByType(String areaType,String code){
        return whWmsWarehouseAreaService.getAreaByType(areaType,code);
    }

    /**
     * 获取全部区域信息
     * @return
     */
    public List<WhWmsWarehouseArea> getAllArea(){
        return whWmsWarehouseAreaService.getAllArea();
    }

    public WhWmsWarehouseArea findHouseAreaByCode(String houseCode) {
        return whWmsWarehouseAreaService.getAreaByCode(houseCode);
    }

    /**
     * 根据条件查找波次
     * @author eric
     * @param cond
     * @return
     */
    public Pagination<WhWmsConnectInfoVO> findWmsConnectByCond(WhWmsConnectInfoCond cond){
        return whWmsConnectInfoService.findByCond(cond);
    }

    /**
     * 根据条件查找待出库的仓库指令
     * @author eric
     * @param cond
     * @return
     */
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandByCond(WhWmsWaitOutStockCond cond){
        return whWmsConnectInfoService.findWaitOutStockCommandByCond(cond);
    }
    
    /**
     * 根据条件查找待出库的仓库指令-调拨
     * @param cond
     * @return
     */
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandAltByCond(WhWmsWaitOutStockCondAlt cond){
        return whWmsConnectInfoService.findWaitOutStockCommandAltByCond(cond);
    }

    /**
     * 根据条件查找待出库的仓库指令-采退
     * @param cond
     * @return
     */
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandPcsRtnByCond(WhWmsWaitOutStockCondPcsRtn cond){
        return whWmsConnectInfoService.findWaitOutStockCommandPcsRtnByCond(cond);
    }

    /**
     * 根据条件查找待出库的仓库指令
     * 单品单件 top5 sku
     * @param cond
     * @return
     */
    public List<WhSkuInfoVO> findWaitOutStockCommandSkuByCond(WhWmsWaitOutStockCond cond){
    	return whWmsConnectInfoService.findWaitOutStockCommandSkuByCond(cond);
    }


    public Pagination<WhWmsWaitOutStockVO> findWaitOutStockCommandRecWasteByCond(WhWmsWaitOutStockCondRecWaste cond){
        return whWmsConnectInfoService.findWaitOutStockCommandRecWasteByCond(cond);
    }

    /**
     * 查找波次规则参数
     * @author eric
     * @param name
     * @return
     */
    public Integer findConnectParaValueByName(String name){
        return whWmsConnectParaService.findValueByName(name);
    }

    /**
     * 启动波次
     * @author eric
     * @param vo
     * @param count
     * @return
     * @throws Exception 
     */
    public List<WhWmsConnectInfoVO> createWhWmsConnectInfo(WhWmsConnectInfoVO vo,int count) throws Exception{
        return whWmsConnectInfoService.createWhWmsConnectInfo(vo, count);
    }

    /**
     * 创建仓库出库盘点记录
     * @author eric
     * @param vo
     * @return
     * @throws Exception
     */
    /**
     * 创建仓库出库盘点记录
     * @param vo
     * @return
     * @throws Exception
     */
    public WhWmsOutStockRecord createWhWmsOutStockRecord(WhWmsOutStockRecord vo) throws Exception{
        return whWmsOutStockRecordService.createWhWmsOutStockRecord(vo);
    }

    /**
     * 启动波次
     * @param vo
     * @param count
     * @return
     * @throws Exception
     */
    public List<WhWmsConnectInfoVO> createWhWmsConnectInfoAlt(WhWmsConnectInfoVO vo,int count) throws Exception{
        return whWmsConnectInfoService.createWhWmsConnectInfoAlt(vo, count);
    }

    /**
     * 启动波次-采退
     * @param vo
     * @param count
     * @return
     * @throws Exception
     */
    public List<WhWmsConnectInfoVO> createWhWmsConnectInfoPcsRtn(WhWmsConnectInfoVO vo,int count) throws Exception{
        return whWmsConnectInfoService.createWhWmsConnectInfoPcsRtn(vo, count);
    }

    /**
     * 启动波次-报废领用
     * @param vo
     * @param count
     * @return
     * @throws Exception
     */
    public List<WhWmsConnectInfoVO> createWhWmsConnectInfoRecWaste(WhWmsConnectInfoVO vo,int count) throws Exception{
        return whWmsConnectInfoService.createWhWmsConnectInfoRecWaste(vo, count);
    }

    public boolean cancelConnect(List<Long> idList){
        return whWmsConnectInfoService.cancelConnect(idList);
    }

    public List<WhWmsConnectCountVO> connectCount(String physicalWarehouseCode){
        return whWmsConnectInfoService.connectCount(physicalWarehouseCode);
    }

    public boolean connectDistribute(WhWmsConnectDistributVO connectDistribut){
        return whWmsConnectInfoService.connectDistribute(connectDistribut);
    }

    public boolean connectDistribute(Long connectId){
        return whWmsConnectInfoService.connectDistribute(connectId);
    }


    public WhSalesReturnExceptionSkuVO findSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond){
        return whCommandService.findSalesReturnExceptionSkuByCond(cond);
    }

    public List<WhSalesReturnExceptionSkuVO> listSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond){
        return whCommandService.listSalesReturnExceptionSkuByCond(cond);
    }

    public List<WhSalesReturnExceptionSku> selectSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond){
        return whCommandService.selectSalesReturnExceptionSkuByCond(cond);
    }

    /**
     * 退货异常
     * @param cond
     */
    public WhSalesReturnExceptionVO findSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond){
        return whCommandService.findSalesReturnExceptionByCond(cond);
    }

    /**
     * 退货异常
     * @param id
     */
    public WhSalesReturnExceptionVO selectSalesReturnExceptionById(Long id) throws Exception{
        WhSalesReturnException returnException = whCommandService.selectSalesReturnExceptionById(id);
        if (EmptyUtil.isEmpty(returnException)){
            return null;
        }
        return BeanUtil.buildFrom(returnException,WhSalesReturnExceptionVO.class);
    }

    /**
     * 退货异常列表
     * @param cond
     */
    public List<WhSalesReturnExceptionVO> listSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond){
        return whCommandService.listSalesReturnExceptionByCond(cond);
    }

    /**
     * 退货异常列表
     * @param cond
     */
    public List<WhSalesReturnException> selectSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond){
        return whCommandService.selectSalesReturnExceptionByCond(cond);
    }

    // 更新时 会先删除行信息
    public boolean updateSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception{
        return whCommandService.updateSalesReturnException(vo);
    }

    // 不删除行信息，同时 根据行ID更新行信息
    public boolean updateSalesReturnExceptionById(WhSalesReturnExceptionVO vo) throws Exception{
        return whCommandService.updateSalesReturnExceptionById(vo);
    }

    public boolean updateSalesReturnExceptionSkuById(WhSalesReturnExceptionSku returnExceptionSku) throws Exception{
        return whCommandService.updateSalesReturnExceptionSkuById(returnExceptionSku);
    }

    public boolean insertSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception{
        return whCommandService.insertSalesReturnException(vo);
    }

    public boolean addOrUpdateSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception{
        if (EmptyUtil.isNotEmpty(vo.getId())){
            WhSalesReturnException salesReturnException = whCommandService.selectSalesReturnExceptionById(vo.getId());
            if (EmptyUtil.isEmpty(salesReturnException)){
                throw new WarehouseException("更新数据不存在![id]"+vo.getId());
            }
            return updateSalesReturnException(vo);
        }
        return insertSalesReturnException(vo);
    }

    public Integer findCountSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond){
        return whCommandService.findCountSalesReturnExceptionByCond(cond);
    }

    /**
     * 入库单列表
     * @param vo
     */
    public List<WhReceiveShelvesVO> findReceiveShelvesByCon(WhReceiveShelvesVO vo){
        return whCommandService.findReceiveShelvesByCon(vo);
    }

    /**
     * 查询待关闭的 pop 指令
     * @param vo
     * @return
     */
    public List<WhReceiveShelvesVO> findWaitClosePopCommandByCond(WhReceiveShelvesVO vo){
        return whCommandService.findWaitClosePopCommandByCond(vo);
    }
    /**
     * 入库单列表
     * @param vo
     */
    public Integer findCountReceiveShelvesByCon(WhReceiveShelvesVO vo){
        return whCommandService.findCountReceiveShelvesByCon(vo);
    }
    /**
     *根据id更新指令状态
     * @param id,status
     * @return
     */
    public boolean updateCommandStatusById(Integer id,Integer status){
        return whCommandService.updateCommandStatusById(id, status);
    }

    /**
     * 根据入库类型和t_wh_command_id查询入库单
     * @param whInType,whCommandId
     */
    public List<WhReceiveShelvesVO> findReceiveShelvesDetail(Integer whInType,Integer whCommandId){
        return whCommandService.findReceiveShelvesDetail(whInType, whCommandId);
    }



    /**
     * 条件查询移库任务行 分页
     * @param cond
     * @return
     */
    public Pagination<WhWmsMoveSkuVO> getMoveSkuByMoveByCondPage(WhWmsMoveSkuCond cond){
        return whWmsMoveSkuService.getMoveSkuByMoveByCondPage(cond);
    }

    /**
     * 条件查询移库任务行
     * @param cond
     * @return
     */
    public List<WhWmsMoveSkuVO> getMoveSkuByMoveByCond(WhWmsMoveSkuCond cond) {
        return whWmsMoveSkuService.getMoveSkuByMoveByCond(cond);
    }

    /**
     * 条件查询移库单
     * @param cond
     * @return
     */
    public Pagination<WhWmsMoveStockVO> getMoveStockByCond(WhWmsMoveStockCond cond) {
        return whWmsMoveStockService.getMoveStockByCond(cond);
    }

    public List<WhWmsMoveStockVO> getMoveStockByCodes(List<String> moveCodes, boolean cascade){
        return whWmsMoveStockService.getMoveStockByCodes(moveCodes,cascade);
    }

    public List<WhWmsMoveSkuVO> findMoveStockSkuRf(String moveCode) {
        return whWmsMoveStockService.findMoveStockSkuRf(moveCode);
    }

    public boolean releaseWmsOccupyByMove(WhWmsOccupyVO vo){
        return whWmsOccupyService.releaseWmsOccupyByMove(vo);
    }

    /**
     * 根据code查找移库单
     * @param code
     * @return
     */
    public WhWmsMoveStockVO getMoveStockByCode(String code) {
        return whWmsMoveStockService.getMoveStockByCode(code);
    }

    /**
     * 根据id查询移库单
     * @param id
     * @return
     */
    public WhWmsMoveStock getMoveStockById(Long id) {
        return whWmsMoveStockService.getMoveStockById(id);
    }

    /**
     * 根据移库单号查询sku信息
     * @param moveCode
     * @return
     */
    public List<WhWmsMoveSkuVO> getMoveSkuByMoveCode(String moveCode) {
        return whWmsMoveSkuService.getMoveSkuByMoveCode(moveCode);
    }

    /**
     * 新建移库单
     * @param moveStockVO
     * @return
     */
    public Boolean newMoveStock(WhWmsMoveStockVO moveStockVO) {
        return whWmsMoveStockService.newMoveStock(moveStockVO);
    }
    public Boolean moveStockFinishByMoveSku(String moveCode, Long operatorId, Long moveSkuId){
        return whWmsMoveStockService.moveStockFinishByMoveSku(moveCode,operatorId,moveSkuId);
    }
    public Boolean newMoveStockThenFinish(WhWmsMoveStockVO moveStockVO) {
        return whWmsMoveStockService.createMoveStockThenFinish(moveStockVO);
    }

    public Boolean moveStockFinishByMoveSku(String moveCode, Long operatorId, Long moveSkuId,WhWmsTaskAssignVO taskAssignVO){
        return whWmsMoveStockService.moveStockFinishByMoveSku(moveCode,operatorId,moveSkuId,taskAssignVO);
    }

    public Boolean moveStockFinishByMoveSku(WhWmsMoveSkuVO whWmsMoveSkuVO, WhWmsTaskAssignVO taskAssignVO){
        return whWmsMoveStockService.moveStockFinishByMoveSku(whWmsMoveSkuVO,taskAssignVO);
    }
    /**
     * 模糊获取库位号
     * @param name
     * @return
     */
    public List<WhWmsHouseShelves> getHouseShelvesLikeCode(String name) {
        return whWmsHouseShelvesService.getHouseShelvesLikeCode(name);
    }

    public List<WhWmsHouseShelves> getHouseShelvesByCondNoPage(WhWmsHouseShelvesCond cond) {
        return whWmsHouseShelvesService.getHouseShelvesByCondNoPage(cond);
    }


    /**
     * 移库后释放占用并扣减库存
     * @param moveCode
     @return
     */
    public Boolean doMoveStockAndReleaseOccupyAndFinish(String moveCode,Long operatorId){
        return whWmsMoveStockService.doMoveStockAndReleaseOccupyAndFinish(moveCode,operatorId);

    }

    /**
     * 取消移库单
     * @param list
     */
    public void cancelMoveStock(List<WhWmsMoveStockVO> list,Long operatorId){
        if(EmptyUtil.isNotEmpty(list)){
            list.forEach(vo->{
                List<WhWmsMoveSkuVO> skuList = whWmsMoveSkuService.getMoveSkuByMoveCode(vo.getCode());
                vo.setMoveSkuList(skuList);
            });
            whWmsMoveStockService.cancelMoveStock(list,operatorId);
        }
    }
    /**
    * 根据id获取任务行
    * @param id
    * @return
    */
    public WhWmsMoveSkuVO getMoveSkuById(Long id) {
        return whWmsMoveSkuService.getMoveSkuById(id);
    }


    /**
     * 入库单质检
     * @param vo
     */
    public boolean qualityControl(WhReceiveShelvesVO vo){
        String lockKey = "lock:wms:qualityControl"+vo.getWhCommandId();
        try{
            //获取分布式锁
            Boolean getLock = redisDistributLock.tryLock(lockKey,1L, TimeUnit.MINUTES);
            if (!getLock){
                throw new WarehouseException(
                        WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "系统繁忙，请稍后重试!");
            }
            checkQuInfo(vo);
            return whCommandService.qualityControl(vo);
        }finally {
            redisDistributLock.unLock(lockKey);
        }
    }


    //检查收货数量
    private void checkQualityControlAmount(WhReceiveShelvesVO vo){
        Map<String,Integer> skuPlanRestQuantityMap = getSkuPlanRestQuantityMap(vo);
        Map<String,Integer> skuQcMap = getQualityControlSkuQuantiyMap(vo);
        for(Map.Entry<String,Integer> entry : skuQcMap.entrySet()){
            Integer qcQuantity = entry.getValue();
            Integer restQuantity = skuPlanRestQuantityMap.get(entry.getKey());
            if(NullUtil.isNull(restQuantity)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("质检异常[%s]",entry.getKey()));
            }
            if(qcQuantity > restQuantity){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("收货数量异常[可收数量：%s],[当前质检数量：%s]",restQuantity,qcQuantity));
            }
        }
    }

    private Map<String,Integer> getSkuPlanRestQuantityMap(WhReceiveShelvesVO vo){
        Map<String,Integer> skuQuantityMap = new HashMap<>();
        List<WhReceiveShelvesVO> receiveList = findReceiveShelvesDetail(vo.getWhInType(),vo.getWhCommandId());
        if(EmptyUtil.isNotEmpty(receiveList)){
            for(WhReceiveShelvesVO receive : receiveList){
                int total = receive.getPlanedQuantity();
                if(NullUtil.isNotNull(receive.getAllNondefectiveQuantity())){
                    total -= receive.getAllNondefectiveQuantity();
                }
                if(NullUtil.isNotNull(receive.getAllDefectiveQuantity())){
                    total -= receive.getAllDefectiveQuantity();
                }
                if(NullUtil.isNotNull(receive.getAllSampleQuantity())){
                    total -= receive.getAllSampleQuantity();
                }
                if(NullUtil.isNotNull(receive.getAllWasteQuantity())){
                    total -= receive.getAllWasteQuantity();
                }
                if(NullUtil.isNotNull(receive.getAllDisplayQuantity())){
                    total -= receive.getAllDisplayQuantity();
                }
                if(NullUtil.isNotNull(receive.getAllPropQuantity())){
                    total -= receive.getAllPropQuantity();
                }
                skuQuantityMap.put(receive.getSkuCode(),total);
            }
        }
        return skuQuantityMap;
    }

    private Map<String,Integer> getQualityControlSkuQuantiyMap(WhReceiveShelvesVO vo){
        Map<String,Integer> skuQuantityMap = new HashMap<>();
        if(EmptyUtil.isNotEmpty(vo.getQcList()))
        for(WhQualityControlVO qc : vo.getQcList()){
            Integer total = skuQuantityMap.get(qc.getQcSku());
            if(NullUtil.isNull(total)){
                total = 0;
            }
            if(NullUtil.isNotNull(qc.getNondefectiveQuantity())
                    && qc.getNondefectiveQuantity() > 0){
                total += qc.getNondefectiveQuantity();
            }
            if (NullUtil.isNotNull(qc.getDefectiveQuantity())
                    && qc.getDefectiveQuantity() > 0){
                total += qc.getDefectiveQuantity();
            }
            if (NullUtil.isNotNull(qc.getSampleQuantity())
                    && qc.getSampleQuantity() > 0){
                total += qc.getSampleQuantity();
            }
            if (NullUtil.isNotNull(qc.getWasteQuantity())
                    && qc.getWasteQuantity() > 0){
                total += qc.getWasteQuantity();
            }
            if (NullUtil.isNotNull(qc.getDisplayQuantity())
                    && qc.getDisplayQuantity() > 0){
                total += qc.getDisplayQuantity();
            }
            if (NullUtil.isNotNull(qc.getPropQuantity())
                    && qc.getPropQuantity() > 0){
                total += qc.getPropQuantity();
            }
            skuQuantityMap.put(qc.getQcSku(),total);
        }
        return skuQuantityMap;
    }

    public Set<Long> getGlobalConfigByKey(String configKey){
        return whCommandService.getGlobalConfigByKey(configKey);
    }

    /**
     * 上架开始
     * @param vo
     */
    public String startPutaway(WhWmsWaitPutawayVO vo) {
       return whWmsWaitPutawayService.startPutaway(vo);
    }

    /**
     * 查询要打印的上架清单
     * @param vo
     * @return
     */
    public List<WhWmsWaitPutawayVO> findPrintPutawayOrder(WhWmsPutawaySearchVO vo) {
        return whWmsWaitPutawayService.findPrintPutawayOrder(vo);
    }

    /**
     * 查询待上架列表
     * @param vo
     * @return
     */
    public Pagination<WhWmsWaitPutawayVO> findPutawayList(WhWmsWaitPutawayVO vo) {
        return whWmsWaitPutawayService.findPutawayList(vo);
    }
    
    /**
     * 通过SKU_CODE查询待上架列表
     * @param vo
     * @return
     */
    public Pagination<WhWmsWaitPutawayVO> getPutawayListBySkuCode(WhWmsWaitPutawayVO vo) {
        return whWmsWaitPutawayService.getPutawayListBySkuCode(vo);
    }

    /**
     *上架任务管理
     * @param vo
     * @return
     */
    public Pagination<WhWmsWaitPutawayVO> findPutawayTaskList(WhWmsWaitPutawayVO vo){
        return whWmsWaitPutawayService.findPutawayTaskList(vo);
    }

    /**
     * WMS的SKU库存占用
     *
     * @param vo SKU库存占用vo
     */
    public Long wmsOccupy(WhWmsOccupyVO vo){
        return whWmsOccupyService.wmsOccupy(vo);
    }


    /**
     * WMS的批量SKU库存占用
     *
     * @param voList SKU库存占用vo列表
     */
    public List<Long> wmsBatchOccupy(List<WhWmsOccupyVO> voList){
        return whWmsOccupyService.wmsBatchOccupy(voList);
    }


    /**
     * 释放WMS的SKU库存占用
     *
     * @param vo
     */
    public boolean releaseWmsOccupy(WhWmsOccupyVO vo){
        return whWmsOccupyService.releaseWmsOccupy(vo);
    }


    /**
     * 多条件获取WMS占用记录
     *
     * @param cond
     * @return
     */
    public List<WhWmsOccupyVO> getWmsOccupyByCond(WhWmsOccupyVO cond){
        return whWmsOccupyService.getWmsOccupyByCond(cond);
    }


    /**
     * 根据ID更新WMS的SKU库存
     * @param id
     * @return
     */
    public boolean updateStockById(Integer id,Integer amount){
        return  whWmsSkuStockService.updateStockById(id, amount);
    }

    /**
     * 根据物理仓库编码、仓库区域、条形码、库位编码、SKU_CODE、SKU状态更新WMS的SKU库存
     * @return
     */
    public boolean updateStockByCond(Integer amount,String physicalWarehouseCode,String houseType,String barcode,String shelvesCode,String skuCode,Integer skuStatus,Integer inoutType,String receiptNo,Long userId){
        return whWmsSkuStockService.updateStockByCond(amount, physicalWarehouseCode, houseType, barcode, shelvesCode, skuCode, skuStatus,inoutType,receiptNo, userId);
    }

    public boolean convertBarcodeUpdateSkuStock(WhWmsSkuStockVO vo){
        return whWmsSkuStockService.convertBarcodeUpdateSkuStock(vo);
    }

    /**
     * 条件获取WMS库存
     * @param cond
     * @return
     */
    public List<WhWmsSkuStockVO> getWmsSkuStockByCond(WhWmsSkuStockVO cond){
        return whWmsSkuStockService.getWmsSkuStockByCond(cond);
    }
    
    

    /**
     * 条件获取WMS库存
     * @param cond
     * @return
     */
    public List<WhWmsSkuStockVO> getWmsSkuStocksByCond(WhWmsSkuStockVO cond){
        return whWmsSkuStockService.getWmsSkuStocksByCond(cond);
    }
    
    /**
     * 条件获取WMS库存
     * @param cond
     * @return
     */
    public List<WhWmsSkuStockVO> getWmsSkuStocksByShelvesCond(WhWmsSkuStockVO cond){
        return whWmsSkuStockService.getWmsSkuStocksByShelvesCond(cond);
    }
    
    /**
     * 条件获取WMS库存
     * @param cond
     * @return
     */
    public List<WhWmsSkuStockVO> getWmsSkuStocksByCondForReport(WhWmsSkuStockVO cond){
        return whWmsSkuStockService.getWmsSkuStocksByCondForReport(cond);
    }
    
    /**
     * 条件获取WMS库存
     * @param cond
     * @return
     */
    public Pagination<WhWmsSkuStockVO> getWmsSkuStocksByShelvesCondForReport(WhWmsSkuStockVO cond){
        return whWmsSkuStockService.getWmsSkuStocksByShelvesCondForReport(cond);
    }

    public List<WhWmsSkuStockVO> listWmsSkuStocksByShelvesCondForReport(WhWmsSkuStockVO cond){
        return whWmsSkuStockService.getSkuStocksByShelvesCondForReport(cond);
    }

    public List<WhWmsSkuStockVO> listWmsSkuStocksByCond(WhWmsSkuStockVO cond){
        return whWmsSkuStockService.listSkuStocksByCond(cond);
    }

    public List<WhWmsMoveStorehouseVO> listWhWmsMoveStorehouseVOsByCond(WhWmsMoveStorehouseCond cond){
        return whWmsMoveStorehouseService.listWhWmsMoveStorehouseVOsByCond(cond);
    }

    public WhWmsMoveStorehouseVO listWhWmsMoveStorehouseVOsByCode(String code){
        WhWmsMoveStorehouseCond cond = new WhWmsMoveStorehouseCond();
        cond.setCode(code);
        List<WhWmsMoveStorehouseVO> moveStorehouseVOs = this.listWhWmsMoveStorehouseVOsByCond(cond);
        if (CollectionUtils.isEmpty(moveStorehouseVOs)){
            return null;
        }
        return moveStorehouseVOs.get(0);
    }

    public List<WhWmsMoveStorehouse> listWhWmsMoveStorehouseByCond(WhWmsMoveStorehouseCond cond){
        return whWmsMoveStorehouseService.listWhWmsMoveStorehouseByCond(cond);
    }
    public void updateWhWmsMoveStorehouse(WhWmsMoveStorehouse record, WhWmsMoveStorehouseExample example) {
        whWmsMoveStorehouseService.updateWhWmsMoveStorehouse(record,example);
    }
    public WhWmsMoveStorehouse findWhWmsMoveStorehouseById(Long id) {
        return whWmsMoveStorehouseService.findWhWmsMoveStorehouseById(id);
    }

    public WhWmsMoveStorehouse findWhWmsMoveStorehouseByCode(String code) {
        if (EmptyUtil.isEmpty(code)){
            return null;
        }
        WhWmsMoveStorehouseCond cond = new WhWmsMoveStorehouseCond();
        cond.setCode(code);
        List<WhWmsMoveStorehouse> moveStorehouses = this.listWhWmsMoveStorehouseByCond(cond);
        if (CollectionUtils.isNotEmpty(moveStorehouses)){
            return moveStorehouses.get(0);
        }
        return null;
    }

    public WhWmsMoveStorehouseVO findWhWmsMoveStorehouseVOByCode(String code, boolean fetchBc) {
        WhWmsMoveStorehouseVO moveStorehouseVO = this.listWhWmsMoveStorehouseVOsByCode(code);
        if (EmptyUtil.isNotEmpty(moveStorehouseVO) && fetchBc){
            WhWmsMoveStorehouseBarcodeCond cond = new WhWmsMoveStorehouseBarcodeCond();
            cond.setRefId(moveStorehouseVO.getId());
            moveStorehouseVO.setMoveStorehouseBarcodeVOs(this.listWhWmsMoveStorehouseBarcodeVOsByCond(cond));
        }
        return moveStorehouseVO;
    }

    public void addOrEditWhWmsMoveStorehouseVO(WhWmsMoveStorehouseVO moveStorehouseVO){
        whWmsMoveStorehouseService.addOrEditWhWmsMoveStorehouseVO(moveStorehouseVO);
    }

    public List<WhWmsMoveStorehouseBarcodeVO> listWhWmsMoveStorehouseBarcodeVOsByCond(WhWmsMoveStorehouseBarcodeCond cond){
        return whWmsMoveStorehouseService.listWhWmsMoveStorehouseBarcodeVOsByCond(cond);
    }

    public List<WhWmsMoveStorehouseBarcode> listWhWmsMoveStorehouseBarcodeByCond(WhWmsMoveStorehouseBarcodeCond cond){
        return whWmsMoveStorehouseService.listWhWmsMoveStorehouseBarcodeByCond(cond);
    }

    public WhWmsMoveStorehouseVO findWhWmsMoveStorehouseById(Long id,boolean cascade){
        return whWmsMoveStorehouseService.findWhWmsMoveStorehouseById(id,cascade);
    }

    public boolean moveStorehousePutAway(WhWmsMoveStorehouseVO vo){
        return whWmsMoveStorehouseService.moveStorehousePutAway(vo);
    }

    public boolean moveWarehouseStock(List<WhWmsMoveHouseShelvesExcelVO> excelList,Long operatorId){
        return whWmsMoveWarehouseService.moveStock(excelList,operatorId);
    }

    public WhWmsSkuStockVO countSkuAmountBySkuStatus(WhWmsSkuStockVO cond){
        return whWmsSkuStockService.countSkuAmountBySkuStatus(cond);
    }

    public List<WhWmsSkuStockVO> findWmsSkuAvailableAccountWithPreOccupy(WhWmsSkuStockVO vos,boolean gtZero){
        return whWmsSkuStockService.findWmsSkuAvailableAccountWithPreOccupy(vos,gtZero);
    }


    /**
     * 根据条件计算可用库存
     * @param vos
     * @return
     */
    public List<WhWmsSkuStockVO> findWmsSkuAvailableAccount(WhWmsSkuStockVO vos){
        return whWmsSkuStockService.findWmsSkuAvailableAccount(vos);
    }

    /**
     * 根据connectId查找
     * @param connectId
     * @return
     */
    public List<WhWmsConnectPickSkuVO> findConnectPickSkuByConnectId(Long connectId){
        return whWmsConnectPickSkuService.findByConnectId(connectId);
    }

    public List<WhWmsConnectPickSkuVO> findConnectPickSkuByCond(WhWmsConnectPickSkuCond cond){
        return whWmsConnectPickSkuService.findConnectPickSkuByCond(cond);
    }

    /**
     * 根据connectId查找
     * @param connectIds
     * @return
     */
    public List<WhWmsConnectPickSkuVO> findConnectPickSkuByConnectIds(List<Long> connectIds){
        return whWmsConnectPickSkuService.findByConnectIds(connectIds);
    }
    public List<WhWmsConnectPickSkuVO> findListConnectPickSku(List<Long> connectIds){
        return whWmsConnectPickSkuService.findListConnectPickSku(connectIds);
    }

    /**
     * 提交拣货任务
     * @param connectId
     * @param pickSkuVOList
     * @param operatorId
     * @return
     * @throws Exception
     */
    public Boolean submitConnectPickSku(Long connectId,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId,WhWmsTaskAssignVO task) throws Exception{
        long time1 = Calendar.getInstance().getTimeInMillis();
        WhWmsConnectInfoVO connectVO = whWmsConnectInfoService.findById(connectId);
        if(connectVO==null||
                (!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.WAITING_PROCESS)
                        &&!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.PROCESSING)) ){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次状态不是待拣货或拣货中");
        }
        List<WhWmsConnectPickSkuVO> submitList = new ArrayList<>();
        for(WhWmsConnectPickSkuVO vo:pickSkuVOList){
            submitList.add(vo);
        }
        WhCommand cmd = new WhCommand();
        List<WhWmsCommandConnectVO> commandConnects = new ArrayList<>();
        if(whWmsConnectPickSkuService.preSubmitConnectPickSku(connectVO,pickSkuVOList,operatorId,cmd,commandConnects)){
            return true;
        }
        boolean result = false;
        try{
            if(cmd.getInOutType().equals(WhCommand.TYPE_PURCHASE_RETURN_OUT)){//采退出库-拣货
                WhWmsConnectPickSkuSubmitDataVO vo = whWmsConnectPickSkuService.checkSubmitConnectPickSkuPcsRtn(connectVO,commandConnects,pickSkuVOList,operatorId);
                result = whWmsConnectPickSkuService.submitConnectPickSkuPcsRtn(vo,operatorId);
            }else if(cmd.getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)){//调拨出库-拣货
                WhWmsConnectPickSkuSubmitDataVO vo = whWmsConnectPickSkuService.checkSubmitConnectPickSkuAlt(connectVO,pickSkuVOList,operatorId);
               result = whWmsConnectPickSkuService.submitConnectPickSkuAlt(vo,operatorId);
            }else if(WMSConstants.ConnectType.RECEIVE_WASTE.equals(connectVO.getConnectType())){//报废出库
                WhWmsConnectPickSkuSubmitDataVO vo = whWmsConnectPickSkuService.checkSubmitConnectPickSkuRecWaste(connectVO,commandConnects,pickSkuVOList,operatorId);
                result = whWmsConnectPickSkuService.submitConnectPickSkuRecWaste(vo,operatorId);
            }else {//销售出库
                WhWmsConnectPickSkuSubmitDataVO vo = whWmsConnectPickSkuService.checkSubmitConnectPickSku(connectVO, pickSkuVOList, operatorId, cmd, commandConnects);
                result = whWmsConnectPickSkuService.submitConnectPickSku(vo);
                if (result && NullUtil.isNotNull(task)) {
                    whWmsTaskAssignService.finishTaskAssigned(task.getId(), operatorId);
                }
            }
        }catch (Exception e){
            for(WhWmsConnectPickSkuVO whWmsConnectPickSkuVO:submitList){
                WhWmsConnectPickSku vo = new WhWmsConnectPickSku();
                vo.setStatus(0);
                vo.setId(whWmsConnectPickSkuVO.getId());
                whWmsConnectPickSkuService.updateWhWmsConnectPickSkuByKey(vo);
            }
            throw new RuntimeException(e.getMessage());
        }
        long time2 = Calendar.getInstance().getTimeInMillis();
        log.warn("提交拣货任务submitConnectPickSku task 波次" + connectVO.getId() +"耗时：" + (time2 - time1));
        return result;
    }

    public void handleConnectToNextAction(){
        List<WhWmsConnectInfoVO> list = whWmsConnectInfoService.findNeedHandleConnect();
        if(EmptyUtil.isEmpty(list)){
            return;
        }
        for(WhWmsConnectInfoVO connectVO : list){
            List<WhWmsCommandConnectVO> commandConnects = findNotCanceledConnectCommandByConnectId(connectVO.getId());
            WhCommand cmd = whCommandService.findCommandByCode(commandConnects.get(0).getCommandCode(), false);
            List<WhWmsConnectPickSkuVO> pickSkuVOList = findConnectPickSkuByConnectId(connectVO.getId());//获取实际拣货数据
            boolean result = false;
            try{
                if(cmd.getInOutType().equals(WhCommand.TYPE_PURCHASE_RETURN_OUT)){//采退出库-拣货
                    WhWmsConnectPickSkuSubmitDataVO vo = whWmsConnectPickSkuService.checkSubmitConnectPickSkuPcsRtn(connectVO,commandConnects,pickSkuVOList,1l);
                    result = whWmsConnectPickSkuService.submitConnectPickSkuPcsRtn(vo,1l);
                }else if(cmd.getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)){//调拨出库-拣货
                    WhWmsConnectPickSkuSubmitDataVO vo = whWmsConnectPickSkuService.checkSubmitConnectPickSkuAlt(connectVO,pickSkuVOList,1l);
                    result = whWmsConnectPickSkuService.submitConnectPickSkuAlt(vo,1l);
                }else {//销售出库
                    WhWmsConnectPickSkuSubmitDataVO vo = whWmsConnectPickSkuService.checkSubmitConnectPickSku(connectVO, pickSkuVOList, 1l, cmd, commandConnects);
                    result = whWmsConnectPickSkuService.submitConnectPickSku(vo);
                }
            }catch (Exception e){
                log.info(String.format("WhWmsCommandConnectVO[%s]后续流程处理失败",connectVO.getId()));
            }

        }
    }

    /**
     * 绑定拣货周转箱
     * @param connectId
     * @param turnoverBoxNo
     * @param createUserId
     * @return
     */
    public Boolean bindConnectBox(Long connectId,String turnoverBoxNo,Long createUserId){
        return whWmsConnectPickSkuService.bindConnectBox(connectId, turnoverBoxNo, createUserId);
    }

    /**
     * 查询绑定拣货周转箱
     * @param connectId
     * @param
     * @param
     * @return
     */
    public List<WhWmsConnectTurnoverBox> findConnectBox(Long connectId){
        return whWmsConnectPickSkuService.findConnectBoxByConnectId(connectId);
    }

    /**
     * 删除拣货周转箱
     * @param connectId
     * @param turnoverBoxNo
     * @return
     */
    public Boolean delConnectBox(Long connectId,String turnoverBoxNo){
        return whWmsConnectPickSkuService.delConnectBox(connectId, turnoverBoxNo);
    }

    /**
     * 根据波次id查 非取消的 波次仓库指令
     * @param connectId
     * @return
     */
    public List<WhWmsCommandConnectVO> findNotCanceledConnectCommandByConnectId(Long connectId){
        return whWmsCommandConnectService.findNotCanceledByConnectId(connectId);
    }
    public List<WhWmsCommandConnectVO> findWhWmsCommandConnectVOListByCond(WhWmsCommandConnectCond whWmsCommandConnectCond){
        return whWmsCommandConnectService.findByCond(whWmsCommandConnectCond);
    }
    /*
    * 拣货逻辑
    * */
    public List<WhWmsSkuPickStockVO> generalPickSkuStockStragety(List<WhWmsSkuPickStockVO> pickStockList , Integer skuStatus, String physicalWarehouseCode){
        return whWmsCommandConnectService.generalPickSkuStockStragety(pickStockList,skuStatus,physicalWarehouseCode);
    }

    /**
     * 查找拣货周转箱
     * @param cond
     * @return
     */
    public List<WhWmsConnectTurnoverBox> findPickSkuBoxByCond(WhWmsConnectTurnoverBox cond){
        return whWmsConnectPickSkuService.findBoxByCond(cond);
    }

    public List<WhCountVO> countConnectPickSku(Long operatorId,String physicalWarehouseCode){
        return whWmsConnectPickSkuService.countConnectPickSku(operatorId,physicalWarehouseCode);
    }

    /**
     * 多条件查询批次码
     * @param vo
     * @return
     */
    public List<WhWmsSkuBarcodeVO> getWmsSkuBarcodeByCond(WhWmsSkuBarcodeVO vo){
        return whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(vo);
    }

    /**
     * 收货是否完成
     * @param cmdCode
     * @return
     */
    public boolean isReceiveOver(String cmdCode){
        return  whWmsWaitPutawayService.isReceiveOver(cmdCode);
    };
    /**
     * 批量创建波次分拨数据
     * @param vos
     * @return
     */
    public List<WhWmsConnectDistributionVO> createConnectDistribution(List<WhWmsConnectDistributionVO> vos){
        return whWmsConnectDistributionService.create(vos);
    }

    /**
     * 批量创建波次分拨数据
     * @param vos
     * @return
     */
    @Deprecated
    public List<WhWmsConnectDistributionVO> createConnectDistribution(List<WhWmsConnectDistributionVO> vos,Long operatorId){
        return whWmsConnectDistributionService.create(vos,operatorId);
    }

    public boolean connectDistribute(WhWmsConnectDistributeInfoVO connectDistributeInfo){
        if(EmptyUtil.isNotEmpty(connectDistributeInfo.getMoveStockList())){
            for(WhWmsMoveStockVO moveStock : connectDistributeInfo.getMoveStockList()){
                whWmsMoveStockService.buildMoveStock(moveStock);
            }
        }
        return whWmsConnectDistributionService.connectDistribute(connectDistributeInfo);
    }

    /**
     * 根据条件查找波次分拨数据
     * @param cond
     * @return
     */
    public List<WhWmsConnectDistributionVO> findConnectDistributionByCond(WhWmsConnectDistributionVO cond){
        return whWmsConnectDistributionService .findByCond(cond);
    }
    public Map<String, List<String>> findPackageDistributionBoxNo(List<Long> commandIdList, List<String> commandCodeList){
        return whWmsConnectDistributionService.findPackageDistributionBoxNo(commandIdList,commandCodeList);
    }
    public Pagination<WhWmsWaitPutawayTaskVO> findPutawayTaskList(WhWmsWaitPutawayTaskVO vo){
        return whWmsWaitPutawayTaskService.findPutawayTaskList(vo);
    }

    public List<WhWmsWaitPutawayTaskVO> findWhWmsWaitPutawayTaskVOList(WhWmsWaitPutawayTaskVO vo){
        return whWmsWaitPutawayTaskService.findWhWmsWaitPutawayTaskVOList(vo);
    }
    /**
     * 根据主键获取生产加工子任务
     * @param id
     * @return
     */
    public WhWmsPrdcJobTaskVO getPrdcJobTaskById(Long id) {
        return whWmsPrdcJobTaskService.getPrdcJobTaskById(id);
    }


    public boolean submitConnectCheck(WhWmsConnectCheckVO connectCheck){
        if(EmptyUtil.isNotEmpty(connectCheck.getMoveStockList())){
            for(WhWmsMoveStockVO moveStock : connectCheck.getMoveStockList()){
                whWmsMoveStockService.buildMoveStock(moveStock);
            }
        }
        return whWmsCommandCheckService.submitConnectCheck(connectCheck);
    }

    public boolean checkGiftCardCanBindByCardNo(String cardNo){
        return whWmsCommandCheckService.checkGiftCardCanBindByCardNo(cardNo);
    }

    /**
     * 定制商品出库验货数据
     */
    public boolean createCustomization(WhWmsCommandCheckInfo checkInfo){
        return whWmsCommandCheckService.createCustomization(checkInfo);
    }


    public boolean createCommandCheck(WhWmsCommandCheckInfo checkInfo){
        WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO  = whWmsCommandCheckService
                .preCheckCommandCheck(checkInfo.getCommandCheckDetailList(),checkInfo.getOperatorId());
        whWmsConnectPickSkuSubmitDataVO.setCheckGiftCardList(checkInfo.getCheckGiftCardList());
        whWmsCommandCheckService.create(checkInfo.getCommandCheckDetailList()
                ,whWmsConnectPickSkuSubmitDataVO
                ,checkInfo.getOperatorId());
        return true;
    }

    /**
     * 批量创建出库单出库验货数据
     * @param connectId
     * @param batchList
     * @param fedList
     * @param sfList
     * @return
     */
    public Boolean createCommandCheck(Long connectId,List<WhWmsCommandCheckBatch> batchList, List<PackageInfo> fedList, List<PackageInfo> sfList){
        return whWmsCommandCheckService.create(connectId,batchList,fedList,sfList);
    }

    public boolean  putawayTaskExcu(WhWmsPutawayExcuVO vo,Long operatorId) throws Exception{
        return whWmsWaitPutawayTaskService.putawayTaskExcu(vo,operatorId);
    }

    public boolean targetShelvesCodeCheck(String shelvesCode,String barCode,boolean focus){
        return whWmsWaitPutawayTaskService.targetShelvesCodeCheck(shelvesCode,barCode,focus);
    }

    public List<WhCountVO> countPutawayTask(String physicalWarehouseCode){
        return whWmsWaitPutawayTaskService.countPutawayTask(physicalWarehouseCode);
    }
    
    /**
     * 手动入库
     * @throws Exception 
     * */
    public boolean  manualReceive(WhWmsManualInOutVO vo) throws Exception{
        return whWmsManualInOutService.manualInOutStock(vo);
    }
    /**
     * 手动出库
     * @throws Exception 
     * */
    public boolean manualOut(List<WhWmsManualInOutVO> voList) throws Exception{
        return whWmsManualInOutService.manualInOutStock(voList);
    }

    /**
     * 取消出库验货,标记缺货
     * @param commandCode
     * @param operatorId
     * @param vos
     * @return
     */
    public Boolean cancelCommandCheck(String commandCode,Long operatorId,List<WhWmsCommandCheckVO> vos) {
        return whWmsCommandCheckService.cancel(commandCode,operatorId,vos);
    }

    public Boolean cancelCommandCheck(String commandCode,Long operatorId) {
        return whWmsCommandCheckService.cancel(commandCode,operatorId);
    }
    /**
     * 取消出库验货,指令取消
     * @param commandCode
     * @param operatorId
     * @return
     */
    public Boolean rejectCommandCheck(String commandCode,Long operatorId) {
        return whWmsCommandCheckService.reject(commandCode,operatorId);
    }
    
    /**
     * 出库单关联快递单
     * @param commandCode
     * @param commandCode
     * @return
     */
    public Boolean commandAssociateExpress(String commandCode,String expressCode) {
        return WhCommandAssociateExpressService.commandAssociateExpress(commandCode,expressCode);
    }

    /**
     * 出库单关联快递单
     * @param commandCode
     * @param expressCode
     * @param operationSource
     * @return
     */
    public Boolean commandAssociateExpress(String commandCode,String expressCode,String operationSource) {
        return WhCommandAssociateExpressService.commandAssociateExpress(commandCode,expressCode,operationSource);
    }

    /**
     * 出库单关联快递单
     * @return
     */
    public Boolean commandAssociateExpress(WhCommandAssoExpressVO vo) {
        return WhCommandAssociateExpressService.commandAssociateExpress(vo);
    }

    @Deprecated
    public void packageAssoExpressZTAndPackage(ZTOrderSubmitResponse ztOrderSubmitResponse){
        whCommandService.packageAssoExpressZTAndPackage(ztOrderSubmitResponse);
    }

    @Deprecated
    public Boolean commandAssociateExpressSF(String commandCode, PackageInfo pi){
        return WhCommandAssociateExpressService.commandAssociateExpressSF(commandCode,pi);
    }

    /**
     * 出库单关联快递单(单个),联邦
     *
     * @param commandCode
     * @param pi
     * @return
     */
    @Deprecated
    public Boolean commandAssociateExpressFED(String commandCode, PackageInfo pi){
        return WhCommandAssociateExpressService.commandAssociateExpressFED(commandCode,pi);
    }

    @Deprecated
    public void packageAssoExpressTmsAndCommand(PackageInfo pi){
        whCommandService.packageAssoExpressTmsAndCommand(pi);
    }


    
    

    /**
     * 根据jobCode获取所有子任务列
     * @param jobCode
     * @return
     */
    public List<WhWmsPrdcJobTaskVO> getPrdcJobTaskByJobCode(String jobCode) {
        return whWmsPrdcJobTaskService.getPrdcJobTaskByJobCode(jobCode);
    }

    /**
     * 生成加工子任务,并占用相应库存
     * @param vo
     * @return
     */
    public Boolean createJobTaskAndOccupyStock(WhWmsPrdcJobTaskVO vo) {
        return whWmsPrdcJobTaskService.createJobTaskAndOccupyStock(vo);
    }

    /**
     * 根据子任务code获取加工行数据详情
     * @param taskCode
     * @return
     */
    public List<WhWmsPrdcJobTaskDetailVO> getTaskDetailByTaskCode(String taskCode){return whWmsPrdcJobTaskDetailService.getTaskDetailByTaskCode(taskCode);}

    /**
     * 完成子任务，并更新相应库存
     * @param jobTaskVO
     * @return
     * @throws Exception 
     */
    public Boolean finishTaskAndUpdateStock(WhWmsPrdcJobTaskVO jobTaskVO,Long userId) throws Exception {
        return whWmsPrdcJobTaskService.finishTaskAndUpdateStock(jobTaskVO,userId);
    }
    /**
     * 库存报表查询
     * */
    public List<WhWmsSkuStockVO> getStockByWarehouseCode(String warehouseCode){
    	return whWmsReportService.getStockByWarehouseCode(warehouseCode);
    }
    
    /**
     * 库位库存报表查询
     * */
    public List<WhWmsSkuStockVO> getShelvesStockByWarehouseCode(String warehouseCode){
    	return whWmsReportService.getShelvesStockByWarehouseCode(warehouseCode);
    }
    
    /**
     * 库存概要查询
     * */
    public Map<String,Object> getStockCountByWarehouseCode(String warehouseCode){
    	return whWmsReportService.getStockCountByWarehouseCode(warehouseCode);
    }


    /**
     * 条件获取生产任务列
     * @param cond
     * @return
     */
    public List<WhWmsPrdcJobTaskVO> getPrdcJobTaskByCond(WhWmsPrdcJobTaskCond cond) {
        return whWmsPrdcJobTaskService.getPrdcJobTaskByCond(cond);
    }

    /**
     * 获取单张生产订单最大可启动子任务数
     * @param vo
     * @return
     */
    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo){
        return whWmsPrdcJobTaskService.getPrdcJobMaxTask(vo);
    }

    public WhWmsSkuBarcode findMinExpiryDateByMaterialOccupy(WhWmsPrdcJobTaskVO vo){
        return whWmsPrdcJobTaskService.findMinExpiryDateByMaterialOccupy(vo);
    }
    
    /**
     * 获取PrdcJob任务完成情况统计信息
     * */
    public List<Map<String,Object>> getWmsPrdcJobTaskFinishedInfo(List<String> prdcJobCodes){
    	return whWmsPrdcJobTaskService.getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
    }
    
    /**
     * 获取PrdcJob进行中任务情况统计信息
     * */
    public List<Map<String,Object>> getWmsPrdcJobTaskProcessingInfo(List<String> prdcJobCodes){
    	return whWmsPrdcJobTaskService.getWmsPrdcJobTaskProcessingInfo(prdcJobCodes);
    }
    
    /**
     * 获取PrdcJob任务完成情况实际完成数量
     * */
    public List<Map<String,Object>> getWmsPrdcJobTaskFinishedRealAmount(List<String> prdcJobCodes){
    	return whWmsPrdcJobTaskService.getWmsPrdcJobTaskFinishedRealAmount(prdcJobCodes);
    }

    /**
     * 更新生产任务
     * @param vo
     * @return
     */
    public Boolean updateJobTask(WhWmsPrdcJobTaskVO vo){
        return whWmsPrdcJobTaskService.updateJobTask(vo);
    }

    /**
     * 条件获取生产任务 分页
     * @param cond
     * @return
     */
    public Pagination<WhWmsPrdcJobTaskVO> getPrdcTaskByCondPage(WhWmsPrdcJobTaskCond cond) {return whWmsPrdcJobTaskService.getPrdcTaskByCondPage(cond);
    }


    /**
     * 查找出库订单信息
     * @param cond
     * @return
     * */
    public List<WhWmsCommandInfoVO>  findCommandInfoByCond(WhWmsCommandInfoCond cond){
    	return whCommandService.findCommandInfoByCond(cond);
    }

    /**
     * 查找出库订单信息
     * @param cond
     * @return
     * */
    public List<WhWmsCommandInfoVO>  findNewCommandInfoByCond(WhWmsCommandInfoCond cond){
    	return whCommandService.findNewCommandInfoByCond(cond);
    }

    public Pagination<WhWmsCommandInfoVO>  findPaginationCommandInfoByCond(WhWmsCommandInfoCond cond){
    	return whCommandService.findPaginationCommandInfoByCond(cond);
    }


    /**
     * 统计出库订单信息
     * @param cond
     * @return
     * */
    public Map<String,Object>  countCommandInfoByCond(WhWmsCommandInfoCond cond){
    	return whCommandService.countCommandInfoByCond(cond);
    }
    
    /**
	 * 查询附加信息
	 * */
	public List<Map<String, Object>> findAdditionalInfosByCond(WhWmsCommandInfoCond cond){
		return whCommandService.findAdditionalInfosByCond(cond);
	}
	
	/**
	 * 查询波次信息
	 * */
	public WhWmsConnectInfoVO findWhWmsConnectInfoVOByCommandCode(String commandCode){
		return whCommandService.findWhWmsConnectInfoVOByCommandCode(commandCode);
	}

    public boolean commandHandover(WhCommand cmd){
        return whWmsCommandHandoverService.commandHandover(cmd);
    }

    public void processSubmitCommandHandover(WhCommand cmd){
        whWmsCommandHandoverService.processSubmitCommandHandover(cmd);
    }

    public String findSalerEmailAddressByOrderCode(String orderCode){
        String defaultEmail = "thebeastcorpsale@163.com";
        if(EmptyUtil.isNotEmpty(orderCode)){
            String email = whCommandService.findSalesOrderAddressByCond(orderCode);
            if(EmptyUtil.isEmpty(email)){
                email = defaultEmail;
            }
            return email;
        }
        return defaultEmail;
    }

    /**
     * 根据快递单号查找command
     * @param expressCode
     * @return
     */
    public WhCommand findCommandByExpressCode(String expressCode){
        return whCommandService.findCommandByExpressCode(expressCode);
    }

    public boolean createPreOccupy(WhWmsCommandPreOccupyVO vo){
        return whWmsCommandPreOccupyService.createPreOccupy(vo);
    }

    public boolean createPreOccupy(List<WhWmsCommandPreOccupyVO> voList){
        return whWmsCommandPreOccupyService.createPreOccupy(voList);
    }

    public List<WhWmsCommandPreOccupyVO> findPreOccupyByCond(WhWmsCommandPreOccupyCond cond){
        return whWmsCommandPreOccupyService.findByCond(cond);
    }

    public boolean releasePreOccupy(WhWmsCommandPreOccupyCond cond){
        return whWmsCommandPreOccupyService.releasePreOccupy(cond);
    }

    public void commandPreOccupy(String physicalWarehouseCode,Integer skuStatus){
        whWmsConnectStartService.commandPreOccupy(physicalWarehouseCode,skuStatus);
    }

    public void commandPreOccupy(String physicalWarehouseCode,Integer skuStatus,List<String> commandCodes){
        whWmsConnectStartService.commandPreOccupy(physicalWarehouseCode,skuStatus,commandCodes);
    }

    public boolean releasePreOccupy(String physicalWarehouseCode){
        return whWmsConnectStartService.releasePreOccupy(physicalWarehouseCode);
    }

    public WhWmsConnectStartResultVO connectStart(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartConditionsVO conditions,
                                           WhWmsConnectStartCountConfigVO countConfig){
        return whWmsConnectStartService.connectStart(pickStockInfoList,conditions,countConfig);
    }

    public WhWmsConnectStartResultVO connectStartWithConnectType(List<WhCommandPickStockInfoVO> pickStockInfoList
            , WhWmsConnectStartConditionsVO conditions
            , WhWmsConnectStartCountConfigVO countConfig){
        return whWmsConnectStartService.connectStartWithConnectType(pickStockInfoList,conditions,countConfig);
    }

    public WhWmsCommandPreOccupyCond buildPreOccupyCond(WhWmsConnectStartConditionsVO conditions){
        return whWmsConnectStartService.buildPreOccupyCond(conditions);
    }

    public List<WhCommandPickStockInfoVO> convertPickStockInfoFromPreOccupy(List<WhWmsCommandPreOccupyVO> preOccupyList,
                                                                            WhWmsConnectStartConditionsVO conditions){
        return whWmsConnectStartService.convertPickStockInfoFromPreOccupy(preOccupyList,conditions);
    }

    public Map<Integer, WhWmsConnectCountInfoVO> countUnfinishedConnect(String physicalWarehouseCode){
        return whWmsConnectInfoService.countUnfinishedConnect(physicalWarehouseCode);
    }

    public List<WhWmsConnectActivityRuleVO> findConnectActivityRuleByCond(WhWmsConnectActiveRuleCond cond, boolean cascade){
        return whWmsConnectActivityRuleService.findConnectActivityRuleByCond(cond,cascade);
    }


    public Pagination<WhWmsConnectActivityRuleVO> findConnectActivityRuleByCondPage(WhWmsConnectActiveRuleCond cond, boolean cascade){
        return whWmsConnectActivityRuleService.findConnectActivityRuleByCondPage(cond,cascade);
    }

    public WhWmsConnectActivityRuleVO findConnectActivityRule(Long ruleId){
        return whWmsConnectActivityRuleService.findConnectActivityRule(ruleId);
    }

    public boolean saveConnectActiveRule(WhWmsConnectActivityRuleVO ruleVO){
        return whWmsConnectActivityRuleService.saveConnectActivityRule(ruleVO);
    }

    public boolean enableDisableConnectActivityRule(Long ruleId,Integer enableOrDisable){
        return whWmsConnectActivityRuleService.enableDisableConnectActivityRule(ruleId,enableOrDisable);
    }
    /**
     * 根据指令编号查找关联波次信息
     * @param commandCode
     * @return
     */
    public WhWmsCommandConnectVO findNotCanceledConnectCommandByCommandCode(String commandCode){
        return whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
    }

    /**
     * 根据主键找波次
     * @param connectId
     * @return
     */
    public WhWmsConnectInfoVO findConnectInfoByConnectId(Long connectId){
        return whWmsConnectInfoService.findById(connectId);
    }

    /**
     * 根据指令找波次
     * @param commandCode
     * @return
     */
    public WhWmsConnectInfoVO findConnectInfoByCommandCode(String commandCode){
        WhCommand whCommand = whCommandService.findCommandByCode(commandCode, true);
        if(whCommand==null){
            return null;
        }
        WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
        if(commandConnectVO==null){
            return null;
        }
        return whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
    }

    /**
     * 根据指令找波次
     * @param commandCode
     * @return
     */
    public WhWmsConnectInfoVO findConnectInfoByCommandCode(String commandCode,boolean isFetch, boolean isCanceled){
        WhCommand whCommand = whCommandService.findCommandByCode(commandCode, isFetch);
        if(whCommand==null){
            return null;
        }
        WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findByWhCommandCode(commandCode,isCanceled);
        if(commandConnectVO==null){
            return null;
        }
        return whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
    }

    /**
     * 根据code关联WMS-skuInfo  autoComplete
     * @param codeLike
     * @return
     */
    public List<WhWmsShelvesSkuInfo> getSkuInfoLikeCode(String codeLike) {
        return whWmsShelvesSkuInfoService.getSkuInfoLikeCode(codeLike);
    }
    public List<WhCommandSku> findCommandSkuByCommandId(Long commandId){
        return whCommandService.findCommandSkuByCommandId(commandId);
    }

    /**
     * 指令从缺货中到处理中
     * @param whCommandCode
     * @return
     */
    public boolean commandShortagesToInProcessing(String whCommandCode){
        return whCommandService.commandShortagesToInProcessing(whCommandCode);
    }

    /**
     * 获取记录
     * @param cond
     * @return
     */
//    public List<WhWmsTakeStockVO> getTakeStockByCond(WhWmsTakeStockCond cond) {
//        return whWmsTakeStockService.getTakeStockByCond(cond);
//    }

    /**
     * 获取记录 分页
     * @param cond
     * @return
     */
//    public Pagination<WhWmsTakeStockVO> getTakeStockByCondPage(WhWmsTakeStockCond cond) {
//        return whWmsTakeStockService.getTakeStockByCondPage(cond);
//    }

//    /**
//     * 获取行记录
//     * @param cond
//     * @return
//     */
//    public List<WhWmsTakeStockRcdVO> getTakeStockRcdByCond(WhWmsTakeStockRcdCond cond){
//        return  whWmsTakeStockRcdService.getTakeStockRcdByCond(cond);
//    }
//
//    /**
//     * 根据条件获取盘点行记录 页面用
//     * @param cond
//     * @return
//     */
//    public Pagination<WhWmsTakeStockRcdVO> getTakeStockRcdByCondPage(WhWmsTakeStockRcdCond cond) {
//        return whWmsTakeStockRcdService.getTakeStockByCondRcdPage(cond);
//    }
//
//    /**
//     * 创建盘点任务
//     * @param vo
//     * @return
//     */
//    public Boolean createInventoryTask(WhWmsTakeStockVO vo,List<WhWmsTakeStockPlanVO> planList) {
//        return whWmsTakeStockService.createInventoryTask(vo,planList);
//    }
//
//    /**
//     * 创建盘点任务
//     * @param vo
//     * @return
//     */
//    public Boolean createInventoryTask(WhWmsTakeStockVO vo) {
//        return whWmsTakeStockService.createInventoryTask(vo);
//    }


    /**
     * 根据条件查找指令
     * @param cond 条件
     * @return
     */
    public List<WhCommand> findCommandByCond(WhCommandCond cond){
        return whCommandService.findCommandByCond(cond);
    }

    /**
     * 返回需要补货的库位
     * @param houseType
     * @param shelvesType
     * @return
     */
    public List<WhWmsHouseShelvesVO> findNeedToReplenishShelves(String houseType,Integer shelvesType){
       return whWmsReplenishService.findNeedToReplenishShelves(houseType, shelvesType);
    }

    /**
     * 处理补货
     * @param shelvesVO
     */

    public void processReplenish(WhWmsHouseShelvesVO shelvesVO){
        whWmsReplenishService.processReplenish(shelvesVO);
    }


//    /**
//     * 批量盘点
//     * @param whWmsTakeStock
//     * @return
//     */
//    public Boolean complateInventoryTask(WhWmsTakeStockVO whWmsTakeStock) {
//        return whWmsTakeStockService.complateInventoryTask(whWmsTakeStock);
//    }
//
//    /**
//     * 批量盘点
//     * @param whWmsTakeStock
//     * @return
//     */
//    public Boolean complateInventoryTask(WhWmsTakeStockVO whWmsTakeStock,WhWmsTaskAssignVO taskAssignVO) {
//        return whWmsTakeStockService.complateInventoryTask(whWmsTakeStock,taskAssignVO);
//    }

    /**
     * 按名字获取区域
     * @param name
     * @return
     */
    public WhWmsWarehouseArea getAreaByName(String name) {
        return whWmsWarehouseAreaService.getAreaByName(name);
    }

    /**
     * 按code获取区域
     * @param code
     * @return
     */
    public WhWmsWarehouseArea getAreaByCode(String code) {
        return whWmsWarehouseAreaService.getAreaByCode(code);
    }

//    /**
//     * 根据code获取记录
//     * @param code
//     * @return
//     */
//    public WhWmsTakeStockVO getTakeStockByCode(String code) {
//        return whWmsTakeStockService.getTakeStockByCode(code);
//    }

//    /**
//     * 根据id获取盘点行记录
//     * @param id
//     * @return
//     */
//    public WhWmsTakeStockRcdVO getTakeStockRcdById(Long id) {
//        return whWmsTakeStockRcdService.getTakeStockRcdById(id);
//    }

//    /**
//     * 批量盘点审核
//     * @param rcds
//     * @return
//     */
//    public Boolean inventoryAudit(List<WhWmsTakeStockRcdVO> rcds) {
//        return whWmsTakeStockRcdService.inventoryAudit(rcds);
//    }

//    /**
//     * 生成盘点计划
//     * @param plan
//     * @return
//     */
//    public Boolean createTakeStockPlan(WhWmsTakeStockPlanVO plan) {
//        return whWmsTakeStockPlanService.createTakeStockPlan(plan);
//    }

//    /**
//     * 条件获取盘点计划
//     * @param cond
//     * @return
//     */
//    public List<WhWmsTakeStockPlanVO> getTakeStockPlanByCond(WhWmsTakeStockPlanCond cond) {
//        return whWmsTakeStockPlanService.getTakeStockPlanByCond(cond);
//    }
    public List<WhCommand> findCommandByConnectIdAndBarCode(String barCode, Long connectId){
        return this.whCommandService.findCommandByConnectIdAndBarCode(barCode,connectId);
    }
    /**
     * 拼接库位号
     * @param id
     * @return
     */
//    public String excuteShelvesCode(String physicalWarehouseCode, String houseType, String shelves) {
//        return whWmsHouseShelvesService.excuteShelvesCode(physicalWarehouseCode,houseType,shelves);
//    }

//    public WhWmsTakeStockPlanVO getTakeStockPlanById(Long id) {
//        return whWmsTakeStockPlanService.getTakeStockPlanById(id);
//    }

    /**
     * 盘点计划生成盘点任务
     * @param whWmsTakeStock
     * @param id
     * @return
     */
//    public Boolean createPlanInventoryTask(WhWmsTakeStockVO whWmsTakeStock, Long id) {
//        return whWmsTakeStockService.createPlanInventoryTask(whWmsTakeStock,id);
//    }


    /**
     * 生成盘点计划
     * @param planList
     * @return
     */
//    public Boolean createTakeStockPlans(List<WhWmsTakeStockPlanVO> planList){
//        return whWmsTakeStockPlanService.createTakeStockPlans((planList));
//    }


    /**
     *条件查询库位 groupBy 库位
     * @param vo
     * @return
     */
    public List<WhWmsSkuStock> getGroupByShelvesByCond(WhWmsSkuStockVO vo){
        return whWmsSkuStockService.getGroupByShelvesByCond(vo);
    }


    /**
     *条件查询库存 (盘点用)
     * @param vo
     * @return
     */
    public List<WhWmsSkuStock> getStockByCond(WhWmsSkuStockVO vo){
        return whWmsSkuStockService.getStockByCond(vo);
    }

    /**
     *条件查询物理仓sku库存
     * @param cond
     * @return
     */
    public List<PhyWhStockVO> findPhyWhStockByCond(PhyWhStockCond cond){
        return whWmsSkuStockService.findPhyWhStockByCond(cond);
    }

    public List<PhyWhStockVO> findPhyWhSkuTotalQuantityByCond(PhyWhStockCond cond){
        return whWmsSkuStockService.findPhyWhSkuTotalQuantityByCond(cond);
    }

    /**
     * 修改待审核盘点
     * @param takeStockRcdVO
     */
//    public Boolean updateTakeStock(WhWmsTakeStockRcdVO takeStockRcdVO) {
//        return whWmsTakeStockRcdService.updateTakeStock(takeStockRcdVO);
//    }

    /**
     * 检查是否可以绑定分拨箱
     * @param code
     * @return
     */
    public Boolean checkConnectDistributionBoxNo(String code){
        return whWmsConnectDistributionService.checkBoxNo(code);
    }

    /**
     * 根据相关单据号查找command
     * @param referenceCode
     * @return
     */
    public WhCommand findCommandByReferenceCode(String referenceCode) {
        return whCommandService.findCommandByReferenceCode(referenceCode);
    }
    public boolean checkQuInfo(WhReceiveShelvesVO vo){
        return whWmsWaitPutawayService.checkQuInfo(vo);
    }

    public List<WhWmsReceiveShelvesDetailVO> listWhWmsReceiveShelvesDetailVOByCond(WhWmsReceiveShelvesDetailCond cond) {
        return whWmsReceiveShelvesDetailService.listWhWmsReceiveShelvesDetailVOByCond(cond);
    }

    public WhWmsQcProcessDetailVO findWhWmsQcProcessDetailVOByCond(WhWmsQcProcessDetailCond cond) {
        return whWmsReceiveShelvesDetailService.findWhWmsQcProcessDetailVOByCond(cond);
    }

    public List<WhWmsQcProcessDetailVO> listWhWmsQcProcessDetailVOByCond(WhWmsQcProcessDetailCond cond) {
        return whWmsReceiveShelvesDetailService.listWhWmsQcProcessDetailVOByCond(cond);
    }

    public WhWmsQcProcessDetail findWhWmsQcProcessDetailByCond(WhWmsQcProcessDetailCond cond) {
        return whWmsReceiveShelvesDetailService.findWhWmsQcProcessDetailByCond(cond);
    }

    public List<WhWmsQcProcessDetail> listWhWmsQcProcessDetailsByCond(WhWmsQcProcessDetailCond cond) {
        return whWmsReceiveShelvesDetailService.listWhWmsQcProcessDetailsByCond(cond);
    }

    public void purchaseDefectiveProcess(List<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs,Long processUserId) throws Exception {
        whWmsReceiveShelvesDetailService.purchaseDefectiveProcess(receiveShelvesDetailVOs,processUserId);
    }




//    public Boolean createTakeStockPlansGroupByShelves(List<WhWmsSkuStock> skuStocksList,Long userId) {
//        return whWmsTakeStockPlanService.createTakeStockPlansGroupByShelves(skuStocksList,userId);
//    }

//    /**
//     * 驳回盘点(整个库位)
//     * @param shelvesCode
//     */
//    public Boolean refuseInvetoryByShelvesCode(String shelvesCode) {
//        return whWmsTakeStockRcdService.refuseInvetoryByShelvesCode(shelvesCode);
//    }

    public List<WhWmsMoveSkuVO> recommendWmsHouseShelves(List<WhWmsStartPutawayVO> pvoList) {
        return whWmsWaitPutawayService.recommendWmsHouseShelves(pvoList);
    }

    public WhWmsWaitPutawayVO findWhWmsWaitPutawayVOById(Long qcId) {
        return whWmsWaitPutawayService.findById(qcId);
    }

    /**
     * 商品转换
     * */
	public boolean skuTranslate(WhWmsSkuTranslateVO vo) {
		return whWmsSkuTranslateService.skuTranslate(vo);
	}

    /**
     * 检查是否可以绑定分拨箱
     * @param
     * @return
     */
    public Boolean delConnectDistributionBoxNo(Long connectId,String commandCode){
        return whWmsConnectDistributionService.deleteConnectDistribution(connectId,commandCode);
    }
    public List<WhWmsSkuStockRecordVO> findWhWmsStockRecordList(WhWmsSkuStockRecordCond whWmsSkuStockRecordCond){
        return whWmsSkuStockService.findWhWmsStockRecord(whWmsSkuStockRecordCond);
    }
    public int findWhWmsStockRecordCount(WhWmsSkuStockRecordCond whWmsSkuStockRecordCond){
        return whWmsSkuStockService.findWhWmsStockRecordCount(whWmsSkuStockRecordCond);
    }

    public Pagination<PhyWhSkuStockRcdVO> findPhyWhSkuStockRcdByCond(PhyWhSkuStockRcdCond cond){
        return whWmsSkuStockService.findPhyWhSkuStockRcdByCond(cond);
    }

    /**
     * 统计指令数
     * */
    public List<WhCommandCountVO> getCommandOutCountByCond(WhCommandCond cond){
    	return this.whCommandService.getCommandOutCountByCond(cond);
    }

    /**
     * 新增-调拨打包
     * */
    public void addConnectAllotPackage(WhWmsConnectAllotPackageVO vo){
    	whWmsConnectAllotPackageService.add(vo);
    }

    /**
     * 查找-调拨打包
     * */
    public WhWmsConnectAllotPackageVO findConnectAllotPackageById(Long id){
    	return whWmsConnectAllotPackageService.findById(id);
    }
    /**
     * 查找-调拨打包
     * */
	public List<WhWmsConnectAllotPackageVO> findConnectAllotPackageByConnectId(Long connectId){
		return whWmsConnectAllotPackageService.findByConnectId(connectId);
	}

    /**
     * 查找-调拨拆箱
     * */
    public boolean splitAllotPackage(WhWmsConnectAllotPackageVO allotPackage){
        String lockKey = "wms:splitAltPackage:"+allotPackage.getSourceAltPackageId();
        try{
            boolean getLock = redisDistributLock.tryLock(lockKey,10L,TimeUnit.SECONDS);
            if(!getLock){
                throw new WarehouseException(
                        WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "系统繁忙,请稍后重试!");
            }
            return whWmsConnectAllotPackageService.splitAllotPackage(allotPackage);
        }finally {
            redisDistributLock.unLock(lockKey);
        }
    }

	/**
     * 查找-调拨打包
     * */
	public Pagination<WhWmsConnectAllotPackageVO> findConnectAllotPackageByCond(WhConnectAltPackageCond cond){
		return whWmsConnectAllotPackageService.findByCond(cond);
	}

    public List<WhWmsConnectAllotPackageVO> findConnectAltPackageList(WhConnectAltPackageCond cond){
        return whWmsConnectAllotPackageService.findConnectAltPackageList(cond);
    }

    public WhWmsConnectAllotPackageVO findConnectAltPackage(String allotPackageCode){
        return whWmsConnectAllotPackageService.findConnectAltPackage(allotPackageCode);
    }

    public List<WhWmsConnectAllotPackageVO> findMinEstimatedAllocationDate(List<Long> packageIdList){
        return whWmsConnectAllotPackageService.findMinEstimatedAllocationDate(packageIdList);
    }

    public WhWmsConnectAllotPackageVO findConnectBoxsByCond(WhConnectAltPackageCond cond){
        return whWmsConnectAllotPackageService.findConnectBoxsByCond(cond);
    }

    public List<WhWmsConnectAllotPackageVO> findAllotTypeByByCond(WhConnectAltPackageCond cond){
		return whWmsConnectAllotPackageService.findAllotTypeByByCond(cond);
	}

	public boolean submitConnectAltCheck(WhWmsConnectAllotPackageVO packageVO) throws Exception{
		return whWmsConnectInfoService.submitConnectAltCheck(packageVO);
	}


    public List<WhCommandOutCancel> findUnHandleCommand(){
        return whCommandOutCancelService.findUnHandleCommand();
    }

    public boolean insert(WhCommandOutCancel whCommandOutCancel){
        return whCommandOutCancelService.insert(whCommandOutCancel);
    }

    public boolean cancelMakeCommandHandover(WhCommand command,Long operatorId){
        return whCommandOutCancelService.cancelMakeCommandHandover(command,operatorId);
    }

    public List<WhWmsMoveSkuVO> buildMoveStockSku(List<WhCommandSku> commandSkuList,
                                           List<WhWmsConnectPickSkuVO> picSkuList,
                                           WhWmsHouseShelvesVO oriShelves,
                                           WhWmsHouseShelvesVO tarShelves){
        return whCommandOutCancelService.buildMoveStockSku(commandSkuList,picSkuList,oriShelves,tarShelves);
    }

    public List<WhWmsMoveSkuVO> buildMoveStockSkuFormDistribution(WhCommand command,WhWmsHouseShelvesVO oriShelves,
                                                                  WhWmsHouseShelvesVO tarShelves){
        return whCommandOutCancelService.buildMoveStockSkuFormDistribution(command,oriShelves,tarShelves);
    }

    public String cancelMakeCommandOnCheckOut(WhWmsMoveStockVO move,WhCommand command){
        return whCommandOutCancelService.cancelMakeCommandOnCheckOut(move,command);
    }

    public String commandCheckOutByParam(WhWmsCommandCheckPara whWmsCommandCheckPara){
        return whCommandOutCancelService.commandCheckOutByParam(whWmsCommandCheckPara);
    }


    /**
     * 出发取消制单,发送邮件
     * @return
     */
    public Boolean sendMailToNoticeCancelMakeOnHandover(String packageCode){
        try{
            EmailVO emailVO = new EmailVO();
            emailVO.setToAddressList(Arrays.asList(PegasusUtilFacade.getInstance()
                    .findConfigByKey("wms-cancelMake").getConfigValue().split(",")));
            emailVO.setSubject("[取消制单]已触发");
            StringBuffer contentBuffer = new StringBuffer("仓库已处理相应包裹,触发状态:包裹交接");
            contentBuffer.append("</br>");
            contentBuffer.append("包裹:"+packageCode);
            contentBuffer.append("</br>");
            emailVO.setContent(contentBuffer.toString());
            boolean tf = EmailUtil.getInstance().send(emailVO);
            return tf;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }

    }

	/**
	 * 关联快递单号
	 * */
	public boolean associateExpress(WhWmsConnectAllotPackageVO packageVO){
		return whWmsConnectAllotPackageService.associateExpress(packageVO);
	}
    public int findPickCommandCount(Long connectId){
        return whWmsConnectPickSkuService.findPickCommandCount(connectId);
    }

    public  void deleteConnectBox(Long connectId){
        whWmsConnectPickSkuService.deleteConnectBox(connectId);
    }


    public List<WhWmsTaskAssignVO> findWhWmsTaskAssignByCond(WhWmsTaskAssignCond cond){
        return whWmsTaskAssignService.findWhWmsTaskAssignByCond(cond);
    }

    /**
     * 任务指派
     * */
    public WhWmsTaskAssignVO taskAssignAuto(WhWmsTaskAssignReqVO reqVO){
        return whWmsTaskAssignService.taskAssignAuto(reqVO);
    }

    /**
     * 任务领取主动
     * */
    public WhWmsTaskAssignVO taskAssignAsked(WhWmsTaskAssignReqVO reqVO){
        return whWmsTaskAssignService.taskAssignAsked(reqVO);
    }

//    //Inventory start.......
//    public boolean createInventoryPlan(List<WhWmsTakeStockPlanVO> planList){
//        return whWmsInventoryManageService.createInventoryPlan(planList);
//    }
//
//    /**
//     * 保存盘点计划
//     * 除非库位存在待审核
//     * */
//    public boolean createInventoryPlanWithCheck(List<WhWmsTakeStockPlanVO> planList){
//        return whWmsInventoryManageService.insertInventoryPlan(planList);
//    }
//
//    public boolean cancelInventoryPlan(List<Long> planIds){
//        return whWmsInventoryManageService.cancelInventoryPlan(planIds);
//    }
//
//    public WhWmsTakeStockPlanVO getInventoryPlanById(Long planId){
//        return whWmsInventoryManageService.getInventoryPlanById(planId);
//    }
//
//    public Pagination<WhWmsTakeStockPlanVO> getInventoryPlanByCond(WhWmsTakeStockPlanCond cond){
//        return whWmsInventoryManageService.getInventoryPlanByCond(cond);
//    }
//
//    public Pagination<WhWmsTakeStockPlanVO> getInventoryPlanByCondPagination(WhWmsTakeStockPlanCond cond){
//        return whWmsInventoryManageService.getInventoryPlanByCondPagination(cond);
//    }
//
//    /**
//     * 快速盘点
//     * */
//    public boolean inventoryQuick(List<WhWmsTakeStockPlanVO> planList){
//        return whWmsInventoryManageService.inventoryQuick(planList);
//    }
//
//    public void updateWhWmsTakeStockPlanByKey(WhWmsTakeStockPlan whWmsTakeStockPlan){
//        whWmsInventoryManageService.updateWhWmsTakeStockPlanByKey(whWmsTakeStockPlan);
//    }
//    public boolean complateInventoryPlan(List<WhWmsTakeStockPlanVO> planList){
//        return whWmsInventoryManageService.complateInventoryPlan(planList);
//    }
//
//    public boolean complateInventoryPlan(WhWmsTakeStockPlanVO planVO,Long operatorId,WhWmsTaskAssignVO taskAssignVO){
//        return whWmsInventoryManageService.complateInventoryPlan(planVO,operatorId,taskAssignVO);
//    }
//
//    public List<WhWmsTakeStockRcdVO> getInventoryRcdByPlanId(Long planId){
//        return whWmsInventoryManageService.getInventoryRcdByPlanId(planId);
//    }
//
//    public boolean auditInventoryPlan(Long planId,boolean flag,Long operatorId){
//        return whWmsInventoryManageService.auditInventoryPlan(planId,flag,operatorId);
//    }
//
//    public boolean auditInventoryPlan(List<Long> planIds,boolean flag,Long operatorId){
//        return whWmsInventoryManageService.auditInventoryPlan(planIds,flag,operatorId);
//    }
//
//    public List<WhCountVO> countInventoryPlan(Long operatorId, String physicalWarehouseCode){
//        return whWmsInventoryManageService.countInventoryPlan(operatorId,physicalWarehouseCode);
//    }
//
//    public List<WhWmsTakeStockCheckRcdVO> getLastCheckRcd(List<Long> planIdList){
//        return whWmsInventoryManageService.getLastCheckRcd(planIdList);
//    }
    //Inventory end########

    // inventoryV3 start#####

    public List<WhWmsInventoryPlanShelvesVO> findCanInventoryPlanShelvesByCond(WhWmsInventoryPlanShelvesDetailCond cond){
        return whWmsInventoryService.findCanInventoryPlanShelvesByCond(cond);
    }

    public WhWmsInventoryPlanVO findInventoryPlan(Long id,boolean cascade){
        return whWmsInventoryService.findInventoryPlan(id,cascade);
    }

    public List<WhWmsInventoryPlanVO> findInventoryPlan(WhWmsInventoryPlanCond cond){
        return whWmsInventoryService.findInventoryPlan(cond);
    }

    public Pagination<WhWmsInventoryPlanVO> findInventoryPlanPage(WhWmsInventoryPlanCond cond){
        return whWmsInventoryService.findInventoryPlanPage(cond);
    }

    public boolean saveInventoryPlan(WhWmsInventoryPlanVO plan){
        return whWmsInventoryService.saveInventoryPlan(plan);
    }

    public boolean cancelInventoryPlan(Long id){
        return whWmsInventoryService.cancelInventoryPlan(id);
    }

    public Pagination<WhWmsInventoryPlanShelvesVO> findInventoryPlanShelvesByCondPage(WhWmsInventoryPlanShelvesCond cond){
        return whWmsInventoryService.findInventoryPlanShelvesByCondPage(cond);
    }

    public WhWmsInventoryPlanShelvesVO findInventoryPlanShelves(Long planShelvesId,boolean cascade){
        return whWmsInventoryService.findInventoryPlanShelves(planShelvesId,cascade);
    }

    public boolean complateInventoryPlanShelves(WhWmsInventoryPlanShelvesVO planShelves){
        return whWmsInventoryService.complateInventoryPlanShelves(planShelves);
    }

    public Pagination<WhWmsInventoryPlanDiffDetailVO> findInventoryPlanDiffDetailPage(WhWmsInventoryPlanDiffDetailCond cond){
        return whWmsInventoryPlanDiffService.findInventoryPlanDiffDetailPage(cond);
    }

    public List<WhWmsInventoryPlanDiffDetailVO> findInventoryPlanDiffDetail(WhWmsInventoryPlanDiffDetailCond cond){
        return whWmsInventoryPlanDiffService.findInventoryPlanDiffDetail(cond);
    }

    public List<Long> processInventoryPlanDiff(WhWmsInventoryPlanDiffProcessVO processVO){
        return whWmsInventoryPlanDiffService.processInventoryPlanDiff(processVO);
    }

    public List<Long> auditeInventoryPlanDiff(WhWmsInventoryPlanDiffAuditeVO auditeVO){
        return whWmsInventoryPlanDiffService.auditeInventoryPlanDiff(auditeVO);
    }

    public boolean inventoryQuick(List<WhWmsInventoryPlanVO> planList){
        return whWmsInventoryService.inventoryQuick(planList);
    }

    public List<WhCountVO> countInventoryPlan(Long operatorId, String physicalWarehouseCode){
        return whWmsInventoryService.countInventoryPlan(operatorId,physicalWarehouseCode);
    }
    // inventoryV3 end#####

    //波次启动设置 begin###################
    public List<WhWmsConnectStartCountConfigVO> findAllConnectStartCountConfig(){
        return whWmsConnectStartConfigService.findAllConnectStartCountConfig();
    }

    public WhWmsConnectStartCountConfigVO findConnectStartCountConfig(String physicalWarehouseCode){
        return whWmsConnectStartConfigService.findConnectStartCountConfig(physicalWarehouseCode);
    }

    public boolean saveConnectStartCountConfig(WhWmsConnectStartCountConfigVO countConfigVO){
        return whWmsConnectStartConfigService.saveConnectStartCountConfig(countConfigVO);
    }

    public List<WhWmsConnectStartRuleConfigVO> findAllConnectStartRuleConfig(){
        return whWmsConnectStartConfigService.findAllConnectStartRuleConfig();
    }

    public WhWmsConnectStartRuleConfigVO findConnectStartRuleConfig(String physicalWarehouseCode){
        return whWmsConnectStartConfigService.findConnectStartRuleConfig(physicalWarehouseCode);
    }

    public boolean saveConnectStartRuleConfig(WhWmsConnectStartRuleConfigVO ruleConfigVO){
        return whWmsConnectStartConfigService.saveConnectStartRuleConfig(ruleConfigVO);
    }

    public List<WhWmsConnectStartDurationVO> findConnectStartDuration(String physicalWarehouseCode){
        return whWmsConnectStartDurationService.findConnectStartDuration(physicalWarehouseCode);
    }

    public WhWmsConnectStartDurationVO findConnectStartDuration(Long startDurationId){
        return whWmsConnectStartDurationService.findConnectStartDuration(startDurationId);
    }

    public boolean saveConnectStartDuration(WhWmsConnectStartDurationVO startDurationVO){
        return whWmsConnectStartDurationService.saveConnectStartDuration(startDurationVO);
    }

    public boolean delConnectStartDuration(Long startDurationId){
        return whWmsConnectStartDurationService.delConnectStartDuration(startDurationId);
    }

    public List<WhWmsConnectStartForbideRuleVO> findConnectStartForbideRule(String physicalWarehouseCode, boolean cascade){
        return whWmsConnectStartForbideRuleService.findConnectStartForbideRule(physicalWarehouseCode,cascade);
    }

    public WhWmsConnectStartForbideRuleVO findConnectStartForbideRule(Long forbideRuleId, boolean cascade){
        return whWmsConnectStartForbideRuleService.findConnectStartForbideRule(forbideRuleId,cascade);
    }

    public boolean saveConnectStartForbideRule(WhWmsConnectStartForbideRuleVO forbideRuleVO){
        return whWmsConnectStartForbideRuleService.saveConnectStartForbideRule(forbideRuleVO);
    }

    public boolean enableDisableConnectStartForbideRule(Long forbideRuleId,Integer enableOrDisable){
        return whWmsConnectStartForbideRuleService.enableDisableConnectStartForbideRule(forbideRuleId,enableOrDisable);
    }

    public void disableExpireConnectStartForbideRule(){
        whWmsConnectStartForbideRuleService.disableExpireConnectStartForbideRule();
    }

    public List<WhWmsConnectStartRuleVO> findConnectStartRule(String physicalWarehouseCode, Integer ruleType){
        return whWmsConnectStartRuleService.findConnectStartRule(physicalWarehouseCode,ruleType);
    }

    public List<WhWmsConnectStartRuleVO> findConnectStartRule(String physicalWarehouseCode, Integer ruleType, Boolean enableOrNot){
        return whWmsConnectStartRuleService.findConnectStartRule(physicalWarehouseCode,ruleType,enableOrNot);
    }

    public WhWmsConnectStartRuleVO findConnectStartRule(Long ruleId,boolean cascade){
        return whWmsConnectStartRuleService.findConnectStartRule(ruleId,cascade);
    }

    public boolean saveConnectStartRule(WhWmsConnectStartRuleVO startRuleVO){
        return whWmsConnectStartRuleService.saveConnectStartRule(startRuleVO);
    }

    public boolean saveConnectStartRuleForChannel(WhWmsConnectStartRuleVO startRuleVO){
        return whWmsConnectStartRuleService.saveConnectStartRuleForChannel(startRuleVO);
    }

    public boolean saveConnectStartRuleForShelvesArea(WhWmsConnectStartRuleVO shelvesAreaRuleVO){
        return whWmsConnectStartRuleService.saveConnectStartRuleForShelvesArea(shelvesAreaRuleVO);
    }

    public boolean delConnectStartRule(Long startRuleId){
        return whWmsConnectStartRuleService.delConnectStartRule(startRuleId);
    }
    //波次启动设置 edn#####################

    /**
     * ljj 8.15
     * scm收货上架查看所有订单所有收货备注
     * @param
     * @return
     */
    public List<WhWmsWaitPutaway> getAllRemearkByReceiptsNo(String receiptsNo) {
		return whWmsWaitPutawayService.getAllRemearkByReceiptsNo(receiptsNo);
	}

    public List<WhWmsWaitPutawayVO> countQcQuantityByCond(List<String> receiptsNos, Integer inOutType){
        return whWmsWaitPutawayService.countQcQuantityByCond(receiptsNos,inOutType);
    }

    public List<WhWmsWaitPutaway> getAllRemearkByCond(WhWmsWaitPutawayVO cond) {
		return whWmsWaitPutawayService.getAllRemearkByCond(cond);
	}

    public List<WhWmsWaitPutawayVO> findWaitPutawayWasteByCond(WhWmsWaitPutawayVO vo) {
		return whWmsWaitPutawayService.findWaitPutawayWasteByCond(vo);
	}

    public List<WhWmsWaitPutaway> listWaitPutawayByCond(WhWmsWaitPutawayVO vo) {
		return whWmsWaitPutawayService.listWaitPutawayByCond(vo);
	}

	public List<WhWmsSkuStockVO> listExpiryDateSku(WhWmsSkuStockVO cond) {
		return whWmsSkuStockService.listExpiryDateSku(cond);
	}

    public List<WhWmsOperationCountVO> getCountInfoByCond(WhWmsOperationCountCond cond){
        return whWmsOperationRcdService.getCountInfoByCond(cond);
    }

	public boolean vipShip(WhCommand whCommand) {
		return whThirdPartyService.vipShip(whCommand);
	}

    /**
     * 根据条件查找箱号
     * @author eric
     * @param cond
     * @return
     */
    public List<WhWmsBoxNumber> findWmsBoxNumberByCond(WhWmsBoxNumberCond cond){
        return whWmsConnectInfoService.findWmsBoxNumberByCond(cond);
    }

    /**
     * 根据条件查找箱号
     * @author eric
     * @param cond
     * @return
     */
    public List<WhWmsBoxNumberVO> findSingleBoxNumberByCond(WhWmsBoxNumberCond cond){
        return whWmsConnectInfoService.findSingleBoxNumberByCond(cond);
    }
    public int findCountByConnectId(Long connectId){
        return whWmsCommandConnectService.findCountByConnectId(connectId);
    }
    /**
     * 箱号生成
     * @param vo
     * @return
     */
    public WhWmsBoxNumberVO createBoxNumber(WhWmsBoxNumberVO vo) {
        return whWmsConnectInfoService.createBoxNumber(vo);
    }

    /**
     * 箱号更新
     * @param boxMember
     * @return
     */
    public boolean createBoxNumber(WhWmsBoxNumber boxMember) {
        return whWmsConnectInfoService.createBoxNumber(boxMember);
    }


    /**
     * 根据类型获取查询区域信息
     * @param type
     * @return
     */
    public List<WhWmsWarehouseArea> getAreaHouseByType(String type){
        return whWmsWarehouseAreaService.getAreaHouseByType(type);
    }

    public List<WhWmsOutStockRecord> findWhWmsOutStockRecordsByCond(WhWmsOutStockRecordCond cond) {
        return whWmsOutStockRecordService.findWhWmsOutStockRecordsByCond(cond);
    }

    public boolean updateWhWmsOutStockRecordsByCond(WhWmsOutStockRecord record){
        return whWmsOutStockRecordService.updateWhWmsOutStockRecordsByCond(record);
    }

    public boolean updateWhWmsOutStockRecordsByConds(List<WhWmsOutStockRecord> records){
        return whWmsOutStockRecordService.updateWhWmsOutStockRecordsByConds(records);
    }

    public PageInfo<WhWmsConsumableSkuVO> findWmsConsumableSkuByCond(WhWmsConsumableSkuCond cond) {
        return whWmsConsumableService.findWmsConsumableSkuByCond(cond);
    }

    public  List<Integer> batchCreate(List<WhWmsConsumableSkuVO> consumableSkuVOList) {
        return  whWmsConsumableService.batchCreate(consumableSkuVOList);
    }

    public Pagination<WhWmsGradeOfQualityVO> listWhWmsGradeOfQualityVOByCondPage(WhWmsGradeOfQualityCond cond) {
        return whWmsGradeOfQualityService.listWhWmsGradeOfQualityVOByCond(cond);
    }

    public WhWmsGradeOfQualityVO findWhWmsGradeOfQualityVOById(Long id,boolean fetchGradeSku,boolean fetchGradeBarcode) {
        return whWmsGradeOfQualityService.findWhWmsGradeOfQualityVOById(id,fetchGradeSku,fetchGradeBarcode);
    }

    public WhWmsGradeOfQuality findWhWmsGradeOfQualityById(Long id) throws Exception {
        return whWmsGradeOfQualityService.findWhWmsGradeOfQualityById(id);
    }

    public WhWmsGradeOfQualityVO findWhWmsGradeOfQualityVOByCond(WhWmsGradeOfQualityCond cond) {
        return whWmsGradeOfQualityService.findWhWmsGradeOfQualityVOByCond(cond);
    }

    public boolean createWhWmsGradeOfQualityVO(WhWmsGradeOfQualityVO vo) throws Exception{
       return whWmsGradeOfQualityService.create(vo);
    }

    public boolean manualApprovalFlag(WhWmsGradeOfQualityVO vo) throws Exception{
        return whWmsGradeOfQualityService.manualApprovalFlag(vo);
    }

    public boolean approveWhWmsGradeOfQuality(WhWmsGradeOfQualityVO vo) throws Exception{
       return whWmsGradeOfQualityService.approveWhWmsGradeOfQuality(vo);
    }

    public List<WhGradeSalesOrderVO> listSalesOrderByWmsOccupyRefCodes(WhWmsGradeOfQualityCond cond) throws Exception{
       return whWmsGradeOfQualityService.listSalesOrderByWmsOccupyRefCodes(cond);
    }

    public boolean createOrUpdateWhWmsGradeOfQualityVO(WhWmsGradeOfQualityVO vo) throws Exception{
       return whWmsGradeOfQualityService.createOrUpdate(vo);
    }

    public boolean cancelWhWmsGradeOfQuality(WhWmsGradeOfQuality record) throws Exception{
       return whWmsGradeOfQualityService.cancelWhWmsGradeOfQuality(record);
    }

    public WhWarehouse findGradeWarehouseByCond(String phyCode,Integer relateType,Integer skuStatus) throws Exception{
        return whWmsGradeOfQualityService.findGradeWarehouseByCond(phyCode, relateType, skuStatus);
    }

    /**
     * 查询品级调整审批列表
     * @param cond
     * @return
     */
    public Pagination<WhGradeOfQualityVO> pageWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond){
        return whGradeOfQualityService.pageWhGradeOfQualityVOByCond(cond);
    }

    public List<WhGradeOfQualityDetail> listWhGradeOfQualityDetailByCond(WhGradeOfQualityDetailCond cond){
        return whGradeOfQualityService.listWhGradeOfQualityDetailByCond(cond);
    }

    public List<WhGradeAffectInfo> listWhGradeAffectInfoByCond(WhGradeAffectInfoCond cond){
        return whGradeOfQualityService.listWhGradeAffectInfoByCond(cond);
    }

    public List<WhGradeAffectInfoVO> listWhGradeAffectInfoVOByCond(WhGradeAffectInfoCond cond){
        return whGradeOfQualityService.listWhGradeAffectInfoVOByCond(cond);
    }

    public boolean updateWhGradeAffectInfo(WhGradeAffectInfo affectInfo){
        return whGradeOfQualityService.updateWhGradeAffectInfo(affectInfo);
    }

    public void gradeAdjustApplySendMail(final List<WhGradeOfQualityVO> whGradeVOs){
        whGradeOfQualityService.gradeAdjustApplySendMail(whGradeVOs);
    }

    public void stockOutByGradeAdjustSendMail(final WhGradeOfQualityVO whGradeVO,final List<WhGradeAffectInfoVO> affectInfoVOs){
        whGradeOfQualityService.stockOutByGradeAdjustSendMail(whGradeVO,affectInfoVOs);
    }

    public void sendMailStockOutByGradeAdjust(final WhGradeOfQualityVO whGradeVO,final List<WhGradeAffectInfoVO> affectInfoVOs,Map<String,WhGradeAffectInfoVO> waitSendEmailMap){
        whGradeOfQualityService.sendMailStockOutByGradeAdjust(whGradeVO,affectInfoVOs,waitSendEmailMap);
    }

    public void sendStockOutEmailForGradeAdjust(List<String> toAddressList,String emailContent,List<Long> affectIds) {
        whGradeOfQualityService.sendStockOutEmailForGradeAdjust(toAddressList,emailContent,affectIds);
    }

    public void orderExceptionByGradeAdjustSendMail(final WhGradeOfQualityVO whGradeVO,final List<WhGradeAffectInfoVO> affectInfoVOs){
        whGradeOfQualityService.orderExceptionByGradeAdjustSendMail(whGradeVO,affectInfoVOs);
    }

    public void sendMailOrderExceptionByGradeAdjust(final WhGradeOfQualityVO whGradeVO,final List<WhGradeAffectInfoVO> affectInfoVOs,
                                                    Map<String,WhGradeAffectInfoVO> waitSendEmailMap){
        whGradeOfQualityService.sendMailOrderExceptionByGradeAdjust(whGradeVO,affectInfoVOs,waitSendEmailMap);
    }

    public void sendOrderExceptionEmailForGradeAdjust(List<String> toAddressList,String emailContent,List<Long> affectIds) {
        whGradeOfQualityService.sendOrderExceptionEmailForGradeAdjust(toAddressList,emailContent,affectIds);
    }

    public void stockChangeByGradeAdjustSendMail(final WhGradeOfQualityVO whGradeVO,final List<WhGradeAffectInfoVO> affectInfoVOs){
        whGradeOfQualityService.stockChangeByGradeAdjustSendMail(whGradeVO,affectInfoVOs);
    }

    public void sendMailStockChangeByGradeAdjust(final WhGradeOfQualityVO whGradeVO,final List<WhGradeAffectInfoVO> affectInfoVOs,
                                                 Map<String,WhGradeAffectInfoVO> waitSendEmailMap) {
        whGradeOfQualityService.sendMailStockChangeByGradeAdjust(whGradeVO,affectInfoVOs,waitSendEmailMap);
    }

    public void sendStockChangeEmailForGradeAdjust(List<String> toAddressList,String emailContent,List<Long> affectIds) {
        whGradeOfQualityService.sendStockChangeEmailForGradeAdjust(toAddressList,emailContent,affectIds);
    }

    public WhGradeOfQualityVO findWhGradeOfQualityVOById(Long id, WhGradeOfQualityCond cond){
        return whGradeOfQualityService.findWhGradeOfQualityVOById(id,cond);
    }

    public WhGradeOfQualityVO findWhGradeOfQualityVOById(Long id){
        return findWhGradeOfQualityVOById(id,new WhGradeOfQualityCond());
    }

    public WhGradeOfQualityVO findWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond){
        return whGradeOfQualityService.findWhGradeOfQualityVOByCond(cond);
    }

    public List<WhGradeOfQualityVO> listWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond){
        return whGradeOfQualityService.listWhGradeOfQualityVOByCond(cond);
    }

    public List<WhGradeOfQualityVO> listWhGradeOfQualityVOsByCond(WhGradeOfQualityCond cond){
        return whGradeOfQualityService.listWhGradeOfQualityVOsByCond(cond);
    }

    public List<WhGradeOfQuality> listWhGradeOfQualityByCond(WhGradeOfQualityCond cond){
        return whGradeOfQualityService.listWhGradeOfQualityByCond(cond);
    }

    public boolean createWhGradeOfQualityVO(WhGradeOfQualityVO vo) throws Exception{
        return whGradeOfQualityService.create(vo);
    }

    public boolean updateWhGradeOfQualityVO(WhGradeOfQualityVO vo) throws Exception{
        return whGradeOfQualityService.update(vo);
    }

    public boolean createOrUpdateWhGradeOfQualityVO(WhGradeOfQualityVO vo) throws Exception{
        return whGradeOfQualityService.createOrUpdate(vo);
    }

    public boolean auditWhGradeOfQuality(WhGradeOfQualityVO vo) throws Exception{
        return whGradeOfQualityService.auditWhGradeOfQuality(vo);
    }

    public List<Long> batchAuditWhGradeOfQuality(List<WhGradeOfQualityVO> gradeOfQualityVOs,Long approveUserId) throws Exception{
        return whGradeOfQualityService.batchAuditWhGradeOfQuality(gradeOfQualityVOs,approveUserId);
    }

    public boolean batchCreateWhGradeAndFetch(List<WhGradeOfQualityVO> vos) throws Exception{
        return whGradeOfQualityService.batchCreateWhGradeAndFetch(vos);
    }

    public boolean updateWhGradeOfQualityDetail(WhGradeOfQualityDetail whGradeDetail){
        return whGradeOfQualityService.updateWhGradeOfQualityDetail(whGradeDetail);
    }

    public boolean batchCreateWhGradeOfQuality(List<WhGradeOfQuality> gradeOfQualitys){
        return whGradeOfQualityService.batchCreateWhGradeOfQuality(gradeOfQualitys);
    }

    public boolean batchCreateWhGradeOfQualityDetail(List<WhGradeOfQualityDetail> gradeOfQualityDetails){
        return whGradeOfQualityService.batchCreateWhGradeOfQualityDetail(gradeOfQualityDetails);
    }

    public boolean batchDeleteWhGradeOfQualityDetailByCond(WhGradeOfQualityDetailCond cond){
        return whGradeOfQualityService.batchDeleteWhGradeOfQualityDetailByCond(cond);
    }

    /**
     * 批量删除可领用SKU
     * @param skuCodes
     */
    public void batchDeleteConsumableSku(List<String> skuCodes) {
        whWmsConsumableService.batchDeleteConsumableSku(skuCodes);
    }

    /**
     * 查询可用的 耗材SKU
     * @param skuCodeOrName
     * @return
     */
   public List<PcsSkuSimpleVO> findConsumableSkuByCodeOrName(String skuCodeOrName) {
     return   whWmsConsumableService.findConsumableSkuByCodeOrName(skuCodeOrName);
   }

    public List<String> findBySkuCodes(List<String> skuCodes) {
       return whWmsConsumableService.findBySkuCodes(skuCodes);
    }


    public boolean insertWhExpressWaybill(WhExpressWaybill whExpressWaybill) {
        return whExpressWaybillService.insert(whExpressWaybill);
    }

    public boolean deleteWhExpressWaybillById(Long id) {
        return whExpressWaybillService.deleteById(id);
    }

    public boolean deleteWhExpressWaybillByCond(WhExpressWaybillCond cond) {
        return whExpressWaybillService.deleteByCond(cond);
    }

    public boolean updateWhExpressWaybillByCond(WhExpressWaybill whExpressWaybill,WhExpressWaybillCond cond) {
        return whExpressWaybillService.updateByCond(whExpressWaybill, cond);
    }

    public boolean updateWhExpressWaybillById(WhExpressWaybill whExpressWaybill) {
        return whExpressWaybillService.updateById(whExpressWaybill);
    }

    public WhExpressWaybill findById(Long id) {
        return whExpressWaybillService.findById(id);
    }

    public List<WhExpressWaybill> findWhExpressWaybillByCond(WhExpressWaybillCond cond) {
        return whExpressWaybillService.findWhExpressWaybillByCond(cond);
    }

    public List<WhExpressWaybillVO> listWhExpressWaybillByCond(WhExpressWaybillCond cond) {
        return whExpressWaybillService.listWhExpressWaybillByCond(cond);
    }

    public Pagination<WhExpressWaybillVO> listWhExpressWaybillByCondPage(WhExpressWaybillCond cond) {
        return whExpressWaybillService.listWhExpressWaybillByCondPage(cond);
    }

    public boolean batchCreateWhExpressWaybill(List<WhExpressWaybillVO> whExpressWaybillVOs) {
        return whExpressWaybillService.batchCreate(whExpressWaybillVOs);
    }

    public Pagination<WhWmsReplenishRuleVO> pageWhWmsReplenishRuleVOByCond(WhWmsReplenishRuleCond cond){
        return whWmsReplenishRuleService.pageWhWmsReplenishRuleVOByCond(cond);
    }

    public List<WhWmsReplenishRuleVO> listWhWmsReplenishRuleVOByCond(WhWmsReplenishRuleCond cond){
        return whWmsReplenishRuleService.listWhWmsReplenishRuleVOByCond(cond);
    }

    public List<WhWmsReplenishRule> listWhWmsReplenishRuleByCond(WhWmsReplenishRuleCond cond){
        return whWmsReplenishRuleService.listWhWmsReplenishRuleByCond(cond);
    }

    public WhWmsReplenishRule findWhWmsReplenishRuleByPhyCode(String phyCode){
        return whWmsReplenishRuleService.findWhWmsReplenishRuleByPhyCode(phyCode);
    }

    public String replenishInfoGenerateByCond(WhWmsReplenishInfoCond cond) throws Exception{
        return whWmsReplenishRuleService.replenishInfoGenerateByCond(cond);
    }

    public WhWmsReplenishRuleVO findWhWmsReplenishRuleVOByPhyCode(String phyCode){
        WhWmsReplenishRuleCond cond = new WhWmsReplenishRuleCond();
        cond.setPhysicalWarehouseCode(phyCode);
        List<WhWmsReplenishRuleVO> replenishRuleVOs = listWhWmsReplenishRuleVOByCond(cond);
        if (CollectionUtils.isNotEmpty(replenishRuleVOs)){
            return replenishRuleVOs.get(0);
        }
        return null;
    }

    public WhWmsReplenishRule findWhWmsReplenishRuleById(Long id){
        return whWmsReplenishRuleService.findWhWmsReplenishRuleById(id);
    }

    public WhWmsReplenishRuleVO findWhWmsReplenishRuleVOById(Long id,boolean fetchHouse,boolean fetchBlack){
        return whWmsReplenishRuleService.findWhWmsReplenishRuleVOById(id,fetchHouse,fetchBlack);
    }

    public WhWmsReplenishRuleVO findWhWmsReplenishRuleVOByPhyCode(String phyCode,boolean fetchHouse,boolean fetchBlack){
        return whWmsReplenishRuleService.findWhWmsReplenishRuleVOByPhyCode(phyCode,fetchHouse,fetchBlack);
    }

    public List<WhWmsReplenishRuleVO> listPcsSkuVOsByCond(WhWmsReplenishRuleCond cond){
        return whWmsReplenishRuleService.listPcsSkuVOsByCond(cond);
    }

    public WhWmsReplenishRuleVO saveOrUpdateWhWmsReplenishRuleVO(WhWmsReplenishRuleVO replenishRuleVO){
        return whWmsReplenishRuleService.saveOrUpdateWhWmsReplenishRuleVO(replenishRuleVO);
    }

    public List<WhWmsReplenishRuleBlacklistVO> listWhWmsReplenishRuleBlacklistVOByRuleId(Long ruleId){
        return whWmsReplenishRuleService.listWhWmsReplenishRuleBlacklistVOByRuleId(ruleId);
    }

    public List<WhWmsReplenishRuleHousetypeVO> listWhWmsReplenishRuleHousetypeVOByRuleId(Long ruleId){
        return whWmsReplenishRuleService.listWhWmsReplenishRuleHousetypeVOByRuleId(ruleId);
    }

    public Pagination<WhWmsReplenishInfoVO> pageWhWmsReplenishInfoVOByCond(WhWmsReplenishInfoCond cond){
        return whWmsReplenishInfoService.pageWhWmsReplenishInfoVOByCond(cond);
    }

    public List<WhWmsReplenishInfoVO> listWhWmsReplenishInfoVOByCond(WhWmsReplenishInfoCond cond){
        return whWmsReplenishInfoService.listWhWmsReplenishInfoVOByCond(cond);
    }

    public List<WhWmsReplenishInfo> listWhWmsReplenishInfoByCond(WhWmsReplenishInfoCond cond){
        return whWmsReplenishInfoService.listWhWmsReplenishInfoByCond(cond);
    }

    public WhWmsReplenishInfo findWhWmsReplenishInfoById(Long id){
        return whWmsReplenishInfoService.findWhWmsReplenishInfoById(id);
    }

    public WhWmsReplenishInfoVO findWhWmsReplenishInfoVOById(Long id){
        return whWmsReplenishInfoService.findWhWmsReplenishInfoVOById(id);
    }

    public WhWmsReplenishInfoVO saveOrUpdateWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishInfoVO){
        return whWmsReplenishInfoService.saveOrUpdateWhWmsReplenishInfoVO(replenishInfoVO);
    }

    public boolean batchSaveWhWmsReplenishInfo(List<WhWmsReplenishInfo> replenishInfos){
        return whWmsReplenishInfoService.batchSaveWhWmsReplenishInfo(replenishInfos);
    }

    public String batchSaveWhWmsReplenishInfoVO(List<WhWmsReplenishInfoVO> replenishInfoVOs) throws Exception{
        WhWmsBatchReplenishInfoVO batchReplenishInfo = new WhWmsBatchReplenishInfoVO();
        batchReplenishInfo.setReplenishInfoList(replenishInfoVOs);
        batchReplenishInfo.setAutoReplenish(false);
        return whWmsReplenishInfoService.batchSaveWhWmsReplenishInfoVO(batchReplenishInfo);
    }

    public String createReplenishMoveStock(WhWmsReplenishInfoCond cond) throws Exception{
        return whWmsReplenishInfoService.createReplenishMoveStock(cond);
    }

    public boolean saveWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishInfoVO){
        return whWmsReplenishInfoService.saveWhWmsReplenishInfoVO(replenishInfoVO);
    }

    public boolean updateWhWmsReplenishInfoVO(WhWmsReplenishInfoVO replenishInfoVO){
        return whWmsReplenishInfoService.updateWhWmsReplenishInfoVO(replenishInfoVO);
    }

    public Map<String,Boolean> usedSupplierAndEffectiveGoods(List<String> skuCodes) {
        return whWmsReplenishInfoService.usedSupplierAndEffectiveGoods(skuCodes);
    }

    public String buildAndCreateMoveStock(WhWmsReplenishInfo replenishInfo, Map<String, Boolean> skuBooleanMap, WhWmsReplenishInfoCond cond) throws WarehouseException{
        return whWmsReplenishInfoService.buildAndCreateMoveStock(replenishInfo, skuBooleanMap, cond);
    }
}
