/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrderSubmitResponse;
import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;
import com.thebeastshop.pegasus.util.vo.JdStockSyncResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import page.Pagination;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * @author Royan
 * @version $Id: PegasusWarehouseServiceFacade.java, v 0.1 2015-07-01 下午3:00
 */
public class PegasusWarehouseServiceFacade {

    private final static Logger LOGGER = LoggerFactory.getLogger(PegasusWarehouseServiceFacade.class);

    private static PegasusWarehouseServiceFacade instance;

    @Autowired
    private WhAllotService whAllotService;

    @Autowired
    private WhCommandService whCommandService;
    
    @Autowired
    private OffSpotGoodsService offSpotGoodsService;

    @Autowired
    private WhDamageWasteService whDamageWasteService;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private WhInvService whInvService;

    @Autowired
    private WhInventoryService whInventoryService;

    @Autowired
    private WhTakeStockService whTakeStockService;

    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    
    @Autowired
	private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhWmsConnectPickSkuService whWmsConnectPickSkuService;

    @Autowired
    private WhCustomizatonParamService whCustomizatonParamService;

    @Autowired
    private WhWarehouseGroupService whWarehouseGroupService;

    @Autowired
    private WhJitPackageSkuReferenceService whJitPackageSkuReferenceService;

    @Autowired
    private WhJitPackageSendMailService whJitPackageSendMailService;

    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;

    @Autowired
    private WhWmsPrdcMaterialDetailService whWmsPrdcMaterialDetailService;

    @Autowired
    private WhWmsTaskAssignService whWmsTaskAssignService;

    @Autowired
    private WhAutoAllotService whAutoAllotService;

    @Autowired
    private WhCrossGoodsService whCrossGoodsService;

    @Autowired
    private TmallStockLogService tmallStockLogService;

    @Autowired
    private WhBondedWarehouseAllotApplyService whBondedWarehouseAllotApplyService;

    @Autowired
    private WhTlBuyerPackageService whTlBuyerPackageService;

    @Autowired
    private RedisDistributLock redisDistributLock;

    @Autowired
    private WhAllotStoreApplicationService whAllotStoreApplicationService;

    private PegasusWarehouseServiceFacade() {

    }

    public static PegasusWarehouseServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }

        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                LOGGER.info("[fasade init start] PegasusWarehouseServiceFacade");
                new ClassPathXmlApplicationContext("pegasus-service-warehouse/spring.xml");
                LOGGER.info("[fasade init finish] PegasusWarehouseServiceFacade");
            }
            instance = (PegasusWarehouseServiceFacade) SpringUtil.getBean("pegasusWarehouseServiceFacade");
        }
        return instance;
    }

    /**
     * 创建物理仓
     *
     * @param whPhysicalWarehouse 物理仓
     * @return 物理仓编码
     */
    public String createPhysicalWarehouse(final WhPhysicalWarehouse whPhysicalWarehouse) {
        return whInfoService.createPhysicalWarehouse(whPhysicalWarehouse);
    }

    /**
     * 更新物理仓
     *
     * @param whPhysicalWarehouse 物理仓
     * @return 是否成功
     */
    public boolean updatePhysicalWarehouse(final WhPhysicalWarehouse whPhysicalWarehouse) {
        return whInfoService.updatePhysicalWarehouse(whPhysicalWarehouse);
    }

    /**
     * 根据编码更新物理仓
     *
     * @param code 编码
     * @param whPhysicalWarehouse 物理仓
     * @return 是否成功
     */
    public boolean updatePhysicalWarehouseByCode(final String code, final WhPhysicalWarehouse whPhysicalWarehouse) {
        return whInfoService.updatePhysicalWarehouseByCode(code, whPhysicalWarehouse);
    }
    public WhWmsExpressInfo findExpressInfoById(Long id){
        return whInfoService.findExpressInfoById(id);
    };
    /**
     * 删除物理仓
     *
     * @param whPhysicalWarehouse 物理仓
     * @return 是否成功
     */
    public boolean deletePhysicalWarehouse(final WhPhysicalWarehouse whPhysicalWarehouse) {
        return whInfoService.deletePhysicalWarehouse(whPhysicalWarehouse);
    }

    /**
     * 根据编码查找物理仓
     *
     * @param code 物理仓编码
     * @return 物理仓
     */
    public WhPhysicalWarehouse findPhysicalWarehouseByCode(final String code) {
        return whInfoService.findPhysicalWarehouseByCode(code);
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByDistrict(List<Long> districtIds){
        return whInfoService.findPhysicalWarehouseByDistrict(districtIds);
    }

    /**
     * 根据物理仓编码 查询 物理仓及所属逻辑仓分组
     * @param code 物理仓编码
     * @return
     */
    public WhPhysicalWarehouseVO findPhysicalWarehouseVOAndWarehouseGroupByPhyCode(final String code) {
        return whInfoService.findPhysicalWarehouseVOAndWarehouseGroupByPhyCode(code);
    }
    public WhPhysicalWarehouse findPhysicalWarehouseById(Long id) {
        return whInfoService.findPhysicalWarehouseById(id);
    }

    public List<WhPhysicalWarehouse> listPhysicalWarehouseByIds(List<Long> ids) {
        return whInfoService.listPhysicalWarehouseByIds(ids);
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByNameCode(String nameOrCode){
        return whInfoService.findPhysicalWarehouseByNameCode(nameOrCode);
    }
    public List<WhPhysicalWarehouse> findNewPhysicalWarehouseByNameOrCode(String nameOrCode){
        return whInfoService.findNewPhysicalWarehouseByNameOrCode(nameOrCode);
    }
    /**
     * 查找所有物理仓（含禁用）
     *
     * @return 物理仓列表
     */
    public List<WhPhysicalWarehouse> findAllPhysicalWarehouse() {
        return whInfoService.findAllPhysicalWarehouse();
    }

    public Map<String, WhPhysicalWarehouseVO> findAllPhysicalWarehouseMap(){
        return whInfoService.findAllPhysicalWarehouseMap();
    }

    /**
     * 根据条件查询物理仓
     * @param whPhysicalWarehouseVO
     * @return 物理仓列表
     */
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByCond(WhPhysicalWarehouseVO whPhysicalWarehouseVO) {
        return whInfoService.findPhysicalWarehouseByCond(whPhysicalWarehouseVO);
    }


    public List<WhPhysicalWarehouseVO> listOffLinePhysicalWarehouse(WhPhysicalWarehouseVO whPhysicalWarehouseVO) {
        return whInfoService.listOffLinePhysicalWarehouse(whPhysicalWarehouseVO);
    }

    public List<WhDistrictPhysicalWarehouseVO> findDistrictPyWarehouseByExample(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO) {
        return whInfoService.findDistrictPyWarehouseByExample(whDistrictPhysicalWarehouseVO);
    }

    public List<WhDistrictPhysicalWarehouseVO> listDistrictPyWarehouseByCond(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO) {
        return whInfoService.listDistrictPyWarehouseByCond(whDistrictPhysicalWarehouseVO);
    }

    public boolean batchInsertDistrictPyWarehouse(List<WhDistrictPhysicalWarehouseVO> whDistrictPhysicalWarehouseVOs) {
        return whInfoService.batchInsertDistrictPyWarehouse(whDistrictPhysicalWarehouseVOs)>0;
    }

    public boolean deleteDistrictPyWarehouseByExample(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO) {
        return whInfoService.deleteDistrictPyWarehouseByExample(whDistrictPhysicalWarehouseVO)>0;
    }

    /**
     * 查找所有可用物理仓
     *
     * @return 物理仓列表
     */
    public List<WhPhysicalWarehouse> findPhysicalWarehouse() {
        return whInfoService.findPhysicalWarehouse();
    }

    /**
     * 创建逻辑仓
     *
     * @param whPhysicalWarehouse 物理仓 不再使用
     * @param whWarehouse 逻辑仓
     * @return 逻辑仓编码
     */
    public String createWarehouse(final WhPhysicalWarehouse whPhysicalWarehouse, final WhWarehouse whWarehouse) {
        return whInfoService.createWarehouse(whPhysicalWarehouse, whWarehouse);
    }

    /**
     * 更新逻辑仓
     *
     * @param whWarehouse 逻辑仓
     * @return 是否成功
     */
    public boolean updateWarehouse(final WhWarehouse whWarehouse) {
        return whInfoService.updateWarehouse(whWarehouse);
    }

    /**
     * 根据编码更新逻辑仓
     *
     * @param code 逻辑仓编码
     * @param whWarehouse 逻辑仓
     * @return 是否成功
     */
    public boolean updateWarehouseByCode(final String code, final WhWarehouse whWarehouse) {
        return whInfoService.updateWarehouseByCode(code, whWarehouse);
    }

    /**
     * 删除逻辑仓
     *
     * @param whWarehouse 逻辑仓
     * @return 是否成功
     */
    public boolean deleteWarehouse(final WhWarehouse whWarehouse) {
        return whInfoService.deleteWarehouse(whWarehouse);
    }

    /**
     * 根据编码查找逻辑仓
     *
     * @param code 逻辑仓编码
     * @return 逻辑仓
     */
    public WhWarehouse findWarehouseByCode(final String code) {
        return whInfoService.findWarehouseByCode(code);
    }

    public WhWarehouseVO findWarehouseAndGroupByWarehouseCode(final String code) {
        return whInfoService.findWarehouseAndGroupByWarehouseCode(code);
    }

    public List<WhWarehouseVO> findWarehouseAndGroupByWarehouseCodes(List<String> warehouseCodes) {
        return whInfoService.findWarehouseAndGroupByWarehouseCodes(warehouseCodes);
    }

    /**
     * 根据编码列表查找逻辑仓
     *
     * @param codes 逻辑仓编码列表
     * @return 逻辑仓列表
     */
    public List<WhWarehouse> findWarehouseByCodes(final List<String> codes) {
        return whInfoService.findWarehouseByCodes(codes);
    }

    public Map<String,WhWarehouseVO> findWarehouseMapByCodes(List<String> codes){
        return whInfoService.findWarehouseMapByCodes(codes);
    }

    public WhWarehouse findDefaultInWarehouseByPhyWhCodeAndCommodityStatus(String phyCode, Integer commodityStatus){
        return whInfoService.findDefaultInWarehouseByPhyWhCodeAndCommodityStatus(phyCode, commodityStatus);
    }

    public WhWarehouse findDefaultOutWarehouseByPhyWhCodeAndCommodityStatus(String phyCode, Integer commodityStatus){
        return whInfoService.findDefaultOutWarehouseByPhyWhCodeAndCommodityStatus(phyCode, commodityStatus);
    }

    /**
     * 根据条件查找逻辑仓
     *
     * @param cond 条件
     * @return 逻辑仓列表
     */
    public List<WhWarehouse> findWarehouseByCond(final WhWarehouseCond cond) {
        return whInfoService.findWarehouseByCond(cond);
    }

    /**
     * 根据名字/编码和类型查找逻辑仓
     *
     * @param nameOrCode 名字/编码
     * @param warehouseType 类型
     * @return 逻辑仓列表
     */
    public List<WhWarehouse> findWarehouseByNameCodeAndType(final String nameOrCode, final Integer warehouseType) {
        return whInfoService.findWarehouseByNameCodeAndType(nameOrCode, warehouseType);
    }

    @Deprecated
    public List<WhWarehouse> findWarehouseByNameAndWaitForDispatchingFilter(final String nameOrCode, final Integer filterRuleType) {
        return whInfoService.findWarehouseByNameAndWaitForDispatchingFilter(nameOrCode, filterRuleType);
    }

    /**
     * 根据名字/编码和类型查找逻辑仓
     *
     * @param nameOrCode 名字/编码
     * @return 逻辑仓列表
     */
    public List<WhWarehouse> findWarehouseByNameCode(final String nameOrCode) {
        return whInfoService.findWarehouseByNameCode(nameOrCode);
    }

    public List<WhWarehouse> findGroupWarehouseByNameCode(String nameOrCode, String physicalWarehouseCode,Boolean noPage){
        return whInfoService.findGroupWarehouseByNameCode(nameOrCode,physicalWarehouseCode,noPage);
    }

    /**
     * 根据逻辑仓查找物理仓
     * 逻辑仓物理仓关联关系先通过逻辑仓分组关联
     * @param warehouseCode 逻辑仓编码
     * @return 物理仓列表
     */
    @Deprecated
    public WhPhysicalWarehouse findPhysicalWarehouseByWarehouse(final String warehouseCode) {
        return whInfoService.findPhysicalWarehouseByWarehouse(warehouseCode);
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByWarehouseCodes(final Set<String> warehouseCodeSet) {
        return whInfoService.findPhysicalWarehouseByWarehouseCodes(warehouseCodeSet);
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByWarehouseCodesNew(final Set<String> warehouseCodeSet) {
        return whInfoService.findPhysicalWarehouseByWarehouseCodesNew(warehouseCodeSet);
    }

    /**
     * 根据仓库编码查找同物理仓下唯一的良品待分配仓
     *
     * @param warehouseCode
     * @return
     */
    @Deprecated
    public WhWarehouse findUniqWaitForDispatchingWarehouse(final String warehouseCode) {
        return whInfoService.findUniqWaitForDispatchingWarehouse(warehouseCode);
    }

    /**
     * 根据仓库编码查找同物理仓下唯一的残次仓
     *
     * @param warehouseCode
     * @return
     */
    public WhWarehouse findUniqDamagedWarehouse(final String warehouseCode) {
        return whInfoService.findUniqDamagedWarehouse(warehouseCode);
    }

    /**
     * 根据仓库编码查找同物理仓下唯一的报废仓
     *
     * @param warehouseCode
     * @return
     */
    public WhWarehouse findUniqWastedWarehouse(final String warehouseCode) {
        return whInfoService.findUniqWastedWarehouse(warehouseCode);
    }

    /**
     * 自动处理库位状态
     */
    public void autoProcessShelvesStatus(){
        whWmsConnectPickSkuService.autoProcessShelvesStatus();
    }
    /**
     * 根据仓库编码查找同物理仓下唯一的生产加工仓
     *
     * @param warehouseCode
     * @return
     */
    public WhWarehouse findUniqProducingWarehouse(final String warehouseCode) {
        return whInfoService.findUniqProducingWarehouse(warehouseCode);
    }

    /**
     * 判断两个是否在同一物理仓
     *
     * @param warehouseCode1 逻辑仓1
     * @param warehouseCode2 逻辑仓2
     * @return
     */
    public boolean isInSamePhysicalWarehouse(final String warehouseCode1, final String warehouseCode2) {
        return whInfoService.isInSamePhysicalWarehouse(warehouseCode1, warehouseCode2);
    }

    public boolean isWarehouseInSameWarehouseGroup(final String warehouseCode1, final String warehouseCode2){
        return whInfoService.isWarehouseInSameWarehouseGroup(warehouseCode1, warehouseCode2);
    }

    /**
     * 判断两个是否库间移动（瞬间完成）
     *
     * @param warehouseCode1 逻辑仓1
     * @param warehouseCode2 逻辑仓2
     * @return
     */
    public boolean isWarehouseMove(final String warehouseCode1, final String warehouseCode2) {
        return whInfoService.isWarehouseMove(warehouseCode1, warehouseCode2);
    }


    /**
     * 通过物理仓（可有可无）  和  逻辑仓类型(可有可无)   查询逻辑仓结果
     * @param pyhialCode 物理仓 code
     * @param type   逻辑仓类型  1良品待分配仓2残次品仓3废品仓4礼品仓5样品仓6生产加工仓9渠道销售仓
     * @auhtor lijing
     * @return
     */
    @Deprecated
    public List<WhWarehouse> findWarehouseByPhysicalCodeAndStatusTmp(String pyhialCode,Integer type){
        return whInfoService.findWarehouseByPhysicalCodeAndStatus(pyhialCode,type);
    }

    /**
     * 通过物理仓——》逻辑仓分组——》当前商品状态的逻辑仓
     * @param pyhialCode 物理仓
     * @param commodityStatus 逻辑仓商品状态
     * @return
     */
    @Deprecated
    public List<WhWarehouse> findWarehouseByPhysicalCodeAndStatus(String pyhialCode,Integer commodityStatus){
        return whInfoService.findWarehouseByPhysicalCodeAndStatus(pyhialCode,commodityStatus);
    }

    public List<WhWarehouse> findAllWarehousesByPhyCodeAndStatus(String pyhialCode,Integer commodityStatus,Integer relateType){
        return whInfoService.findAllWarehousesByPhyCodeAndStatus(pyhialCode,commodityStatus,relateType);
    }

    public List<WhWarehouse> listWarehousesByPhyCodeAndStatusFromGroup(String pyhialCode,Integer commodityStatus){
        return whInfoService.listWarehousesByPhyCodeAndStatusFromGroup(pyhialCode,commodityStatus);
    }

    public WhWarehouse findDefaultInNondefectiveWarehouseByPhyWhCode(String physicalWarehouseCode){
        return whInfoService.findDefaultInNondefectiveWarehouseByPhyWhCode(physicalWarehouseCode);
    }

    public WhWarehouse findDefaultOutNondefectiveWarehouseByPhyWhCode(String physicalWarehouseCode){
        return whInfoService.findDefaultOutNondefectiveWarehouseByPhyWhCode(physicalWarehouseCode);
    }

    public WhWarehouse findDefaultInDefectiveWarehouseByPhyWhCode(String physicalWarehouseCode){
        return whInfoService.findDefaultInDefectiveWarehouseByPhyWhCode(physicalWarehouseCode);
    }

    /**
     * 根据查找物理仓下唯一的良品待分配仓
     *
     * @param pyhialCode
     * @return
     */
    @Deprecated
    public WhWarehouse findPhyWhUniqWaitForDispatchingWarehouse(final String pyhialCode) {
        // List<WhWarehouse> whWarehouseList = whInfoService.findWarehouseByPhysicalCodeAndStatus(pyhialCode,WhWarehouseVO.TYPE_WAIT_FOR_DISPATCHING);
        List<WhWarehouse> whWarehouseList = whInfoService.findWarehouseByPhysicalCodeAndStatus(pyhialCode,WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        if(EmptyUtil.isEmpty(whWarehouseList) || whWarehouseList.size() > 1){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"同物理仓只能有一个当前类型的逻辑仓");
        }
        return whWarehouseList.get(0);
    }


    public List<WhWarehouseGroupVO> findWarehouseGroupByCond(WhWarehouseGroupCond cond, boolean cascade){
        return whWarehouseGroupService.findByCond(cond,cascade);
    }

    public List<WhWarehouseGroupVO> findWarehouseGroupByWhCodes(WhWarehouseGroupCond cond){
        return whWarehouseGroupService.findWarehouseGroupByWhCodes(cond);
    }

    public WhWarehouseGroupVO findWarehouseGroupByWhCode(String warehouseCode,boolean cascade){
        return whWarehouseGroupService.findWarehouseGroupByWhCode(warehouseCode,cascade);
    }

    public WhWarehouseGroupVO findWarehouseGroupByPhyWhCode(String phyWhCode,boolean cascade){
        return whWarehouseGroupService.findWarehouseGroupByPhyWhCode(phyWhCode,cascade);
    }

    public Pagination<WhWarehouseGroupVO> findWarehouseGroupByCondPage(WhWarehouseGroupCond cond){
        return whWarehouseGroupService.findByCondPage(cond);
    }

    public Map<Long,WhWarehouseGroupVO> findAllWarehouseGroupMap(boolean cascade){
        return whWarehouseGroupService.findAllMap(cascade);
    }

    public Map<String,WhWarehouseGroupVO> findWhGroupMap(List<String> relateWarehouseCodes){
        return whWarehouseGroupService.findWhGroupMap(relateWarehouseCodes);
    }

    public List<WhWarehouseGroupVO> findAllWarehouseGroup(boolean cascade){
        return whWarehouseGroupService.findAll(cascade);
    }

    public WhWarehouseGroupVO findWarehouseGroupById(Long id,boolean cascade){
        return whWarehouseGroupService.findById(id,cascade);
    }

    public boolean saveOrUpdateWarehouseGroup(WhWarehouseGroupVO groupVO){
        return whWarehouseGroupService.saveOrUpdate(groupVO);
    }

    // whAllotService

    /**
     * 创建调拨单
     *
     * @param whAllotRcd 调拨单
     * @return 调拨单号
     */
    public String createAllotRcd(final WhAllotRcd whAllotRcd) throws Exception {
        return whAllotService.createAllotRcd(whAllotRcd);
    }


    public String createAllotRcdAndFinishCommand(final WhAllotRcd whAllotRcd,final Integer type,
                                                 final boolean fetch) throws Exception {
        String allotCode = whCommandService.createAllotRcdAndFinishCommand(whAllotRcd,type,fetch);
        return allotCode;
    }
    public String createAutoTransferAllot(final WhAllotRcd whAllotRcd) throws Exception {
        return whAllotService.createAutoTransferAllot(whAllotRcd);
    }
    public String createPreAllotRcd(final WhPreAllotRcd whPreAllotRcd) throws Exception {
        return whAllotService.createPreAllotRcd(whPreAllotRcd);
    }

    public boolean isWarehouseInnerMove(final WhAllotRcd whAllotRcd){
        return whAllotService.isWarehouseInnerMove(whAllotRcd);
    }

    public boolean isWarehouseGroupChannelMove(final WhAllotRcd whAllotRcd){
        return whAllotService.isWarehouseGroupChannelMove(whAllotRcd);
    }

    public boolean isAllotDirectComplete(final WhAllotRcd whAllotRcd){
        return whAllotService.isAllotDirectComplete(whAllotRcd);
    }

    public boolean isAllotSecondConfirm(final WhAllotRcd whAllotRcd){
        return whAllotService.isAllotSecondConfirm(whAllotRcd);
    }
    /**
     * 取消调拨单
     *
     * @param code 调拨单CODE
     * @return 是否成功
     * @throws Exception
     */
    public boolean cancelAllotRcdByCode(final String code) throws Exception {
        return whAllotService.cancelAllotRcdByCode(code);
    }

    public Map<String,Boolean> isAllotCanCancel(List<String> codes){
        return whAllotService.isAllotCanCancel(codes);
    }

    /**
     * 取消调拨单
     *
     * @param code     调拨单CODE
     * @return 是否成功
     * @throws Exception
     */
    public boolean cancelAllotRcdByCodeFromWms(String code) throws Exception {
        return whAllotService.cancelAllotRcdByCodeFromWms(code);
    }

    public boolean cancelAllotRcdByCodeForCustomization(String code) throws Exception{
        return whAllotService.cancelAllotRcdByCodeForCustomization(code);
    }

    /**
     * 根据CODE查找调拨单
     *
     * @param code 调拨单CODE
     * @param fetchSku 是否抓取调拨单SKU
     * @return 调拨单
     */
    public WhAllotRcd findAllotRcdByCode(final String code, final boolean fetchSku) {
        return whAllotService.findAllotRcdByCode(code, fetchSku);
    }

    public WhAllotRcd findAllotRcdByCode(final String code, final boolean fetchSku,boolean fetchRefPackageSku) {
        return whAllotService.findAllotRcdByCode(code, fetchSku,fetchRefPackageSku);
    }

    public List<WhAllotDiffDetailVO> findAllotDiffDetailByExample(final WhAllotDiffDetailVO allotDiffDetailVO) {
        return whAllotService.findAllotDiffDetailByExample(allotDiffDetailVO);
    }

    public List<WhAllotDiffDetailVO> listAllotDiffDetailByCode(final WhAllotDiffDetailVO allotDiffDetailVO) {
        return whAllotService.listAllotDiffDetailByCode(allotDiffDetailVO);
    }

    public WhAllotRcd findAllotRcdById(final Long id) {
        return whAllotService.findAllotRcdById(id);
    }

    public Integer countRefPackCancelQuantityAfterAllotFinished(WhAllotCond allotCond) {
        return whAllotService.countRefPackCancelQuantityAfterAllotFinished(allotCond);
    }

    /**
     * 根据类型和相关单据查找调拨
     *
     * @param type
     * @param referenceCode
     * @param fetchSku
     * @return
     */
    public WhAllotRcd findAllotRcdByTypeAndReferenceCode(final Integer type, final String referenceCode,
                                                         final boolean fetchSku) {
        return whAllotService.findAllotRcdByTypeAndReferenceCode(type, referenceCode, fetchSku);
    }

    /**
     * 根据条件查找调拨
     *
     * @param cond 条件
     * @return
     */
    public List<WhAllotRcd> findAllotRcdByCond(final WhAllotCond cond) {
        return whAllotService.findAllotRcdByCond(cond);
    }

    public List<WhAllotRcd> selectAllotRcdByCond(final WhAllotCond cond) {
        return whAllotService.selectAllotRcdByCond(cond);
    }

    public List<WhPreAllotRcdVO> findPreAllotRcdByCond(WhAllotCond cond){
        return whAllotService.findPreAllotRcdByCond(cond);
    }

    public List<WhPreAllotRcdVO> findPreAllotRcdByCond(WhAllotCond cond,boolean fetchSku,boolean fetchCountQuantity){
        return whAllotService.findPreAllotRcdByCond(cond,fetchSku,fetchCountQuantity);
    }

    public List<WhPreAllotRcdDownloadVO> findPreAllotRcdListByCond(WhAllotCond cond){
        return  whAllotService.findPreAllotRcdListByCond(cond);
    }
    public List<WhPreAllotRcdSku> findPreAllotRcdSkuByPreId(Long preId){
        return whAllotService.findPreAllotRcdSkuByPreId(preId);
    }
    public String autoCreateAllotRcd(WhPreAllotRcdVO vo){
        return whAllotService.autoCreateAllotRcd(vo);
    }
    /**
     * 根据条件查找调拨
     *
     * @param cond 条件
     * @return
     */
    public List<WhAllotRcd> getAllotRcdByCond(final WhAllotCond cond) {
        return whAllotService.getAllotRcdByCond(cond);
    }
    public void updateWhPreAllotRcdByCond(WhPreAllotRcd whPreAllotRcd){
        whAllotService.updateWhPreAllotRcdByCond(whPreAllotRcd);
    }
    /**
     * 根据调拨单ID查找调拨单SKU
     *
     * @param allotId 调拨单ID
     * @return 调拨单SKU列表
     */
    public List<WhAllotRcdSku> findAllotRcdSkuByAllotId(final Long allotId) {
        return whAllotService.findAllotRcdSkuByAllotId(allotId);
    }

    /**
     * 根据调拨单CODE查找调拨单SKU
     *
     * @param allotCode 源调拨单CODE
     * @return 调拨单SKU列表
     */
    public List<WhAllotRcdSku> findAllotRcdSkuByAllotCode(final String allotCode) {
        return whAllotService.findAllotRcdSkuByAllotCode(allotCode);
    }

    /**
     * 根据仓库CODE查找待确认调拨单
     *
     * @param warehouseCode 仓库CODE
     * @return 调拨单
     */
    public List<WhAllotRcd> findAllotRcdWaitForConfirmation(final String warehouseCode) {
        return whAllotService.findAllotRcdWaitForConfirmation(warehouseCode);
    }

    /**
     * 根据仓库CODE查找待出库调拨单
     *
     * @param warehouseCode 仓库CODE
     * @return 调拨单
     */
    public List<WhAllotRcd> findAllotRcdWaitForOutbound(final String warehouseCode) {
        return whAllotService.findAllotRcdWaitForOutbound(warehouseCode);
    }

    /**
     * 根据仓库CODE查找待入库调拨单
     *
     * @param warehouseCode 仓库CODE
     * @return 调拨单
     */
    public List<WhAllotRcd> findAllotRcdWaitForInbound(final String warehouseCode) {
        return whAllotService.findAllotRcdWaitForInbound(warehouseCode);
    }

    /**
     * 根据ID更新调拨单状态
     *
     * @param id 源调拨单ID
     * @param newStatus 新状态
     * @return 是否成功
     * @throws Exception
     */
    public boolean updateAllotRcdStatusById(final Long id, final Integer newStatus) throws Exception {
        return whAllotService.updateAllotRcdStatusById(id, newStatus);
    }

    /**
     * 根据CODE更新调拨单状态
     *
     * @param code 源调拨单CODE
     * @param newStatus 新状态
     * @return 是否成功
     * @throws Exception
     */
    public boolean updateAllotRcdStatusByCode(final String code, final Integer newStatus) throws Exception {
        return whAllotService.updateAllotRcdStatusByCode(code, newStatus);
    }
    
    /**
     * 根据CODE更新调拨单状态
     *
     * @param code 源调拨单CODE
     * @param newStatus 新状态
     * @return 是否成功
     * @throws Exception
     */
    public boolean updateAllotRcdStatusByCodeNew(final String code, final Integer newStatus,final String rejectedReason) throws Exception {
        return whAllotService.updateAllotRcdStatusByCodeNew(code, newStatus,rejectedReason);
    }

    public boolean allotPackageInbound(WhAllotPackageInBoundVO altPackageInBound){
        String lockKey = "scm:inbound:cmd:"+altPackageInBound.getInCommandCode();
        try{
            boolean getLock = redisDistributLock.tryLock(lockKey,10, TimeUnit.SECONDS);
            if(!getLock){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,"系统繁忙,请稍后重试");
            }
            return whAllotService.allotPackageInbound(altPackageInBound);
        }finally {
            redisDistributLock.unLock(lockKey);
        }
    }

    public boolean updateByPrimaryKeySelective(WhJitPackageSkuReference record){
        return whJitPackageSkuReferenceService.updateByPrimaryKeySelective(record);
    }

    public boolean createWhJitPackageSkuReference(List<WhJitPackageSkuReferenceVO> voList){
        return whJitPackageSkuReferenceService.createWhJitPackageSkuReference(voList);
    }

    public List<WhJitPackageSkuReferenceVO> findByReferenceCode(String referenceCode){
        return whJitPackageSkuReferenceService.findByReferenceCode(referenceCode);
    }
    
    public List<WhJitPackageSkuReferenceVO> findBySkuCode(String skuCode){
        return whJitPackageSkuReferenceService.findBySkuCode(skuCode);
    }
    
    public List<WhJitPackageSkuReferenceVO> findByPackageCode(String packageCode){
        return whJitPackageSkuReferenceService.findByPackageCode(packageCode);
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageRefByPackageCode(String packageCode,Integer type){
        return whJitPackageSkuReferenceService.findJitPackageRefByPackageCode(packageCode,type);
    }
    
    /**
     * 根据相关单据号查找关联包裹的未分配数量
     *
     * @param referenceCode 单据号
     * @return 未分配数量
     */
    public int findUndistributedNumberByreferenceCode(String referenceCode){
    	return whJitPackageSkuReferenceService.findUndistributedNumberByreferenceCode(referenceCode);
    }
    
    public List<WhJitPackageSkuReferenceVO> findNeedAllotPackageByReferenceCode(String referenceCode,Integer type){
        return whJitPackageSkuReferenceService.findNeedAllotPackageByReferenceCode(referenceCode,type);
    }
    
    public List<WhJitPackageSkuReferenceVO> findOpJitPackageReferenceListByTypeAndReferenceCode(String referenceCode,Integer type){
        return whJitPackageSkuReferenceService.findOpJitPackageReferenceListByTypeAndReferenceCode(referenceCode,type);
    }

    public List<WhJitPackageSkuReferenceVO> findOpJitPackageReferenceByTypeAndReferenceCode(List<String> referenceCodes,Integer type){
        return whJitPackageSkuReferenceService.findOpJitPackageReferenceByTypeAndReferenceCode(referenceCodes,type);
    }

    public WhJitPackageSkuReferenceVO findLastUsableJitPackageReferenceByTypeAndReferenceCode(String referenceCode,Integer type){
        return whJitPackageSkuReferenceService.findLastUsableJitPackageReferenceByTypeAndReferenceCode(referenceCode,type);
    }
    
    public List<WhJitPackageSkuReferenceVO> findNeedAllotByReferenceCode(String packageCode,String skuCode){
        return whJitPackageSkuReferenceService.findNeedAllotByReferenceCode(packageCode,skuCode);
    }
    
    public List<WhJitPackageSkuReferenceVO> findNeedAllotByPackageCodeAndSkuCode(String packageCode,String skuCode,Integer referenceType){
        return whJitPackageSkuReferenceService.findNeedAllotByPackageCodeAndSkuCode(packageCode,skuCode,referenceType);
    }
    
    public int countAssigndNumber(String packageCode,String skuCode){
    	return whJitPackageSkuReferenceService.countAssigndNumber(packageCode,skuCode);
    }
    
    public WhJitPackageSkuReferenceVO findPopWarehouseByReferenceCode(String referenceCode){
        return whJitPackageSkuReferenceService.findPopWarehouseByReferenceCode(referenceCode);
    }
    
    public WhJitPackageSkuReferenceVO findPjWarehouseByReferenceCode(String referenceCode){
        return whJitPackageSkuReferenceService.findPjWarehouseByReferenceCode(referenceCode);
    }

    public List<WhJitPackageSkuReferenceVO> findByPackageCode(List<String> packageCodeList,Integer referenceType){
        return whJitPackageSkuReferenceService.findByPackageCode(packageCodeList,referenceType);
    }

    public List<WhJitPackageSkuReferenceVO> findByReferenceCode(List<String> referenceCodeList){
        return whJitPackageSkuReferenceService.findByReferenceCode(referenceCodeList);
    }

    public Map<String,List<WhJitPackageSkuReferenceVO>> findJitPakcageSkuByReferenceCodeGroup(List<String> referenceCodeList){
        return whJitPackageSkuReferenceService.findByReferenceCodeGroup(referenceCodeList);
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterJobCancel(){
        return whJitPackageSkuReferenceService.findJitPackageSkuNotSendMailAfterJobCancel();
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterJobFinishException(){
        return whJitPackageSkuReferenceService.findJitPackageSkuNotSendMailAfterJobFinishException();
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotCreatePrdcJobAfterAltFinished(){
        return whJitPackageSkuReferenceService.findJitPackageSkuNotCreatePrdcJobAfterAltFinished();
    }

    public Map<String,List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotCreatePrdcJobAfterAltFinishedGroup(){
        return whJitPackageSkuReferenceService.findJitPackageSkuNotCreatePrdcJobAfterAltFinishedGroup();
    }

    public Map<String,List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotSendMailAfterAltFinishedGroup(WhJitPackageSkuReferenceVO vo){
        return whJitPackageSkuReferenceService.findJitPackageSkuNotSendMailAfterAltFinishedGroup(vo);
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotAltAfterPrdcJobFinished(){
        return whJitPackageSkuReferenceService.findJitPackageSkuNotAltAfterPrdcJobFinished();
    }

    public Map<String,List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotAltAfterPrdcJobFinishedGroup(){
        return whJitPackageSkuReferenceService.findJitPackageSkuNotAltAfterPrdcJobFinishedGroup();
    }

    public Map<String,List<WhJitPackageSkuReferenceVO>> findJitPackageSkuOrderCancelGroup(){
        return whJitPackageSkuReferenceService.findJitPackageSkuOrderCancelGroup();
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterOrderCancel(){
        return whJitPackageSkuReferenceService.findJitPackageSkuNotSendMailAfterOrderCancel();
    }

    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotProcessAfterOrderPaidGroup(){
        return whJitPackageSkuReferenceService.findJitPackageSkuNotProcessAfterOrderPaidGroup();
    }

    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuByPackageCode(List<String> packageCodes){
        return whJitPackageSkuReferenceService.findJitPackageSkuByPackageCode(packageCodes);
    }
    
    public List<WhJitPackageSkuReferenceVO> findReferenceCodeByPackageCode(List<String> packageCodes){
        return whJitPackageSkuReferenceService.findReferenceCodeByPackageCode(packageCodes);
    }
    
    public List<AssociatedInfoVO> findAssociatedInfoByreferenceCode(String referenceCode){
        return whJitPackageSkuReferenceService.findAssociatedInfoByreferenceCode(referenceCode);
    }
    
    public List<AssociatedInfoVO> findJobAssociatedInfoByreferenceCode(String referenceCode){
        return whJitPackageSkuReferenceService.findJobAssociatedInfoByreferenceCode(referenceCode);
    }
    
    public List<WhJitPackageSkuReferenceVO> findNonCustomByPackageCode(Long orderId){
        return whJitPackageSkuReferenceService.findNonCustomByPackageCode(orderId);
    }

    public WhCustomizatonParam findCustomizatonParamByType(Integer type){
        return whCustomizatonParamService.findCustomizatonParamByType(type);
    }

    public boolean saveOrUpdateCustomizationParam(WhCustomizatonParam param){
        return whCustomizatonParamService.saveOrUpdateCustomizationParam(param);
    }

    // whCommandService

    /**
     * 创建指令
     *
     * @param whCommand 指令
     * @return 指令编码
     * @throws Exception
     */
    public String createCommand(final WhCommand whCommand) throws Exception {
        return whCommandService.createCommand(whCommand);
    }

    /**
     * 创建指令，并自动完成
     *
     * @param whCommand 指令
     * @return 指令编码
     * @throws Exception
     */
    public String createCommandThenFinish(final WhCommand whCommand) throws Exception {
        return whCommandService.createCommandThenFinish(whCommand);
    }

    /**
     * 释放SKU库存后创建指令
     *
     * @param whCommand 指令
     * @param whReleaseOccupationVOList 释放占用
     * @return 指令编码
     * @throws Exception
     */
    public String createCommandAfterRelease(final WhCommand whCommand,
                                            final List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return whCommandService.createCommandAfterRelease(whCommand, whReleaseOccupationVOList);
    }

    /**
     * 占用SKU库存后创建指令
     *
     * @param whCommand 指令
     * @param whInvOccupyList SKU库存占用列表
     * @return 指令编码
     * @throws Exception
     */
    public String createCommandAfterOccupy(final WhCommand whCommand, final List<WhInvOccupy> whInvOccupyList) throws Exception {
        return whCommandService.createCommandAfterOccupy(whCommand, whInvOccupyList);
    }

    /**
     * 释放SKU库存后创建指令，并自动完成
     *
     * @param whCommand 指令
     * @param whReleaseOccupationVOList
     * @return 指令编码
     * @throws Exception
     */
    public String createCommandAfterReleaseThenFinish(final WhCommand whCommand,
                                                      final List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return whCommandService.createCommandAfterReleaseThenFinish(whCommand, whReleaseOccupationVOList);
    }

    public String createCommandThenFinishWithoutOccupy(final WhCommand whCommand,final List<WhReleaseOccupationVO> releaseList){
        return whCommandService.createCommandThenFinishWithoutOccupy(whCommand,releaseList);
    }

    public String createCommandThenFinishForSales(
            WhCommand whCommand
            ,List<WhReleaseOccupationVO> releaseList
            ,List<WhInvRcd> invRcdList,String uniqueCode){
        return whCommandService.createCommandThenFinishForSales(whCommand,releaseList,invRcdList,uniqueCode);
    }


    public boolean finishOutCommandForSales(
            WhCommand whCommand
            ,List<WhReleaseOccupationVO> releaseList
            ,List<WhInvRcd> invRcdList){
        return whCommandService.finishOutCommandForSales(whCommand,releaseList,invRcdList);
    }

    /**
     * 根据CODE查找指令
     *
     * @param code 指令编码
     * @param fetch 是否抓取行
     * @return 指令
     */
    public WhCommand findCommandByCode(final String code, final boolean fetch) {
        return whCommandService.findCommandByCode(code, fetch);
    }
    
    /**
     * 根据CODE查找指令
     *
     * @param code 指令编码
     * @param fetch 是否抓取行
     * @return 指令
     */
    public WhCommand findNewCommandByCode(final String code, final boolean fetch) {
        return whCommandService.findNewCommandByCode(code, fetch);
    }

    /**
     * 根据CODE列表查找指令列表
     *
     * @param codeList 指令编码列表
     * @param fetch 是否抓取行
     * @return 指令列表
     * @throws Exception
     */
    public List<WhCommand> findCommandByCodes(final List<String> codeList, final boolean fetch){
        return whCommandService.findCommandByCodes(codeList, fetch);
    }
    public List<WhCommandSku> findCommandSkuByCommandCodes(List<String> commandCodeList){
        return whCommandService.findCommandSkuByCommandCodes(commandCodeList);
    }
    public List<WhCommandSku> findCommandSkuByCommandSkuCodes(List<String> commandCodeList){
        return whCommandService.findCommandSkuByCommandSkuCodes(commandCodeList);
    }
    /**
     * 根据仓库和指令编码查找处理中的指令
     *
     * @param warehouseCodeList
     * @param codeList
     * @return
     */
    public List<WhCommand> findInProcessCommandByWarehouseAndAndCodes(final List<String> warehouseCodeList,
                                                                      final List<String> codeList) {
        return whCommandService.findInProcessCommandByWarehouseAndAndCodes(warehouseCodeList, codeList);
    }

    /**
     * 根据出入库类型和相关单据号查找指令
     *
     * @param type 出入库类型
     * @param referenceCode 相关单据号
     * @param fetch 是否抓取行
     * @return 是否成功
     */
    public WhCommand findCommandByTypeAndReferenceCode(final Integer type, final String referenceCode,
                                                       final boolean fetch) {
        return whCommandService.findCommandByTypeAndReferenceCode(type, referenceCode, fetch);
    }

    public WhCommand findCommandByReferenceCode(String referenceCode){
        return whCommandService.findCommandByReferenceCode(referenceCode);
    }

    /**
     * 根据条件查找指令
     *
     * @param cond 条件
     * @return 指令列表
     */
    public List<WhCommand> findCommandByCond(final WhCommandCond cond) {
        return whCommandService.findCommandByCond(cond);
    }
    
    /**
     * 根据条件查找非现货商品
     *
     * @param cond 条件
     * @return 非现货商品列表
     */
    public List<OffSpotGood> findOffSpotGoodsListByCond(final OffSpotGoodsCond cond) {
        return offSpotGoodsService.findOffSpotGoodsListByCond(cond);
    }
    
    /**
     * 查找非现货商品未发货数量详情
     *
     * @param skuCode 条件
     * @return 非现货商品详情
     */
    public List<OffSpotGood> findDetailOffSpotGoodsList(String skuCode) {
        return offSpotGoodsService.findDetailOffSpotGoodsList(skuCode);
    }
    
    /**
     * 查找非现货商品在途数量详情
     *
     * @param skuCode 条件
     * @return 非现货商品详情
     */
    public List<OffSpotGood> findDetailOnTheWayOffSpotGoodsList(String skuCode) {
        return offSpotGoodsService.findDetailOnTheWayOffSpotGoodsList(skuCode);
    }

    // 查询未发货包裹，且未发送过邮件提醒的包裹
    public List<WhCommand> findUnDeliveryGoodsAndNoSendMailByCond(final WhCommandCond cond) {
        return whCommandService.findUnDeliveryGoodsAndNoSendMailByCond(cond);
    }

    /**
     * 根据逻辑仓和创建时间范围查找处理中指令
     *
     * @param warehouseCodeList
     * @param startTime
     * @param endTime
     * @return 指令列表
     */
    public List<WhCommand> findInProcessCommandByWarehouseAndTimeRange(final List<String> warehouseCodeList,
                                                                       final Date startTime, final Date endTime) {
        return whCommandService.findInProcessCommandByWarehouseAndTimeRange(warehouseCodeList, startTime, endTime);
    }

    /**
     * 根据CODE查找指令行
     *
     * @param code 指令行编码
     * @return 指令行
     */
    public WhCommandSku findCommandSkuByCode(final String code) {
        return whCommandService.findCommandSkuByCode(code);
    }

    /**
     * 根据CODE查找指令行
     *
     * @param commandCode 指令编码
     * @return 指令行列表
     */
    public List<WhCommandSku> findCommandSkuByCommandCode(final String commandCode) {
        return whCommandService.findCommandSkuByCommandCode(commandCode);
    }

    /**
     * 根据CODE查找指令行
     *
     * @param commandId 指令Id
     * @return 指令行列表
     */
    public List<WhCommandSku> findCommandSkuByCommandId(final Long commandId) {
        return whCommandService.findCommandSkuByCommandId(commandId);
    }

    public boolean cancelCommandWithoutOccupy(WhCommand rcd){
        return whCommandService.cancelCommandWithoutOccupy(rcd);
    }

    /**
     * 根据ID取消指令
     *
     * @param id 指令Id
     * @return 是否成功
     */
    public boolean cancelCommandById(final Long id) {
        return whCommandService.cancelCommandById(id);
    }

    /**
     * 根据编码取消指令
     *
     * @param code 指令编码
     * @return 是否成功
     */
    public boolean cancelCommandByCode(final String code) {
        return whCommandService.cancelCommandByCode(code);
    }

    /**
     * 根据出入库类型和相关单据号取消指令
     *
     * @param type 出入库类型
     * @param referenceCode 相关单据号
     * @return 是否成功
     */
    public boolean cancelCommandByTypeAndReferenceCode(final Integer type, final String referenceCode) {
        return whCommandService.cancelCommandByTypeAndReferenceCode(type, referenceCode);
    }

    /**
     * 根据出入库类型和相关单据号重置指令相关单据号
     *
     * @param type 出入库类型
     * @param referenceCode 相关单据号
     */
    public void resetCommandReferenceCodeByTypeAndReferenceCode(final Integer type, final String referenceCode) {
        whCommandService.resetCommandReferenceCodeByTypeAndReferenceCode(type, referenceCode);
    }

    /**
     * 占用前根据出入库类型和相关单据号重置指令相关单据号
     *
     * @param type
     * @param referenceCode
     */
    public void resetCommandReferenceCodeByTypeAndReferenceCodeBeforeOccupy(final Integer type,
                                                                            final String referenceCode,
                                                                            final List<WhInvOccupy> whInvOccupyList) {
        whCommandService
                .resetCommandReferenceCodeByTypeAndReferenceCodeBeforeOccupy(type, referenceCode, whInvOccupyList);
    }

    /**
     * 根据ID完成指令
     *
     * @param id 指令Id
     * @return 是否成功
     * @throws Exception
     */
    public boolean finishCommandById(final Long id) throws Exception {
        return whCommandService.finishCommandById(id);
    }

    /**
     * 根据逻辑仓和增量时间条件查找处理中的指令
     *
     * @param warehouseCodeList 逻辑仓列表
     * @param incrementTime 增量时间
     * @return 指令列表
     */
    public List<WhCommand> findInProcessCommandByIncrement(final List<String> warehouseCodeList,
                                                           final Date incrementTime) {
        return whCommandService.findInProcessCommandByIncrement(warehouseCodeList, incrementTime);
    }

    /**
     * 根据出入库类型和相关单据号完成指令
     *
     * @param type 出入库类型
     * @param referenceCode 相关单据号
     * @return 是否成功
     * @throws Exception
     */
    public boolean finishCommandByTypeAndReferenceCode(final Integer type, final String referenceCode) throws Exception {
        return whCommandService.finishCommandByTypeAndReferenceCode(type, referenceCode);
    }

    /**
     * 完成指令
     *
     * @param rcd 指令
     * @return 是否成功
     * @throws Exception
     */
    public boolean finishCommand(final WhCommand rcd) throws Exception {
        return whCommandService.finishCommand(rcd);
    }

    public boolean finishCommandWithoutOccupy(final WhCommand rcd){
        return whCommandService.finishCommandWithoutOccupy(rcd);
    }

    public boolean processCommandOutFinish(
            WhCommand command
            ,List<WhInvRcd> invRcdList
            ,List<WhReleaseOccupationVO> releaseList){
        return whCommandService.processCommandOutFinish(command,invRcdList,releaseList);
    }

    public List<WhWmsMoveStock> findWmsMoveStockByPrdCode(String prdCode){
        return whWmsMoveStockService.findWmsMoveStockByPrdCode(prdCode);
    }

    public Integer cancelWmsMoveStockByIdList(List<Long> idList){
        return whWmsMoveStockService.cancelWmsMoveStockByIdList(idList);
    }

    // whDamageWasteService

    /**
     * 记录耗损
     *
     * @param whDamagedRcd 耗损
     * @return 记录ID
     * @throws Exception
     */
    public Long recordDamage(final WhDamagedRcd whDamagedRcd) throws Exception{
        return whDamageWasteService.recordDamage(whDamagedRcd);
    }

    /**
     * 记录报废
     *
     * @param whWastedRcd 报废
     * @return 记录ID
     * @throws Exception
     */
    public Long recordWaste(final WhWastedRcd whWastedRcd) throws Exception{
        return whDamageWasteService.recordWaste(whWastedRcd);
    }

    /**
     * 根据SKU编码查找耗损记录
     *
     * @param skuCode SKU编码
     * @return Map<来源仓库编码,耗损记录列表>
     */
    public Map<String, List<WhDamagedRcd>> findDamagedRcdBySkuCode(final String skuCode) {
        return whDamageWasteService.findDamagedRcdBySkuCode(skuCode);
    }

    /**
     * 根据SKU编码和来源仓库编码查找耗损记录
     *
     * @param skuCode SKU编码
     * @param sourceWarehouseCode 来源仓库编码
     * @return 耗损记录列表
     */
    public List<WhDamagedRcd> findDamagedRcdBySkuCodeAndWarehouseCode(final String skuCode,
                                                                      final String sourceWarehouseCode) {
        return whDamageWasteService.findDamagedRcdBySkuCodeAndWarehouseCode(skuCode, sourceWarehouseCode);
    }

    /**
     * 根据条件查找残次记录
     *
     * @param cond 条件
     * @return 残次记录列表
     */
    public List<WhDamagedRcd> findDamagedRcdByCond(final WhDamagedRcdCond cond) {
        return whDamageWasteService.findDamagedRcdByCond(cond);
    }

    /**
     * 根据SKU编码查找报废记录
     *
     * @param skuCode SKU编码
     * @return Map<来源仓库编码,报废记录列表>
     */
    public Map<String, List<WhWastedRcd>> findWastedRcdBySkuCode(final String skuCode) {
        return whDamageWasteService.findWastedRcdBySkuCode(skuCode);
    }

    /**
     * 根据SKU编码和来源仓库编码查找报废记录
     *
     * @param skuCode SKU编码
     * @param sourceWarehouseCode 来源仓库编码
     * @return 报废记录列表
     */
    public List<WhWastedRcd> findWastedRcdBySkuCodeAndWarehouseCode(final String skuCode,
                                                                    final String sourceWarehouseCode) {
        return whDamageWasteService.findWastedRcdBySkuCodeAndWarehouseCode(skuCode, sourceWarehouseCode);
    }

    /**
     * 处理残次
     *
     * @param warehouseCode 残次仓编码
     * @param skuCode sku编码
     * @param quantity 处理数量
     * @param type 类型（waste,fix）
     * @return
     * @throws Exception
     */
    public boolean dealDamaged(final String warehouseCode, final String skuCode, final Integer quantity,
                               final String type) throws Exception{
        return whDamageWasteService.dealDamaged(warehouseCode, skuCode, quantity, type);
    }

    // whInvService

    /**
     * 记录SKU库存记录
     *
     * @param whInvRcd SKU库存记录
     * @return 库存记录ID
     */
/*    public boolean record(final WhInvRcd whInvRcd) {
        return whInvService.record(whInvRcd);
    }*/

    /**
     * 记录SKU库存占用
     *
     * @param whInvOccupy SKU库存占用
     * @return 库存占用ID
     */
    /*public Long occupy(final WhInvOccupy whInvOccupy) {
        return whInvService.occupy(whInvOccupy);
    }

    *//**
     * 记录SKU库存占用
     *
     * @param whInvOccupyList SKU库存占用列表
     * @return 库存占用ID
     *//*
    public List<Long> occupy(final List<WhInvOccupy> whInvOccupyList) {
        return whInvService.occupy(whInvOccupyList);
    }
*/

    /**
     * 释放SKU库存后占用
     *
     * @param whInvOccupyList
     * @param whReleaseOccupationVOList
     * @return 库存占用ID
     */
   /* public List<Long> occupyAfterRelease(final List<WhInvOccupy> whInvOccupyList,
                                         final List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        return whInvService.occupyAfterRelease(whInvOccupyList, whReleaseOccupationVOList);
    }*/

    /**
     * 根据占用类型和相关单据号释放SKU库存占用
     *
     * @param whReleaseOccupationVO 释放占用
     */
   /* public void releaseOccupation(final WhReleaseOccupationVO whReleaseOccupationVO) {
        whInvService.releaseOccupation(whReleaseOccupationVO);
    }*/

    /**
     * 根据占用类型和相关单据号释放SKU库存占用
     *
     * @param whReleaseOccupationVOList 释放占用
     */
   /* public void releaseOccupation(final List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        whInvService.releaseOccupation(whReleaseOccupationVOList);
    }*/

    /**
     * 根据SKU编码查找库存数量
     *
     * @param skuCode SKU编码
     * @return Map<仓库编码,库存数量>
     */
    public List<WhWarehouseInvQttVO> findInvQttBySkuCode(final String skuCode) {
        return whInvService.findInvQttBySkuCode(skuCode);
    }

    /**
     * 根据SKU编码查找待入库数量
     *
     * @param skuCode SKU编码
     * @return Map<仓库编码,库存数量>
     */
    public List<WhWarehouseInvQttVO> findWillInQttBySkuCode(final String skuCode) {
        return whInvService.findWillInQttBySkuCode(skuCode);
    }

    /**
     * 根据仓库编码查找SKU库存数量
     *
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findSkuInvQttByWarehouseCode(final String warehouseCode) {
        return whInvService.findSkuInvQttByWarehouseCode(warehouseCode);
    }

    /**
     * 根据物理仓库编码查找SKU库存数量
     *
     * @param physicalWarehouseCode 物理仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findSkuInvQttByPhysicalWarehouseCode(final String physicalWarehouseCode) {
        return whInvService.findSkuInvQttByPhysicalWarehouseCode(physicalWarehouseCode);
    }

    /**
     * 根据仓库编码列表查找SKU库存数量
     *
     * @param warehouseCodeList 仓库编码列表
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findSkuInvQttByWarehouseCodes(final List<String> warehouseCodeList) {
        return whInvService.findSkuInvQttByWarehouseCodes(warehouseCodeList);
    }

    /**
     * 根据仓库编码查找占用数量
     *
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findOccupyQttByWarehouseCode(final String warehouseCode) {
        return whInvService.findOccupyQttByWarehouseCode(warehouseCode);
    }

    /**
     * 根据仓库编码查找待入库数量
     *
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findWillInQttByWarehouseCode(final String warehouseCode) {
        return whInvService.findWillInQttByWarehouseCode(warehouseCode);
    }

    /**
     * 根据SKU编码和仓库编码查找库存数量
     *
     * @param skuCode SKU编码
     * @param warehouseCode 仓库编码
     * @return 库存数量
     */
    public int findInvQttBySkuCodeAndWarehouseCode(final String skuCode, final String warehouseCode) {
        return whInvService.findInvQttBySkuCodeAndWarehouseCode(skuCode, warehouseCode);
    }
    
    /**
     * 根据SKU编码查找所有仓库的可用库存数量
     * @param skuCode       SKU编码
     * @return 可用库存数量
     */
    public int findQttBySkuCode(final String skuCode) {
        return whInvService.findQttBySkuCode(skuCode);
    }

    /**
     * 根据SKU编码列表和仓库编码查找库存数量
     *
     * @param skuCodes SKU编码列表
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findInvQttBySkuCodesAndWarehouseCode(final List<String> skuCodes,
                                                                    final String warehouseCode) {
        return whInvService.findInvQttBySkuCodesAndWarehouseCode(skuCodes, warehouseCode);
    }

    /**
     * 根据SKU编码查找占用数量
     *
     * @param skuCode SKU编码
     * @return Map<仓库编码,库存数量>
     */
    public List<WhWarehouseInvQttVO> findOccupyQttBySkuCode(final String skuCode) {
        return whInvService.findOccupyQttBySkuCode(skuCode);
    }

    /**
     * 根据SKU编码和仓库编码查找占用数量
     *
     * @param skuCode SKU编码
     * @param warehouseCode 仓库编码
     * @return 库存数量
     */
    public int findOccupyQttBySkuCodeAndWarehouseCode(final String skuCode, final String warehouseCode) {
        return whInvService.findOccupyQttBySkuCodeAndWarehouseCode(skuCode, warehouseCode);
    }

    /**
     * 根据SKU编码列表和仓库编码查找占用数量
     *
     * @param skuCodes SKU编码列表
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public List<WhSkuInvQttVO> findOccupyQttBySkuCodesAndWarehouseCode(final List<String> skuCodes,
                                                                       final String warehouseCode) {
        return whInvService.findOccupyQttBySkuCodesAndWarehouseCode(skuCodes, warehouseCode);
    }

    /**
     * 根据SKU编码查找可用库存数量
     *
     * @param skuCode SKU编码
     * @return Map<仓库编码,库存数量>
     */
    public Map<String, WhInvVO> findCanUseQttBySkuCode(final String skuCode) {
        return whInvService.findCanUseQttBySkuCode(skuCode);
    }

    //sku库存查询
    public List<WhWarehouseSkuInvVO> findWarehousesSkuInvByCond(List<String> warehouseCodeList,String skuCode){
        return whInvService.findWarehousesSkuInvByCond(warehouseCodeList,skuCode);
    }

    public Map<String, WhWarehouse> getWarehouseMap(List<String> warehouseCodeList){
        return whInvService.getWarehouseMap(warehouseCodeList);
    }

    /**
     * 根据仓库编码查找可用库存数量
     *
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public Map<String, WhInvVO> findCanUseQttByWarehouseCode(final String warehouseCode) {
        return whInvService.findCanUseQttByWarehouseCode(warehouseCode);
    }

    /**
     * 根据SKU编码和仓库编码查找可用库存数量
     *
     * @param skuCode SKU编码
     * @param warehouseCode 仓库编码
     * @return 库存数量
     */
    public WhInvVO findCanUseQttBySkuCodeAndWarehouseCode(final String skuCode, final String warehouseCode) {
        return whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode, warehouseCode);
    }

    /**
     * 根据SKU编码列表和仓库编码查找可用库存数量
     *
     * @param skuCodes SKU编码列表
     * @param warehouseCode 仓库编码
     * @return Map<SKU编码,库存数量>
     */
    public Map<String, WhInvVO> findCanUseQttBySkuCodesAndWarehouseCode(final List<String> skuCodes,
                                                                        final String warehouseCode) {
        return whInvService.findCanUseQttBySkuCodesAndWarehouseCode(skuCodes, warehouseCode);
    }

    /**
     * 根据SKU编码列表查找可用库存数量
     *
     * @param skuCodes SKU编码列表
     * @param
     * @return Map<SKU编码,库存数量>
     */
    public List<WhInvQttVO> findInvQttBySkuCode_IPOS(String channelCode, String skuCodes) {
        return whInvService.findInvQttBySkuCode_IPOS(channelCode, skuCodes);
    }

    /**
     * 计算可用库存报表
     */
    public List<WhInvVO> calCanUseQtt() {
        return whInvService.calCanUseQtt();
    }

    // whTakeStockService

    /**
     * 创建
     *
     * @param whTakeStock
     * @return ID
     * @throws Exception
     */
    public Long createTakeStock(final WhTakeStock whTakeStock) throws Exception {
        return whTakeStockService.createTakeStock(whTakeStock);
    }

    public List<Long> batchCreateTakeStock(List<WhTakeStock> whTakeStockList) throws Exception {
      return whTakeStockService.batchCreateTakeStock(whTakeStockList);
    }

    //门店盘点--start

    public boolean createWhInventory(WhInventoryCreateVO inventoryInfo){
        return whInventoryService.createWhInventory(inventoryInfo);
    }

    public WhInventoryVO findWhInventory(Long id){
        return whInventoryService.findWhInventory(id);
    }

    public WhInventoryVO findWhInventory(Long id,boolean cascade){
        return whInventoryService.findWhInventory(id,cascade);
    }

    public List<WhInventoryVO> findWhInventoryByCond(WhInventoryCond cond){
        return whInventoryService.findWhInventoryByCond(cond);
    }

    public Pagination<WhInventoryVO> findWhInventoryByCondPage(WhInventoryCond cond){
        return whInventoryService.findWhInventoryByCondPage(cond);
    }

    public boolean initWhInventory(Long invenotryId){
        return whInventoryService.initWhInventory(invenotryId);
    }

    public boolean cancelWhInventory(Long inventoryId){
        return whInventoryService.cancelWhInventory(inventoryId);
    }

    //提交待经理审批
    public boolean submitInventoryForManagerAudit(Long inventoryId){
        return whInventoryService.submitInventoryForManagerAudit(inventoryId);
    }

    public boolean whInventoryExistDiff(Long inventoryId){
        return whInventoryService.whInventoryExistDiff(inventoryId);
    }

    public WhInventoryDetailVO findWhInventoryDetail(Long detailId){
        return whInventoryService.findWhInventoryDetail(detailId);
    }

    public List<WhInventoryDetailVO> findWhInventoryDetailByCond(WhInventoryDetailCond detailCond){
        return whInventoryService.findWhInventoryDetailByCond(detailCond);
    }

    public Pagination<WhInventoryDetailVO> findWhInventoryDetailByCondPage(WhInventoryDetailCond detailCond){
        return whInventoryService.findWhInventoryDetailByCondPage(detailCond);
    }

    public List<WhInventoryReasionDicVO> findAllWhInventoryReasionDic(){
        return whInventoryService.findAllWhInventoryReasionDic();
    }

    public boolean submitWhInventoryDetail(WhInventoryDetailVO inventoryDetail){
        return whInventoryService.submitWhInventoryDetail(inventoryDetail);
    }

    public boolean reInitInventoryDetail(Long inventoryDetailId){
        return whInventoryService.reInitInventoryDetail(inventoryDetailId);
    }

    public boolean addWhInventoryDetail(WhInventoryDetailVO inventoryDetail){
        return whInventoryService.addWhInventoryDetail(inventoryDetail);
    }

    public boolean inventoryDetailManagerAudit(WhInventoryDetailAuditVO auditInfo){
        return whInventoryService.inventoryDetailManagerAudit(auditInfo);
    }

    public boolean inventoryDetailManagerBatchAudit(WhInventoryDetailAuditVO auditInfo){
        return whInventoryService.inventoryDetailManagerBatchAudit(auditInfo);
    }

    public boolean inventoryFinishForManager(WhInventoryAuditVO auditInfo){
        return whInventoryService.inventoryFinishForManager(auditInfo);
    }

    public boolean inventoryDetailFinanceAudit(WhInventoryDetailAuditVO auditInfo){
        return whInventoryService.inventoryDetailFinanceAudit(auditInfo);
    }

    public boolean inventoryDetailFinanceBatchAudit(WhInventoryDetailAuditVO auditInfo){
        return whInventoryService.inventoryDetailFinanceBatchAudit(auditInfo);
    }

    public boolean inventoryFinishForFinance(WhInventoryAuditVO auditInfo){
        return whInventoryService.inventoryFinishForFinance(auditInfo);
    }

    public WhInventoryCountInfoVO countProcessingWhInventory(String physicalWarehouseCode){
        return whInventoryService.countProcessingWhInventory(physicalWarehouseCode);
    }

    public boolean processingWhInventoryDetailInSingle(WhInventoryDetailVO inventoryDetail){
        return whInventoryService.processingWhInventoryDetailInSingle(inventoryDetail);
    }

    public boolean processingWhInventoryDetailInContinue(WhInventoryDetailVO inventoryDetail){
        return whInventoryService.processingWhInventoryDetailInContinue(inventoryDetail);
    }

    //门店盘点邮箱配置
    public List<WhInventoryEmailVO> findAllWhInventoryEmail(){
        return whInventoryService.findAllWhInventoryEmail();
    }

    public List<WhInventoryEmailVO> findWhInventoryEmail(String physicalWarehouseCode){
        return whInventoryService.findWhInventoryEmail(physicalWarehouseCode);
    }

    public boolean saveWhInventoryEmail(List<WhInventoryEmailVO> emailList){
        return whInventoryService.saveWhInventoryEmail(emailList);
    }


    //门店盘点--end

    /**
     * 根据仓库编码查找
     *
     * @param warehouseCode 仓库编码
     * @param fetchRcd 是否抓取记录
     * @return 列表
     */
    public List<WhTakeStockRcdVO> findTakeStockByWarehouseCode(final String warehouseCode, final boolean fetchRcd) {
        return whTakeStockService.findTakeStockByWarehouseCode(warehouseCode, fetchRcd);
    }

    /**
     * 根据条件查找
     *
     * @param cond 条件
     * @return 列表
     */
    public PageInfo<WhTakeStockRcdVO> findTakeStockByCond(final WhTakeStockCond cond) {
        return whTakeStockService.findTakeStockByCond(cond);
    }

    /**
     * 条件获取出入库记录
     *
     * @param cond
     * @return
     */
    public List<WhInvRcdVO> getInvRcdByCond(final WhInvRcdCond cond) {
        List<WhInvRcdVO> whInvRcdVOList = whInvService.getInvRcdByCond(cond);
        if (EmptyUtil.isNotEmpty(whInvRcdVOList)) {
            for (WhInvRcdVO whInvRcdVO : whInvRcdVOList) {
                if(EmptyUtil.isNotEmpty(whInvRcdVO.getReferenceCode())){
                    continue;
                }
                if (NullUtil.isNotNull(whInvRcdVO.getTakeStockRcdId())){
                    whInvRcdVO.setReferenceCode(whInvRcdVO.getTakeStockRcdId()+"");
                }else if(NullUtil.isNotNull(whInvRcdVO.getWmsTakeStockRcdId())){
                    whInvRcdVO.setReferenceCode(whInvRcdVO.getWmsTakeStockRcdId()+"");
                }
            }
        }
        return whInvRcdVOList;
    }
   public List<WhInvRcdExtend> findWhInvRcdExtendListByIdList(List<Long> idList){
       return whInvService.findWhInvRcdExtendListByIdList(idList);
   }
    /**
     * 条件获取占用记录
     *
     * @param cond
     * @return
     */
    public List<WhInvOccupy> getInvOccupyByCond(final WhInvRcdCond cond) {
        List<WhInvOccupy> whInvRcdVOList = whInvService.getInvOccupyByCond(cond);
        return whInvRcdVOList;
    }

    /**
     * 条件获取待入库总数
     *
     * @param cond
     * @return
     */
    public WhInvOccupy getCountInvRcdWillInByCond(final WhInvRcdCond cond) {
        WhInvOccupy whInvRcdVOList = whInvService.getCountInvRcdWillInByCond(cond);
        return whInvRcdVOList;
    }

    /**
     * 条件获取待入库详情记录
     *
     * @param cond
     * @return
     */
    public List<WhInvOccupy> getInvRcdWillInByCond(final WhInvRcdCond cond) {
        List<WhInvOccupy> whInvRcdVOList = whInvService.getInvRcdWillInByCond(cond);
        return whInvRcdVOList;
    }

    /**
     * 查找command sku行
     *
     * @param skuCode
     * @return
     */

    public WhCommandSku findCommandSku(final String skuCode, final Long commandId) {
        return whCommandService.findCommandSku(skuCode, commandId);
    }
    public WhPhysicalWarehouse findPhysicalWarehouseByNo(String no) {
        return whInfoService.findPhysicalWarehouseByNo(no);
    }

    public List<WhPhysicalWarehouseVO> findNotRelatePhysicalWarehouses(){
        return whInfoService.findNotRelatePhysicalWarehouses();
    }

    public List<WhWarehouseVO> findNotRelateWarehouses(){
        return whInfoService.findNotRelateWarehouses();
    }

    public WhPhysicalWarehouse computeDispatchPhysicalWarehouse(String dispatchWhCode, Map<String,Integer> skuQuantityMap, Long targetDistrict){
        return whWmsSkuStockService.computeDispatchPhysicalWarehouse(dispatchWhCode,skuQuantityMap,targetDistrict);
    }
    /**
     * 更新调拨单
     *
     * @return 是否成功
     */
    public boolean updateAllotRcd(WhAllotRcd rcd){
        return whAllotService.updateAllotRcd(rcd);
    }

    /**
     * 更新调拨记录行
     *
     * @return 是否成功
     */
    public boolean updateAllotRcdSku(WhAllotRcdSku rcdSku){
        return whAllotService.updateAllotRcdSku(rcdSku);
    }

    public void packageAssoExpressFED(PackageInfo pi){
        whCommandService.packageAssoExpressFED(pi);
    }
    public void packageAssoExpressFEDAndCommand(PackageInfo pi){
        whCommandService.packageAssoExpressFEDAndCommand(pi);
    }

    public  void packageAssoExpressSF(PackageInfo pi){
        whCommandService.packageAssoExpressSF(pi);
    }
    public  void packageAssoExpressSFAndPackage(PackageInfo pi){
        whCommandService.packageAssoExpressSFAndPackage(pi);
    }
    public  void packageAssoExpressZTAndPackage(ZTOrderSubmitResponse ztOrderSubmitResponse){
        whCommandService.packageAssoExpressZTAndPackage(ztOrderSubmitResponse);
    }
    public void packageAssoExpressTmsAndCommand(PackageInfo pi){
        whCommandService.packageAssoExpressTmsAndCommand(pi);
    }

    public void commandAssociateExpress(String commandCode,String deliveryCode){
        whCommandService.commandAssociateExpress(commandCode,deliveryCode);
    }

    public  void updaeCommand(WhCommand whCommand){
        whCommandService.updateCommand(whCommand);
    }

    public  List<WhWmsCommandShortRecord> findWhWmsCommandShortRecordByCommandCode(String commandCode){
        return whCommandService.findWhWmsCommandShortRecordByCommandCode(commandCode);
    }

    public void commandWithPackageExpress(){
        whCommandService.commandWithPackageExpress();
    }

    public WhInvOccupy findOccupyQttByReferenceCode(String referenceCode) {
        return whInvService.findOccupyQttByReferenceCode(referenceCode);
    }

    public String synCommodityStocks(Long numIid, String outerId, long quantity, String sessionKey, int syncType, String referenceCode,Long operatorId) throws Exception {
        return whCommandService.synCommodityStocks(numIid, outerId, quantity, sessionKey, syncType, referenceCode,operatorId);
    }

    public Map<String,JdStockSyncResult> syncJdSkuStock(String warehouseCode
            , Map<String,Integer> skuQuantityMap
            , Integer syncType
            , String referenceCode
            , Long operatorId) {
        List<String> referenceCodes = new LinkedList<String>();
        referenceCodes.add(referenceCode);
        return whCommandService.syncJdSkuStock(warehouseCode,skuQuantityMap,syncType,referenceCodes,operatorId);
    }
    public void insertWhCommandOutFinish(WhCommandOutFinish whCommandOutFinish){
        whCommandService.insertWhCommandOutFinish(whCommandOutFinish);
    }

    public boolean saveJitPackageSendMail(WhJitPackageSendMailVO vo){
        return whJitPackageSendMailService.saveJitPackageSendMail(vo);
    }

    /**
     *获取根据skuCode ,生产日期获取 批次号
     *没有则生成
     * */
    public String getBarCode(String skuCode,Date prodDate){
        return whCommandService.getBarCode(skuCode, prodDate);
    }

    public String getBarCode(String skuCode, Date prodDate, Date expirationDate) {
        return whCommandService.getBarCode(skuCode,prodDate,expirationDate);
    }

    public String getBarCode(WhQualityControlVO qc) {
        return whCommandService.getBarCode(qc);
    }

    public String getPrePrintBarCode(WhQualityControlVO qc) {
        return whCommandService.getPrePrintBarCode(qc);
    }

    public Long getSupplierIdByPurchaseReturnCode(String purchaseReturnCode){
        return whCommandService.getSupplierIdByPurchaseReturnCode(purchaseReturnCode);
    }

    public String getOriPhyCodeByPurchaseReturnCode(String purchaseReturnCode){
        return whCommandService.getOriPhyCodeByPurchaseReturnCode(purchaseReturnCode);
    }

    /**
     * 通过SKU_CODE查询SKU保质期
     * @param skuCode
     * @return
     */
    public Integer findSkuShelfLifeBySkuCode(String skuCode){
        return whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(skuCode);
    }

    public WhWmsSkuBarcode findMinProdOrExpiryDateByBarCodes(List<String> barCodes){
        return whWmsSkuBarcodeService.findMinProdOrExpiryDateByBarCodes(barCodes);
    }

    public WhWmsSkuBarcodeVO findWhWmsBarcodeById(Long id, boolean fetchMaterial) {
        WhWmsSkuBarcodeVO skuBarcodeVO = whWmsSkuBarcodeService.findById(id);
        if (EmptyUtil.isNotEmpty(skuBarcodeVO) && fetchMaterial){
            WhWmsPrdcMaterialDetailCond cond = new WhWmsPrdcMaterialDetailCond();
            cond.setProdSku(skuBarcodeVO.getSkuCode());
            cond.setProdBarcode(skuBarcodeVO.getBarCode());
            cond.setOrderByClause("MATERIAL_SKU ASC,MATERIAL_BARCODE ASC");
            List<WhWmsPrdcMaterialDetailVO> materialDetailVOs = whWmsPrdcMaterialDetailService.listWhWmsPrdcMaterialDetailVOByCond(cond);
            skuBarcodeVO.setMaterialDetailVOs(materialDetailVOs);
        }
        return skuBarcodeVO;
    }

    public List<WhWmsSkuBarcodeVO> findExpiryDateSkuInfo(WhWmsSkuBarcodeCond cond){
        return whWmsSkuBarcodeService.findExpiryDateSkuInfo(cond);
    }

    public List<WhWmsSkuBarcodeVO> getWmsSkuBarcodeByCond(WhWmsSkuBarcodeVO cond){
        return whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(cond);
    }

    public Pagination<WhWmsSkuBarcodeVO> findExpiryDateSkuInfoByCondPage(WhWmsSkuBarcodeCond cond){
        return whWmsSkuBarcodeService.findExpiryDateSkuInfoByCondPage(cond);
    }

    public boolean modifyExpiryDate(WhWmsSkuBarcode cond){
        return whWmsSkuBarcodeService.modifyExpiryDate(cond);
    }

    public List<WhPackageInfoVO> findCHN2053PackageInfo(){
        return whCommandService.findCHN2053PackageInfo();
    }
    public List<WhWmsSubmitHandRecord> autoProcessSubmitHandData(){
        return whCommandService.autoProcessSubmitHandData();
    }
    public void processSubmitData(List<WhWmsSubmitHandRecord> list){
        whCommandService.processSubmitData(list);
    }
    public List<WhCommandOutFinish> findWhCommandOutFinishNoFinish(){
        return  whCommandService.findWhCommandOutFinishNoFinish();
    }
    public List<WhWmsExpressInfo> findAllExpressInfo(){
        return whInfoService.findAllExpressInfo();
    }
    /**
     * 释放SKU库存后创建指令，并自动完成
     *
     * @param
     * @param whReleaseOccupationVOList
     * @return 指令编码
     * @throws Exception
     */
    public List<String> createCommandsAfterReleaseThenFinish(final List<WhCommand> whCommandList,
                                                             final List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return whCommandService.createCommandsAfterReleaseThenFinish(whCommandList, whReleaseOccupationVOList);
    }

    public boolean consumableReceiveOutInPut(String dispatchBillCode, Map<String, Integer> quantityMap, List<WhWmsSkuStock> whWmsSkuStocks, Long operatorId) throws Exception {
        return whWmsConnectPickSkuService.consumableReceiveOutInPut(dispatchBillCode,quantityMap,whWmsSkuStocks,
                operatorId);
    }
    /**
     * 释放库存
     *
     * @param whInvOccupyList SKU库存占用列表
     * @return 库存占用ID
     */
    public int releaseOccupy(final List<WhInvOccupy> whInvOccupyList) {
        return whInvService.releaseOccupy(whInvOccupyList);
    }

    public void processWhWmsSkuStockDiff(){
        //仅处理门店物理仓库存扣减错误
        List<WhWmsSkuStockDiffVO> diffList = whWmsSkuStockService.findWhWmsSkuStockDiffList();
        if(EmptyUtil.isNotEmpty(diffList)){

            for(WhWmsSkuStockDiffVO skuStockDiff : diffList){
                if(NullUtil.isNull(skuStockDiff.getDiffAmount())
                        || skuStockDiff.getDiffAmount() >= 0
                        || NullUtil.isNull(skuStockDiff.getScmAmount())
                        || skuStockDiff.getScmAmount() < 0){
                    continue;
                }
                try{
                    WhWarehouseGroupVO whGroup = whWarehouseGroupService.findById(skuStockDiff.getWarehouseGroupId(),true);
                    List<WhPhysicalWarehouseVO> phyWhList = whGroup.getRelatePhysicalWarehouses();
                    if(EmptyUtil.isEmpty(phyWhList) || phyWhList.size() > 1){
                        throw new RuntimeException(String.format("[%s]逻辑仓分组配置异常！",skuStockDiff.getWarehouseGroupId()));
                    }
                    WhPhysicalWarehouseVO phyWh = phyWhList.get(0);
                    whCommandService.updatePhyWhSkuStockOut(phyWh.getCode(),skuStockDiff.getSkuCode(),skuStockDiff.getSkuStatus(),skuStockDiff.getDiffAmount());
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
        }
    }

    public void processWhWmsSkuStockDiffNotAdd(){
        //仅处理门店物理仓库存未增加错误
        List<WhWmsSkuStockDiffVO> diffList = whWmsSkuStockService.findWhWmsSkuStockDiffList();
        if(EmptyUtil.isNotEmpty(diffList)){

            for(WhWmsSkuStockDiffVO skuStockDiff : diffList){
                if(NullUtil.isNull(skuStockDiff.getDiffAmount())
                        || skuStockDiff.getDiffAmount() <= 0
                        || NullUtil.isNull(skuStockDiff.getScmAmount())
                        || skuStockDiff.getScmAmount() < 0){
                    continue;
                }
                try{
                    WhWarehouseGroupVO whGroup = whWarehouseGroupService.findById(skuStockDiff.getWarehouseGroupId(),true);
                    List<WhPhysicalWarehouseVO> phyWhList = whGroup.getRelatePhysicalWarehouses();
                    if(EmptyUtil.isEmpty(phyWhList) || phyWhList.size() > 1){
                        throw new RuntimeException(String.format("[%s]逻辑仓分组配置异常！",skuStockDiff.getWarehouseGroupId()));
                    }
                    WhPhysicalWarehouseVO phyWh = phyWhList.get(0);
                    whWmsSkuStockService.updatePhyWhSkuStock(phyWh.getCode()
                            ,skuStockDiff.getSkuCode(),skuStockDiff.getSkuStatus(),skuStockDiff.getDiffAmount()
                            ,19,"diffStock",1L,"diffStock");
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 列新code
     *
     * @param
     * @return 库存占用ID
     */
    public int updateReferenceCode(String oldReferenceCode,String newReferenceCode) {
        return whInvService.updateReferenceCode(oldReferenceCode,newReferenceCode);
    }

    public List<String> batchCreatePreAllotRcd(List<WhPreAllotRcd> whPreAllotRcdList) throws Exception {
        return  whAllotService.batchCreatePreAllotRcd(whPreAllotRcdList);
    }

    /**
     * 根据物理仓 查询默认的出库良品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutNondefectiveWarehouseByPyCode(final String physicalWarehouseCode){
        return whInfoService.findDefaultOutNondefectiveWarehouseByPyCode(physicalWarehouseCode);
    }

    /**
     * 根据物理仓 查询默认的出库残次逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutDefectiveWarehouseByPyCode(final String physicalWarehouseCode){
        return whInfoService.findDefaultOutDefectiveWarehouseByPyCode(physicalWarehouseCode);
    }

    /**
     * 根据物理仓 查询默认的出库样品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutSampleWarehouseByPyCode(final String physicalWarehouseCode){
        return whInfoService.findDefaultOutSampleWarehouseByPyCode(physicalWarehouseCode);
    }

    /**
     * 根据物理仓 查询默认的出库废品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutWasteWarehouseByPyCode(final String physicalWarehouseCode){
        return whInfoService.findDefaultOutWasteWarehouseByPyCode(physicalWarehouseCode);
    }

    public WhWarehouse findDefaultInOrOutWarehouseByPhyWhCode(String physicalWarehouseCode,Integer inOrOut,Integer skuStatus){
        return whInfoService.findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode,inOrOut,skuStatus);
    }

    /**
     * 根据物理仓 查询默认的入库良品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInNondefectiveWarehouseByPyCode(final String physicalWarehouseCode){
        return whInfoService.findDefaultInNondefectiveWarehouseByPyCode(physicalWarehouseCode);
    }

    /**
     * 根据物理仓 查询默认的入库残次逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInDefectiveWarehouseByPyCode(final String physicalWarehouseCode){
        return whInfoService.findDefaultInDefectiveWarehouseByPyCode(physicalWarehouseCode);
    }

    /**
     * 根据物理仓 查询默认的入库样品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInSampleWarehouseByPyCode(final String physicalWarehouseCode){
        return whInfoService.findDefaultInSampleWarehouseByPyCode(physicalWarehouseCode);
    }

    /**
     * 根据物理仓 查询默认的入库废品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInWasteWarehouseByPyCode(final String physicalWarehouseCode){
        return whInfoService.findDefaultInWasteWarehouseByPyCode(physicalWarehouseCode);
    }

    /**
     * 根据物理仓 查询默认的入库废品逻辑仓
     * @param physicalWarehouseCode 物理仓code
     * @return
     */
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInDisplayWarehouseByPyCode(final String physicalWarehouseCode){
        return whInfoService.findDefaultInDisplayWarehouseByPyCode(physicalWarehouseCode);
    }


    /**
     * 根据逻辑仓 查询物理仓
     * @param warehouseCode 逻辑仓
     * @param inOrOut 出库/入库
     * @param skuStatus 商品状态
     * @return
     */
    public List<WhPhysicalWarehouseVO> findRelatePhysicalWarehouseByWarehouseCode(String warehouseCode, Integer inOrOut, Integer skuStatus){
        return whInfoService.findRelatePhysicalWarehouseByWarehouseCode(warehouseCode, inOrOut, skuStatus);
    }

    public List<WhPhysicalWarehouseVO> findPhysicalWarehouseByWarehouseCode(String warehouseCode){
        return whInfoService.findPhysicalWarehouseByWarehouseCode(warehouseCode);
    }
    
    public List<WhDistrictPhysicalWarehouseVO> findDistrictPyWarehouseByCodeAndDistrictId(List<String> codes,Long districtId){
        return whInfoService.findDistrictPyWarehouseByCodeAndDistrictId(codes,districtId);
    }
    
    public List<PhyWhStockVO> findPhyWhStockByCond(PhyWhStockCond cond){
    	return whWmsSkuStockService.findPhyWhStockByCond(cond);
    }
    
    public List<WhGjStockVO> findWhGjStock(){
    	return whWmsSkuStockService.findWhGjStock();
    }
    
    public List<WhGjStockVO> findWhGjStockByLimit(int pageSize,int pageNum){
    	return whWmsSkuStockService.findWhGjStockByLimit(pageSize,pageNum);
    }

    /**
     * 查找物理逻辑仓关联关系
     * @param cond
     * @return
     */
    public List<WhPhysicalWarehouseRelateWarehouseVO> findPhysicalWarehouseRelateWarehouseByCond(final WhPhysicalWarehouseRelateWarehouseVO cond){
        return whInfoService.findPhysicalWarehouseRelateWarehouseByCond(cond);
    }

    /**
     * 根据逻辑仓->默认的出入类型->物理仓
     * @param warehouseCode 物理仓编码
     * @param relateInOrOut 逻辑仓分类类型 [1入 2出]
     * @return
     */
    public WhPhysicalWarehouse findPhysicalWarehouseByWarehouseGroupCond(final String warehouseCode,Integer relateInOrOut){
        return whInfoService.findPhysicalWarehouseByWarehouseGroupCond(warehouseCode,relateInOrOut);
    }

    /**
     * 获取差异邮件信息
     * @param cond
     * @return
     */
    public List<WhAllotDiffSendMessageVO> getWhAllotDiffMessage(WhAllotCond cond){
    	return whAllotService.getWhAllotDiffMessage(cond);
    }

    public List<WhWmsCommandConnectVO> findCommandConnectByCond(WhWmsCommandConnectCond cond){
        return whWmsCommandConnectService.findByCond(cond);
    }

    public List<WhPhysicalWarehouse> findPhysicalWarehouseByType(List<Integer> warehouseTypeList) {
        return whInfoService.findPhysicalWarehouseByType(warehouseTypeList);
    }

    public int saveAutoAllotRule(WhAutoAllotRuleVO whAutoAllotRule) throws Exception {
        return whAutoAllotService.saveAutoAllotRule(whAutoAllotRule);
    }

    public List<WhAutoAllotRuleVO> findHisRules(String bu, short allotChannel) {
        return whAutoAllotService.findHisRules(bu, allotChannel);
    }
    public List<WhAutoAllotExcludeCategory> findExcludeCategorysByRuleId(Integer ruleId) {
        return whAutoAllotService.findExcludeCategorysByRuleId(ruleId);
    }
    public List<WhAutoAllotCallbackExcludeCategory> findCallbackExcludeCategorysByRuleId(Integer ruleId) {
        return whAutoAllotService.findCallbackExcludeCategorysByRuleId(ruleId);
    }
    public void executeAutoAllot(Long operatorId,String bu, boolean isAuto) throws Exception {
        whAutoAllotService.executeAutoAllot(operatorId, bu, isAuto);
    }
    public void cronExecuteAutoAllot(Long operatorId) throws Exception {
        whAutoAllotService.cronExecuteAutoAllot(operatorId);
    }
    public void executeAutoAllotOnline(Long operatorId, boolean isAuto) throws Exception {
        whAutoAllotService.executeAutoAllotOnline(operatorId, isAuto);
    }
    public PageInfo<WhAutoAllotRecordVO> findAutoAllotRecords(WhAutoAllotCond whAutoAllotCond) {
        return whAutoAllotService.findAutoAllotRecords(whAutoAllotCond);
    }
    public List<WhAutoAllotRecordDetailVO> findDetailByRecordId(Integer recordId) {
        return whAutoAllotService.findDetailByRecordId(recordId);
    }

    public Set<String> cancleExecuteAutoAllot(Integer recordId) throws Exception {
        return whAutoAllotService.cancleExecuteAutoAllot(recordId);
    }

    public Set<String> confirmExecuteAutoAllot(Integer recordId) throws Exception {
        return whAutoAllotService.confirmExecuteAutoAllot(recordId);
    }

    public WhAutoAllotRuleVO findCurrentRule(String bu, short allotChannel) {
        if (allotChannel == 0) {
            return  whAutoAllotService.findCurrentRule(bu,true);
        } else {
            return whAutoAllotService.findCurrentRuleOnline(true);
        }

    }

    public int updatePlanedDyDateByReCodes(List<WhCommand> whCommandList) {
        return whCommandService.updatePlanedDyDateByReCodes(whCommandList);
    }

    public List<WhWarehouseGroupVO> findWhGroupByCodeOrName(String codeOrName) {
        return whWarehouseGroupService.findByCodeOrName(codeOrName);
    }

    public List<WhWarehouseGroupVO> findWhGroupByIds(List<Long> ids) {
        return whWarehouseGroupService.findByIds(ids);
    }

    // ########### 生产加工主耗材详情系列操作 start#############
    public boolean createWhWmsPrdcMaterialDetail(WhWmsPrdcMaterialDetail record){
        return whWmsPrdcMaterialDetailService.create(record);
    }

    public boolean batchCreateWhWmsPrdcMaterialDetail(List<WhWmsPrdcMaterialDetail> records){
        return whWmsPrdcMaterialDetailService.batchCreate(records);
    }

    /**
     * 更新主耗材详情信息
     * @param record
     * @return
     */
    Boolean updateById(WhWmsPrdcMaterialDetail record){
        return whWmsPrdcMaterialDetailService.updateById(record);
    }

    Boolean updateByCond(WhWmsPrdcMaterialDetail record,WhWmsPrdcMaterialDetailCond cond){
        return whWmsPrdcMaterialDetailService.updateByCond(record,cond);
    }

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    WhWmsPrdcMaterialDetail findWhWmsPrdcMaterialDetailById(Long id){
        return whWmsPrdcMaterialDetailService.findWhWmsPrdcMaterialDetailById(id);
    }

    /**
     * 根据条件查询加工主耗材信息列表
     * @param cond
     * @return
     */
    public List<WhWmsPrdcMaterialDetail> listWhWmsPrdcMaterialDetailByCond(WhWmsPrdcMaterialDetailCond cond){
        return whWmsPrdcMaterialDetailService.listWhWmsPrdcMaterialDetailByCond(cond);
    }

    public List<WhWmsPrdcMaterialDetailVO> listWhWmsPrdcMaterialDetailVOByCond(WhWmsPrdcMaterialDetailCond cond){
        return whWmsPrdcMaterialDetailService.listWhWmsPrdcMaterialDetailVOByCond(cond);
    }
    // ########### 生产加工主耗材详情系列操作 end #############


    public Integer checkIfAnyMoveStockAssigned (List<String> codeList) {
        return whWmsTaskAssignService.checkIfAnyMoveStockAssignEd(codeList);
    }

    public List<WhWarehouseVO> findWarehouseByGroupId(Long warehouseGroupId) {
      return whInfoService.findWarehouseByGroupId(warehouseGroupId);
    }

    public Boolean addOrEditCrossGoodsApply(WhCrossGoods whCrossGoods) {
        return whCrossGoodsService.addOrEditCrossGoodsApply(whCrossGoods);
    }

    public Boolean approveCrossGoodsApply(WhCrossGoods whCrossGoods) throws Exception {
        return whCrossGoodsService.approveCrossGoodsApply(whCrossGoods);
    }

    public Pagination<WhCrossGoodsVO> listCrossGoods(WhCrossGoodsCondVO cond) {
        return whCrossGoodsService.listCrossGoods(cond);
    }

    public WhCrossGoodsVO detailCrossGoods(Long id) {
        return whCrossGoodsService.detailCrossGoods(id);
    }

    public Integer batchApproveCrossGoodsApply(List<Long> ids, Integer status, Long operatorId, String approveRemark) throws Exception {
        return whCrossGoodsService.batchUpdate(ids, status, operatorId, approveRemark);
    }


    public Pagination<TmallStockLogVO> findTmallStockLogByCond(TmallStockLogCond cond) {
        return tmallStockLogService.findByCond(cond);
    }


    public TmallStockLogVO findTmallStockLogDetailById(Integer id) {
        return tmallStockLogService.findDetailById(id);
    }

    public Boolean dealOuterStockSyn(Integer id, String remark) {
        return tmallStockLogService.dealOuterStockSyn(id, remark);
    }

    public String officialWebSiteAllot(Integer id, Long operatorId, String operatorName) throws Exception {
        return tmallStockLogService.officialWebSiteAllot(id, operatorId, operatorName);
    }

    public List<TmallStockLogVO> findFailedSyncByAllotCode(String allotCode) {
        return tmallStockLogService.findFailedSyncByAllotCode(allotCode);
    }

    public Integer addOrEditBondedWarehouseAllotApply(BondedWarehouseAllotApplyVO allotApplyVO) {
        return whBondedWarehouseAllotApplyService.addOrEditBondedWarehouseAllotApply(allotApplyVO);
    }

    public Pagination<WhTlBuyerApplyVO> findByCondBondedWarehouseAllotApply(WhTlBuyerApplyCondVO whTlBuyerApplyCondVO) {
        return whBondedWarehouseAllotApplyService.findByCond(whTlBuyerApplyCondVO);
    }
    public WhTlBuyerApplyVO findById(Integer id) {
        return whBondedWarehouseAllotApplyService.findById(id);
    }

    public Integer approveBondedWarehouseAllotApply (BondedWarehouseAllotApplyVO allotApplyVO) {
        return whBondedWarehouseAllotApplyService.approveApply(allotApplyVO);
    }

    public Integer cancelApply(Integer id) {
        return whBondedWarehouseAllotApplyService.cancelApply(id);
    }
    public Integer batchPackage (List<Integer> ids,String name,Long operatorId) throws Exception {
        return whBondedWarehouseAllotApplyService.batchPackage(ids,name,operatorId);
    }

    public Integer batchUpdate (List<Integer> applyIds,Integer buyerPackageId) {
        return whBondedWarehouseAllotApplyService.batchUpdate(applyIds,buyerPackageId);
    }

    //whTlBuyerPackageService
    public Pagination<WhTlBuyerPackageOrderVO> findPackageOrderByCond(WhTlBuyerApplyCondVO whTlBuyerApplyCondVO) {
        return whTlBuyerPackageService.findByCond(whTlBuyerApplyCondVO);
    }

    public WhTlBuyerPackageOrderVO findPackageOrderDetailById (Integer id) {
        return whTlBuyerPackageService.findById(id);
    }

    public List<WhTlBuyerPackageOrderVO> findPackageOrderDetailByIds (List<Integer> ids) {
        return whTlBuyerPackageService.findByIds(ids);
    }

    public Integer packageOrderInOrOutBond(BondedWarehouseAllotPackageVO saveVO) throws Exception {
        return whTlBuyerPackageService.packageOrderInOrOutBond(saveVO);
    }

    public WhTlBuyerPackage findBuyerPackageDetailByIdForExceal(Integer buyerPackageId) {
        return whTlBuyerPackageService.findBuyerPackageDetailByIdForExceal(buyerPackageId);
    }

    public Map<String,Integer> findSkuSynQtyCountByCond(TmallStockLogCond cond) {
        return tmallStockLogService.findSkuSynQtyCountByCond(cond);
    }

    public void createAllotsCron() throws Exception {
        whAllotStoreApplicationService.createAllotsCron();
    }

    public void autoAllotForLbLimitSale() {
        whAutoAllotService.autoAllotForLbLimitSale();
    }

}