/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse;

import java.util.List;
import java.util.Map;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotStoreApplicationCond;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.vo.ThirdpartyGoodsQuantityRequest;
import com.thebeastshop.pegasus.util.vo.ThirdpartyGoodsQuantityResponse;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.vo.WhJitPackageSkuReferenceVO;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;

/**
 * @author Royan
 * @version $Id: PegasusWarehouseInnerServiceFacade.java, v 0.1 2015-07-01 下午3:00
 */
public class PegasusWarehouseInnerServiceFacade {

    private final static Logger LOGGER = LoggerFactory
            .getLogger(PegasusWarehouseInnerServiceFacade.class);

    private static PegasusWarehouseInnerServiceFacade instance;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhInvService whInvService;

    @Autowired
    private WhAllotService whAllotService;

    @Autowired
    private WhProxyService whProxyService;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private WhAllotStoreApplicationService whAllotStoreApplicationService;
    @Autowired
    private WhThirdPartyService whThirdPartyService;

    private PegasusWarehouseInnerServiceFacade() {

    }

    public static PegasusWarehouseInnerServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }

        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                LOGGER.info("[fasade init start] PegasusWarehouseInnerServiceFacade");
                new ClassPathXmlApplicationContext("pegasus-service-warehouse/spring.xml");
                LOGGER.info("[fasade init finish] PegasusWarehouseInnerServiceFacade");
            }
            instance = (PegasusWarehouseInnerServiceFacade) SpringUtil
                    .getBean("pegasusWarehouseInnerServiceFacade");
        }
        return instance;
    }

    // whCommandService

    /**
     * 创建指令
     *
     * @param whCommand 指令
     * @return 指令编码
     * @throws Exception
     */
    public String createCommand(final WhCommand whCommand) throws Exception {
        return whCommandService.createCommand(whCommand);
    }

    /**
     * 创建指令，并自动完成
     *
     * @param whCommand 指令
     * @return 指令编码
     * @throws Exception
     */
    public String createCommandThenFinish(final WhCommand whCommand) throws Exception{
        return whCommandService.createCommandThenFinish(whCommand);
    }
    public void saveOrUpdateApplicationPara(String bu,boolean autoAudit){
        whInfoService.saveOrUpdateApplicationPara(bu,autoAudit);
    }
    public WhApplicatPara findWhApplicationParaByBu(String bu){
        return  whInfoService.findWhApplicationParaByBu(bu);
    }
    public List<WhApplicatPara> findAllWhApplicationPara(){
        return  whInfoService.findAllWhApplicationPara();
    }
    public List<WhApplicatParaSku> findWhApplicationParaSkuBySkuCode(String skuCode){
        return whInfoService.findWhApplicationParaSkuBySkuCode(skuCode);
    }
    public void insertApplicationParaSku(WhApplicatParaSku whApplicatParaSku){
       whInfoService.insertApplicationParaSku(whApplicatParaSku);
    }
    public void deleteApplicationParaSku(String skuCode){
       whInfoService.deleteApplicationParaSku(skuCode);
    }
    public List<WhApplicatParaSku> findAllWhApplicationParaSku(){
        return whInfoService.findAllWhApplicationParaSku();
    }
    /**.
     * 创建指令，并自动完成
     *
     * @param whCommands 指令
     * @return 指令编码
     * @throws Exception
     */
    public List<String> createCommandsThenFinish(final List<WhCommand> whCommands) throws Exception{
        return whCommandService.createCommandsThenFinish(whCommands);
    }

    /**
     * 释放SKU库存后创建指令
     *
     * @param whCommand                 指令
     * @param whReleaseOccupationVOList 释放占用
     * @return 指令编码
     * @throws Exception
     */
    public String createCommandAfterRelease(final WhCommand whCommand,
                                            final List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return whCommandService.createCommandAfterRelease(whCommand, whReleaseOccupationVOList);
    }

    public String createCommandWithoutOccupy(final WhCommand whCommand){
        return whCommandService.createCommandWithoutOccupy(whCommand);
    }

    /**
     * 占用SKU库存后创建指令
     *
     * @param whCommand       指令
     * @param whInvOccupyList SKU库存占用列表
     * @return 指令编码
     * @throws Exception
     */
    public String createCommandAfterOccupy(final WhCommand whCommand, final List<WhInvOccupy> whInvOccupyList) throws Exception {
        return whCommandService.createCommandAfterOccupy(whCommand, whInvOccupyList);
    }

    /**
     * 释放SKU库存后创建指令，并自动完成
     *
     * @param whCommand                 指令
     * @param whReleaseOccupationVOList
     * @return 指令编码
     * @throws Exception
     */
    public String createCommandAfterReleaseThenFinish(final WhCommand whCommand,
                                                      final List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return whCommandService.createCommandAfterReleaseThenFinish(whCommand,
                whReleaseOccupationVOList);
    }

    public String createCommandThenFinishWithoutOccupy(final WhCommand whCommand,final List<WhReleaseOccupationVO> releaseList) {
        return whCommandService.createCommandThenFinishWithoutOccupy(whCommand,releaseList);
    }

    /**
     * 释放SKU库存后创建指令，并自动完成
     *
     * @param whCommands                 指令
     * @param whReleaseOccupationVOList
     * @return 指令编码
     * @throws Exception
     */
    public List<String> createCommandsAfterReleaseThenFinish(final List<WhCommand> whCommands,
                                                             final List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return whCommandService.createCommandsAfterReleaseThenFinish(whCommands,
                whReleaseOccupationVOList);
    }

    /**
     * 释放SKU库存后创建指令，并自动完成-scm生产加工使用
     *
     * @param whCommands                 指令
     * @param whReleaseOccupationVOList
     * @return 指令编码
     * @throws Exception
     */
    public List<String> createCommandsAfterReleaseThenFinishForPrdc(final List<WhCommand> whCommands,
                                                                    final List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return whCommandService.createCommandsAfterReleaseThenFinishForPrdc(whCommands,
                whReleaseOccupationVOList);
    }

    /**
     * 占用SKU库存后创建指令，并自动完成
     *
     * @param whCommand                 指令
     * @param whInvOccupyList
     * @return 指令编码
     * @throws Exception
     */
    public String createCommandAfterOccupyThenFinish(final WhCommand whCommand,
                                                     final List<WhInvOccupy> whInvOccupyList) throws Exception {
        return whCommandService.createCommandAfterOccupyThenFinish(whCommand,
                whInvOccupyList);
    }
    public void releaseJitPackageOccupy(String packageCode){
        whInvService.releaseJitPackageOccupy(packageCode);
    }
    /**
     * 根据CODE查找指令
     *
     * @param code  指令编码
     * @param fetch 是否抓取行
     * @return 指令
     */
    public WhCommand findCommandByCode(final String code, final boolean fetch) {
        return whCommandService.findCommandByCode(code, fetch);
    }
    public WhCommand findCommandById(final Integer id, final boolean fetch) {
        return whCommandService.findCommandById(id, fetch);
    }
    /**
     * 根据CODE列表查找指令列表
     *
     * @param codeList 指令编码列表
     * @param fetch    是否抓取行
     * @return 指令列表
     * @throws Exception
     */
    public List<WhCommand> findCommandByCodes(final List<String> codeList, final boolean fetch) throws Exception {
        return whCommandService.findCommandByCodes(codeList, fetch);
    }

    /**
     * 根据出入库类型和相关单据号查找指令
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @param fetch         是否抓取行
     * @return 是否成功
     */
    public WhCommand findCommandByTypeAndReferenceCode(final Integer type, final String referenceCode,
                                                       final boolean fetch) {
        return whCommandService.findCommandByTypeAndReferenceCode(type, referenceCode, fetch);
    }

    /**
     * 根据相关单据号查找指令
     *
     * @return 是否成功
     */
    public WhCommand findCommandByReferenceCode(String referenceCode) {
        return whCommandService.findCommandByReferenceCode(referenceCode);
    }

    /**
     * 根据出入库类型和相关单据号重置指令相关单据号
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     */
    public void resetCommandReferenceCodeByTypeAndReferenceCode(final Integer type, final String referenceCode) {
        whCommandService.resetCommandReferenceCodeByTypeAndReferenceCode(type, referenceCode);
    }

    /**
     * 占用前根据出入库类型和相关单据号重置指令相关单据号
     *
     * @param type
     * @param referenceCode
     */
    public void resetCommandReferenceCodeByTypeAndReferenceCodeBeforeOccupy(final Integer type,
                                                                            final String referenceCode,
                                                                            final List<WhInvOccupy> whInvOccupyList) {
        whCommandService.resetCommandReferenceCodeByTypeAndReferenceCodeBeforeOccupy(type,
                referenceCode, whInvOccupyList);
    }

    // whInvService

    /**
     * 记录SKU库存占用
     *
     * @param whInvOccupy SKU库存占用
     */
  /*  public void occupy(final WhInvOccupy whInvOccupy) {
        whInvService.occupy(whInvOccupy);
    }*/

    /**
     * 记录SKU库存占用
     *
     * @param whInvOccupyList SKU库存占用列表
     */
    public void occupy(final List<WhInvOccupy> whInvOccupyList) {
        whInvService.occupy(whInvOccupyList);
    }

    /*public List<WhInvOccupy> occupyLeast(final List<WhInvOccupy> whInvOccupyList){
        return whInvService.occupyLeast(whInvOccupyList);
    }*/



    /**
     * 记录SKU库存占用
     *
     * @param whInvOccupyList SKU库存占用列表
     */
    public void occupy(final List<WhInvOccupy> whInvOccupyList,List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList) {
        whInvService.occupy(whInvOccupyList,whJitPackageSkuReferenceVOList);
    }

    public void occupCustomization(final List<WhInvOccupy> whInvOccupyList,List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList,List<WhAllotRcd> allotList){

    }

    /**
     * 记录SKU库存占用
     *
     * @param whInvOccupyList SKU库存占用列表
     */
    public void occupy(final List<WhInvOccupy> whInvOccupyList,List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList,String allotCode) {
        whInvService.occupy(whInvOccupyList,whJitPackageSkuReferenceVOList,allotCode);
    }

    /**
     * 释放SKU库存后占用
     * 同时创建包裹sku关联
     * @param whInvOccupyList
     * @param whReleaseOccupationVOList
     */
    public void occupyAfterRelease(final List<WhInvOccupy> whInvOccupyList,
                                   final List<WhReleaseOccupationVO> whReleaseOccupationVOList
            ,String referenceCode, List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList) {
        whInvService.occupyAfterRelease(whInvOccupyList, whReleaseOccupationVOList,referenceCode,whJitPackageSkuReferenceVOList);
    }


    /**
     * 释放SKU库存后占用
     *
     * @param whInvOccupyList
     * @param whReleaseOccupationVOList
     */
  /*  public void occupyAfterRelease(final List<WhInvOccupy> whInvOccupyList,
                                   final List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        whInvService.occupyAfterRelease(whInvOccupyList, whReleaseOccupationVOList);
    }*/

    /**
     * 根据占用类型和相关单据号释放SKU库存占用
     *
     * @param whReleaseOccupationVO 释放占用
     */
   public void releaseOccupation(final WhReleaseOccupationVO whReleaseOccupationVO) {
        whInvService.releaseOccupation(whReleaseOccupationVO);
    }

    /**
     * 根据占用类型和相关单据号释放SKU库存占用
     *
     * @param whReleaseOccupationVOList 释放占用
     */
  /*  public void releaseOccupation(final List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        whInvService.releaseOccupation(whReleaseOccupationVOList);
    }
    */


    public void releaseOccupation(final List<WhReleaseOccupationVO> whReleaseOccupationVOList,List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList) {
        whInvService.releaseOccupation(whReleaseOccupationVOList,whJitPackageSkuReferenceVOList);
    }

    /**
     * 根据SKU编码查找可用库存数量
     *
     * @param skuCode SKU编码
     * @return Map<仓库编码,库存数量>
     */
    public Map<String, WhInvVO> findCanUseQttBySkuCode(final String skuCode) {
        return whInvService.findCanUseQttBySkuCode(skuCode);
    }

    /**
     * 根据SKU编码和仓库编码查找可用库存数量
     *
     * @param skuCode       SKU编码
     * @param warehouseCode 仓库编码
     * @return 库存数量
     */
    public WhInvVO findCanUseQttBySkuCodeAndWarehouseCode(final String skuCode, final String warehouseCode) {
        return whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode, warehouseCode);
    }
    /**
     * 根据SKU编码和仓库编码查找可用库存数量
     *
     * @param
     * @param warehouseCode 仓库编码
     * @return 库存数量
     */
    public  Map<String, WhInvVO> findCanUseQttBySkuCodesAndWarehouseCode(List<String> skuCodes, String warehouseCode) {
        return whInvService.findCanUseQttBySkuCodesAndWarehouseCode(skuCodes, warehouseCode);
    }

    // whAllotService

    /**
     * 根据CODE查找调拨单
     *
     * @param code     调拨单CODE
     * @param fetchSku 是否抓取调拨单SKU
     * @return 调拨单
     */
    public WhAllotRcd findAllotRcdByCode(final String code, final boolean fetchSku) {
        return whAllotService.findAllotRcdByCode(code, fetchSku);
    }

    /**
     * 根据类型和相关单据查找调拨
     *
     * @param type
     * @param referenceCode
     * @param fetchSku
     * @return
     */
    public WhAllotRcd findAllotRcdByTypeAndReferenceCode(final Integer type, final String referenceCode,
                                                         final boolean fetchSku) {
        return whAllotService.findAllotRcdByTypeAndReferenceCode(type, referenceCode, fetchSku);
    }

    /**
     * 创建调拨单
     *
     * @param whAllotRcd 调拨单
     * @return 调拨单号
     * @throws Exception
     */
    public String createAllotRcd(final WhAllotRcd whAllotRcd) throws Exception {
        return whAllotService.createAllotRcd(whAllotRcd);
    }

    /**
     * 创建调拨单
     *
     * @param whAllotRcds 调拨单
     * @return 调拨单号
     * @throws Exception
     */
    public List<String> createAllotRcds(final List<WhAllotRcd> whAllotRcds) throws Exception{
        return whAllotService.createAllotRcds(whAllotRcds);
    }



    /**
     * 根据出入库类型和相关单据号取消指令
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @return 是否成功
     */
    public boolean cancelCommandByTypeAndReferenceCode(final Integer type, final String referenceCode) {
        return whCommandService.cancelCommandByTypeAndReferenceCode(type, referenceCode);
    }

    /**
     * 先释放占用,再根据出入库类型和相关单据号取消指令
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @param whReleaseOccupationVOList 释放占用列表
     * @return 是否成功
     */
    public boolean cancelCommandByTypeAndReferenceCodeAfterRelease(final Integer type, final String referenceCode, final List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        return whCommandService.cancelCommandByTypeAndReferenceCodeAfterRelease(type, referenceCode, whReleaseOccupationVOList);
    }

    /**
     * 根据出入库类型和相关单据号取消指令,再占用
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @param whInvOccupyList 占用列表
     * @return 是否成功
     */
    public boolean cancelCommandByTypeAndReferenceCodeBeforeOccupy(final Integer type,
                                                                   final String referenceCode,
                                                                   final List<WhInvOccupy> whInvOccupyList) {
        return whCommandService.cancelCommandByTypeAndReferenceCodeBeforeOccupy(type,
                referenceCode, whInvOccupyList);
    }

    /**
     * 根据出入库类型和相关单据号取消指令,指令不占用
     *
     * @param type          出入库类型
     * @param referenceCode 相关单据号
     * @return 是否成功
     */
    public boolean cancelCommandByTypeAndReferenceCodeWithoutOccupy(final Integer type,
                                                                   final String referenceCode) {
        return whCommandService.cancelCommandByTypeAndReferenceCodeWithoutOccupy(type,referenceCode);
    }


    /**
     * 动作序列
     * 1.创建指令并自动完成
     * 2.创建占用
     *
     * @param commandList
     * @param occupyList
     * @return
     * @throws Exception
     */
    public boolean firstMethodCreateCommandThenFinishAnotherMethodOccupy(final List<WhCommand> commandList,final List<WhInvOccupy> occupyList) throws Exception{
        return whProxyService.firstMethodCreateCommandThenFinishAnotherMethodOccupy(commandList,occupyList);
    }

    /**
     * 判断两个是否库间移动（瞬间完成）
     *
     * @param warehouseCode1 逻辑仓1
     * @param warehouseCode2 逻辑仓2
     * @return
     */
    @Deprecated
    public boolean isWarehouseMove(final String warehouseCode1, final String warehouseCode2){
        return whInfoService.isWarehouseMove(warehouseCode1,warehouseCode2);
    }

    public boolean isWarehouseInSameWarehouseGroup(final String warehouseCode1, final String warehouseCode2){
        return whInfoService.isWarehouseInSameWarehouseGroup(warehouseCode1,warehouseCode2);
    }

    public boolean colseCommandByReferenceCode(int inoutType,String referenceCode){
        return whCommandService.colseCommandByReferenceCode(inoutType,referenceCode);
    }

    public List<String> createAllotRcdByList(final List<WhAllotRcdVO> whAllotRcdVOList) throws Exception{
        return  whAllotService.createAllotRcdByList(whAllotRcdVOList);
    }

    public boolean createAllotRcdAndPrdcJobOccupy(List<WhAllotRcd> whAllotRcds,
                                                  List<WhInvOccupy> whJobInvOccupyList, List<WhJitPackageSkuReferenceVO> whJobJitPackageSkuReferenceVOList) throws Exception{
        return whAllotService.createAllotRcdAndPrdcJobOccupy(whAllotRcds,whJobInvOccupyList,whJobJitPackageSkuReferenceVOList);
    }


    /**
     * 根据移库单反向移库
     * @param code
     * @return

     * @throws Exception
     */
    public boolean revertAllotRcd(final String code) throws Exception{
        return whAllotService.revertAllotRcd(code);
    }

    public boolean cancelCommand(WhCommand whCommand){
        return whCommandService.cancelCommand(whCommand);
    }

    public boolean cancelCommandforShortage(String commandCode){
        return whCommandService.cancelCommandforShortage(commandCode);
    }

    public boolean cancelCommandForSalesOrder(List<WhCommand> whCommands, List<SStockReleaseDTO> releaseList){
        return whCommandService.cancelCommandForSalesOrder(whCommands, releaseList);
    }

    /**
     * 完成指令
     *
     * @param rcd 指令
     * @return 是否成功
     */
    public boolean finishCommand(WhCommand rcd) throws Exception{
            return whCommandService.finishCommand(rcd);
    }

    /**
     * 完成指令
     *
     * @param rcd 指令
     * @return 是否成功
     */
    public boolean finishCommandWithoutOccupy(WhCommand rcd){
        return whCommandService.finishCommandWithoutOccupy(rcd);
    }

    /**
     * 完成指令
     *
     * @param rcd 指令
     * @return 是否成功
     */
    public boolean finishCommandWithoutOccupy(WhCommand rcd,List<WhReleaseOccupationVO> releaseList){
        return whCommandService.finishCommandWithoutOccupy(rcd,releaseList);
    }

    public void releaseWhCommandOccupy(WhCommand rcd){
        whCommandService.releaseWhCommandOccupy(rcd);
    }

    public void updateCommand(WhCommand whCommand){
        whCommandService.updateCommand(whCommand);
    }

    public List<WhInvOccupy> getWhInvOccupy(List<String> referenceCodes){
        return whInvService.getWhInvOccupy(referenceCodes);
    }

    public void cancelAllotRcdCommandByTypeAndReferenceCode(Integer type, String referenceCode) {
        whCommandService.cancelAllotRcdCommandByTypeAndReferenceCode(type, referenceCode);
    }

    /**
     * 获取抢购活动指定商品的可用库存
     * @param wareHouseCode
     * @param campaignCode
     * @param skuCode
     * @return
     */
    public Integer getPanicBuyCampaignOccupy(String wareHouseCode, String campaignCode, String skuCode){
        return whInvService.findOccupyByCampaignCodeAndSkuCode(wareHouseCode, campaignCode, skuCode);
    }

    /**
     * 抢购活动占用库存
     * @param params
     * @return
     */
    public Map<String, List<Long>> campaignOccupy(Map<String, List<WhInvOccupy>> params){
        return whInvService.campaignOccupy(params);
    }

    /**
     * 删除抢购活动占用
     * @param releaseList
     */
    //public void deleteCampaignOccupation(List<WhReleaseOccupationVO> releaseList) {
    //    whInvService.deleteCampaignOccupation(releaseList);
    //}
    ///**
    // * 权宜活动占用库存
    // * @param params
    // * @return
    // */
    //public Map<String, List<Long>> interestOccupy(Map<String, List<WhInvOccupy>> params){
    //    return whInvService.interestOccupy(params);
    //}

    /**
     * 权宜活动占用库存
     * @param params
     * @return
     */
    public WhInvOccupy findOccupyQttByReferenceCode(String referenceCode ){
        return whInvService.findOccupyQttByReferenceCode(referenceCode);
    }
    public List<WhCommandSku> findDiffCommandSkuByCommandReferenceCodes(List<String> allotCodeList){
       return whCommandService.findDiffCommandSkuByCommandReferenceCodes(allotCodeList);
    }
    public Integer autoCloseCommandInEndMonth () {
        return whCommandService.autoCloseCommandInEndMonth();
    }

    public void updateCommandSku(WhCommandSku whCommandSku){
        whCommandService.updateCommandSku(whCommandSku);
    }

    public List<String> findGoodWarehouseCode() {
      return whInfoService.findGoodWarehouseCode();
    }

    public int applicationAllot(WhAllotStoreApplicationVO storeApplication) throws Exception {
      return whAllotStoreApplicationService.applicationAllot(storeApplication);
    }
    public WhAllotStoreApplication findApplicationByKey(Integer id){
        return whAllotStoreApplicationService.findApplicationByKey(id);
    }
  public PageInfo<WhAllotStoreApplicationSkuVO> listApplicationRecord(WhAllotStoreApplicationCond cond) {
      return whAllotStoreApplicationService.listApplicationRecord(cond);
  }

  public int cancelApplication(Integer applicationLineId, Long cancelPerson) throws Exception {
      return  whAllotStoreApplicationService.cancelApplication(applicationLineId, cancelPerson);
  }

  public PageInfo<WhAllotStoreApplicationSkuVO> listApprovalListByCond(WhAllotStoreApplicationCond cond) {
      return whAllotStoreApplicationService.listApprovalListByCond(cond);
  }

  public List<WhAllotStoreApplicationSkuVO> approve(WhAllotStoreApplicationApproveVO approveVO,Map<String,WhAllotStoreApplicationSkuRefusedDateVO> skuPurchaseOrderMap) throws Exception {
      return whAllotStoreApplicationService.approve(approveVO,skuPurchaseOrderMap);
  }

  public PageInfo<WhAllotStoreApplicationSkuVO> listChannelGroupApplicationBySkuCode(WhAllotStoreApplicationCond cond) {
      return whAllotStoreApplicationService.listChannelGroupApplicationBySkuCode(cond);
  }

  public void nofityStoreAllotApplovalResult() {
    whAllotStoreApplicationService.nofityApplovalResult();
  }

  public ThirdpartyGoodsQuantityResponse syncThirdpartyGoodsStocks(ThirdpartyGoodsQuantityRequest goodsQuantitySyncVO) throws Exception {
    return whThirdPartyService.syncCommodityStocks(goodsQuantitySyncVO);
  }
}