/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.service.purchase.cond.PurchaseFlowerReceiveOrderCond;
import com.thebeastshop.pegasus.service.purchase.cond.PurchaseFlowerSupplierReportCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseFlowerReceiveOrderItemMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseFlowerReceiveOrderMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlowerReceiveOrderItem;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlowerReceiveOrderItemExample;
import com.thebeastshop.pegasus.service.purchase.service.PurchaseFlowerReceiveOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseFlowerReceiveOrderItemVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseFlowerReceiveOrderVO;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseFlowerSupplierReportVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseFlowerReceiveOrderService")
public class PurchaseFlowerReceiveOrderServiceImpl
implements PurchaseFlowerReceiveOrderService {
    @Autowired
    private PcsPurchaseFlowerReceiveOrderMapper pcsPurchaseFlowerReceiveOrderMapper;
    @Autowired
    private PcsPurchaseFlowerReceiveOrderItemMapper pcsPurchaseFlowerReceiveOrderItemMapper;

    @Override
    public Pagination<PcsPurchaseFlowerReceiveOrderVO> findByCond(PurchaseFlowerReceiveOrderCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.pcsPurchaseFlowerReceiveOrderMapper.countByCond(cond);
        page.setRecord(Integer.valueOf(count));
        if (!NumberUtil.isNullOrZero((Number)count)) {
            List<PcsPurchaseFlowerReceiveOrderVO> flowerVOList = this.pcsPurchaseFlowerReceiveOrderMapper.findByCond(cond);
            page.setResultList(flowerVOList);
        }
        return page;
    }

    @Override
    public List<PcsPurchaseFlowerReceiveOrderVO> findByCondForExportExcel(PurchaseFlowerReceiveOrderCond cond) {
        cond.setPagenum(Integer.MAX_VALUE);
        List<PcsPurchaseFlowerReceiveOrderVO> receiveOrderVOS = this.pcsPurchaseFlowerReceiveOrderMapper.findByCond(cond);
        if (CollectionUtils.isNotEmpty(receiveOrderVOS)) {
            for (PcsPurchaseFlowerReceiveOrderVO pcsPurchaseFlowerReceiveOrderVO : receiveOrderVOS) {
                PcsPurchaseFlowerReceiveOrderItemExample example = new PcsPurchaseFlowerReceiveOrderItemExample();
                example.createCriteria().andReceivePlanIdEqualTo(pcsPurchaseFlowerReceiveOrderVO.getId());
                List<PcsPurchaseFlowerReceiveOrderItem> purchaseFlowerPlanItems = this.pcsPurchaseFlowerReceiveOrderItemMapper.selectByExample(example);
                for (PcsPurchaseFlowerReceiveOrderItem purchaseFlowerPlanItemVO : purchaseFlowerPlanItems) {
                    purchaseFlowerPlanItemVO.setTbIdStr("skuLine_" + purchaseFlowerPlanItemVO.getPurchaseFlowerCode() + "-" + purchaseFlowerPlanItemVO.getUseChannel());
                }
                pcsPurchaseFlowerReceiveOrderVO.setReceiveOrderItems(BeanUtil.buildListFrom(purchaseFlowerPlanItems, PcsPurchaseFlowerReceiveOrderItemVO.class));
            }
        }
        return receiveOrderVOS;
    }

    @Override
    public Integer addOrEditPurchaseFlowerReceiveOrder(PcsPurchaseFlowerReceiveOrderVO pcsPurchaseFlowerReceiveOrderVO) {
        if (null == pcsPurchaseFlowerReceiveOrderVO.getId()) {
            this.pcsPurchaseFlowerReceiveOrderMapper.insert(pcsPurchaseFlowerReceiveOrderVO);
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("id", pcsPurchaseFlowerReceiveOrderVO.getId());
            String receiveCode = CodeGenerator.getInstance().generate("PCS_REC_CODE", params);
            PcsPurchaseFlowerReceiveOrderVO updateVO = new PcsPurchaseFlowerReceiveOrderVO();
            updateVO.setId(pcsPurchaseFlowerReceiveOrderVO.getId());
            updateVO.setCode(receiveCode);
            updateVO.setStatus(1);
            this.pcsPurchaseFlowerReceiveOrderMapper.updateByPrimaryKeySelective(updateVO);
            if (CollectionUtils.isNotEmpty(pcsPurchaseFlowerReceiveOrderVO.getReceiveOrderItems())) {
                for (PcsPurchaseFlowerReceiveOrderItem pcsPurchaseFlowerReceiveOrderItem : pcsPurchaseFlowerReceiveOrderVO.getReceiveOrderItems()) {
                    pcsPurchaseFlowerReceiveOrderItem.setReceivePlanId(pcsPurchaseFlowerReceiveOrderVO.getId());
                }
            }
            return this.pcsPurchaseFlowerReceiveOrderItemMapper.batchInsert(pcsPurchaseFlowerReceiveOrderVO.getReceiveOrderItems());
        }
        this.pcsPurchaseFlowerReceiveOrderMapper.updateByPrimaryKeySelective(pcsPurchaseFlowerReceiveOrderVO);
        PcsPurchaseFlowerReceiveOrderItemExample example = new PcsPurchaseFlowerReceiveOrderItemExample();
        example.createCriteria().andReceivePlanIdEqualTo(pcsPurchaseFlowerReceiveOrderVO.getId());
        this.pcsPurchaseFlowerReceiveOrderItemMapper.deleteByExample(example);
        return this.pcsPurchaseFlowerReceiveOrderItemMapper.batchInsert(pcsPurchaseFlowerReceiveOrderVO.getReceiveOrderItems());
    }

    @Override
    public PcsPurchaseFlowerReceiveOrderVO findById(Integer id) {
        PcsPurchaseFlowerReceiveOrderVO pcsPurchaseFlowerReceiveOrderVO = this.pcsPurchaseFlowerReceiveOrderMapper.findById(id);
        PcsPurchaseFlowerReceiveOrderItemExample example = new PcsPurchaseFlowerReceiveOrderItemExample();
        example.createCriteria().andReceivePlanIdEqualTo(id);
        List<PcsPurchaseFlowerReceiveOrderItem> pPcsPurchaseFlowerReceiveOrderItems = this.pcsPurchaseFlowerReceiveOrderItemMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(pPcsPurchaseFlowerReceiveOrderItems)) {
            pcsPurchaseFlowerReceiveOrderVO.setReceiveOrderItems(BeanUtil.buildListFrom(pPcsPurchaseFlowerReceiveOrderItems, PcsPurchaseFlowerReceiveOrderItemVO.class));
            for (PcsPurchaseFlowerReceiveOrderItemVO receiveOrderItemVO : pcsPurchaseFlowerReceiveOrderVO.getReceiveOrderItems()) {
                receiveOrderItemVO.setTbIdStr("skuLine_" + receiveOrderItemVO.getPurchaseFlowerCode() + "-" + receiveOrderItemVO.getUseChannel());
            }
        }
        return pcsPurchaseFlowerReceiveOrderVO;
    }

    @Override
    public Pagination<PurchaseFlowerSupplierReportVO> findSupplierReportByCond(PurchaseFlowerSupplierReportCond cond) throws ParseException {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.pcsPurchaseFlowerReceiveOrderMapper.countSupplierReportByCond(cond);
        page.setRecord(Integer.valueOf(count));
        if (!NumberUtil.isNullOrZero((Number)count)) {
            List<PurchaseFlowerSupplierReportVO> flowerVOList = this.pcsPurchaseFlowerReceiveOrderMapper.findSupplierReportByCond(cond);
            if (CollectionUtils.isNotEmpty(flowerVOList)) {
                NumberFormat nf = NumberFormat.getPercentInstance();
                for (PurchaseFlowerSupplierReportVO purchaseFlowerSupplierReportVO : flowerVOList) {
                    Number costRate = nf.parse(purchaseFlowerSupplierReportVO.getRate());
                    BigDecimal b = BigDecimal.valueOf(costRate.doubleValue()).add(BigDecimal.ONE);
                    purchaseFlowerSupplierReportVO.setCostBeforeTax(purchaseFlowerSupplierReportVO.getAmount().multiply(b));
                }
            }
            page.setResultList(flowerVOList);
        }
        return page;
    }

    public static void main(String[] args) throws ParseException {
        String str = "34.2%";
        NumberFormat nf = NumberFormat.getPercentInstance();
        Number m = nf.parse(str);
        System.out.println(m.doubleValue());
    }
}

