/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.service.purchase.cond.PurchaseFlowerPlanCond;
import com.thebeastshop.pegasus.service.purchase.dao.PurchaseFlowerPlanItemMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PurchaseFlowerPlanMapper;
import com.thebeastshop.pegasus.service.purchase.model.PurchaseFlowerPlanItemExample;
import com.thebeastshop.pegasus.service.purchase.service.PurchaseFlowerPlanService;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseFlowerPlanItemVO;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseFlowerPlanVO;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseFlowerPlanService")
public class PurchaseFlowerPlanServiceImpl
implements PurchaseFlowerPlanService {
    @Autowired
    private PurchaseFlowerPlanMapper purchaseFlowerPlanMapper;
    @Autowired
    private PurchaseFlowerPlanItemMapper purchaseFlowerPlanItemMapper;

    @Override
    public Pagination<PurchaseFlowerPlanVO> findByCond(PurchaseFlowerPlanCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.purchaseFlowerPlanMapper.countByCond(cond);
        page.setRecord(Integer.valueOf(count));
        if (!NumberUtil.isNullOrZero((Number)count)) {
            List<PurchaseFlowerPlanVO> flowerVOList = this.purchaseFlowerPlanMapper.findByCond(cond);
            if (CollectionUtils.isNotEmpty(flowerVOList)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
                for (PurchaseFlowerPlanVO purchaseFlowerPlanVO : flowerVOList) {
                    purchaseFlowerPlanVO.setPlanReceiveDateStr(sdf.format(purchaseFlowerPlanVO.getPlanReceiveDate()));
                }
            }
            page.setResultList(flowerVOList);
        }
        return page;
    }

    @Override
    public List<PurchaseFlowerPlanVO> findByCondForExportExcel(PurchaseFlowerPlanCond cond) {
        cond.setPagenum(Integer.MAX_VALUE);
        List<PurchaseFlowerPlanVO> purchaseFlowerPlanVOS = this.purchaseFlowerPlanMapper.findByCond(cond);
        if (CollectionUtils.isNotEmpty(purchaseFlowerPlanVOS)) {
            for (PurchaseFlowerPlanVO purchaseFlowerPlanVO : purchaseFlowerPlanVOS) {
                List<PurchaseFlowerPlanItemVO> purchaseFlowerPlanItems = this.purchaseFlowerPlanItemMapper.findByPlanId(purchaseFlowerPlanVO.getId());
                for (PurchaseFlowerPlanItemVO purchaseFlowerPlanItemVO : purchaseFlowerPlanItems) {
                    purchaseFlowerPlanItemVO.setTbIdStr("skuLine_" + purchaseFlowerPlanItemVO.getPurchaseFlowerCode() + "-" + purchaseFlowerPlanItemVO.getUseChannel());
                }
                purchaseFlowerPlanVO.setPurchaseFlowerPlanItemVOS(purchaseFlowerPlanItems);
            }
        }
        return purchaseFlowerPlanVOS;
    }

    @Override
    @Transactional
    public Integer addOrEditPurchaseFlowerPlan(PurchaseFlowerPlanVO purchaseFlowerPlanVO) {
        if (null == purchaseFlowerPlanVO.getId()) {
            purchaseFlowerPlanVO.setCreateTime(new Date());
            this.purchaseFlowerPlanMapper.insert(purchaseFlowerPlanVO);
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("id", purchaseFlowerPlanVO.getId());
            String flowerCode = CodeGenerator.getInstance().generate("PCS_POP_CODE", params);
            PurchaseFlowerPlanVO updateVO = new PurchaseFlowerPlanVO();
            updateVO.setId(purchaseFlowerPlanVO.getId());
            updateVO.setCode(flowerCode);
            updateVO.setStatus(1);
            this.purchaseFlowerPlanMapper.updateByPrimaryKeySelective(updateVO);
            if (CollectionUtils.isNotEmpty(purchaseFlowerPlanVO.getPurchaseFlowerPlanItemVOS())) {
                for (PurchaseFlowerPlanItemVO purchaseFlowerPlanItemVO : purchaseFlowerPlanVO.getPurchaseFlowerPlanItemVOS()) {
                    purchaseFlowerPlanItemVO.setPurchasePlanId(purchaseFlowerPlanVO.getId());
                }
            }
            return this.purchaseFlowerPlanItemMapper.batchInsert(purchaseFlowerPlanVO.getPurchaseFlowerPlanItemVOS());
        }
        this.purchaseFlowerPlanMapper.updateByPrimaryKeySelective(purchaseFlowerPlanVO);
        PurchaseFlowerPlanItemExample example = new PurchaseFlowerPlanItemExample();
        example.createCriteria().andPurchasePlanIdEqualTo(purchaseFlowerPlanVO.getId());
        this.purchaseFlowerPlanItemMapper.deleteByExample(example);
        return this.purchaseFlowerPlanItemMapper.batchInsert(purchaseFlowerPlanVO.getPurchaseFlowerPlanItemVOS());
    }

    @Override
    public PurchaseFlowerPlanVO findById(Integer id) {
        PurchaseFlowerPlanVO purchaseFlowerPlanVO = this.purchaseFlowerPlanMapper.findById(id);
        if (purchaseFlowerPlanVO != null) {
            List<PurchaseFlowerPlanItemVO> purchaseFlowerPlanItems = this.purchaseFlowerPlanItemMapper.findByPlanId(id);
            for (PurchaseFlowerPlanItemVO purchaseFlowerPlanItemVO : purchaseFlowerPlanItems) {
                purchaseFlowerPlanItemVO.setTbIdStr("skuLine_" + purchaseFlowerPlanItemVO.getPurchaseFlowerCode() + "-" + purchaseFlowerPlanItemVO.getUseChannel());
            }
            purchaseFlowerPlanVO.setPurchaseFlowerPlanItemVOS(purchaseFlowerPlanItems);
        }
        return purchaseFlowerPlanVO;
    }
}

