/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeSkuCond;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcRecipeSkuMapper;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeSku;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeSkuExample;
import com.thebeastshop.pegasus.service.purchase.service.PrdcRecipeSkuService;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeSkuVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="prdcRecipeSkuService")
public class PrdcRecipeSkuServiceImpl
implements PrdcRecipeSkuService {
    @Autowired
    private PrdcRecipeSkuMapper prdcRecipeSkuMapper;

    @Override
    public PrdcRecipeSkuVO findRecipeSkuVOById(Long id) {
        PrdcRecipeSku prdcRecipeSku = this.prdcRecipeSkuMapper.selectByPrimaryKey(id);
        return (PrdcRecipeSkuVO)BeanUtil.buildFrom((Object)prdcRecipeSku, PrdcRecipeSkuVO.class);
    }

    @Override
    public List<PrdcRecipeSkuVO> findRecipeSkuVOByRecipeId(Long recipeId) {
        PrdcRecipeSkuExample example = new PrdcRecipeSkuExample();
        example.createCriteria().andRecipeIdEqualTo(recipeId);
        List<PrdcRecipeSku> prdcRecipeSkus = this.prdcRecipeSkuMapper.selectByExample(example);
        return BeanUtil.buildListFrom(prdcRecipeSkus, PrdcRecipeSkuVO.class);
    }

    @Override
    public List<PrdcRecipeSkuVO> findRecipeSkuVOByCond(String skuCode, Long recipeId) {
        PrdcRecipeSkuExample example = new PrdcRecipeSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode).andRecipeIdEqualTo(recipeId);
        List<PrdcRecipeSku> prdcRecipeSkus = this.prdcRecipeSkuMapper.selectByExample(example);
        return BeanUtil.buildListFrom(prdcRecipeSkus, PrdcRecipeSkuVO.class);
    }

    @Override
    public List<PrdcRecipeSkuVO> findRecipeSkuVOByCond(PrdcRecipeSkuCond cond) {
        PrdcRecipeSkuExample example = new PrdcRecipeSkuExample();
        PrdcRecipeSkuExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        } else if (CollectionUtils.isNotEmpty(cond.getSkuCodes())) {
            criteria.andSkuCodeIn((List)cond.getSkuCodes());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getRecipeId())) {
            criteria.andRecipeIdEqualTo(cond.getRecipeId());
        } else if (CollectionUtils.isNotEmpty(cond.getRecipeIds())) {
            criteria.andRecipeIdIn((List)cond.getRecipeIds());
        }
        List<PrdcRecipeSku> prdcRecipeSkus = this.prdcRecipeSkuMapper.selectByExample(example);
        return BeanUtil.buildListFrom(prdcRecipeSkus, PrdcRecipeSkuVO.class);
    }

    @Override
    public Long create(PrdcRecipeSkuVO vo) {
        PrdcRecipeSku prdcRecipeSku = (PrdcRecipeSku)BeanUtil.buildFrom((Object)vo, PrdcRecipeSku.class);
        if (EmptyUtil.isNotEmpty((Object)prdcRecipeSku)) {
            int result = this.prdcRecipeSkuMapper.insert(prdcRecipeSku);
            return Long.parseLong(result + "");
        }
        return 0L;
    }

    @Override
    public Boolean update(PrdcRecipeSkuVO vo) {
        PrdcRecipeSku prdcRecipeSku = (PrdcRecipeSku)BeanUtil.buildFrom((Object)vo, PrdcRecipeSku.class);
        if (prdcRecipeSku != null && EmptyUtil.isNotEmpty((Object)vo.getId())) {
            return this.prdcRecipeSkuMapper.updateByPrimaryKeySelective(prdcRecipeSku) > 0;
        }
        return null;
    }

    @Override
    public Boolean deleteRecipeSku(String skuCode, Long recipeId) {
        PrdcRecipeSkuExample example = new PrdcRecipeSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode).andRecipeIdEqualTo(recipeId);
        return this.prdcRecipeSkuMapper.deleteByExample(example) > 0;
    }

    @Override
    public Boolean deleteRecipeSku(Long id) {
        return this.prdcRecipeSkuMapper.deleteByPrimaryKey(id) > 0;
    }
}

