/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.merchandise.enums.PcsSkuSalesPriceChangeStatusEnum;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeMaterialCond;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcRecipeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcRecipeMaterialMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcRecipeSkuMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipe;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeExample;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeMaterial;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeMaterialExample;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeSku;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeSkuExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuAutoApproveRuleService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcRecipeService;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeMaterialSimpleVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeMaterialVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="prdcRecipeService")
public class PrdcRecipeServiceImpl
implements PrdcRecipeService {
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private PrdcRecipeMapper prdcRecipeMapper;
    @Autowired
    private PrdcRecipeMaterialMapper prdcRecipeMaterialMapper;
    @Autowired
    private PrdcRecipeSkuMapper prdcRecipeSkuMapper;
    @Autowired
    private McPcsSkuSalesPriceChangeService mcPcsSkuSalesPriceChangeService;
    @Autowired
    private PcsSkuAutoApproveRuleService pcsSkuAutoApproveRuleService;

    @Override
    public PrdcRecipeVO findRecipeVOById(Long id) {
        PrdcRecipeCond cond = new PrdcRecipeCond();
        cond.setRecipeId(id);
        cond.setCurrpage(1);
        cond.setFetchSkuImg(true);
        List<PrdcRecipeVO> prdcRecipeVOList = this.findRecipeVOByCond(cond, true);
        if (CollectionUtils.isEmpty(prdcRecipeVOList)) {
            return null;
        }
        return prdcRecipeVOList.get(0);
    }

    private List<PrdcRecipeMaterialVO> findRecipeMaterialVOByRecipeIds(List<Long> recipeIds) {
        return this.prdcRecipeMaterialMapper.findRecipeMaterialVOByRecipeIds(recipeIds);
    }

    private List<PrdcRecipeSku> findRecipeSkuByRecipeIds(List<Long> recipeIds) {
        PrdcRecipeSkuExample example = new PrdcRecipeSkuExample();
        example.createCriteria().andRecipeIdIn((List)recipeIds);
        return this.prdcRecipeSkuMapper.selectByExample(example);
    }

    @Override
    public List<PrdcRecipeMaterialVO> findRecipeMaterialVOByRecipeId(Long recipeId) {
        PrdcRecipeMaterialExample example = new PrdcRecipeMaterialExample();
        example.createCriteria().andRecipeIdEqualTo(recipeId);
        List<PrdcRecipeMaterial> prdcRecipeMaterialList = this.prdcRecipeMaterialMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(prdcRecipeMaterialList)) {
            return Collections.emptyList();
        }
        List prdcRecipeMaterialVOList = BeanUtil.buildListFrom(prdcRecipeMaterialList, PrdcRecipeMaterialVO.class);
        for (PrdcRecipeMaterialVO prdcRecipeMaterialVO : prdcRecipeMaterialVOList) {
            PcsSkuVO skuVO = this.mcPcsSkuService.findByCode(prdcRecipeMaterialVO.getSkuCode());
            if (!EmptyUtil.isNotEmpty((Object)skuVO)) continue;
            prdcRecipeMaterialVO.setSkuName(skuVO.getNameCn() == null ? "" : skuVO.getNameCn());
        }
        return prdcRecipeMaterialVOList;
    }

    @Override
    public List<PrdcRecipeVO> findRecipeVOByCond(PrdcRecipeCond cond, Boolean cascade) {
        List<PrdcRecipeMaterialVO> mList;
        List<Object> tmp;
        List<PrdcRecipeVO> prdcRecipeVOList = this.prdcRecipeMapper.findRecipeVOByCond(cond);
        if (CollectionUtils.isEmpty(prdcRecipeVOList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        if (cascade.booleanValue()) {
            for (PrdcRecipeVO recipe : prdcRecipeVOList) {
                ids.add(recipe.getId());
            }
            List<PrdcRecipeMaterialVO> recipeMaterialList = this.findRecipeMaterialVOByRecipeIds(ids);
            HashMap<Long, ArrayList<Object>> recipeMap = new HashMap<Long, ArrayList<Object>>();
            for (PrdcRecipeMaterialVO m : recipeMaterialList) {
                tmp = (List)recipeMap.get(m.getRecipeId());
                if (NullUtil.isNull((Object)tmp)) {
                    tmp = new ArrayList();
                    recipeMap.put(m.getRecipeId(), (ArrayList<Object>)tmp);
                }
                tmp.add(m);
            }
            for (PrdcRecipeVO prdcRecipeVO : prdcRecipeVOList) {
                mList = (List)recipeMap.get(prdcRecipeVO.getId());
                if (NullUtil.isNull((Object)mList)) {
                    mList = new ArrayList();
                }
                prdcRecipeVO.setRecipeMaterialVOList(mList);
            }
        }
        if (cond.isFetchSkuImg()) {
            List<PrdcRecipeSku> prdcRecipeSkus = this.findRecipeSkuByRecipeIds(ids);
            HashMap<Long, ArrayList<Object>> recipeSkuMap = new HashMap<Long, ArrayList<Object>>();
            for (PrdcRecipeSku receipeSku : prdcRecipeSkus) {
                tmp = (ArrayList<Object>)recipeSkuMap.get(receipeSku.getRecipeId());
                if (NullUtil.isNull((Object)tmp)) {
                    tmp = new ArrayList<Object>();
                    recipeSkuMap.put(receipeSku.getRecipeId(), (ArrayList<Object>)tmp);
                }
                tmp.add(receipeSku);
            }
            for (PrdcRecipeVO prdcRecipeVO : prdcRecipeVOList) {
                mList = (ArrayList<PrdcRecipeMaterialVO>)recipeSkuMap.get(prdcRecipeVO.getId());
                if (NullUtil.isNull((Object)mList)) {
                    mList = new ArrayList<PrdcRecipeMaterialVO>();
                }
                prdcRecipeVO.setPrdcRecipeSkus((List<PrdcRecipeSku>)mList);
            }
        }
        return prdcRecipeVOList;
    }

    @Override
    public List<PrdcRecipeMaterialVO> findRecipeMaterialVOByCond(PrdcRecipeMaterialCond cond, Boolean cascade) {
        List<PrdcRecipeMaterial> prdcRecipeMaterialList;
        PrdcRecipeMaterialExample example = new PrdcRecipeMaterialExample();
        PrdcRecipeMaterialExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if (CollectionUtils.isNotEmpty(cond.getSkuCodes())) {
            criteria.andSkuCodeIn((List)cond.getSkuCodes());
        }
        if (CollectionUtils.isEmpty(prdcRecipeMaterialList = this.prdcRecipeMaterialMapper.selectByExample(example))) {
            return Collections.emptyList();
        }
        return BeanUtil.buildListFrom(prdcRecipeMaterialList, PrdcRecipeMaterialVO.class);
    }

    @Override
    public List<PrdcRecipeVO> findRecipeVOBySkuCode(String skuCode, Boolean cascade) {
        PrdcRecipeExample example = new PrdcRecipeExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        List<PrdcRecipe> prdcRecipeList = this.prdcRecipeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(prdcRecipeList)) {
            return Collections.emptyList();
        }
        return BeanUtil.buildListFrom(prdcRecipeList, PrdcRecipeVO.class);
    }

    @Override
    public List<PrdcRecipeVO> findRecipeVOBySkuCode(List<String> skuCodes) {
        PrdcRecipeExample example = new PrdcRecipeExample();
        example.createCriteria().andSkuCodeIn((List)skuCodes);
        List<PrdcRecipe> prdcRecipeList = this.prdcRecipeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(prdcRecipeList)) {
            return Collections.emptyList();
        }
        return BeanUtil.buildListFrom(prdcRecipeList, PrdcRecipeVO.class);
    }

    @Override
    public Map<String, PrdcRecipeVO> mapRecipeVOBySkuCode(List<String> skuCodes) {
        List<PrdcRecipeVO> list = this.findRecipeVOBySkuCode(skuCodes);
        HashMap<String, PrdcRecipeVO> map = new HashMap<String, PrdcRecipeVO>();
        if (CollectionUtils.isEmpty(list)) {
            return map;
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            PrdcRecipeVO recipeVO = list.get(i);
            map.put(recipeVO.getSkuCode(), recipeVO);
        }
        return map;
    }

    @Override
    public List<PrdcRecipeMaterialVO> findRecipeMaterialVOBySkuCode(String skuCode, Boolean cascade) {
        PrdcRecipeMaterialExample example = new PrdcRecipeMaterialExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        List<PrdcRecipeMaterial> prdcRecipeMaterialList = this.prdcRecipeMaterialMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(prdcRecipeMaterialList)) {
            return Collections.emptyList();
        }
        return BeanUtil.buildListFrom(prdcRecipeMaterialList, PrdcRecipeMaterialVO.class);
    }

    @Override
    public List<PrdcRecipeSku> findPrdcRecipeSkuByCond(PrdcRecipeCond cond) {
        PrdcRecipeSkuExample example = new PrdcRecipeSkuExample();
        example.createCriteria().andRecipeIdEqualTo(cond.getRecipeId()).andSkuCodeEqualTo(cond.getRecipeSkuCode());
        List<PrdcRecipeSku> prdcRecipeSkus = this.prdcRecipeSkuMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(prdcRecipeSkus)) {
            return Collections.emptyList();
        }
        return prdcRecipeSkus;
    }

    @Override
    @Transactional
    public Long create(PrdcRecipeVO vo) {
        PrdcRecipe prdcRecipe = (PrdcRecipe)BeanUtil.buildFrom((Object)vo, PrdcRecipe.class);
        List prdcRecipeMaterialList = BeanUtil.buildListFrom(vo.getRecipeMaterialVOList(), PrdcRecipeMaterial.class);
        this.createRecipe(prdcRecipe);
        this.saveRecipeMaterial(prdcRecipe, prdcRecipeMaterialList);
        List<PrdcRecipeSku> prdcRecipeSkus = vo.getPrdcRecipeSkus();
        this.createRecipeSkuImg(prdcRecipe, prdcRecipeSkus);
        return prdcRecipe.getId();
    }

    @Override
    @Transactional
    public Boolean update(PrdcRecipeVO vo) {
        PrdcRecipe prdcRecipe = (PrdcRecipe)BeanUtil.buildFrom((Object)vo, PrdcRecipe.class);
        List prdcRecipeMaterialList = BeanUtil.buildListFrom(vo.getRecipeMaterialVOList(), PrdcRecipeMaterial.class);
        this.updateRecipe(prdcRecipe);
        this.saveRecipeMaterial(prdcRecipe, prdcRecipeMaterialList);
        List<PrdcRecipeSku> prdcRecipeSkus = vo.getPrdcRecipeSkus();
        this.createRecipeSkuImg(prdcRecipe, prdcRecipeSkus);
        return true;
    }

    @Override
    public Boolean updateRecipeHour(PrdcRecipeVO vo) {
        PrdcRecipe prdcRecipe = (PrdcRecipe)BeanUtil.buildFrom((Object)vo, PrdcRecipe.class);
        this.updateRecipe(prdcRecipe);
        return true;
    }

    @Override
    public Boolean deleteRecipeMaterial(Long recipeId, Long recipeMaterialId) {
        if (recipeId == null || recipeMaterialId == null) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PrdcRecipeVO prdcRecipeVO = this.findRecipeVOById(recipeId);
        if (prdcRecipeVO == null) {
            throw new PurchaseException("PC0001", "\u5339\u914d\u4e0d\u5230\u914d\u65b9");
        }
        Boolean found = false;
        for (PrdcRecipeMaterialVO prdcRecipeMaterialVO : prdcRecipeVO.getRecipeMaterialVOList()) {
            if (!prdcRecipeMaterialVO.getId().equals(recipeMaterialId)) continue;
            found = true;
        }
        if (found.booleanValue()) {
            if (this.prdcRecipeMaterialMapper.deleteByPrimaryKey(recipeMaterialId) == 0) {
                throw new PurchaseException("PC0011", "\u5220\u9664\u914d\u65b9\u884c\u5931\u8d25");
            }
        } else {
            throw new PurchaseException("PC0001", "\u914d\u65b9\u4e0d\u5305\u542b\u8be5\u884c\u6570\u636e");
        }
        return true;
    }

    @Override
    public List<PrdcRecipeMaterialSimpleVO> findBottomMaterialByRecipeSkuCodes(List<String> skuCodes) {
        List<PrdcRecipeMaterialSimpleVO> materialSimpleList = this.prdcRecipeMaterialMapper.findMaterialsByRecipeSkus(skuCodes);
        ArrayList<PrdcRecipeMaterialSimpleVO> querySku = new ArrayList<PrdcRecipeMaterialSimpleVO>();
        ArrayList<String> querySkuCodes = new ArrayList<String>();
        ArrayList<PrdcRecipeMaterialSimpleVO> materialSkuList = new ArrayList<PrdcRecipeMaterialSimpleVO>();
        if (EmptyUtil.isNotEmpty(materialSimpleList)) {
            for (PrdcRecipeMaterialSimpleVO simpleVO : materialSimpleList) {
                querySku.add(simpleVO);
                querySkuCodes.add(simpleVO.getMaterialSkuCode());
            }
            while (querySkuCodes.size() > 0) {
                materialSimpleList = this.prdcRecipeMaterialMapper.findMaterialsByRecipeSkus(querySkuCodes);
                ArrayList<String> newQuerySkuCodes = new ArrayList<String>();
                ArrayList<PrdcRecipeMaterialSimpleVO> newQuerySku = new ArrayList<PrdcRecipeMaterialSimpleVO>();
                int querySize = querySkuCodes.size();
                for (int i = 0; i < querySize; ++i) {
                    String skuCode = (String)querySkuCodes.get(i);
                    boolean isBottom = true;
                    for (PrdcRecipeMaterialSimpleVO simple : materialSimpleList) {
                        if (!skuCode.contains(simple.getRecipeSkuCode())) continue;
                        PrdcRecipeMaterialSimpleVO newSimple = new PrdcRecipeMaterialSimpleVO();
                        newSimple.setRecipeSkuCode(((PrdcRecipeMaterialSimpleVO)querySku.get(i)).getRecipeSkuCode());
                        newSimple.setMaterialSkuCode(simple.getMaterialSkuCode());
                        newQuerySku.add(newSimple);
                        newQuerySkuCodes.add(simple.getMaterialSkuCode());
                        isBottom = false;
                    }
                    if (!isBottom) continue;
                    materialSkuList.add((PrdcRecipeMaterialSimpleVO)querySku.get(i));
                }
                querySkuCodes = newQuerySkuCodes;
                querySku = newQuerySku;
            }
        }
        return materialSkuList;
    }

    private void validateRecipe(Boolean isCreat, PrdcRecipe rcd) {
        PcsSkuVO skuVO;
        PrdcRecipeCond con = new PrdcRecipeCond();
        con.setRecipeSkuCode(rcd.getSkuCode());
        List<PrdcRecipeVO> list = this.prdcRecipeMapper.findRecipeVOByCond(con);
        if (isCreat.booleanValue()) {
            if (rcd.getId() != null) {
                throw new PurchaseException("PC0001", "\u914d\u65b9\u5df2\u5b58\u5728ID[" + rcd.getId() + "]\uff0c\u65e0\u9700\u65b0\u589e!");
            }
            if (list != null && list.size() > 0) {
                throw new PurchaseException("PC0001", "\u6210\u54c1sku[" + rcd.getSkuCode() + "]\u5df2\u6709\u914d\u65b9!");
            }
        } else {
            PrdcRecipeVO prdcRecipe;
            if (rcd.getId() == null) {
                throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
            }
            if (list.size() > 1) {
                throw new PurchaseException("PC0001", "\u6210\u54c1sku[" + rcd.getSkuCode() + "]\u4e0d\u80fd\u91cd\u590d");
            }
            if (list.size() == 1 && !(prdcRecipe = list.get(0)).getId().equals(rcd.getId())) {
                throw new PurchaseException("PC0001", "\u914d\u65b9ID\u4e0d\u5339\u914d[" + prdcRecipe.getId() + "<>" + rcd.getId() + "],\u4e0d\u80fd\u66f4\u65b0!");
            }
        }
        if ((skuVO = this.mcPcsSkuService.findByCode(rcd.getSkuCode())) == null) {
            throw new PurchaseException("PC0001", "skuCode\u5339\u914d\u4e0d\u5230sku");
        }
    }

    @Transactional
    private void createRecipe(PrdcRecipe rcd) {
        this.validateRecipe(true, rcd);
        rcd.setCreateTime(DateUtil.getNow());
        if (this.prdcRecipeMapper.insert(rcd) == 0) {
            throw new PurchaseException("PC0009", "\u6570\u636e\u5e93\u63d2\u5165\u5931\u8d25");
        }
    }

    @Transactional
    private void updateRecipe(PrdcRecipe rcd) {
        this.validateRecipe(false, rcd);
        if (this.prdcRecipeMapper.updateByPrimaryKeySelective(rcd) == 0) {
            throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void saveRecipeMaterial(PrdcRecipe prdcRecipe, List<PrdcRecipeMaterial> rcdList) {
        Boolean flag = false;
        for (PrdcRecipeMaterial rcd : rcdList) {
            if (!rcd.getMaterialType().equals(1)) continue;
            flag = true;
        }
        if (!flag.booleanValue()) {
            throw new PurchaseException("PC0001", "\u914d\u65b9\u81f3\u5c11\u9700\u89811\u4e2a\u4e3b\u8017\u6750");
        }
        for (PrdcRecipeMaterial rcd : rcdList) {
            if (rcd.getId() == null) {
                this.createRecipeMaterial(prdcRecipe, rcd);
                continue;
            }
            this.updateRecipeMaterial(prdcRecipe, rcd);
        }
    }

    private void validateRecipeMaterial(PrdcRecipe prdcRecipe, PrdcRecipeMaterial rcd) {
        PcsSkuVO skuVO = this.mcPcsSkuService.findByCode(rcd.getSkuCode());
        if (skuVO == null) {
            throw new PurchaseException("PC0001", "\u8017\u6750skuCode\u5339\u914d\u4e0d\u5230sku");
        }
        if (EmptyUtil.isEmpty((Object)rcd.getQuantity())) {
            throw new PurchaseException("PC0001", "\u8017\u6750sku\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rcd.getQuantity().compareTo(new Float(0.0f)) <= 0) {
            throw new PurchaseException("PC0001", "\u8017\u6750sku\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (rcd.getSkuCode().equals(prdcRecipe.getSkuCode())) {
            throw new PurchaseException("PC0001", "\u8017\u6750SKU\u5305\u542b\u6210\u54c1SKU");
        }
        if (EmptyUtil.isEmpty((List)this.mcPcsSkuService.findAuditRecordsByCodeAndStatus(rcd.getSkuCode(), PcsSkuSalesPriceChangeStatusEnum.COMPLETED_REVIEW.getStatus()))) {
            throw new PurchaseException("PC0001", "[" + skuVO.getCode() + "]" + skuVO.getNameCn() + "\u672a\u901a\u8fc7\u5ba1\u6279");
        }
    }

    @Transactional
    private void createRecipeMaterial(PrdcRecipe prdcRecipe, PrdcRecipeMaterial rcd) {
        this.validateRecipeMaterial(prdcRecipe, rcd);
        rcd.setRecipeId(prdcRecipe.getId());
        if (this.prdcRecipeMaterialMapper.insert(rcd) == 0) {
            throw new PurchaseException("PC0009", "\u6570\u636e\u5e93\u63d2\u5165\u5931\u8d25");
        }
    }

    @Transactional
    private void createOrUpdateRecipeSku(PrdcRecipeSku prdcRecipeSku) {
        int result = 0;
        if (EmptyUtil.isNotEmpty((Object)prdcRecipeSku.getId())) {
            prdcRecipeSku.setUpdateTime(DateUtil.getNow());
            result = this.prdcRecipeSkuMapper.updateByPrimaryKeySelective(prdcRecipeSku);
        } else {
            prdcRecipeSku.setCreateTime(DateUtil.getNow());
            result = this.prdcRecipeSkuMapper.insert(prdcRecipeSku);
        }
        if (result == 0) {
            throw new PurchaseException("PC0009", "\u6570\u636e\u5e93\u63d2\u5165\u5931\u8d25");
        }
    }

    @Transactional
    private void createRecipeSkuImg(PrdcRecipe prdcRecipe, List<PrdcRecipeSku> prdcRecipeSkus) {
        this.deleteRecipeSkuImg(prdcRecipe);
        if (EmptyUtil.isNotEmpty((Object)prdcRecipe.getId()) && CollectionUtils.isNotEmpty(prdcRecipeSkus)) {
            for (PrdcRecipeSku prdcRecipeSku : prdcRecipeSkus) {
                prdcRecipeSku.setCreateTime(DateUtil.getNow());
                prdcRecipeSku.setRecipeId(prdcRecipe.getId());
                prdcRecipeSku.setSkuCode(prdcRecipe.getSkuCode());
                if (this.prdcRecipeSkuMapper.insert(prdcRecipeSku) != 0) continue;
                throw new PurchaseException("PC0009", "\u914d\u65b9SKU\u56fe\u7247\u63d2\u5165\u5931\u8d25");
            }
        }
    }

    @Transactional
    private void deleteRecipeSkuImg(PrdcRecipe prdcRecipe) {
        if (EmptyUtil.isNotEmpty((Object)prdcRecipe.getId())) {
            PrdcRecipeSkuExample example = new PrdcRecipeSkuExample();
            PrdcRecipeSkuExample.Criteria criteria = example.createCriteria();
            criteria.andRecipeIdEqualTo(prdcRecipe.getId());
            if (EmptyUtil.isNotEmpty((String)prdcRecipe.getSkuCode())) {
                criteria.andSkuCodeEqualTo(prdcRecipe.getSkuCode());
            }
            this.prdcRecipeSkuMapper.deleteByExample(example);
        }
    }

    @Transactional
    private void updateRecipeMaterial(PrdcRecipe prdcRecipe, PrdcRecipeMaterial rcd) {
        this.validateRecipeMaterial(prdcRecipe, rcd);
        if (this.prdcRecipeMaterialMapper.updateByPrimaryKeySelective(rcd) == 0) {
            throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
    }
}

