/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.common.Pagination;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.message.service.EmailSendService;
import com.thebeastshop.message.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcJobCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerDeliveryRecipeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerRecipeSkuMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcJobLineMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcJobMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcPreJobLineMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcPreJobMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcRecipeMaterialMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDeliveryRecipe;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerRecipeSku;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerRecipeSkuExample;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJob;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobExample;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLine;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLineExample;
import com.thebeastshop.pegasus.service.purchase.model.PrdcPreJob;
import com.thebeastshop.pegasus.service.purchase.model.PrdcPreJobLine;
import com.thebeastshop.pegasus.service.purchase.model.PrdcPreJobLineExample;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeMaterial;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeMaterialExample;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcRecipeService;
import com.thebeastshop.pegasus.service.purchase.util.PrdcJobLineUtil;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPreAllotVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobCountInfo;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcPreJobDownloadVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcPreJobLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcPreJobVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeMaterialVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.wms.cond.PhyWhStockCond;
import com.thebeastshop.wms.sservice.SWhAllotService;
import com.thebeastshop.wms.sservice.SWhInfoService;
import com.thebeastshop.wms.sservice.SWhInvService;
import com.thebeastshop.wms.sservice.SWhJitPackageSkuReferenceService;
import com.thebeastshop.wms.sservice.SWhWarehouseGroupService;
import com.thebeastshop.wms.sservice.SWhWmsPrdcJobTaskService;
import com.thebeastshop.wms.sservice.SWhWmsSkuStockService;
import com.thebeastshop.wms.sservice.WWhCommandService;
import com.thebeastshop.wms.vo.PhyWhStockVO;
import com.thebeastshop.wms.vo.WhAllotRcdSkuVO;
import com.thebeastshop.wms.vo.WhAllotRcdVO;
import com.thebeastshop.wms.vo.WhCommandSkuVO;
import com.thebeastshop.wms.vo.WhCommandVO;
import com.thebeastshop.wms.vo.WhInvOccupyVO;
import com.thebeastshop.wms.vo.WhInvVO;
import com.thebeastshop.wms.vo.WhJitPackageSkuReferenceVO;
import com.thebeastshop.wms.vo.WhPackageInvVO;
import com.thebeastshop.wms.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.wms.vo.WhRecipeInvVO;
import com.thebeastshop.wms.vo.WhReleaseOccupationVO;
import com.thebeastshop.wms.vo.WhWarehouseGroupVO;
import com.thebeastshop.wms.vo.WhWarehouseVO;
import com.thebeastshop.wms.vo.WhWmsPrdcJobTaskVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="prdcJobService")
public class PrdcJobServiceImpl
implements PrdcJobService {
    private static Logger log = LoggerFactory.getLogger(PrdcJobServiceImpl.class);
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private PrdcRecipeService prdcRecipeService;
    @Autowired
    private PrdcJobMapper prdcJobMapper;
    @Autowired
    private PrdcJobLineMapper prdcJobLineMapper;
    @Autowired
    private PrdcPreJobMapper prdcPreJobMapper;
    @Autowired
    private PrdcPreJobLineMapper prdcPreJobLineMapper;
    @Autowired
    private PrdcRecipeMaterialMapper prdcRecipeMaterialMapper;
    @Autowired
    private PcsFlowerRecipeSkuMapper pcsFlowerRecipeSkuMapper;
    @Autowired
    private PcsFlowerDeliveryRecipeMapper pcsFlowerDeliveryRecipeMapper;
    private PegasusUtilFacade utilFacade = PegasusUtilFacade.getInstance();
    public static Map<String, WhWarehouseVO> warehouseMap = new HashMap<String, WhWarehouseVO>();
    public static Map<String, WhPhysicalWarehouseVO> whPhysicalWarehouseMap = new HashMap<String, WhPhysicalWarehouseVO>();
    public static Map<String, WhWarehouseGroupVO> whGroupMap = new HashMap<String, WhWarehouseGroupVO>();
    @Autowired
    private SStockService sStockService;
    @Autowired
    private SWhInfoService sWhInfoService;
    @Autowired
    private SWhInvService sWhInvService;
    @Autowired
    private SWhAllotService sWhAllotService;
    @Autowired
    private SWhWmsSkuStockService sWhWmsSkuStockService;
    @Autowired
    private SWhWmsPrdcJobTaskService sWhWmsPrdcJobTaskService;
    @Autowired
    private SWhJitPackageSkuReferenceService sWhJitPackageSkuReferenceService;
    @Autowired
    private WWhCommandService wWhCommandService;
    @Autowired
    private SWhWarehouseGroupService sWhWarehouseGroupService;
    @Autowired
    private EmailSendService emailSendService;

    @Override
    public PrdcJobVO findJobVOById(Long id) {
        PrdcJobCond cond = new PrdcJobCond();
        cond.setJobId(id);
        cond.setCurrpage(1);
        List<PrdcJobVO> prdcJobVOList = this.findJobVOByCond(cond, true);
        PrdcJobVO prdcJobVO = null;
        if (CollectionUtils.isNotEmpty(prdcJobVOList)) {
            WhWarehouseVO whWarehouseVO;
            prdcJobVO = prdcJobVOList.get(0);
            WhPhysicalWarehouseVO whPhysicalWarehouseVO = this.sWhInfoService.findPhysicalWarehouseByCode(prdcJobVO.getPhysicalWarehouseCode());
            if (whPhysicalWarehouseVO != null) {
                prdcJobVO.setPhysicalWarehouseName(whPhysicalWarehouseVO.getName());
                prdcJobVO.setWhPhysicalWarehouse(whPhysicalWarehouseVO);
            }
            if ((whWarehouseVO = this.sWhInfoService.findWarehouseByCode(prdcJobVO.getWarehouseCode())) != null) {
                prdcJobVO.setWarehouseName(whWarehouseVO.getName());
            }
        }
        return prdcJobVO;
    }

    @Override
    public PrdcJobVO findJobVOByCode(String code) {
        PrdcJobExample example = new PrdcJobExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PrdcJob> jobs = this.prdcJobMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(jobs)) {
            return null;
        }
        List jobVOs = BeanUtil.buildListFrom(jobs, PrdcJobVO.class);
        PrdcJobVO jobVO = (PrdcJobVO)jobVOs.get(0);
        jobVO.setPrdcJobLineVOList(this.findJobLineVOByJobId(jobVO.getId()));
        return jobVO;
    }

    @Override
    public List<PrdcJobVO> findPrdcJobVO(boolean cascade) {
        List<PrdcJobVO> list = this.prdcJobMapper.findPrdcJobVO();
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public List<PrdcJobVO> findJobVOByRecipeId(Long recipeId, Boolean cascade) {
        PrdcJobCond cond = new PrdcJobCond();
        cond.setRecipeId(recipeId);
        cond.setCurrpage(null);
        List<PrdcJobVO> prdcJobVOList = this.findJobVOByCond(cond, cascade);
        if (CollectionUtils.isEmpty(prdcJobVOList)) {
            return Collections.emptyList();
        }
        return prdcJobVOList;
    }

    @Override
    public Map<String, WhRecipeInvVO> caculateRecipeAmountForAssemble(List<String> skuCodes, String warehouseCode) {
        HashMap<String, WhRecipeInvVO> map = new HashMap<String, WhRecipeInvVO>();
        PrdcRecipeCond cond = new PrdcRecipeCond();
        cond.setSkuCodes(skuCodes);
        List<PrdcRecipeVO> recipeList = this.prdcRecipeService.findRecipeVOByCond(cond, true);
        if (EmptyUtil.isNotEmpty(recipeList)) {
            ArrayList<String> materialSkuCodes = new ArrayList<String>();
            for (PrdcRecipeVO prdcRecipeVO : recipeList) {
                for (PrdcRecipeMaterialVO materialVO : prdcRecipeVO.getRecipeMaterialVOList()) {
                    materialSkuCodes.add(materialVO.getSkuCode());
                }
            }
            Map skuInvMap = this.sWhInvService.findCanUseQttBySkuCodesAndWarehouseCode(materialSkuCodes, warehouseCode);
            for (PrdcRecipeVO recipeVO : recipeList) {
                WhRecipeInvVO recipeInvVO = this.buildZeroReceipeInvVO(recipeVO.getSkuCode(), warehouseCode);
                recipeInvVO.setRecipeExist(true);
                recipeInvVO.setCustomization(PrdcRecipeVO.isCustomization(recipeVO.getCustomization()));
                ArrayList<WhRecipeInvVO.WhMaterialRecipeInvVO> materialSkuInvList = new ArrayList<WhRecipeInvVO.WhMaterialRecipeInvVO>();
                for (PrdcRecipeMaterialVO materialVO : recipeVO.getRecipeMaterialVOList()) {
                    WhRecipeInvVO.WhMaterialRecipeInvVO materialRecipeInvVO = new WhRecipeInvVO.WhMaterialRecipeInvVO();
                    materialRecipeInvVO.setSkuCode(materialVO.getSkuCode());
                    materialRecipeInvVO.setRecipeAmount(materialVO.getQuantity());
                    materialRecipeInvVO.setWarehouseCode(warehouseCode);
                    WhInvVO invVO = (WhInvVO)skuInvMap.get(materialVO.getSkuCode());
                    if (NullUtil.isNull((Object)invVO)) {
                        invVO = this.buildZeroInvVO(materialVO.getSkuCode(), warehouseCode);
                    }
                    materialRecipeInvVO.setSkuInvVO(invVO);
                    materialSkuInvList.add(materialRecipeInvVO);
                }
                recipeInvVO.setMaterialSkuInvList(materialSkuInvList);
                map.put(recipeVO.getSkuCode(), recipeInvVO);
            }
        }
        for (String skuCode : skuCodes) {
            WhRecipeInvVO whRecipeInvVO = (WhRecipeInvVO)map.get(skuCode);
            if (!NullUtil.isNull((Object)whRecipeInvVO)) continue;
            map.put(skuCode, this.buildZeroReceipeInvVO(skuCode, warehouseCode));
        }
        return map;
    }

    @Override
    @Transactional
    public boolean batchCreatePrdcJobOrAllot(List<PrdcJobVO> jobList, List<WhAllotRcdVO> allotList) throws Exception {
        ArrayList<WhInvOccupyVO> whJobOccupyList = new ArrayList<WhInvOccupyVO>();
        ArrayList<WhJitPackageSkuReferenceVO> jobreferenceVOList = new ArrayList<WhJitPackageSkuReferenceVO>();
        if (EmptyUtil.isNotEmpty(jobList)) {
            for (PrdcJobVO vo : jobList) {
                this.savePrdcJobAndGetOccupyList(vo, whJobOccupyList);
                this.buildWhJitPackageSkuReference(vo);
                if (!EmptyUtil.isNotEmpty(vo.getJitPackageSkuReferenceList())) continue;
                jobreferenceVOList.addAll(vo.getJitPackageSkuReferenceList());
            }
        }
        return this.sWhAllotService.createAllotRcdAndPrdcJobOccupy(allotList, whJobOccupyList, jobreferenceVOList);
    }

    @Override
    public void sendCusShortMailEmail(List<WhPackageInvVO> packageInvList, String moreInfo) {
        if (EmptyUtil.isEmpty(packageInvList)) {
            return;
        }
        CommGlobalConfig config = this.utilFacade.findConfigByKey("orderNotice.cusShortMail");
        if (NullUtil.isNull((Object)config) || EmptyUtil.isEmpty((String)config.getConfigValue())) {
            return;
        }
        List<String> toAddressList = Arrays.asList(config.getConfigValue().split(","));
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(toAddressList);
        emailVO.setSubject("\u5b9a\u5236\u5546\u54c1\u52a0\u5de5\u8017\u6750\u4e0d\u8db3");
        emailVO.setContent(this.buildCusShortMailContent(packageInvList, moreInfo));
        this.emailSendService.send(emailVO);
    }

    private String buildCusShortMailContent(List<WhPackageInvVO> packageInvList, String moreInfo) {
        ArrayList<String> skuCodes = new ArrayList<String>();
        for (WhPackageInvVO whPackageInvVO : packageInvList) {
            skuCodes.add(whPackageInvVO.getSkuCode());
        }
        Map<String, PrdcRecipeVO> recipeVOMap = this.getRecipeVOMap(skuCodes, true);
        for (PrdcRecipeVO recipeVO : recipeVOMap.values()) {
            for (PrdcRecipeMaterialVO materialVO : recipeVO.getRecipeMaterialVOList()) {
                skuCodes.add(materialVO.getSkuCode());
            }
        }
        Map<String, PcsSkuVO> map = this.getSkuMap(skuCodes, false);
        StringBuilder buffer = new StringBuilder();
        if (EmptyUtil.isNotEmpty((String)moreInfo)) {
            buffer.append(moreInfo).append("<br/>");
        }
        PcsSkuVO skuVO = null;
        for (WhPackageInvVO packageInvVO : packageInvList) {
            skuVO = map.get(packageInvVO.getSkuCode());
            buffer.append("\u5305\u88f9\u53f7:").append(packageInvVO.getPackageCode()).append("<br/>").append("\u5b9a\u5236SKU:").append("[").append(packageInvVO.getSkuCode()).append("]").append(NullUtil.isNull((Object)skuVO) ? "" : skuVO.getNameCn()).append("<br/>");
            PrdcRecipeVO recipeVO = recipeVOMap.get(packageInvVO.getSkuCode());
            if (NullUtil.isNotNull((Object)recipeVO)) {
                for (PrdcRecipeMaterialVO materialVO : recipeVO.getRecipeMaterialVOList()) {
                    skuVO = map.get(materialVO.getSkuCode());
                    buffer.append(String.format("\u8017\u6750SKU:[%s]%s", materialVO.getSkuCode(), NullUtil.isNull((Object)skuVO) ? "" : skuVO.getNameCn())).append("<br/>");
                }
            }
            buffer.append("<br/>");
        }
        return buffer.toString();
    }

    private Map<String, PcsSkuVO> getSkuMap(List<String> skuCodes, boolean cascade) {
        List skuList = this.mcPcsSkuService.findSkuByCodes(skuCodes, cascade);
        HashMap<String, PcsSkuVO> skuMap = new HashMap<String, PcsSkuVO>();
        if (EmptyUtil.isNotEmpty((List)skuList)) {
            for (PcsSkuVO sku : skuList) {
                skuMap.put(sku.getCode(), sku);
            }
        }
        return skuMap;
    }

    @Override
    public boolean buildAllotOrPrdcJob(List<WhPackageInvVO> packageInvList, List<PrdcJobVO> jobList, List<WhAllotRcdVO> allotList) {
        if (EmptyUtil.isEmpty(packageInvList)) {
            return false;
        }
        ArrayList<String> skuCodes = new ArrayList<String>();
        for (WhPackageInvVO packageInvVO : packageInvList) {
            skuCodes.add(packageInvVO.getSkuCode());
        }
        Map<String, PrdcRecipeVO> recipeVOMap = this.getRecipeVOMap(skuCodes, true);
        for (WhPackageInvVO packageInvVO : packageInvList) {
            PrdcRecipeVO recipeVO = recipeVOMap.get(packageInvVO.getSkuCode());
            if (NullUtil.isNull((Object)recipeVO)) {
                throw new PurchaseException("PC0002", String.format("[%s]\u914d\u65b9\u4e0d\u5b58\u5728", packageInvVO.getSkuCode()));
            }
            if (!this.isCustomizatonRecipe(recipeVO)) {
                throw new PurchaseException("PC0002", String.format("[%s]\u914d\u65b9\u4e0d\u662f\u5b9a\u5236\u914d\u65b9", packageInvVO.getSkuCode()));
            }
            WhPhysicalWarehouseVO processingPhyWh = this.sWhInfoService.findPhysicalWarehouseByCode(recipeVO.getProcessingWarehouse());
            if (NullUtil.isNull((Object)processingPhyWh)) {
                throw new PurchaseException("PC0002", String.format("[%s]\u7269\u7406\u4ed3\u4e0d\u5b58\u5728", recipeVO.getProcessingWarehouse()));
            }
            WhWarehouseVO dispatchWarehouse = this.sWhInfoService.findWarehouseByCode(packageInvVO.getDispatchWarehouseCode());
            if (NullUtil.isNull((Object)dispatchWarehouse)) {
                throw new PurchaseException("PC0002", String.format("[%s]\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", packageInvVO.getDispatchWarehouseCode()));
            }
            if (NullUtil.isNotNull((Object)processingPhyWh.getWarehouseGroupId()) && processingPhyWh.getWarehouseGroupId().equals(dispatchWarehouse.getWarehouseGroupId())) {
                jobList.add(this.buildPrdcJob(packageInvVO, recipeVO));
                continue;
            }
            allotList.add(this.buildWhAllot(packageInvVO, recipeVO));
        }
        return true;
    }

    private WhAllotRcdVO buildWhAllot(WhPackageInvVO packageInvVO, PrdcRecipeVO recipeVO) {
        WhPhysicalWarehouseVO processingPhyWh = this.sWhInfoService.findPhysicalWarehouseByCode(recipeVO.getProcessingWarehouse());
        if (NullUtil.isNull((Object)processingPhyWh)) {
            throw new PurchaseException("PC0002", String.format("[%s]\u52a0\u5de5\u4ed3\u4e0d\u5b58\u5728", recipeVO.getProcessingWarehouse()));
        }
        if (NullUtil.isNull((Object)processingPhyWh.getCityId())) {
            throw new PurchaseException("PC0002", String.format("[%s]\u52a0\u5de5\u4ed3\u6240\u5c5e\u5730\u533a\u672a\u8bbe\u7f6e", recipeVO.getProcessingWarehouse()));
        }
        Date now = DateUtil.getNow();
        WhAllotRcdVO allotRcd = new WhAllotRcdVO();
        WhWarehouseVO targetWarehouse = this.sWhInfoService.findDefaultOutNondefectiveWarehouseByPhyWhCode(recipeVO.getProcessingWarehouse());
        allotRcd.setTargetWarehouseCode(targetWarehouse.getCode());
        allotRcd.setTargetPhysicalWarehouseCode(recipeVO.getProcessingWarehouse());
        allotRcd.setSourceWarehouseCode(packageInvVO.getDispatchWarehouseCode());
        if (NullUtil.isNull((Object)packageInvVO.getPlanedDeliveryDate())) {
            allotRcd.setEstimatedAllocationDate(DateUtil.addDay((Date)now, (int)1));
        } else {
            allotRcd.setEstimatedAllocationDate(DateUtil.addDay((Date)packageInvVO.getPlanedDeliveryDate(), (int)1));
        }
        allotRcd.setAllotType(WhAllotRcdVO.TYPE_CUSTOMIZE_OUT);
        allotRcd.setAllotStatus(WhAllotRcdVO.STATUS_WAIT_FOR_CONFIRMATION);
        allotRcd.setCreateTime(now);
        allotRcd.setRemark("\u5b9a\u5236\u52a0\u5de5\u5546\u54c1\u4ed3\u5e93\u5916\u52a0\u5de5");
        allotRcd.setNeedConfirm(true);
        if (NullUtil.isNull((Object)packageInvVO.getQuantity())) {
            throw new PurchaseException("PC0002", String.format("[%s]\u6210\u54c1\u6570\u91cf\u4e0d\u53ef\u4e3a\u7a7a", packageInvVO.getSkuCode()));
        }
        HashMap<String, Integer> skuQuantityMap = new HashMap<String, Integer>();
        ArrayList<WhAllotRcdSkuVO> whAllotRcdSkuList = new ArrayList<WhAllotRcdSkuVO>();
        for (PrdcRecipeMaterialVO recipeMaterialVO : recipeVO.getRecipeMaterialVOList()) {
            Integer quantity = (int)this.computeJobLineQuantity(packageInvVO.getQuantity(), recipeMaterialVO.getQuantity());
            WhAllotRcdSkuVO rcdSku = new WhAllotRcdSkuVO();
            rcdSku.setSkuCode(recipeMaterialVO.getSkuCode());
            rcdSku.setQuantity(quantity);
            whAllotRcdSkuList.add(rcdSku);
            skuQuantityMap.put(recipeMaterialVO.getSkuCode(), quantity);
        }
        allotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
        ArrayList<WhJitPackageSkuReferenceVO> refList = new ArrayList<WhJitPackageSkuReferenceVO>();
        WhJitPackageSkuReferenceVO referenceVO = new WhJitPackageSkuReferenceVO();
        referenceVO.setPackageCode(packageInvVO.getPackageCode());
        referenceVO.setSkuCode(packageInvVO.getSkuCode());
        referenceVO.setPackageSkuId(packageInvVO.getPakcageSkuId());
        referenceVO.setType(WhJitPackageSkuReferenceVO.TYPE_WH_ALLOT);
        referenceVO.setStatus(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        referenceVO.setCustomizationContent(packageInvVO.getCustomizationContent());
        referenceVO.setCreateUserId(Long.valueOf(1L));
        referenceVO.setCreateTime(now);
        refList.add(referenceVO);
        allotRcd.setJitPackageSkuReferenceVOs(refList);
        WhPhysicalWarehouseVO sourcePhyWh = this.sWhWmsSkuStockService.computeDispatchPhysicalWarehouse(packageInvVO.getDispatchWarehouseCode(), skuQuantityMap, processingPhyWh.getCityId());
        if (NullUtil.isNull((Object)sourcePhyWh)) {
            throw new PurchaseException("PC0002", String.format("[%s][%s]\u7269\u7406\u4ed3\u5e93\u5b58\u4e0d\u8db3", packageInvVO.getDispatchWarehouseCode(), packageInvVO.getSkuCode()));
        }
        allotRcd.setSourcePhysicalWarehouseCode(sourcePhyWh.getCode());
        return allotRcd;
    }

    private PrdcJobVO buildPrdcJob(WhPackageInvVO packageInvVO, PrdcRecipeVO recipeVO) {
        Date now = DateUtil.getNow();
        PrdcJobVO jobVO = new PrdcJobVO();
        jobVO.setWarehouseCode(packageInvVO.getDispatchWarehouseCode());
        jobVO.setPhysicalWarehouseCode(recipeVO.getProcessingWarehouse());
        jobVO.setJobType(PrdcJobVO.JOB_TYPE_ASSEMBLE);
        jobVO.setSkuCode(packageInvVO.getSkuCode());
        jobVO.setRecipeId(recipeVO.getId());
        jobVO.setEstQuantity(packageInvVO.getQuantity());
        jobVO.setPlanStatus(PrdcJobVO.PLAN_STATUS_CONFIRM);
        jobVO.setEstDoneDate(DateUtil.addDay((Date)now, (int)1));
        jobVO.setRemark("\u5b9a\u5236\u5546\u54c1\u52a0\u5de5");
        jobVO.setCreateOperatorId(1L);
        jobVO.setCreateOperatorName("\u7cfb\u7edf");
        jobVO.setCreateTime(now);
        ArrayList<WhJitPackageSkuReferenceVO> refList = new ArrayList<WhJitPackageSkuReferenceVO>();
        WhJitPackageSkuReferenceVO referenceVO = new WhJitPackageSkuReferenceVO();
        referenceVO.setPackageCode(packageInvVO.getPackageCode());
        referenceVO.setSkuCode(packageInvVO.getSkuCode());
        referenceVO.setPackageSkuId(packageInvVO.getPakcageSkuId());
        referenceVO.setType(WhJitPackageSkuReferenceVO.TYPE_PRDC_JOB);
        referenceVO.setStatus(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        referenceVO.setCustomizationContent(packageInvVO.getCustomizationContent());
        referenceVO.setCreateUserId(Long.valueOf(1L));
        referenceVO.setCreateTime(now);
        refList.add(referenceVO);
        jobVO.setJitPackageSkuReferenceList(refList);
        this.bulidJobLine(jobVO, recipeVO);
        return jobVO;
    }

    @Override
    public void bulidJobLine(PrdcJobVO jobVO, PrdcRecipeVO recipeVO) {
        if (NullUtil.isNull((Object)jobVO) || NullUtil.isNull((Object)jobVO.getEstQuantity())) {
            throw new PurchaseException("PC0002", String.format("[%s]\u52a0\u5de5\u6570\u91cf\u4e0d\u53ef\u4e3a\u7a7a", jobVO.getSkuCode()));
        }
        ArrayList<PrdcJobLineVO> prdcJobLineVOList = new ArrayList<PrdcJobLineVO>();
        for (PrdcRecipeMaterialVO recipeMaterialVO : recipeVO.getRecipeMaterialVOList()) {
            PrdcJobLineVO lineVO = new PrdcJobLineVO();
            lineVO.setSkuCode(recipeMaterialVO.getSkuCode());
            lineVO.setMaterialType(recipeMaterialVO.getMaterialType());
            lineVO.setRecipeAmount(recipeMaterialVO.getQuantity());
            lineVO.setQuantity(Float.valueOf(this.computeJobLineQuantity(jobVO.getEstQuantity(), recipeMaterialVO.getQuantity())));
            prdcJobLineVOList.add(lineVO);
        }
        jobVO.setPrdcJobLineVOList(prdcJobLineVOList);
    }

    private float computeJobLineQuantity(Integer needQuantity, Float recipeQuantity) {
        return (float)Math.ceil(recipeQuantity.floatValue() * (float)needQuantity.intValue());
    }

    private boolean isCustomizatonRecipe(PrdcRecipeVO recipeVO) {
        return NullUtil.isNotNull((Object)recipeVO.getCustomization()) && recipeVO.getCustomization() == 1;
    }

    private Map<String, PrdcRecipeVO> getRecipeVOMap(List<String> skuCodes, boolean cascade) {
        PrdcRecipeCond cond = new PrdcRecipeCond();
        cond.setSkuCodes(skuCodes);
        HashMap<String, PrdcRecipeVO> recipeVOMap = new HashMap<String, PrdcRecipeVO>();
        List<PrdcRecipeVO> recipeList = this.prdcRecipeService.findRecipeVOByCond(cond, cascade);
        if (EmptyUtil.isNotEmpty(recipeList)) {
            for (PrdcRecipeVO recipeVO : recipeList) {
                recipeVOMap.put(recipeVO.getSkuCode(), recipeVO);
            }
        }
        return recipeVOMap;
    }

    private WhRecipeInvVO buildZeroReceipeInvVO(String skuCode, String warehouseCode) {
        WhRecipeInvVO recipeInvVO = new WhRecipeInvVO();
        recipeInvVO.setSkuCode(skuCode);
        recipeInvVO.setWarehouseCode(warehouseCode);
        return recipeInvVO;
    }

    private WhInvVO buildZeroInvVO(String skuCode, String warehouseCode) {
        WhInvVO invVO = new WhInvVO();
        invVO.setSkuCode(skuCode);
        invVO.setWarehouseCode(warehouseCode);
        invVO.setQuantityInOccupy(0);
        invVO.setQuantityInRcd(0);
        return invVO;
    }

    @Override
    public List<PrdcJobLineVO> findJobLineVOByJobId(Long jobId) {
        PrdcJobLineExample example = new PrdcJobLineExample();
        example.createCriteria().andJobIdEqualTo(jobId);
        List<PrdcJobLine> prdcJobLineList = this.prdcJobLineMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(prdcJobLineList)) {
            return Collections.emptyList();
        }
        List prdcJobLineVOList = BeanUtil.buildListFrom(prdcJobLineList, PrdcJobLineVO.class);
        for (PrdcJobLineVO prdcJobLineVO : prdcJobLineVOList) {
            PcsSkuVO skuVO = this.mcPcsSkuService.findByCode(prdcJobLineVO.getSkuCode());
            if (skuVO == null) {
                log.error("SKU {} is NULL!", (Object)prdcJobLineVO.getSkuCode());
                continue;
            }
            prdcJobLineVO.setSkuName(skuVO.getNameCn());
        }
        return prdcJobLineVOList;
    }

    public Map<Long, List<PrdcJobLineVO>> findJobLineVOByJobIds(List<Long> jobIds) {
        HashMap<Long, List<PrdcJobLineVO>> jobMap = new HashMap<Long, List<PrdcJobLineVO>>();
        if (EmptyUtil.isEmpty(jobIds)) {
            return jobMap;
        }
        PrdcJobLineExample example = new PrdcJobLineExample();
        example.createCriteria().andJobIdIn((List)jobIds);
        List<PrdcJobLine> prdcJobLineList = this.prdcJobLineMapper.selectByExample(example);
        if (EmptyUtil.isNotEmpty(prdcJobLineList)) {
            List prdcJobLineVOList = BeanUtil.buildListFrom(prdcJobLineList, PrdcJobLineVO.class);
            ArrayList<String> skuCodes = new ArrayList<String>();
            for (PrdcJobLineVO line : prdcJobLineVOList) {
                skuCodes.add(line.getSkuCode());
            }
            List skuList = this.mcPcsSkuService.findSkuByCodes(skuCodes, false);
            HashMap<String, PcsSkuVO> skuMap = new HashMap<String, PcsSkuVO>();
            if (EmptyUtil.isNotEmpty((List)skuList)) {
                for (PcsSkuVO sku : skuList) {
                    skuMap.put(sku.getCode(), sku);
                }
            }
            for (PrdcJobLineVO prdcJobLineVO : prdcJobLineVOList) {
                PcsSkuVO sku;
                ArrayList<PrdcJobLineVO> tmpList = (ArrayList<PrdcJobLineVO>)jobMap.get(prdcJobLineVO.getJobId());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<PrdcJobLineVO>();
                    jobMap.put(prdcJobLineVO.getJobId(), tmpList);
                }
                if (NullUtil.isNotNull((Object)(sku = (PcsSkuVO)skuMap.get(prdcJobLineVO.getSkuCode())))) {
                    prdcJobLineVO.setSkuName(sku.getNameCn());
                }
                tmpList.add(prdcJobLineVO);
            }
        }
        return jobMap;
    }

    @Override
    public List<PrdcPreJobVO> findPreJobListByCond(PrdcJobCond cond) {
        return this.prdcPreJobMapper.findPreJobListByCond(cond);
    }

    @Override
    public String findScmOperatorEmailByOperatorId(Long createOperatorId) {
        return this.prdcPreJobMapper.findScmOperatorEmailByOperatorId(createOperatorId);
    }

    @Override
    public List<PrdcJobVO> findNearestJobBySkuCodes(List<String> skuCodes) {
        return this.prdcJobMapper.findNearestJobBySkuCodes(skuCodes);
    }

    @Override
    public List<PrdcPreJobLineVO> findPreJobListListByPreJobId(Long preJobId) {
        return this.prdcPreJobLineMapper.findPreJobListListByPreJobId(preJobId);
    }

    @Override
    public List<PrdcPreJobDownloadVO> findPreJobDownListByCond(PrdcJobCond cond) {
        return this.prdcPreJobLineMapper.findPreJobDownListByCond(cond);
    }

    @Override
    @Transactional
    public Long processPrdcPreJob(PrdcPreJobVO vo) {
        Long prdcId = null;
        if (Calendar.getInstance().getTimeInMillis() < DateUtil.dayStart((Date)DateUtil.parse((String)vo.getEstStartDate(), (String)"yyyy-MM-dd")).getTime()) {
            return null;
        }
        if (Calendar.getInstance().getTimeInMillis() > DateUtil.dayEnd((Date)DateUtil.parse((String)vo.getEstDoneDate(), (String)"yyyy-MM-dd")).getTime()) {
            this.updatePrdcPreJobStatus(vo.getId(), PrdcPreJob.PRE_JOB_STATUS_FINISH);
        } else {
            int diff = vo.getEstQuantity() - vo.getFinishedQuantity();
            if (diff <= 0) {
                this.updatePrdcPreJobStatus(vo.getId(), PrdcPreJob.PRE_JOB_STATUS_FINISH);
            } else {
                List<PrdcPreJobLine> prdcPreJobLineList;
                PrdcPreJobLineExample example;
                int useAmount = 0;
                if (vo.getJobType() == 2) {
                    WhInvVO whInvVO = this.sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode(vo.getSkuCode(), vo.getWarehouseCode());
                    if (whInvVO != null && whInvVO.getCanUseInv() > 0) {
                        useAmount = whInvVO.getCanUseInv();
                    }
                } else {
                    PrdcPreJobLine prdcPreJobLine;
                    WhInvVO whInvVO;
                    example = new PrdcPreJobLineExample();
                    example.createCriteria().andPreJobIdEqualTo(vo.getId());
                    prdcPreJobLineList = this.prdcPreJobLineMapper.selectByExample(example);
                    int i = 0;
                    Iterator<PrdcPreJobLine> iterator = prdcPreJobLineList.iterator();
                    while (iterator.hasNext() && (whInvVO = this.sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode((prdcPreJobLine = iterator.next()).getSkuCode(), vo.getWarehouseCode())) != null && whInvVO.getCanUseInv() > 0) {
                        int skuUseAmount = new BigDecimal(whInvVO.getCanUseInv()).divide(new BigDecimal(prdcPreJobLine.getRecipeAmount().floatValue()), 0, 1).intValue();
                        if (i == 0) {
                            useAmount = skuUseAmount;
                        }
                        if (skuUseAmount < useAmount) {
                            useAmount = skuUseAmount;
                        }
                        ++i;
                    }
                }
                if (useAmount > 0) {
                    example = new PrdcPreJobLineExample();
                    example.createCriteria().andPreJobIdEqualTo(vo.getId());
                    prdcPreJobLineList = this.prdcPreJobLineMapper.selectByExample(example);
                    int amount = 0;
                    if (diff >= vo.getMinAmount()) {
                        if (useAmount >= vo.getMinAmount()) {
                            amount = useAmount > diff ? diff : useAmount;
                        }
                    } else if (diff <= useAmount) {
                        amount = diff;
                    }
                    if (amount > 0) {
                        prdcId = this.create(this.buildPrdcJob(vo, amount, prdcPreJobLineList));
                        int finishAmount = vo.getFinishedQuantity() + amount;
                        PrdcPreJob prdcPreJob = new PrdcPreJob();
                        prdcPreJob.setId(vo.getId());
                        prdcPreJob.setFinishedQuantity(finishAmount);
                        this.prdcPreJobMapper.updateByPrimaryKeySelective(prdcPreJob);
                        if (amount == diff) {
                            this.updatePrdcPreJobStatus(vo.getId(), PrdcPreJob.PRE_JOB_STATUS_FINISH);
                        } else {
                            this.updatePrdcPreJobStatus(vo.getId(), PrdcPreJob.PRE_JOB_STATUS_PROCESSING);
                        }
                    }
                }
            }
        }
        return prdcId;
    }

    private PrdcJobVO buildPrdcJob(PrdcPreJobVO vo, int amount, List<PrdcPreJobLine> prdcPreJobLineList) {
        PrdcJobVO prdcJobVO = new PrdcJobVO();
        prdcJobVO.setPlanStatus(PrdcJob.WMS_STATUS_RETURN_MODIFY);
        prdcJobVO.setCreateTime(Calendar.getInstance().getTime());
        prdcJobVO.setCreateOperatorId(vo.getCreateOperatorId());
        prdcJobVO.setReferenceCode(vo.getCode());
        prdcJobVO.setJobType(vo.getJobType());
        prdcJobVO.setRecipeId(vo.getRecipeId());
        prdcJobVO.setSkuCode(vo.getSkuCode());
        prdcJobVO.setWarehouseCode(vo.getWarehouseCode());
        prdcJobVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        prdcJobVO.setEstDoneDate(Calendar.getInstance().getTime());
        prdcJobVO.setEstQuantity(amount);
        prdcJobVO.setCreateOperatorName(vo.getCreateOperatorName());
        prdcJobVO.setRemark(vo.getRemark());
        prdcJobVO.setPriority(vo.getPriority());
        ArrayList<PrdcJobLineVO> prdcJobLineList = new ArrayList<PrdcJobLineVO>();
        prdcJobVO.setPrdcJobLineVOList(prdcJobLineList);
        for (PrdcPreJobLine prdcPreJobLine : prdcPreJobLineList) {
            PrdcJobLineVO prdcJobLine = new PrdcJobLineVO();
            prdcJobLine.setSkuCode(prdcPreJobLine.getSkuCode());
            prdcJobLine.setMaterialType(prdcPreJobLine.getMaterialType());
            prdcJobLine.setRecipeAmount(prdcPreJobLine.getRecipeAmount());
            prdcJobLine.setQuantity(Float.valueOf(new BigDecimal(prdcPreJobLine.getRecipeAmount().floatValue()).multiply(new BigDecimal(amount)).setScale(0, 0).floatValue()));
            prdcJobLine.setRealQuantity(Float.valueOf(0.0f));
            prdcJobLineList.add(prdcJobLine);
        }
        return prdcJobVO;
    }

    private void updatePrdcPreJobStatus(Long id, Integer status) {
        PrdcPreJob prdcPreJob = new PrdcPreJob();
        prdcPreJob.setId(id);
        prdcPreJob.setPlanStatus(status);
        this.prdcPreJobMapper.updateByPrimaryKeySelective(prdcPreJob);
    }

    @Override
    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond, Boolean cascade) {
        List<PrdcJob> prdcJobList = this.prdcJobMapper.findJobVOByCond(cond);
        if (CollectionUtils.isEmpty(prdcJobList)) {
            return new ArrayList<PrdcJobVO>();
        }
        List prdcJobVOList = BeanUtil.buildListFrom(prdcJobList, PrdcJobVO.class);
        ArrayList<String> skuCodes = new ArrayList<String>();
        HashSet<String> physicalWarehouseCodeSet = new HashSet<String>();
        HashSet<String> warehouseCodeSet = new HashSet<String>();
        ArrayList<Long> recipeIds = new ArrayList<Long>();
        ArrayList<Long> jobIds = new ArrayList<Long>();
        for (PrdcJobVO prdcJobVO : prdcJobVOList) {
            skuCodes.add(prdcJobVO.getSkuCode());
            recipeIds.add(prdcJobVO.getRecipeId());
            jobIds.add(prdcJobVO.getId());
            physicalWarehouseCodeSet.add(prdcJobVO.getPhysicalWarehouseCode());
            warehouseCodeSet.add(prdcJobVO.getWarehouseCode());
        }
        List skuList = this.mcPcsSkuService.findSkuByCodes(skuCodes, false);
        HashMap<String, PcsSkuVO> skuMap = new HashMap<String, PcsSkuVO>();
        if (EmptyUtil.isNotEmpty((List)skuList)) {
            for (PcsSkuVO sku : skuList) {
                skuMap.put(sku.getCode(), sku);
            }
        }
        List<String> warehouseCodes = Arrays.asList(warehouseCodeSet.toArray(new String[warehouseCodeSet.size()]));
        Map whGroupMap = this.sWhWarehouseGroupService.findWhGroupMap(warehouseCodes);
        List whWarehouses = this.sWhInfoService.findWarehouseByCodes(warehouseCodes);
        HashMap<String, WhWarehouseVO> warehouseCodeMap = new HashMap<String, WhWarehouseVO>();
        if (EmptyUtil.isNotEmpty((List)whWarehouses)) {
            for (WhWarehouseVO warehouse : whWarehouses) {
                warehouseCodeMap.put(warehouse.getCode(), warehouse);
            }
        }
        WhPhysicalWarehouseVO whPhysicalWarehouseVO = new WhPhysicalWarehouseVO();
        whPhysicalWarehouseVO.setWarehouseCodes(Arrays.asList(physicalWarehouseCodeSet.toArray(new String[physicalWarehouseCodeSet.size()])));
        List physicalWarehouses = this.sWhInfoService.findPhysicalWarehouseByCond((WhPhysicalWarehouseVO)BeanUtil.buildFrom((Object)whPhysicalWarehouseVO, WhPhysicalWarehouseVO.class));
        HashMap<String, WhPhysicalWarehouseVO> physicalWarehouseCodeMap = new HashMap<String, WhPhysicalWarehouseVO>();
        if (EmptyUtil.isNotEmpty((List)physicalWarehouses)) {
            for (WhPhysicalWarehouseVO physicalWarehouse : physicalWarehouses) {
                physicalWarehouseCodeMap.put(physicalWarehouse.getCode(), physicalWarehouse);
            }
        }
        for (PrdcJobVO prdcJobVO : prdcJobVOList) {
            WhWarehouseGroupVO whGroup;
            PcsSkuVO skuVO = (PcsSkuVO)skuMap.get(prdcJobVO.getSkuCode());
            if (NullUtil.isNotNull((Object)skuVO)) {
                prdcJobVO.setSkuName(skuVO.getNameCn());
                prdcJobVO.setSkuBuyerId(skuVO.getBuyerId());
                prdcJobVO.setSkuBuyerName(skuVO.getBuyerName());
            }
            if (NullUtil.isNotNull(warehouseCodeMap.get(prdcJobVO.getWarehouseCode()))) {
                prdcJobVO.setWarehouseName(((WhWarehouseVO)warehouseCodeMap.get(prdcJobVO.getWarehouseCode())).getName());
            }
            if (NullUtil.isNotNull(physicalWarehouseCodeMap.get(prdcJobVO.getPhysicalWarehouseCode()))) {
                prdcJobVO.setPhysicalWarehouseName(((WhPhysicalWarehouseVO)physicalWarehouseCodeMap.get(prdcJobVO.getPhysicalWarehouseCode())).getName());
                prdcJobVO.setWhPhysicalWarehouse((WhPhysicalWarehouseVO)physicalWarehouseCodeMap.get(prdcJobVO.getPhysicalWarehouseCode()));
            }
            if (!EmptyUtil.isNotEmpty((Object)(whGroup = (WhWarehouseGroupVO)whGroupMap.get(prdcJobVO.getWarehouseCode()))) || !WhWarehouseGroupVO.WAREHOUSE_YES.equals(whGroup.getType())) continue;
            prdcJobVO.setPhysicalWhIsWarehouse(true);
        }
        if (cascade.booleanValue()) {
            HashMap<Long, PrdcRecipeVO> recipeMap = new HashMap<Long, PrdcRecipeVO>();
            PrdcRecipeCond recipeCond = new PrdcRecipeCond();
            recipeCond.setRecipeIds(recipeIds);
            List<PrdcRecipeVO> recipeList = this.prdcRecipeService.findRecipeVOByCond(recipeCond, true);
            if (EmptyUtil.isNotEmpty(recipeList)) {
                for (PrdcRecipeVO recipeVO : recipeList) {
                    recipeMap.put(recipeVO.getId(), recipeVO);
                }
            }
            Map<Long, List<PrdcJobLineVO>> prdcJobLineMap = this.findJobLineVOByJobIds(jobIds);
            for (PrdcJobVO prdcJobVO : prdcJobVOList) {
                PrdcRecipeVO prdcRecipeVO = (PrdcRecipeVO)recipeMap.get(prdcJobVO.getRecipeId());
                if (NullUtil.isNotNull((Object)prdcRecipeVO)) {
                    prdcJobVO.setRecipeName(prdcRecipeVO.getRecipeName());
                    prdcJobVO.setRecipeCreateOperatorName(prdcRecipeVO.getCreateUserName());
                    prdcJobVO.setCustomization(prdcRecipeVO.getCustomization());
                }
                prdcJobVO.setPrdcJobLineVOList(prdcJobLineMap.get(prdcJobVO.getId()));
            }
            this.fullCustoimzationInfo(prdcJobVOList);
        }
        return prdcJobVOList;
    }

    private void fullCustoimzationInfo(List<PrdcJobVO> prdcJobVOList) {
        if (EmptyUtil.isEmpty(prdcJobVOList)) {
            return;
        }
        ArrayList<String> codes = new ArrayList<String>();
        for (PrdcJobVO jobVO : prdcJobVOList) {
            codes.add(jobVO.getCode());
        }
        Map codeMap = this.sWhJitPackageSkuReferenceService.findByReferenceCodeGroup(codes);
        if (!codeMap.isEmpty()) {
            for (PrdcJobVO jobVO : prdcJobVOList) {
                List tmpList = (List)codeMap.get(jobVO.getCode());
                if (!NullUtil.isNotNull((Object)tmpList)) continue;
                jobVO.setJitPackageSkuReferenceList(tmpList);
            }
        }
    }

    @Override
    public Pagination<PrdcJobVO> findJobVOByCondPage(PrdcJobCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int total = this.prdcJobMapper.countJobVOByCond(cond);
        if (NumberUtil.isNullOrZero((Number)total)) {
            page.setRecord(Integer.valueOf(0));
            return page;
        }
        List<PrdcJobVO> list = this.findJobVOByCond(cond, cond.isCascade());
        list.forEach(vo -> this.setPrdcJobVOProperty((PrdcJobVO)vo));
        page.setRecord(Integer.valueOf(total));
        page.setResultList(list);
        return page;
    }

    private void setPrdcJobVOProperty(PrdcJobVO vo) {
        if (vo != null) {
            if (vo.getWarehouseCode() != null) {
                Map whGroupMap;
                WhWarehouseGroupVO whGroup;
                WhWarehouseVO whWarehouseVO = warehouseMap.get(vo.getWarehouseCode());
                if (whWarehouseVO == null && (whWarehouseVO = this.sWhInfoService.findWarehouseByCode(vo.getWarehouseCode())) != null) {
                    warehouseMap.put(whWarehouseVO.getCode(), whWarehouseVO);
                }
                if (whWarehouseVO != null) {
                    vo.setWarehouseName(whWarehouseVO.getName());
                }
                if ((whGroup = PrdcJobServiceImpl.whGroupMap.get(vo.getWarehouseCode())) == null && (whGroupMap = this.sWhWarehouseGroupService.findWhGroupMap(Collections.singletonList(vo.getWarehouseCode()))) != null && whGroupMap.size() > 0) {
                    whGroup = (WhWarehouseGroupVO)whGroupMap.get(vo.getWarehouseCode());
                    whGroupMap.put(vo.getWarehouseCode(), whGroup);
                }
                boolean isG = false;
                if (WhWarehouseGroupVO.WAREHOUSE_YES.equals(whGroup.getType())) {
                    isG = true;
                }
                vo.setPhysicalWhIsWarehouse(isG);
            }
            if (vo.getPhysicalWarehouseCode() != null) {
                WhPhysicalWarehouseVO whPhysicalWarehouseVO = whPhysicalWarehouseMap.get(vo.getPhysicalWarehouseCode());
                if (whPhysicalWarehouseVO == null && (whPhysicalWarehouseVO = this.sWhInfoService.findPhysicalWarehouseByCode(vo.getPhysicalWarehouseCode())) != null) {
                    whPhysicalWarehouseMap.put(whPhysicalWarehouseVO.getCode(), whPhysicalWarehouseVO);
                }
                if (whPhysicalWarehouseVO != null) {
                    vo.setPhysicalWarehouseName(whPhysicalWarehouseVO.getName());
                }
            }
        }
    }

    @Override
    public PrdcJobCountInfo countPrdcJobByCond(PrdcJobCond cond) {
        return this.prdcJobMapper.countPrdcJobByCond(cond);
    }

    @Override
    @Transactional
    public Long create(PrdcJobVO vo) {
        ArrayList<WhInvOccupyVO> whOccupyList = new ArrayList<WhInvOccupyVO>();
        PrdcJob prdcJob = this.savePrdcJobAndGetOccupyList(vo, whOccupyList);
        vo.setCode(prdcJob.getCode());
        this.buildWhJitPackageSkuReference(vo);
        this.sWhInvService.occupy(whOccupyList, vo.getJitPackageSkuReferenceList());
        return prdcJob.getId();
    }

    private void buildWhJitPackageSkuReference(PrdcJobVO vo) {
        if (EmptyUtil.isNotEmpty(vo.getJitPackageSkuReferenceList())) {
            Date createTime = DateUtil.getNow();
            for (WhJitPackageSkuReferenceVO skuReferenceVO : vo.getJitPackageSkuReferenceList()) {
                skuReferenceVO.setReferenceCode(vo.getCode());
                skuReferenceVO.setCreateTime(createTime);
                if (NullUtil.isNull((Object)vo.getCreateOperatorId())) {
                    skuReferenceVO.setCreateUserId(Long.valueOf(1L));
                    continue;
                }
                skuReferenceVO.setCreateUserId(vo.getCreateOperatorId());
            }
        }
    }

    @Override
    @Transactional
    public Integer updatePrdcPreJobByKey(PrdcPreJob prdcPreJob) {
        return this.prdcPreJobMapper.updateByPrimaryKeySelective(prdcPreJob);
    }

    @Override
    @Transactional
    public Long createPrdcPreJob(PrdcPreJob vo) {
        this.prdcPreJobMapper.insert(vo);
        int num = 0;
        int result = 0;
        while (result <= 0) {
            vo.setCode(this.generatePreJobCode(num));
            ++num;
            try {
                result = this.prdcPreJobMapper.updateByPrimaryKeySelective(vo);
            }
            catch (Exception exception) {}
        }
        PrdcRecipeMaterialExample example = new PrdcRecipeMaterialExample();
        example.createCriteria().andRecipeIdEqualTo(vo.getRecipeId());
        List<PrdcRecipeMaterial> list = this.prdcRecipeMaterialMapper.selectByExample(example);
        for (PrdcRecipeMaterial prdcRecipeMaterial : list) {
            PrdcPreJobLine prdcPreJobLine = new PrdcPreJobLine();
            prdcPreJobLine.setSkuCode(prdcRecipeMaterial.getSkuCode());
            prdcPreJobLine.setMaterialType(prdcRecipeMaterial.getMaterialType());
            prdcPreJobLine.setRecipeAmount(prdcRecipeMaterial.getQuantity());
            prdcPreJobLine.setPreJobId(vo.getId());
            this.prdcPreJobLineMapper.insert(prdcPreJobLine);
        }
        return vo.getId();
    }

    @Override
    @Transactional
    public String createFlowerPrdcPreJob(PcsPreAllotVO vo) {
        PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe = this.pcsFlowerDeliveryRecipeMapper.selectByPrimaryKey(vo.getRecipeId());
        PcsFlowerRecipeSkuExample pcsFlowerRecipeSkuExample = new PcsFlowerRecipeSkuExample();
        PcsFlowerRecipeSkuExample.Criteria criteria = pcsFlowerRecipeSkuExample.createCriteria();
        criteria.andRecipeIdEqualTo(vo.getRecipeId());
        criteria.andAvailableEqualTo(1);
        List<PcsFlowerRecipeSku> pcsFlowerRecipeSkuList = this.pcsFlowerRecipeSkuMapper.selectByExample(pcsFlowerRecipeSkuExample);
        if (pcsFlowerRecipeSkuList == null || pcsFlowerRecipeSkuList.size() == 0) {
            throw new PurchaseException("999", "\u8fd8\u6ca1\u6709\u751f\u6210\u914d\u65b9");
        }
        if (vo.getSelfShouldSendQuantity() <= 0) {
            throw new PurchaseException("999", "\u6210\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        }
        PrdcRecipeCond prdcRecipeCond = new PrdcRecipeCond();
        prdcRecipeCond.setRecipeSkuCode(pcsFlowerDeliveryRecipe.getSkuCode());
        List<PrdcRecipeVO> prdcRecipeVOList = this.prdcRecipeService.findRecipeVOByCond(prdcRecipeCond, false);
        Long prdcRecipeId = null;
        if (prdcRecipeVOList == null || prdcRecipeVOList.size() == 0) {
            PrdcRecipeVO prdcRecipeVO = new PrdcRecipeVO();
            prdcRecipeVO.setCreateTime(Calendar.getInstance().getTime());
            prdcRecipeVO.setCreateUserId(vo.getOperatorId());
            PcsSkuVO pcsSkuVO = this.mcPcsSkuService.findByCode(pcsFlowerDeliveryRecipe.getSkuCode());
            prdcRecipeVO.setRecipeDesc(pcsSkuVO == null ? "" : pcsSkuVO.getNameCn());
            prdcRecipeVO.setRecipeName(pcsSkuVO == null ? "" : pcsSkuVO.getNameCn());
            prdcRecipeVO.setRecipeStatus(1);
            prdcRecipeVO.setSkuCode(pcsFlowerDeliveryRecipe.getSkuCode());
            ArrayList<PrdcRecipeMaterialVO> prdcRecipeMaterialVOList = new ArrayList<PrdcRecipeMaterialVO>();
            prdcRecipeVO.setRecipeMaterialVOList(prdcRecipeMaterialVOList);
            for (PcsFlowerRecipeSku pcsFlowerRecipeSku : pcsFlowerRecipeSkuList) {
                PrdcRecipeMaterialVO prdcRecipeMaterialVO = new PrdcRecipeMaterialVO();
                prdcRecipeMaterialVO.setSkuCode(pcsFlowerRecipeSku.getSkuCode());
                prdcRecipeMaterialVO.setQuantity(pcsFlowerRecipeSku.getExpendNumber());
                prdcRecipeMaterialVO.setMaterialType(pcsFlowerRecipeSku.getSkuType() == 0 ? 2 : pcsFlowerRecipeSku.getSkuType());
                prdcRecipeMaterialVOList.add(prdcRecipeMaterialVO);
            }
            prdcRecipeId = this.prdcRecipeService.create(prdcRecipeVO);
        } else {
            prdcRecipeId = prdcRecipeVOList.get(0).getId();
        }
        PrdcPreJob prdcPreJob = new PrdcPreJob();
        prdcPreJob.setSkuCode(pcsFlowerDeliveryRecipe.getSkuCode());
        prdcPreJob.setCreateTime(Calendar.getInstance().getTime());
        prdcPreJob.setPlanStatus(1);
        prdcPreJob.setCreateOperatorId(vo.getOperatorId());
        prdcPreJob.setFinishedQuantity(0);
        prdcPreJob.setEstDoneDate(pcsFlowerDeliveryRecipe.getSendDay());
        prdcPreJob.setEstQuantity(vo.getSelfShouldSendQuantity());
        prdcPreJob.setEstStartDate(Calendar.getInstance().getTime());
        prdcPreJob.setJobType(1);
        prdcPreJob.setMinQuantity(10);
        prdcPreJob.setRecipeId(prdcRecipeId);
        prdcPreJob.setRemark("\u5468\u671f\u914d\u9001\u5546\u54c1");
        prdcPreJob.setWarehouseCode("WH020600010096");
        this.prdcPreJobMapper.insertSelective(prdcPreJob);
        int num = 0;
        int result = 0;
        while (result <= 0) {
            prdcPreJob.setCode(this.generatePreJobCode(num));
            ++num;
            try {
                result = this.prdcPreJobMapper.updateByPrimaryKeySelective(prdcPreJob);
            }
            catch (Exception exception) {}
        }
        for (PcsFlowerRecipeSku pcsFlowerRecipeSku : pcsFlowerRecipeSkuList) {
            PrdcPreJobLine prdcPreJobLine = new PrdcPreJobLine();
            prdcPreJobLine.setPreJobId(prdcPreJob.getId());
            prdcPreJobLine.setRecipeAmount(pcsFlowerRecipeSku.getExpendNumber());
            prdcPreJobLine.setMaterialType(pcsFlowerRecipeSku.getSkuType() == 0 ? 2 : pcsFlowerRecipeSku.getSkuType());
            prdcPreJobLine.setSkuCode(pcsFlowerRecipeSku.getSkuCode());
            this.prdcPreJobLineMapper.insertSelective(prdcPreJobLine);
        }
        return prdcPreJob.getCode();
    }

    private PrdcPreJobVO createPrdcPreJob(PrdcPreJobVO vo) {
        PrdcPreJob prdcPreJob = (PrdcPreJob)BeanUtil.buildFrom((Object)vo, PrdcPreJob.class);
        Integer id = this.prdcPreJobMapper.insertSelective(prdcPreJob);
        int num = 0;
        int result = 0;
        while (result <= 0) {
            prdcPreJob.setCode(this.generatePreJobCode(num));
            ++num;
            try {
                result = this.prdcPreJobMapper.updateByPrimaryKeySelective(prdcPreJob);
            }
            catch (Exception exception) {}
        }
        List list = BeanUtil.buildListFrom(vo.getJobLineVOList(), PrdcPreJobLine.class);
        for (PrdcPreJobLine prdcPreJobLine : list) {
            prdcPreJobLine.setPreJobId(Long.parseLong(id.toString()));
            this.prdcPreJobLineMapper.insertSelective(prdcPreJobLine);
        }
        vo.setId(Long.parseLong(id.toString()));
        vo.setCode(prdcPreJob.getCode());
        return vo;
    }

    private String generatePreJobCode(int num) {
        String date = DateUtil.format((Date)Calendar.getInstance().getTime(), (String)"yyyyMMddHHmmss");
        long dateLong = Long.parseLong(date);
        return "FPJ" + (dateLong += (long)num);
    }

    private PrdcJob savePrdcJobAndGetOccupyList(PrdcJobVO vo, List<WhInvOccupyVO> whOccupyList) {
        vo.setProcessingAmount(0);
        vo.setFinishedDamagedQuantity(0);
        vo.setFinishedQuantity(0);
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)vo, PrdcJob.class);
        List prdcJobLineList = BeanUtil.buildListFrom(vo.getPrdcJobLineVOList(), PrdcJobLine.class);
        WhWarehouseVO whWarehouse = this.sWhInfoService.findWarehouseByCode(vo.getWarehouseCode());
        Validation.paramNotNull((Object)whWarehouse, (String)"\u903b\u8f91\u4ed3\u4e3a\u7a7a");
        Validation.paramNotNull((Object)whWarehouse.getCommodityStatus(), (String)"\u903b\u8f91\u4ed3\u5546\u54c1\u72b6\u6001\u4e3a\u7a7a");
        PhyWhStockCond phyWhStockCond = new PhyWhStockCond();
        phyWhStockCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        phyWhStockCond.setSkuStatus(whWarehouse.getCommodityStatus());
        if (vo.getJobType() == PrdcJobVO.JOB_TYPE_ASSEMBLE) {
            for (PrdcJobLine jobLine : prdcJobLineList) {
                WhInvVO whInvVO = this.sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode(jobLine.getSkuCode(), vo.getWarehouseCode());
                if (jobLine.getQuantity().floatValue() > (float)whInvVO.getCanUseInv()) {
                    throw new PurchaseException("", "SKU[" + jobLine.getSkuCode() + "]\u5728[" + whWarehouse.getName() + "]\u4e2d\u7684\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3");
                }
                phyWhStockCond.setSkuCode(jobLine.getSkuCode());
                int physicalSkuStockCount = this.findPhysicalSkuStock(phyWhStockCond);
                if (!(jobLine.getQuantity().floatValue() > (float)physicalSkuStockCount)) continue;
                throw new PurchaseException("", "\u7269\u7406\u4ed3\u5e93\u5b58\u4e0d\u8db3\uff0cSKU[" + jobLine.getSkuCode() + "],\u5546\u54c1\u72b6\u6001[" + phyWhStockCond.getSkuStatus() + "]\u7269\u7406\u4ed3[" + phyWhStockCond.getPhysicalWarehouseCode() + "]\uff0c\u9700\u6263\u51cf\u6570[" + jobLine.getQuantity() + "]>\u5f53\u524d\u5e93\u5b58\u6570[" + physicalSkuStockCount + "]");
            }
        } else if (vo.getJobType() == PrdcJobVO.JOB_TYPE_SPLIT) {
            WhInvVO whInvVO = this.sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode(vo.getSkuCode(), vo.getWarehouseCode());
            if (vo.getEstQuantity() > whInvVO.getCanUseInv()) {
                throw new PurchaseException("", "SKU[" + vo.getSkuCode() + "]\u5728[" + whWarehouse.getName() + "]\u4e2d\u7684\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3");
            }
            phyWhStockCond.setSkuCode(vo.getSkuCode());
            int physicalSkuStockCount = this.findPhysicalSkuStock(phyWhStockCond);
            if (vo.getEstQuantity() > physicalSkuStockCount) {
                throw new PurchaseException("", "\u7269\u7406\u4ed3\u5e93\u5b58\u4e0d\u8db3\uff0cSKU[" + vo.getSkuCode() + "],\u5546\u54c1\u72b6\u6001[" + phyWhStockCond.getSkuStatus() + "]\u7269\u7406\u4ed3[" + phyWhStockCond.getPhysicalWarehouseCode() + "]\uff0c\u9700\u6263\u51cf\u6570[" + vo.getEstQuantity() + "]>\u5f53\u524d\u5e93\u5b58\u6570[" + physicalSkuStockCount + "]");
            }
        }
        this.createJob(prdcJob);
        vo.setCode(prdcJob.getCode());
        this.saveJobLine(prdcJob, prdcJobLineList);
        whOccupyList.addAll(this.buildWhOccupy(prdcJob, prdcJobLineList, vo.getWarehouseCode(), WhInvOccupyVO.TYPE_PRODUCE_OUT));
        return prdcJob;
    }

    private int findPhysicalSkuStock(PhyWhStockCond cond) {
        List phyWhStockVOs = this.sWhWmsSkuStockService.findPhyWhStockByCond(cond);
        if (CollectionUtils.isEmpty((Collection)phyWhStockVOs)) {
            return 0;
        }
        return ((PhyWhStockVO)phyWhStockVOs.get(0)).getCanUseQuantity();
    }

    @Override
    @Transactional
    public List<Long> batchCreate(List<PrdcJobVO> list) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (EmptyUtil.isNotEmpty(list)) {
            ArrayList<WhInvOccupyVO> whOccupyList = new ArrayList<WhInvOccupyVO>();
            for (PrdcJobVO vo : list) {
                PrdcJob prdcJob = this.savePrdcJobAndGetOccupyList(vo, whOccupyList);
                ids.add(prdcJob.getId());
            }
            ServiceResp serviceResp = this.sStockService.occupy(this.convertWhInvOccupy2DTO(whOccupyList));
            if (serviceResp.isFailure()) {
                throw new PurchaseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
            }
        }
        return ids;
    }

    @Override
    @Transactional
    public List<Long> batchCreate(List<PrdcJobVO> list, String allotCode) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (EmptyUtil.isNotEmpty(list)) {
            ArrayList<WhInvOccupyVO> whOccupyList = new ArrayList<WhInvOccupyVO>();
            ArrayList<WhJitPackageSkuReferenceVO> referenceVOList = new ArrayList<WhJitPackageSkuReferenceVO>();
            for (PrdcJobVO vo : list) {
                PrdcJob prdcJob = this.savePrdcJobAndGetOccupyList(vo, whOccupyList);
                this.buildWhJitPackageSkuReference(vo);
                if (EmptyUtil.isNotEmpty(vo.getJitPackageSkuReferenceList())) {
                    referenceVOList.addAll(vo.getJitPackageSkuReferenceList());
                }
                ids.add(prdcJob.getId());
            }
            this.sWhInvService.occupy(whOccupyList, referenceVOList, allotCode);
        }
        return ids;
    }

    @Override
    public List<Long> batchCreateAndFinishForKafka(List<PrdcJobVO> list) throws Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (EmptyUtil.isNotEmpty(list)) {
            ArrayList<WhInvOccupyVO> whOccupyList = new ArrayList<WhInvOccupyVO>();
            for (PrdcJobVO vo : list) {
                PrdcJob prdcJob = this.savePrdcJobAndGetOccupyList(vo, whOccupyList);
                vo.setId(prdcJob.getId());
                ids.add(prdcJob.getId());
            }
            ServiceResp serviceResp = this.sStockService.occupy(this.convertWhInvOccupy2DTO(whOccupyList));
            if (serviceResp.isFailure()) {
                throw new PurchaseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
            }
        }
        if (EmptyUtil.isNotEmpty(list)) {
            for (PrdcJobVO vo : list) {
                PrdcJobVO updateVO = new PrdcJobVO();
                updateVO = (PrdcJobVO)BeanUtil.buildFrom((Object)vo, PrdcJobVO.class);
                updateVO.setFinishTime(new Date());
                updateVO.setCreateTime(new Date());
                PrdcJobLineExample example = new PrdcJobLineExample();
                example.createCriteria().andJobIdEqualTo(updateVO.getId());
                List<PrdcJobLine> jobLines = this.prdcJobLineMapper.selectByExample(example);
                for (PrdcJobLine line : jobLines) {
                    line.setRealQuantity(line.getQuantity());
                }
                List jobLineVOS = BeanUtil.buildListFrom(jobLines, PrdcJobLineVO.class);
                updateVO.setPrdcJobLineVOList(jobLineVOS);
                this.finishJob(updateVO);
            }
        }
        return ids;
    }

    private void finishJob(PrdcJobVO vo) throws Exception {
        List prdcJobLineList = BeanUtil.buildListFrom(vo.getPrdcJobLineVOList(), PrdcJobLine.class);
        List<WhReleaseOccupationVO> whReleaseOccupationVOList = this.buildWhRelease(vo, prdcJobLineList, WhInvOccupyVO.TYPE_PRODUCE_OUT);
        if (CollectionUtils.isEmpty(whReleaseOccupationVOList)) {
            throw new PurchaseException("PC0001", "\u521b\u5efa\u91ca\u653e\u5360\u7528\u5e93\u5b58\u5931\u8d25");
        }
        vo.setFinishedQuantity(vo.getEstQuantity());
        vo.setConfirmOperatorId(vo.getCreateOperatorId());
        vo.setConfirmOperatorName(vo.getCreateOperatorName());
        for (PrdcJobLineVO jobLine_0 : vo.getPrdcJobLineVOList()) {
            for (PrdcJobLineVO jobLine : vo.getPrdcJobLineVOList()) {
                if (!jobLine_0.getSkuCode().equals(jobLine.getSkuCode())) continue;
                if (vo.getJobType() == 2 && jobLine_0.getMaterialType() == 2) {
                    jobLine_0.setRealQuantity(new Float(0.0f));
                    jobLine_0.setDamageQuantity(0);
                    continue;
                }
                jobLine_0.setRealQuantity(jobLine.getRealQuantity());
                jobLine_0.setDamageQuantity(jobLine.getDamageQuantity());
                jobLine_0.setRemark(jobLine.getRemark());
            }
        }
        List<WhCommandVO> whCommands = this.buildPrdcCommands(vo);
        this.createCommandsAfterReleaseThenFinishAndUpdate(vo, whCommands, whReleaseOccupationVOList);
    }

    @Override
    @Transactional
    public Boolean returnModify(PrdcJobVO vo) {
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)vo, PrdcJob.class);
        List prdcJobLineList_0 = BeanUtil.buildListFrom(this.findJobLineVOByJobId(vo.getId()), PrdcJobLine.class);
        List<WhReleaseOccupationVO> whReleaseList = this.buildWhRelease(prdcJob, prdcJobLineList_0, WhInvOccupyVO.TYPE_PRODUCE_OUT);
        List prdcJobLineList = BeanUtil.buildListFrom(vo.getPrdcJobLineVOList(), PrdcJobLine.class);
        this.returnModifyJob(prdcJob);
        this.changeJobLine(prdcJob, prdcJobLineList);
        List<WhInvOccupyVO> whOccupyList = this.buildWhOccupy(prdcJob, prdcJobLineList, vo.getWarehouseCode(), WhInvOccupyVO.TYPE_PRODUCE_OUT);
        this.buildWhJitPackageSkuReference(vo);
        this.sWhInvService.occupyAfterRelease(whOccupyList, whReleaseList, vo.getCode(), vo.getJitPackageSkuReferenceList());
        return true;
    }

    @Override
    public Boolean deleteJobLine(Long jobId, Long jobLineId) {
        if (jobId == null || jobLineId == null) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PrdcJobVO prdcJobVO = this.findJobVOById(jobId);
        if (prdcJobVO == null) {
            throw new PurchaseException("PC0001", "\u5339\u914d\u4e0d\u5230\u4efb\u52a1");
        }
        Boolean found = false;
        for (PrdcJobLineVO prdcJobLineVO : prdcJobVO.getPrdcJobLineVOList()) {
            if (!prdcJobLineVO.getId().equals(jobLineId)) continue;
            found = true;
        }
        if (found.booleanValue()) {
            if (this.prdcJobLineMapper.deleteByPrimaryKey(jobLineId) == 0) {
                throw new PurchaseException("PC0011", "\u5220\u9664\u4efb\u52a1\u884c\u5931\u8d25");
            }
        } else {
            throw new PurchaseException("PC0001", "\u4efb\u52a1\u4e0d\u5305\u542b\u8be5\u884c\u6570\u636e");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean cancelJobForStatusReturnModify(Long jobId) {
        if (jobId == null || jobId <= 0L) throw new PurchaseException("PC0001", "the id is invalid");
        PrdcJobVO prdcJobVO = this.findJobVOById(jobId);
        if (prdcJobVO == null) throw new PurchaseException("PC0001", "job is not found ");
        if (!prdcJobVO.getPlanStatus().equals(PrdcJob.PLAN_STATUS_RETURN_MODIFY)) throw new PurchaseException("PC0002", "the status is invalid ");
        PrdcJob update = new PrdcJob();
        update.setId(jobId);
        update.setPlanStatus(PrdcJob.PLAN_STATUS_CANCEL);
        if (this.prdcJobMapper.updateByPrimaryKeySelective(update) != 0) return true;
        throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    @Transactional
    public Boolean startProduction(PrdcJobVO jobVO) {
        if (jobVO == null) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)jobVO, PrdcJob.class);
        int update = this.prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0) {
            throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean releaseJobLineOccupyAndUpdate(PrdcJobVO jobVO, List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        if (jobVO == null) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)jobVO, PrdcJob.class);
        int update = this.prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0) {
            throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
        this.sWhInvService.releaseOccupation(whReleaseOccupationVOList, jobVO.getJitPackageSkuReferenceList());
        return true;
    }

    @Override
    @Transactional
    public Boolean createCommandsAfterReleaseThenFinishAndUpdate(PrdcJobVO jobVO, List<WhCommandVO> whCommands, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        List commands;
        if (jobVO == null) {
            throw new PurchaseException("PC0001", "param abnormal!");
        }
        if (jobVO.getPlanStatus() == PrdcJob.PLAN_STATUS_FINISHED || jobVO.getPlanStatus() == PrdcJob.WMS_PLAN_STATUS_FINISHED || jobVO.getPlanStatus() == PrdcJob.PLAN_STATUS_CANCEL) {
            throw new PurchaseException("PC0001", "status abnormal!");
        }
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)jobVO, PrdcJob.class);
        prdcJob.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_FINISHED);
        prdcJob.setFinishTime(new Date());
        int updateJob = this.prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (updateJob <= 0) {
            throw new PurchaseException("PC0010", "update data failed!");
        }
        for (PrdcJobLine prdcJobLine : jobVO.getPrdcJobLineVOList()) {
            int updateJobLine = this.prdcJobLineMapper.updateByPrimaryKey(prdcJobLine);
            if (updateJobLine > 0) continue;
            throw new PurchaseException("PC0010", "update data failed!");
        }
        if (EmptyUtil.isNotEmpty(whCommands)) {
            for (WhCommandVO whCommandVO : whCommands) {
                whCommandVO.setPlanedDeliveryDate(prdcJob.getFinishTime());
            }
        }
        if (EmptyUtil.isEmpty((List)(commands = this.wWhCommandService.createCommandsAfterReleaseThenFinishForPrdc(whCommands, whReleaseOccupationVOList)))) {
            throw new PurchaseException("PC0001", "param abnormal!");
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateJobVO(PrdcJobVO jobVO) {
        if (jobVO == null) {
            throw new PurchaseException("PC0010", "param abnormal!");
        }
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)jobVO, PrdcJob.class);
        int update = this.prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0) {
            throw new PurchaseException("PC0010", "update data failed!");
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updatePjJobVO(PrdcJobVO jobVO) {
        if (jobVO == null) {
            throw new PurchaseException("PC0010", "param abnormal!");
        }
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)jobVO, PrdcJob.class);
        int update = this.prdcJobMapper.updateByPrimaryKeySelective(prdcJob);
        if (update <= 0) {
            throw new PurchaseException("PC0010", "update data failed!");
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updateProdJobById(long id, Integer sign) {
        int result = 0;
        try {
            result = this.prdcJobMapper.updateProdJobById(id, sign);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return result > 0;
    }

    @Override
    @Transactional
    public boolean updateJobConfirmToWmsReturnModify(String jobCode) {
        PrdcJobExample example = new PrdcJobExample();
        example.createCriteria().andCodeEqualTo(jobCode);
        List<PrdcJob> jobs = this.prdcJobMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(jobs)) {
            throw new PurchaseException("PC0002", String.format("[%s]\u52a0\u5de5\u5355\u4e0d\u5b58\u5728", jobCode));
        }
        PrdcJob job = jobs.get(0);
        if (!PrdcJob.PLAN_STATUS_CONFIRM.equals(job.getPlanStatus())) {
            throw new PurchaseException("PC0002", String.format("[%s]\u52a0\u5de5\u5355\u72b6\u6001[%s]", jobCode, job.getPlanStatus()));
        }
        this.changePrdcJobStatus(job.getId(), PrdcJob.PLAN_STATUS_CONFIRM, PrdcJob.WMS_STATUS_RETURN_MODIFY);
        return true;
    }

    private void changePrdcJobStatus(Long jobId, Integer oldStatus, Integer newStatus) {
        PrdcJobExample example = new PrdcJobExample();
        example.createCriteria().andPlanStatusEqualTo(oldStatus).andIdEqualTo(jobId);
        PrdcJob record = new PrdcJob();
        record.setPlanStatus(newStatus);
        int count = this.prdcJobMapper.updateByExampleSelective(record, example);
        if (count != 1) {
            throw new PurchaseException("PC0002", "\u52a0\u5de5\u5355\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void validateJob(Boolean isCreat, PrdcJob rcd) {
        if (isCreat != false ? rcd.getId() != null : rcd.getId() == null) {
            throw new PurchaseException("PC0001", "param abnormal");
        }
        PrdcRecipeVO prdcRecipeVO = this.prdcRecipeService.findRecipeVOById(rcd.getRecipeId());
        if (prdcRecipeVO == null) {
            throw new PurchaseException("PC0001", "recipeId\u5339\u914d\u4e0d\u5230\u914d\u65b9");
        }
        if (!prdcRecipeVO.getSkuCode().equals(rcd.getSkuCode())) {
            throw new PurchaseException("PC0001", "\u914d\u65b9\u6210\u54c1skuCode\u4e0e\u4efb\u52a1\u6210\u54c1skuCode\u4e0d\u4e00\u81f4");
        }
        PcsSkuVO skuVO = this.mcPcsSkuService.findByCode(rcd.getSkuCode());
        if (skuVO == null) {
            throw new PurchaseException("PC0001", "skuCode\u5339\u914d\u4e0d\u5230sku");
        }
    }

    @Transactional
    private void createJob(PrdcJob rcd) {
        this.validateJob(true, rcd);
        rcd.setCode("");
        if (NullUtil.isNull((Object)rcd.getPlanStatus())) {
            rcd.setPlanStatus(PrdcJob.WMS_STATUS_RETURN_MODIFY);
        }
        rcd.setCreateTime(DateUtil.getNow());
        if (this.prdcJobMapper.insert(rcd) == 0) {
            throw new PurchaseException("PC0009", "insert data failed!");
        }
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", rcd.getId());
        String code = CodeGenerator.getInstance().generate("PRDC_JOB_CODE", params);
        if (EmptyUtil.isEmpty((String)code)) {
            throw new PurchaseException("PC0006", "\u4efb\u52a1\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
        rcd.setCode(code);
        if (this.prdcJobMapper.updateByPrimaryKey(rcd) == 0) {
            throw new PurchaseException("PC0010", "update data failed!");
        }
    }

    @Transactional
    private void returnModifyJob(PrdcJob rcd) {
        if (rcd.getPlanStatus() != PrdcJob.WMS_STATUS_RETURN_MODIFY) {
            throw new PurchaseException("PC0010", "status abnormal!");
        }
        this.validateJob(false, rcd);
        PrdcJob update = new PrdcJob();
        update.setRecipeId(rcd.getRecipeId());
        update.setId(rcd.getId());
        update.setSkuCode(rcd.getSkuCode());
        update.setWarehouseCode(rcd.getWarehouseCode());
        update.setPriority(rcd.getPriority());
        update.setEstQuantity(rcd.getEstQuantity());
        update.setEstDoneDate(rcd.getEstDoneDate());
        update.setRemark(rcd.getRemark());
        update.setJobType(rcd.getJobType());
        if (this.prdcJobMapper.updateByPrimaryKeySelective(update) == 0) {
            throw new PurchaseException("PC0010", "update data failed!");
        }
    }

    private void saveJobLine(PrdcJob prdcJob, List<PrdcJobLine> rcdList) {
        ArrayList<Integer> nums = new ArrayList<Integer>();
        nums.add(0);
        for (PrdcJobLine line : rcdList) {
            if (line.getCode() == null || line.getCode().equals("")) continue;
            String suffixCode = line.getCode().substring(line.getCode().indexOf(prdcJob.getCode()) + prdcJob.getCode().length());
            nums.add(Integer.valueOf(suffixCode));
        }
        Collections.sort(nums);
        Integer maxNum = (Integer)nums.get(0);
        for (int i = 0; i < rcdList.size(); ++i) {
            PrdcJobLine rcd = rcdList.get(i);
            if (rcd.getId() != null) continue;
            maxNum = maxNum + 1;
            rcd.setCode(PrdcJobLineUtil.getJobLineCode(prdcJob.getCode(), maxNum));
            this.createJobLine(prdcJob, rcd);
        }
    }

    @Transactional
    private void changeJobLine(PrdcJob prdcJob, List<PrdcJobLine> rcdList) {
        ArrayList<Integer> nums = new ArrayList<Integer>();
        PrdcJobLineExample example = new PrdcJobLineExample();
        example.createCriteria().andJobIdEqualTo(prdcJob.getId());
        this.prdcJobLineMapper.deleteByExample(example);
        nums.add(0);
        for (PrdcJobLine line : rcdList) {
            if (line.getCode() == null || line.getCode().equals("")) continue;
            String suffixCode = line.getCode().substring(line.getCode().indexOf(prdcJob.getCode()) + prdcJob.getCode().length());
            nums.add(Integer.valueOf(suffixCode));
        }
        Collections.sort(nums);
        Integer maxNum = (Integer)nums.get(0);
        for (int i = 0; i < rcdList.size(); ++i) {
            PrdcJobLine rcd = rcdList.get(i);
            maxNum = maxNum + 1;
            rcd.setCode(PrdcJobLineUtil.getJobLineCode(prdcJob.getCode(), maxNum));
            this.createJobLine(prdcJob, rcd);
        }
    }

    private void validateJobLine(PrdcJob prdcJob, PrdcJobLine rcd) {
        PcsSkuVO skuVO = this.mcPcsSkuService.findByCode(rcd.getSkuCode());
        if (skuVO == null) {
            throw new PurchaseException("PC0001", "\u8017\u6750skuCode\u5339\u914d\u4e0d\u5230sku");
        }
        if (rcd.getQuantity().compareTo(new Float(0.0f)) <= 0) {
            throw new PurchaseException("PC0001", "\u8017\u6750sku\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (rcd.getSkuCode().equals(prdcJob.getSkuCode())) {
            throw new PurchaseException("PC0001", "\u8017\u6750SKU\u5305\u542b\u6210\u54c1SKU");
        }
    }

    @Transactional
    private void createJobLine(PrdcJob prdcJob, PrdcJobLine rcd) {
        this.validateJobLine(prdcJob, rcd);
        rcd.setJobId(prdcJob.getId());
        if (this.prdcJobLineMapper.insert(rcd) == 0) {
            throw new PurchaseException("PC0009", "insert data failed!");
        }
    }

    @Override
    public List<WhCommandVO> buildPrdcCommands(PrdcJobVO jobVO) {
        if (CollectionUtils.isEmpty(jobVO.getPrdcJobLineVOList())) {
            throw new PurchaseException("PC0001", "\u6784\u9020\u91ca\u653e\u5e93\u5b58\u5931\u8d25,prdcJobLineVOList");
        }
        ArrayList<WhCommandVO> whCommandList = new ArrayList<WhCommandVO>();
        WhCommandVO whCommandJob = new WhCommandVO();
        whCommandJob.setWarehouseCode(jobVO.getWarehouseCode());
        whCommandJob.setPhysicalWarehouseCode(jobVO.getPhysicalWarehouseCode());
        whCommandJob.setReferenceCode(jobVO.getCode());
        if (jobVO.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
            whCommandJob.setInOutType(WhCommandVO.TYPE_PRODUCE_IN);
        } else if (jobVO.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
            whCommandJob.setInOutType(WhCommandVO.TYPE_PRODUCE_OUT);
        }
        ArrayList<WhCommandSkuVO> jobSkuList = new ArrayList<WhCommandSkuVO>();
        WhCommandSkuVO jobSku = new WhCommandSkuVO();
        jobSku.setSkuCode(jobVO.getSkuCode());
        jobSku.setPlanedQuantity(jobVO.getEstQuantity());
        jobSku.setQuantity(jobVO.getFinishedQuantity());
        jobSku.setDamagedQuantity(jobVO.getFinishedDamagedQuantity());
        jobSkuList.add(jobSku);
        whCommandJob.setWhCommandSkuList(jobSkuList);
        whCommandJob.setOperatorId(jobVO.getConfirmOperatorId());
        whCommandList.add(whCommandJob);
        for (PrdcJobLineVO jobLineVO : jobVO.getPrdcJobLineVOList()) {
            WhCommandVO whCommandJobLine = new WhCommandVO();
            ArrayList<WhCommandSkuVO> jobLineSkuList = new ArrayList<WhCommandSkuVO>();
            whCommandJobLine.setWarehouseCode(jobVO.getWarehouseCode());
            whCommandJobLine.setPhysicalWarehouseCode(jobVO.getPhysicalWarehouseCode());
            whCommandJobLine.setReferenceCode(jobLineVO.getCode());
            if (jobVO.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
                whCommandJobLine.setInOutType(WhCommandVO.TYPE_PRODUCE_OUT);
            } else if (jobVO.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
                if (jobLineVO.getMaterialType() == PrdcJobLineVO.MATERIAL_TYPE_AUXILIARY) continue;
                whCommandJobLine.setInOutType(WhCommandVO.TYPE_PRODUCE_IN);
            }
            if (jobLineVO.getQuantity().compareTo(new Float(0.0f)) <= 0) {
                throw new PurchaseException("PC0001", "\u6784\u9020\u4ed3\u5e93\u6307\u4ee4\u5931\u8d25,\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            }
            WhCommandSkuVO jobLineSku = new WhCommandSkuVO();
            jobLineSku.setSkuCode(jobLineVO.getSkuCode());
            if (jobLineVO.getQuantity() != null) {
                jobLineSku.setPlanedQuantity(Integer.valueOf(jobLineVO.getQuantity().intValue()));
            } else {
                jobLineSku.setPlanedQuantity(Integer.valueOf(0));
            }
            if (jobLineVO.getRealQuantity() != null) {
                jobLineSku.setQuantity(Integer.valueOf(jobLineVO.getRealQuantity().intValue()));
            } else {
                jobLineSku.setQuantity(Integer.valueOf(0));
            }
            if (jobLineVO.getDamageQuantity() != null) {
                jobLineSku.setDamagedQuantity(Integer.valueOf(jobLineVO.getDamageQuantity()));
            } else {
                jobLineSku.setDamagedQuantity(Integer.valueOf(0));
            }
            jobLineSkuList.add(jobLineSku);
            whCommandJobLine.setWhCommandSkuList(jobLineSkuList);
            whCommandList.add(whCommandJobLine);
        }
        return whCommandList;
    }

    @Override
    public List<WhReleaseOccupationVO> buildWhRelease(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, Integer occupyType) {
        ArrayList<WhReleaseOccupationVO> releaseList = new ArrayList<WhReleaseOccupationVO>();
        if (CollectionUtils.isEmpty(prdcJobLineList)) {
            throw new PurchaseException("PC0001", "\u6784\u9020\u91ca\u653e\u5e93\u5b58\u7684LIST\u5931\u8d25,opSoPackageSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PrdcJobVO prdcJob_0 = this.findJobVOById(prdcJob.getId());
        if (prdcJob_0.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
            for (PrdcJobLine rdcJobLine : prdcJobLineList) {
                if (rdcJobLine.getQuantity().compareTo(new Float(0.0f)) <= 0) {
                    throw new PurchaseException("PC0001", "\u6784\u9020\u91ca\u653e\u5e93\u5b58\u7684LIST\u5931\u8d25,\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                }
                WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                whReleaseOccupationVO.setOccupyType(occupyType);
                whReleaseOccupationVO.setReferenceCode(rdcJobLine.getCode());
                releaseList.add(whReleaseOccupationVO);
            }
        } else if (prdcJob_0.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
            WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
            whReleaseOccupationVO.setOccupyType(occupyType);
            whReleaseOccupationVO.setReferenceCode(prdcJob_0.getCode());
            releaseList.add(whReleaseOccupationVO);
        } else {
            throw new PurchaseException("PC0001", "error,type abnormal!");
        }
        return releaseList;
    }

    @Override
    public List<WhInvOccupyVO> buildWhOccupy(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, String warehouseCode, Integer occupyType) {
        ArrayList<WhInvOccupyVO> occupyList = new ArrayList<WhInvOccupyVO>();
        if (CollectionUtils.isEmpty(prdcJobLineList)) {
            throw new PurchaseException("PC0001", "param list cannot be null");
        }
        if (prdcJob.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
            for (PrdcJobLine prdcJobLine : prdcJobLineList) {
                if (NumberUtil.isNullOrZero((Number)prdcJobLine.getQuantity())) {
                    throw new PurchaseException("PC0001", "the quantity cannot be 0 or null");
                }
                WhInvOccupyVO whInvOccupy = new WhInvOccupyVO();
                whInvOccupy.setWarehouseCode(warehouseCode);
                whInvOccupy.setOccupyType(occupyType);
                whInvOccupy.setReferenceCode(prdcJobLine.getCode());
                whInvOccupy.setSkuCode(prdcJobLine.getSkuCode());
                whInvOccupy.setQuantity(Integer.valueOf(prdcJobLine.getQuantity().intValue()));
                occupyList.add(whInvOccupy);
            }
        } else if (prdcJob.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
            if (NumberUtil.isNullOrZero((Number)prdcJob.getEstQuantity())) {
                throw new PurchaseException("PC0001", "the quantity cannot be 0 or null!");
            }
            WhInvOccupyVO whInvOccupy = new WhInvOccupyVO();
            whInvOccupy.setWarehouseCode(warehouseCode);
            whInvOccupy.setOccupyType(occupyType);
            whInvOccupy.setReferenceCode(prdcJob.getCode());
            whInvOccupy.setSkuCode(prdcJob.getSkuCode());
            whInvOccupy.setQuantity(prdcJob.getEstQuantity());
            occupyList.add(whInvOccupy);
        } else {
            throw new PurchaseException("PC0001", "error,status abnormal!");
        }
        return occupyList;
    }

    @Override
    public List<Map<String, String>> getWarehouseList(List<String> warehouseCodeList) {
        ArrayList<Map<String, String>> warehouseNameList = new ArrayList<Map<String, String>>();
        for (String warehouseCode : warehouseCodeList) {
            HashMap<String, String> option = new HashMap<String, String>();
            option.put("code", warehouseCode);
            option.put("name", this.getWarehouseName(warehouseCode));
            warehouseNameList.add(option);
        }
        return warehouseNameList;
    }

    @Override
    public String getWarehouseName(String warehouseCode) {
        WhWarehouseVO wh;
        String name = "";
        if (NullUtil.isNotNull((Object)warehouseCode) && NullUtil.isNotNull((Object)(wh = this.sWhInfoService.findWarehouseByCode(warehouseCode))) && EmptyUtil.isNotEmpty((String)wh.getName())) {
            name = wh.getName();
        }
        return name;
    }

    @Override
    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo) {
        return this.sWhWmsPrdcJobTaskService.getPrdcJobMaxTask(vo);
    }

    @Override
    public boolean updatePrdcJobWhenTaskFinish(WhWmsPrdcJobTaskVO vo) {
        List<PrdcJob> prdcJobs;
        ArrayList<String> prdcJobCodes = new ArrayList<String>();
        if (vo != null) {
            prdcJobCodes.add(vo.getPrdcJobCode());
        }
        if ((prdcJobs = this.prdcJobMapper.getPrdcJobProcessingOrPartFinished(prdcJobCodes)) != null && !prdcJobs.isEmpty()) {
            prdcJobCodes.clear();
            for (PrdcJob job : prdcJobs) {
                prdcJobCodes.add(job.getCode());
            }
            List wmsPrdcJobTaskInfos = this.sWhWmsPrdcJobTaskService.getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
            List wmsPrdcJobTaskProcesInfos = this.sWhWmsPrdcJobTaskService.getWmsPrdcJobTaskProcessingInfo(prdcJobCodes);
            List wmsPrdcJobTaskFinishedRealAmount = this.sWhWmsPrdcJobTaskService.getWmsPrdcJobTaskFinishedRealAmount(prdcJobCodes);
            if (wmsPrdcJobTaskInfos != null && !wmsPrdcJobTaskInfos.isEmpty()) {
                for (PrdcJob job : prdcJobs) {
                    Integer finishedGoodsAmount;
                    PrdcJob update;
                    Map<String, Object> info = this.getTaskInfoByPrdcJobCode(wmsPrdcJobTaskInfos, job.getCode());
                    Map<String, Object> processingInfo = this.getTaskInfoByPrdcJobCode(wmsPrdcJobTaskProcesInfos, job.getCode());
                    List<Map<String, Object>> jobLineRealAmounts = this.getJobInfoByPrdcJobCode(wmsPrdcJobTaskFinishedRealAmount, job.getCode());
                    if (info != null && processingInfo == null) {
                        update = new PrdcJob();
                        update.setId(job.getId());
                        if (PrdcJob.JOB_TYPE_ASSEMBLE.equals(job.getJobType())) {
                            finishedGoodsAmount = this.object2Int(info.get("finishedGoodsAmount"));
                            Integer n = this.object2Int(info.get("finishedDefectiveAmount"));
                            Integer amount = this.object2Int(info.get("amount"));
                            if (job.getEstQuantity().compareTo(amount) == 0) {
                                update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_FINISHED);
                                update.setFinishTime(DateUtil.getNow());
                            } else if (job.getEstQuantity().compareTo(amount) > 0 && amount > 0) {
                                update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_PARTFINISHED);
                            } else {
                                update.setPlanStatus(PrdcJob.WMS_STATUS_RETURN_MODIFY);
                            }
                            update.setFinishedQuantity(finishedGoodsAmount);
                            update.setFinishedDamagedQuantity(n);
                            update.setProcessingAmount(0);
                        } else {
                            Integer amount = this.object2Int(info.get("amount"));
                            if (job.getEstQuantity().compareTo(amount) == 0) {
                                update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_FINISHED);
                                update.setFinishTime(DateUtil.getNow());
                            } else if (job.getEstQuantity().compareTo(amount) > 0 && amount > 0) {
                                update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_PARTFINISHED);
                            } else {
                                update.setPlanStatus(PrdcJob.WMS_STATUS_RETURN_MODIFY);
                            }
                            update.setFinishedQuantity(amount);
                            update.setProcessingAmount(0);
                        }
                        this.updatePrdcJobCheckCancle(update);
                        for (Map map : jobLineRealAmounts) {
                            PrdcJobLine prdcJobLine = this.makePrdcJobLine(map, update);
                            if (prdcJobLine == null) continue;
                            this.prdcJobLineMapper.updateByExampleSelective(prdcJobLine, this.makePrdcJobLineExample(prdcJobLine));
                        }
                        continue;
                    }
                    if (info == null || processingInfo == null) continue;
                    update = new PrdcJob();
                    update.setId(job.getId());
                    update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_PROCESSING);
                    if (PrdcJob.JOB_TYPE_ASSEMBLE.equals(job.getJobType())) {
                        finishedGoodsAmount = this.object2Int(info.get("finishedGoodsAmount"));
                        Integer n = this.object2Int(info.get("finishedDefectiveAmount"));
                        update.setFinishedQuantity(finishedGoodsAmount);
                        update.setFinishedDamagedQuantity(n);
                    } else {
                        finishedGoodsAmount = this.object2Int(info.get("finishedGoodsAmount"));
                        update.setFinishedQuantity(finishedGoodsAmount);
                    }
                    Integer processingAmount = this.object2Int(processingInfo.get("amount"));
                    update.setProcessingAmount(processingAmount);
                    this.updatePrdcJobCheckCancle(update);
                }
            }
        }
        return true;
    }

    private void updatePrdcJobCheckCancle(PrdcJob update) {
        PrdcJobExample example = new PrdcJobExample();
        example.createCriteria().andIdEqualTo(update.getId()).andPlanStatusNotEqualTo(PrdcJob.PLAN_STATUS_CANCEL);
        int size = this.prdcJobMapper.updateByExampleSelective(update, example);
        if (size == 0) {
            update.setPlanStatus(null);
            this.prdcJobMapper.updateByPrimaryKeySelective(update);
        }
    }

    private PrdcJobLineExample makePrdcJobLineExample(PrdcJobLine prdcJobLine) {
        if (prdcJobLine == null) {
            return null;
        }
        PrdcJobLineExample exam = new PrdcJobLineExample();
        PrdcJobLineExample.Criteria crit = exam.createCriteria();
        crit.andSkuCodeEqualTo(prdcJobLine.getSkuCode());
        crit.andJobIdEqualTo(prdcJobLine.getJobId());
        return exam;
    }

    private PrdcJobLine makePrdcJobLine(Map<String, Object> jobLineRealAmount, PrdcJob update) {
        if (jobLineRealAmount == null) {
            return null;
        }
        PrdcJobLine prdcJobLine = new PrdcJobLine();
        prdcJobLine.setJobId(update.getId());
        prdcJobLine.setSkuCode(String.valueOf(jobLineRealAmount.get("skuCode")));
        prdcJobLine.setRealQuantity(Float.valueOf(String.valueOf(jobLineRealAmount.get("realAmount"))));
        prdcJobLine.setDamageQuantity(Integer.valueOf(String.valueOf(jobLineRealAmount.get("realDefectiveAmount"))));
        return prdcJobLine;
    }

    private Integer object2Int(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.parseInt(obj.toString());
    }

    private Map<String, Object> getTaskInfoByPrdcJobCode(List<Map<String, Object>> infos, String prdcJobCode) {
        if (infos != null && !infos.isEmpty()) {
            for (Map<String, Object> info : infos) {
                Object code = info.get("prdcJobCode");
                if (!prdcJobCode.equals(code)) continue;
                return info;
            }
        }
        return null;
    }

    private List<Map<String, Object>> getJobInfoByPrdcJobCode(List<Map<String, Object>> jobFinishedRealAmount, String prdcJobCode) {
        ArrayList<Map<String, Object>> map = new ArrayList<Map<String, Object>>();
        if (jobFinishedRealAmount != null && !jobFinishedRealAmount.isEmpty()) {
            for (Map<String, Object> info : jobFinishedRealAmount) {
                Object code = info.get("prdcJobCode");
                if (!prdcJobCode.equals(code)) continue;
                map.add(info);
            }
            return map;
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getWmsPrdcJobTaskFinishedInfo(List<String> prdcJobCodes) {
        return this.sWhWmsPrdcJobTaskService.getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
    }

    @Override
    public List<PrdcJob> getPrdcJobProcessingOrPartFinished(List<String> codes) {
        return this.prdcJobMapper.getPrdcJobProcessingOrPartFinished(codes);
    }

    @Override
    public List<WhReleaseOccupationVO> buildWhRelease(List<PrdcJobLineVO> prdcJobLineVOList, Integer occupyType) {
        ArrayList<WhReleaseOccupationVO> releaseList = new ArrayList<WhReleaseOccupationVO>();
        if (CollectionUtils.isEmpty(prdcJobLineVOList)) {
            throw new PurchaseException("PC0001", "\u6784\u9020\u91ca\u653e\u5e93\u5b58\u7684LIST\u5931\u8d25,opSoPackageSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PrdcJobLineVO rdcJobLineVO : prdcJobLineVOList) {
            if (rdcJobLineVO.getQuantity().compareTo(Float.valueOf(0.0f)) <= 0) {
                throw new PurchaseException("PC0001", "\u6784\u9020\u91ca\u653e\u5e93\u5b58\u7684LIST\u5931\u8d25,\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            }
            WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
            whReleaseOccupationVO.setOccupyType(occupyType);
            whReleaseOccupationVO.setReferenceCode(rdcJobLineVO.getCode());
            releaseList.add(whReleaseOccupationVO);
        }
        return releaseList;
    }

    @Override
    public List<WhInvOccupyVO> buildWhOccupy(List<PrdcJobLineVO> prdcJobLineVOList, String warehouseCode, Integer occupyType) {
        ArrayList<WhInvOccupyVO> occupyList = new ArrayList<WhInvOccupyVO>();
        if (CollectionUtils.isEmpty(prdcJobLineVOList)) {
            throw new PurchaseException("PC0001", "\u6784\u9020\u5360\u7528\u5e93\u5b58\u7684LIST\u5931\u8d25,opSoPackageSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PrdcJobLineVO prdcJobLineVO : prdcJobLineVOList) {
            if (prdcJobLineVO.getQuantity().compareTo(Float.valueOf(0.0f)) <= 0) {
                throw new PurchaseException("PC0001", "\u6784\u9020\u5360\u7528\u5e93\u5b58\u7684LIST\u5931\u8d25,\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            }
            WhInvOccupyVO whInvOccupy = new WhInvOccupyVO();
            whInvOccupy.setWarehouseCode(warehouseCode);
            whInvOccupy.setOccupyType(occupyType);
            whInvOccupy.setReferenceCode(prdcJobLineVO.getCode());
            whInvOccupy.setSkuCode(prdcJobLineVO.getSkuCode());
            whInvOccupy.setQuantity(Integer.valueOf(Double.valueOf(Math.ceil(prdcJobLineVO.getQuantity().floatValue())).intValue()));
            occupyList.add(whInvOccupy);
        }
        return occupyList;
    }

    @Override
    @Transactional
    public Boolean checkOccupyAndUpdate(PrdcJobVO jobVO, List<WhInvOccupyVO> whInvOccupyList) {
        if (jobVO == null) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        PrdcJob prdcJob = (PrdcJob)BeanUtil.buildFrom((Object)jobVO, PrdcJob.class);
        int update = this.prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0) {
            throw new PurchaseException("PC0010", "\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25");
        }
        ServiceResp serviceResp = this.sStockService.occupy(this.convertWhInvOccupy2DTO(whInvOccupyList));
        if (serviceResp.isFailure()) {
            throw new PurchaseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        return true;
    }

    @Override
    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond) {
        return this.prdcJobMapper.findExportJobVOByCond(cond);
    }

    @Override
    public List<PrdcJob> findSkuReportJobVO() {
        return this.prdcJobMapper.findSkuReportJobVO();
    }

    private List<SStockOccupyDTO> convertWhInvOccupy2DTO(List<WhInvOccupyVO> whInvOccupyList) {
        ArrayList<SStockOccupyDTO> dtoList = new ArrayList<SStockOccupyDTO>();
        if (EmptyUtil.isNotEmpty(whInvOccupyList)) {
            for (WhInvOccupyVO whInvOccupy : whInvOccupyList) {
                dtoList.add(this.convertWhInvOccupy2DTO(whInvOccupy));
            }
        }
        return dtoList;
    }

    private SStockOccupyDTO convertWhInvOccupy2DTO(WhInvOccupyVO whInvOccupy) {
        SStockOccupyDTO sStockOccupyDTO = new SStockOccupyDTO();
        BeanUtils.copyProperties((Object)whInvOccupy, (Object)sStockOccupyDTO);
        sStockOccupyDTO.setOccupyTime(new Date());
        sStockOccupyDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)whInvOccupy.getOccupyType()));
        return sStockOccupyDTO;
    }

    @Override
    public boolean isSplitBySkuCode(String skuCode) {
        return this.prdcJobMapper.isSplitBySkuCode(skuCode) > 0;
    }
}

