/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCustomsInfoVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCustomBckCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCustomBckMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCustomBck;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCustomBckService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCustomBckVO;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pcsSkuCustomBckService")
public class PcsSkuCustomBckServiceImpl
implements PcsSkuCustomBckService {
    @Autowired
    private PcsSkuCustomBckMapper pcsSkuCustomBckMapper;
    @Autowired
    private McPcsSkuService mcPcsSkuService;

    @Override
    public Pagination<PcsSkuCustomBckVO> findByCond(PcsSkuCustomBckCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        Integer count = this.pcsSkuCustomBckMapper.countByCond(cond);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero((Number)count)) {
            return null;
        }
        page.setResultList(this.pcsSkuCustomBckMapper.findByCond(cond));
        return page;
    }

    @Override
    public Integer countByCond(PcsSkuCustomBckCond cond) {
        return this.pcsSkuCustomBckMapper.countByCond(cond);
    }

    @Override
    public Integer approveOrRefuseSkuCustomBck(Integer id, Integer status, String customBckCode, String remark) {
        Integer res = 0;
        PcsSkuCustomBck pcsSkuCustomBck = new PcsSkuCustomBck();
        pcsSkuCustomBck.setId(id);
        pcsSkuCustomBck.setStatus(status);
        boolean flag = false;
        if (status == 1) {
            pcsSkuCustomBck.setCustomsNumber(customBckCode);
            pcsSkuCustomBck.setRemark(remark);
            flag = true;
        } else {
            pcsSkuCustomBck.setRemark(remark);
        }
        res = this.pcsSkuCustomBckMapper.updateByPrimaryKeySelective(pcsSkuCustomBck);
        if (flag) {
            PcsSkuCustomBck customBck = this.pcsSkuCustomBckMapper.selectByPrimaryKey(id);
            PcsSkuCustomsInfoVO pcsSkuCustomsInfo = new PcsSkuCustomsInfoVO();
            pcsSkuCustomsInfo.setSkuCode(customBck.getSkuCode());
            pcsSkuCustomsInfo.setCustomsRecordNumber(customBckCode);
            this.mcPcsSkuService.updateSkuCustomInfo(pcsSkuCustomsInfo);
        }
        return res;
    }

    @Override
    public Integer insertWhenNotExist(PcsSkuCustomBck pcsSkuCustomBck) {
        PcsSkuCustomBckCond cond = new PcsSkuCustomBckCond();
        cond.setSkuCode(pcsSkuCustomBck.getSkuCode());
        if (CollectionUtils.isEmpty(this.pcsSkuCustomBckMapper.findByCond(cond))) {
            return this.pcsSkuCustomBckMapper.insert(pcsSkuCustomBck);
        }
        return 0;
    }
}

