/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.pegasus.integration.PegasusIntegrationFacade;
import com.thebeastshop.pegasus.service.purchase.cond.SkuCerCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCertificateFieldMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCertificateMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCertificateMpCodeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCertificateSpecialMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificate;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificateExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificateFieldExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificateMpCode;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificateMpCodeExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificateSpecial;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificateSpecialExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTplService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCertificateService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldTypesetVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCerInfoExcelVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCertificateFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCertificateVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintCerSpecialVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintCerVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintSkuCerFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintSkuCerVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsSkuCertificateService")
public class PcsSkuCertificateServiceImpl
implements PcsSkuCertificateService {
    @Autowired
    private PcsSkuCertificateMapper pcsSkuCertificateMapper;
    @Autowired
    private PcsSkuCertificateFieldMapper pcsSkuCertificateFieldMapper;
    @Autowired
    private PcsSkuCertificateSpecialMapper pcsSkuCertificateSpecialMapper;
    @Autowired
    private PcsCertificateTplService pcsCertificateTplService;
    @Autowired
    private PcsSkuCertificateMpCodeMapper pcsSkuCertificateMpCodeMapper;

    @Override
    public List<PcsSkuCertificateVO> findSkuCerByCond(SkuCerCond cond) {
        return this.pcsSkuCertificateMapper.findSkuCerByCond(cond);
    }

    @Override
    public List<PcsSkuCertificateVO> findRecipeCerVOByCond(SkuCerCond cond) {
        return this.pcsSkuCertificateMapper.findRecipeCerVOByCond(cond);
    }

    @Override
    public List<PcsSkuCerInfoExcelVO> findSkuCerExportInfoByCond(SkuCerCond cond) {
        return this.pcsSkuCertificateMapper.findSkuCerExportInfoByCond(cond);
    }

    @Override
    public PcsSkuCertificateVO findBySkuCode(String skuCode) {
        return this.findBySkuCode(skuCode, true);
    }

    @Override
    public PcsSkuCertificateVO findBySkuCode(String skuCode, boolean cascade) {
        PcsSkuCertificateVO cerVO = this.pcsSkuCertificateMapper.findBySkuCode(skuCode);
        if (NullUtil.isNull((Object)cerVO) || !cascade) {
            return cerVO;
        }
        List<PcsSkuCertificateFieldVO> fieldlist = this.pcsSkuCertificateFieldMapper.findByCerId(cerVO.getId());
        cerVO.setFieldList(fieldlist);
        if (EmptyUtil.isNotEmpty(fieldlist)) {
            PcsCertificateTplVO tplVO = this.pcsCertificateTplService.findById(cerVO.getCerTplId(), true);
            this.pcsCertificateTplService.fullCerTplDefaultValue(tplVO, skuCode);
            block0: for (PcsSkuCertificateFieldVO field : fieldlist) {
                for (PcsCertificateTplFieldVO tplField : tplVO.getTplFieldVOList()) {
                    if (field.getCerTplFieldId().equals(tplField.getId())) {
                        field.setTplFieldVO(tplField);
                        if (!PcsCertificateTplFieldVO.WRITE_TYPE_SKUINFO.equals(tplField.getWriteType()) || !EmptyUtil.isEmpty((String)field.getValue())) continue block0;
                        field.setValue(tplField.getDefaultValue());
                        continue block0;
                    }
                    if (EmptyUtil.isNotEmpty((String)cerVO.getCertificateSize()) && CollectionUtils.isNotEmpty(tplField.getFieldTypesetList())) {
                        for (PcsCertificateTplFieldTypesetVO tplFieldTypesetVO : tplField.getFieldTypesetList()) {
                            if (!cerVO.getCertificateSize().equals(tplFieldTypesetVO.getCerSize())) continue;
                            tplField.setCurrFieldTypeset(tplFieldTypesetVO);
                            break;
                        }
                    }
                    if (!EmptyUtil.isEmpty((Object)tplField.getCurrFieldTypeset()) || !CollectionUtils.isNotEmpty(tplField.getFieldTypesetList())) continue;
                    tplField.setCurrFieldTypeset(tplField.getFieldTypesetList().get(0));
                }
            }
        }
        cerVO.setSpecialList(this.findSpecialByCerId(cerVO.getId()));
        return cerVO;
    }

    @Override
    public List<PcsSkuCertificateVO> findBySkuCodes(List<String> skuCodeList, boolean cascade) {
        if (CollectionUtils.isEmpty(skuCodeList)) {
            return Collections.emptyList();
        }
        List<PcsSkuCertificateVO> cerList = this.pcsSkuCertificateMapper.findBySkuCodes(skuCodeList);
        if (EmptyUtil.isEmpty(cerList) || !cascade) {
            return cerList;
        }
        ArrayList<Long> cerIds = new ArrayList<Long>();
        ArrayList<Long> cerTplIds = new ArrayList<Long>();
        for (PcsSkuCertificateVO cerVO : cerList) {
            cerIds.add(cerVO.getId());
            cerTplIds.add(cerVO.getCerTplId());
        }
        List<PcsSkuCertificateFieldVO> cerFieldList = this.pcsSkuCertificateFieldMapper.findByCerIds(cerIds);
        List<PcsCertificateTplVO> tplList = this.pcsCertificateTplService.findByIds(cerTplIds, true);
        HashMap<Long, PcsCertificateTplFieldVO> tplFieldMap = new HashMap<Long, PcsCertificateTplFieldVO>();
        if (EmptyUtil.isNotEmpty(tplList)) {
            for (PcsCertificateTplVO tplVO : tplList) {
                if (!EmptyUtil.isNotEmpty(tplVO.getTplFieldVOList())) continue;
                for (PcsCertificateTplFieldVO tplFieldVO : tplVO.getTplFieldVOList()) {
                    tplFieldMap.put(tplFieldVO.getId(), tplFieldVO);
                }
            }
        }
        List<PcsSkuCertificateSpecial> specialList = this.findSpecialByCerIds(cerIds);
        HashMap<Long, ArrayList<PcsSkuCertificateSpecial>> cerSpecialListMap = new HashMap<Long, ArrayList<PcsSkuCertificateSpecial>>();
        if (EmptyUtil.isNotEmpty(specialList)) {
            for (PcsSkuCertificateSpecial special : specialList) {
                ArrayList<PcsSkuCertificateSpecial> tmpList = (ArrayList<PcsSkuCertificateSpecial>)cerSpecialListMap.get(special.getCerId());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<PcsSkuCertificateSpecial>();
                    cerSpecialListMap.put(special.getCerId(), tmpList);
                }
                tmpList.add(special);
            }
        }
        if (EmptyUtil.isNotEmpty(cerFieldList)) {
            HashMap cerFieldMap = new HashMap();
            for (PcsSkuCertificateFieldVO cerField : cerFieldList) {
                Long key = cerField.getCerId();
                ArrayList<PcsSkuCertificateFieldVO> tmpList = (ArrayList<PcsSkuCertificateFieldVO>)cerFieldMap.get(key);
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<PcsSkuCertificateFieldVO>();
                    cerFieldMap.put(key, tmpList);
                }
                cerField.setTplFieldVO((PcsCertificateTplFieldVO)tplFieldMap.get(cerField.getCerTplFieldId()));
                tmpList.add(cerField);
            }
            for (PcsSkuCertificateVO cerVO : cerList) {
                cerVO.setFieldList((List)cerFieldMap.get(cerVO.getId()));
                cerVO.setSpecialList((List)cerSpecialListMap.get(cerVO.getId()));
            }
        }
        return cerList;
    }

    @Override
    public List<PrintSkuCerVO> getPrintCerBySkuCodeBarCode(PrintCerVO cond) {
        if (EmptyUtil.isEmpty((Object)cond) || EmptyUtil.isEmpty(cond.getSkuInfos())) {
            return new ArrayList<PrintSkuCerVO>();
        }
        List<PrintSkuCerVO> skuCerList = cond.getSkuInfos();
        ArrayList<String> skuCodes = new ArrayList<String>();
        for (PrintSkuCerVO sb : skuCerList) {
            skuCodes.add(sb.getSkuCode());
        }
        Map<String, String> cerMpCodeMap = this.findSkuCerMpCodeMap(skuCodes);
        List<PcsSkuCertificateVO> cerList = this.findBySkuCodes(skuCodes, true);
        if (EmptyUtil.isEmpty(cerList)) {
            return new ArrayList<PrintSkuCerVO>();
        }
        ArrayList<PrintSkuCerVO> printList = new ArrayList<PrintSkuCerVO>();
        block1: for (PrintSkuCerVO printSkuCer : skuCerList) {
            for (PcsSkuCertificateVO cerVO : cerList) {
                if (!cerVO.getSkuCode().equals(printSkuCer.getSkuCode())) continue;
                cerVO.setBarCode(printSkuCer.getBarCode());
                printSkuCer.setSubmited(this.isCerSubmited(cerVO));
                printSkuCer.setSimple(this.isSimpleCer(cerVO));
                printSkuCer.setCerSize(cerVO.getCertificateSize());
                printSkuCer.setImgUrl(cerVO.getImgUrl());
                printSkuCer.setFieldList(this.buildPrintSkuCerFields(cerVO, printSkuCer));
                printSkuCer.setSpecialList(this.buildPrintCerSpecials(cerVO));
                printSkuCer.setPrintMpCode(PcsSkuCertificateVO.PRINT_MP_CODE_YES.equals(cerVO.getPrintMpCode()));
                printSkuCer.setMpCodeUrl(cerMpCodeMap.get(cerVO.getSkuCode()));
                printList.add(printSkuCer);
                continue block1;
            }
        }
        return printList;
    }

    private boolean isCerSubmited(PcsSkuCertificateVO cerVO) {
        return PcsSkuCertificateVO.SUBMIT_STATUS_SUBMITTED.equals(cerVO.getIsSubmit());
    }

    private boolean isSimpleCer(PcsSkuCertificateVO cerVO) {
        return PcsSkuCertificateVO.CER_TYPE_SIMPLE.equals(cerVO.getCerType());
    }

    @Override
    public List<String> findSkuCodeNeedAutoSubmit() {
        return this.pcsSkuCertificateMapper.findSkuCodeNeedAutoSubmit();
    }

    private List<PrintCerSpecialVO> buildPrintCerSpecials(PcsSkuCertificateVO cerVO) {
        if (EmptyUtil.isEmpty(cerVO.getSpecialList())) {
            return new ArrayList<PrintCerSpecialVO>();
        }
        ArrayList<PrintCerSpecialVO> printSpecialList = new ArrayList<PrintCerSpecialVO>();
        for (PcsSkuCertificateSpecial special : cerVO.getSpecialList()) {
            PrintCerSpecialVO printSpecial = new PrintCerSpecialVO();
            printSpecial.setSpecialCode(special.getSpecialCode());
            printSpecial.setSpecialType(special.getSpecialType());
            printSpecial.setSpecialValue(special.getSpecialValue());
            printSpecialList.add(printSpecial);
        }
        return printSpecialList;
    }

    private List<PrintSkuCerFieldVO> buildPrintSkuCerFields(PcsSkuCertificateVO cerVO, PrintSkuCerVO printSkuCer) {
        if (EmptyUtil.isEmpty(cerVO.getFieldList())) {
            return new ArrayList<PrintSkuCerFieldVO>();
        }
        ArrayList<PrintSkuCerFieldVO> fieldList = new ArrayList<PrintSkuCerFieldVO>();
        PrintSkuCerFieldVO printField = null;
        PcsCertificateTplFieldVO tplField = null;
        block0: for (PcsSkuCertificateFieldVO fieldVO : cerVO.getFieldList()) {
            List<PcsCertificateTplFieldTypesetVO> typesetList;
            printField = new PrintSkuCerFieldVO();
            tplField = fieldVO.getTplFieldVO();
            if (EmptyUtil.isEmpty((Object)tplField)) continue;
            printField.setName(tplField.getName());
            printField.setFontSize(tplField.getFontSize());
            printField.setNeedPrintName(PcsCertificateTplFieldVO.PRINT_YES.equals(tplField.getIsPrint()));
            printField.setSortOrder(fieldVO.getSortOrder());
            printField.setPosition(tplField.getPosition());
            if (PcsCertificateTplFieldVO.WRITE_TYPE_INPUT.equals(tplField.getWriteType())) {
                printField.setValue(fieldVO.getValue());
            } else if (EmptyUtil.isEmpty((String)cerVO.getBarCode()) && PcsCertificateTplFieldVO.WRITE_TYPE_SYSTEM.equals(tplField.getWriteType())) {
                printField.setValue("\u7cfb\u7edf\u83b7\u53d6");
            } else if (PcsCertificateTplFieldVO.WRITE_TYPE_SYSTEM.equals(tplField.getWriteType()) && "\u751f\u4ea7\u65e5\u671f".equals(tplField.getName())) {
                if (EmptyUtil.isNotEmpty((String)printSkuCer.getProdDate())) {
                    printField.setValue(printSkuCer.getProdDate());
                } else if (!PcsSkuCertificateVO.NEED_PROD_DATE_YES.equals(cerVO.getNeedProdDate()) || EmptyUtil.isEmpty((String)printSkuCer.getProdDate())) {
                    continue;
                }
            } else if (PcsCertificateTplFieldVO.WRITE_TYPE_SKUINFO.equals(tplField.getWriteType()) && EmptyUtil.isNotEmpty((String)fieldVO.getValue())) {
                printField.setValue(fieldVO.getValue());
            } else {
                String value = this.pcsCertificateTplService.getFieldDicValue(tplField.getFieldDicId(), cerVO.getSkuCode(), cerVO.getBarCode());
                printField.setValue(value);
            }
            if (!CollectionUtils.isNotEmpty(typesetList = tplField.getFieldTypesetList())) continue;
            for (PcsCertificateTplFieldTypesetVO typeset : typesetList) {
                if (!typeset.getCerSize().equals(cerVO.getCertificateSize())) continue;
                printField.setTypeset(typeset.getShowType().toString());
                fieldList.add(printField);
                continue block0;
            }
        }
        return fieldList;
    }

    @Override
    @Transactional
    public void save(PcsSkuCertificateVO cerVO) {
        if (NullUtil.isNull((Object)cerVO.getPrintMpCode())) {
            cerVO.setPrintMpCode(PcsSkuCertificateVO.PRINT_MP_CODE_NO);
        }
        this.pcsSkuCertificateMapper.insert(cerVO);
        if (EmptyUtil.isNotEmpty(cerVO.getFieldList())) {
            for (PcsSkuCertificateFieldVO fieldVO : cerVO.getFieldList()) {
                fieldVO.setCerId(cerVO.getId());
                this.pcsSkuCertificateFieldMapper.insert(fieldVO);
            }
        }
        if (EmptyUtil.isNotEmpty(cerVO.getSpecialList())) {
            for (PcsSkuCertificateSpecial special : cerVO.getSpecialList()) {
                special.setCerId(cerVO.getId());
                this.pcsSkuCertificateSpecialMapper.insert(special);
            }
        }
    }

    @Override
    @Transactional
    public void update(PcsSkuCertificateVO cerVO) {
        this.deleteCerFieldByCerId(cerVO.getId());
        this.deleteCerSpecialByCerId(cerVO.getId());
        this.pcsSkuCertificateMapper.updateByPrimaryKey(cerVO);
        if (EmptyUtil.isNotEmpty(cerVO.getFieldList())) {
            for (PcsSkuCertificateFieldVO fieldVO : cerVO.getFieldList()) {
                fieldVO.setCerId(cerVO.getId());
                this.pcsSkuCertificateFieldMapper.insert(fieldVO);
            }
        }
        if (EmptyUtil.isNotEmpty(cerVO.getSpecialList())) {
            for (PcsSkuCertificateSpecial special : cerVO.getSpecialList()) {
                special.setCerId(cerVO.getId());
                this.pcsSkuCertificateSpecialMapper.insert(special);
            }
        }
    }

    @Override
    @Transactional
    public void saveOrUpdate(PcsSkuCertificateVO cerVO) {
        if (NullUtil.isNull((Object)cerVO.getId())) {
            this.save(cerVO);
        } else {
            this.update(cerVO);
        }
    }

    @Override
    @Transactional
    public boolean saveOrUpdateSkuCer(PcsSkuCertificateVO cerVO) {
        int reslut = 0;
        if (NullUtil.isNull((Object)cerVO.getId())) {
            if (NullUtil.isNotNull((Object)cerVO.getPrintMpCode())) {
                cerVO.setPrintMpCode(PcsSkuCertificateVO.PRINT_MP_CODE_NO);
            }
            reslut = this.pcsSkuCertificateMapper.insert(cerVO);
        } else {
            reslut = this.pcsSkuCertificateMapper.updateByPrimaryKeySelective(cerVO);
        }
        return reslut > 0;
    }

    @Override
    @Transactional
    public void saveOrUpdate(List<PcsSkuCertificateVO> cerList) {
        if (EmptyUtil.isNotEmpty(cerList)) {
            for (PcsSkuCertificateVO cerVO : cerList) {
                this.saveOrUpdate(cerVO);
            }
        }
    }

    @Override
    @Transactional
    public void saveOrUpdateStatus(PcsSkuCertificateVO cerVO) {
        if (NullUtil.isNull((Object)cerVO.getId())) {
            if (NullUtil.isNotNull((Object)cerVO.getPrintMpCode())) {
                cerVO.setPrintMpCode(PcsSkuCertificateVO.PRINT_MP_CODE_NO);
            }
            this.pcsSkuCertificateMapper.insert(cerVO);
        } else {
            this.pcsSkuCertificateMapper.updateByPrimaryKey(cerVO);
        }
    }

    private int deleteCerFieldByCerId(Long cerId) {
        PcsSkuCertificateFieldExample example = new PcsSkuCertificateFieldExample();
        example.createCriteria().andCerIdEqualTo(cerId);
        return this.pcsSkuCertificateFieldMapper.deleteByExample(example);
    }

    private int deleteCerSpecialByCerId(Long cerId) {
        PcsSkuCertificateSpecialExample example = new PcsSkuCertificateSpecialExample();
        example.createCriteria().andCerIdEqualTo(cerId);
        return this.pcsSkuCertificateSpecialMapper.deleteByExample(example);
    }

    private List<PcsSkuCertificateSpecial> findSpecialByCerId(Long cerId) {
        PcsSkuCertificateSpecialExample example = new PcsSkuCertificateSpecialExample();
        example.createCriteria().andCerIdEqualTo(cerId);
        return this.pcsSkuCertificateSpecialMapper.selectByExample(example);
    }

    private List<PcsSkuCertificateSpecial> findSpecialByCerIds(List<Long> cerIds) {
        PcsSkuCertificateSpecialExample example = new PcsSkuCertificateSpecialExample();
        example.createCriteria().andCerIdIn((List)cerIds);
        return this.pcsSkuCertificateSpecialMapper.selectByExample(example);
    }

    @Override
    @Transactional
    public boolean saveSkuCerMpCode(String skuCode, String mpCodeUrl) {
        PcsSkuCertificateMpCode record = new PcsSkuCertificateMpCode();
        record.setSkuCode(skuCode);
        record.setMpCodeUrl(mpCodeUrl);
        record.setCreateTime(DateUtil.getNow());
        this.pcsSkuCertificateMpCodeMapper.insert(record);
        return true;
    }

    @Override
    @Transactional
    public boolean batchSaveSkuCerMpCode(Map<String, String> skuCode_mpCodeUrl) {
        if (EmptyUtil.isNotEmpty(skuCode_mpCodeUrl)) {
            ArrayList<PcsSkuCertificateMpCode> recordList = new ArrayList<PcsSkuCertificateMpCode>();
            for (Map.Entry<String, String> entry : skuCode_mpCodeUrl.entrySet()) {
                PcsSkuCertificateMpCode record = new PcsSkuCertificateMpCode();
                record.setSkuCode(entry.getKey());
                record.setMpCodeUrl(entry.getValue());
                record.setCreateTime(DateUtil.getNow());
                recordList.add(record);
            }
            this.pcsSkuCertificateMpCodeMapper.batchInsert(recordList);
        }
        return true;
    }

    @Override
    public String findSkuCerMpCode(String skuCode) {
        PcsSkuCertificateMpCodeExample example = new PcsSkuCertificateMpCodeExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        List<PcsSkuCertificateMpCode> list = this.pcsSkuCertificateMpCodeMapper.selectByExample(example);
        if (EmptyUtil.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1).getMpCodeUrl();
    }

    @Override
    public List<String> findSkuCerWithSalesPriceField(List<String> skuCodes) {
        if (EmptyUtil.isEmpty(skuCodes)) {
            return new ArrayList<String>();
        }
        return this.pcsSkuCertificateMapper.findSkuCerWithSalesPriceField(skuCodes);
    }

    @Override
    public List<String> findSkuSalesPriceChangePreDay() {
        return this.pcsSkuCertificateMapper.findSkuSalesPriceChangePreDay();
    }

    @Override
    public Map<String, String> findSkuCerMpCodeMap(List<String> skuCodes) {
        HashMap<String, String> map = new HashMap<String, String>();
        PcsSkuCertificateMpCodeExample example = new PcsSkuCertificateMpCodeExample();
        example.createCriteria().andSkuCodeIn((List)skuCodes);
        List<PcsSkuCertificateMpCode> list = this.pcsSkuCertificateMpCodeMapper.selectByExample(example);
        if (EmptyUtil.isNotEmpty(list)) {
            for (PcsSkuCertificateMpCode mpCode : list) {
                map.put(mpCode.getSkuCode(), mpCode.getMpCodeUrl());
            }
        }
        return map;
    }

    @Override
    public String getOrCreateSkuCerMpCode(String skuCode) {
        String mpCodeUrl = this.findSkuCerMpCode(skuCode);
        if (EmptyUtil.isEmpty((String)mpCodeUrl) && EmptyUtil.isNotEmpty((String)(mpCodeUrl = this.createwxaqrcode(skuCode)))) {
            this.saveSkuCerMpCode(skuCode, mpCodeUrl);
        }
        return mpCodeUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createwxaqrcode(String skuCode) {
        String accessToken = this.getAppletToken();
        if (EmptyUtil.isEmpty((String)accessToken)) {
            throw new PurchaseException("PC0001", "\u83b7\u53d6Token\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient HttpClient = httpClientBuilder.build();
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=" + accessToken);
        try {
            String path = PropConstants.getProperties((String)"SCM_CER_MP_CODE_PATH");
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("path", (Object)String.format(path, skuCode));
            jsonObj.put("width", (Object)3400);
            httpPost.setEntity((HttpEntity)new StringEntity(jsonObj.toString(), "UTF-8"));
            CloseableHttpResponse httpResponse = HttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            if (NullUtil.isNotNull((Object)entity)) {
                String contentType = entity.getContentType().getValue();
                if (contentType.contains("application/json")) {
                    throw new PurchaseException(EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
                }
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                String key = PegasusIntegrationFacade.getInstance().getOssUtilBean().uploadFile(null, "mp_code_" + skuCode, contentType.split("/")[1], (InputStream)inputStream);
                String pathPrefix = PegasusIntegrationFacade.getInstance().getOssUtilBean().getBaseUrl();
                String string = pathPrefix + key;
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                HttpClient.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppletToken() {
        String tokenUrl = PropConstants.getProperties((String)"SCM_APPLET_TOKEN_URL");
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient HttpClient = httpClientBuilder.build();
        HttpGet httpGet = new HttpGet(tokenUrl);
        try {
            HttpEntity entity;
            CloseableHttpResponse httpResponse = HttpClient.execute((HttpUriRequest)httpGet);
            if (httpResponse.getStatusLine().getStatusCode() == HttpStatus.OK.value() && NullUtil.isNotNull((Object)(entity = httpResponse.getEntity()))) {
                String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                HttpClient.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public Integer insertOrUpdateByExampleSelective(PcsSkuCertificate record, PcsSkuCertificateExample example) {
        List<PcsSkuCertificate> list = this.pcsSkuCertificateMapper.selectByExample(example);
        Integer res = CollectionUtils.isNotEmpty(list) ? Integer.valueOf(this.pcsSkuCertificateMapper.updateByExampleSelective(record, example)) : Integer.valueOf(this.pcsSkuCertificateMapper.insert(record));
        return res;
    }
}

