/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuAutoApproveBgmCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuFinanceAutoApproveRuleCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuAutoApproveBgmMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuAutoApproveBgm;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuAutoApproveBgmExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuAutoApproveRuleService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuAutoApproveBgmVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuFinanceAutoApproveRule;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuFinanceAutoApproveRuleVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommTypeValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsSkuAutoApproveRuleService")
public class PcsSkuAutoApproveRuleServiceImpl
implements PcsSkuAutoApproveRuleService {
    PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();
    @Autowired
    private PcsSkuAutoApproveBgmMapper pcsSkuAutoApproveBgmMapper;

    @Override
    public boolean addOrEdit(PcsSkuFinanceAutoApproveRuleVO vo) {
        ArrayList<CommTypeValue> commTypeValues = new ArrayList<CommTypeValue>();
        this.makePcsSkuAutoApproveRule(vo, commTypeValues);
        if (CollectionUtils.isNotEmpty(commTypeValues)) {
            return this.pegasusUtilFacade.addOrUpdateCommTypeValue(commTypeValues);
        }
        return false;
    }

    private void makePcsSkuAutoApproveRule(PcsSkuFinanceAutoApproveRuleVO vo, List<CommTypeValue> commTypeValues) {
        PcsSkuFinanceAutoApproveRule voTmp = new PcsSkuFinanceAutoApproveRule();
        voTmp.setCategoryIds(vo.getCategoryIds());
        CommTypeValue commTypeValue = new CommTypeValue();
        commTypeValue.setType("TYPE_AUTO_FINANCE_APPROVE");
        commTypeValue.setName("TYPE_AUTO_FINANCE_APPROVE_CATEGORY");
        if (CollectionUtils.isNotEmpty(vo.getCategoryIds())) {
            commTypeValue.setValue(JSONObject.toJSONString((Object)voTmp));
        } else {
            commTypeValue.setValue("");
        }
        commTypeValue.setDescription("SKU\u8d22\u52a1\u81ea\u52a8\u5ba1\u6279\u2014\u2014>\u54c1\u7c7b\u5217\u8868");
        commTypeValues.add(commTypeValue);
        PcsSkuFinanceAutoApproveRule approveRule = (PcsSkuFinanceAutoApproveRule)BeanUtil.buildFrom((Object)vo, PcsSkuFinanceAutoApproveRule.class);
        approveRule.setCategoryIds(null);
        CommTypeValue commTypeValueOther = new CommTypeValue();
        commTypeValueOther.setType("TYPE_AUTO_FINANCE_APPROVE");
        commTypeValueOther.setName("TYPE_AUTO_FINANCE_APPROVE_OTHER");
        commTypeValueOther.setValue(JSONObject.toJSONString((Object)approveRule));
        commTypeValueOther.setDescription("SKU\u8d22\u52a1\u81ea\u52a8\u5ba1\u6279\u2014\u2014>\u5176\u5b83\u53c2\u6570");
        commTypeValues.add(commTypeValueOther);
    }

    @Override
    public Map<Integer, BigDecimal> getPcsSkuFinanceAutoApproveRuleForCostRiseUnder() {
        HashMap<Integer, BigDecimal> ruleMap = new HashMap<Integer, BigDecimal>();
        PcsSkuFinanceAutoApproveRuleVO autoApproveRuleVO = this.findPcsSkuFinanceAutoApproveRuleVO(null);
        if (EmptyUtil.isEmpty((Object)autoApproveRuleVO)) {
            ruleMap.put(PcsSkuFinanceAutoApproveRuleVO.SKU_COST_RISE_UNDER, BigDecimal.ZERO);
            ruleMap.put(PcsSkuFinanceAutoApproveRuleVO.MATERIAL_COST_RISE_UNDER, BigDecimal.ZERO);
            return ruleMap;
        }
        BigDecimal costRiseUnder = EmptyUtil.isEmpty((String)autoApproveRuleVO.getCostRiseUnder()) ? BigDecimal.ZERO : new BigDecimal(autoApproveRuleVO.getCostRiseUnder());
        BigDecimal materialCostRiseUnder = EmptyUtil.isEmpty((String)autoApproveRuleVO.getMaterialCostRiseUnder()) ? BigDecimal.ZERO : new BigDecimal(autoApproveRuleVO.getMaterialCostRiseUnder());
        ruleMap.put(PcsSkuFinanceAutoApproveRuleVO.SKU_COST_RISE_UNDER, costRiseUnder);
        ruleMap.put(PcsSkuFinanceAutoApproveRuleVO.MATERIAL_COST_RISE_UNDER, materialCostRiseUnder);
        return ruleMap;
    }

    @Override
    public PcsSkuFinanceAutoApproveRuleVO findPcsSkuFinanceAutoApproveRuleVO(PcsSkuFinanceAutoApproveRuleCond cond) {
        PcsSkuFinanceAutoApproveRuleVO pcsSkuFinanceAutoApproveRuleVO = new PcsSkuFinanceAutoApproveRuleVO();
        List commTypeValues = this.pegasusUtilFacade.getCommTypeValuesByType("TYPE_AUTO_FINANCE_APPROVE");
        if (CollectionUtils.isNotEmpty((Collection)commTypeValues)) {
            JSONObject categoryJson;
            PcsSkuFinanceAutoApproveRuleVO autoApproveRuleVO;
            JSONObject otherJson;
            PcsSkuFinanceAutoApproveRuleVO autoMakeOrderParamTmp;
            HashMap<String, CommTypeValue> commTypeValueMap = new HashMap<String, CommTypeValue>();
            for (CommTypeValue commTypeValue : commTypeValues) {
                commTypeValueMap.put(commTypeValue.getName(), commTypeValue);
            }
            CommTypeValue commTypeValueTmp = (CommTypeValue)commTypeValueMap.get("TYPE_AUTO_FINANCE_APPROVE_OTHER");
            if (EmptyUtil.isNotEmpty((Object)commTypeValueTmp) && EmptyUtil.isNotEmpty((String)commTypeValueTmp.getValue()) && EmptyUtil.isNotEmpty((Object)(autoMakeOrderParamTmp = (PcsSkuFinanceAutoApproveRuleVO)JSONObject.toJavaObject((JSON)(otherJson = JSON.parseObject((String)commTypeValueTmp.getValue())), PcsSkuFinanceAutoApproveRuleVO.class)))) {
                pcsSkuFinanceAutoApproveRuleVO = (PcsSkuFinanceAutoApproveRuleVO)BeanUtil.buildFrom((Object)autoMakeOrderParamTmp, PcsSkuFinanceAutoApproveRuleVO.class);
            }
            if (EmptyUtil.isNotEmpty((Object)(commTypeValueTmp = (CommTypeValue)commTypeValueMap.get("TYPE_AUTO_FINANCE_APPROVE_CATEGORY"))) && EmptyUtil.isNotEmpty((String)commTypeValueTmp.getValue()) && EmptyUtil.isNotEmpty((Object)(autoApproveRuleVO = (PcsSkuFinanceAutoApproveRuleVO)JSONObject.toJavaObject((JSON)(categoryJson = JSON.parseObject((String)commTypeValueTmp.getValue())), PcsSkuFinanceAutoApproveRuleVO.class))) && CollectionUtils.isNotEmpty(autoApproveRuleVO.getCategoryIds())) {
                ArrayList<Long> categoryIds = new ArrayList<Long>();
                autoApproveRuleVO.getCategoryIds().forEach(categoryId -> categoryIds.add((Long)categoryId));
                if (EmptyUtil.isEmpty((Object)autoApproveRuleVO.getId())) {
                    pcsSkuFinanceAutoApproveRuleVO.setId(commTypeValueTmp.getId());
                }
                pcsSkuFinanceAutoApproveRuleVO.setCategoryIds(categoryIds);
            }
            if (pcsSkuFinanceAutoApproveRuleVO != null && EmptyUtil.isNotEmpty((Object)cond) && cond.isFetchBgms()) {
                pcsSkuFinanceAutoApproveRuleVO.setSkuAutoApproveBgmVOs(this.pcsSkuAutoApproveBgmMapper.listAllPcsSkuAutoApproveBgmVO());
            }
        }
        return pcsSkuFinanceAutoApproveRuleVO;
    }

    @Override
    @Transactional
    public boolean addPcsSkuAutoApproveBgm(PcsSkuAutoApproveBgm skuAutoApproveBgm) {
        return this.pcsSkuAutoApproveBgmMapper.insertSelective(skuAutoApproveBgm) > 0;
    }

    @Override
    @Transactional
    public boolean batchAddPcsSkuAutoApproveBgm(List<PcsSkuAutoApproveBgm> skuAutoApproveBgms, Boolean needEmpty) {
        if (needEmpty.booleanValue()) {
            this.emptyPcsSkuAutoApproveBgm();
        }
        return this.pcsSkuAutoApproveBgmMapper.batchInsert(skuAutoApproveBgms);
    }

    @Override
    public boolean emptyPcsSkuAutoApproveBgm() {
        return this.pcsSkuAutoApproveBgmMapper.deleteByExample(null) > 0;
    }

    @Override
    public List<PcsSkuAutoApproveBgm> listAllPcsSkuAutoApproveBgm() {
        return this.pcsSkuAutoApproveBgmMapper.selectByExample(null);
    }

    @Override
    public List<PcsSkuAutoApproveBgm> listPcsSkuAutoApproveBgmByCond(PcsSkuAutoApproveBgmCond cond) {
        PcsSkuAutoApproveBgmExample example = this.buildPcsSkuAutoApproveBgmExampleByCond(cond);
        return this.pcsSkuAutoApproveBgmMapper.selectByExample(example);
    }

    private PcsSkuAutoApproveBgmExample buildPcsSkuAutoApproveBgmExampleByCond(PcsSkuAutoApproveBgmCond cond) {
        PcsSkuAutoApproveBgmExample example = new PcsSkuAutoApproveBgmExample();
        PcsSkuAutoApproveBgmExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getCategoryId())) {
            criteria.andCategoryIdEqualTo(cond.getCategoryId());
        } else if (CollectionUtils.isNotEmpty(cond.getCategoryIds())) {
            criteria.andCategoryIdIn((List)cond.getCategoryIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getSkuPurchasePattern())) {
            criteria.andSkuPurchasePatternEqualTo(cond.getSkuPurchasePattern());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCategoryLevel())) {
            criteria.andCategoryLevelEqualTo(cond.getCategoryLevel());
        }
        return example;
    }

    @Override
    public List<PcsSkuAutoApproveBgmVO> listAllPcsSkuAutoApproveBgmVO() {
        return this.pcsSkuAutoApproveBgmMapper.listAllPcsSkuAutoApproveBgmVO();
    }

    @Override
    public List<PcsSkuAutoApproveBgmVO> listAllPcsSkuAutoApproveBgmVOByCond(PcsSkuAutoApproveBgmCond cond) {
        return this.pcsSkuAutoApproveBgmMapper.listAllPcsSkuAutoApproveBgmVOByCond(cond);
    }

    @Override
    public List<PcsSkuAutoApproveBgmVO> listAllFirstCategoryBgmVO() {
        return this.pcsSkuAutoApproveBgmMapper.listAllFirstCategoryBgmVO();
    }

    @Override
    public List<PcsSkuAutoApproveBgmVO> listCategoryBgmVOByCond(PcsSkuAutoApproveBgmCond cond) {
        return this.pcsSkuAutoApproveBgmMapper.listCategoryBgmVOByCond(cond);
    }
}

