/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.message.enums.MsgTypeEnum;
import com.thebeastshop.message.enums.PublishTypeEnum;
import com.thebeastshop.message.service.MsgSendService;
import com.thebeastshop.message.vo.MsgSingleVo;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuSalesPriceChangeStatusEnum;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuStatusEnum;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoCreditNoteCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseReturnCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsCostAdjustMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoApprovalRecordsMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoCostApprovalRecordsMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoCreditNoteMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoLineApprovalRecordMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanCostMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseOrderCostMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseOrderMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseReturnMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseReturnSkuMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PurchaseSellStockReportMapper;
import com.thebeastshop.pegasus.service.purchase.enums.PoStatusEnum;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.OpFinanceBudget;
import com.thebeastshop.pegasus.service.purchase.model.PcsCostAdjust;
import com.thebeastshop.pegasus.service.purchase.model.PcsCostAdjustExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoApprovalRecords;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoApprovalRecordsExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoCostApprovalRecords;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoCostApprovalRecordsExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoCreditNote;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoCreditNoteExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLineApprovalRecord;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCost;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrderCost;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrderExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseReturn;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseReturnSku;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoCreditNoteVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoFieldEditableInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanCostVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoProgressTrackingDetailVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoProgressTrackingVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseReturnSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseReturnVO;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseSellStockReportVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import com.thebeastshop.pegasus.util.model.CommAudit;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.stock.enums.SStockInOutTypeEnum;
import com.thebeastshop.wms.cond.PhyWhStockCond;
import com.thebeastshop.wms.sservice.SWhInfoService;
import com.thebeastshop.wms.sservice.SWhInvService;
import com.thebeastshop.wms.sservice.SWhWmsSkuStockService;
import com.thebeastshop.wms.sservice.WWhCommandService;
import com.thebeastshop.wms.vo.PhyWhStockVO;
import com.thebeastshop.wms.vo.WhCommandSkuVO;
import com.thebeastshop.wms.vo.WhCommandVO;
import com.thebeastshop.wms.vo.WhInvVO;
import com.thebeastshop.wms.vo.WhWarehouseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsPurchaseOrderService")
public class PcsPurchaseOrderServiceImpl
implements PcsPurchaseOrderService,
CheckAble,
CodeAble {
    private final Logger log = LoggerFactory.getLogger(PcsPurchaseOrderServiceImpl.class);
    @Autowired
    private PcsPurchaseOrderMapper pcsPurchaseOrderMapper;
    @Autowired
    private PcsPoLineService pcsPoLineService;
    @Autowired
    private PcsPoPlanMapper pcsPoPlanMapper;
    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;
    @Autowired
    private McPcsSkuSalesPriceChangeService mcPcsSkuSalesPriceChangeService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private PcsPurchaseReturnMapper pcsPurchaseReturnMapper;
    @Autowired
    private PcsPurchaseReturnSkuMapper pcsPurchaseReturnSkuMapper;
    @Autowired
    private PcsPurchaseOrderCostMapper pcsPurchaseOrderCostMapper;
    @Autowired
    private PcsPoPlanCostMapper pcsPoPlanCostMapper;
    @Autowired
    private PcsCostAdjustMapper pcsCostAdjustMapper;
    @Autowired
    private PurchaseSellStockReportMapper purchaseSellStockReportMapper;
    @Autowired
    private MsgSendService msgSendService;
    @Autowired
    private PcsPoApprovalRecordsMapper pcsPoApprovalRecordsMapper;
    @Autowired
    private PcsPoLineApprovalRecordMapper pcsPoLineApprovalRecordMapper;
    @Autowired
    private PcsPoCreditNoteMapper pcsPoCreditNoteMapper;
    @Autowired
    private PcsPoPlanService pcsPoPlanService;
    @Autowired
    private PcsPoCostApprovalRecordsMapper pcsPoCostApprovalRecordsMapper;
    @Autowired
    private WWhCommandService wWhCommandService;
    @Autowired
    private SWhInfoService sWhInfoService;
    @Autowired
    private SWhInvService sWhInvService;
    @Autowired
    private SWhWmsSkuStockService sWhWmsSkuStockService;
    private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();

    public Boolean check(Object obj) {
        PcsPurchaseOrder record = (PcsPurchaseOrder)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        Boolean currencyFlag = false;
        record.setPurchaseCurrencyDesc(record.getPurchaseCurrencyCode());
        return true;
    }

    private Boolean check(PcsPurchaseOrder record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(String code) {
        return NullUtil.isNull((Object)this.findPoByCode(code));
    }

    public String generateCode(Object id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_PURCHASE_ORDER", params);
        return code;
    }

    @Override
    public PcsPurchaseOrder buildFromVO(PcsPurchaseOrderVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsPurchaseOrder record = new PcsPurchaseOrder();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        record.setPurchaseCurrencyRate(vo.getRate());
        return record;
    }

    @Override
    public PcsPurchaseOrderVO buildFromModel(PcsPurchaseOrder record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsPurchaseOrderVO vo = new PcsPurchaseOrderVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        vo.setRate(record.getPurchaseCurrencyRate());
        return vo;
    }

    @Override
    public Long addPcsPoCreditNoteVO(PcsPoCreditNoteVO vo) {
        return this.createPcsPoCreditNote(vo);
    }

    @Override
    public void deletePcsPoCreditNoteVO(PcsPoCreditNoteVO vo) {
        PcsPoCreditNote pcsPoCreditNote = this.pcsPoCreditNoteMapper.selectByPrimaryKey(vo.getId());
        if (pcsPoCreditNote.getStatus() != 0) {
            throw new RuntimeException("\u53ea\u6709\u672a\u4f7f\u7528\u72b6\u6001\u624d\u53ef\u4ee5\u5220\u9664");
        }
        this.pcsPoCreditNoteMapper.deleteByPrimaryKey(vo.getId());
        ArrayList<String> fileRefCodes = new ArrayList<String>();
        fileRefCodes.add(vo.getId().toString());
        this.pegasusUtilFacade.deleteCommFileRefByRefCodes(fileRefCodes, CommFileRef.CONTRACT_TYPE_CREDIT_NOTE);
    }

    private Long createPcsPoCreditNote(PcsPoCreditNoteVO creditNoteVO) {
        HashMap<Long, List> mapCommFileRefs = new HashMap<Long, List>();
        this.pcsPoCreditNoteMapper.insertSelective(creditNoteVO);
        if (CollectionUtils.isNotEmpty(creditNoteVO.getAttachmentList())) {
            mapCommFileRefs.put(creditNoteVO.getId(), creditNoteVO.getAttachmentList());
        }
        if (mapCommFileRefs.size() > 0) {
            mapCommFileRefs.forEach((k, v) -> v.forEach(commRef -> {
                commRef.setReferenceCode(k.toString());
                this.pegasusUtilFacade.createCommFileRef(commRef);
            }));
        }
        return creditNoteVO.getId();
    }

    @Override
    @Transactional
    public PcsPurchaseOrder create(PcsPurchaseOrder record, boolean saveDraft) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setCreateTime(new Date());
            record.setIsReceivedAll(1);
            this.pcsPurchaseOrderMapper.insertSelective(record);
            try {
                String code = this.generateCode(record.getId());
                if (this.check(code).booleanValue()) {
                    record.setCode(code);
                    if (!saveDraft) {
                        // empty if block
                    }
                    this.pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record);
                    return record;
                }
                throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                throw new PurchaseException("PC0006", "\u751f\u6210CODE\u5931\u8d25");
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPurchaseOrder record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            record.setCode(null);
            return this.pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public PcsPurchaseOrder findPoById(Long id) {
        return this.pcsPurchaseOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsPoCreditNote> listPcsPoCreditNoteByCond(PcsPoCreditNoteCond cond) {
        PcsPoCreditNoteExample example = this.buildPcsPoCreditNoteExampleByCond(cond);
        return this.pcsPoCreditNoteMapper.selectByExample(example);
    }

    @Override
    public List<PcsPoCreditNoteVO> listPcsPoCreditNoteVOByCond(PcsPoCreditNoteCond cond) {
        return this.pcsPoCreditNoteMapper.listPcsPoCreditNoteVOByCond(cond);
    }

    @Override
    public List<PcsPoCreditNoteVO> listSumPoCreditNoteVOByCond(PcsPoCreditNoteCond cond) {
        return this.pcsPoCreditNoteMapper.listSumPoCreditNoteVOByCond(cond);
    }

    private boolean checkBigDecimalGtZero(BigDecimal amount) {
        return EmptyUtil.isNotEmpty((Object)amount) && amount.compareTo(BigDecimal.ZERO) > 0;
    }

    private PcsPoCreditNoteExample buildPcsPoCreditNoteExampleByCond(String poCode, Integer status) {
        PcsPoCreditNoteCond cond = new PcsPoCreditNoteCond();
        cond.setPoCode(poCode);
        cond.setStatus(status);
        return this.buildPcsPoCreditNoteExampleByCond(cond);
    }

    private PcsPoCreditNoteExample buildPcsPoCreditNoteExampleByCond(PcsPoCreditNoteCond cond) {
        PcsPoCreditNoteExample example = new PcsPoCreditNoteExample();
        PcsPoCreditNoteExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((String)cond.getPoCode())) {
            criteria.andPoCodeEqualTo(cond.getPoCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getStatus())) {
            criteria.andStatusEqualTo(cond.getStatus());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getNotStatus())) {
            criteria.andStatusNotEqualTo(cond.getNotStatus());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getValid())) {
            criteria.andValidEqualTo(cond.getValid());
        } else {
            criteria.andValidEqualTo(1);
        }
        return example;
    }

    @Override
    public PcsPurchaseOrderVO findPoVOById(Long id) {
        PcsPurchaseOrderVO pcsPurchaseOrderVO = this.pcsPurchaseOrderMapper.findPoVOById(id);
        if (EmptyUtil.isNotEmpty((Object)pcsPurchaseOrderVO)) {
            PcsPoApprovalRecords pcsPoApprovalRecords = this.findNewestApprovalRecordsByPoId(id);
            if (pcsPoApprovalRecords != null) {
                pcsPurchaseOrderVO.setSubmitUserId(pcsPoApprovalRecords.getSubmitUserId());
            }
            List<PcsPurchaseOrderCost> orderCostList = this.pcsPurchaseOrderCostMapper.selectByPoId(id);
            pcsPurchaseOrderVO.setOrderCostList(orderCostList);
            if (EmptyUtil.isNotEmpty(orderCostList)) {
                for (PcsPurchaseOrderCost pcsPurchaseOrderCost : orderCostList) {
                    short costType = pcsPurchaseOrderCost.getCostType();
                    if (costType == 1) {
                        pcsPurchaseOrderVO.setMoldCost(pcsPurchaseOrderCost.getAfterTaxesAmount());
                        pcsPurchaseOrderVO.setMoldRate(pcsPurchaseOrderCost.getRate());
                    }
                    if (costType == 2) {
                        pcsPurchaseOrderVO.setPlateCost(pcsPurchaseOrderCost.getAfterTaxesAmount());
                        pcsPurchaseOrderVO.setPlateRate(pcsPurchaseOrderCost.getRate());
                    }
                    if (costType != 3) continue;
                    pcsPurchaseOrderVO.setFreightCost(pcsPurchaseOrderCost.getAfterTaxesAmount());
                    pcsPurchaseOrderVO.setFreightRate(pcsPurchaseOrderCost.getRate());
                }
            }
        }
        return pcsPurchaseOrderVO;
    }

    @Override
    public PcsPurchaseOrderVO findPoVOByCode(String code) {
        return this.pcsPurchaseOrderMapper.findPoVOByCode(code);
    }

    @Override
    public PcsPurchaseOrder findPoByPoCode(String poCode) {
        return this.findPoByCode(poCode);
    }

    @Override
    public PcsPurchaseOrderVO findPurchaseOrderByCommandCode(String commandCode) {
        return this.pcsPurchaseOrderMapper.findPurchaseOrderByCommandCode(commandCode);
    }

    @Override
    public PcsPurchaseOrder findPoByCode(String code) {
        PcsPurchaseOrderExample example = new PcsPurchaseOrderExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsPurchaseOrder> poList = this.pcsPurchaseOrderMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return null;
        }
        if (poList.size() > 1) {
            throw new PurchaseException("PC0005", " \u6839\u636ecode[" + code + "]\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        return poList.get(0);
    }

    @Override
    public List<PcsPurchaseOrderVO> findPOVOByCond(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderMapper.findPOVOByCond(cond);
    }

    @Override
    public PageInfo<PcsPurchaseOrderVO> pageQueryPOByCond(PcsPurchaseOrderCond cond) {
        PageRowBounds rowBounds = new PageRowBounds(cond.getPageStart(), cond.getPagenum().intValue());
        PageInfo pageInfo = new PageInfo(this.pcsPurchaseOrderMapper.pageQueryPOByCond(cond, rowBounds));
        pageInfo.setTotal(rowBounds.getTotal().longValue());
        return pageInfo;
    }

    @Override
    public Map<String, Integer> countPoGroupByStatus(PcsPurchaseOrderCond cond) {
        List<Map<String, Integer>> countMapList = this.pcsPurchaseOrderMapper.countPoGroupByStatus(cond);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        if (CollectionUtils.isNotEmpty(countMapList)) {
            countMapList.forEach(map -> countMap.put(String.valueOf(map.get("poStatus")), (Integer)map.get("poCount")));
        }
        return countMap;
    }

    @Override
    @Transactional
    public Long createPurchaseOrderAndLine(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        PcsPurchaseOrder pcsPurchaseOrder = this.buildFromVO(pcsPurchaseOrderVO);
        ArrayList<PcsPoLine> pcsPoLineList = new ArrayList();
        if (CollectionUtils.isEmpty(pcsPurchaseOrderVO.getPcsPoLineVOList())) {
            pcsPoLineList = Collections.emptyList();
        } else {
            for (PcsPoLineVO pcsPoLineVO : pcsPurchaseOrderVO.getPcsPoLineVOList()) {
                PcsPoLine pcsPoLine = this.pcsPoLineService.buildFromVO(pcsPoLineVO);
                pcsPoLineList.add(pcsPoLine);
            }
        }
        Long poId = this.createPurchaseOrderAndLine(pcsPurchaseOrder, pcsPoLineList, pcsPurchaseOrderVO.isSaveDraft(), pcsPurchaseOrderVO.getOrderCostList());
        this.createPcsPoCreditNoteVO(pcsPurchaseOrderVO.getPcsPoCreditNoteVOs(), pcsPurchaseOrder.getCode());
        this.createPoOtherAttachments(pcsPurchaseOrderVO.getOtherAttachmentList(), pcsPurchaseOrder.getId());
        return poId;
    }

    private void updateCreatePcsPoCreditNoteVO(List<PcsPoCreditNoteVO> creditNoteVOs, String poCode) {
        PcsPoCreditNoteExample example = this.buildPcsPoCreditNoteExampleByCond(poCode, null);
        List<PcsPoCreditNote> creditNotes = this.pcsPoCreditNoteMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(creditNotes)) {
            this.pcsPoCreditNoteMapper.deleteByExample(example);
            ArrayList fileRefCodes = new ArrayList();
            creditNotes.forEach(cn -> fileRefCodes.add(cn.getId().toString()));
            this.pegasusUtilFacade.deleteCommFileRefByRefCodes(fileRefCodes, CommFileRef.CONTRACT_TYPE_CREDIT_NOTE);
        }
        this.createPcsPoCreditNoteVO(creditNoteVOs, poCode);
    }

    private void updatePoOtherAttachments(List<CommFileRef> otherAttachmentList, Long poId) {
        this.pegasusUtilFacade.deleteCommFileRefByRefCodes(Arrays.asList(poId.toString()), CommFileRef.CONTRACT_TYPE_PO_OTHER);
        this.createPoOtherAttachments(otherAttachmentList, poId);
    }

    private void createPcsPoCreditNoteVO(List<PcsPoCreditNoteVO> creditNoteVOs, String poCode) {
        if (CollectionUtils.isNotEmpty(creditNoteVOs)) {
            HashMap<Long, List> mapCommFileRefs = new HashMap<Long, List>();
            for (PcsPoCreditNoteVO creditNoteVO : creditNoteVOs) {
                creditNoteVO.setPoCode(poCode);
                this.pcsPoCreditNoteMapper.insertSelective(creditNoteVO);
                if (!CollectionUtils.isNotEmpty(creditNoteVO.getAttachmentList())) continue;
                mapCommFileRefs.put(creditNoteVO.getId(), creditNoteVO.getAttachmentList());
            }
            if (mapCommFileRefs.size() > 0) {
                mapCommFileRefs.forEach((k, v) -> v.forEach(commRef -> {
                    commRef.setReferenceCode(k.toString());
                    this.pegasusUtilFacade.createCommFileRef(commRef);
                }));
            }
        }
    }

    private void createPoOtherAttachments(List<CommFileRef> otherAttachmentList, Long poId) {
        if (CollectionUtils.isNotEmpty(otherAttachmentList)) {
            otherAttachmentList.forEach(attach -> {
                attach.setReferenceCode(poId.toString());
                this.pegasusUtilFacade.createCommFileRef(attach);
            });
        }
    }

    @Override
    @Transactional
    public Long createPurchaseOrderAndLine(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, boolean saveDraft, List<PcsPurchaseOrderCost> orderCostList) {
        this.computeTotalPrice(pcsPurchaseOrder, pcsPoLineList, orderCostList);
        if (pcsPoLineList.size() == 0) {
            throw new PurchaseException("PC0001", "\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u884c\u4fe1\u606f");
        }
        if (saveDraft) {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT);
        } else {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
            pcsPurchaseOrder.setLastSubmitTime(new Date());
            this.checkSkuStatus(pcsPoLineList);
        }
        pcsPurchaseOrder.setIncludeShipment(this.checkIsContainFreight(orderCostList) ? (short)0 : 1);
        pcsPurchaseOrder = this.create(pcsPurchaseOrder, saveDraft);
        if (EmptyUtil.isEmpty((Object)pcsPurchaseOrder.getId())) {
            throw new PurchaseException("PC0009", "\u5934\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + pcsPurchaseOrder.toString());
        }
        for (PcsPoLine pcsPoLine : pcsPoLineList) {
            pcsPoLine.setPoId(pcsPurchaseOrder.getId());
            if (this.pcsPoLineService.create(pcsPoLine).compareTo(0L) >= 1) continue;
            throw new PurchaseException("PC0009", "\u884c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + pcsPoLine.toString());
        }
        this.createPurchaseOrderCosts(orderCostList, pcsPurchaseOrder.getId());
        if (!saveDraft) {
            pcsPurchaseOrder.setPurchaseOrderStatus(PoStatusEnum.PURCHASE_ORDER_STATUS_DRAFT.getKey());
            this.savePoAndLineApprovalRecord(pcsPurchaseOrder, pcsPoLineList, orderCostList);
        }
        return pcsPurchaseOrder.getId();
    }

    @Override
    public void checkPurchaseOrderBeforeEdit(PcsPurchaseOrderVO editVO) {
        if (NullUtil.isNull((Object)editVO.getId())) {
            return;
        }
        PcsPurchaseOrderVO info = this.findPurchaseOrderById(editVO.getId());
        if (NullUtil.isNull((Object)info)) {
            throw new PurchaseException(String.format("[%s]\u91c7\u8d2d\u5355\u4e0d\u5b58\u5728\uff01", editVO.getId()));
        }
        this.checkPurchaseOrderFieldsBeforeEdit(editVO, info);
    }

    @Override
    public PcsPoFieldEditableInfoVO buildPoFieldEditableInfo(PcsPurchaseOrderVO info) {
        int passTimes = this.getPoPassApprovalTimes(info.getId());
        info.setAuditPassOnce(passTimes > 0);
        Predicate<Integer> isDraft = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT::equals;
        Predicate<Integer> isReject = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT::equals;
        Predicate<Integer> isWaitingAudit = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT::equals;
        Predicate<Integer> isWaitFinanceApprovel = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_FINANCE_APPROVEL::equals;
        Predicate<Integer> isAudit = isWaitingAudit.or(isWaitFinanceApprovel);
        Predicate<Integer> isWaitReceive = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE::equals;
        Predicate<Integer> isWaitingReceive = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE::equals;
        Predicate<Integer> isAlreadyFinish = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH::equals;
        Predicate<Integer> isDraftOrReject = isDraft.or(isReject);
        Predicate<Integer> isRejectOrWaitOrWaitingReceive = isReject.or(isWaitReceive).or(isWaitingReceive);
        Predicate<Integer> isAuditPassOnce = status -> info.isAuditPassOnce();
        Predicate<Integer> neverPassOnce = isAuditPassOnce.negate().and(isDraftOrReject);
        List<PcsPoPlan> planList = this.pcsPoPlanService.findPcsPoPlanByPoId(info.getId());
        Predicate<Integer> neverCreatePoPlan = status -> EmptyUtil.isEmpty((List)planList);
        BooleanSupplier commCanEdit = () -> isAuditPassOnce.and(isDraftOrReject).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        PcsPoFieldEditableInfoVO editableInfo = new PcsPoFieldEditableInfoVO();
        BooleanSupplier supplierCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setSupplier(supplierCanEdit.getAsBoolean());
        BooleanSupplier purchaseCurrencyCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setPurchaseCurrencyCode(purchaseCurrencyCodeCanEdit.getAsBoolean());
        BooleanSupplier purchaseOrderCostCenterCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setPurchaseOrderCostCenter(purchaseOrderCostCenterCanEdit.getAsBoolean());
        BooleanSupplier askDeliveryDateCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        editableInfo.setAskDeliveryDate(askDeliveryDateCanEdit.getAsBoolean());
        BooleanSupplier needCustomsArrangeCanEdit = askDeliveryDateCanEdit;
        editableInfo.setNeedCustomsArrange(needCustomsArrangeCanEdit.getAsBoolean());
        BooleanSupplier setDeliveryTermsCanEdit = askDeliveryDateCanEdit;
        editableInfo.setDeliveryTerms(setDeliveryTermsCanEdit.getAsBoolean());
        BooleanSupplier physicalWarehouseCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setPhysicalWarehouseCode(physicalWarehouseCodeCanEdit.getAsBoolean());
        BooleanSupplier warehouseCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setWarehouseCode(warehouseCodeCanEdit.getAsBoolean());
        BooleanSupplier autoBuildPopCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        editableInfo.setAutoBuildPop(autoBuildPopCanEdit.getAsBoolean());
        BooleanSupplier overDeliveryLimitRateCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        editableInfo.setOverDeliveryLimitRate(overDeliveryLimitRateCanEdit.getAsBoolean());
        BooleanSupplier remarkCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive.or(isAlreadyFinish)).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        editableInfo.setRemark(remarkCanEdit.getAsBoolean());
        BooleanSupplier contractAttachmentCanEdit = () -> neverPassOnce.or(isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive.or(isAlreadyFinish))).test(info.getPurchaseOrderStatus());
        editableInfo.setContractAttachment(contractAttachmentCanEdit.getAsBoolean());
        BooleanSupplier poCostCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setPoCost(poCostCanEdit.getAsBoolean());
        BooleanSupplier skuCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        BooleanSupplier skuQuantityCanEdit = () -> neverPassOnce.or(isWaitReceive.or(isReject).and(neverCreatePoPlan)).test(info.getPurchaseOrderStatus());
        BooleanSupplier skuUnitPriceCanEdit = () -> isAuditPassOnce.and(isReject).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        BooleanSupplier skuTaxRateCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setSku(skuCanEdit.getAsBoolean());
        editableInfo.setSkuQuantity(skuQuantityCanEdit.getAsBoolean());
        editableInfo.setSkuUnitPrice(skuUnitPriceCanEdit.getAsBoolean());
        editableInfo.setSkuTaxRate(skuTaxRateCanEdit.getAsBoolean());
        BooleanSupplier creditNoteCanEdit = () -> isWaitingReceive.or(isWaitReceive).or(isAlreadyFinish).test(info.getPurchaseOrderStatus());
        editableInfo.setCreditNote(creditNoteCanEdit.getAsBoolean());
        BooleanSupplier otherAttachmentsCanEdit = () -> true;
        editableInfo.setOtherAttachments(otherAttachmentsCanEdit.getAsBoolean());
        editableInfo.setAuditPassOnce(info.isAuditPassOnce());
        return editableInfo;
    }

    private void checkPurchaseOrderFieldsBeforeEdit(PcsPurchaseOrderVO editVO, PcsPurchaseOrderVO info) {
        int passTimes = this.getPoPassApprovalTimes(info.getId());
        info.setAuditPassOnce(passTimes > 0);
        Predicate<Integer> isDraft = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT::equals;
        Predicate<Integer> isReject = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT::equals;
        Predicate<Integer> isWaitingAudit = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT::equals;
        Predicate<Integer> isWaitFinanceApprovel = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_FINANCE_APPROVEL::equals;
        Predicate<Integer> isAudit = isWaitingAudit.or(isWaitFinanceApprovel);
        Predicate<Integer> isWaitReceive = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE::equals;
        Predicate<Integer> isWaitingReceive = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE::equals;
        Predicate<Integer> isAlreadyFinish = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH::equals;
        Predicate<Integer> isDraftOrReject = isDraft.or(isReject);
        Predicate<Integer> isRejectOrWaitOrWaitingReceive = isReject.or(isWaitReceive).or(isWaitingReceive);
        Predicate<Integer> isAuditPassOnce = status -> info.isAuditPassOnce();
        Predicate<Integer> neverPassOnce = isAuditPassOnce.negate().and(isDraftOrReject);
        List<PcsPoPlan> planList = this.pcsPoPlanService.findPcsPoPlanByPoId(info.getId());
        Predicate<Integer> neverCreatePoPlan = status -> EmptyUtil.isEmpty((List)planList);
        BooleanSupplier commCanEdit = () -> isAuditPassOnce.and(isDraftOrReject).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        BooleanSupplier supplierCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        this.checkPurchaseOrderField(supplierCanEdit, editVO::getSupplierId, info::getSupplierId, String.format("[%s][%s]\u4f9b\u5e94\u5546\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        BooleanSupplier purchaseCurrencyCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        this.checkPurchaseOrderField(purchaseCurrencyCodeCanEdit, editVO::getPurchaseCurrencyCode, info::getPurchaseCurrencyCode, String.format("[%s][%s]\u5e01\u79cd\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        BooleanSupplier purchaseOrderCostCenterCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        this.checkPurchaseOrderField(purchaseOrderCostCenterCanEdit, editVO::getPurchaseOrderCostCenter, info::getPurchaseOrderCostCenter, String.format("[%s][%s]\u6210\u672c\u4e2d\u5fc3\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        BooleanSupplier askDeliveryDateCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        this.checkPurchaseOrderField(askDeliveryDateCanEdit, editVO::getAskDeliveryDate, info::getAskDeliveryDate, String.format("[%s][%s]\u4ea4\u8d27\u65e5\u671f\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        BooleanSupplier needCustomsArrangeCanEdit = askDeliveryDateCanEdit;
        this.checkPurchaseOrderField(needCustomsArrangeCanEdit, editVO::getNeedCustomsArrange, info::getNeedCustomsArrange, String.format("[%s][%s]\u5173\u52a1\u5b89\u6392\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        BooleanSupplier deliveryTermsCanEdit = askDeliveryDateCanEdit;
        this.checkPurchaseOrderField(deliveryTermsCanEdit, editVO::getDeliveryTerms, info::getDeliveryTerms, String.format("[%s][%s]DeliveryTerms\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        BooleanSupplier physicalWarehouseCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        this.checkPurchaseOrderField(physicalWarehouseCodeCanEdit, editVO::getPhysicalWarehouseCode, info::getPhysicalWarehouseCode, String.format("[%s][%s]\u7269\u7406\u4ed3\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        BooleanSupplier warehouseCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        this.checkPurchaseOrderField(warehouseCodeCanEdit, editVO::getWarehouseCode, info::getWarehouseCode, String.format("[%s][%s]\u6536\u8d27\u903b\u8f91\u4ed3\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        BooleanSupplier autoBuildPopCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        this.checkPurchaseOrderField(autoBuildPopCanEdit, editVO::getAutoBuildPop, info::getAutoBuildPop, String.format("[%s][%s]\u81ea\u52a8\u521b\u5efaPOP\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        BooleanSupplier overDeliveryLimitRateCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        this.checkPurchaseOrderField(overDeliveryLimitRateCanEdit, editVO::getOverDeliveryLimitRate, info::getOverDeliveryLimitRate, String.format("[%s][%s]\u8fc7\u91cf\u4ea4\u8d27\u9650\u5ea6\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        BooleanSupplier remarkCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive.or(isAlreadyFinish)).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        this.checkPurchaseOrderField(remarkCanEdit, editVO::getRemark, info::getRemark, String.format("[%s][%s]\u5907\u6ce8\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        BooleanSupplier creditNoteCanEdit = () -> isWaitingReceive.or(isWaitReceive).or(isAlreadyFinish).test(info.getPurchaseOrderStatus());
        BooleanSupplier otherAttachmentsCanEdit = () -> true;
        BooleanSupplier poCostCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        Map<Short, PcsPurchaseOrderCost> infoPoCostMap = info.getOrderCostList().stream().collect(Collectors.toMap(PcsPurchaseOrderCost::getCostType, item -> item));
        Integer infoPoCostLength = EmptyUtil.isEmpty(info.getOrderCostList()) ? 0 : info.getOrderCostList().size();
        Integer editPoCostLength = EmptyUtil.isEmpty(editVO.getOrderCostList()) ? 0 : editVO.getOrderCostList().size();
        this.checkPurchaseOrderField(poCostCanEdit, () -> editPoCostLength, () -> infoPoCostLength, String.format("[%s][%s]\u91c7\u8d2d\u5355\u8d39\u7528\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        editVO.getOrderCostList().forEach(poCost -> {
            PcsPurchaseOrderCost editOrderCost = (PcsPurchaseOrderCost)infoPoCostMap.get(poCost.getCostType());
            this.checkPurchaseOrderField(poCostCanEdit, () -> true, () -> NullUtil.isNotNull((Object)editOrderCost), String.format("[%s][%s]\u91c7\u8d2d\u5355\u8d39\u7528\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
            this.checkPurchaseOrderField(poCostCanEdit, editOrderCost::getRate, poCost::getRate, String.format("[%s][%s]\u91c7\u8d2d\u5355\u8d39\u7528\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
            this.checkPurchaseOrderField(poCostCanEdit, editOrderCost::getAfterTaxesAmount, poCost::getAfterTaxesAmount, String.format("[%s][%s]\u91c7\u8d2d\u5355\u8d39\u7528\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        });
        BooleanSupplier skuCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        BooleanSupplier skuQuantityCanEdit = () -> neverPassOnce.or(isWaitReceive.or(isReject).and(neverCreatePoPlan)).test(info.getPurchaseOrderStatus());
        BooleanSupplier skuUnitPriceCanEdit = () -> isAuditPassOnce.and(isReject).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        BooleanSupplier skuTaxRateCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        Integer infoPoLineLength = EmptyUtil.isEmpty(info.getPcsPoLineVOList()) ? 0 : info.getPcsPoLineVOList().size();
        Integer editPoLineLength = EmptyUtil.isEmpty(editVO.getPcsPoLineVOList()) ? 0 : editVO.getPcsPoLineVOList().size();
        this.checkPurchaseOrderField(skuCanEdit, () -> infoPoLineLength, () -> editPoLineLength, String.format("[%s][%s]SKU\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
        Map infoPoLineMap = info.getPcsPoLineVOList().stream().collect(Collectors.toMap(PcsPoLineVO::getSkuCode, Function.identity(), (v1, v2) -> v1));
        ArrayList<Long> delLineIds = new ArrayList<Long>();
        List<PcsPoLineVO> editPoLineList = editVO.getPcsPoLineVOList();
        infoPoLineMap.forEach((skuCode, value) -> {
            boolean isDelete = true;
            for (PcsPoLineVO editPoLine : editPoLineList) {
                String editPoLineSkuCode = editPoLine.getSkuCode();
                if (!skuCode.equals(editPoLineSkuCode)) continue;
                isDelete = false;
            }
            if (isDelete) {
                delLineIds.add(value.getId());
            }
        });
        editVO.getPcsPoLineVOList().forEach(editPoLine -> {
            PcsPoLineVO infoPoLine = (PcsPoLineVO)infoPoLineMap.get(editPoLine.getSkuCode());
            if (infoPoLine != null) {
                this.checkPurchaseOrderField(skuCanEdit, () -> true, () -> NullUtil.isNotNull((Object)infoPoLine), String.format("[%s][%s]SKU\u884c\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
                this.checkPurchaseOrderField(skuQuantityCanEdit, infoPoLine::getQuantity, editPoLine::getQuantity, String.format("[%s][%s]SKU\u884c\u6570\u91cf\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
                this.checkPurchaseOrderField(skuUnitPriceCanEdit, infoPoLine::getUnitPrice, editPoLine::getUnitPrice, String.format("[%s][%s]SKU\u884c\u91c7\u8d2d\u5355\u4ef7\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
                this.checkPurchaseOrderField(skuTaxRateCanEdit, infoPoLine::getTaxRate, editPoLine::getTaxRate, String.format("[%s][%s]SKU\u884c\u7a0e\u7387\u4e0d\u53ef\u7f16\u8f91\uff01", info.getCode(), info.getPurchaseOrderStatusName()));
            }
        });
        editVO.setDelLineIds(delLineIds);
    }

    private void checkPurchaseOrderField(BooleanSupplier canEditSupplier, Supplier<?> s1, Supplier<?> s2, String message) {
        boolean change;
        if (!canEditSupplier.getAsBoolean() && (change = this.isFieldChange(s1, s2))) {
            throw new PurchaseException("PC0002", message);
        }
    }

    private boolean isFieldChange(Supplier<?> s1, Supplier<?> s2) {
        boolean isEqual = false;
        if (NullUtil.isNull(s1.get()) && NullUtil.isNull(s2.get())) {
            isEqual = true;
        } else if (NullUtil.isNotNull(s1.get()) && NullUtil.isNotNull(s2.get())) {
            BigDecimal b2;
            BigDecimal b1;
            Class<?> clazz = s1.get().getClass();
            isEqual = BigDecimal.class.equals(clazz) ? (b1 = (BigDecimal)s1.get()).compareTo(b2 = (BigDecimal)s2.get()) == 0 : Predicate.isEqual(s1.get()).test(s2.get());
        }
        return !isEqual;
    }

    private boolean checkPurchaseOrderApprovalFields(PcsPurchaseOrderVO editVO, PcsPurchaseOrderVO info, int passTimes) {
        try {
            info.setAuditPassOnce(passTimes > 0);
            if (passTimes == 0 && (info.getPurchaseOrderStatus().equals(PoStatusEnum.PURCHASE_ORDER_STATUS_DRAFT.getKey()) || info.getPurchaseOrderStatus().equals(PoStatusEnum.PURCHASE_ORDER_STATUS_REJECT.getKey()))) {
                return editVO.isSaveDraft();
            }
            if (this.isFieldChange(editVO::getPurchaseCurrencyCode, info::getPurchaseCurrencyCode)) {
                return false;
            }
            Map<Short, PcsPurchaseOrderCost> infoPoCostMap = info.getOrderCostList().stream().collect(Collectors.toMap(PcsPurchaseOrderCost::getCostType, item -> item));
            Integer infoPoCostLength = EmptyUtil.isEmpty(info.getOrderCostList()) ? 0 : info.getOrderCostList().size();
            Integer editPoCostLength = EmptyUtil.isEmpty(editVO.getOrderCostList()) ? 0 : editVO.getOrderCostList().size();
            if (this.isFieldChange(() -> editPoCostLength, () -> infoPoCostLength)) {
                return false;
            }
            editVO.getOrderCostList().forEach(poCost -> {
                block3: {
                    block2: {
                        PcsPurchaseOrderCost editOrderCost = (PcsPurchaseOrderCost)infoPoCostMap.get(poCost.getCostType());
                        if (this.isFieldChange(() -> true, () -> NullUtil.isNotNull((Object)editOrderCost))) break block2;
                        if (this.isFieldChange(editOrderCost::getRate, poCost::getRate)) break block2;
                        if (!this.isFieldChange(editOrderCost::getAfterTaxesAmount, poCost::getAfterTaxesAmount)) break block3;
                    }
                    throw new PurchaseException("\u91c7\u8d2d\u5355\u8d39\u7528\u6709\u53d8\u66f4\uff01");
                }
            });
            Integer infoPoLineLength = EmptyUtil.isEmpty(info.getPcsPoLineVOList()) ? 0 : info.getPcsPoLineVOList().size();
            Integer editPoLineLength = EmptyUtil.isEmpty(editVO.getPcsPoLineVOList()) ? 0 : editVO.getPcsPoLineVOList().size();
            if (this.isFieldChange(() -> infoPoLineLength, () -> editPoLineLength)) {
                return false;
            }
            Map infoPoLineMap = info.getPcsPoLineVOList().stream().collect(Collectors.toMap(PcsPoLineVO::getSkuCode, Function.identity(), (v1, v2) -> v1));
            editVO.getPcsPoLineVOList().forEach(editPoLine -> {
                block2: {
                    block3: {
                        PcsPoLineVO infoPoLine = (PcsPoLineVO)infoPoLineMap.get(editPoLine.getSkuCode());
                        if (infoPoLine == null) break block2;
                        if (this.isFieldChange(() -> true, () -> NullUtil.isNotNull((Object)infoPoLine))) break block3;
                        if (this.isFieldChange(infoPoLine::getQuantity, editPoLine::getQuantity)) break block3;
                        if (this.isFieldChange(infoPoLine::getUnitPrice, editPoLine::getUnitPrice)) break block3;
                        if (!this.isFieldChange(infoPoLine::getTaxRate, editPoLine::getTaxRate)) break block2;
                    }
                    throw new PurchaseException("\u91c7\u8d2d\u5355\u884c\u6570\u636e\u6709\u53d8\u66f4\uff01");
                }
            });
        }
        catch (PurchaseException purchaseException) {
            return false;
        }
        return true;
    }

    private List<PcsPurchaseOrderCost> findPurchaseOrderCost(Long purchaseOrderId) {
        return this.pcsPurchaseOrderCostMapper.selectByPoId(purchaseOrderId);
    }

    private List<PcsPoPlanVO> findPcsPoPlanVOList(Long poId) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        PcsPoPlanExample.Criteria criteria = example.createCriteria();
        criteria.andPoIdEqualTo(poId);
        return BeanUtil.buildListFrom(this.pcsPoPlanMapper.selectByExample(example), PcsPoPlanVO.class);
    }

    private PcsPurchaseOrderVO findPurchaseOrderById(Long id) {
        PcsPurchaseOrder po = this.findPoById(id);
        PcsPurchaseOrderVO vo = null;
        if (NullUtil.isNotNull((Object)po)) {
            List<PcsPoLine> poLineList = this.pcsPoLineService.findPoLineByPoId(id);
            List poLineVOList = BeanUtil.buildListFrom(poLineList, PcsPoLineVO.class);
            List<PcsPurchaseOrderCost> poOrderCostList = this.findPurchaseOrderCost(id);
            vo = (PcsPurchaseOrderVO)BeanUtil.buildFrom((Object)po, PcsPurchaseOrderVO.class);
            vo.setPcsPoLineVOList(poLineVOList);
            vo.setOrderCostList(poOrderCostList);
        }
        return vo;
    }

    private boolean checkIsContainFreight(List<PcsPurchaseOrderCost> orderCostList) {
        if (orderCostList == null || orderCostList.size() == 0) {
            return false;
        }
        for (PcsPurchaseOrderCost pcsPurchaseOrderCost : orderCostList) {
            if (pcsPurchaseOrderCost.getCostType() != 3 || pcsPurchaseOrderCost.getAfterTaxesAmount() == null || new BigDecimal(0).compareTo(pcsPurchaseOrderCost.getAfterTaxesAmount()) >= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void computeTotalPrice(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, List<PcsPurchaseOrderCost> orderCostList) {
        PcsPoPlanCost sumPoPlanCost;
        BigDecimal totalAmount = new BigDecimal(0.0);
        BigDecimal totalTax = new BigDecimal(0.0);
        BigDecimal totalAmountAfterTax = new BigDecimal(0.0);
        BigDecimal otherFeeAfterTax = new BigDecimal(0.0);
        if (EmptyUtil.isNotEmpty(pcsPoLineList)) {
            for (PcsPoLine pcsPoLine : pcsPoLineList) {
                BigDecimal unitPrice = pcsPoLine.getUnitPrice();
                int quantity = pcsPoLine.getQuantity();
                BigDecimal taxRate = pcsPoLine.getTaxRate();
                taxRate = taxRate.add(new BigDecimal(1));
                BigDecimal unitPriceAfterTax = pcsPoLine.getUnitPrice().divide(taxRate, 4, 6);
                pcsPoLine.setTotalPrice(unitPrice.multiply(new BigDecimal(quantity)));
                totalAmount = totalAmount.add(pcsPoLine.getTotalPrice());
                pcsPoLine.setUnitPriceAfterTax(unitPriceAfterTax);
                pcsPoLine.setTotalPriceAfterTax(unitPriceAfterTax.multiply(new BigDecimal(quantity)));
                pcsPoLine.setTaxRate(pcsPoLine.getTaxRate());
                totalAmountAfterTax = totalAmountAfterTax.add(pcsPoLine.getTotalPriceAfterTax());
            }
            if (EmptyUtil.isNotEmpty(orderCostList)) {
                for (PcsPurchaseOrderCost pcsPurchaseOrderCost : orderCostList) {
                    totalAmount = totalAmount.add(pcsPurchaseOrderCost.getAfterTaxesAmount() == null ? BigDecimal.ZERO : pcsPurchaseOrderCost.getAfterTaxesAmount());
                    totalAmountAfterTax = totalAmountAfterTax.add(pcsPurchaseOrderCost.getPreTaxesAmount() == null ? BigDecimal.ZERO : pcsPurchaseOrderCost.getPreTaxesAmount());
                }
            }
            totalAmountAfterTax = totalAmountAfterTax.add(otherFeeAfterTax);
            totalTax = totalAmount.subtract(totalAmountAfterTax);
        }
        if (EmptyUtil.isNotEmpty((Object)pcsPurchaseOrder.getCrossBorderFlag()) && pcsPurchaseOrder.getCrossBorderFlag() == 0 && EmptyUtil.isNotEmpty((Object)pcsPurchaseOrder.getIncludeShipment()) && pcsPurchaseOrder.getIncludeShipment() == 0) {
            BigDecimal logisticsCost = pcsPurchaseOrder.getLogisticsCost() == null ? new BigDecimal(0.0) : pcsPurchaseOrder.getLogisticsCost();
            totalAmount = totalAmount.add(logisticsCost);
            pcsPurchaseOrder.setTotalAmount(totalAmount);
            pcsPurchaseOrder.setTotalAmountAfterTax(totalAmountAfterTax.add(logisticsCost));
        }
        pcsPurchaseOrder.setOtherFeeTaxRate(pcsPurchaseOrder.getOtherFeeTaxRate());
        Long poId = pcsPurchaseOrder.getId();
        BigDecimal purchaseCurrencyRate = pcsPurchaseOrder.getPurchaseCurrencyRate();
        if (poId != null && (sumPoPlanCost = this.pcsPoPlanCostMapper.sumPopFeeByPoId(poId)) != null) {
            totalAmount.add(sumPoPlanCost.getAfterTaxAmount().divide(purchaseCurrencyRate, 5));
            totalAmountAfterTax.add(sumPoPlanCost.getPreTaxAmount().divide(purchaseCurrencyRate, 5));
        }
        pcsPurchaseOrder.setTotalAmount(totalAmount);
        pcsPurchaseOrder.setTotalAmountAfterTax(totalAmountAfterTax);
    }

    @Override
    @Transactional
    public Boolean updatePurchaseOrderAndLine(List<PcsPoLine> pcsPoLineList, PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        PcsPurchaseOrder pcsPurchaseOrder = (PcsPurchaseOrder)BeanUtil.buildFrom((Object)pcsPurchaseOrderVO, PcsPurchaseOrder.class);
        pcsPurchaseOrder.setPurchaseCurrencyRate(pcsPurchaseOrderVO.getRate());
        Long poId = pcsPurchaseOrder.getId();
        List<Long> delLineIds = pcsPurchaseOrderVO.getDelLineIds();
        if (delLineIds != null && delLineIds.size() > 0) {
            this.deletePcsPoLine((long)poId, delLineIds);
        }
        PcsPurchaseOrderVO oldPcsPurchaseOrder = this.findPurchaseOrderById(poId);
        int passTimes = this.getPoPassApprovalTimes(poId);
        boolean saveDraft = this.checkPurchaseOrderApprovalFields(pcsPurchaseOrderVO, oldPcsPurchaseOrder, passTimes);
        List<PcsPurchaseOrderCost> orderCostList = pcsPurchaseOrderVO.getOrderCostList();
        List<PcsPurchaseOrderCost> oldOrderCostList = passTimes == 0 ? orderCostList : oldPcsPurchaseOrder.getOrderCostList();
        this.computeTotalPrice(pcsPurchaseOrder, pcsPoLineList, oldOrderCostList);
        if (pcsPoLineList.size() == 0) {
            throw new PurchaseException("PC0001", "\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u884c\u4fe1\u606f");
        }
        PcsPurchaseOrder newPcsPurchaseOrder = null;
        try {
            newPcsPurchaseOrder = (PcsPurchaseOrder)pcsPurchaseOrder.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        if (!saveDraft) {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
            pcsPurchaseOrder.setLastSubmitTime(new Date());
            this.checkSkuStatus(pcsPoLineList);
            List<PcsPoLine> oldPcsPoLineList = passTimes == 0 ? pcsPoLineList : this.pcsPoLineService.findPoLineByPoId(poId);
            this.computeTotalPrice(pcsPurchaseOrder, oldPcsPoLineList, oldOrderCostList);
            this.updatePurchaseOrderCosts(oldOrderCostList, pcsPurchaseOrder.getId());
            if (passTimes > 0) {
                pcsPurchaseOrder.setPurchaseCurrencyCode(null);
                pcsPurchaseOrder.setPurchaseCurrencyDesc(null);
                pcsPurchaseOrder.setPurchaseCurrencyRate(null);
            }
        } else {
            this.updatePurchaseOrderCosts(orderCostList, pcsPurchaseOrder.getId());
        }
        pcsPurchaseOrder.setIncludeShipment(this.checkIsContainFreight(oldOrderCostList) ? (short)0 : 1);
        Boolean update = this.update(pcsPurchaseOrder);
        if (update.booleanValue()) {
            if (saveDraft || passTimes == 0) {
                for (PcsPoLine pcsPoLine : pcsPoLineList) {
                    if (EmptyUtil.isEmpty((Object)pcsPoLine.getId())) {
                        pcsPoLine.setPoId(pcsPurchaseOrder.getId());
                        if (this.pcsPoLineService.create(pcsPoLine).compareTo(0L) >= 1) continue;
                        throw new PurchaseException("PC0009", "\u884c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + pcsPoLine.toString());
                    }
                    if (this.pcsPoLineService.update(pcsPoLine)) continue;
                    throw new PurchaseException("PC0010", "\u884c\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + pcsPoLine.toString());
                }
            }
            this.updatePoOtherAttachments(pcsPurchaseOrderVO.getOtherAttachmentList(), pcsPurchaseOrder.getId());
            if (!saveDraft) {
                newPcsPurchaseOrder.setPurchaseOrderStatus(oldPcsPurchaseOrder.getPurchaseOrderStatus());
                this.savePoAndLineApprovalRecord(newPcsPurchaseOrder, pcsPoLineList, orderCostList);
            }
            return true;
        }
        throw new PurchaseException("PC0010", "\u5934\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + pcsPurchaseOrder.toString());
    }

    private void checkSkuStatus(List<PcsPoLine> pcsPoLineList) {
        ArrayList<String> skuCodeList = new ArrayList<String>();
        for (PcsPoLine pcsPoLine : pcsPoLineList) {
            skuCodeList.add(pcsPoLine.getSkuCode());
        }
        Map map = this.mcPcsSkuService.mapAuditRecordsByCodeAndStatus(skuCodeList, PcsSkuSalesPriceChangeStatusEnum.COMPLETED_REVIEW.getStatus());
        Map skuDTOMap = this.mcPcsSkuService.mapSkuByCodes(skuCodeList);
        StringBuilder sb = new StringBuilder();
        for (String skuCode : skuCodeList) {
            PcsSkuVO skuDTO;
            if (!map.containsKey(skuCode)) {
                sb.append("[").append(skuCode).append("]").append(((PcsSkuVO)skuDTOMap.get(skuCode)).getNameCn()).append(",").append(PcsSkuStatusEnum.getDesc((int)((PcsSkuVO)skuDTOMap.get(skuCode)).getSkuStatus())).append("</br>");
            }
            if (0 != (skuDTO = (PcsSkuVO)skuDTOMap.get(skuCode)).getCanPurchase()) continue;
            sb.append("[").append(skuCode).append("]").append(skuDTO.getNameCn()).append(",").append("\u5df2\u7ecf\u505c\u6b62\u91c7\u8d2d\uff0c\u5982\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u91c7\u8d2d\u5458").append(skuDTO.getRealName()).append("</br>");
        }
        if (EmptyUtil.isNotEmpty((Object)sb)) {
            throw new PurchaseException("PC0001", "\u4ee5\u4e0bSKU\u672a\u5ba1\u6279\u901a\u8fc7\uff0c\u63d0\u4ea4\u5931\u8d25</br>" + sb.toString());
        }
    }

    private void sendNotice(String code) {
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("planner.Approval.Mobile");
        String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        if (toNotifyUsers != null && toNotifyUsers.length > 0) {
            ArrayList<MsgSingleVo> msgSingleVoList = new ArrayList<MsgSingleVo>();
            for (String mobile : toNotifyUsers) {
                MsgSingleVo msgSingleVo = new MsgSingleVo();
                msgSingleVo.setMsgTo(mobile);
                msgSingleVo.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684\u91c7\u8d2d\u5355\u9700\u8981\u5ba1\u6279\uff0c\u91c7\u8d2d\u5355code\uff1a" + code + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
                msgSingleVo.setMsgType(MsgTypeEnum.SmsMsg);
                msgSingleVo.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
                msgSingleVoList.add(msgSingleVo);
            }
            this.msgSendService.sendInterfaceVO(msgSingleVoList);
        }
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("planner.Approval.Email");
        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
        emailVO.setSubject("\u91c7\u8d2d\u5355\u5ba1\u6279");
        emailVO.setContent("\u60a8\u597d\uff0c\u60a8\u6709\u65b0\u7684\u91c7\u8d2d\u5355\u9700\u8981\u5ba1\u6279\uff0c\u91c7\u8d2d\u5355 code\uff1a" + code + "\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\uff0c\u8c22\u8c22\uff01");
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            EmailUtil.getInstance().send(emailVO);
        }
    }

    @Override
    public List<String> findWarehouseCodeGroup() {
        List<String> warehouseCodeList = this.pcsPurchaseOrderMapper.findWarehouseCodeGroup();
        if (CollectionUtils.isEmpty(warehouseCodeList)) {
            return Collections.emptyList();
        }
        return warehouseCodeList;
    }

    @Override
    public List<PcsPurchaseOrderVO> findPoInfoByWarehouseCodeGroup() {
        List<PcsPurchaseOrderVO> purchaseOrderVOs = this.pcsPurchaseOrderMapper.findPoInfoByWarehouseCodeGroup();
        if (CollectionUtils.isEmpty(purchaseOrderVOs)) {
            return Collections.emptyList();
        }
        return purchaseOrderVOs;
    }

    @Override
    @Transactional
    public Boolean auditPurchaseOrder(long id, Boolean isPass, Integer type) {
        PcsPurchaseOrderVO record = this.findPoVOForApprovalById(id, true);
        Integer poStatusBeforeAudit = record.getPurchaseOrderStatus();
        if (EmptyUtil.isNotEmpty((Object)record) && (record.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT) || record.getPurchaseOrderStatus() == 4 || record.getPurchaseOrderStatus() == 6)) {
            record.setAuditTime(new Date());
            if (isPass.booleanValue()) {
                if (type == 1) {
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                } else if (type == 2) {
                    if (poStatusBeforeAudit != PoStatusEnum.PURCHASE_ORDER_STATUS_WAITING_AUDIT.getKey()) {
                        throw new PurchaseException("PC0002", "\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u7684\u6700\u65b0\u72b6\u6001");
                    }
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_FINANCE_APPROVEL);
                } else if (type == 6) {
                    if (poStatusBeforeAudit != PoStatusEnum.PURCHASE_ORDER_STATUS_WAIT_FINANCE_APPROVEL.getKey()) {
                        throw new PurchaseException("PC0002", "\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u7684\u6700\u65b0\u72b6\u6001");
                    }
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                    List<PcsPoPlan> pcsPoPlanList = this.pcsPoPlanService.findPcsPoPlanByPoId(record.getId());
                    if (pcsPoPlanList != null && pcsPoPlanList.size() > 0) {
                        for (PcsPoPlan pcsPoPlan : pcsPoPlanList) {
                            if (pcsPoPlan.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_FINISHED) || pcsPoPlan.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_CLOSED)) continue;
                            record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE);
                            break;
                        }
                    }
                } else if (type == 0) {
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                }
            } else if (EmptyUtil.isNotEmpty((Object)record.getNewAskDeliveryDate())) {
                record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH);
            } else {
                record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT);
            }
            this.auditPoHandle(id, record);
            boolean update = this.update((PcsPurchaseOrder)BeanUtil.buildFrom((Object)record, PcsPurchaseOrder.class));
            if (update) {
                return true;
            }
            throw new PurchaseException("PC0010", "\u5ba1\u6838\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
        }
        throw new PurchaseException("PC0002", "\u5fc5\u987b\u662f\u5f85\u5ba1\u6838\u72b6\u6001");
    }

    private void auditPoLineHandle(PcsPoApprovalRecords newestApprovalRecord) {
        if (newestApprovalRecord != null) {
            List<PcsPoLineApprovalRecord> poLineApprovalRecords = this.pcsPoLineApprovalRecordMapper.selectByApprovalRecordId(newestApprovalRecord.getId());
            List pcsPoLineList = BeanUtil.buildListFrom(poLineApprovalRecords, PcsPoLineVO.class);
            if (pcsPoLineList == null || pcsPoLineList.size() == 0) {
                return;
            }
            for (PcsPoLineApprovalRecord poLineApprovalRecord : poLineApprovalRecords) {
                PcsPoLineVO pcsPoLineVO = (PcsPoLineVO)BeanUtil.buildFrom((Object)poLineApprovalRecord, PcsPoLineVO.class);
                if (poLineApprovalRecord.getPoLineId() == null) {
                    this.pcsPoLineService.create((PcsPoLine)BeanUtil.buildFrom((Object)poLineApprovalRecord, PcsPoLine.class));
                    continue;
                }
                pcsPoLineVO.setId(poLineApprovalRecord.getPoLineId());
                this.pcsPoLineService.update(pcsPoLineVO);
            }
        }
    }

    private void auditPoCostHandle(Long approvalRecordId) {
        List<PcsPurchaseOrderCost> pcsPurchaseOrderCosts = this.findPoCostApprovalRecords(approvalRecordId);
        for (PcsPurchaseOrderCost purchaseOrderCost : pcsPurchaseOrderCosts) {
            this.pcsPurchaseOrderCostMapper.updateByPoIdAndCostType(purchaseOrderCost);
        }
    }

    private void auditPoHandle(Long poId, PcsPurchaseOrderVO record) {
        Integer poApprovalStatus = record.getPurchaseOrderStatus();
        PcsPoApprovalRecords newestApprovalRecord = this.findNewestApprovalRecordsByPoId(poId);
        newestApprovalRecord.setPoApprovalStatus(poApprovalStatus);
        if (PoStatusEnum.PURCHASE_ORDER_STATUS_WAIT_RECEIVE.getKey().equals(poApprovalStatus)) {
            this.auditPoLineHandle(newestApprovalRecord);
            this.auditPoCostHandle(newestApprovalRecord.getId());
            newestApprovalRecord.setEffectiveTime(new Date());
            record.setPurchaseCurrencyRate(newestApprovalRecord.getPurchaseCurrencyRate());
            record.setPurchaseCurrencyCode(newestApprovalRecord.getPurchaseCurrencyCode());
            record.setPurchaseCurrencyDesc(newestApprovalRecord.getPurchaseCurrencyDesc());
        }
        this.pcsPoApprovalRecordsMapper.updateByPrimaryKeySelective(newestApprovalRecord);
    }

    @Override
    @Transactional
    public Boolean closePurchaseOrder(long id) {
        PcsPurchaseOrder record = this.findPoById(id);
        if (EmptyUtil.isNotEmpty((Object)record) && record.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE)) {
            record.setFinishedTime(new Date());
            record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH);
            boolean update = this.update(record);
            if (update) {
                String now;
                String po_Time;
                if (record.getPurchaseOrderCostCenter() != null && !(po_Time = DateFormatUtils.format((Date)record.getAskDeliveryDate(), (String)"yyyy-MM")).equals(now = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM"))) {
                    List<PcsPoLine> poLineList = this.pcsPoLineService.findPoLineByPoId(id);
                    List<PcsPoPlanLine> poPlanLineList = this.pcsPoPlanLineService.findPoPlanLineByPoId(id);
                    BigDecimal poLineSum = BigDecimal.ZERO;
                    BigDecimal poPlanLineSum = BigDecimal.ZERO;
                    for (PcsPoLine poLine : poLineList) {
                        poLineSum = poLineSum.add(poLine.getUnitPriceAfterTax().multiply(new BigDecimal(poLine.getQuantity())));
                    }
                    for (PcsPoPlanLine poPlanLine : poPlanLineList) {
                        BigDecimal q = poPlanLine.getQuantity() == null ? BigDecimal.ZERO : new BigDecimal(poPlanLine.getQuantity());
                        BigDecimal wq = poPlanLine.getWasteQuantity() == null ? BigDecimal.ZERO : new BigDecimal(poPlanLine.getWasteQuantity());
                        poPlanLineSum = poPlanLineSum.add(poPlanLine.getUnitPrice().multiply(q.add(wq)));
                    }
                    if (poPlanLineSum.intValue() != 0 && EmptyUtil.isNotEmpty((Object)record.getPurchaseCurrencyRate())) {
                        BigDecimal extra_cost = poLineSum.subtract(poPlanLineSum).multiply(record.getPurchaseCurrencyRate());
                        extra_cost = extra_cost.setScale(2, 4);
                        Integer budgetYear = Integer.parseInt(now.substring(0, 4));
                        Integer budgetMonth = Integer.parseInt(now.substring(now.length() - 2, now.length()));
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("budgetYear", budgetYear);
                        params.put("budgetMonth", budgetMonth);
                        params.put("categoryId", record.getPurchaseOrderCostCenter());
                        List<OpFinanceBudget> budgets = this.pcsPurchaseOrderMapper.findOpFinanceBudgetByParams(params);
                        if (CollectionUtils.isEmpty(budgets)) {
                            OpFinanceBudget budget = new OpFinanceBudget();
                            budget.setBudgetMonth(budgetMonth);
                            budget.setBudgetYear(budgetYear);
                            budget.setCategoryId(record.getPurchaseOrderCostCenter());
                            budget.setCreateTime(new Date());
                            budget.setExtraBudget(extra_cost);
                            budget.setTotalBudget(extra_cost);
                            this.pcsPurchaseOrderMapper.insertOpFinanceBudget(budget);
                        } else {
                            OpFinanceBudget budget = budgets.get(0);
                            BigDecimal extraBudget = budget.getExtraBudget() == null ? BigDecimal.ZERO : budget.getExtraBudget();
                            budget.setExtraBudget(extraBudget.add(extra_cost));
                            budget.setTotalBudget(budget.getTotalBudget().add(extra_cost));
                            this.pcsPurchaseOrderMapper.updateOpFinanceBudget(budget);
                        }
                    }
                }
                return true;
            }
            throw new PurchaseException("PC0010", "\u5173\u95ed\u91c7\u8d2d\u5355\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
        }
        throw new PurchaseException("PC0002", "\u5f85\u6536\u8d27\u7684\u91c7\u8d2d\u5355\u624d\u80fd\u6574\u5355\u5173\u95ed\uff01");
    }

    @Override
    @Transactional
    public Boolean deletePcsPoLine(long poId, long pcsPoLineId) {
        PcsPurchaseOrder pcsPurchaseOrder = this.findPoById(poId);
        if (EmptyUtil.isNotEmpty((Object)pcsPurchaseOrder) && EmptyUtil.isNotEmpty((Object)pcsPurchaseOrder.getPurchaseOrderStatus()) && (pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT) || pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT))) {
            PcsPoLine pcsPoLine = this.pcsPoLineService.findPoLineById(pcsPoLineId);
            if (EmptyUtil.isNotEmpty((Object)pcsPoLine) && EmptyUtil.isNotEmpty((Object)pcsPoLine.getPoId()) && pcsPoLine.getPoId().equals(poId)) {
                return this.pcsPoLineService.deleteById(pcsPoLineId);
            }
            throw new PurchaseException("PC0002", "\u884cId\u5f02\u5e38");
        }
        throw new PurchaseException("PC0002", "\u53ea\u6709\u5f85\u4fee\u6539\u72b6\u6001\u7684\u91c7\u8d2d\u5355\u53ef\u4ee5\u5220\u51cf\u884c\u4fe1\u606f");
    }

    @Override
    public int deletePcsPoLine(long poId, List<Long> delLineIds) {
        delLineIds.stream().forEach(pcsPoLineId -> this.deletePcsPoLine(poId, (long)pcsPoLineId));
        return 0;
    }

    @Override
    @Transactional
    public Boolean batchUpdatePcsPoLine(PcsPurchaseOrderVO pcsPoVO, Long operatorId) {
        PcsPurchaseOrder pcsPurchaseOrder = this.findPoById(pcsPoVO.getId());
        if (EmptyUtil.isEmpty((Object)pcsPurchaseOrder)) {
            throw new PurchaseException("PC0002", "\u5339\u914d\u4e0d\u5230\u91c7\u8d2d\u5355");
        }
        List<PcsPoLineVO> pcsPoLineVOs = pcsPoVO.getPcsPoLineVOList();
        if (EmptyUtil.isEmpty(pcsPoLineVOs)) {
            throw new PurchaseException("PC0002", "\u5339\u914d\u4e0d\u5230\u91c7\u8d2d\u5355\u884c\u4fe1\u606f");
        }
        for (PcsPoLineVO pcsPoLineVO : pcsPoLineVOs) {
            if (EmptyUtil.isNotEmpty((Object)pcsPoLineVO.getId())) {
                PcsCostAdjustExample example = new PcsCostAdjustExample();
                PcsCostAdjustExample.Criteria criteria = example.createCriteria();
                criteria.andCostTypeEqualTo(PcsCostAdjust.COST_TYPE_SKU);
                criteria.andCostIdEqualTo(pcsPoLineVO.getId());
                example.setOrderByClause("ADJUST_TIME desc");
                List<PcsCostAdjust> pcsCostAdjustList = this.pcsCostAdjustMapper.selectByExample(example);
                BigDecimal lastAjustAfterTaxAmount = BigDecimal.ZERO;
                PcsCostAdjust pcsCostAdjust = new PcsCostAdjust();
                if (pcsCostAdjustList != null && pcsCostAdjustList.size() > 0) {
                    PcsCostAdjust lastPcsCostAdjust = pcsCostAdjustList.get(0);
                    lastAjustAfterTaxAmount = lastPcsCostAdjust.getAdjustAfterTaxAmount();
                    pcsCostAdjust.setOldUnitPricePreTax(lastPcsCostAdjust.getAdjustUnitPricePreTax());
                } else {
                    PcsPoLine pcsPoLine = this.pcsPoLineService.findPoLineById(pcsPoLineVO.getId());
                    if (pcsPoLine != null) {
                        lastAjustAfterTaxAmount = pcsPoLine.getUnitPrice().multiply(pcsPurchaseOrder.getPurchaseCurrencyRate()).setScale(4, 6);
                        BigDecimal unitPricePreTax = pcsPoLine.getUnitPrice().divide(pcsPoLine.getTaxRate().add(new BigDecimal(1)), 4, 6);
                        BigDecimal unitPricePreTaxRmb = unitPricePreTax.multiply(pcsPurchaseOrder.getPurchaseCurrencyRate()).setScale(4, 6);
                        pcsCostAdjust.setOldUnitPricePreTax(unitPricePreTaxRmb);
                    }
                }
                pcsCostAdjust.setCostId(pcsPoLineVO.getId());
                pcsCostAdjust.setCostType(PcsCostAdjust.COST_TYPE_SKU);
                pcsCostAdjust.setAdjustActualTaxrate(pcsPoLineVO.getAdjustTaxRate());
                pcsCostAdjust.setAdjustAfterTaxAmount(pcsPoLineVO.getAdjustUnitPrice());
                BigDecimal preTaxAmount = pcsPoLineVO.getAdjustUnitPrice().divide(pcsPoLineVO.getAdjustTaxRate().add(new BigDecimal(1)), 4, 6);
                pcsCostAdjust.setAdjustPreTaxAmount(preTaxAmount);
                pcsCostAdjust.setAdjustPersonId(operatorId);
                pcsCostAdjust.setAdjustTime(Calendar.getInstance().getTime());
                BigDecimal range = pcsPoLineVO.getAdjustUnitPrice().subtract(lastAjustAfterTaxAmount).setScale(4, 6);
                pcsCostAdjust.setAdjustAmountRange(range);
                pcsCostAdjust.setSkuCode(pcsPoLineVO.getSkuCode());
                pcsCostAdjust.setPoCode(pcsPurchaseOrder.getCode());
                pcsCostAdjust.setAdjustUnitPricePreTax(pcsPoLineVO.getAdjustUnitPrice().divide(pcsPoLineVO.getAdjustTaxRate().add(new BigDecimal(1)), 4, 6));
                this.pcsCostAdjustMapper.insertSelective(pcsCostAdjust);
                pcsPoLineVO.setSkuCode(null);
                if (this.pcsPoLineService.update(pcsPoLineVO)) continue;
                throw new PurchaseException("PC0010", "\u884c\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + pcsPoLineVO.toString());
            }
            throw new PurchaseException("PC0009", "\u5339\u914d\u4e0d\u5230\u91c7\u8d2d\u5355\u884c\u4fe1\u606f," + pcsPoLineVO.toString());
        }
        return true;
    }

    @Override
    @Transactional
    public void processReceicePlan(String poPlanCode, Map<String, Integer> liangpinMap, Map<String, Integer> canciMap) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andCodeEqualTo(poPlanCode);
        List<PcsPoPlan> pcsPoPlanList = this.pcsPoPlanMapper.selectByExample(example);
        if (pcsPoPlanList != null && pcsPoPlanList.size() > 0) {
            PcsPoPlan pcsPoPlan = pcsPoPlanList.get(0);
            pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_FINISHED);
            pcsPoPlan.setReceiveDate(new Date());
            this.pcsPoPlanMapper.updateByPrimaryKey(pcsPoPlan);
            List<PcsPoPlanLine> pcsPoPlanLineList = this.pcsPoPlanLineService.findPoPlanLineByPoPlanId(pcsPoPlan.getId());
            for (PcsPoPlanLine pcsPoPlanLine : pcsPoPlanLineList) {
                pcsPoPlanLine.setQuantity(liangpinMap.get(pcsPoPlanLine.getSkuCode()));
                pcsPoPlanLine.setWasteQuantity(canciMap.get(pcsPoPlanLine.getSkuCode()));
                this.pcsPoPlanLineService.update(pcsPoPlanLine);
            }
            int result = this.pcsPoPlanMapper.isAllReceivePo(pcsPoPlan.getPoId());
            if (result <= 0) {
                PcsPurchaseOrder purchaseOrder = this.pcsPurchaseOrderMapper.selectByPrimaryKey(pcsPoPlan.getPoId());
                if (purchaseOrder != null) {
                    purchaseOrder.setFinishedTime(Calendar.getInstance().getTime());
                    purchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH);
                    this.pcsPurchaseOrderMapper.updateByPrimaryKey(purchaseOrder);
                }
            } else {
                PcsPurchaseOrder purchaseOrder;
                int allPoPlanFinished = this.pcsPoPlanMapper.isAllPoPlanFinished(pcsPoPlan.getPoId());
                if (allPoPlanFinished == 0 && (purchaseOrder = this.pcsPurchaseOrderMapper.selectByPrimaryKey(pcsPoPlan.getPoId())) != null) {
                    purchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                    this.pcsPurchaseOrderMapper.updateByPrimaryKey(purchaseOrder);
                }
            }
        }
    }

    @Override
    public boolean updatePurchaseOrder(PcsPurchaseOrder record) {
        return this.pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public long countByCond(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderMapper.countByCond(cond);
    }

    @Override
    public PcsPurchaseReturn bulidFromVO(PcsPurchaseReturnVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsPurchaseReturn record = new PcsPurchaseReturn();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsPurchaseReturnSku bulidFromVO(PcsPurchaseReturnSkuVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsPurchaseReturnSku record = new PcsPurchaseReturnSku();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    @Transactional
    public Long createPurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList, boolean saveDraft) throws Exception {
        pcsPurchaseReturn.setCreateTime(new Date());
        pcsPurchaseReturn.setAvailable(true);
        if (saveDraft) {
            pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_DRAFT);
        } else {
            pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_WAITING_AUDIT);
        }
        Long purchaseReturnId = this.savePurchaseReturnAndLine(pcsPurchaseReturn, returnSkuVOList);
        if (!saveDraft) {
            PcsPurchaseReturnVO pcsPurchaseReturnVO = this.findPRVOById(pcsPurchaseReturn.getId(), true);
            ArrayList<WhCommandSkuVO> whCommandSkuList = new ArrayList<WhCommandSkuVO>();
            for (PcsPurchaseReturnSkuVO pcsPurchaseReturnSkuVO : pcsPurchaseReturnVO.getReturnSkuVOList()) {
                WhCommandSkuVO whCommandSku = new WhCommandSkuVO();
                whCommandSku.setSkuCode(pcsPurchaseReturnSkuVO.getSkuCode());
                whCommandSku.setPlanedQuantity(pcsPurchaseReturnSkuVO.getExpectedQuantity());
                whCommandSkuList.add(whCommandSku);
            }
            WhCommandVO whCommandOut = new WhCommandVO();
            whCommandOut.setReferenceCode(pcsPurchaseReturnVO.getCode());
            whCommandOut.setInOutType(SStockInOutTypeEnum.OUT_TYPE_PURCHASE_RETURN.getCode());
            whCommandOut.setExpressType(Integer.valueOf(Integer.parseInt(pcsPurchaseReturn.getExpressType() + "")));
            whCommandOut.setPlanedDeliveryDate(DateUtil.getNow());
            whCommandOut.setWarehouseCode(pcsPurchaseReturnVO.getWarehouseCode());
            whCommandOut.setPhysicalWarehouseCode(pcsPurchaseReturnVO.getTargetWarehouse());
            whCommandOut.setWhCommandSkuList(whCommandSkuList);
            this.checkSkuStock(whCommandOut);
            this.wWhCommandService.createCommand(whCommandOut);
        }
        return purchaseReturnId;
    }

    private Long savePurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList) {
        if (EmptyUtil.isNotEmpty(returnSkuVOList)) {
            this.pcsPurchaseReturnMapper.insertSelective(pcsPurchaseReturn);
            Long purchaseReturnId = pcsPurchaseReturn.getId();
            pcsPurchaseReturn.setCode(this.generateReturnCode(purchaseReturnId));
            this.updatePurchaseReturn(pcsPurchaseReturn);
            if (EmptyUtil.isNotEmpty(returnSkuVOList)) {
                for (PcsPurchaseReturnSku pcsPurchaseReturnSku : returnSkuVOList) {
                    pcsPurchaseReturnSku.setPurchaseReturnId(purchaseReturnId);
                    this.pcsPurchaseReturnSkuMapper.insertSelective(pcsPurchaseReturnSku);
                    pcsPurchaseReturnSku.setCode(this.generateReturnLineCode(pcsPurchaseReturnSku.getId(), pcsPurchaseReturn.getCode()));
                    this.pcsPurchaseReturnSkuMapper.updateByPrimaryKeySelective(pcsPurchaseReturnSku);
                }
            }
            return purchaseReturnId;
        }
        return 0L;
    }

    private List<PcsPurchaseReturnSku> getSkuVOList(List<PcsPurchaseReturnSku> returnSkuVOList, boolean flag) {
        ArrayList<PcsPurchaseReturnSku> lineList = new ArrayList<PcsPurchaseReturnSku>();
        for (PcsPurchaseReturnSku pcsPurchaseReturnSku : returnSkuVOList) {
            if (flag && pcsPurchaseReturnSku.getSkuType() == 1) {
                lineList.add(pcsPurchaseReturnSku);
            }
            if (flag || pcsPurchaseReturnSku.getSkuType() != 0) continue;
            lineList.add(pcsPurchaseReturnSku);
        }
        return lineList;
    }

    @Override
    @Transactional
    public Boolean updatePurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList, boolean saveDraft) throws Exception {
        PcsPurchaseReturnVO pcsPurchaseReturnVO = this.findPRVOById(pcsPurchaseReturn.getId(), true);
        if (!saveDraft) {
            pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_WAITING_AUDIT);
        }
        this.updatePurchaseReturn(pcsPurchaseReturn);
        if (EmptyUtil.isNotEmpty(returnSkuVOList)) {
            List<PcsPurchaseReturnSkuVO> hisLine = pcsPurchaseReturnVO.getReturnSkuVOList();
            for (PcsPurchaseReturnSkuVO pcsPurchaseReturnSkuVO : hisLine) {
                Long lineId = pcsPurchaseReturnSkuVO.getId();
                boolean isDel = true;
                for (PcsPurchaseReturnSku pcsPurchaseReturnSku : returnSkuVOList) {
                    if (!lineId.equals(pcsPurchaseReturnSku.getId())) continue;
                    isDel = false;
                }
                if (!isDel) continue;
                this.pcsPurchaseReturnSkuMapper.deleteByPrimaryKey(lineId);
            }
            for (PcsPurchaseReturnSku pcsPurchaseReturnSku : returnSkuVOList) {
                if (pcsPurchaseReturnSku.getId() != null) {
                    this.pcsPurchaseReturnSkuMapper.updateByPrimaryKeySelective(pcsPurchaseReturnSku);
                    continue;
                }
                pcsPurchaseReturnSku.setPurchaseReturnId(pcsPurchaseReturn.getId());
            }
        }
        if (!saveDraft) {
            pcsPurchaseReturnVO = this.findPRVOById(pcsPurchaseReturn.getId(), true);
            ArrayList<WhCommandSkuVO> whCommandSkuList = new ArrayList<WhCommandSkuVO>();
            for (PcsPurchaseReturnSkuVO pcsPurchaseReturnSkuVO : pcsPurchaseReturnVO.getReturnSkuVOList()) {
                WhCommandSkuVO whCommandSku = new WhCommandSkuVO();
                whCommandSku.setSkuCode(pcsPurchaseReturnSkuVO.getSkuCode());
                whCommandSku.setPlanedQuantity(pcsPurchaseReturnSkuVO.getExpectedQuantity());
                whCommandSkuList.add(whCommandSku);
            }
            WhCommandVO whCommandOut = new WhCommandVO();
            whCommandOut.setReferenceCode(pcsPurchaseReturnVO.getCode());
            whCommandOut.setInOutType(WhCommandVO.TYPE_PURCHASE_RETURN_OUT);
            whCommandOut.setExpressType(Integer.valueOf(Integer.parseInt(pcsPurchaseReturn.getExpressType() + "")));
            whCommandOut.setPlanedDeliveryDate(DateUtil.getNow());
            whCommandOut.setWarehouseCode(pcsPurchaseReturnVO.getWarehouseCode());
            whCommandOut.setPhysicalWarehouseCode(pcsPurchaseReturnVO.getTargetWarehouse());
            whCommandOut.setWhCommandSkuList(whCommandSkuList);
            this.checkSkuStock(whCommandOut);
            String string = this.wWhCommandService.createCommand(whCommandOut);
        }
        return null;
    }

    private void checkSkuStock(WhCommandVO whCommand) {
        PhyWhStockCond phyWhStockCond = new PhyWhStockCond();
        phyWhStockCond.setPhysicalWarehouseCode(whCommand.getPhysicalWarehouseCode());
        WhWarehouseVO whWarehouse = this.sWhInfoService.findWarehouseByCode(whCommand.getWarehouseCode());
        phyWhStockCond.setSkuStatus(whWarehouse.getCommodityStatus());
        for (WhCommandSkuVO commandSku : whCommand.getWhCommandSkuList()) {
            WhInvVO whInvVO = this.sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode(commandSku.getSkuCode(), whCommand.getWarehouseCode());
            if (commandSku.getPlanedQuantity() > whInvVO.getCanUseInv()) {
                throw new PurchaseException("", "SKU[" + commandSku.getSkuCode() + "]," + WhWarehouseVO.getSkuStatusName((Integer)whWarehouse.getCommodityStatus()) + ",\u5728[" + whWarehouse.getName() + "]\u4e2d\u7684\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3");
            }
            phyWhStockCond.setSkuCode(commandSku.getSkuCode());
            int physicalSkuStockCount = this.findPhysicalSkuStock(phyWhStockCond);
            if (commandSku.getPlanedQuantity() <= physicalSkuStockCount) continue;
            throw new PurchaseException("", "\u7269\u7406\u4ed3\u5e93\u5b58\u4e0d\u8db3\uff0cSKU[" + commandSku.getSkuCode() + "],\u5546\u54c1\u72b6\u6001[" + WhWarehouseVO.getSkuStatusName((Integer)phyWhStockCond.getSkuStatus()) + "]\u7269\u7406\u4ed3[" + phyWhStockCond.getPhysicalWarehouseCode() + "]\uff0c\u9700\u6263\u51cf\u6570[" + commandSku.getPlanedQuantity() + "]>\u5f53\u524d\u5e93\u5b58\u6570[" + physicalSkuStockCount + "]");
        }
    }

    private int findPhysicalSkuStock(PhyWhStockCond cond) {
        List phyWhStockVOs = this.sWhWmsSkuStockService.findPhyWhStockByCond(cond);
        if (CollectionUtils.isEmpty((Collection)phyWhStockVOs)) {
            return 0;
        }
        return ((PhyWhStockVO)phyWhStockVOs.get(0)).getCanUseQuantity();
    }

    public String generateReturnCode(Object id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_PURCHASE_RETURN", params);
        return code;
    }

    public String generateReturnLineCode(Object id, String pcsPurchaseReturnCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("pcsPurchaseReturnCode", pcsPurchaseReturnCode);
        String code = CodeGenerator.getInstance().generate("PCS_PURCHASE_RETURN_LINE", params);
        return code;
    }

    @Override
    public Boolean updatePurchaseReturn(PcsPurchaseReturn pcsPurchaseReturn) {
        return this.pcsPurchaseReturnMapper.updateByPrimaryKeySelective(pcsPurchaseReturn) == 1;
    }

    @Override
    public List<PcsPurchaseReturnVO> findPRVOByCond(PcsPurchaseReturnCond cond) {
        return this.pcsPurchaseReturnMapper.findPRVOByCond(cond);
    }

    @Override
    public Integer countPRVOByCond(PcsPurchaseReturnCond cond) {
        return this.pcsPurchaseReturnMapper.countRVOByCond(cond);
    }

    @Override
    public PcsPurchaseReturnVO findPRVOById(Long id, boolean withLine) {
        PcsPurchaseReturnVO pcsPurchaseReturnVO = this.pcsPurchaseReturnMapper.findPRVOById(id);
        if (EmptyUtil.isNotEmpty((Object)pcsPurchaseReturnVO) && withLine) {
            PcsPurchaseReturnSku cond = new PcsPurchaseReturnSku();
            cond.setPurchaseReturnId(id);
            cond.setPoId(pcsPurchaseReturnVO.getPoId());
            List<PcsPurchaseReturnSkuVO> lineList = this.pcsPurchaseReturnSkuMapper.findPrLineByCond(cond);
            pcsPurchaseReturnVO.setReturnSkuVOList(lineList);
        }
        return pcsPurchaseReturnVO;
    }

    @Override
    public List<PcsPurchaseReturnSkuVO> findPrLineByCond(PcsPurchaseReturnSku cond) {
        return this.pcsPurchaseReturnSkuMapper.findPrLineByCond(cond);
    }

    @Override
    public Boolean auditPurchaseReturn(CommAudit commAudit) throws Exception {
        PcsPurchaseReturn pcsPurchaseReturn = new PcsPurchaseReturn();
        pcsPurchaseReturn.setId(Long.valueOf(commAudit.getId()));
        if (commAudit.getIsPass().booleanValue()) {
            pcsPurchaseReturn.setAuditTime(new Date());
            pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_WAITING_SEND);
        } else {
            PcsPurchaseReturnVO pcsPurchaseReturnVO = this.findPRVOById(pcsPurchaseReturn.getId(), false);
            this.wWhCommandService.cancelCommandByTypeAndReferenceCode(Integer.valueOf(28), pcsPurchaseReturnVO.getCode());
            pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_REJECT);
        }
        return this.updatePurchaseReturn(pcsPurchaseReturn);
    }

    @Override
    public Boolean closePurchaseReturn(Long id) {
        PcsPurchaseReturn pcsPurchaseReturn = new PcsPurchaseReturn();
        pcsPurchaseReturn.setId((long)id);
        pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_CANCLE);
        PcsPurchaseReturnVO pcsPurchaseReturnVO = this.findPRVOById(pcsPurchaseReturn.getId(), true);
        WhCommandVO whCommand = this.wWhCommandService.findCommandByTypeAndReferenceCode(Integer.valueOf(28), pcsPurchaseReturnVO.getCode(), false);
        if (whCommand != null) {
            if (whCommand.getCommandStatus() != 0 && whCommand.getCommandStatus() != 1) {
                throw new PurchaseException("PC0002", "\u5df2\u7ecf\u6ce2\u6b21\u542f\u52a8\u4e0d\u80fd\u53d6\u6d88\uff01");
            }
            this.wWhCommandService.cancelCommandByTypeAndReferenceCode(Integer.valueOf(28), pcsPurchaseReturnVO.getCode());
        }
        return this.updatePurchaseReturn(pcsPurchaseReturn);
    }

    @Override
    public List<PcsPurchaseOrderVO> findPOVOBySupplierId(Long supplierId) {
        return this.pcsPurchaseOrderMapper.findPOVOBySupplierId(supplierId);
    }

    @Override
    public List<PcsPoLineVO> findFinancePoLineVOByParams(Map<String, Object> params) {
        return this.pcsPurchaseOrderMapper.findFinancePoLineVOByParams(params);
    }

    @Override
    public List<PcsPurchaseOrderVO> findPoCostById(Long id) {
        return this.pcsPurchaseOrderMapper.findPoCostById(id);
    }

    @Override
    public List<Long> createPurchaseOrderCosts(List<PcsPurchaseOrderCost> orderCostList, Long poId) {
        if (EmptyUtil.isNotEmpty(orderCostList)) {
            for (PcsPurchaseOrderCost pcsPurchaseOrderCost : orderCostList) {
                pcsPurchaseOrderCost.setPoId(poId);
                pcsPurchaseOrderCost.setCreateTime(new Date());
                this.pcsPurchaseOrderCostMapper.insertSelective(pcsPurchaseOrderCost);
            }
        }
        return null;
    }

    @Override
    public List<Long> updatePurchaseOrderCosts(List<PcsPurchaseOrderCost> orderCostList, Long poId) {
        if (EmptyUtil.isNotEmpty(orderCostList)) {
            for (PcsPurchaseOrderCost pcsPurchaseOrderCost : orderCostList) {
                pcsPurchaseOrderCost.setPoId(poId);
                this.pcsPurchaseOrderCostMapper.updateByPrimaryKeySelective(pcsPurchaseOrderCost);
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean batchUpdatePcsPoCost(PcsPoPlanCostVO pcsPoCostVO, Long operatorId) {
        PcsPurchaseOrder pcsPurchaseOrder = this.findPoById(pcsPoCostVO.getId());
        if (EmptyUtil.isEmpty((Object)pcsPurchaseOrder)) {
            throw new PurchaseException("PC0002", "\u5339\u914d\u4e0d\u5230\u91c7\u8d2d\u5355");
        }
        List<PcsCostAdjust> pcsPoCosts = pcsPoCostVO.getPcsCostAdjustList();
        if (EmptyUtil.isEmpty(pcsPoCosts)) {
            throw new PurchaseException("PC0002", "\u5339\u914d\u4e0d\u5230\u91c7\u8d2d\u5355\u8d39\u7528");
        }
        Date adjustTime = Calendar.getInstance().getTime();
        for (PcsCostAdjust pcsPoCost : pcsPoCosts) {
            if (EmptyUtil.isNotEmpty((Object)pcsPoCost.getCostId())) {
                PcsPoPlanCost pcsPoPlanCost;
                PcsCostAdjustExample example = new PcsCostAdjustExample();
                PcsCostAdjustExample.Criteria criteria = example.createCriteria();
                criteria.andCostTypeEqualTo(pcsPoCost.getCostType());
                criteria.andCostIdEqualTo(pcsPoCost.getCostId());
                example.setOrderByClause(" ADJUST_TIME desc");
                List<PcsCostAdjust> pcsCostAdjustList = this.pcsCostAdjustMapper.selectByExample(example);
                BigDecimal diffAmountTaxPre = pcsPoCost.getAdjustPreTaxAmount();
                BigDecimal diffAmountTaxAfter = pcsPoCost.getAdjustAfterTaxAmount();
                if (pcsCostAdjustList != null && pcsCostAdjustList.size() > 0) {
                    PcsCostAdjust realPcsCostAdjust = pcsCostAdjustList.get(0);
                    diffAmountTaxPre = pcsPoCost.getAdjustPreTaxAmount().subtract(realPcsCostAdjust.getAdjustPreTaxAmount());
                    diffAmountTaxAfter = pcsPoCost.getAdjustAfterTaxAmount().subtract(realPcsCostAdjust.getAdjustAfterTaxAmount());
                    if (pcsPoCost.getCostType().equals(PcsCostAdjust.COST_TYPE_POP)) {
                        if (realPcsCostAdjust.getPopCode() != null) {
                            pcsPoCost.setPopCode(realPcsCostAdjust.getPopCode());
                        } else {
                            PcsPoPlan pcsPoPlan;
                            PcsPoPlanCost pcsPoPlanCost2 = this.pcsPoPlanCostMapper.selectByPrimaryKey(pcsPoCost.getCostId());
                            if (pcsPoPlanCost2 != null && pcsPoPlanCost2.getPoPlanId() != null && (pcsPoPlan = this.pcsPoPlanMapper.selectByPrimaryKey(Long.parseLong(pcsPoPlanCost2.getPoPlanId().toString()))) != null) {
                                pcsPoCost.setPopCode(pcsPoPlan.getCode());
                            }
                        }
                    }
                } else if (pcsPoCost.getCostType().equals(PcsCostAdjust.COST_TYPE_PO)) {
                    PcsPurchaseOrderCost pcsPurchaseOrderCost = this.pcsPurchaseOrderCostMapper.selectByPrimaryKey(pcsPoCost.getCostId());
                    if (pcsPurchaseOrderCost != null) {
                        BigDecimal rmbRate = pcsPurchaseOrder.getPurchaseCurrencyRate().add(new BigDecimal(0));
                        BigDecimal preTaxesAmountRmb = BigDecimal.ZERO;
                        if (NullUtil.isNotNull((Object)preTaxesAmountRmb)) {
                            preTaxesAmountRmb = pcsPurchaseOrderCost.getPreTaxesAmount().multiply(rmbRate).setScale(4, RoundingMode.HALF_UP);
                        }
                        diffAmountTaxPre = pcsPoCost.getAdjustPreTaxAmount().subtract(preTaxesAmountRmb);
                        BigDecimal diffAmountTaxAfterRmb = BigDecimal.ZERO;
                        if (NullUtil.isNotNull((Object)pcsPurchaseOrderCost.getAfterTaxesAmount())) {
                            diffAmountTaxAfterRmb = pcsPurchaseOrderCost.getAfterTaxesAmount().multiply(rmbRate).setScale(4, RoundingMode.HALF_UP);
                        }
                        diffAmountTaxAfter = pcsPoCost.getAdjustAfterTaxAmount().subtract(diffAmountTaxAfterRmb);
                    }
                } else if (pcsPoCost.getCostType().equals(PcsCostAdjust.COST_TYPE_POP) && (pcsPoPlanCost = this.pcsPoPlanCostMapper.selectByPrimaryKey(pcsPoCost.getCostId())) != null && pcsPoPlanCost.getPoPlanId() != null) {
                    PcsPoPlan pcsPoPlan = this.pcsPoPlanMapper.selectByPrimaryKey(Long.parseLong(pcsPoPlanCost.getPoPlanId().toString()));
                    if (pcsPoPlan != null) {
                        pcsPoCost.setPopCode(pcsPoPlan.getCode());
                    }
                    diffAmountTaxPre = pcsPoCost.getAdjustPreTaxAmount().subtract(pcsPoPlanCost.getPreTaxAmount() == null ? new BigDecimal(0) : pcsPoPlanCost.getPreTaxAmount());
                    diffAmountTaxAfter = pcsPoCost.getAdjustAfterTaxAmount().subtract(pcsPoPlanCost.getAfterTaxAmount() == null ? new BigDecimal(0) : pcsPoPlanCost.getAfterTaxAmount());
                }
                pcsPoCost.setDiffAmountTaxPre(diffAmountTaxPre);
                pcsPoCost.setDiffAmountTaxAfter(diffAmountTaxAfter);
                pcsPoCost.setPoCode(pcsPurchaseOrder.getCode());
                pcsPoCost.setAdjustTime(adjustTime);
                pcsPoCost.setAdjustPersonId(operatorId);
                if (this.pcsCostAdjustMapper.insertSelective(pcsPoCost) >= 0) continue;
                throw new PurchaseException("PC0010", "\u91c7\u8d2d\u5355\u8d39\u7528\u66f4\u65b0\u5931\u8d25," + pcsPoCost.toString());
            }
            throw new PurchaseException("PC0009", "\u5339\u914d\u4e0d\u5230\u91c7\u8d2d\u5355\u8d39\u7528\u4fe1\u606f," + pcsPoCost.toString());
        }
        return true;
    }

    @Override
    public List<PcsCostAdjust> findCostAjustByCostIds(List<Long> costIds, Integer costType) {
        if (EmptyUtil.isEmpty(costIds) || NullUtil.isNull((Object)costType)) {
            return new ArrayList<PcsCostAdjust>();
        }
        PcsCostAdjustExample example = new PcsCostAdjustExample();
        example.createCriteria().andCostIdIn((List)costIds).andCostTypeEqualTo(costType);
        return this.pcsCostAdjustMapper.selectByExample(example);
    }

    @Override
    public List<PurchaseSellStockReportVO> findPssReportByCond(PcsPurchaseOrderCond cond) {
        return this.purchaseSellStockReportMapper.findPssReportByCond(cond);
    }

    @Override
    public List<PurchaseSellStockReportVO> findPssReportByIds(List<Long> reportIds) {
        return this.purchaseSellStockReportMapper.findPssReportByIds(reportIds);
    }

    @Override
    @Transactional
    public int reopenPurchaseOrder(Long poId, Date askDeliveryDate) {
        PcsPurchaseOrder purchaseOrder = this.pcsPurchaseOrderMapper.selectByPrimaryKey(poId);
        if (EmptyUtil.isNotEmpty((Object)askDeliveryDate)) {
            purchaseOrder.setNewAskDeliveryDate(askDeliveryDate);
            purchaseOrder.setAskDeliveryDate(askDeliveryDate);
        } else {
            purchaseOrder.setNewAskDeliveryDate(purchaseOrder.getAskDeliveryDate());
        }
        this.savePoAndLineApprovalRecord(purchaseOrder, this.pcsPoLineService.findPoLineByPoId(poId), this.pcsPurchaseOrderCostMapper.selectByPoId(poId));
        purchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
        return this.pcsPurchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder);
    }

    @Override
    public List<PcsPurchaseOrder> findNeedToClosedPO() {
        return this.pcsPurchaseOrderMapper.findNeedToClosedPO();
    }

    @Override
    public List<PcsPurchaseOrderVO> findNearestPurchaseOrderBySkuCodes(List<String> skuCodes) {
        return this.pcsPurchaseOrderMapper.findNearestPurchaseOrderBySkuCodes(skuCodes);
    }

    @Override
    public PageInfo<PcsPoProgressTrackingVO> pageQueryTrackingProgressByCond(PcsPurchaseOrderCond cond) {
        PageRowBounds rowBounds = new PageRowBounds(cond.getPageStart(), cond.getPagenum().intValue());
        PageInfo pageInfo = new PageInfo(this.pcsPurchaseOrderMapper.pageQueryTrackingProgressByCond(cond, rowBounds));
        pageInfo.setTotal(rowBounds.getTotal().longValue());
        return pageInfo;
    }

    @Override
    public List<PcsPoProgressTrackingDetailVO> queryTrackingProgressDetailByCond(PcsPurchaseOrderCond cond) {
        ArrayList<PcsPoProgressTrackingDetailVO> allList = new ArrayList<PcsPoProgressTrackingDetailVO>();
        int currpage = 0;
        boolean hasNextPage = true;
        while (hasNextPage) {
            PageRowBounds pageRowBounds = new PageRowBounds((++currpage - 1) * 2000, 2000);
            List<PcsPoProgressTrackingDetailVO> list = this.pcsPurchaseOrderMapper.queryTrackingProgressDetailByCond(cond, pageRowBounds);
            allList.addAll(list);
            if (list != null && list.size() != 0) continue;
            hasNextPage = false;
        }
        Map<String, Long> skuFirstPOMap = this.mapSkuFirstPO(cond);
        int listSize = allList.size();
        for (int i = 0; i < listSize; ++i) {
            PcsPoProgressTrackingDetailVO trackingDetailVO = (PcsPoProgressTrackingDetailVO)allList.get(i);
            String skuCode = trackingDetailVO.getSkuCode();
            if (!trackingDetailVO.getPoId().equals(skuFirstPOMap.get(skuCode))) continue;
            trackingDetailVO.setFirstOrder(true);
        }
        return allList;
    }

    @Override
    public Map<String, Long> mapSkuFirstPO(PcsPurchaseOrderCond cond) {
        List<PcsPoProgressTrackingDetailVO> list = this.pcsPurchaseOrderMapper.querySkuFirstOrder(cond);
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (list == null || list.size() == 0) {
            return map;
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            PcsPoProgressTrackingDetailVO trackingDetailVO = list.get(i);
            map.put(trackingDetailVO.getSkuCode(), trackingDetailVO.getPoId());
        }
        return map;
    }

    @Override
    public List<Long> findCanAutoCreatePopPoIds() {
        List<PcsPoLineVO> poLines = this.pcsPoLineService.selectCanAutoCreatePopLines();
        HashSet<Long> poIds = new HashSet<Long>();
        if (poLines == null || poLines.size() == 0) {
            return new ArrayList<Long>(poIds);
        }
        for (PcsPoLineVO pcsPoLine : poLines) {
            if (pcsPoLine.getPoId() == null) continue;
            poIds.add(pcsPoLine.getPoId());
        }
        return new ArrayList<Long>(poIds);
    }

    @Override
    public List<PcsPoApprovalRecords> findApprovalRecordsByPoId(Long poId) {
        PcsPoApprovalRecordsExample example = new PcsPoApprovalRecordsExample();
        example.createCriteria().andPoIdEqualTo(poId);
        example.setOrderByClause("id desc");
        return this.pcsPoApprovalRecordsMapper.selectByExample(example);
    }

    @Override
    public PcsPoApprovalRecords findNewestApprovalRecordsByPoId(Long poId) {
        List<PcsPoApprovalRecords> approvalRecords = this.findApprovalRecordsByPoId(poId);
        if (approvalRecords == null || approvalRecords.size() == 0) {
            return null;
        }
        return approvalRecords.get(0);
    }

    @Override
    public Long savePoApprovalRecord(PcsPurchaseOrder pcsPurchaseOrder) {
        Long poId = pcsPurchaseOrder.getId();
        PcsPoApprovalRecords newestApprovalRecord = this.findNewestApprovalRecordsByPoId(poId);
        PcsPoApprovalRecords approvalRecord = new PcsPoApprovalRecords();
        Integer approvalTimes = 1;
        if (newestApprovalRecord != null) {
            approvalTimes = newestApprovalRecord.getApprovalTimes() + 1;
        }
        approvalRecord.setPoId(poId);
        approvalRecord.setPoStatusBeforeSubmit(pcsPurchaseOrder.getPurchaseOrderStatus());
        Date now = new Date();
        approvalRecord.setSubmitTime(now);
        approvalRecord.setApprovalTimes(approvalTimes);
        approvalRecord.setUpdateTime(now);
        approvalRecord.setPurchaseCurrencyCode(pcsPurchaseOrder.getPurchaseCurrencyCode());
        approvalRecord.setPurchaseCurrencyRate(pcsPurchaseOrder.getPurchaseCurrencyRate());
        approvalRecord.setPurchaseCurrencyDesc(pcsPurchaseOrder.getPurchaseCurrencyDesc());
        approvalRecord.setPoApprovalStatus(PoStatusEnum.PURCHASE_ORDER_STATUS_WAITING_AUDIT.getKey());
        approvalRecord.setSubmitUserId(pcsPurchaseOrder.getSubmitUserId());
        this.pcsPoApprovalRecordsMapper.insertSelective(approvalRecord);
        return approvalRecord.getId();
    }

    @Override
    @Transactional
    public Long savePoAndLineApprovalRecord(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, List<PcsPurchaseOrderCost> orderCostList) {
        Long poApprovalRecordId = this.savePoApprovalRecord(pcsPurchaseOrder);
        if (pcsPoLineList == null || pcsPoLineList.size() == 0) {
            return null;
        }
        ArrayList<PcsPoLineApprovalRecord> lineApprovalRecords = new ArrayList<PcsPoLineApprovalRecord>();
        for (PcsPoLine pcsPoLine : pcsPoLineList) {
            PcsPoLineApprovalRecord poLineApprovalRecord = (PcsPoLineApprovalRecord)BeanUtil.buildFrom((Object)pcsPoLine, PcsPoLineApprovalRecord.class);
            poLineApprovalRecord.setPoApprovalRecordId(poApprovalRecordId);
            poLineApprovalRecord.setPoLineId(pcsPoLine.getId());
            lineApprovalRecords.add(poLineApprovalRecord);
        }
        this.savePoApprovalRecordLine(lineApprovalRecords);
        this.savePoCostApprovalRecords(orderCostList, poApprovalRecordId);
        return poApprovalRecordId;
    }

    private void savePoCostApprovalRecords(List<PcsPurchaseOrderCost> poCostList, Long poApprovalRecordId) {
        if (poCostList != null && poCostList.size() > 0) {
            for (PcsPurchaseOrderCost poCost : poCostList) {
                PcsPoCostApprovalRecords record = new PcsPoCostApprovalRecords();
                BeanUtils.copyProperties((Object)poCost, (Object)record);
                record.setPoApprovalRecordId(poApprovalRecordId);
                this.pcsPoCostApprovalRecordsMapper.insertSelective(record);
            }
        }
    }

    @Override
    public int savePoApprovalRecordLine(List<PcsPoLineApprovalRecord> lineApprovalRecords) {
        return this.pcsPoLineApprovalRecordMapper.batchInsert(lineApprovalRecords);
    }

    @Override
    @Transactional
    public int withdrawApproval(Long poId) {
        Integer poStatusBeforeSubmit = PoStatusEnum.PURCHASE_ORDER_STATUS_DRAFT.getKey();
        PcsPoApprovalRecords newestApprovalRecord = this.findNewestApprovalRecordsByPoId(poId);
        if (newestApprovalRecord != null) {
            poStatusBeforeSubmit = newestApprovalRecord.getPoStatusBeforeSubmit();
        }
        PcsPurchaseOrderVO purchaseOrderVO = new PcsPurchaseOrderVO();
        purchaseOrderVO.setId(poId);
        purchaseOrderVO.setPoStatusBeforeSubmit(poStatusBeforeSubmit);
        int rct = this.pcsPurchaseOrderMapper.withdrawApproval(purchaseOrderVO);
        if (rct == 0) {
            throw new PurchaseException("\u8b66\u544a", "\u91c7\u8d2d\u5355\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u65e0\u6cd5\u64a4\u56de\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u64cd\u4f5c");
        }
        return rct;
    }

    @Override
    public List<PcsPoLineVO> findPoApprovalRecordLine(Long poId) {
        PcsPoApprovalRecords newestApprovalRecord = this.findNewestApprovalRecordsByPoId(poId);
        if (EmptyUtil.isNotEmpty((Object)newestApprovalRecord)) {
            List<PcsPoLineVO> poLineApprovalRecords = this.pcsPoLineApprovalRecordMapper.findPoLineVOByPoId(newestApprovalRecord.getPoId(), newestApprovalRecord.getId());
            if (poLineApprovalRecords == null || poLineApprovalRecords.size() == 0) {
                return null;
            }
            return poLineApprovalRecords;
        }
        return null;
    }

    @Override
    public List<PcsPurchaseOrderCost> findPoCostApprovalRecords(Long poApprovalRecordId) {
        PcsPoCostApprovalRecordsExample example = new PcsPoCostApprovalRecordsExample();
        example.createCriteria().andPoApprovalRecordIdEqualTo(poApprovalRecordId);
        return BeanUtil.buildListFrom(this.pcsPoCostApprovalRecordsMapper.selectByExample(example), PcsPurchaseOrderCost.class);
    }

    @Override
    public PcsPurchaseOrderVO findPoVOByCond(PcsPurchaseOrderCond cond) {
        PcsPurchaseOrderVO pcsPurchaseOrderVO = null;
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            pcsPurchaseOrderVO = this.pcsPurchaseOrderMapper.findPoVOById(cond.getId());
        } else if (EmptyUtil.isNotEmpty((String)cond.getPoCode())) {
            pcsPurchaseOrderVO = this.pcsPurchaseOrderMapper.findPoVOByCode(cond.getPoCode());
        }
        if (pcsPurchaseOrderVO != null) {
            List<PcsPoPlanVO> pcsPoPlanVOs;
            if (cond.isFetchPoLine()) {
                pcsPurchaseOrderVO.setPcsPoLineVOList(this.pcsPoLineService.findPoLineVOByPoId(pcsPurchaseOrderVO.getId()));
            }
            if (cond.isFetchPoCost()) {
                pcsPurchaseOrderVO.setPcsPoCostList(this.findPurchaseOrderCost(pcsPurchaseOrderVO.getId()));
            }
            if (cond.isFetchPop() && CollectionUtils.isNotEmpty(pcsPoPlanVOs = this.findPcsPoPlanVOList(pcsPurchaseOrderVO.getId()))) {
                Map<Integer, List<PcsPoPlanCost>> popCostMap;
                Map<Long, List<PcsPoPlanLineVO>> popLineMap;
                pcsPurchaseOrderVO.setPcsPoPlanVOList(pcsPoPlanVOs);
                HashSet popIds = new HashSet();
                HashSet popIdList = new HashSet();
                pcsPoPlanVOs.forEach(pop -> {
                    popIds.add(pop.getId());
                    popIdList.add(pop.getId().intValue());
                });
                if (cond.isFetchPopLine() && !(popLineMap = this.pcsPoPlanService.findPoPlanLineMap(Arrays.asList(popIds.toArray(new Long[popIds.size()])))).isEmpty()) {
                    pcsPoPlanVOs.forEach(pop -> {
                        List lineList = (List)popLineMap.get(pop.getId());
                        if (NullUtil.isNotNull((Object)lineList)) {
                            pop.setPcsPoPlanLineVOList(lineList);
                        }
                    });
                }
                if (cond.isFetchPopCost() && (popCostMap = this.mapPcsPoPlanCost(Arrays.asList(popIdList.toArray(new Integer[popIdList.size()])))).size() > 0) {
                    pcsPoPlanVOs.forEach(pop -> {
                        List popCostList = (List)popCostMap.get(pop.getId().intValue());
                        if (NullUtil.isNotNull((Object)popCostList)) {
                            pop.setPcsPoPlanCosts(popCostList);
                        }
                    });
                }
            }
        }
        return pcsPurchaseOrderVO;
    }

    public Map<Integer, List<PcsPoPlanCost>> mapPcsPoPlanCost(List<Integer> popIds) {
        HashMap<Integer, List<PcsPoPlanCost>> map = new HashMap<Integer, List<PcsPoPlanCost>>();
        List<PcsPoPlanCost> poPlanCosts = this.pcsPoPlanService.listPcsPoPlanCostByPopIds(popIds);
        if (EmptyUtil.isNotEmpty(poPlanCosts)) {
            poPlanCosts.forEach(poPlanCost -> {
                ArrayList<PcsPoPlanCost> tmpList = (ArrayList<PcsPoPlanCost>)map.get(poPlanCost.getPoPlanId());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<PcsPoPlanCost>();
                    map.put(poPlanCost.getPoPlanId(), tmpList);
                }
                tmpList.add((PcsPoPlanCost)poPlanCost);
            });
        }
        return map;
    }

    @Override
    public PcsPurchaseOrderVO findPoVOById(long id, boolean cascadeLine) {
        PcsPurchaseOrderVO pcsPurchaseOrderVO = this.findPoVOById(id);
        if (pcsPurchaseOrderVO == null) {
            return null;
        }
        pcsPurchaseOrderVO.setPcsPoLineVOList(this.pcsPoLineService.findPoLineVOByPoId(id));
        return pcsPurchaseOrderVO;
    }

    @Override
    public PcsPurchaseOrderVO findPoVOForApprovalById(long id, boolean cascadeLine) {
        PcsPurchaseOrderVO pcsPurchaseOrderVO = this.findPoVOById(id);
        if (pcsPurchaseOrderVO == null) {
            return null;
        }
        PcsPoApprovalRecords newestApprovalRecord = this.findNewestApprovalRecordsByPoId(id);
        ArrayList<PcsPoLineVO> poLineVOList = new ArrayList();
        if (newestApprovalRecord != null) {
            poLineVOList = this.findPoApprovalRecordLine(id);
            PcsPurchaseOrder pcsPurchaseOrder = (PcsPurchaseOrder)BeanUtil.buildFrom((Object)pcsPurchaseOrderVO, PcsPurchaseOrder.class);
            this.computeTotalPrice(pcsPurchaseOrder, BeanUtil.buildListFrom(poLineVOList, PcsPoLine.class), pcsPurchaseOrderVO.getOrderCostList());
            pcsPurchaseOrderVO.setPcsPoLineVOList(poLineVOList);
            pcsPurchaseOrderVO.setTotalAmount(pcsPurchaseOrder.getTotalAmount());
            pcsPurchaseOrderVO.setTotalAmountAfterTax(pcsPurchaseOrder.getTotalAmountAfterTax());
            List<PcsPurchaseOrderCost> pcsPurchaseOrderCosts = this.findPoCostApprovalRecords(newestApprovalRecord.getId());
            if (pcsPurchaseOrderCosts == null || pcsPurchaseOrderCosts.size() > 0) {
                pcsPurchaseOrderVO.setOrderCostList(pcsPurchaseOrderCosts);
            }
        }
        return pcsPurchaseOrderVO;
    }

    @Override
    public Map<String, Integer> mapRefundedGoodQuantityByPoIdAndSkuCode(Long poId) {
        List<PcsPurchaseReturnSkuVO> returnSkuList = this.pcsPurchaseReturnSkuMapper.selectRealityGoodQuantityByPoId(poId);
        if (returnSkuList == null || returnSkuList.size() == 0) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (PcsPurchaseReturnSkuVO returnSkuVO : returnSkuList) {
            String key = returnSkuVO.getPoId() + "_" + returnSkuVO.getSkuCode();
            map.put(key, returnSkuVO.getGoodRealityQuantity());
        }
        return map;
    }

    @Override
    public Map<String, Integer> computeRealityGoodQuantityByPoId(Long poId) {
        List<PcsPurchaseReturnSkuVO> list = this.pcsPurchaseReturnSkuMapper.computeRealityGoodQuantityByPoId(poId);
        if (EmptyUtil.isNotEmpty(list)) {
            return list.stream().collect(Collectors.toMap(PcsPurchaseReturnSku::getSkuCode, PcsPurchaseReturnSkuVO::getGoodRealityQuantity, (v1, v2) -> v1 + v2));
        }
        return new HashMap<String, Integer>();
    }

    @Override
    public List<PcsPoApprovalRecords> listPoApprovalRecords(Long poId, Integer approvalStatus) {
        PcsPoApprovalRecordsExample example = new PcsPoApprovalRecordsExample();
        PcsPoApprovalRecordsExample.Criteria criteria = example.createCriteria();
        criteria.andPoApprovalStatusEqualTo(approvalStatus);
        criteria.andPoIdEqualTo(poId);
        return this.pcsPoApprovalRecordsMapper.selectByExample(example);
    }

    @Override
    public int getPoPassApprovalTimes(Long poId) {
        List<PcsPoApprovalRecords> records = this.listPoApprovalRecords(poId, PoStatusEnum.PURCHASE_ORDER_STATUS_WAIT_RECEIVE.getKey());
        return records == null ? 0 : records.size();
    }

    @Override
    public List<PcsPurchaseOrderVO> listPoVOByIds(List<Long> ids, boolean cascadeLine) {
        PcsPurchaseOrderCond cond = new PcsPurchaseOrderCond();
        cond.setPoIds(ids);
        List<PcsPurchaseOrderVO> poVOs = this.pcsPurchaseOrderMapper.findPOVOByCond(cond);
        if (cascadeLine && CollectionUtils.isNotEmpty(poVOs)) {
            poVOs.forEach(po -> po.setPcsPoLineVOList(this.pcsPoLineService.findPoLineVOByPoId(po.getId())));
        }
        return poVOs;
    }
}

