/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseFlowerSupplierCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseFlowerSupplierMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlowerSupplier;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlowerSupplierExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseFlowerSupplierService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseFlowerSupplierVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pcsPurchaseFlowerSupplierService")
public class PcsPurchaseFlowerSupplierServiceImpl
implements PcsPurchaseFlowerSupplierService {
    public final Logger log = LoggerFactory.getLogger(PcsPurchaseFlowerSupplierServiceImpl.class);
    @Autowired
    private PcsPurchaseFlowerSupplierMapper pcsPurchaseFlowerSupplierMapper;

    @Override
    public Integer addOrEditPurchaseFlowerSupplier(PcsPurchaseFlowerSupplierVO pcsPurchaseFlowerSupplierVO) {
        if (0 == pcsPurchaseFlowerSupplierVO.getId()) {
            this.pcsPurchaseFlowerSupplierMapper.insert(pcsPurchaseFlowerSupplierVO);
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("id", pcsPurchaseFlowerSupplierVO.getId());
            String flowerCode = CodeGenerator.getInstance().generate("PCS_SUP_CODE", params);
            PcsPurchaseFlowerSupplier updateVO = new PcsPurchaseFlowerSupplier();
            updateVO.setId(pcsPurchaseFlowerSupplierVO.getId());
            updateVO.setCode(flowerCode);
            updateVO.setStatus(1);
            return this.pcsPurchaseFlowerSupplierMapper.updateByPrimaryKeySelective(updateVO);
        }
        return this.pcsPurchaseFlowerSupplierMapper.updateByPrimaryKeySelective(pcsPurchaseFlowerSupplierVO);
    }

    @Override
    public Pagination<PcsPurchaseFlowerSupplierVO> findByCond(PcsPurchaseFlowerSupplierCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.pcsPurchaseFlowerSupplierMapper.countByCond(cond);
        page.setRecord(Integer.valueOf(count));
        if (!NumberUtil.isNullOrZero((Number)count)) {
            List<PcsPurchaseFlowerSupplierVO> flowerVOList = this.pcsPurchaseFlowerSupplierMapper.findByCond(cond);
            page.setResultList(flowerVOList);
        }
        return page;
    }

    @Override
    public PcsPurchaseFlowerSupplierVO findById(Integer id) {
        PcsPurchaseFlowerSupplier pcsPurchaseFlowerSupplier = this.pcsPurchaseFlowerSupplierMapper.selectByPrimaryKey(id);
        return (PcsPurchaseFlowerSupplierVO)BeanUtil.buildFrom((Object)pcsPurchaseFlowerSupplier, PcsPurchaseFlowerSupplierVO.class);
    }

    @Override
    public List<PcsPurchaseFlowerSupplierVO> findByCondForExport(PcsPurchaseFlowerSupplierCond cond) {
        return this.pcsPurchaseFlowerSupplierMapper.findByCond(cond);
    }

    @Override
    public Integer updateByExample(PcsPurchaseFlowerSupplierVO pcsPurchaseFlowerVO) {
        PcsPurchaseFlowerSupplier updateVO = (PcsPurchaseFlowerSupplier)BeanUtil.buildFrom((Object)pcsPurchaseFlowerVO, PcsPurchaseFlowerSupplierVO.class);
        return this.pcsPurchaseFlowerSupplierMapper.updateByPrimaryKeySelective(updateVO);
    }

    @Override
    public Integer batchUpdateByCode(List<PcsPurchaseFlowerSupplierVO> pcsPurchaseFlowers) {
        return this.pcsPurchaseFlowerSupplierMapper.batchUpdateByCodeSelective(BeanUtil.buildListFrom(pcsPurchaseFlowers, PcsPurchaseFlowerSupplier.class));
    }

    @Override
    public Integer batchInsert(List<PcsPurchaseFlowerSupplierVO> pcsPurchaseFlowerSupplierVOS) {
        if (CollectionUtils.isNotEmpty(pcsPurchaseFlowerSupplierVOS)) {
            ArrayList updateVOs = Lists.newArrayList();
            for (PcsPurchaseFlowerSupplier pcsPurchaseFlowerSupplier : pcsPurchaseFlowerSupplierVOS) {
                this.pcsPurchaseFlowerSupplierMapper.insert(pcsPurchaseFlowerSupplier);
                HashMap<String, Integer> params = new HashMap<String, Integer>();
                params.put("id", pcsPurchaseFlowerSupplier.getId());
                String flowerCode = CodeGenerator.getInstance().generate("PCS_SUP_CODE", params);
                PcsPurchaseFlowerSupplier updateVO = new PcsPurchaseFlowerSupplier();
                updateVO.setId(pcsPurchaseFlowerSupplier.getId());
                updateVO.setCode(flowerCode);
                updateVO.setStatus(1);
                updateVOs.add(updateVO);
            }
            return this.pcsPurchaseFlowerSupplierMapper.batchUpdateByPramaryKeySelective(updateVOs);
        }
        return null;
    }

    @Override
    public List<PcsPurchaseFlowerSupplierVO> findByNameOrCodeLike(String term) {
        return this.pcsPurchaseFlowerSupplierMapper.findByNameOrCodeLike(SQLUtils.allLike((String)term));
    }

    @Override
    public List<PcsPurchaseFlowerSupplierVO> findAllSupplier() {
        PcsPurchaseFlowerSupplierExample example = new PcsPurchaseFlowerSupplierExample();
        example.createCriteria().andStatusEqualTo(PcsPurchaseFlowerSupplier.STATUS_ENABLE);
        List<PcsPurchaseFlowerSupplier> list = this.pcsPurchaseFlowerSupplierMapper.selectByExample(example);
        return BeanUtil.buildListFrom(list, PcsPurchaseFlowerSupplierVO.class);
    }
}

