/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseFlowerCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseFlowerMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlower;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseFlowerService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseFlowerVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsPurchaseFlowerService")
public class PcsPurchaseFlowerServiceImpl
implements PcsPurchaseFlowerService {
    public final Logger log = LoggerFactory.getLogger(PcsPurchaseFlowerServiceImpl.class);
    @Autowired
    private PcsPurchaseFlowerMapper pcsPurchaseFlowerMapper;

    @Override
    @Transactional
    public Integer addOrEditPurchaseFlower(PcsPurchaseFlowerVO pcsPurchaseFlower) {
        if (0 == pcsPurchaseFlower.getId()) {
            this.pcsPurchaseFlowerMapper.insert(pcsPurchaseFlower);
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("id", pcsPurchaseFlower.getId());
            String flowerCode = CodeGenerator.getInstance().generate("PCS_FLOWER_CODE", params);
            PcsPurchaseFlower updateVO = new PcsPurchaseFlower();
            updateVO.setId(pcsPurchaseFlower.getId());
            updateVO.setCode(flowerCode);
            updateVO.setStatus(1);
            return this.pcsPurchaseFlowerMapper.updateByPrimaryKeySelective(updateVO);
        }
        return this.pcsPurchaseFlowerMapper.updateByPrimaryKeySelective(pcsPurchaseFlower);
    }

    @Override
    public Pagination<PcsPurchaseFlowerVO> findByCond(PcsPurchaseFlowerCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.pcsPurchaseFlowerMapper.countByCond(cond);
        page.setRecord(Integer.valueOf(count));
        if (!NumberUtil.isNullOrZero((Number)count)) {
            List<PcsPurchaseFlowerVO> flowerVOList = this.pcsPurchaseFlowerMapper.findByCond(cond);
            page.setResultList(flowerVOList);
        }
        return page;
    }

    @Override
    public PcsPurchaseFlowerVO findById(Integer id) {
        PcsPurchaseFlower pcsPurchaseFlower = this.pcsPurchaseFlowerMapper.selectByPrimaryKey(id);
        PcsPurchaseFlowerVO pcsPurchaseFlowerVO = (PcsPurchaseFlowerVO)BeanUtil.buildFrom((Object)pcsPurchaseFlower, PcsPurchaseFlowerVO.class);
        return pcsPurchaseFlowerVO;
    }

    @Override
    public List<PcsPurchaseFlowerVO> findByCondForExport(PcsPurchaseFlowerCond cond) {
        return this.pcsPurchaseFlowerMapper.findByCond(cond);
    }

    @Override
    public Integer updateByExample(PcsPurchaseFlowerVO pcsPurchaseFlowerVO) {
        PcsPurchaseFlower updateVO = (PcsPurchaseFlower)BeanUtil.buildFrom((Object)pcsPurchaseFlowerVO, PcsPurchaseFlower.class);
        return this.pcsPurchaseFlowerMapper.updateByPrimaryKeySelective(updateVO);
    }

    @Override
    @Transactional
    public Integer batchUpdateByCode(List<PcsPurchaseFlower> pcsPurchaseFlowers) {
        return this.pcsPurchaseFlowerMapper.batchUpdateByCodeSelective(pcsPurchaseFlowers);
    }

    @Override
    @Transactional
    public Integer batchInsert(List<PcsPurchaseFlower> pcsPurchaseFlowers) {
        ArrayList updateVOs = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(pcsPurchaseFlowers)) {
            for (PcsPurchaseFlower pcsPurchaseFlower : pcsPurchaseFlowers) {
                this.pcsPurchaseFlowerMapper.insert(pcsPurchaseFlower);
                HashMap<String, Integer> params = new HashMap<String, Integer>();
                params.put("id", pcsPurchaseFlower.getId());
                String flowerCode = CodeGenerator.getInstance().generate("PCS_FLOWER_CODE", params);
                PcsPurchaseFlower updateVO = new PcsPurchaseFlower();
                updateVO.setId(pcsPurchaseFlower.getId());
                updateVO.setCode(flowerCode);
                updateVOs.add(updateVO);
            }
            return this.pcsPurchaseFlowerMapper.batchUpdateByPramaryKeySelective(updateVOs);
        }
        return null;
    }

    @Override
    public List<PcsPurchaseFlowerVO> findPurchaseFlowerByChannelCodeAndCodeOrName(String channelCode, String nameOrCode, Integer unitConfigId) {
        return this.pcsPurchaseFlowerMapper.findPurchaseFlowerByChannelCodeAndCodeOrName(channelCode, nameOrCode, unitConfigId);
    }
}

