/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.commdata.service.CommEntityOperationRcdService;
import com.thebeastshop.commdata.service.CommGlobalConfigService;
import com.thebeastshop.commdata.vo.CommEntityOpRcdVO;
import com.thebeastshop.commdata.vo.CommGlobalConfigVO;
import com.thebeastshop.common.Pagination;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.common.utils.SQLUtils;
import com.thebeastshop.kit.codetemplate.utils.CodeGenerator;
import com.thebeastshop.message.service.EmailSendService;
import com.thebeastshop.message.vo.EmailVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoPlanCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoPlanCostCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanCostMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanLineMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanMapper;
import com.thebeastshop.pegasus.service.purchase.enums.PoLogisticsEnum;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCost;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCostExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLogisticsBillService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanCostVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLogisticsBillVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPopFeeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderVO;
import com.thebeastshop.pegasus.service.purchase.vo.PoInfomationVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.ExcelUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import com.thebeastshop.wms.sservice.WWhCommandService;
import com.thebeastshop.wms.vo.WhCommandSkuVO;
import com.thebeastshop.wms.vo.WhCommandVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsPoPlanService")
public class PcsPoPlanServiceImpl
implements PcsPoPlanService,
CheckAble,
CodeAble {
    private final Logger log = LoggerFactory.getLogger(PcsPoPlanServiceImpl.class);
    @Autowired
    private WWhCommandService wWhCommandService;
    @Autowired
    private CommGlobalConfigService commGlobalConfigService;
    @Autowired
    private CommEntityOperationRcdService commEntityOperationRcdService;
    @Autowired
    private PcsPoPlanMapper pcsPoPlanMapper;
    @Autowired
    private PcsPoPlanLineMapper pcsPoPlanLineMapper;
    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;
    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;
    @Autowired
    private PcsPoLineService pcsPoLineService;
    @Autowired
    private PcsPoPlanCostMapper pcsPoPlanCostMapper;
    @Autowired
    private PcsPoLogisticsBillService pcsPoLogisticsBillService;
    @Autowired
    private EmailSendService emailSendService;

    @Override
    public PcsPoPlan buildFromVO(PcsPoPlanVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsPoPlan record = new PcsPoPlan();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsPoPlanVO buildFromModel(PcsPoPlan record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsPoPlanVO vo = new PcsPoPlanVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    private WhCommandVO bulidWhCommand(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) {
        PcsPurchaseOrder po = this.pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
        if (EmptyUtil.isEmpty((Object)po)) {
            throw new PurchaseException("PC0001", "\u91c7\u8d2d\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!po.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE) && !po.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE)) {
            throw new PurchaseException("PC0002", "\u91c7\u8d2d\u5355\u72b6\u6001\u5fc5\u987b\u662f\u6536\u8d27\u4e2d");
        }
        if (CollectionUtils.isEmpty(pcsPoPlanLineList)) {
            throw new PurchaseException("PC0001", "pcsPoPlanLineList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WhCommandVO whCommand = new WhCommandVO();
        whCommand.setWarehouseCode(po.getWarehouseCode());
        whCommand.setPhysicalWarehouseCode(po.getPhysicalWarehouseCode());
        whCommand.setReferenceCode(pcsPoPlan.getCode());
        whCommand.setInOutType(WhCommandVO.TYPE_PURCHASE_IN);
        ArrayList<WhCommandSkuVO> whCommandSkuList = new ArrayList<WhCommandSkuVO>();
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            if (line.getPlanedQuantity().compareTo(0) <= 0) {
                throw new PurchaseException("PC0001", "\u6784\u9020\u4ed3\u5e93\u6307\u4ee4\u7684LIST\u5931\u8d25,\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            }
            WhCommandSkuVO whCommandSku = new WhCommandSkuVO();
            whCommandSku.setSkuCode(line.getSkuCode());
            whCommandSku.setPlanedQuantity(line.getPlanedQuantity());
            whCommandSku.setQpb(line.getQpb());
            if (!NumberUtil.isNullOrZero((Number)line.getQuantity())) {
                whCommandSku.setQuantity(line.getQuantity());
            }
            if (!NumberUtil.isNullOrZero((Number)line.getWasteQuantity())) {
                whCommandSku.setDamagedQuantity(line.getWasteQuantity());
            }
            whCommandSkuList.add(whCommandSku);
        }
        if (CollectionUtils.isEmpty(whCommandSkuList)) {
            throw new PurchaseException("PC0001", "\u6784\u9020\u4ed3\u5e93\u6307\u4ee4\u7684LIST\u5931\u8d25,whCommandSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        whCommand.setWhCommandSkuList(whCommandSkuList);
        return whCommand;
    }

    @Override
    @Transactional
    public PcsPoPlan create(PcsPoPlan record) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            record.setWhCommandCode("");
            record.setPlanStatus(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE);
            record.setCreateTime(DateUtil.getNow());
            this.pcsPoPlanMapper.insertSelective(record);
            try {
                String code = this.generateCode(record.getId());
                if (!this.check(code).booleanValue()) {
                    throw new PurchaseException("PC0005", "code\u5b57\u6bb5\u6570\u636e\u5e93\u5df2\u6709\u76f8\u540c\u7684\u503c\u4e0d\u80fd\u91cd\u590d");
                }
                record.setCode(code);
            }
            catch (PurchaseException we) {
                this.log.error("", (Throwable)we);
                throw new PurchaseException(we.getErrorCode(), "facadeWhInner error:" + we.getMessage());
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                throw new PurchaseException("PC0006", e.getMessage());
            }
            this.pcsPoPlanMapper.updateByPrimaryKeySelective(record);
            return record;
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPoPlan record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            return this.pcsPoPlanMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updatePcsPoPlanWarnFlagByIds(List<Long> ids) {
        return this.pcsPoPlanMapper.updatePcsPoPlanWarnFlagByIds(ids) != 0;
    }

    @Override
    public List<PcsPopFeeVO> calculatePopFee(List<Long> popIds) {
        return this.pcsPoPlanCostMapper.calculatePopFee(popIds);
    }

    @Override
    public Map<Long, PcsPopFeeVO> mapPopFee(List<Long> popIds) {
        List<PcsPopFeeVO> list = this.calculatePopFee(popIds);
        HashMap<Long, PcsPopFeeVO> map = new HashMap<Long, PcsPopFeeVO>();
        if (list == null || list.size() == 0) {
            return map;
        }
        for (PcsPopFeeVO popFeeVO : list) {
            map.put(popFeeVO.getPopId(), popFeeVO);
        }
        return map;
    }

    @Override
    @Transactional
    public int delPoPlanFee(Long poPlanFeeId) {
        PcsPoPlanCost cost = this.selectCostByCostId(poPlanFeeId);
        cost.setAvailable((byte)0);
        this.updatePoPlanFee(cost, 1);
        if (cost != null) {
            cost.setId(null);
            cost.setPreTaxAmount(BigDecimal.ZERO.subtract(cost.getPreTaxAmount()));
            cost.setAfterTaxAmount(BigDecimal.ZERO.subtract(cost.getAfterTaxAmount()));
            cost.setFeeTime(new Date());
            cost.setCreateTime(new Date());
            this.createPoPlanFee(cost);
        }
        return 0;
    }

    @Override
    public int delPoPlanFeeByIds(List<Long> feeIds) {
        Integer ret = 0;
        feeIds.stream().forEach(feeId -> this.delPoPlanFee((Long)feeId));
        return ret;
    }

    @Override
    public PcsPoPlan findPoPlanById(long id) {
        return this.pcsPoPlanMapper.selectByPrimaryKey(id);
    }

    @Override
    public boolean updatePcsPoPlanById(long id, String date) {
        int result = 0;
        try {
            result = this.pcsPoPlanMapper.updatePcsPoPlanById(id, date);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return result > 0;
    }

    @Override
    @Transactional
    public boolean updatePcsPoPlanByPrimaryKey(PcsPoPlan pcsPoPlan) {
        if (EmptyUtil.isEmpty((Object)pcsPoPlan.getId()) || EmptyUtil.isEmpty((Object)this.pcsPoPlanMapper.selectByPrimaryKey(pcsPoPlan.getId()))) {
            throw new PurchaseException("PC0001 popId\u4e0d\u5b58\u5728\uff0c\u66f4\u65b0\u5931\u8d25!");
        }
        return this.pcsPoPlanMapper.updateByPrimaryKeySelective(pcsPoPlan) > 0;
    }

    @Override
    public boolean updatePcsPoPlanLineById(long id, Integer sign) {
        int result = 0;
        try {
            result = this.pcsPoPlanMapper.updatePcsPoPlanLineById(id, sign);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return result > 0;
    }

    @Override
    public boolean updatePrdcJobById(long id, Integer sign) {
        int result = 0;
        try {
            result = this.pcsPoPlanMapper.updatePrdcJobById(id, sign);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return result > 0;
    }

    @Override
    public PcsPoPlan findPoPlanByCode(String code) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsPoPlan> poList = this.pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return null;
        }
        if (poList.size() > 1) {
            throw new PurchaseException("PC0005", " \u6839\u636ecode[" + code + "]\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        return poList.get(0);
    }

    @Override
    public List<PcsPoPlan> findPoPlanByStatus(Integer status) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andPlanStatusEqualTo(status);
        List<PcsPoPlan> poList = this.pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        return poList;
    }

    @Override
    public List<PcsPoPlanVO> findWasteAfterPopFinished(PcsPoPlanVO vo) {
        List<PcsPoPlanVO> poList = this.pcsPoPlanMapper.findWasteAfterPopFinished(vo);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        return poList;
    }

    @Override
    public void sendPopEmailByCond(PcsPoPlanVO vo) {
        List<PcsPoPlanVO> poPlanList = null;
        List<String> toAddressList = null;
        if (2 == vo.getSendPopEmailOrigin()) {
            poPlanList = vo.getPoPlanVOs();
            toAddressList = vo.getPopInStorageEmailReceivers();
        } else {
            poPlanList = this.findWasteAfterPopFinished(vo);
            toAddressList = Arrays.asList(this.commGlobalConfigService.findConfigByKey("cronSendEmailByWasteAterPopFinished.toAddress").getConfigValue().split(","));
        }
        if (CollectionUtils.isNotEmpty(poPlanList)) {
            CommGlobalConfigVO commGlobalConfig = this.commGlobalConfigService.findConfigByKey("cronSendEmailByWasteAterPopFinished.webUrl");
            String link = "http://scm.thebeastshop.com/scm/wms/receiveShelves/listDetailWaste.htm";
            if (EmptyUtil.isNotEmpty((Object)commGlobalConfig) && EmptyUtil.isNotEmpty((String)commGlobalConfig.getConfigValue())) {
                link = commGlobalConfig.getConfigValue();
            }
            String emailTitle = "POP\u6536\u8d27\u6b8b\u6b21";
            if (2 == vo.getSendPopEmailOrigin()) {
                emailTitle = "POP\u5165\u5e93\u901a\u77e5";
            }
            this.log.debug("[POP\u5b8c\u6210\u65f6," + emailTitle + "\u63d0\u9192]pcsPoPlanServiceImpl.sendPopEmailByCond begin at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            if (CollectionUtils.isEmpty(toAddressList)) {
                toAddressList = Collections.emptyList();
            }
            this.sendEmailByWasteAterPopFinished(poPlanList, toAddressList, link, emailTitle, vo);
            this.log.debug("[POP\u5b8c\u6210\u65f6," + emailTitle + "\u63d0\u9192]pcsPoPlanServiceImpl.sendPopEmailByCond end at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    private void sendEmailWasteAterPopFinished(StringBuffer emailContent, List<PcsPoPlanVO> pcsPoPlanVOs, List<String> toAddressList, String link, String emailTitle, PcsPoPlanVO vo) {
        emailContent.append("<table id='table-5'><thead><th>PO</th><th>POP</th><th>SKU</th><th>SKU\u540d\u79f0</th><th>\u8ba1\u5212\u6570</th><th>\u5b9e\u6536\u826f\u54c1</th><th>\u5f85\u5b9a\u6570\u91cf</th><th>\u5dee\u5f02\u6570(\u8ba1\u5212-\u826f\u54c1)</th><th>\u6b8b\u6b21\u94fe\u63a5</th></thead><tbody>");
        ArrayList<Long> popIds = new ArrayList<Long>();
        HashMap<String, List<PcsPoPlanVO>> poPlanVOMap = new HashMap<String, List<PcsPoPlanVO>>();
        StringBuffer allEmailContent = new StringBuffer();
        this.buildPopWasteContent(allEmailContent, pcsPoPlanVOs, popIds, link, poPlanVOMap);
        allEmailContent.append("</tbody></table></html>");
        HashMap buyerLoginUserEmailContentMap = new HashMap();
        if (poPlanVOMap.size() > 0) {
            for (Map.Entry entry : poPlanVOMap.entrySet()) {
                StringBuffer buyerEmailContent = (StringBuffer)buyerLoginUserEmailContentMap.get(entry.getKey());
                if (EmptyUtil.isEmpty((Object)buyerEmailContent)) {
                    buyerEmailContent = new StringBuffer();
                    buyerLoginUserEmailContentMap.put(entry.getKey(), buyerEmailContent);
                }
                this.buildPopWasteContent(buyerEmailContent, (List)entry.getValue(), null, link, null);
            }
            for (Map.Entry buyerContentEntry : buyerLoginUserEmailContentMap.entrySet()) {
                ((StringBuffer)buyerContentEntry.getValue()).append("</tbody></table></html>");
            }
        }
        if (!vo.isOnlySendBuyerEmail()) {
            this.sendPopWasteEmail(toAddressList, emailContent.toString() + allEmailContent.toString(), popIds, emailTitle);
            if (buyerLoginUserEmailContentMap.size() > 0) {
                for (Map.Entry entry : buyerLoginUserEmailContentMap.entrySet()) {
                    this.sendPopWasteEmail(Arrays.asList(((String)entry.getKey()).split(",")), emailContent.toString() + ((StringBuffer)entry.getValue()).toString(), null, emailTitle);
                }
            }
        }
    }

    private void sendEmailHoldPendingAterPopFinished(StringBuffer emailContent, List<PcsPoPlanVO> pcsPoPlanVOs, List<String> toAddressList, String link, String emailTitle, PcsPoPlanVO vo) {
        emailContent.append("<table id='table-5'><thead><th>PO</th><th>POP</th><th>SKU</th><th>SKU\u540d\u79f0</th><th>\u8ba1\u5212\u6570</th><th>\u5b9e\u6536\u826f\u54c1</th><th>\u5f85\u5b9a\u6570\u91cf</th><th>\u5dee\u5f02</th><th>\u8d28\u68c0\u5165\u5e93\u65f6\u95f4</th><th>\u5f85\u5b9a\u539f\u56e0</th><th>\u5f3a\u5236\u5904\u7406\u65e5\u671f</th><th>\u6b8b\u6b21\u94fe\u63a5</th></thead><tbody>");
        ArrayList<Long> popIds = new ArrayList<Long>();
        HashMap<String, List<PcsPoPlanVO>> buyerPoPlanVOMap = new HashMap<String, List<PcsPoPlanVO>>();
        StringBuffer allEmailContent = emailContent;
        this.buildPopHoldPendingContent(allEmailContent, pcsPoPlanVOs, popIds, link, buyerPoPlanVOMap);
        allEmailContent.append("</tbody></table></html>");
        HashMap buyerEmailContentMap = new HashMap();
        if (buyerPoPlanVOMap.size() > 0) {
            for (Map.Entry entry : buyerPoPlanVOMap.entrySet()) {
                StringBuffer buyerEmailContent = (StringBuffer)buyerEmailContentMap.get(entry.getKey());
                if (EmptyUtil.isEmpty((Object)buyerEmailContent)) {
                    buyerEmailContent = new StringBuffer();
                    buyerEmailContentMap.put(entry.getKey(), buyerEmailContent);
                }
                this.buildPopHoldPendingContent(buyerEmailContent, (List)entry.getValue(), null, link, null);
            }
            for (Map.Entry buyerContentEntry : buyerEmailContentMap.entrySet()) {
                ((StringBuffer)buyerContentEntry.getValue()).append("</tbody></table></html>");
            }
        }
        if (buyerEmailContentMap.size() > 0) {
            for (Map.Entry entry : buyerEmailContentMap.entrySet()) {
                String entryKey = (String)entry.getKey();
                boolean hasUndeterminedQuantity = this.checkHasUndeterminedQuantity((List)buyerPoPlanVOMap.get(entryKey));
                if (!hasUndeterminedQuantity || emailTitle.contains("\u6709\u5f85\u5b9a\u5546\u54c1\u9700\u5904\u7406")) continue;
                emailTitle = emailTitle + "\uff08\u6709\u5f85\u5b9a\u5546\u54c1\u9700\u5904\u7406\uff09";
            }
            this.sendPopWasteEmail(toAddressList, allEmailContent.toString(), popIds, emailTitle);
        }
    }

    private boolean checkHasUndeterminedQuantity(List<PcsPoPlanVO> pcsPoPlanVOs) {
        if (pcsPoPlanVOs == null || pcsPoPlanVOs.size() == 0) {
            return false;
        }
        for (PcsPoPlanVO poPlanVO : pcsPoPlanVOs) {
            if (!poPlanVO.isHasUndeterminedQuantity()) continue;
            return true;
        }
        return false;
    }

    private void sendEmailByWasteAterPopFinished(List<PcsPoPlanVO> pcsPoPlanVOs, List<String> toAddressList, String link, String emailTitle, PcsPoPlanVO vo) {
        int sendMailOrigin = vo.getSendPopEmailOrigin();
        StringBuffer emailContent = new StringBuffer();
        emailContent.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
        emailContent.append("#table-5 td {color: #000;}");
        emailContent.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
        emailContent.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
        if (2 == sendMailOrigin) {
            this.log.info("\u91c7\u8d2d\u5165\u5e93\u90ae\u4ef6--sendEmailByWasteAterPopFinished:{}", (Object)vo.getCode());
            this.sendEmailHoldPendingAterPopFinished(emailContent, pcsPoPlanVOs, toAddressList, link, emailTitle, vo);
        } else {
            this.sendEmailWasteAterPopFinished(emailContent, pcsPoPlanVOs, toAddressList, link, emailTitle, vo);
        }
    }

    private void sendPopWasteEmail(List<String> toAddressList, String emailContent, List<Long> popIds, String emailTitle) {
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(toAddressList);
        emailVO.setSubject(emailTitle);
        emailVO.setContent(emailContent);
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            try {
                this.log.info("\u5f00\u59cb\u53d1\u9001" + emailTitle + "\u90ae\u4ef6\uff1a" + emailVO.getToAddressList());
                boolean result = this.emailSendService.send(emailVO);
                if (result && CollectionUtils.isNotEmpty(popIds)) {
                    this.updatePcsPoPlanWarnFlagByIds(popIds);
                }
                this.log.info("\u6210\u529f\u53d1\u9001" + emailTitle + "\u90ae\u4ef6\uff1a" + emailVO.getToAddressList());
            }
            catch (Exception e) {
                this.log.error("\u5165\u5e93\u90ae\u4ef6\u53d1\u9001\u5931\u8d25----POP{}", (Object)JSON.toJSONString(popIds));
                e.printStackTrace();
            }
        }
    }

    private void buildPopWasteContent(StringBuffer emailContent, List<PcsPoPlanVO> pcsPoPlanVOs, List<Long> popIds, String link, Map<String, List<PcsPoPlanVO>> poPlanVOMap) {
        for (PcsPoPlanVO pcsPoPlanVO : pcsPoPlanVOs) {
            emailContent.append("<tr>");
            emailContent.append("<td>" + pcsPoPlanVO.getPoCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getSkuCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getSkuName() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getPlanedQuantity() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getQuantity() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getWasteQuantity() + "</td>");
            emailContent.append("<td>" + (pcsPoPlanVO.getPlanedQuantity() - pcsPoPlanVO.getQuantity()) + "</td>");
            emailContent.append("<td><a href='" + link + "?popCode=" + pcsPoPlanVO.getCode() + "&skuCode=" + pcsPoPlanVO.getSkuCode() + "'>\u6b8b\u6b21\u94fe\u63a5</a></td>");
            emailContent.append("</tr>");
            if (popIds != null) {
                popIds.add(pcsPoPlanVO.getId());
            }
            if (poPlanVOMap == null || !EmptyUtil.isNotEmpty((String)pcsPoPlanVO.getCreateOperatorEmail())) continue;
            List<PcsPoPlanVO> pcsPoPlanVOsTmp = poPlanVOMap.get(pcsPoPlanVO.getCreateOperatorEmail());
            if (CollectionUtils.isEmpty(pcsPoPlanVOsTmp)) {
                pcsPoPlanVOsTmp = new ArrayList<PcsPoPlanVO>();
                poPlanVOMap.put(pcsPoPlanVO.getCreateOperatorEmail(), pcsPoPlanVOsTmp);
            }
            pcsPoPlanVOsTmp.add(pcsPoPlanVO);
        }
    }

    private void buildPopHoldPendingContent(StringBuffer emailContent, List<PcsPoPlanVO> pcsPoPlanVOs, List<Long> popIds, String link, Map<String, List<PcsPoPlanVO>> buyerPoPlanVOMap) {
        for (PcsPoPlanVO pcsPoPlanVO : pcsPoPlanVOs) {
            int qcWasteQuantity;
            int planedQuantity = pcsPoPlanVO.getPlanedQuantity() == null ? 0 : pcsPoPlanVO.getPlanedQuantity();
            int qcQuantity = pcsPoPlanVO.getQuantity() == null ? 0 : pcsPoPlanVO.getQuantity();
            int n = qcWasteQuantity = pcsPoPlanVO.getWasteQuantity() == null ? 0 : pcsPoPlanVO.getWasteQuantity();
            if (qcWasteQuantity > 0 || planedQuantity - qcQuantity > 0) {
                emailContent.append("<tr bgcolor=\"#FF9F9F\">");
            } else {
                emailContent.append("<tr>");
            }
            emailContent.append("<td>" + pcsPoPlanVO.getPoCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getSkuCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getSkuName() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getPlanedQuantity() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getQuantity() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getWasteQuantity() + "</td>");
            emailContent.append("<td>" + (pcsPoPlanVO.getPlanedQuantity() - pcsPoPlanVO.getQuantity()) + "</td>");
            emailContent.append("<td>" + this.formatDate(pcsPoPlanVO.getQcCreateTime(), "yyyy-MM-dd HH:mm:ss") + "</td>");
            if (qcWasteQuantity > 0) {
                emailContent.append("<td>" + pcsPoPlanVO.getQcRemark() + "</td>");
                emailContent.append("<td>" + this.formatDate(pcsPoPlanVO.getSystemProcessTime(), "yyyy-MM-dd") + "</td>");
                emailContent.append("<td><a href='" + link + "?qcId=" + pcsPoPlanVO.getQcId() + "&popCode=" + pcsPoPlanVO.getCode() + "&skuCode=" + pcsPoPlanVO.getSkuCode() + "&originType=1'>\u6b8b\u6b21\u94fe\u63a5</a></td>");
            } else {
                emailContent.append("<td></td>");
                emailContent.append("<td></td>");
                emailContent.append("<td></td>");
            }
            emailContent.append("</tr>");
            if (popIds != null) {
                popIds.add(pcsPoPlanVO.getId());
            }
            if (buyerPoPlanVOMap == null || !EmptyUtil.isNotEmpty((String)pcsPoPlanVO.getBuyerEmailAddress())) continue;
            List<PcsPoPlanVO> pcsPoPlanVOsTmp = buyerPoPlanVOMap.get(pcsPoPlanVO.getBuyerEmailAddress());
            if (CollectionUtils.isEmpty(pcsPoPlanVOsTmp)) {
                pcsPoPlanVOsTmp = new ArrayList<PcsPoPlanVO>();
                buyerPoPlanVOMap.put(pcsPoPlanVO.getBuyerEmailAddress(), pcsPoPlanVOsTmp);
            }
            pcsPoPlanVOsTmp.add(pcsPoPlanVO);
        }
    }

    private String formatDate(Date date, String format) {
        if (EmptyUtil.isEmpty((Object)date)) {
            return "";
        }
        return DateUtil.format((Date)date, (String)format);
    }

    private List<PoInfomationVO> findPoInfomation() {
        List<PoInfomationVO> poList = this.pcsPoPlanMapper.findPoInfomation();
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        return poList;
    }

    @Override
    @Transactional
    public Boolean createPoPlanAndLine(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) throws Exception {
        if (pcsPoPlanLineList.size() == 0) {
            throw new PurchaseException("PC0001", "\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u8ba1\u5212\u884c\u4fe1\u606f");
        }
        if (EmptyUtil.isEmpty((Object)(pcsPoPlan = this.create(pcsPoPlan)).getId())) {
            throw new PurchaseException("PC0009", "\u8ba1\u5212\u5934\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + pcsPoPlan.toString());
        }
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            line.setPoPlanId(pcsPoPlan.getId());
            if (this.pcsPoPlanLineService.create(line).compareTo(0L) >= 1) continue;
            throw new PurchaseException("PC0009", "\u8ba1\u5212\u884c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + line.toString());
        }
        WhCommandVO whCommand = this.bulidWhCommand(pcsPoPlan, pcsPoPlanLineList);
        pcsPoPlan.setWhCommandCode(this.wWhCommandService.createCommand(whCommand));
        if (!this.update(pcsPoPlan)) {
            throw new PurchaseException("PC0010", "\u8ba1\u5212\u5934\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + pcsPoPlan.toString());
        }
        PcsPurchaseOrder pcsPurchaseOrder = this.pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
        String poCode = pcsPurchaseOrder.getCode();
        pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE);
        this.pcsPurchaseOrderService.update(pcsPurchaseOrder);
        if (pcsPurchaseOrder.getNeedCustomsArrange().booleanValue()) {
            PcsPoPlanLogisticsBillVO logisticsBill = new PcsPoPlanLogisticsBillVO();
            logisticsBill.setPoCode(poCode);
            logisticsBill.setPopCode(pcsPoPlan.getCode());
            logisticsBill.setCreator(pcsPoPlan.getCreateOperatorId());
            logisticsBill.setCreateTime(pcsPoPlan.getCreateTime());
            logisticsBill.setBillStatus(PoLogisticsEnum.WAITING_SUBMIT.getKey());
            logisticsBill.setPoId(pcsPurchaseOrder.getId());
            logisticsBill.setPopId(pcsPoPlan.getId());
            this.pcsPoLogisticsBillService.savePopLogisticsBill(logisticsBill);
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean createPoPlanAndLineThenFinish(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) throws Exception {
        if (pcsPoPlanLineList.size() == 0) {
            throw new PurchaseException("PC0001", "\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u8ba1\u5212\u884c\u4fe1\u606f");
        }
        pcsPoPlan.setPlanedSendDate(DateUtil.getNow());
        pcsPoPlan.setPlanedReceiveDate(DateUtil.getNow());
        pcsPoPlan = this.create(pcsPoPlan);
        if (EmptyUtil.isEmpty((Object)pcsPoPlan.getId())) {
            throw new PurchaseException("PC0009", "\u8ba1\u5212\u5934\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + pcsPoPlan.toString());
        }
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            line.setPoPlanId(pcsPoPlan.getId());
            Integer quantity = line.getQuantity();
            Integer wasteQuantity = line.getWasteQuantity();
            if (this.pcsPoPlanLineService.create(line).compareTo(0L) < 1) {
                throw new PurchaseException("PC0009", "\u8ba1\u5212\u884c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25," + line.toString());
            }
            line.setQuantity(quantity);
            line.setWasteQuantity(wasteQuantity);
            if (this.pcsPoPlanLineService.update(line)) continue;
            throw new PurchaseException("PC0009", "\u8ba1\u5212\u884c\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + line.toString());
        }
        WhCommandVO whCommandForCreate = this.bulidWhCommand(pcsPoPlan, pcsPoPlanLineList);
        pcsPoPlan.setWhCommandCode(this.wWhCommandService.createCommandThenFinish(whCommandForCreate));
        if (EmptyUtil.isEmpty((String)pcsPoPlan.getWhCommandCode())) {
            throw new PurchaseException("PC0010", "\u4ed3\u5e93\u6307\u4ee4\u751f\u6210\u5931\u8d25," + pcsPoPlan.toString());
        }
        pcsPoPlan.setReceiveDate(DateUtil.getNow());
        pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_ALREADY_IN);
        if (!this.update(pcsPoPlan)) {
            throw new PurchaseException("PC0010", "\u8ba1\u5212\u5934\u4fe1\u606f\u66f4\u65b0\u5931\u8d25," + pcsPoPlan.toString());
        }
        return true;
    }

    @Override
    public List<PcsPoPlan> findPcsPoPlanByPoId(long poId) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andPoIdEqualTo(poId);
        List<PcsPoPlan> poList = this.pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        return poList;
    }

    @Override
    public List<PcsPoPlanVO> findPopVOsByCond(PcsPoPlanCond cond) {
        List<PcsPoPlanVO> poPlanVOs = this.pcsPoPlanMapper.findPopVOsByCond(cond);
        if (cond.isFetchPopLine() && CollectionUtils.isNotEmpty(poPlanVOs)) {
            ArrayList<Long> popIds = new ArrayList<Long>();
            poPlanVOs.forEach(pop -> popIds.add(pop.getId()));
            this.buildPopLineToPopVO(poPlanVOs, popIds);
        }
        return poPlanVOs;
    }

    @Override
    public List<PcsPoPlanVO> findPcsPoPlanByPoIds(List<Long> poIds, boolean cascade) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andPoIdIn((List)poIds);
        example.setOrderByClause("PO_ID desc");
        List<PcsPoPlan> poList = this.pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> poPlanIds = new ArrayList<Long>();
        ArrayList<PcsPoPlanVO> vos = new ArrayList<PcsPoPlanVO>(poList.size());
        for (PcsPoPlan record : poList) {
            poPlanIds.add(record.getId());
            PcsPoPlanVO vo = this.buildFromModel(record);
            vos.add(vo);
        }
        if (cascade) {
            this.buildPopLineToPopVO(vos, poPlanIds);
        }
        return vos;
    }

    private void buildPopLineToPopVO(List<PcsPoPlanVO> vos, List<Long> poPlanIds) {
        Map<Long, List<PcsPoPlanLineVO>> popLineMap = this.findPoPlanLineMap(poPlanIds);
        if (!popLineMap.isEmpty()) {
            for (PcsPoPlanVO vo : vos) {
                List<PcsPoPlanLineVO> lineList = popLineMap.get(vo.getId());
                if (!NullUtil.isNotNull(lineList)) continue;
                vo.setPcsPoPlanLineVOList(lineList);
            }
        }
    }

    @Override
    public List<PcsPoPlan> findPcsPoPlanByCond(PcsPoPlanCond cond) {
        PcsPoPlanExample example = this.buildPcsPoPlanExample(cond);
        return this.pcsPoPlanMapper.selectByExample(example);
    }

    private PcsPoPlanExample buildPcsPoPlanExample(PcsPoPlanCond cond) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        PcsPoPlanExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getCode())) {
            criteria.andCodeEqualTo(cond.getCode());
        } else if (CollectionUtils.isNotEmpty(cond.getCodes())) {
            criteria.andCodeIn((List)cond.getCodes());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getPlanStatus())) {
            criteria.andPlanStatusEqualTo(cond.getPlanStatus());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getPoId())) {
            criteria.andPoIdEqualTo(cond.getPoId());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getWhCommandCode())) {
            criteria.andWhCommandCodeEqualTo(cond.getWhCommandCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getWarnFlag())) {
            criteria.andWarnFlagEqualTo(cond.getWarnFlag());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getGoldjetInboundNum())) {
            criteria.andGoldjetInboundNumEqualTo(cond.getGoldjetInboundNum());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getBillOfLading())) {
            criteria.andBillOfLadingEqualTo(cond.getBillOfLading());
        } else if (EmptyUtil.isNotEmpty((String)cond.getBillOfLadingLike())) {
            criteria.andBillOfLadingLike(SQLUtils.allLike((String)cond.getBillOfLading()));
        }
        return example;
    }

    @Override
    public Map<Long, List<PcsPoPlanLineVO>> findPoPlanLineMap(List<Long> poPlanIds) {
        HashMap<Long, List<PcsPoPlanLineVO>> map = new HashMap<Long, List<PcsPoPlanLineVO>>();
        List<PcsPoPlanLineVO> lineList = this.pcsPoPlanLineService.findPoPlanLineVOByPoPlanIds(poPlanIds);
        if (EmptyUtil.isNotEmpty(lineList)) {
            for (PcsPoPlanLineVO poPlanLineVO : lineList) {
                ArrayList<PcsPoPlanLineVO> tmpList = (ArrayList<PcsPoPlanLineVO>)map.get(poPlanLineVO.getPoPlanId());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<PcsPoPlanLineVO>();
                    map.put(poPlanLineVO.getPoPlanId(), tmpList);
                }
                tmpList.add(poPlanLineVO);
            }
        }
        return map;
    }

    @Override
    @Transactional
    public Boolean synPoPlanAndLine(PcsPoPlan poPlan) {
        WhCommandVO whCommand = this.wWhCommandService.findCommandByCode(poPlan.getWhCommandCode(), true);
        if (EmptyUtil.isNotEmpty((Object)whCommand) && whCommand.getCommandStatus().equals(WhCommandVO.STATUS_FINISHED)) {
            List<PcsPoPlanLine> pcsPoPlanLineList = this.pcsPoPlanLineService.findPoPlanLineByPoPlanId(poPlan.getId());
            for (PcsPoPlanLine poPlanLine : pcsPoPlanLineList) {
                for (WhCommandSkuVO whCommandSku : whCommand.getWhCommandSkuList()) {
                    if (!poPlanLine.getSkuCode().equals(whCommandSku.getSkuCode())) continue;
                    poPlanLine.setQuantity(whCommandSku.getQuantity());
                    poPlanLine.setWasteQuantity(whCommandSku.getDamagedQuantity());
                    this.pcsPoPlanLineService.update(poPlanLine);
                }
            }
            poPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_ALREADY_IN);
            poPlan.setReceiveDate(whCommand.getProcessTime());
            this.update(poPlan);
        }
        return true;
    }

    @Override
    public byte[] exportPoInfomation() {
        List<PoInfomationVO> poList = this.findPoInfomation();
        if (CollectionUtils.isEmpty(poList)) {
            throw new PurchaseException("PC0001", "\u6ca1\u6709\u76f8\u5173\u6570\u636e");
        }
        HashMap sheets = new HashMap();
        ArrayList allLines = new ArrayList();
        ArrayList<String> head = new ArrayList<String>();
        head.add("\u91c7\u8d2d\u5355\u7f16\u53f7");
        head.add("\u91c7\u8d2d\u5355\u72b6\u6001");
        head.add("\u4f9b\u5e94\u5546");
        head.add("\u76ee\u6807\u4ed3\u5e93");
        head.add("\u521b\u5efa\u65f6\u95f4");
        head.add("\u521b\u5efa\u4eba");
        head.add("\u5ba1\u6838\u65f6\u95f4");
        head.add("SKU");
        head.add("SKU\u540d");
        head.add("\u8981\u6c42\u4ea4\u8d27\u65e5\u671f");
        head.add("\u6570\u91cf");
        head.add("\u5355\u4ef7");
        head.add("\u603b\u4ef7");
        head.add("\u5b9e\u6536\u826f\u54c1");
        head.add("\u5b9e\u6536\u6b8b\u6b21");
        head.add("\u5f85\u6536\u6570\u91cf");
        allLines.add(head);
        for (PoInfomationVO vo : poList) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(vo.getPoCode());
            list.add(vo.getPurchaseOrderStatus());
            list.add(vo.getSuppName());
            list.add(vo.getHouseName());
            list.add(vo.getCreateTime());
            list.add(vo.getNickName());
            list.add(vo.getAuditTime());
            list.add(vo.getSkuCode());
            list.add(vo.getSkuName());
            list.add(vo.getAskDeliveryDate());
            list.add(vo.getQuantity());
            list.add(vo.getUnitPriceAfterTax());
            list.add(vo.getTotalPriceAfterTax());
            list.add(vo.getReceiveQuantity());
            list.add(vo.getWasteQuantity());
            list.add(vo.getWaitStockAmout());
            allLines.add(list);
        }
        sheets.put("\u91c7\u8d2d\u5355\u660e\u7ec6", allLines);
        new ExcelUtil();
        byte[] res = ExcelUtil.write(sheets, (boolean)true);
        return res;
    }

    @Override
    public byte[] exportPoPlanStatusWaitingIn() {
        List<PcsPoPlan> poPlans = this.findPoPlanByStatus(PcsPoPlan.PLAN_STATUS_WAITING_IN);
        if (CollectionUtils.isEmpty(poPlans)) {
            throw new PurchaseException("PC0001", "\u6ca1\u6709\u76f8\u5173\u6570\u636e");
        }
        HashMap sheets = new HashMap();
        ArrayList allLines = new ArrayList();
        ArrayList<String> head = new ArrayList<String>();
        head.add("\u91c7\u8d2d\u5355\u7f16\u53f7");
        head.add("\u521b\u5efa\u4eba");
        head.add("SKU");
        head.add("SKU\u540d");
        head.add("\u91c7\u8d2d\u5355\u6570\u91cf");
        head.add("\u6536\u8d27\u8ba1\u5212\u7f16\u53f7");
        head.add("\u6536\u8d27\u72b6\u6001");
        head.add("\u8ba1\u5212\u53d1\u8d27\u65e5\u671f");
        head.add("\u8ba1\u5212\u6536\u8d27\u65e5\u671f");
        head.add("\u5b9e\u9645\u6536\u8d27\u65e5\u671f");
        head.add("\u8ba1\u5212\u5165\u6570\u91cf");
        allLines.add(head);
        HashMap<Long, PcsPurchaseOrderVO> poVOMap = new HashMap<Long, PcsPurchaseOrderVO>();
        HashMap<Long, List<PcsPoLine>> poLinesMap = new HashMap<Long, List<PcsPoLine>>();
        HashMap<Long, String> poAuditUserNameMap = new HashMap<Long, String>();
        for (PcsPoPlan pcsPoPlan : poPlans) {
            if (!poVOMap.containsKey(pcsPoPlan.getPoId())) {
                PcsPurchaseOrderVO poVO = this.pcsPurchaseOrderService.findPoVOById(pcsPoPlan.getPoId());
                poVOMap.put(pcsPoPlan.getPoId(), poVO);
            }
            if (!poLinesMap.containsKey(pcsPoPlan.getPoId())) {
                List<PcsPoLine> poLines = this.pcsPoLineService.findPoLineByPoId(pcsPoPlan.getPoId());
                poLinesMap.put(pcsPoPlan.getPoId(), poLines);
            }
            if (poAuditUserNameMap.containsKey(pcsPoPlan.getPoId())) continue;
            List commEntityOpRcds = this.commEntityOperationRcdService.findEntityOpRcdByClazzAndId("PcsPurchaseOrder", pcsPoPlan.getPoId().toString());
            poAuditUserNameMap.put(pcsPoPlan.getPoId(), "");
            for (CommEntityOpRcdVO commEntityOpRcd : commEntityOpRcds) {
                if (!commEntityOpRcd.getOperationDesc().equals("\u5ba1\u6838\u901a\u8fc7\u91c7\u8d2d\u5355")) continue;
                poAuditUserNameMap.put(pcsPoPlan.getPoId(), commEntityOpRcd.getOperatorName());
            }
        }
        HashMap<String, Integer> skuPoPlan = new HashMap<String, Integer>();
        for (PcsPoPlan poPlan : poPlans) {
            List<PcsPoPlanLineVO> poPlanLineVOs = this.pcsPoPlanLineService.findPoPlanLineVOByPoPlanId(poPlan.getId());
            PcsPurchaseOrderVO poVO = (PcsPurchaseOrderVO)poVOMap.get(poPlan.getPoId());
            List poLines = (List)poLinesMap.get(poPlan.getPoId());
            String poAuditUserName = (String)poAuditUserNameMap.get(poPlan.getPoId());
            for (PcsPoPlanLineVO poPlanLineVO : poPlanLineVOs) {
                String skuCode;
                skuPoPlan.put(skuCode, (skuPoPlan.get(skuCode = poPlanLineVO.getSkuCode()) == null ? 0 : (Integer)skuPoPlan.get(skuCode)) + 1);
                ArrayList<String> line = new ArrayList<String>();
                line.add(poVO.getCode());
                line.add(poVO.getCreateOperatorName());
                line.add(poPlanLineVO.getSkuCode());
                line.add(poPlanLineVO.getSkuNameCn());
                line.add(poPlanLineVO.getQuantity() + "");
                line.add(poPlan.getCode());
                line.add("\u5f85\u5165\u5e93");
                line.add(DateUtil.format((Date)poPlan.getPlanedSendDate(), (String)"yyyy-MM-dd"));
                line.add(DateUtil.format((Date)poPlan.getPlanedReceiveDate(), (String)"yyyy-MM-dd"));
                line.add(DateUtil.format((Date)poPlan.getReceiveDate(), (String)"yyyy-MM-dd"));
                line.add(poPlanLineVO.getPlanedQuantity().toString());
                allLines.add(line);
            }
        }
        sheets.put("\u6536\u8d27\u8ba1\u5212-\u5f85\u5165\u5e93", allLines);
        new ExcelUtil();
        byte[] byArray = ExcelUtil.write(sheets, (boolean)true);
        return byArray;
    }

    public Boolean check(Object obj) {
        PcsPoPlan record = (PcsPoPlan)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsPoPlan record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getPoId())) {
            throw new PurchaseException("PC0001", "\u91c7\u8d2d\u5355ID\u4e3a\u7a7a");
        }
        if (isCreate.booleanValue() && EmptyUtil.isEmpty((Object)this.pcsPurchaseOrderService.findPoById(record.getPoId()))) {
            throw new PurchaseException("PC0001", "\u91c7\u8d2d\u5355ID\u6570\u636e\u5e93\u4e0d\u5b58\u5728");
        }
        return true;
    }

    private Boolean check(String code) {
        return NullUtil.isNull((Object)this.findPoPlanByCode(code));
    }

    public String generateCode(Object id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        return CodeGenerator.getInstance().generate("PCS_PO_PLAN", params);
    }

    @Override
    public boolean updatePoPlan(PcsPoPlan po) {
        int rs = 0;
        rs = this.pcsPoPlanMapper.updateByPrimaryKeySelective(po);
        return rs > 0;
    }

    @Override
    public boolean updatePoPlanLine(PcsPoPlanLine line) {
        return this.pcsPoPlanLineMapper.updateByPrimaryKeySelective(line) != 0;
    }

    @Override
    public boolean isAllPoPlanFinished(Long poId) {
        int result = this.pcsPoPlanMapper.isAllPoPlanFinished(poId);
        return result == 0;
    }

    @Override
    public boolean isAllReceivePo(Long poId) {
        int result = this.pcsPoPlanMapper.isAllReceivePo(poId);
        return result == 0;
    }

    @Override
    @Transactional
    public Boolean closePoPlanByPlanId(Long poPlandId) {
        PcsPoPlan pcsPoPlan = this.pcsPoPlanMapper.selectByPrimaryKey(poPlandId);
        if (pcsPoPlan != null && pcsPoPlan.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE)) {
            this.pcsPoLogisticsBillService.closePoPlan(poPlandId);
            return this.closePoPlanByPlanId(pcsPoPlan);
        }
        throw new RuntimeException("\u6536\u8d27\u8ba1\u5212\u4e0d\u5b58\u5728\u6216\u6536\u8d27\u8ba1\u5212\u4e0d\u662f\u5f85\u6536\u8d27\u72b6\u6001");
    }

    @Override
    public Boolean closePoPlanByPlanIdCheckCommand(Long poPlandId, Integer whCommandId) {
        PcsPoPlan pcsPoPlan = this.pcsPoPlanMapper.selectByPrimaryKey(poPlandId);
        WhCommandVO whCommand = this.wWhCommandService.findCommandById(whCommandId, false);
        if (pcsPoPlan == null || whCommand == null || !WhCommandVO.STATUS_WAITING_QUALITY_CONTROL.equals(whCommand.getCommandStatus()) && !WhCommandVO.STATUS_QUALITY_PROCESSING.equals(whCommand.getCommandStatus())) {
            throw new RuntimeException("\u6536\u8d27\u8ba1\u5212\u4e0d\u5b58\u5728\u6216\u6307\u4ee4\u4e0d\u5b58\u5728\u6216\u6307\u4ee4\u4e0d\u662f(\u5f85\u8d28\u68c0\u3001\u8d28\u68c0\u4e2d)\u72b6\u6001");
        }
        return this.closePoPlanByPlanId(pcsPoPlan);
    }

    private Boolean closePoPlanByPlanId(PcsPoPlan pcsPoPlan) {
        PcsPurchaseOrder pcsPurchaseOrder;
        Integer hasReceive = this.pcsPoPlanMapper.checkPopHasReceive(pcsPoPlan.getId());
        WhCommandVO whCommand = this.wWhCommandService.findCommandByTypeAndReferenceCode(WhCommandVO.TYPE_PURCHASE_IN, pcsPoPlan.getCode(), false);
        if (EmptyUtil.isNotEmpty((Object)hasReceive) && hasReceive > 0) {
            pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_FINISHED);
            pcsPoPlan.setReceiveDate(DateUtil.getNow());
            this.pcsPoPlanMapper.updateByPrimaryKeySelective(pcsPoPlan);
            if (whCommand != null) {
                this.wWhCommandService.updateCommandStatusById(Integer.valueOf(Integer.parseInt(whCommand.getId() + "")), WhCommandVO.STATUS_QUALITY_FINISHED);
            }
        } else {
            pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_CLOSED);
            this.pcsPoPlanMapper.updateByPrimaryKey(pcsPoPlan);
            if (whCommand != null) {
                this.wWhCommandService.updateCommandStatusById(Integer.valueOf(Integer.parseInt(whCommand.getId() + "")), WhCommandVO.STATUS_FINISHED);
            }
        }
        List<PcsPoPlan> pcsPoPlanList = this.findPcsPoPlanByPoId(pcsPoPlan.getPoId());
        boolean isUpdate = true;
        for (PcsPoPlan pcsPoPlan1 : pcsPoPlanList) {
            if (!pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_IN) && !pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE) && !pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING)) continue;
            isUpdate = false;
            break;
        }
        if (isUpdate && !(pcsPurchaseOrder = this.pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId())).getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE)) {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
            this.pcsPurchaseOrderService.update(pcsPurchaseOrder);
        }
        return true;
    }

    @Override
    @Transactional
    public int createPoPlanFee(PcsPoPlanCost pcsPoPlanCost) {
        if (pcsPoPlanCost.getAvailable() == null) {
            pcsPoPlanCost.setAvailable((byte)1);
        }
        if (pcsPoPlanCost.getAvailable() == 1) {
            this.updatePoTotalAmount(pcsPoPlanCost, 0);
        }
        pcsPoPlanCost.setCreateTime(new Date());
        return this.pcsPoPlanCostMapper.insertSelective(pcsPoPlanCost);
    }

    @Override
    public int batchCreatePoPlanFee(List<PcsPoPlanCost> pcsPoPlanCosts) {
        this.batchUpdatePoTotalAmount(pcsPoPlanCosts, 0);
        return this.pcsPoPlanCostMapper.batchInsertPoPlanCost(pcsPoPlanCosts);
    }

    @Override
    public List<PcsPoPlanCost> selectCostByPoPlanId(Integer poPlanId) {
        return this.pcsPoPlanCostMapper.selectCostByPoPlanId(poPlanId);
    }

    @Override
    public List<PcsPoPlanCost> listPcsPoPlanCostByPopIds(List<Integer> popIds) {
        PcsPoPlanCostExample example = new PcsPoPlanCostExample();
        PcsPoPlanCostExample.Criteria criteria = example.createCriteria();
        criteria.andPoPlanIdIn((List)popIds);
        criteria.andAvailableEqualTo((byte)1);
        return this.pcsPoPlanCostMapper.selectByExample(example);
    }

    @Override
    public Map<Integer, List<PcsPoPlanCost>> mapPcsPoPlanCost(List<Integer> popIds) {
        HashMap<Integer, List<PcsPoPlanCost>> map = new HashMap<Integer, List<PcsPoPlanCost>>();
        List<PcsPoPlanCost> poPlanCosts = this.listPcsPoPlanCostByPopIds(popIds);
        if (EmptyUtil.isNotEmpty(poPlanCosts)) {
            poPlanCosts.forEach(poPlanCost -> {
                ArrayList<PcsPoPlanCost> tmpList = (ArrayList<PcsPoPlanCost>)map.get(poPlanCost.getPoPlanId());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<PcsPoPlanCost>();
                    map.put(poPlanCost.getPoPlanId(), tmpList);
                }
                tmpList.add((PcsPoPlanCost)poPlanCost);
            });
        }
        return map;
    }

    @Override
    public List<PcsPoPlanCostVO> listPoPlanCostVOsByGroup(PcsPoPlanCostCond cond) {
        return this.pcsPoPlanCostMapper.listPoPlanCostVOsByGroup(cond);
    }

    @Override
    public List<PcsPoPlanCostVO> listPoPlanCostVOs(PcsPoPlanCostCond cond) {
        return this.pcsPoPlanCostMapper.listPoPlanCostVOs(cond);
    }

    @Override
    public Pagination<PcsPoPlanCostVO> pagePoPlanCostVOs(PcsPoPlanCostCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.countPoPlanCostVOsByGroup(cond);
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return page;
        }
        List<PcsPoPlanCostVO> poPlanCostVOs = this.pcsPoPlanCostMapper.listPoPlanCostVOsByGroup(cond);
        page.setResultList(poPlanCostVOs);
        return page;
    }

    private Integer countPoPlanCostVOsByGroup(PcsPoPlanCostCond cond) {
        return this.pcsPoPlanCostMapper.countPoPlanCostVOsByGroup(cond);
    }

    @Override
    public List<PcsPoPlanCost> findPoCostDetails(Integer poId) {
        return this.pcsPoPlanCostMapper.findPoPCostDetailByPoId(poId);
    }

    @Override
    public int updatePoTotalAmount(PcsPoPlanCost pcsPoPlanCost, int optType) {
        return this.batchUpdatePoTotalAmount(Collections.singletonList(pcsPoPlanCost), optType);
    }

    public int batchUpdatePoTotalAmount(List<PcsPoPlanCost> pcsPoPlanCosts, int optType) {
        if (CollectionUtils.isEmpty(pcsPoPlanCosts)) {
            return 1;
        }
        Integer popId = pcsPoPlanCosts.get(0).getPoPlanId();
        PcsPurchaseOrder pcsPurchaseOrder = this.pcsPurchaseOrderService.findPoById(this.pcsPoPlanMapper.selectByPrimaryKey(Long.parseLong(popId.toString())).getPoId());
        BigDecimal purchaseCurrencyRate = pcsPurchaseOrder.getPurchaseCurrencyRate();
        if (optType == 0) {
            for (PcsPoPlanCost poPlanCost : pcsPoPlanCosts) {
                pcsPurchaseOrder.setTotalAmount(pcsPurchaseOrder.getTotalAmount().add(poPlanCost.getAfterTaxAmount().divide(purchaseCurrencyRate, 2, 5)));
                pcsPurchaseOrder.setTotalAmountAfterTax(pcsPurchaseOrder.getTotalAmountAfterTax().add(poPlanCost.getPreTaxAmount().divide(purchaseCurrencyRate, 2, 5)));
            }
        } else {
            for (PcsPoPlanCost poPlanCost : pcsPoPlanCosts) {
                pcsPurchaseOrder.setTotalAmount(pcsPurchaseOrder.getTotalAmount().subtract(poPlanCost.getAfterTaxAmount().divide(purchaseCurrencyRate, 2, 5)));
                pcsPurchaseOrder.setTotalAmountAfterTax(pcsPurchaseOrder.getTotalAmountAfterTax().subtract(poPlanCost.getPreTaxAmount().divide(purchaseCurrencyRate, 2, 5)));
            }
        }
        if (EmptyUtil.isNotEmpty((Object)pcsPurchaseOrder.getCrossBorderFlag()) && pcsPurchaseOrder.getCrossBorderFlag() == 1) {
            return this.pcsPurchaseOrderService.update(pcsPurchaseOrder) ? 1 : 0;
        }
        return 1;
    }

    @Override
    public int updatePoPlanFee(PcsPoPlanCost pcsPoPlanCost, int optType) {
        if (optType == 1) {
            PcsPoPlanCost oldPcsPoPlanCost = this.pcsPoPlanCostMapper.selectByPrimaryKey(pcsPoPlanCost.getId());
            this.updatePoTotalAmount(oldPcsPoPlanCost, 1);
        }
        return this.pcsPoPlanCostMapper.updateByPrimaryKeySelective(pcsPoPlanCost);
    }

    @Override
    public PcsPoPlanCost selectCostByCostId(Long costId) {
        return this.pcsPoPlanCostMapper.selectByPrimaryKey(costId);
    }

    @Override
    public Integer closePopPlanEndMonth() {
        return this.pcsPoPlanCostMapper.closePopPlanEndMonth();
    }
}

