/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.cond.PoLogisticsBillCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanLineMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanLogisticsBillMapper;
import com.thebeastshop.pegasus.service.purchase.enums.PoLogisticsEnum;
import com.thebeastshop.pegasus.service.purchase.enums.PoPCostTypeEnum;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCost;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLogisticsBill;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLogisticsBillExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLogisticsBillService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLogisticsBillVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPopFeeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PoLogisticsBillStatusTab;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsPoLogisticsBillService")
public class PcsPoLogisticsBillServiceImpl
implements PcsPoLogisticsBillService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PcsPoLogisticsBillServiceImpl.class);
    @Autowired
    private PcsPoPlanLogisticsBillMapper pcsPoPlanLogisticsBillMapper;
    @Autowired
    private PcsPoPlanLineMapper pcsPoPlanLineMapper;
    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;
    @Autowired
    private PcsPoPlanService pcsPoPlanService;

    @Override
    @Transactional
    public int savePopLogisticsBill(PcsPoPlanLogisticsBillVO logisticsBill) {
        PcsPoPlanLogisticsBill logisticsBillDO = this.buildVO2DO(logisticsBill);
        this.pcsPoPlanLineService.addPopLineHsCode(logisticsBill.getPopLines());
        boolean isSave = logisticsBill.isSave();
        if (!isSave) {
            logisticsBillDO.setSubmitApplicationTime(new Date());
            logisticsBillDO.setBillStatus(PoLogisticsEnum.PENDING.getKey());
        }
        if (logisticsBill.getId() == null) {
            return this.pcsPoPlanLogisticsBillMapper.insertSelective(logisticsBillDO);
        }
        return this.pcsPoPlanLogisticsBillMapper.updateByPrimaryKeySelective(logisticsBillDO);
    }

    @Override
    @Transactional
    public int savePopLogisticsBills(List<PcsPoPlanLogisticsBillVO> logisticsBills) {
        if (logisticsBills == null || logisticsBills.size() == 0) {
            return 0;
        }
        this.buildPopLogisticsBillsStatus(logisticsBills);
        this.savePOPFee(logisticsBills);
        List updateList = BeanUtil.buildListFrom(logisticsBills, PcsPoPlanLogisticsBill.class);
        return this.pcsPoPlanLogisticsBillMapper.batchUpdateByPrimaryKeySelective(updateList);
    }

    private void savePOPFee(List<PcsPoPlanLogisticsBillVO> logisticsBills) {
        List<Long> popIds = logisticsBills.stream().map(po -> po.getPopId()).collect(Collectors.toList());
        Map<Long, PcsPopFeeVO> popFeeMap = this.pcsPoPlanService.mapPopFee(popIds);
        Map<Integer, List<PcsPoPlanCost>> listMap = this.pcsPoPlanService.mapPcsPoPlanCost(popIds.stream().map(popId -> popId.intValue()).collect(Collectors.toList()));
        ArrayList<PcsPoPlanCost> pcsPoPlanCosts = new ArrayList<PcsPoPlanCost>();
        Date currentDateTime = new Date();
        ArrayList<Long> delIds = new ArrayList<Long>();
        logisticsBills.stream().forEach(logisticsBill -> {
            Long popId = logisticsBill.getPopId();
            PcsPopFeeVO popFeeVO = (PcsPopFeeVO)popFeeMap.get(popId);
            BigDecimal tariff = logisticsBill.getTariff();
            BigDecimal vat = logisticsBill.getVat();
            BigDecimal consumptionTaxAmount = logisticsBill.getConsumptionTaxAmount();
            BigDecimal internalFee = logisticsBill.getInternalFee();
            BigDecimal internationalFee = logisticsBill.getInternationalFee();
            PcsPoPlanCost pcsPoPlanCost = new PcsPoPlanCost();
            pcsPoPlanCost.setCreateTime(currentDateTime);
            pcsPoPlanCost.setPoPlanId(popId.intValue());
            pcsPoPlanCost.setOtherFeeType(-1);
            pcsPoPlanCost.setShipmentType(-1);
            pcsPoPlanCost.setTaxType(-1);
            pcsPoPlanCost.setAvailable((byte)1);
            pcsPoPlanCost.setTaxRate(BigDecimal.ZERO);
            List hisPopCosts = (List)listMap.get(popId.intValue());
            if (tariff != null && tariff.compareTo(popFeeVO.getTariffAmount()) != 0) {
                pcsPoPlanCost.setRelationMan(popFeeVO.getTariffAgent());
                pcsPoPlanCosts.add(this.buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.TAXES, 1, tariff));
                delIds.addAll(this.buildDeletePOPCost(PoPCostTypeEnum.TAXES, 1, hisPopCosts));
            }
            if (vat != null && vat.compareTo(popFeeVO.getVatAmount()) != 0) {
                pcsPoPlanCost.setRelationMan(popFeeVO.getVatAgent());
                pcsPoPlanCosts.add(this.buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.TAXES, 2, vat));
                delIds.addAll(this.buildDeletePOPCost(PoPCostTypeEnum.TAXES, 2, hisPopCosts));
            }
            if (consumptionTaxAmount != null && consumptionTaxAmount.compareTo(popFeeVO.getConsumptionTaxAmount()) != 0) {
                pcsPoPlanCost.setRelationMan(popFeeVO.getConsumptionTaxAgent());
                pcsPoPlanCosts.add(this.buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.TAXES, 3, consumptionTaxAmount));
                delIds.addAll(this.buildDeletePOPCost(PoPCostTypeEnum.TAXES, 3, hisPopCosts));
            }
            if (internalFee != null && internalFee.compareTo(popFeeVO.getInternalFee()) != 0) {
                pcsPoPlanCost.setRelationMan(logisticsBill.getInternalAgent());
                pcsPoPlanCosts.add(this.buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 13, internalFee));
                delIds.addAll(this.buildDeletePOPCost(PoPCostTypeEnum.LOGISTICS, 13, hisPopCosts));
            } else {
                String internalAgent = logisticsBill.getInternalAgent();
                if (internalAgent != null && !internalAgent.equals(popFeeVO.getInternalProxy())) {
                    pcsPoPlanCost.setRelationMan(logisticsBill.getInternalAgent());
                    pcsPoPlanCosts.add(this.buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 13, internalFee));
                    delIds.addAll(this.buildDeletePOPCost(PoPCostTypeEnum.LOGISTICS, 13, hisPopCosts));
                }
            }
            if (internationalFee != null && internationalFee.compareTo(popFeeVO.getInternationalFee()) != 0) {
                pcsPoPlanCost.setRelationMan(logisticsBill.getInternationalAgent());
                pcsPoPlanCosts.add(this.buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 14, internationalFee));
                delIds.addAll(this.buildDeletePOPCost(PoPCostTypeEnum.LOGISTICS, 14, hisPopCosts));
            } else {
                String internationalAgent = logisticsBill.getInternationalAgent();
                if (internationalAgent != null && !internationalAgent.equals(popFeeVO.getInternationalProxy())) {
                    pcsPoPlanCost.setRelationMan(logisticsBill.getInternationalAgent());
                    pcsPoPlanCosts.add(this.buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 14, internationalFee));
                    delIds.addAll(this.buildDeletePOPCost(PoPCostTypeEnum.LOGISTICS, 14, hisPopCosts));
                }
            }
        });
        if (pcsPoPlanCosts != null && pcsPoPlanCosts.size() > 0) {
            this.pcsPoPlanService.batchCreatePoPlanFee(pcsPoPlanCosts);
        }
        if (delIds != null && delIds.size() > 0) {
            this.pcsPoPlanService.delPoPlanFeeByIds(delIds);
        }
    }

    private PcsPoPlanCost buildPOPCost(PcsPoPlanCost pcsPoPlanCost, PoPCostTypeEnum poPCostTypeEnum, Integer feeType, BigDecimal feeAmount) {
        PcsPoPlanCost newPopCost = new PcsPoPlanCost();
        BeanUtils.copyProperties((Object)pcsPoPlanCost, (Object)newPopCost);
        newPopCost.setPreTaxAmount(feeAmount);
        newPopCost.setAfterTaxAmount(feeAmount);
        if (feeAmount.compareTo(BigDecimal.ZERO) <= 0) {
            newPopCost.setAvailable((byte)0);
        }
        switch (poPCostTypeEnum) {
            case OTHER: {
                newPopCost.setOtherFeeType(feeType);
                break;
            }
            case TAXES: {
                newPopCost.setTaxType(feeType);
                break;
            }
            case LOGISTICS: {
                newPopCost.setShipmentType(feeType);
                break;
            }
        }
        return newPopCost;
    }

    private List<Long> buildDeletePOPCost(PoPCostTypeEnum poPCostTypeEnum, Integer feeType, List<PcsPoPlanCost> hisPoPlanCosts) {
        ArrayList<Long> delIds = new ArrayList<Long>();
        if (hisPoPlanCosts != null && hisPoPlanCosts.size() > 0) {
            hisPoPlanCosts.stream().forEach(hisPoPlanCost -> {
                Long hisCostId = hisPoPlanCost.getId();
                switch (poPCostTypeEnum) {
                    case OTHER: {
                        break;
                    }
                    case TAXES: {
                        if (hisPoPlanCost.getTaxType() != feeType) break;
                        delIds.add(hisCostId);
                        break;
                    }
                    case LOGISTICS: {
                        if (hisPoPlanCost.getShipmentType() != feeType) break;
                        delIds.add(hisCostId);
                        break;
                    }
                }
            });
        }
        return delIds;
    }

    @Override
    public PcsPoPlanLogisticsBill buildVO2DO(PcsPoPlanLogisticsBillVO logisticsBill) {
        return (PcsPoPlanLogisticsBill)BeanUtil.buildFrom((Object)logisticsBill, PcsPoPlanLogisticsBill.class);
    }

    @Override
    public PcsPoPlanLogisticsBillVO buildDO2VO(PcsPoPlanLogisticsBill logisticsBill) {
        return (PcsPoPlanLogisticsBillVO)BeanUtil.buildFrom((Object)logisticsBill, PcsPoPlanLogisticsBillVO.class);
    }

    @Override
    public PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillById(Integer billId) {
        return this.buildDO2VO(this.pcsPoPlanLogisticsBillMapper.selectByPrimaryKey(billId));
    }

    @Override
    public PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillByPopCode(String popCode) {
        PcsPoPlanLogisticsBillExample example = new PcsPoPlanLogisticsBillExample();
        example.createCriteria().andPopCodeEqualTo(popCode);
        List<PcsPoPlanLogisticsBill> list = this.pcsPoPlanLogisticsBillMapper.selectByExample(example);
        if (list == null || list.size() == 0) {
            return null;
        }
        return this.buildDO2VO(list.get(0));
    }

    @Override
    public PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillByPopId(Long popId) {
        PcsPoPlanLogisticsBillExample example = new PcsPoPlanLogisticsBillExample();
        example.createCriteria().andPopIdEqualTo(popId);
        List<PcsPoPlanLogisticsBill> list = this.pcsPoPlanLogisticsBillMapper.selectByExample(example);
        if (list == null || list.size() == 0) {
            return null;
        }
        return this.buildDO2VO(list.get(0));
    }

    @Override
    public PageInfo<PcsPoPlanLogisticsBillVO> listBillByCond(PoLogisticsBillCond cond) {
        PageRowBounds pageRowBounds = new PageRowBounds(cond.getOffset().intValue(), cond.getPagenum().intValue());
        List<PcsPoPlanLogisticsBillVO> billVOS = this.pcsPoPlanLogisticsBillMapper.selectByCond(cond, pageRowBounds);
        this.buildPopDetailInfo(billVOS);
        PageInfo pageInfo = new PageInfo(billVOS);
        pageInfo.setTotal(pageRowBounds.getTotal().longValue());
        return pageInfo;
    }

    @Override
    public List<PoLogisticsBillStatusTab> countGroupByBillstatus(PoLogisticsBillCond cond) {
        return this.pcsPoPlanLogisticsBillMapper.countGroupByBillstatus(cond);
    }

    @Override
    public int cancelPopLogisticsBill(Integer id) {
        PcsPoPlanLogisticsBill bill = this.pcsPoPlanLogisticsBillMapper.selectByPrimaryKey(id);
        if (bill.getBillStatus() != PoLogisticsEnum.WAITING_SUBMIT.getKey()) {
            throw new PurchaseException("", "\u53ea\u6709\u5f85\u63d0\u4ea4\u72b6\u6001\u7269\u6d41\u5355\u624d\u53ef\u4ee5\u53d6\u6d88\uff01");
        }
        int rct = this.pcsPoPlanLogisticsBillMapper.cancelPopLogisticsBill(id);
        if (rct == 0) {
            throw new PurchaseException("", "\u53d6\u6d88\u5931\u8d25\uff01");
        }
        return 1;
    }

    @Override
    public List<PcsPoPlanLogisticsBillVO> listLogisticsBillByPoId(Long poId) {
        PcsPoPlanLogisticsBillExample example = new PcsPoPlanLogisticsBillExample();
        example.createCriteria().andPoIdEqualTo(poId);
        List<PcsPoPlanLogisticsBill> list = this.pcsPoPlanLogisticsBillMapper.selectByExample(example);
        if (list == null || list.size() == 0) {
            return null;
        }
        return BeanUtil.buildListFrom(list, PcsPoPlanLogisticsBillVO.class);
    }

    @Override
    public Boolean closePoPlan(Long poPlandId) {
        PcsPoPlanLogisticsBillVO pcsPoPlanLogisticsBillVO = this.getPcsPoPlanLogisticsBillByPopId(poPlandId);
        if (pcsPoPlanLogisticsBillVO == null) {
            return true;
        }
        int billStatus = pcsPoPlanLogisticsBillVO.getBillStatus();
        if (PoLogisticsEnum.CANCLE.getKey() == billStatus || PoLogisticsEnum.COMPLETED.getKey() == billStatus) {
            return true;
        }
        int newBillStatus = PoLogisticsEnum.WAITING_SUBMIT.getKey() == billStatus ? PoLogisticsEnum.CANCLE.getKey() : PoLogisticsEnum.COMPLETED.getKey();
        if (this.pcsPoPlanLogisticsBillMapper.updateLogisticsBillStatus(pcsPoPlanLogisticsBillVO.getId(), newBillStatus, billStatus) == 1) {
            return true;
        }
        LOGGER.info("\u5173\u95edPOP \u7269\u6d41\u5355\u72b6\u6001\u5f02\u5e38\uff0cPOP\u7269\u6d41\u5355INFO:{}", (Object)JSON.toJSONString((Object)pcsPoPlanLogisticsBillVO));
        throw new PurchaseException("", "\u7269\u6d41\u5355\u72b6\u6001\u5f02\u5e38");
    }

    private void buildPopLogisticsBillsStatus(List<PcsPoPlanLogisticsBillVO> updateList) {
        if (updateList != null && updateList.size() > 0) {
            int listSize = updateList.size();
            for (int i = 0; i < listSize; ++i) {
                PcsPoPlanLogisticsBillVO logisticsBill = updateList.get(i);
                Integer billStatus = logisticsBill.getBillStatus();
                if (billStatus == null) continue;
                if (billStatus == PoLogisticsEnum.PENDING.getKey()) {
                    Date actualDeliveryTime = logisticsBill.getActualDeliveryTime();
                    if (actualDeliveryTime != null) {
                        logisticsBill.setBillStatus(PoLogisticsEnum.COMPLETED.getKey());
                        if (actualDeliveryTime.before(DateUtil.parse((String)DateUtil.getNowFormat((String)"yyyy-MM-dd"), (String)"yyyy-MM-dd"))) continue;
                        this.sendSinceImportPOArrivalNotice(logisticsBill);
                        continue;
                    }
                    logisticsBill.setBillStatus(PoLogisticsEnum.PROCESSING.getKey());
                    continue;
                }
                if (billStatus != PoLogisticsEnum.PROCESSING.getKey() || logisticsBill.getActualDeliveryTime() == null) continue;
                logisticsBill.setBillStatus(PoLogisticsEnum.COMPLETED.getKey());
                if (logisticsBill.getActualDeliveryTime().before(DateUtil.parse((String)DateUtil.getNowFormat((String)"yyyy-MM-dd"), (String)"yyyy-MM-dd"))) continue;
                this.sendSinceImportPOArrivalNotice(logisticsBill);
            }
        }
    }

    private void sendSinceImportPOArrivalNotice(PcsPoPlanLogisticsBillVO poPlanLogisticsBill) {
        Long poCreator = poPlanLogisticsBill.getPoCreator();
        StringBuilder emailContentSb = new StringBuilder();
        emailContentSb.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
        emailContentSb.append("#table-5 td {color: #000;}");
        emailContentSb.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
        emailContentSb.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
        emailContentSb.append("<table id='table-5'><thead><th>PO\u5355\u53f7</th><th>POP\u5355\u53f7</th><th>\u521b\u5efa\u4eba</th><th>\u9884\u8ba1\u5230\u4ed3\u65e5\u671f</th></thead><tbody>");
        emailContentSb.append("<tr>");
        emailContentSb.append("<td>").append(poPlanLogisticsBill.getPoCode()).append("</td>");
        emailContentSb.append("<td>").append(poPlanLogisticsBill.getPopCode()).append("</td>");
        emailContentSb.append("<td>").append(poPlanLogisticsBill.getCreatorName()).append("</td>");
        emailContentSb.append("<td>").append(DateUtil.format((Date)poPlanLogisticsBill.getActualDeliveryTime(), (String)"yyyy-MM-dd")).append("</td>");
        emailContentSb.append("</tr>");
        emailContentSb.append("</tbody></table></html>");
        String emailTitle = "\u81ea\u8fdb\u53e3\u91c7\u8d2d\u5355\u9884\u8ba1\u5230\u8d27\u901a\u77e5";
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(poPlanLogisticsBill.getNoticeAddressList());
        emailVO.setSubject(emailTitle);
        emailVO.setContent(emailContentSb.toString());
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            try {
                LOGGER.info("\u5f00\u59cb\u53d1\u9001" + emailTitle + "\u90ae\u4ef6\uff1a" + emailVO.getToAddressList());
                boolean result = EmailUtil.getInstance().send(emailVO);
                LOGGER.info("\u6210\u529f\u53d1\u9001" + emailTitle + "\u90ae\u4ef6\uff1a" + emailVO.getToAddressList());
            }
            catch (Exception e) {
                LOGGER.error("\u81ea\u8fdb\u53e3\u91c7\u8d2d\u5355\u9884\u8ba1\u5230\u8d27\u901a\u77e5----POP{}", (Object)JSON.toJSONString((Object)poPlanLogisticsBill.getPopCode()));
                e.printStackTrace();
            }
        }
    }

    private void buildPopDetailInfo(List<PcsPoPlanLogisticsBillVO> bills) {
        if (bills != null) {
            ArrayList<Long> popIds = new ArrayList<Long>();
            int billQuantity = bills.size();
            for (PcsPoPlanLogisticsBillVO billVO : bills) {
                popIds.add(billVO.getPopId());
            }
            List<Map<String, String>> sumPopSkuTotalAmountMap = this.pcsPoPlanLineMapper.sumPopSkuTotalAmount(popIds);
            Map<Long, PcsPopFeeVO> pcsPopFeeMap = this.pcsPoPlanService.mapPopFee(popIds);
            for (int i = 0; i < billQuantity; ++i) {
                PcsPoPlanLogisticsBillVO billVO = bills.get(i);
                Long popId = billVO.getPopId();
                if (sumPopSkuTotalAmountMap == null || sumPopSkuTotalAmountMap.size() == 0) {
                    billVO.setGoodsValue(BigDecimal.ZERO);
                } else {
                    for (Map<String, String> map : sumPopSkuTotalAmountMap) {
                        if (!popId.equals(Long.valueOf(String.valueOf(map.get("key"))))) continue;
                        billVO.setGoodsValue(new BigDecimal(String.valueOf(map.get("value"))));
                        break;
                    }
                }
                PcsPopFeeVO popFeeVO = pcsPopFeeMap.get(popId);
                if (popFeeVO == null) continue;
                billVO.setTariff(popFeeVO.getTariffAmount() == null ? BigDecimal.ZERO : popFeeVO.getTariffAmount());
                billVO.setVat(popFeeVO.getVatAmount() == null ? BigDecimal.ZERO : popFeeVO.getVatAmount());
                billVO.setInternationalFee(popFeeVO.getInternationalFee() == null ? BigDecimal.ZERO : popFeeVO.getInternationalFee());
                billVO.setInternalFee(popFeeVO.getInternalFee() == null ? BigDecimal.ZERO : popFeeVO.getInternalFee());
                billVO.setInternationalAgent(popFeeVO.getInternationalProxy());
                billVO.setInternalAgent(popFeeVO.getInternalProxy());
                billVO.setConsumptionTaxAmount(popFeeVO.getConsumptionTaxAmount());
            }
        }
    }
}

