/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsPoLineMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLineExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoLineVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsPoLineService")
public class PcsPoLineServiceImpl
implements PcsPoLineService,
CheckAble {
    private final Logger log = LoggerFactory.getLogger(PcsPoLineServiceImpl.class);
    @Autowired
    private PcsPoLineMapper pcsPoLineMapper;

    public Boolean check(Object obj) {
        PcsPoLine record = (PcsPoLine)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(PcsPoLine record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    @Override
    public PcsPoLine buildFromVO(PcsPoLineVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsPoLine record = new PcsPoLine();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsPoLineVO buildFromModel(PcsPoLine record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsPoLineVO vo = new PcsPoLineVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    public List<PcsPoLineVO> buildFromModel(List<PcsPoLine> records) {
        if (records == null || records.size() == 0) {
            return null;
        }
        ArrayList<PcsPoLineVO> voList = new ArrayList<PcsPoLineVO>();
        for (PcsPoLine pcsPoLine : records) {
            PcsPoLineVO pcsPoLineVO = this.buildFromModel(pcsPoLine);
            if (pcsPoLineVO == null) continue;
            voList.add(pcsPoLineVO);
        }
        return voList;
    }

    @Override
    @Transactional
    public Long create(PcsPoLine record) {
        if (this.check(record).booleanValue() && this.check(record, true).booleanValue()) {
            this.pcsPoLineMapper.insertSelective(record);
            return record.getId();
        }
        return null;
    }

    @Override
    public boolean update(PcsPoLineVO pcsPoLineVO) {
        return this.update(this.buildFromVO(pcsPoLineVO));
    }

    @Override
    @Transactional
    public boolean update(PcsPoLine record) {
        if (this.check(record).booleanValue() && this.check(record, false).booleanValue()) {
            return this.pcsPoLineMapper.updateByPrimaryKeySelective(record) != 0;
        }
        return false;
    }

    @Override
    public PcsPoLine findPoLineById(long id) {
        return this.pcsPoLineMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsPoLineVO> findPoLineByPoIds(List<Long> poIds) {
        PcsPoLineExample example = new PcsPoLineExample();
        example.createCriteria().andPoIdIn((List)poIds);
        return this.buildFromModel(this.pcsPoLineMapper.selectByExample(example));
    }

    @Override
    public List<PcsPoLine> findPoLineByPoId(long poId) {
        PcsPoLineExample example = new PcsPoLineExample();
        example.createCriteria().andPoIdEqualTo(poId);
        List<PcsPoLine> poLineList = this.pcsPoLineMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poLineList)) {
            return Collections.emptyList();
        }
        return poLineList;
    }

    @Override
    public List<PcsPoLineVO> findPoLineVOByPoId(long poId) {
        List<PcsPoLineVO> vos = this.pcsPoLineMapper.findPoLineVOByPoId(poId);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public List<PcsPoLineVO> findPoLineVOByPoIdForExcel(long poId) {
        List<PcsPoLineVO> vos = this.pcsPoLineMapper.findPoLineVOByPoIdForExcel(poId);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public List<PcsPoLineVO> findPoLineVOById(long id) {
        List<PcsPoLineVO> vos = this.pcsPoLineMapper.findPoLineVOById(id);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public List<PcsPoLineVO> findPackageNumBySku(PcsPoLineVO pcsPpLinevo) {
        List<PcsPoLineVO> vos = this.pcsPoLineMapper.findPackageNumBySku(pcsPpLinevo);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public List<PcsPoLineVO> findAutomaticTransferAllot(PcsPoPlan pcsPoPlan) {
        List<PcsPoLineVO> vos = this.pcsPoLineMapper.findAutomaticTransferAllot(pcsPoPlan);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    @Transactional
    public Boolean deleteById(long id) {
        PcsPoLine record = this.findPoLineById(id);
        if (EmptyUtil.isNotEmpty((Object)record)) {
            return this.pcsPoLineMapper.deleteByPrimaryKey(id) != 0;
        }
        return false;
    }

    @Override
    public List<PcsPoLineVO> findPoSkuByPoId(long poId) {
        List<PcsPoLineVO> vos = this.pcsPoLineMapper.findPoSkuByPoId(poId);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public List<PcsPoLineVO> findSkuByPoCode(String poCode) {
        List<PcsPoLineVO> vos = this.pcsPoLineMapper.findSkuByPoCode(poCode);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public List<PcsPoLineVO> selectCanAutoCreatePopLines() {
        return this.pcsPoLineMapper.selectCanAutoCreatePopLines();
    }
}

