/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.common.Pagination;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.kit.redis.util.RedisClient;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerDeliveryCapacityCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerDeliveryCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerRecipePlanCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerRecipeSkuCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerDeliveryMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerDeliveryRecipeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerMonthlyCapacityLogMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerMonthlyCapacitySettingMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerRecipeSkuMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDelivery;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDeliveryDate;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDeliveryExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDeliveryRecipe;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDeliveryRecipeExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerMonthlyCapacityLog;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerMonthlyCapacitySetting;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerRecipeSku;
import com.thebeastshop.pegasus.service.purchase.service.PcsFlowerDeliveryRecipePhyWhCapacityService;
import com.thebeastshop.pegasus.service.purchase.service.PcsFlowerDeliveryService;
import com.thebeastshop.pegasus.service.purchase.vo.FlowerRecipeMaterialVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerDeliveryCityCountExcelVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerDeliveryNotSendPackageExcelVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerDeliveryRecipeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerDeliveryShouldSendPackageExcelVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerDeliveryStoreCountExcelVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerDeliveryVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerDeliveryWhCountExcelVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerMerchantibleVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerMonCapaLogVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerMonCapaSettingVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerMonTaskVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerRecipeSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerSkuStatisticsVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsRecipeSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeMaterialVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.stock.dto.SFlowerMonthlyCityDTO;
import com.thebeastshop.stock.dto.SFlowerMonthlyQueryDTO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
import com.thebeastshop.stock.service.SFlowerMonthlyService;
import com.thebeastshop.wms.sservice.WWhCommandService;
import com.thebeastshop.wms.vo.WhWarehouseGroupVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service(value="pcsFlowerDeliveryService")
public class PcsFlowerDeliveryServiceImpl
implements PcsFlowerDeliveryService {
    private final Logger log = LoggerFactory.getLogger(PcsFlowerDeliveryServiceImpl.class);
    @Autowired
    PcsFlowerDeliveryMapper pcsFlowerDeliveryMapper;
    @Autowired
    PcsFlowerDeliveryRecipeMapper pcsFlowerDeliveryRecipeMapper;
    @Autowired
    PcsFlowerRecipeSkuMapper pcsFlowerRecipeSkuMapper;
    @Autowired
    private PcsFlowerMonthlyCapacitySettingMapper pcsFlowerMonthlyCapacitySettingMapper;
    @Autowired
    private PcsFlowerDeliveryRecipePhyWhCapacityService pcsFlowerDeliveryRecipePhyWhCapacityService;
    @Autowired
    private PcsFlowerMonthlyCapacityLogMapper pcsFlowerMonthlyCapacityLogMapper;
    @Autowired
    private SFlowerMonthlyService flowerMonthlyService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private WWhCommandService wWhCommandService;
    private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();

    @Override
    public Pagination<PcsFlowerDeliveryVO> getFlowerDeliveryByCond(PcsFlowerDeliveryCond cond) {
        int count = this.pcsFlowerDeliveryMapper.getFlowerDeliveryCountByCond(cond);
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return null;
        }
        List<PcsFlowerDeliveryVO> pcsFlowerDeliveries = this.pcsFlowerDeliveryMapper.getFlowerDeliveryByCond(cond);
        if (CollectionUtils.isNotEmpty(pcsFlowerDeliveries)) {
            for (PcsFlowerDeliveryVO pcsFlowerDelivery : pcsFlowerDeliveries) {
                pcsFlowerDelivery.setSendDate(pcsFlowerDelivery.getSendDate());
                Long currentRecipeId = pcsFlowerDelivery.getRecipeId();
                StringBuffer recipeName = new StringBuffer("");
                List<Object> pcsFlowerRecipeSkuVOs = new ArrayList();
                if (currentRecipeId != null) {
                    pcsFlowerRecipeSkuVOs = this.pcsFlowerRecipeSkuMapper.getFlowerRecipeSkuByCond(currentRecipeId);
                }
                if (CollectionUtils.isNotEmpty(pcsFlowerRecipeSkuVOs)) {
                    for (PcsFlowerRecipeSkuVO pcsFlowerRecipeSkuVO : pcsFlowerRecipeSkuVOs) {
                        if (pcsFlowerRecipeSkuVO == null) continue;
                        recipeName = recipeName.append("[").append(pcsFlowerRecipeSkuVO.getSkuCode()).append("]").append(pcsFlowerRecipeSkuVO.getSkuName() == null ? "" : pcsFlowerRecipeSkuVO.getSkuName()).append("*").append(pcsFlowerRecipeSkuVO.getQuantity()).append("</br>");
                    }
                    pcsFlowerDelivery.setRecipe(recipeName.toString());
                    continue;
                }
                pcsFlowerDelivery.setRecipe("");
            }
        } else {
            return null;
        }
        page.setResultList(pcsFlowerDeliveries);
        return page;
    }

    @Override
    public PcsFlowerDeliveryVO getFlowerDeliveryBySku(PcsFlowerDeliveryCond cond) {
        return this.pcsFlowerDeliveryMapper.getFlowerDeliveryBySku(cond);
    }

    @Override
    public PcsFlowerDeliveryRecipe getFlowerDeliveryRecipeById(Long recipeId) {
        return this.pcsFlowerDeliveryRecipeMapper.selectByPrimaryKey(recipeId);
    }

    @Override
    public List<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryRecipeByCond(PcsFlowerDeliveryCond cond) {
        List<PcsFlowerDeliveryRecipeVO> pcsFlowerDeliveries = this.pcsFlowerDeliveryRecipeMapper.getFlowerDeliveryDetailByCond(cond);
        return pcsFlowerDeliveries;
    }

    @Override
    public Pagination<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryDetailByCond(PcsFlowerDeliveryCond cond) {
        int count = this.pcsFlowerDeliveryRecipeMapper.getFlowerDeliveryDetailCountByCond(cond);
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return null;
        }
        List<PcsFlowerDeliveryRecipeVO> pcsFlowerDeliveries = this.pcsFlowerDeliveryRecipeMapper.getFlowerDeliveryDetailByCond(cond);
        if (CollectionUtils.isEmpty(pcsFlowerDeliveries)) {
            return null;
        }
        for (PcsFlowerDeliveryRecipeVO pcsFlowerDelivery : pcsFlowerDeliveries) {
            StringBuffer recipeName = new StringBuffer("");
            List<Object> pcsFlowerRecipeSkuVOs = new ArrayList();
            pcsFlowerRecipeSkuVOs = this.pcsFlowerRecipeSkuMapper.getFlowerRecipeSkuByCond(pcsFlowerDelivery.getId());
            if (CollectionUtils.isNotEmpty(pcsFlowerRecipeSkuVOs)) {
                for (PcsFlowerRecipeSkuVO pcsFlowerRecipeSkuVO : pcsFlowerRecipeSkuVOs) {
                    if (pcsFlowerRecipeSkuVO == null) continue;
                    recipeName = recipeName.append("[").append(pcsFlowerRecipeSkuVO.getSkuCode()).append("]").append(pcsFlowerRecipeSkuVO.getSkuName() == null ? "" : pcsFlowerRecipeSkuVO.getSkuName()).append("*").append(pcsFlowerRecipeSkuVO.getQuantity()).append("</br>");
                }
                pcsFlowerDelivery.setRecipeName(recipeName.toString());
                continue;
            }
            pcsFlowerDelivery.setRecipeName("");
        }
        page.setResultList(pcsFlowerDeliveries);
        return page;
    }

    @Override
    @Transactional
    public boolean saveFlowerDelivery(PcsFlowerDeliveryCond cond) {
        PcsFlowerDelivery pcsFlowerDelivery = new PcsFlowerDelivery();
        pcsFlowerDelivery.setSku(cond.getSkuCode());
        pcsFlowerDelivery.setDeliveryDay(cond.getReceiveWeekDay());
        pcsFlowerDelivery.setDeliveryTimes(cond.getSendTimes());
        pcsFlowerDelivery.setRuleNumber(cond.getRuleNumber());
        pcsFlowerDelivery.setCutoffDay(cond.getCutOffWeekDay());
        pcsFlowerDelivery.setCutoffTime(cond.getCutOffTime());
        pcsFlowerDelivery.setIsStockBalance(cond.getIsStockBalance());
        pcsFlowerDelivery.setSafeStock(cond.getSafeStock());
        pcsFlowerDelivery.setProducer(cond.getProducer());
        pcsFlowerDelivery.setDeliveryInterval(cond.getDeliveryInterval());
        if (cond.getRecipeId() == null) {
            pcsFlowerDelivery.setUseableStatue(1);
            this.pcsFlowerDeliveryMapper.insert(pcsFlowerDelivery);
            Date receiveDate = DateUtil.getCurrWeek((int)cond.getReceiveWeekDay());
            Calendar receiveCalendar = Calendar.getInstance();
            receiveCalendar.setTime(receiveDate);
            Calendar now = Calendar.getInstance();
            now.set(11, 0);
            now.set(12, 0);
            now.set(13, 0);
            if (receiveCalendar.getTimeInMillis() < now.getTimeInMillis()) {
                receiveCalendar.add(5, 7);
            }
            ArrayList<PcsFlowerDeliveryRecipe> list = new ArrayList<PcsFlowerDeliveryRecipe>();
            for (int i = 0; i < 260; ++i) {
                PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe = new PcsFlowerDeliveryRecipe();
                pcsFlowerDeliveryRecipe.setSkuCode(cond.getSkuCode());
                pcsFlowerDeliveryRecipe.setReceiveDay(receiveCalendar.getTime());
                if (PcsFlowerDeliveryVO.PRODUCER_WAREHOUSE.equals(cond.getProducer())) {
                    pcsFlowerDeliveryRecipe.setSendDay(DateUtils.addDays((Date)receiveCalendar.getTime(), (int)-1));
                } else {
                    pcsFlowerDeliveryRecipe.setSendDay(receiveCalendar.getTime());
                }
                pcsFlowerDeliveryRecipe.setUseableState(1);
                pcsFlowerDeliveryRecipe.setFinishState(0);
                list.add(pcsFlowerDeliveryRecipe);
                receiveCalendar.add(5, 7);
            }
            this.pcsFlowerDeliveryRecipeMapper.batchInsert(list);
            this.pcsFlowerDeliveryRecipePhyWhCapacityService.refreshFlowerDeliveryRecipePhyWhCapacity(pcsFlowerDelivery.getSku());
        } else {
            pcsFlowerDelivery.setId(cond.getRecipeId());
            this.pcsFlowerDeliveryMapper.updateByPrimaryKeySelective(pcsFlowerDelivery);
        }
        this.updateFlowerFinishStateChange(pcsFlowerDelivery.getSku());
        return true;
    }

    @Override
    public List<String> getPackageDeliveryDate(Long packageId, Long salesOrderId) {
        return this.pcsFlowerDeliveryRecipeMapper.selectPackageDeliveryDate(packageId, salesOrderId);
    }

    @Override
    public List<PcsFlowerRecipeSkuVO> getFlowerRecipeSkuByCond(Long recipeId) {
        return this.pcsFlowerRecipeSkuMapper.getFlowerRecipeSkuByCond(recipeId);
    }

    @Override
    public boolean addFlowerRecipeSku(PcsRecipeSkuVO pcsRecipeSkuVO) {
        try {
            long recipeId = pcsRecipeSkuVO.getRecipeId();
            for (PrdcRecipeMaterialVO prdcRecipeMaterialVO : pcsRecipeSkuVO.getRecipeMaterialVOList()) {
                PcsFlowerRecipeSku pcsFlowerRecipeSku = new PcsFlowerRecipeSku();
                pcsFlowerRecipeSku.setRecipeId(recipeId);
                pcsFlowerRecipeSku.setSkuType(prdcRecipeMaterialVO.getMaterialType());
                pcsFlowerRecipeSku.setSkuCode(prdcRecipeMaterialVO.getSkuCode());
                pcsFlowerRecipeSku.setExpendNumber(prdcRecipeMaterialVO.getQuantity());
                pcsFlowerRecipeSku.setAvailable(1);
                this.pcsFlowerRecipeSkuMapper.insert(pcsFlowerRecipeSku);
            }
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updateFlowerRecipeSku(PcsRecipeSkuVO pcsRecipeSkuVO) {
        List<PrdcRecipeMaterialVO> prdcRecipeMaterialVOs = pcsRecipeSkuVO.getRecipeMaterialVOList();
        List<PcsFlowerRecipeSkuVO> pcsFlowerRecipeSkuVOs = this.pcsFlowerRecipeSkuMapper.getFlowerRecipeSkuByCond(pcsRecipeSkuVO.getRecipeId());
        if (CollectionUtils.isEmpty(prdcRecipeMaterialVOs) && CollectionUtils.isEmpty(pcsFlowerRecipeSkuVOs)) {
            return true;
        }
        try {
            PcsFlowerRecipeSku pcsFlowerRecipeSku;
            if (CollectionUtils.isNotEmpty(pcsFlowerRecipeSkuVOs)) {
                for (PcsFlowerRecipeSkuVO pcsFlowerRecipeSkuVO : pcsFlowerRecipeSkuVOs) {
                    if (pcsFlowerRecipeSkuVO == null) continue;
                    pcsFlowerRecipeSku = new PcsFlowerRecipeSku();
                    pcsFlowerRecipeSku.setId(pcsFlowerRecipeSkuVO.getId());
                    pcsFlowerRecipeSku.setAvailable(0);
                    this.pcsFlowerRecipeSkuMapper.updateByPrimaryKeySelective(pcsFlowerRecipeSku);
                }
            }
            if (CollectionUtils.isNotEmpty(prdcRecipeMaterialVOs)) {
                for (PrdcRecipeMaterialVO prdcRecipeMaterialVO : prdcRecipeMaterialVOs) {
                    pcsFlowerRecipeSku = new PcsFlowerRecipeSku();
                    pcsFlowerRecipeSku.setRecipeId(pcsRecipeSkuVO.getRecipeId());
                    pcsFlowerRecipeSku.setSkuType(prdcRecipeMaterialVO.getMaterialType());
                    pcsFlowerRecipeSku.setSkuCode(prdcRecipeMaterialVO.getSkuCode());
                    pcsFlowerRecipeSku.setExpendNumber(prdcRecipeMaterialVO.getQuantity());
                    pcsFlowerRecipeSku.setAvailable(1);
                    this.pcsFlowerRecipeSkuMapper.insert(pcsFlowerRecipeSku);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean updateFlowerRecipeById(PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe) {
        this.pcsFlowerDeliveryRecipeMapper.updateByPrimaryKeySelective(pcsFlowerDeliveryRecipe);
        return true;
    }

    @Override
    @Transactional
    public boolean updateFlowerDeliveryById(PcsFlowerDelivery pcsFlowerDelivery) {
        try {
            this.pcsFlowerDeliveryMapper.updateByPrimaryKeySelective(pcsFlowerDelivery);
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updateFlowerDeliveryUseableById(PcsFlowerDelivery pcsFlowerDelivery) {
        try {
            pcsFlowerDelivery.setId(pcsFlowerDelivery.getId());
            pcsFlowerDelivery.setUseableStatue(1);
            this.pcsFlowerDeliveryMapper.updateByPrimaryKeySelective(pcsFlowerDelivery);
            this.pcsFlowerDeliveryRecipeMapper.updateCurrBeforeFinish(pcsFlowerDelivery.getSku());
            this.pcsFlowerDeliveryRecipeMapper.updateCurrAfterNoFinish(pcsFlowerDelivery.getSku());
            PcsFlowerDeliveryRecipeExample pcsFlowerDeliveryRecipeExample = new PcsFlowerDeliveryRecipeExample();
            pcsFlowerDeliveryRecipeExample.createCriteria().andSendDayGreaterThan(Calendar.getInstance().getTime());
            pcsFlowerDeliveryRecipeExample.setOrderByClause("SEND_DAY asc");
            List<PcsFlowerDeliveryRecipe> pcsFlowerDeliveryRecipeList = this.pcsFlowerDeliveryRecipeMapper.selectByExample(pcsFlowerDeliveryRecipeExample);
            Date cutDate = DateUtil.getCurrWeek((int)pcsFlowerDelivery.getCutoffDay());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(cutDate);
            String[] time = pcsFlowerDelivery.getCutoffTime().split(":");
            if (time.length == 3) {
                calendar.set(11, Integer.parseInt(time[0]));
                calendar.set(12, Integer.parseInt(time[1]));
                calendar.set(13, Integer.parseInt(time[2]));
            }
            if (Calendar.getInstance().getTimeInMillis() > calendar.getTimeInMillis() && pcsFlowerDeliveryRecipeList != null) {
                PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe = pcsFlowerDeliveryRecipeList.get(0);
                pcsFlowerDeliveryRecipe.setFinishState(1);
                this.pcsFlowerDeliveryRecipeMapper.updateByPrimaryKey(pcsFlowerDeliveryRecipe);
            }
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public List<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryDate(String skuCode) {
        return this.pcsFlowerDeliveryRecipeMapper.getFlowerDeliveryDate(null);
    }

    @Override
    public Map<String, PcsFlowerDeliveryDate> getFlowerStockAndDate(List<SFlowerMonthlyQueryDTO> queryList, Date date, String channelCode) {
        HashMap<String, PcsFlowerDeliveryDate> map = new HashMap<String, PcsFlowerDeliveryDate>();
        for (SFlowerMonthlyQueryDTO queryDTO : queryList) {
            map.put(queryDTO.getSkuCode(), this.getFlowerStockAndDate(queryDTO, date, channelCode));
        }
        return map;
    }

    @Override
    public PcsFlowerDeliveryDate getFlowerStockAndDate(SFlowerMonthlyQueryDTO queryDTO, Date payTime, String channelCode) {
        PcsFlowerDeliveryDate pcsFlowerDeliveryDate;
        String stockProducerKey = queryDTO.getsFlowerProductionTypeEnum().equals((Object)SFlowerProductionTypeEnum.STORE) ? String.valueOf(queryDTO.getCityId()) : "WH02060001";
        String deliveryRulesKey = "flowerMonthly:DeliveryRules:" + queryDTO.getSkuCode() + ":" + stockProducerKey;
        Object deliveryRules = this.redisClient.getCache(deliveryRulesKey);
        if (EmptyUtil.isNotEmpty((Object)deliveryRules)) {
            pcsFlowerDeliveryDate = (PcsFlowerDeliveryDate)deliveryRules;
        } else {
            pcsFlowerDeliveryDate = this.getFlowerStockAndDateInDB(queryDTO, payTime);
            this.redisClient.putCache(deliveryRulesKey, (Object)pcsFlowerDeliveryDate);
        }
        return pcsFlowerDeliveryDate;
    }

    private void refreshDeliveryCache(String skuCode, Integer flowerProductionType) {
        SFlowerProductionTypeEnum flowerProductionTypeEnum = flowerProductionType == 1 ? SFlowerProductionTypeEnum.STORE : SFlowerProductionTypeEnum.WAREHOUSE;
        SFlowerMonthlyQueryDTO queryDTO = new SFlowerMonthlyQueryDTO();
        queryDTO.setsFlowerProductionTypeEnum(flowerProductionTypeEnum);
        queryDTO.setSkuCode(skuCode);
        String deliveryRulesKey = "flowerMonthly:DeliveryRules:" + queryDTO.getSkuCode() + ":";
        if (flowerProductionTypeEnum.equals((Object)SFlowerProductionTypeEnum.STORE)) {
            ArrayList<String> skuCodes = new ArrayList<String>();
            skuCodes.add(skuCode);
            List cityList = this.flowerMonthlyService.getCityList(skuCodes);
            if (EmptyUtil.isNotEmpty((List)cityList)) {
                for (SFlowerMonthlyCityDTO flowerMonthlyCityDTO : cityList) {
                    queryDTO.setCityId(flowerMonthlyCityDTO.getCityId());
                    this.redisClient.putCache(deliveryRulesKey + String.valueOf(flowerMonthlyCityDTO.getCityId()), (Object)this.getFlowerStockAndDateInDB(queryDTO, new Date()));
                }
            }
        } else {
            this.redisClient.putCache(deliveryRulesKey + "WH02060001", (Object)this.getFlowerStockAndDateInDB(queryDTO, new Date()));
        }
    }

    private PcsFlowerDeliveryDate getFlowerStockAndDateInDB(SFlowerMonthlyQueryDTO queryDTO, Date payTime) {
        PcsFlowerDeliveryDate pcsFlowerDeliveryDate = new PcsFlowerDeliveryDate();
        PcsFlowerDeliveryCond skuCond = new PcsFlowerDeliveryCond();
        skuCond.setSkuCode(queryDTO.getSkuCode());
        skuCond.setIsUseable(1);
        skuCond.setFinishState(0);
        int totalStock = 0;
        Integer capacityQuantity = 0;
        PcsFlowerDeliveryVO pcsFlowerDeliveryVO = this.pcsFlowerDeliveryMapper.getFlowerDeliveryBySku(skuCond);
        if (pcsFlowerDeliveryVO == null) {
            pcsFlowerDeliveryDate.setCanSale(false);
            ArrayList<PcsFlowerDeliveryRecipeVO> useableDateList = new ArrayList<PcsFlowerDeliveryRecipeVO>();
            useableDateList.add(new PcsFlowerDeliveryRecipeVO());
            pcsFlowerDeliveryDate.setDeliveryDate(useableDateList);
            this.refreshSoldCache(queryDTO, capacityQuantity, totalStock);
            return pcsFlowerDeliveryDate;
        }
        Date cutDate = DateUtil.getCurrWeek((int)pcsFlowerDeliveryVO.getCutOffWeekDay());
        Calendar cutCalendar = Calendar.getInstance();
        cutCalendar.setTime(cutDate);
        String[] time = pcsFlowerDeliveryVO.getCutOffTime().split(":");
        if (time.length == 3) {
            cutCalendar.set(11, Integer.parseInt(time[0]));
            cutCalendar.set(12, Integer.parseInt(time[1]));
            cutCalendar.set(13, Integer.parseInt(time[2]));
        }
        if (cutCalendar.getTimeInMillis() < Calendar.getInstance().getTimeInMillis()) {
            cutCalendar.add(5, 7);
        }
        Calendar payDateTime = Calendar.getInstance();
        payDateTime.setTime(payTime);
        if (payDateTime.getTimeInMillis() > cutCalendar.getTimeInMillis()) {
            cutCalendar.add(5, 7);
        }
        if (!NumberUtil.isNullOrZero((Number)pcsFlowerDeliveryVO.getDeliveryInterval())) {
            cutCalendar.add(5, 7 * pcsFlowerDeliveryVO.getDeliveryInterval());
        }
        PcsFlowerDeliveryCond cond = new PcsFlowerDeliveryCond();
        cond.setSkuCode(queryDTO.getSkuCode());
        cond.setIsUseable(1);
        cond.setFinishState(0);
        cond.setSendDate(DateUtil.format((Date)cutCalendar.getTime(), (String)"yyyy-MM-dd"));
        cond.setCityId(queryDTO.getCityId());
        List<PcsFlowerDeliveryRecipeVO> pcsFlowerDeliveryRecipes = this.pcsFlowerDeliveryRecipeMapper.getFlowerDeliveryDate(cond);
        if (CollectionUtils.isNotEmpty(pcsFlowerDeliveryRecipes)) {
            ArrayList<PcsFlowerDeliveryRecipeVO> useableDateList = new ArrayList<PcsFlowerDeliveryRecipeVO>();
            ServiceResp serviceResp = this.flowerMonthlyService.getFlowerSkuStock(queryDTO.getSkuCode(), queryDTO.getCityId(), queryDTO.getsFlowerProductionTypeEnum());
            if (serviceResp.isFailure()) {
                throw new PurchaseException("\u5e93\u5b58\u67e5\u8be2\u5931\u8d25");
            }
            capacityQuantity = ((SFlowerMonthlyCityDTO)serviceResp.getBean()).getCapacityQuantity();
            int planQuantity = 0;
            Integer saledQuantity = ((SFlowerMonthlyCityDTO)serviceResp.getBean()).getSoldQuantity();
            int count = pcsFlowerDeliveryVO.getRuleNumber();
            int queryStockNum = 0;
            HashMap<Long, Integer> cityTaskMap = new HashMap<Long, Integer>();
            int recipeNum = 0;
            ArrayList<Integer> deliveryRecipeIds = new ArrayList<Integer>();
            for (PcsFlowerDeliveryRecipeVO recip : pcsFlowerDeliveryRecipes) {
                if (recipeNum >= count) break;
                deliveryRecipeIds.add(recip.getId().intValue());
                ++recipeNum;
            }
            List<Object> flowerMonTaskVOList = new ArrayList();
            if (queryDTO.getsFlowerProductionTypeEnum().equals((Object)SFlowerProductionTypeEnum.STORE)) {
                ArrayList<Integer> cityIds = new ArrayList<Integer>();
                cityIds.add(queryDTO.getCityId());
                flowerMonTaskVOList = this.pcsFlowerDeliveryRecipeMapper.selectCityDeliveryRecipeTaskList(cityIds, queryDTO.getSkuCode(), deliveryRecipeIds);
            } else {
                flowerMonTaskVOList = this.pcsFlowerDeliveryRecipeMapper.selectDeliveryRecipeTaskList(queryDTO.getSkuCode(), deliveryRecipeIds);
            }
            if (EmptyUtil.isNotEmpty(flowerMonTaskVOList)) {
                for (PcsFlowerMonTaskVO pcsFlowerMonTaskVO : flowerMonTaskVOList) {
                    cityTaskMap.put(pcsFlowerMonTaskVO.getDeliveryRecipeId().longValue(), pcsFlowerMonTaskVO.getTaskQuantity());
                }
            }
            for (PcsFlowerDeliveryRecipeVO pcsFlowerDeliveryRecipeVO : pcsFlowerDeliveryRecipes) {
                if (queryStockNum == count && totalStock <= 0) {
                    pcsFlowerDeliveryDate.setCanSale(false);
                    ArrayList<PcsFlowerDeliveryRecipeVO> dateList = new ArrayList<PcsFlowerDeliveryRecipeVO>();
                    dateList.add(new PcsFlowerDeliveryRecipeVO());
                    pcsFlowerDeliveryDate.setDeliveryDate(dateList);
                    this.refreshSoldCache(queryDTO, capacityQuantity, totalStock);
                    return pcsFlowerDeliveryDate;
                }
                int stock = 0;
                int soldQuantity = cityTaskMap.containsKey(pcsFlowerDeliveryRecipeVO.getId()) ? (Integer)cityTaskMap.get(pcsFlowerDeliveryRecipeVO.getId()) : 0;
                stock = capacityQuantity - soldQuantity;
                if (stock > 0 && useableDateList.size() < pcsFlowerDeliveryVO.getSendTimes()) {
                    totalStock = totalStock > 0 ? totalStock : stock;
                    planQuantity = planQuantity > 0 ? planQuantity : pcsFlowerDeliveryRecipeVO.getPlanQuantity();
                    useableDateList.add(pcsFlowerDeliveryRecipeVO);
                    continue;
                }
                if (stock <= 0 && useableDateList.size() > 0 && useableDateList.size() < pcsFlowerDeliveryVO.getSendTimes()) {
                    useableDateList.add(pcsFlowerDeliveryRecipeVO);
                    continue;
                }
                ++queryStockNum;
            }
            pcsFlowerDeliveryDate.setCanSale(totalStock > 0);
            pcsFlowerDeliveryDate.setDeliveryDate(useableDateList);
        } else {
            pcsFlowerDeliveryDate.setCanSale(false);
            ArrayList<PcsFlowerDeliveryRecipeVO> dateList = new ArrayList<PcsFlowerDeliveryRecipeVO>();
            dateList.add(new PcsFlowerDeliveryRecipeVO());
            pcsFlowerDeliveryDate.setDeliveryDate(dateList);
        }
        this.refreshSoldCache(queryDTO, capacityQuantity, totalStock);
        return pcsFlowerDeliveryDate;
    }

    private void refreshSoldCache(SFlowerMonthlyQueryDTO queryDTO, int capacityQuantity, int totalStock) {
        ArrayList<SFlowerMonthlyCityDTO> list = new ArrayList<SFlowerMonthlyCityDTO>();
        SFlowerMonthlyCityDTO sFlowerMonthlyCityDTO = new SFlowerMonthlyCityDTO();
        sFlowerMonthlyCityDTO.setCityId(queryDTO.getCityId());
        sFlowerMonthlyCityDTO.setSkuCode(queryDTO.getSkuCode());
        sFlowerMonthlyCityDTO.setSoldQuantity(Integer.valueOf(capacityQuantity - totalStock));
        sFlowerMonthlyCityDTO.setCanUseQuantity(Integer.valueOf(totalStock));
        sFlowerMonthlyCityDTO.setProductionType(queryDTO.getsFlowerProductionTypeEnum().getValue());
        list.add(sFlowerMonthlyCityDTO);
        this.flowerMonthlyService.refreshCache(list);
    }

    @Override
    public List<PcsFlowerSkuStatisticsVO> requiredSuppliesStatistics(String startDate, String endDate) {
        return this.pcsFlowerRecipeSkuMapper.requiredSuppliesStatistics(startDate, endDate);
    }

    @Override
    public List<PcsFlowerMerchantibleVO> getFlowerSellNumber() {
        ArrayList<PcsFlowerMerchantibleVO> flowerAvailableSkus = new ArrayList<PcsFlowerMerchantibleVO>();
        List<PcsFlowerMerchantibleVO> pcsFlowerMerchantibleVOs = this.pcsFlowerDeliveryRecipeMapper.getFlowerSellNumber();
        if (CollectionUtils.isNotEmpty(pcsFlowerMerchantibleVOs)) {
            for (PcsFlowerMerchantibleVO flowerAvailableSku : pcsFlowerMerchantibleVOs) {
                Integer selfAvailableQuantity = flowerAvailableSku.getPlanQuantity() - flowerAvailableSku.getSoldQuantity();
                Integer tmallAvailableQuantity = flowerAvailableSku.getTmallPlanQuantity() - flowerAvailableSku.getTmallSoldQuantity();
                Integer safeStock = flowerAvailableSku.getSafeStock();
                if ((selfAvailableQuantity >= safeStock || tmallAvailableQuantity < safeStock) && (tmallAvailableQuantity >= safeStock || selfAvailableQuantity < safeStock)) continue;
                flowerAvailableSku.setSelfAvailableQuantity(selfAvailableQuantity);
                flowerAvailableSku.setTmallAvailableQuantity(tmallAvailableQuantity);
                flowerAvailableSkus.add(flowerAvailableSku);
            }
        }
        return flowerAvailableSkus;
    }

    @Override
    public void updateFlowerFinishStateChange() {
        PcsFlowerDeliveryExample example = new PcsFlowerDeliveryExample();
        example.createCriteria().andUseableStatueEqualTo(1);
        List<PcsFlowerDelivery> list = this.pcsFlowerDeliveryMapper.selectByExample(example);
        for (PcsFlowerDelivery pcsFlowerDelivery : list) {
            try {
                this.updateFlowerFinishStateChange(pcsFlowerDelivery);
            }
            catch (Exception e) {
                this.log.error(pcsFlowerDelivery.getSku() + "\u6708\u9001\u9c9c\u82b1\u72b6\u6001\u8f6c\u6362\u5931\u8d25");
                e.printStackTrace();
            }
        }
    }

    public void updateFlowerFinishStateChange(String skuCode) {
        PcsFlowerDeliveryExample example = new PcsFlowerDeliveryExample();
        PcsFlowerDeliveryExample.Criteria deliveryCriteria = example.createCriteria();
        deliveryCriteria.andUseableStatueEqualTo(1);
        deliveryCriteria.andSkuEqualTo(skuCode);
        List<PcsFlowerDelivery> list = this.pcsFlowerDeliveryMapper.selectByExample(example);
        this.updateFlowerFinishStateChange(list);
    }

    private void updateFlowerFinishStateChange(List<PcsFlowerDelivery> list) {
        for (PcsFlowerDelivery pcsFlowerDelivery : list) {
            this.updateFlowerFinishStateChange(pcsFlowerDelivery);
        }
    }

    private void updateFlowerFinishStateChange(PcsFlowerDelivery pcsFlowerDelivery) {
        if (pcsFlowerDelivery.getSku().equals("101180038")) {
            this.log.info("101180038");
        }
        if (pcsFlowerDelivery.getSku() != null && pcsFlowerDelivery.getCutoffDay() != null && pcsFlowerDelivery.getCutoffTime() != null) {
            Date cutDate = this.getCurrWeek(pcsFlowerDelivery.getCutoffDay());
            Calendar cutCalendar = Calendar.getInstance();
            cutCalendar.setTime(cutDate);
            String[] time = pcsFlowerDelivery.getCutoffTime().split(":");
            if (time.length == 3) {
                cutCalendar.set(11, Integer.parseInt(time[0]));
                cutCalendar.set(12, Integer.parseInt(time[1]));
                cutCalendar.set(13, Integer.parseInt(time[2]));
            }
            if (Calendar.getInstance().getTimeInMillis() > cutCalendar.getTimeInMillis()) {
                cutCalendar.add(5, 7);
            }
            if (!NumberUtil.isNullOrZero((Number)pcsFlowerDelivery.getDeliveryInterval())) {
                cutCalendar.add(5, 7 * pcsFlowerDelivery.getDeliveryInterval());
            }
            PcsFlowerDeliveryRecipeExample pcsFlowerDeliveryRecipeExample = new PcsFlowerDeliveryRecipeExample();
            PcsFlowerDeliveryRecipeExample.Criteria criteria = pcsFlowerDeliveryRecipeExample.createCriteria();
            criteria.andSendDayLessThan(cutCalendar.getTime());
            criteria.andFinishStateEqualTo(0);
            criteria.andSkuCodeEqualTo(pcsFlowerDelivery.getSku());
            pcsFlowerDeliveryRecipeExample.setOrderByClause("SEND_DAY asc");
            PcsFlowerDeliveryRecipe record = new PcsFlowerDeliveryRecipe();
            record.setFinishState(1);
            int ret = this.pcsFlowerDeliveryRecipeMapper.updateByExampleSelective(record, pcsFlowerDeliveryRecipeExample);
            this.refreshDeliveryCache(pcsFlowerDelivery.getSku(), pcsFlowerDelivery.getProducer());
        }
    }

    private Date getCurrWeek(int week) {
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setFirstDayOfWeek(1);
        currentDate.set(7, week);
        currentDate.add(3, 0);
        Date nextWeek = currentDate.getTime();
        return nextWeek;
    }

    private void refreshSoldQuantityCache(String skuCode, Byte productionType) {
        int defaultRecipeId = this.pcsFlowerDeliveryRecipeMapper.selectCurrentRecipeId(skuCode);
        ArrayList<SFlowerMonthlyCityDTO> refreshList = new ArrayList<SFlowerMonthlyCityDTO>();
        if (productionType.equals(SFlowerProductionTypeEnum.STORE.getValue())) {
            ArrayList<String> skuCodes = new ArrayList<String>();
            skuCodes.add(skuCode);
            List cityDTOList = this.flowerMonthlyService.getCityList(skuCodes);
            if (EmptyUtil.isNotEmpty((List)cityDTOList)) {
                ArrayList<Integer> cityIds = new ArrayList<Integer>();
                HashMap<Integer, Integer> cityCapacityMap = new HashMap<Integer, Integer>();
                for (SFlowerMonthlyCityDTO flowerMonthlyCityDTO : cityDTOList) {
                    cityIds.add(flowerMonthlyCityDTO.getCityId());
                    cityCapacityMap.put(flowerMonthlyCityDTO.getCityId(), flowerMonthlyCityDTO.getCapacityQuantity());
                }
                List<PcsFlowerMonTaskVO> flowerMonTaskVOList = this.pcsFlowerDeliveryRecipeMapper.selectCurrentTaskBySkuAndCity(cityIds, skuCode, defaultRecipeId);
                for (PcsFlowerMonTaskVO flowerMonTaskVO : flowerMonTaskVOList) {
                    SFlowerMonthlyCityDTO sFlowerMonthlyCityDTO = new SFlowerMonthlyCityDTO();
                    sFlowerMonthlyCityDTO.setSoldQuantity(flowerMonTaskVO.getTaskQuantity());
                    sFlowerMonthlyCityDTO.setCapacityQuantity((Integer)cityCapacityMap.get(flowerMonTaskVO.getCityId()));
                    sFlowerMonthlyCityDTO.setCityId(flowerMonTaskVO.getCityId());
                    sFlowerMonthlyCityDTO.setSkuCode(skuCode);
                    sFlowerMonthlyCityDTO.setProductionType(SFlowerProductionTypeEnum.STORE.getValue());
                    refreshList.add(sFlowerMonthlyCityDTO);
                }
            }
        } else {
            int soldQuantity = this.pcsFlowerDeliveryRecipeMapper.selectWhCurrentTask(skuCode, defaultRecipeId);
            SFlowerMonthlyCityDTO fowerMonthlyCityDTO = this.flowerMonthlyService.getFlowerMonWhData(skuCode);
            if (EmptyUtil.isNotEmpty((Object)fowerMonthlyCityDTO)) {
                SFlowerMonthlyCityDTO sFlowerMonthlyCityDTO = new SFlowerMonthlyCityDTO();
                sFlowerMonthlyCityDTO.setSoldQuantity(Integer.valueOf(soldQuantity));
                sFlowerMonthlyCityDTO.setSkuCode(skuCode);
                sFlowerMonthlyCityDTO.setCapacityQuantity(fowerMonthlyCityDTO.getCapacityQuantity());
                sFlowerMonthlyCityDTO.setProductionType(SFlowerProductionTypeEnum.WAREHOUSE.getValue());
                refreshList.add(sFlowerMonthlyCityDTO);
            }
        }
        if (EmptyUtil.isNotEmpty(refreshList)) {
            this.flowerMonthlyService.refreshCache(refreshList);
        }
    }

    @Override
    @Transactional
    public void flowerFinishStateChange() {
        PcsFlowerDeliveryExample example = new PcsFlowerDeliveryExample();
        example.createCriteria().andUseableStatueEqualTo(1);
        List<PcsFlowerDelivery> list = this.pcsFlowerDeliveryMapper.selectByExample(example);
        for (PcsFlowerDelivery pcsFlowerDelivery : list) {
            if (pcsFlowerDelivery.getSku() == null || pcsFlowerDelivery.getCutoffDay() == null || pcsFlowerDelivery.getCutoffTime() == null) continue;
            this.pcsFlowerDeliveryRecipeMapper.updateCurrBeforeFinish(pcsFlowerDelivery.getSku());
            this.pcsFlowerDeliveryRecipeMapper.updateCurrAfterNoFinish(pcsFlowerDelivery.getSku());
            PcsFlowerDeliveryRecipeExample pcsFlowerDeliveryRecipeExample = new PcsFlowerDeliveryRecipeExample();
            PcsFlowerDeliveryRecipeExample.Criteria criteria = pcsFlowerDeliveryRecipeExample.createCriteria();
            criteria.andSendDayGreaterThan(Calendar.getInstance().getTime());
            criteria.andFinishStateEqualTo(0);
            criteria.andSkuCodeEqualTo(pcsFlowerDelivery.getSku());
            pcsFlowerDeliveryRecipeExample.setOrderByClause("SEND_DAY asc");
            List<PcsFlowerDeliveryRecipe> pcsFlowerDeliveryRecipeList = this.pcsFlowerDeliveryRecipeMapper.selectByExample(pcsFlowerDeliveryRecipeExample);
            Date cutDate = DateUtil.getCurrWeek((int)pcsFlowerDelivery.getCutoffDay());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(cutDate);
            String[] time = pcsFlowerDelivery.getCutoffTime().split(":");
            if (time.length == 3) {
                calendar.set(11, Integer.parseInt(time[0]));
                calendar.set(12, Integer.parseInt(time[1]));
                calendar.set(13, Integer.parseInt(time[2]));
            }
            if (Calendar.getInstance().getTimeInMillis() <= calendar.getTimeInMillis() || pcsFlowerDeliveryRecipeList == null) continue;
            PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe = pcsFlowerDeliveryRecipeList.get(0);
            pcsFlowerDeliveryRecipe.setFinishState(1);
            this.pcsFlowerDeliveryRecipeMapper.updateByPrimaryKey(pcsFlowerDeliveryRecipe);
        }
    }

    @Override
    @Transactional
    public void importFlowerRecipeMaterial(List<FlowerRecipeMaterialVO> list, String skuCode, int isCycle, String effectDate) {
        PcsFlowerRecipeSkuCond cond = new PcsFlowerRecipeSkuCond();
        cond.setEffectDate(effectDate);
        cond.setSkuCode(skuCode);
        PcsFlowerDeliveryRecipeExample pcsFlowerDeliveryRecipeExample = new PcsFlowerDeliveryRecipeExample();
        PcsFlowerDeliveryRecipeExample.Criteria criteria = pcsFlowerDeliveryRecipeExample.createCriteria();
        criteria.andSkuCodeEqualTo(skuCode);
        criteria.andSendDayGreaterThanOrEqualTo(DateUtil.parse((String)effectDate, (String)"yyyy-MM-dd"));
        criteria.andUseableStateEqualTo(1);
        pcsFlowerDeliveryRecipeExample.setOrderByClause("SEND_DAY ASC");
        List<PcsFlowerDeliveryRecipe> pcsFlowerDeliveryRecipeList = this.pcsFlowerDeliveryRecipeMapper.selectByExample(pcsFlowerDeliveryRecipeExample);
        ArrayList<List<FlowerRecipeMaterialVO>> myList = new ArrayList<List<FlowerRecipeMaterialVO>>();
        int initNum = 0;
        ArrayList<FlowerRecipeMaterialVO> voList = new ArrayList<FlowerRecipeMaterialVO>();
        for (FlowerRecipeMaterialVO vo : list) {
            if (vo.getId() != initNum) {
                voList = new ArrayList();
                voList.add(vo);
                myList.add(voList);
                initNum = vo.getId();
                continue;
            }
            voList.add(vo);
        }
        if (isCycle == 1) {
            for (int i = 0; i < pcsFlowerDeliveryRecipeList.size(); ++i) {
                this.processFlowerRecipeSku(pcsFlowerDeliveryRecipeList, myList, i);
            }
        } else {
            int max = pcsFlowerDeliveryRecipeList.size();
            if (myList.size() < max) {
                max = myList.size();
            }
            for (int i = 0; i < max; ++i) {
                this.processFlowerRecipeSku(pcsFlowerDeliveryRecipeList, myList, i);
            }
        }
    }

    private void processFlowerRecipeSku(List<PcsFlowerDeliveryRecipe> pcsFlowerDeliveryRecipeList, List<List<FlowerRecipeMaterialVO>> myList, int i) {
        PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe = pcsFlowerDeliveryRecipeList.get(i);
        List<FlowerRecipeMaterialVO> realList = myList.get(i % myList.size());
        this.pcsFlowerRecipeSkuMapper.upatePcsFlowerSkuStatisticsCancel(pcsFlowerDeliveryRecipe.getId());
        for (FlowerRecipeMaterialVO vo : realList) {
            PcsFlowerRecipeSku pcsFlowerRecipeSku = new PcsFlowerRecipeSku();
            pcsFlowerRecipeSku.setRecipeId(pcsFlowerDeliveryRecipe.getId());
            pcsFlowerRecipeSku.setAvailable(1);
            pcsFlowerRecipeSku.setExpendNumber(Float.valueOf(new BigDecimal(vo.getQuantity()).floatValue()));
            pcsFlowerRecipeSku.setSkuCode(vo.getSkuCode());
            if ("\u4e3b".equals(vo.getMaterialType())) {
                pcsFlowerRecipeSku.setSkuType(1);
            } else {
                pcsFlowerRecipeSku.setSkuType(0);
            }
            this.pcsFlowerRecipeSkuMapper.insert(pcsFlowerRecipeSku);
        }
    }

    @Override
    @Transactional
    public boolean updateTmallFlowerPlanQuantity(PcsFlowerRecipePlanCond cond) throws Exception {
        PcsFlowerDeliveryRecipe selfFlowerRecipe = new PcsFlowerDeliveryRecipe();
        selfFlowerRecipe.setId(cond.getRecipeId());
        selfFlowerRecipe.setPlanQuantity(cond.getPlanQuantity());
        this.pcsFlowerDeliveryRecipeMapper.updateByPrimaryKeySelective(selfFlowerRecipe);
        PcsFlowerDeliveryRecipe tmallFlowerRecipe = new PcsFlowerDeliveryRecipe();
        tmallFlowerRecipe.setId(cond.getRecipeId());
        tmallFlowerRecipe.setTmallPlanQuantity(cond.getTmallPlanQuantity());
        this.pcsFlowerDeliveryRecipeMapper.updateByPrimaryKeySelective(tmallFlowerRecipe);
        boolean tmallResult = true;
        if (!tmallResult) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }

    @Override
    public Boolean updateTmallMthFlowerStock(String skuCode, int prePlanNumber, int afterPlanNumber, String referenceCode, Long operatorId) throws Exception {
        int difference = afterPlanNumber - prePlanNumber;
        if (prePlanNumber == afterPlanNumber) {
            return true;
        }
        Long numIid = this.pegasusUtilFacade.getSkuNumIid(skuCode, "CHN1031");
        this.wWhCommandService.synCommodityStocks(numIid, skuCode, (long)difference, "CHN1031", 5, referenceCode, operatorId);
        return true;
    }

    @Override
    public List<String> findPhyWhFlowerMonthyCapacitySeted(String skuCode) {
        return this.pcsFlowerMonthlyCapacitySettingMapper.findPhyWhFlowerMonthyCapacitySeted(skuCode);
    }

    @Override
    public PageInfo findCapacityByCond(PcsFlowerDeliveryCapacityCond cond) {
        int offset = (cond.getCurrpage() - 1) * cond.getPagenum();
        PageRowBounds pageRowBounds = new PageRowBounds(offset, cond.getPagenum().intValue());
        PageInfo pageInfo = new PageInfo(this.pcsFlowerMonthlyCapacitySettingMapper.selectCapacityByCond(cond, pageRowBounds));
        pageInfo.setTotal(pageRowBounds.getTotal().longValue());
        return pageInfo;
    }

    @Override
    public Map<Class<?>, List<?>> findFlowerDeliverySaleInfo(Long deliveryRecipeId, String skuCode) {
        HashMap map = new HashMap();
        PcsFlowerDeliveryRecipe flowerDeliveryRecipe = this.pcsFlowerDeliveryRecipeMapper.selectByPrimaryKey(deliveryRecipeId);
        PcsFlowerDelivery flowerDelivery = this.findFlowerDelivery(flowerDeliveryRecipe.getSkuCode());
        if (NullUtil.isNull((Object)flowerDelivery)) {
            return map;
        }
        List<PcsFlowerDeliveryShouldSendPackageExcelVO> shouldSendList = this.pcsFlowerDeliveryRecipeMapper.findFlowerDeliveryShouldSendPackageList(deliveryRecipeId);
        if (EmptyUtil.isNotEmpty(shouldSendList)) {
            for (PcsFlowerDeliveryShouldSendPackageExcelVO excel : shouldSendList) {
                if (WhWarehouseGroupVO.WAREHOUSE_YES.equals(excel.getWarehouseGroupType())) {
                    if (PcsFlowerDeliveryVO.PRODUCER_WAREHOUSE.equals(flowerDelivery.getProducer())) {
                        excel.setAbnormal("\u5426");
                        continue;
                    }
                    excel.setAbnormal("\u662f");
                    continue;
                }
                if (!WhWarehouseGroupVO.WAREHOUSE_NO.equals(excel.getWarehouseGroupType())) continue;
                if (PcsFlowerDeliveryVO.PRODUCER_STORE.equals(flowerDelivery.getProducer())) {
                    excel.setAbnormal("\u5426");
                    continue;
                }
                excel.setAbnormal("\u662f");
            }
        }
        map.put(PcsFlowerDeliveryShouldSendPackageExcelVO.class, shouldSendList);
        if (PcsFlowerDeliveryVO.PRODUCER_WAREHOUSE.equals(flowerDelivery.getProducer())) {
            List<PcsFlowerDeliveryWhCountExcelVO> whCountList = this.pcsFlowerDeliveryRecipeMapper.findFlowerDeliveryWhCountList(deliveryRecipeId, skuCode);
            map.put(PcsFlowerDeliveryWhCountExcelVO.class, whCountList);
        } else if (PcsFlowerDeliveryVO.PRODUCER_STORE.equals(flowerDelivery.getProducer())) {
            List<PcsFlowerDeliveryCityCountExcelVO> cityCountList = this.pcsFlowerDeliveryRecipeMapper.findFlowerDeliveryCityCountList(deliveryRecipeId, skuCode);
            map.put(PcsFlowerDeliveryCityCountExcelVO.class, cityCountList);
            List<PcsFlowerDeliveryStoreCountExcelVO> storeCountList = this.pcsFlowerDeliveryRecipeMapper.findFlowerDeliveryStoreCountList(deliveryRecipeId, skuCode);
            map.put(PcsFlowerDeliveryStoreCountExcelVO.class, storeCountList);
        }
        List<PcsFlowerDeliveryNotSendPackageExcelVO> notSendList = this.pcsFlowerDeliveryRecipeMapper.findFlowerDeliveryNotSendPackageList(deliveryRecipeId);
        map.put(PcsFlowerDeliveryNotSendPackageExcelVO.class, notSendList);
        return map;
    }

    private PcsFlowerDelivery findFlowerDelivery(String skuCode) {
        PcsFlowerDeliveryExample example = new PcsFlowerDeliveryExample();
        example.createCriteria().andSkuEqualTo(skuCode);
        List<PcsFlowerDelivery> list = this.pcsFlowerDeliveryMapper.selectByExample(example);
        if (EmptyUtil.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public int saveOrUpdate(List<PcsFlowerMonCapaSettingVO> records) throws Exception {
        this.pcsFlowerMonthlyCapacitySettingMapper.saveOrUpdate(BeanUtil.buildListFrom(records, PcsFlowerMonthlyCapacitySetting.class));
        this.pcsFlowerDeliveryRecipePhyWhCapacityService.refreshFlowerDeliveryRecipePhyWhCapacity(records.get(0).getSkuCode());
        PcsFlowerMonCapaSettingVO pcsFlowerMonCapaSettingVO = records.get(0);
        this.flowerMonthlyService.refreshCacheBySkuCode(pcsFlowerMonCapaSettingVO.getSkuCode(), pcsFlowerMonCapaSettingVO.getProductionType() == 1 ? SFlowerProductionTypeEnum.STORE : SFlowerProductionTypeEnum.WAREHOUSE);
        return 1;
    }

    @Override
    public List<PcsFlowerMonCapaLogVO> findPcsFlowerMonCapaLogBySkuCode(String skuCode) {
        return BeanUtil.buildListFrom(this.pcsFlowerMonthlyCapacityLogMapper.selectBySkuCode(skuCode), PcsFlowerMonCapaLogVO.class);
    }

    @Override
    public List<PcsFlowerMonCapaSettingVO> findCityCapacityByCond(PcsFlowerDeliveryCapacityCond cond) {
        return this.pcsFlowerMonthlyCapacitySettingMapper.selectCityCapacityByCond(cond);
    }

    @Override
    public int saveCapacityChangeLogs(List<PcsFlowerMonthlyCapacityLog> logs) {
        return this.pcsFlowerMonthlyCapacityLogMapper.batchInsert(logs);
    }

    @Override
    public List<PcsFlowerMonCapaSettingVO> findCapacityByUniqueIndex(List<PcsFlowerDeliveryCapacityCond> conds) {
        ArrayList<String> list = new ArrayList<String>();
        for (PcsFlowerDeliveryCapacityCond cond : conds) {
            list.add(cond.getSkuCode() + cond.getPhysicalWarehouseCode());
        }
        return this.pcsFlowerMonthlyCapacitySettingMapper.selectCapacityByUniqueIndex(list);
    }

    @Override
    public Map<String, Integer> findCurrentTaskQuntity(String skuCode, List<Integer> cityIds, SFlowerProductionTypeEnum productionTypeEnum) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        int defaultRecipeId = this.pcsFlowerDeliveryRecipeMapper.selectCurrentRecipeId(skuCode);
        if (productionTypeEnum.equals((Object)SFlowerProductionTypeEnum.STORE)) {
            List<PcsFlowerMonTaskVO> flowerMonTaskVOList = this.pcsFlowerDeliveryRecipeMapper.selectCurrentTaskBySkuAndCity(cityIds, skuCode, defaultRecipeId);
            if (EmptyUtil.isNotEmpty(flowerMonTaskVOList)) {
                for (PcsFlowerMonTaskVO flowerMonTaskVO : flowerMonTaskVOList) {
                    resultMap.put(String.valueOf(flowerMonTaskVO.getCityId()), flowerMonTaskVO.getTaskQuantity());
                }
            }
        } else {
            resultMap.put(skuCode, this.pcsFlowerDeliveryRecipeMapper.selectWhCurrentTask(skuCode, defaultRecipeId));
        }
        return resultMap;
    }

    @Override
    public List<PcsFlowerMonCapaSettingVO> findAllWhCapacityDataBySkucode(String skuCode) {
        return this.pcsFlowerMonthlyCapacitySettingMapper.findAllWhCapacityDataBySkucode(skuCode);
    }
}

