/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerDeliveryRecipeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerDeliveryRecipePhyWhCapacityMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerMonthlyCapacitySettingMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDeliveryRecipePhyWhCapacityExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerMonthlyCapacitySetting;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerMonthlyCapacitySettingExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsFlowerDeliveryRecipePhyWhCapacityService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerDeliveryRecipePhyWhCapacityVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsFlowerDeliveryRecipePhyWhCapacityService")
public class PcsFlowerDeliveryRecipePhyWhCapacityServiceImpl
implements PcsFlowerDeliveryRecipePhyWhCapacityService {
    @Autowired
    private PcsFlowerDeliveryRecipePhyWhCapacityMapper pcsFlowerDeliveryRecipePhyWhCapacityMapper;
    @Autowired
    private PcsFlowerMonthlyCapacitySettingMapper pcsFlowerMonthlyCapacitySettingMapper;
    @Autowired
    private PcsFlowerDeliveryRecipeMapper pcsFlowerDeliveryRecipeMapper;

    @Override
    @Transactional
    public boolean refreshFlowerDeliveryRecipePhyWhCapacity(String skuCode) {
        if (EmptyUtil.isEmpty((String)skuCode)) {
            return false;
        }
        this.refreshFlowerDeliveryRecipeQuantity(skuCode);
        List<PcsFlowerDeliveryRecipePhyWhCapacityVO> capacityList = this.pcsFlowerDeliveryRecipePhyWhCapacityMapper.findNeedRefrshRecipeCapacity(skuCode);
        if (EmptyUtil.isEmpty(capacityList)) {
            return true;
        }
        ArrayList<Long> deleteIdList = new ArrayList<Long>();
        for (PcsFlowerDeliveryRecipePhyWhCapacityVO capacity : capacityList) {
            if (!NullUtil.isNotNull((Object)capacity.getId())) continue;
            deleteIdList.add(capacity.getId());
            capacity.setId(null);
        }
        this.batchDelete(deleteIdList);
        this.batchInsert(capacityList);
        return true;
    }

    private void batchDelete(List<Long> idList) {
        if (EmptyUtil.isEmpty(idList)) {
            return;
        }
        PcsFlowerDeliveryRecipePhyWhCapacityExample example = new PcsFlowerDeliveryRecipePhyWhCapacityExample();
        example.createCriteria().andIdIn((List)idList);
        this.pcsFlowerDeliveryRecipePhyWhCapacityMapper.deleteByExample(example);
    }

    private void batchInsert(List<PcsFlowerDeliveryRecipePhyWhCapacityVO> capacityList) {
        if (EmptyUtil.isEmpty(capacityList)) {
            return;
        }
        List parts = Lists.partition(capacityList, (int)100);
        for (List part : parts) {
            this.pcsFlowerDeliveryRecipePhyWhCapacityMapper.batchInsert(part);
        }
    }

    private int findSkuCapacity(String skuCode) {
        PcsFlowerMonthlyCapacitySettingExample example = new PcsFlowerMonthlyCapacitySettingExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        List<PcsFlowerMonthlyCapacitySetting> list = this.pcsFlowerMonthlyCapacitySettingMapper.selectByExample(example);
        int totalCapacity = 0;
        if (EmptyUtil.isNotEmpty(list)) {
            for (PcsFlowerMonthlyCapacitySetting setting : list) {
                totalCapacity += setting.getCapacityQuantity().intValue();
            }
        }
        return totalCapacity;
    }

    private boolean refreshFlowerDeliveryRecipeQuantity(String skuCode) {
        int capacity = this.findSkuCapacity(skuCode);
        this.pcsFlowerDeliveryRecipeMapper.updateFlowerDeliveyRecipePlanQuantityForNotFinished(skuCode, capacity);
        return true;
    }
}

