/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PcsFinancePaymentCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoCreditNoteCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFinancePaymentMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoCreditNoteMapper;
import com.thebeastshop.pegasus.service.purchase.enums.PoFinancePaymentModeEnum;
import com.thebeastshop.pegasus.service.purchase.model.PcsFinancePayment;
import com.thebeastshop.pegasus.service.purchase.model.PcsFinancePaymentExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoCreditNote;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.service.PcsFinancePaymentService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFinancePaymentVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoCreditNoteVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsFinancePaymentService")
public class PcsFinancePaymentServiceImpl
implements PcsFinancePaymentService {
    private final Logger log = LoggerFactory.getLogger(PcsFinancePaymentServiceImpl.class);
    @Autowired
    private PcsFinancePaymentMapper pcsFinancePaymentMapper;
    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;
    @Autowired
    private PcsPoCreditNoteMapper pcsPoCreditNoteMapper;

    @Override
    public List<PcsFinancePayment> findPoFinaceVOByPoId(long poId, Integer type) {
        PcsFinancePaymentExample example = new PcsFinancePaymentExample();
        PcsFinancePaymentExample.Criteria criteria = example.createCriteria().andExternalIdEqualTo(poId);
        if (NullUtil.isNotNull((Object)type)) {
            criteria.andTypeEqualTo(type);
        }
        example.setOrderByClause("CREATE_TIME DESC");
        List<PcsFinancePayment> poList = this.pcsFinancePaymentMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        }
        return poList;
    }

    @Override
    public PcsFinancePayment buildFromVO(PcsFinancePaymentVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        PcsFinancePayment record = new PcsFinancePayment();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    public PcsFinancePaymentVO buildFromModel(PcsFinancePayment record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsFinancePaymentVO vo = new PcsFinancePaymentVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    @Transactional
    public Long createFinancePayment(PcsFinancePayment pcsFinancePayment) {
        pcsFinancePayment.setCreateTime(new Date());
        this.pcsFinancePaymentMapper.insertSelective(pcsFinancePayment);
        String code = this.generateCode(pcsFinancePayment.getId());
        pcsFinancePayment.setCode(code);
        this.pcsFinancePaymentMapper.updateByPrimaryKey(pcsFinancePayment);
        if (PcsFinancePaymentVO.TYPE_PURCHASE_ORDER.equals(pcsFinancePayment.getType())) {
            this.updatePoAfterFinancePayment(pcsFinancePayment);
            this.updateCreditNoteAfterFinancePayment(pcsFinancePayment);
        }
        return pcsFinancePayment.getId();
    }

    private void updateCreditNoteAfterFinancePayment(PcsFinancePayment pcsFinancePayment) {
        if (EmptyUtil.isNotEmpty((String)pcsFinancePayment.getByPoCode()) && PoFinancePaymentModeEnum.credit_note.getKey().equals(pcsFinancePayment.getPaymentMode())) {
            PcsPoCreditNoteCond cond = new PcsPoCreditNoteCond();
            cond.setPoCode(pcsFinancePayment.getByPoCode());
            cond.setValid(1);
            cond.setNotStatus(2);
            List<PcsPoCreditNoteVO> poCreditNoteVOs = this.pcsPurchaseOrderService.listPcsPoCreditNoteVOByCond(cond);
            if (CollectionUtils.isNotEmpty(poCreditNoteVOs)) {
                ArrayList<Object> needModifyCreditNotes = new ArrayList<Object>();
                BigDecimal paymentAmount = pcsFinancePayment.getPaymentAmount();
                for (PcsPoCreditNoteVO pc : poCreditNoteVOs) {
                    if (paymentAmount.compareTo(pc.getUsableAmount()) >= 0) {
                        pc.setUsedAmount(pc.getUsedAmount().add(pc.getUsableAmount()).setScale(4, 1));
                        pc.setStatus(2);
                        needModifyCreditNotes.add(BeanUtil.buildFrom((Object)pc, PcsPoCreditNote.class));
                        paymentAmount = paymentAmount.subtract(pc.getUsableAmount());
                        continue;
                    }
                    pc.setUsedAmount(pc.getUsedAmount().add(paymentAmount).setScale(4, 1));
                    pc.setStatus(1);
                    needModifyCreditNotes.add(BeanUtil.buildFrom((Object)pc, PcsPoCreditNote.class));
                    break;
                }
                if (needModifyCreditNotes.size() > 0) {
                    needModifyCreditNotes.forEach(cn -> this.pcsPoCreditNoteMapper.updateByPrimaryKeySelective((PcsPoCreditNote)cn));
                }
            }
        }
    }

    private void updatePoAfterFinancePayment(PcsFinancePayment pcsFinancePayment) {
        PcsPurchaseOrder pcsPurchaseOrder = new PcsPurchaseOrder();
        pcsPurchaseOrder.setId(pcsFinancePayment.getExternalId());
        pcsPurchaseOrder.setPaidAmount(pcsFinancePayment.getPaidAmount());
        pcsPurchaseOrder.setFinanceStatus(PcsPurchaseOrder.FINANCE_PAYMENT_STATUS_PAYING);
        this.pcsPurchaseOrderService.updatePurchaseOrder(pcsPurchaseOrder);
    }

    @Override
    public String generateCode(Object id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_FINANCE_PAYMENT", params);
        return code;
    }

    @Override
    @Transactional
    public Boolean updateFinancePayment(PcsFinancePayment pcsFinancePayment) {
        return this.pcsFinancePaymentMapper.updateByPrimaryKey(pcsFinancePayment) != 0;
    }

    @Override
    public Map<String, BigDecimal> getTotalPaymentAmount(Long externalId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("externalId", externalId);
        params.put("type", PcsFinancePaymentVO.TYPE_PURCHASE_ORDER);
        return this.pcsFinancePaymentMapper.getTotalPaymentAmount(params);
    }

    @Override
    public PcsFinancePayment findByPrimaryKey(Long id) {
        return this.pcsFinancePaymentMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsFinancePaymentVO> findPcsFinancePaymentVOByCond(PcsFinancePaymentCond cond) {
        return this.pcsFinancePaymentMapper.findPcsFinancePaymentVOByCond(cond);
    }

    @Override
    public List<PcsFinancePaymentVO> selectNotNotifyPoPaymentInfo() {
        return this.pcsFinancePaymentMapper.selectNotNotifyPoPaymentInfo();
    }

    @Override
    public int updatePoPaymentNotifyStatus(List<Integer> ids) {
        return this.pcsFinancePaymentMapper.updatePoPaymentNotifyStatus(ids);
    }
}

