/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.message.service.EmailSendService;
import com.thebeastshop.message.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.cond.PcsBrandCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.merchandise.service.McPcsBrandService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSupplierService;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseOrderMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.service.PcsCronService;
import com.thebeastshop.pegasus.service.purchase.service.PcsFlowerDeliveryService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerMerchantibleVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsCronService")
public class PcsCronServiceImpl
implements PcsCronService {
    private final Logger log = LoggerFactory.getLogger(PcsCronServiceImpl.class);
    @Autowired
    private PcsPoPlanService pcsPoPlanService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private McPcsSupplierService mcPcsSupplierService;
    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;
    @Autowired
    private McPcsBrandService mcPcsBrandService;
    @Autowired
    private TaskExecutor scheduler;
    @Autowired
    private EmailSendService emailSendService;
    @Autowired
    private PcsFlowerDeliveryService pcsFlowerDeliveryService;
    @Autowired
    private PcsPoPlanMapper pcsPoPlanMapper;
    @Autowired
    private PcsPurchaseOrderMapper pcsPurchaseOrderMapper;

    @Override
    public void cronSynPoPlanAndLine() {
        List<PcsPoPlan> poPlanList = this.pcsPoPlanService.findPoPlanByStatus(PcsPoPlan.PLAN_STATUS_WAITING_IN);
        if (CollectionUtils.isNotEmpty(poPlanList)) {
            for (PcsPoPlan poPlan : poPlanList) {
                try {
                    this.pcsPoPlanService.synPoPlanAndLine(poPlan);
                }
                catch (Exception e) {
                    this.log.error("", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void cronSendEmailByWasteAterPopFinished() {
        PcsPoPlanVO vo = new PcsPoPlanVO();
        vo.setPlanStatus(PcsPoPlan.PLAN_STATUS_FINISHED);
        vo.setWarnFlagStr(String.valueOf(PcsPoPlan.UNSENT_WARN_FLAG));
        vo.setReceiveDateStr(DateUtil.format((Date)DateUtil.getNow(), (String)"yyyy-MM-dd"));
        vo.setSendPopEmailOrigin(1);
        this.pcsPoPlanService.sendPopEmailByCond(vo);
    }

    @Override
    public void cronSendApprovalEmail() {
        PcsSkuCond cond = new PcsSkuCond();
        cond.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
        PcsSkuCond managerCond = new PcsSkuCond();
        managerCond.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
        long skuManagerQuantity = this.mcPcsSkuService.countSkuByCond(managerCond);
        PcsSkuCond financeCond = new PcsSkuCond();
        financeCond.setSkuStatus(PcsSku.SKU_STATUS_WAITING_FINANCE_VERIFY);
        long skuQuantity = this.mcPcsSkuService.countSkuByCond(financeCond);
        PcsPurchaseOrderCond managerPurchaseOrderCond = new PcsPurchaseOrderCond();
        managerPurchaseOrderCond.setPoStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
        long managerPurchaseOrderQuantity = this.pcsPurchaseOrderService.countByCond(managerPurchaseOrderCond);
        PcsPurchaseOrderCond financePurchaseOrderCond = new PcsPurchaseOrderCond();
        financePurchaseOrderCond.setPoStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_FINANCE_APPROVEL);
        long financePurchaseOrderQuantity = this.pcsPurchaseOrderService.countByCond(financePurchaseOrderCond);
        PcsSupplierCond pcsSupplierCond = new PcsSupplierCond();
        pcsSupplierCond.setSupplierOrderStatus(Integer.valueOf(2));
        long financeSupplierQuantity = this.mcPcsSupplierService.countByCond(pcsSupplierCond);
        String emailContent = "\u60a8\u6709";
        if (financeSupplierQuantity != 0L || skuQuantity != 0L) {
            if (skuQuantity != 0L) {
                emailContent = emailContent + skuQuantity + "\u4e2aSKU";
            }
            if (skuQuantity != 0L) {
                emailContent = emailContent + financePurchaseOrderQuantity + "\u4e2a\u91c7\u8d2d\u5355";
            }
            if (financeSupplierQuantity != 0L) {
                if (skuQuantity != 0L) {
                    emailContent = emailContent + "\u3001";
                }
                emailContent = emailContent + financeSupplierQuantity + "\u4e2a\u4f9b\u5e94\u5546";
            }
            emailContent = emailContent + "\u9700\u8981\u5ba1\u6279\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\u3002</br>\u53bb\u5ba1\u6279\uff1ahttp://scm.thebeastshop.com";
            this.sendNotice("finance.Approval.Email", null, emailContent);
        }
        PcsPurchaseOrderCond pcsPurchaseOrderCond = new PcsPurchaseOrderCond();
        pcsPurchaseOrderCond.setPoStatus(2);
        long pcsPurchaseOrderQuantity = this.pcsPurchaseOrderService.countByCond(pcsPurchaseOrderCond);
        emailContent = "\u60a8\u6709" + pcsPurchaseOrderQuantity + "\u4e2a\u91c7\u8d2d\u5355\u9700\u8981\u5ba1\u6279\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\u3002</br>\u53bb\u5ba1\u6279\uff1ahttp://scm.thebeastshop.com";
        if (pcsPurchaseOrderQuantity != 0L) {
            this.sendNotice("planner.Approval.Email", null, emailContent);
        }
        PcsBrandCond pcsBrandCond = new PcsBrandCond();
        pcsBrandCond.setBrandStatus(Integer.valueOf(2));
        long pcsBrandQuantity = this.mcPcsBrandService.countByCond(pcsBrandCond);
        emailContent = "\u60a8\u6709" + pcsBrandQuantity + "\u4e2a\u54c1\u724c\u9700\u8981\u5ba1\u6279\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\u3002</br>\u53bb\u5ba1\u6279\uff1ahttp://scm.thebeastshop.com";
        if (pcsBrandQuantity != 0L) {
            this.sendNotice("legal.Approval.Email", null, emailContent);
        }
        HashMap<Long, String> categoryManagerMap = new HashMap<Long, String>();
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.71");
        categoryManagerMap.put(71L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.351");
        categoryManagerMap.put(351L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.360");
        categoryManagerMap.put(360L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.345");
        categoryManagerMap.put(345L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
        commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.262");
        categoryManagerMap.put(262L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
        for (Map.Entry entry : categoryManagerMap.entrySet()) {
            pcsSupplierCond.setCategoryManager((Long)entry.getKey());
            pcsSupplierCond.setSupplierOrderStatus(Integer.valueOf(1));
            long supplierQuantity = this.mcPcsSupplierService.countByCond(pcsSupplierCond);
            pcsBrandCond.setCategoryManager((Long)entry.getKey());
            pcsBrandCond.setBrandStatus(Integer.valueOf(1));
            pcsBrandQuantity = this.mcPcsBrandService.countByCond(pcsBrandCond);
            emailContent = "\u60a8\u6709";
            UserInfo userInfo = new UserInfo();
            userInfo.setEmail((String)entry.getValue());
            if (pcsBrandQuantity == 0L && supplierQuantity == 0L) continue;
            if (skuQuantity != 0L) {
                emailContent = emailContent + skuManagerQuantity + "\u4e2aSKU";
            }
            if (skuQuantity != 0L) {
                emailContent = emailContent + managerPurchaseOrderQuantity + "\u4e2a\u91c7\u8d2d\u5355";
            }
            if (supplierQuantity != 0L) {
                emailContent = emailContent + supplierQuantity + "\u4e2a\u4f9b\u5e94\u5546";
            }
            if (pcsBrandQuantity != 0L) {
                if (supplierQuantity != 0L) {
                    emailContent = emailContent + "\u3001";
                }
                emailContent = emailContent + pcsBrandQuantity + "\u4e2a\u54c1\u724c";
            }
            emailContent = emailContent + "\u9700\u8981\u5ba1\u6279\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\u3002</br>\u53bb\u5ba1\u6279\uff1ahttp://scm.thebeastshop.com";
            this.sendNotice("", userInfo, emailContent);
        }
    }

    private void sendNotice(final String configKey, final UserInfo userInfo, final String content) {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey(configKey);
                    System.out.println(configKey);
                    String[] toNotifyUsers = new String[]{};
                    if (EmptyUtil.isNotEmpty((Object)commGlobalConfig)) {
                        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
                    }
                    EmailVO emailVO = new EmailVO();
                    if (userInfo != null) {
                        String[] categoryManager = userInfo.getEmail().split(",");
                        emailVO.setToAddressList(Arrays.asList(categoryManager));
                    } else {
                        emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
                    }
                    emailVO.setSubject("\u5ba1\u6279\u63d0\u9192");
                    emailVO.setContent(content);
                    if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
                        PcsCronServiceImpl.this.emailSendService.send(emailVO);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void flowerStockWarning() {
        StringBuffer emailContent = new StringBuffer();
        emailContent.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
        emailContent.append("#table-5 td {color: #000;}");
        emailContent.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
        emailContent.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
        emailContent.append("</br>---------\u5e93\u5b58\u63d0\u9192--------</br><table id='table-5'><thead><th>SKU</th><th>SKU\u4e2d\u6587\u540d</th><th>\u81ea\u8425\u53ef\u552e\u6570\u91cf</th><th>\u5929\u732b\u53ef\u552e\u6570\u91cf</th></thead>");
        emailContent.append("<tbody>");
        List<PcsFlowerMerchantibleVO> voList = this.pcsFlowerDeliveryService.getFlowerSellNumber();
        if (EmptyUtil.isNotEmpty(voList)) {
            for (PcsFlowerMerchantibleVO vo : voList) {
                emailContent.append("<tr>");
                emailContent.append("<td>" + vo.getSkuCode() + "</td>");
                emailContent.append("<td>" + vo.getSkuName() + "</td>");
                emailContent.append("<td>" + (vo.getPlanQuantity() - vo.getSoldQuantity()) + "</td>");
                emailContent.append("<td>" + (vo.getTmallPlanQuantity() - vo.getTmallSoldQuantity()) + "</td>");
                emailContent.append("</tr>");
            }
            emailContent.append("</tbody></table></html>");
            emailContent.append("<tbody>");
            ArrayList<String> toAddressList = new ArrayList<String>();
            toAddressList.add("feng.guo@thebeastshop.com");
            CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("flower.delivery.StockWarn");
            String[] toNotifyUsers = new String[]{};
            if (EmptyUtil.isNotEmpty((Object)commGlobalConfig)) {
                toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
            }
            EmailVO emailVO = new EmailVO();
            emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
            emailVO.setSubject("\u6708\u9001\u9c9c\u82b1\u5e93\u5b58\u9884\u8b66");
            emailVO.setContent(emailContent.toString());
            if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
                this.emailSendService.send(emailVO);
            }
        }
    }

    @Override
    public void flowerFinishStateChange() {
        this.pcsFlowerDeliveryService.updateFlowerFinishStateChange();
    }

    @Override
    @Transactional
    public void closePop() {
        List<PcsPoPlan> poPlanList = this.pcsPoPlanMapper.findNeedToClosedPOP();
        if (EmptyUtil.isNotEmpty(poPlanList)) {
            this.closePopAndCommand(poPlanList, true, false);
        }
    }

    @Override
    @Transactional
    public List<Long> closePoAndPopOnEveryDayTiming(List<PcsPoPlan> poPlanList) {
        if (EmptyUtil.isNotEmpty(poPlanList)) {
            this.closePopAndCommand(poPlanList, false, true);
        }
        return Collections.singletonList(1L);
    }

    private void closePopAndCommand(List<PcsPoPlan> poPlanList, boolean checkPop, boolean checkCommand) {
        if (EmptyUtil.isNotEmpty(poPlanList)) {
            for (PcsPoPlan pcsPoPlan : poPlanList) {
                try {
                    if (checkPop) {
                        boolean isUpdate;
                        this.pcsPoPlanService.closePoPlanByPlanId(pcsPoPlan.getId());
                        int result = this.pcsPoPlanMapper.isAllPoPlanFinished(pcsPoPlan.getPoId());
                        PcsPurchaseOrder pcsPurchaseOrder = this.pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
                        boolean bl = isUpdate = !pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                        if (result != 0 || !isUpdate) continue;
                        pcsPurchaseOrder = new PcsPurchaseOrder();
                        pcsPurchaseOrder.setId(pcsPoPlan.getPoId());
                        pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                        this.pcsPurchaseOrderMapper.updateByPrimaryKeySelective(pcsPurchaseOrder);
                        continue;
                    }
                    if (!checkCommand) continue;
                    this.pcsPoPlanService.closePoPlanByPlanIdCheckCommand(pcsPoPlan.getId(), pcsPoPlan.getWhCommandId());
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        }
    }

    @Override
    public List<Long> closePurchaseOrder() {
        List<PcsPurchaseOrder> purchaseOrders = this.pcsPurchaseOrderService.findNeedToClosedPO();
        ArrayList<Long> poIds = new ArrayList<Long>();
        if (EmptyUtil.isNotEmpty(purchaseOrders)) {
            for (PcsPurchaseOrder pcsPurchaseOrder : purchaseOrders) {
                try {
                    boolean result = this.pcsPurchaseOrderService.closePurchaseOrder(pcsPurchaseOrder.getId());
                    if (!result) continue;
                    poIds.add(pcsPurchaseOrder.getId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return poIds;
    }
}

