/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTplMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTplFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTplService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsCertificateTplService")
public class PcsCertificateTplServiceImpl
implements PcsCertificateTplService {
    @Autowired
    private PcsCertificateTplMapper pcsCertificateTplMapper;
    @Autowired
    private PcsCertificateTplFieldService pcsCertificateTplFieldService;

    @Override
    public List<PcsCertificateTplVO> findAll() {
        return this.pcsCertificateTplMapper.findAll();
    }

    @Override
    public PcsCertificateTplVO findById(Long id, boolean cascade) {
        PcsCertificateTplVO vo = this.pcsCertificateTplMapper.findById(id);
        if (cascade) {
            this.findTplCascadeInfo(vo);
        }
        return vo;
    }

    @Override
    public PcsCertificateTplVO findCerTplVOsByCond(PcsCertificateTplVO tplVO) {
        List<PcsCertificateTplVO> tplVOs = this.listCerTplVOsByCond(tplVO);
        if (CollectionUtils.isNotEmpty(tplVOs)) {
            return tplVOs.get(0);
        }
        return null;
    }

    @Override
    public List<PcsCertificateTplVO> listCerTplVOsByCond(PcsCertificateTplVO tplVO) {
        return this.pcsCertificateTplMapper.listCerTplVOsByCond(tplVO);
    }

    @Override
    public List<PcsCertificateTplVO> findByIds(List<Long> ids, boolean cascade) {
        List<PcsCertificateTplVO> tplList = this.pcsCertificateTplMapper.findByIds(ids);
        if (EmptyUtil.isEmpty(tplList) || !cascade) {
            return tplList;
        }
        Map<Long, List<PcsCertificateTplFieldVO>> cerTplFieldMap = this.pcsCertificateTplFieldService.findByTplIds(ids);
        for (PcsCertificateTplVO tplVO : tplList) {
            tplVO.setTplFieldVOList(cerTplFieldMap.get(tplVO.getId()));
        }
        return tplList;
    }

    @Override
    public PcsCertificateTplVO findByCategoryId(Long categoryId, boolean cascade) {
        PcsCertificateTplVO vo = this.pcsCertificateTplMapper.findByCategoryId(categoryId);
        if (cascade) {
            this.findTplCascadeInfo(vo);
        }
        return vo;
    }

    @Override
    public PcsCertificateTplVO findBySkuCode(String skuCode) {
        PcsCertificateTplVO vo = this.pcsCertificateTplMapper.findBySkuCode(skuCode);
        this.findTplCascadeInfo(vo);
        return vo;
    }

    @Override
    @Transactional
    public void save(PcsCertificateTplVO vo) {
        this.pcsCertificateTplMapper.insert(vo);
        this.saveTplCategory(vo);
    }

    @Override
    @Transactional
    public void copyCerTpl(PcsCertificateTplVO vo) {
        this.pcsCertificateTplMapper.insert(vo);
        this.saveTplCategory(vo);
    }

    @Override
    @Transactional
    public void saveWithTplFields(PcsCertificateTplVO vo) {
        this.save(vo);
        if (EmptyUtil.isNotEmpty(vo.getTplFieldVOList())) {
            for (PcsCertificateTplFieldVO tplFieldVO : vo.getTplFieldVOList()) {
                tplFieldVO.setCertificateTplId(vo.getId());
                this.pcsCertificateTplFieldService.save(tplFieldVO);
            }
        }
    }

    @Override
    @Transactional
    public void update(PcsCertificateTplVO vo) {
        this.updateTplFieldTypeSet(vo);
        this.saveTplCategory(vo);
        PcsCertificateTplVO old = this.pcsCertificateTplMapper.findById(vo.getId());
        vo.setCreateUserId(old.getCreateUserId());
        vo.setCreateTime(old.getCreateTime());
        this.pcsCertificateTplMapper.updateByPrimaryKey(vo);
    }

    @Override
    @Transactional
    public void updateWithTplFields(PcsCertificateTplVO vo) {
        this.pcsCertificateTplFieldService.deleteByTplId(vo.getId());
        if (EmptyUtil.isNotEmpty(vo.getTplFieldVOList())) {
            for (PcsCertificateTplFieldVO tplFieldVO : vo.getTplFieldVOList()) {
                tplFieldVO.setCertificateTplId(vo.getId());
                this.pcsCertificateTplFieldService.save(tplFieldVO);
            }
        }
        this.saveTplCategory(vo);
        this.pcsCertificateTplMapper.updateByPrimaryKeySelective(vo);
    }

    @Override
    @Transactional
    public void updateBasic(PcsCertificateTplVO vo) {
        this.pcsCertificateTplMapper.updateByPrimaryKeySelective(vo);
    }

    private void findTplCascadeInfo(PcsCertificateTplVO vo) {
        if (NullUtil.isNotNull((Object)vo)) {
            List<PcsCertificateTplFieldVO> tplFieldList = this.pcsCertificateTplFieldService.findByTplId(vo.getId());
            vo.setTplFieldVOList(tplFieldList);
            List<Long> categoryIds = this.pcsCertificateTplMapper.findCategoryIdByTplId(vo.getId());
            vo.setCategoryIds(categoryIds);
        }
    }

    @Override
    public List<Long> findUsedCategoryIds() {
        return this.pcsCertificateTplMapper.findUsedCategoryIds();
    }

    @Override
    public PcsCertificateTplVO findCommonUseTpl(boolean cascade) {
        PcsCertificateTplVO vo = this.pcsCertificateTplMapper.findCommonUseTpl();
        if (NullUtil.isNotNull((Object)vo) && cascade) {
            this.findTplCascadeInfo(vo);
        }
        return vo;
    }

    @Override
    public String getFieldDicValue(Long tplFieldDicId, String skuCode, String barCode) {
        return this.pcsCertificateTplFieldService.getFieldDicValue(tplFieldDicId, skuCode, barCode);
    }

    @Override
    public void fullCerTplDefaultValue(PcsCertificateTplVO cerTplVO, String skuCode) {
        if (EmptyUtil.isEmpty(cerTplVO.getTplFieldVOList())) {
            return;
        }
        for (PcsCertificateTplFieldVO tplField : cerTplVO.getTplFieldVOList()) {
            if (null == tplField.getFieldDicId()) continue;
            String value = this.pcsCertificateTplFieldService.getFieldDicValue(tplField.getFieldDicId(), skuCode, "");
            tplField.setDefaultValue(value);
        }
    }

    private void updateTplFieldTypeSet(PcsCertificateTplVO vo) {
        PcsCertificateTplVO oldVO = this.pcsCertificateTplMapper.findById(vo.getId());
        String avaliableSize = vo.getAvaliableSize();
        String oldAvaliableSize = oldVO.getAvaliableSize();
        if (EmptyUtil.isEmpty((String)oldAvaliableSize)) {
            return;
        }
        List<String> oldSizeList = Arrays.asList(oldAvaliableSize.split(","));
        if (EmptyUtil.isNotEmpty((String)avaliableSize)) {
            List<String> sizeList = Arrays.asList(avaliableSize.split(","));
            ArrayList<String> tmpList = new ArrayList<String>();
            for (String oldSize : oldSizeList) {
                if (sizeList.contains(oldSize)) continue;
                tmpList.add(oldSize);
            }
            oldSizeList = tmpList;
        }
        if (EmptyUtil.isEmpty(oldSizeList)) {
            return;
        }
        this.pcsCertificateTplFieldService.deleteTplFieldTypeSet(vo.getId(), oldSizeList);
    }

    private void saveTplCategory(PcsCertificateTplVO vo) {
        this.pcsCertificateTplMapper.deleteTplCategoryByTplId(vo.getId());
        if (EmptyUtil.isNotEmpty(vo.getCategoryIds())) {
            List<Long> usedCategoryIds = this.findUsedCategoryIds();
            if (EmptyUtil.isNotEmpty(usedCategoryIds)) {
                usedCategoryIds.retainAll(vo.getCategoryIds());
                if (EmptyUtil.isNotEmpty(usedCategoryIds)) {
                    throw new PurchaseException("\u5b58\u5728\u5df2\u5173\u8054\u6a21\u677f\u7684\u7c7b\u76ee");
                }
            }
            for (Long categoryId : vo.getCategoryIds()) {
                this.pcsCertificateTplMapper.insertTplCategory(categoryId, vo.getId());
            }
        }
    }
}

