/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTplFieldDicMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTplFieldMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTplFieldTypesetMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTplFieldExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTplFieldService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldDicVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldTypesetVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsCertificateTplFieldService")
public class PcsCertificateTplFieldServiceImpl
implements PcsCertificateTplFieldService {
    @Autowired
    private PcsCertificateTplFieldMapper pcsCertificateTplFieldMapper;
    @Autowired
    private PcsCertificateTplFieldTypesetMapper pcsCertificateTplFieldTypesetMapper;
    @Autowired
    private PcsCertificateTplFieldDicMapper pcsCertificateTplFieldDicMapper;

    @Override
    @Transactional
    public int save(PcsCertificateTplFieldVO vo) {
        int result = this.pcsCertificateTplFieldMapper.insert(vo);
        if (EmptyUtil.isNotEmpty(vo.getFieldTypesetList())) {
            for (PcsCertificateTplFieldTypesetVO typesetVO : vo.getFieldTypesetList()) {
                typesetVO.setTplFieldId(vo.getId());
                this.pcsCertificateTplFieldTypesetMapper.insert(typesetVO);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public int update(PcsCertificateTplFieldVO vo) {
        this.pcsCertificateTplFieldTypesetMapper.deleteByTplFieldId(vo.getId());
        if (EmptyUtil.isNotEmpty(vo.getFieldTypesetList())) {
            for (PcsCertificateTplFieldTypesetVO typesetVO : vo.getFieldTypesetList()) {
                typesetVO.setTplFieldId(vo.getId());
                this.pcsCertificateTplFieldTypesetMapper.insert(typesetVO);
            }
        }
        return this.pcsCertificateTplFieldMapper.updateByPrimaryKey(vo);
    }

    @Override
    @Transactional
    public int saveOrUpdate(PcsCertificateTplFieldVO vo) {
        if (NullUtil.isNull((Object)vo.getId())) {
            return this.save(vo);
        }
        return this.update(vo);
    }

    @Override
    @Transactional
    public int deleteByTplId(Long certificateTplId) {
        this.pcsCertificateTplFieldTypesetMapper.deleteByTplId(certificateTplId);
        PcsCertificateTplFieldExample example = new PcsCertificateTplFieldExample();
        example.createCriteria().andCertificateTplIdEqualTo(certificateTplId);
        return this.pcsCertificateTplFieldMapper.deleteByExample(example);
    }

    @Override
    @Transactional
    public int deleteByTplFieldId(Long TplFieldId) {
        this.pcsCertificateTplFieldTypesetMapper.deleteByTplFieldId(TplFieldId);
        return this.pcsCertificateTplFieldMapper.deleteByPrimaryKey(TplFieldId);
    }

    @Override
    public List<PcsCertificateTplFieldVO> findByTplId(Long certificateTplId) {
        List<PcsCertificateTplFieldVO> fieldList = this.pcsCertificateTplFieldMapper.findByTplId(certificateTplId);
        if (EmptyUtil.isNotEmpty(fieldList)) {
            List<PcsCertificateTplFieldTypesetVO> tmpList;
            List<PcsCertificateTplFieldTypesetVO> fieldTypesetList = this.pcsCertificateTplFieldTypesetMapper.findByTplId(certificateTplId);
            HashMap<Long, ArrayList<PcsCertificateTplFieldTypesetVO>> fieldTypesetMap = new HashMap<Long, ArrayList<PcsCertificateTplFieldTypesetVO>>();
            if (EmptyUtil.isNotEmpty(fieldTypesetList)) {
                for (PcsCertificateTplFieldTypesetVO typesetVO : fieldTypesetList) {
                    tmpList = (ArrayList<PcsCertificateTplFieldTypesetVO>)fieldTypesetMap.get(typesetVO.getTplFieldId());
                    if (NullUtil.isNull((Object)tmpList)) {
                        tmpList = new ArrayList<PcsCertificateTplFieldTypesetVO>();
                        fieldTypesetMap.put(typesetVO.getTplFieldId(), (ArrayList<PcsCertificateTplFieldTypesetVO>)tmpList);
                    }
                    tmpList.add(typesetVO);
                }
            }
            for (PcsCertificateTplFieldVO fieldVO : fieldList) {
                tmpList = (List)fieldTypesetMap.get(fieldVO.getId());
                if (!EmptyUtil.isNotEmpty((List)tmpList)) continue;
                fieldVO.setFieldTypesetList(tmpList);
            }
        }
        return fieldList;
    }

    @Override
    public Map<Long, List<PcsCertificateTplFieldVO>> findByTplIds(List<Long> tplIds) {
        HashMap<Long, List<PcsCertificateTplFieldVO>> cerTplFieldMap = new HashMap<Long, List<PcsCertificateTplFieldVO>>();
        List<PcsCertificateTplFieldVO> fieldList = this.pcsCertificateTplFieldMapper.findByTplIds(tplIds);
        if (EmptyUtil.isNotEmpty(fieldList)) {
            List<PcsCertificateTplFieldTypesetVO> fieldTypesetList = this.pcsCertificateTplFieldTypesetMapper.findByTplIds(tplIds);
            HashMap<Long, ArrayList<PcsCertificateTplFieldTypesetVO>> fieldTypesetMap = new HashMap<Long, ArrayList<PcsCertificateTplFieldTypesetVO>>();
            if (EmptyUtil.isNotEmpty(fieldTypesetList)) {
                for (PcsCertificateTplFieldTypesetVO typesetVO : fieldTypesetList) {
                    ArrayList<PcsCertificateTplFieldTypesetVO> tmpList = (ArrayList<PcsCertificateTplFieldTypesetVO>)fieldTypesetMap.get(typesetVO.getTplFieldId());
                    if (NullUtil.isNull((Object)tmpList)) {
                        tmpList = new ArrayList<PcsCertificateTplFieldTypesetVO>();
                        fieldTypesetMap.put(typesetVO.getTplFieldId(), tmpList);
                    }
                    tmpList.add(typesetVO);
                }
            }
            List<PcsCertificateTplFieldDicVO> fieldDicList = this.findAllCerTplFieldDic();
            HashMap<Long, PcsCertificateTplFieldDicVO> dicMap = new HashMap<Long, PcsCertificateTplFieldDicVO>();
            if (EmptyUtil.isNotEmpty(fieldDicList)) {
                for (PcsCertificateTplFieldDicVO dic : fieldDicList) {
                    dicMap.put(dic.getId(), dic);
                }
            }
            for (PcsCertificateTplFieldVO fieldVO : fieldList) {
                ArrayList<PcsCertificateTplFieldVO> tmpFieldList = (ArrayList<PcsCertificateTplFieldVO>)cerTplFieldMap.get(fieldVO.getCertificateTplId());
                if (NullUtil.isNull((Object)tmpFieldList)) {
                    tmpFieldList = new ArrayList<PcsCertificateTplFieldVO>();
                    cerTplFieldMap.put(fieldVO.getCertificateTplId(), tmpFieldList);
                }
                tmpFieldList.add(fieldVO);
                List tmpList = (List)fieldTypesetMap.get(fieldVO.getId());
                if (EmptyUtil.isNotEmpty((List)tmpList)) {
                    fieldVO.setFieldTypesetList(tmpList);
                }
                fieldVO.setCertificateTplFieldDicVO((PcsCertificateTplFieldDicVO)dicMap.get(fieldVO.getFieldDicId()));
            }
        }
        return cerTplFieldMap;
    }

    @Override
    public PcsCertificateTplFieldVO findTplFieldVO(Long tplId, Long tplFieldId) {
        PcsCertificateTplFieldVO tplFieldVO = this.pcsCertificateTplFieldMapper.findByTplIdTplFieldId(tplId, tplFieldId);
        if (NullUtil.isNotNull((Object)tplFieldVO)) {
            List<PcsCertificateTplFieldTypesetVO> fieldTypesetList = this.pcsCertificateTplFieldTypesetMapper.findByTplFieldId(tplFieldId);
            if (CollectionUtils.isNotEmpty(fieldTypesetList)) {
                for (PcsCertificateTplFieldTypesetVO vo : fieldTypesetList) {
                    vo.setCerName(vo.getCerSize());
                    vo.setCerSize(EmptyUtil.isNotEmpty((String)vo.getCerSize()) ? vo.getCerSize().replaceAll("\\*", "") : "");
                }
            }
            tplFieldVO.setFieldTypesetList(fieldTypesetList);
        }
        return tplFieldVO;
    }

    @Override
    public void deleteTplFieldTypeSet(Long tplId, List<String> delTypeSetList) {
        this.pcsCertificateTplFieldTypesetMapper.deleteTplFieldTypeSet(tplId, delTypeSetList);
    }

    @Override
    public List<PcsCertificateTplFieldDicVO> findAllCerTplFieldDic() {
        return this.pcsCertificateTplFieldDicMapper.findAll();
    }

    @Override
    public PcsCertificateTplFieldDicVO findTplFieldDicById(Long tplFieldDicId) {
        return this.pcsCertificateTplFieldDicMapper.findTplFieldDicById(tplFieldDicId);
    }

    @Override
    public String getFieldDicValue(Long tplFieldDicId, String skuCode, String barCode) {
        PcsCertificateTplFieldDicVO dic = this.pcsCertificateTplFieldDicMapper.findTplFieldDicById(tplFieldDicId);
        if (NullUtil.isNull((Object)dic)) {
            throw new PurchaseException("PC0002", "\u6a21\u677f\u5b57\u5178\u4e0d\u5b58\u5728");
        }
        String sql = dic.getFieldTable();
        sql = sql.replaceAll("[?]", "'" + skuCode + "'");
        sql = sql.replaceAll("[#]", "'" + barCode + "'");
        return this.pcsCertificateTplFieldDicMapper.getQueryValue(sql);
    }

    @Override
    public String getFieldDicValue(String sqlTpl, String skuCode) {
        String sql = sqlTpl.replaceAll("[?]", "'" + skuCode + "'");
        return this.pcsCertificateTplFieldDicMapper.getQueryValue(sql);
    }
}

