/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTagFieldMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTagMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTag;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTagExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTagField;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTagFieldExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateSkuFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTagService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateSkuFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagEditVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagFieldValueVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintCerVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintSkuCerVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="csCertificateTagService")
public class PcsCertificateTagServiceImpl
implements PcsCertificateTagService {
    @Autowired
    PcsCertificateTagMapper pcsCertificateTagMapper;
    @Autowired
    PcsCertificateTagFieldMapper pcsCertificateTagFieldMapper;
    @Autowired
    private PcsCertificateFieldService pcsCertificateFieldService;
    @Autowired
    private PcsCertificateSkuFieldService pcsCertificateSkuFieldService;

    @Override
    public PcsCertificateTagEditVO getTagAndSkuBySkuCode(String skuCode) {
        return this.pcsCertificateTagMapper.getTagAndSkuBySkuCode(skuCode);
    }

    @Override
    public List<PcsCertificateTagFieldValueVO> getTagFieldsSkuBySkuCode(String skuCode) {
        return this.pcsCertificateTagFieldMapper.getTagFieldsSkuBySkuCode(skuCode);
    }

    @Override
    public int saveCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag) {
        this.pcsCertificateTagMapper.insertSelective(pcsCertificateTag);
        int id = pcsCertificateTag.getId();
        return id;
    }

    @Override
    public void updateCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag) {
        this.pcsCertificateTagMapper.updateByPrimaryKeySelective(pcsCertificateTag);
    }

    @Override
    public void saveCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField) {
        this.pcsCertificateTagFieldMapper.insertSelective(pcsCertificateTagField);
    }

    @Override
    public void updateCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField) {
        this.pcsCertificateTagFieldMapper.updateByPrimaryKeySelective(pcsCertificateTagField);
    }

    @Override
    public void deleteCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField) {
        PcsCertificateTagFieldExample example = new PcsCertificateTagFieldExample();
        PcsCertificateTagFieldExample.Criteria criteria = example.createCriteria();
        criteria.andCertificateTagIdEqualTo(pcsCertificateTagField.getCertificateTagId());
        this.pcsCertificateTagFieldMapper.deleteByExample(example);
    }

    @Override
    public boolean addPcsCertificateTag(PcsCertificateTagVO vo) {
        this.pcsCertificateTagMapper.insert(vo);
        List<PcsCertificateTagFieldVO> tagFields = vo.getTagFields();
        if (EmptyUtil.isNotEmpty(tagFields)) {
            for (PcsCertificateTagFieldVO field : tagFields) {
                field.setCertificateTagId(vo.getId());
                this.pcsCertificateTagFieldMapper.insert(field);
            }
        }
        return true;
    }

    @Override
    public boolean updatePcsCertificateTag(PcsCertificateTagVO vo) {
        this.pcsCertificateTagMapper.updateByPrimaryKey(vo);
        PcsCertificateTagFieldExample example = new PcsCertificateTagFieldExample();
        example.createCriteria().andCertificateTagIdEqualTo(vo.getId());
        this.pcsCertificateTagFieldMapper.deleteByExample(example);
        List<PcsCertificateTagFieldVO> tagFields = vo.getTagFields();
        if (EmptyUtil.isNotEmpty(tagFields)) {
            for (PcsCertificateTagFieldVO field : tagFields) {
                field.setCertificateTagId(vo.getId());
                this.pcsCertificateTagFieldMapper.insert(field);
            }
        }
        return true;
    }

    @Override
    public boolean addPcsCertificateTag(List<PcsCertificateTagVO> vos) {
        if (EmptyUtil.isNotEmpty(vos)) {
            for (PcsCertificateTagVO vo : vos) {
                PcsCertificateTagExample example = new PcsCertificateTagExample();
                example.createCriteria().andSkuCodeEqualTo(vo.getSkuCode());
                List<PcsCertificateTag> voList = this.pcsCertificateTagMapper.selectByExample(example);
                if (EmptyUtil.isEmpty(voList)) {
                    this.addPcsCertificateTag(vo);
                    continue;
                }
                PcsCertificateTag tag = voList.get(0);
                vo.setCreateTime(tag.getCreateTime());
                vo.setCreateUserId(tag.getCreateUserId());
                vo.setId(tag.getId());
                vo.setIsSubmit(tag.getIsSubmit());
                this.updatePcsCertificateTag(vo);
            }
        }
        return true;
    }

    @Override
    public List<PcsCertificateFieldVO> getTagFieldsSkuByIds(List<Integer> ids) {
        ArrayList<PcsCertificateFieldVO> list = new ArrayList<PcsCertificateFieldVO>();
        if (EmptyUtil.isNotEmpty(ids)) {
            for (Integer id : ids) {
                list.add(this.pcsCertificateFieldService.findPcsCertificateFieldById(id));
            }
        }
        return list;
    }

    @Override
    public PcsCertificateTagVO searchTagBySkuCode(PcsCertificateTag tag) {
        PcsCertificateTagExample example = new PcsCertificateTagExample();
        example.createCriteria().andSkuCodeEqualTo(tag.getSkuCode());
        List<PcsCertificateTag> list = this.pcsCertificateTagMapper.selectByExample(example);
        PcsCertificateTagVO vo = null;
        if (!CollectionUtils.isEmpty(list)) {
            vo = new PcsCertificateTagVO();
            vo.setCertificateSize(list.get(0).getCertificateSize());
            vo.setCheckStatus(list.get(0).getCheckStatus());
            vo.setCreateTime(list.get(0).getCreateTime());
            vo.setId(list.get(0).getId());
            vo.setImgUrl(list.get(0).getImgUrl());
            vo.setIsHasTag(list.get(0).getIsHasTag());
            vo.setIsSubmit(list.get(0).getIsSubmit());
        }
        return vo;
    }

    @Override
    public List<PcsCertificateTagVO> getCertificateTagBySkuCodes(List<String> skuCodes) {
        List<PcsCertificateTagFieldValueVO> fieldValueList;
        List<PcsCertificateTagVO> tagList = this.pcsCertificateTagMapper.getPcsCertificateTagBySkuCodes(skuCodes);
        ArrayList<Integer> tagIds = new ArrayList<Integer>();
        if (EmptyUtil.isNotEmpty(tagList)) {
            for (PcsCertificateTagVO tagVo : tagList) {
                tagIds.add(tagVo.getId());
            }
        }
        if (EmptyUtil.isNotEmpty(tagIds) && EmptyUtil.isNotEmpty(fieldValueList = this.pcsCertificateTagFieldMapper.getTagFieldByTagIds(tagIds))) {
            for (PcsCertificateTagVO tagVo : tagList) {
                tagVo.setTagFieldValues(this.filterTagFieldValueList(fieldValueList, tagVo.getId()));
            }
        }
        return tagList;
    }

    @Override
    public List<PcsCertificateTagVO> getTagBySkuCodeBarCode(PrintCerVO cond) {
        if (EmptyUtil.isEmpty((Object)cond) || EmptyUtil.isEmpty(cond.getSkuInfos())) {
            return new ArrayList<PcsCertificateTagVO>();
        }
        List<PrintSkuCerVO> skuCodeBarcordList = cond.getSkuInfos();
        HashSet<String> skuCodes = new HashSet<String>();
        for (PrintSkuCerVO sb : skuCodeBarcordList) {
            skuCodes.add(sb.getSkuCode());
        }
        List<PcsCertificateTagVO> tagList = this.getCertificateTagBySkuCodes(Arrays.asList(skuCodes.toArray(new String[0])));
        if (EmptyUtil.isEmpty(tagList)) {
            return new ArrayList<PcsCertificateTagVO>();
        }
        ArrayList<Integer> tagIds = new ArrayList<Integer>();
        if (EmptyUtil.isNotEmpty(tagList)) {
            for (PcsCertificateTagVO tagVo : tagList) {
                tagIds.add(tagVo.getId());
            }
        }
        ArrayList<PcsCertificateTagVO> result = new ArrayList<PcsCertificateTagVO>();
        block2: for (PrintSkuCerVO skuCodeBarCode : skuCodeBarcordList) {
            for (PcsCertificateTagVO tag : tagList) {
                if (!tag.getSkuCode().equals(skuCodeBarCode.getSkuCode())) continue;
                PcsCertificateTagVO cer = new PcsCertificateTagVO();
                BeanUtils.copyProperties((Object)tag, (Object)cer);
                if (EmptyUtil.isNotEmpty(tag.getTagFieldValues())) {
                    ArrayList<PcsCertificateTagFieldValueVO> fieldValues = new ArrayList<PcsCertificateTagFieldValueVO>();
                    for (PcsCertificateTagFieldValueVO f : tag.getTagFieldValues()) {
                        PcsCertificateTagFieldValueVO field = new PcsCertificateTagFieldValueVO();
                        BeanUtils.copyProperties((Object)f, (Object)field);
                        if (EmptyUtil.isNotEmpty((String)skuCodeBarCode.getProdDate()) && "\u751f\u4ea7\u65e5\u671f".equals(field.getFieldName())) {
                            field.setCertificateFieldValue(skuCodeBarCode.getProdDate());
                        }
                        fieldValues.add(field);
                    }
                    cer.setTagFieldValues(fieldValues);
                }
                cer.setBarCode(skuCodeBarCode.getBarCode());
                result.add(cer);
                continue block2;
            }
        }
        if (EmptyUtil.isNotEmpty(result)) {
            for (PcsCertificateTagVO tag : result) {
                List<PcsCertificateTagFieldValueVO> tagFieldValues = tag.getTagFieldValues();
                if (EmptyUtil.isEmpty(tagFieldValues)) continue;
                for (PcsCertificateTagFieldValueVO fieldValueVO : tagFieldValues) {
                    if (!PcsCertificateFieldVO.WRITE_TYPE_SYS.equals(fieldValueVO.getWriteType())) continue;
                    PcsCertificateSkuFieldVO fieldInfo = this.pcsCertificateSkuFieldService.getPcsCertificateSkuFieldVOById(fieldValueVO.getSkuFieldId());
                    String value = this.pcsCertificateSkuFieldService.getFieldValueBySkuCodeBarCode(fieldInfo, tag.getSkuCode(), tag.getBarCode());
                    fieldValueVO.setCertificateFieldValue(value);
                }
            }
        }
        return result;
    }

    private List<PcsCertificateTagFieldValueVO> filterTagFieldValueList(List<PcsCertificateTagFieldValueVO> fieldValueList, Integer tagId) {
        ArrayList<PcsCertificateTagFieldValueVO> values = new ArrayList<PcsCertificateTagFieldValueVO>();
        for (PcsCertificateTagFieldValueVO value : fieldValueList) {
            if (!tagId.equals(value.getTagId())) continue;
            values.add(value);
        }
        return values;
    }
}

