/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PcsCertificateFieldCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateFieldMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateSkuFieldMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateField;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateSkuFieldService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateSkuFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagFieldValueVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pcsCertificateFieldService")
public class PcsCertificateFieldServiceImpl
implements PcsCertificateFieldService {
    private static final Logger log = LoggerFactory.getLogger(PcsCertificateFieldServiceImpl.class);
    @Autowired
    private PcsCertificateFieldMapper PcsCertificateFieldMapper;
    @Autowired
    private PcsCertificateSkuFieldMapper pcsCertificateSkuFieldMapper;
    @Autowired
    private PcsCertificateSkuFieldService pcsCertificateSkuFieldService;

    @Override
    public boolean create(PcsCertificateField field) {
        boolean result;
        boolean bl = result = this.PcsCertificateFieldMapper.insert(field) == 1;
        if (result) {
            field.setFieldCode("CF" + field.getId());
            this.PcsCertificateFieldMapper.updateByPrimaryKeySelective(field);
        }
        return result;
    }

    @Override
    public boolean update(PcsCertificateField field) {
        return this.PcsCertificateFieldMapper.updateByPrimaryKey(field) == 1;
    }

    @Override
    public boolean deleteById(int id) {
        PcsCertificateField del = new PcsCertificateField();
        del.setId(id);
        del.setIsDelete(PcsCertificateFieldVO.DELETE_YES);
        return this.PcsCertificateFieldMapper.updateByPrimaryKey(del) == 1;
    }

    @Override
    public List<PcsCertificateFieldVO> findPcsCertificateField(PcsCertificateFieldCond cond) {
        return this.PcsCertificateFieldMapper.findPcsCertificateField(cond);
    }

    @Override
    public PcsCertificateFieldVO findPcsCertificateFieldById(int id) {
        return this.PcsCertificateFieldMapper.findPcsCertificateFieldById(id);
    }

    @Override
    public List<PcsCertificateFieldVO> findPcsCertificateField(PcsCertificateFieldCond cond, boolean cascade) {
        String skuCode;
        List<PcsCertificateSkuFieldVO> fieldInfos;
        List<PcsCertificateFieldVO> fields = this.PcsCertificateFieldMapper.findPcsCertificateField(cond);
        if (!cascade) {
            return fields;
        }
        ArrayList<Integer> infoFieldIds = new ArrayList<Integer>();
        if (EmptyUtil.isNotEmpty(fields)) {
            for (PcsCertificateFieldVO field : fields) {
                Integer infoId = field.getSkuFieldId();
                if (infoFieldIds.contains(infoId)) continue;
                infoFieldIds.add(infoId);
            }
        }
        if (EmptyUtil.isNotEmpty(infoFieldIds) && EmptyUtil.isNotEmpty(fieldInfos = this.pcsCertificateSkuFieldMapper.getPcsCertificateSkuFieldByIds(infoFieldIds))) {
            fieldInfos = this.pcsCertificateSkuFieldMapper.getPcsCertificateSkuFieldByIds(infoFieldIds);
            block1: for (PcsCertificateFieldVO field : fields) {
                for (PcsCertificateSkuFieldVO fieldInfo : fieldInfos) {
                    if (!fieldInfo.getId().equals(field.getSkuFieldId())) continue;
                    PcsCertificateSkuFieldVO baseInfo = new PcsCertificateSkuFieldVO();
                    BeanUtils.copyProperties((Object)fieldInfo, (Object)baseInfo);
                    field.setFieldInfo(baseInfo);
                    continue block1;
                }
            }
        }
        if (EmptyUtil.isNotEmpty((String)(skuCode = cond.getSkuCode())) && EmptyUtil.isNotEmpty(fields)) {
            for (PcsCertificateFieldVO field : fields) {
                if (PcsCertificateFieldVO.WRITE_TYPE_INPUT.equals(field.getWriteType()) && EmptyUtil.isNotEmpty((Object)field.getSkuFieldId())) {
                    PcsCertificateSkuFieldVO fieldInfo = field.getFieldInfo();
                    String value = this.pcsCertificateSkuFieldService.getFieldValueBySkuCode(fieldInfo, skuCode);
                    field.setSysDefaultValue(value == null ? "" : value);
                    continue;
                }
                if (PcsCertificateFieldVO.WRITE_TYPE_INPUT.equals(field.getWriteType())) {
                    field.setSysDefaultValue(field.getDefaultValue() == null ? "" : field.getDefaultValue());
                    continue;
                }
                if (!PcsCertificateFieldVO.WRITE_TYPE_SYS.equals(field.getWriteType())) continue;
                String value = "";
                field.setSysDefaultValue(value == null ? "" : value);
            }
        }
        return fields;
    }

    private String buildFieldQuerySql(PcsCertificateSkuFieldVO fieldInfo, String skuCode) {
        String sql = fieldInfo.getFieldTable();
        sql = sql.replaceAll("[?]", "'" + skuCode + "'");
        return sql;
    }

    @Override
    public List<PcsCertificateTagFieldValueVO> getTagsBySkuCode(List<String> skuCodes) {
        List<PcsCertificateTagFieldValueVO> list = this.PcsCertificateFieldMapper.getTagsBySkuCode(skuCodes);
        return list;
    }
}

