/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.common.converter.GenericBeanConverter;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsBaseTaxRateCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsBaseTaxRateMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.PcsBaseTaxRate;
import com.thebeastshop.pegasus.service.purchase.service.PcsBaseTaxRateService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBaseTaxRateVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pcsBaseTaxRateService")
public class PcsBaseTaxRateServiceImpl
implements PcsBaseTaxRateService {
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private PcsBaseTaxRateMapper pcsBaseTaxRateMapper;
    protected GenericBeanConverter beanConverter = new GenericBeanConverter();

    @Override
    @Transactional
    public int batchInsert(List<PcsBaseTaxRateVO> taxRateList, List<PcsBaseTaxRateVO> newTaxRateList) {
        if (EmptyUtil.isEmpty(taxRateList)) {
            throw new PurchaseException("PC0001", "\u6279\u91cf\u63d2\u5165\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.pcsBaseTaxRateMapper.batchInsert(this.convertVO2PO(taxRateList));
        this.updateSkuTaxIdInfo(newTaxRateList);
        return 1;
    }

    private void updateSkuTaxIdInfo(List<PcsBaseTaxRateVO> newTaxRateList) {
        ArrayList<String> oldTaxIdList = new ArrayList<String>();
        for (PcsBaseTaxRateVO newTaxRate : newTaxRateList) {
            oldTaxIdList.add(newTaxRate.getTaxId());
        }
        if (EmptyUtil.isNotEmpty(oldTaxIdList)) {
            List skuList = this.mcPcsSkuService.findSkuByTaxIdList(oldTaxIdList);
            if (EmptyUtil.isNotEmpty((List)skuList)) {
                for (PcsSkuVO pcsSkuVO : skuList) {
                    String taxId = pcsSkuVO.getGoodsHscode();
                    for (PcsBaseTaxRateVO newTaxRate : newTaxRateList) {
                        if (!taxId.equals(newTaxRate.getTaxId())) continue;
                        this.buildSkuNewTaxIdInfo(pcsSkuVO, newTaxRate);
                    }
                }
            }
            this.mcPcsSkuService.updateSkus(skuList);
        }
    }

    private void buildSkuNewTaxIdInfo(PcsSkuVO pcsSkuVO, PcsBaseTaxRateVO pcsBaseTaxRateVO) {
        pcsSkuVO.setGoodsHscode(pcsBaseTaxRateVO.getNewTaxId());
        pcsSkuVO.setSaleTax(pcsBaseTaxRateVO.getSkuSaleTax());
        pcsSkuVO.setVatRate(pcsBaseTaxRateVO.getSkuVatRate().multiply(new BigDecimal(100)));
        pcsSkuVO.setGoodsLegalUnitcode(pcsBaseTaxRateVO.getGoodsLegalUnitcode());
        pcsSkuVO.setSecondLegalUnitcode(pcsBaseTaxRateVO.getSecondLegalUnitcode());
    }

    @Override
    public PcsBaseTaxRateVO findPcsBaseTaxRateById(String id) {
        PcsBaseTaxRate pcsBaseTaxRate = this.pcsBaseTaxRateMapper.selectByPrimaryKey(id);
        return this.convertPO2VO(pcsBaseTaxRate);
    }

    @Override
    public PageInfo<PcsBaseTaxRateVO> findPageBaseTaxRateByCond(PcsBaseTaxRateCond taxRateCond) {
        int offset = taxRateCond.getCurrpage() * taxRateCond.getPagenum();
        PageRowBounds pageRowBounds = new PageRowBounds(offset, taxRateCond.getPagenum().intValue());
        List<PcsBaseTaxRate> resultList = this.pcsBaseTaxRateMapper.selectPageBaseTaxRateByCond(taxRateCond, pageRowBounds);
        PageInfo pageInfo = new PageInfo(this.convertPO2VO(resultList));
        pageInfo.setTotal(pageRowBounds.getTotal().longValue());
        return pageInfo;
    }

    @Override
    public List<PcsBaseTaxRate> convertVO2PO(List<PcsBaseTaxRateVO> taxRateList) {
        ArrayList<PcsBaseTaxRate> poList = new ArrayList<PcsBaseTaxRate>();
        for (PcsBaseTaxRateVO vo : taxRateList) {
            PcsBaseTaxRate po = new PcsBaseTaxRate();
            BeanUtils.copyProperties((Object)vo, (Object)po);
            if (EmptyUtil.isNotEmpty((String)vo.getVatRate())) {
                po.setVatRate(new BigDecimal(vo.getVatRate()));
            }
            poList.add(po);
        }
        return poList;
    }

    @Override
    public List<PcsBaseTaxRateVO> convertPO2VO(List<PcsBaseTaxRate> poList) {
        ArrayList<PcsBaseTaxRateVO> voList = new ArrayList<PcsBaseTaxRateVO>();
        if (EmptyUtil.isNotEmpty(poList)) {
            for (PcsBaseTaxRate po : poList) {
                voList.add(this.convertPO2VO(po));
            }
        }
        return voList;
    }

    @Override
    public PcsBaseTaxRateVO convertPO2VO(PcsBaseTaxRate po) {
        PcsBaseTaxRateVO vo = new PcsBaseTaxRateVO();
        BeanUtils.copyProperties((Object)po, (Object)vo);
        if (EmptyUtil.isNotEmpty((Object)po.getVatRate())) {
            vo.setVatRate(String.valueOf(po.getVatRate()));
        }
        return vo;
    }

    @Override
    public PcsBaseTaxRateVO findBaseTaxRateByTaxId(String taxId) {
        PcsBaseTaxRate po = this.pcsBaseTaxRateMapper.selectBaseTaxRateByTaxId(taxId);
        return po == null ? null : this.convertPO2VO(po);
    }

    @Override
    public List<String> findAllTaxId() {
        return this.pcsBaseTaxRateMapper.selectAllTaxId();
    }

    @Override
    public List<PcsBaseTaxRateVO> findBaseTaxRateByNameOrCode(String arg0) {
        List pcsBaseTaxRateVOList = new ArrayList();
        if (EmptyUtil.isEmpty((String)arg0)) {
            return Collections.emptyList();
        }
        List<PcsBaseTaxRate> voList = this.pcsBaseTaxRateMapper.findBaseTaxRateByNameOrCode(arg0);
        pcsBaseTaxRateVOList = this.beanConverter.converterListFrom(voList, PcsBaseTaxRateVO.class);
        if (CollectionUtils.isEmpty(pcsBaseTaxRateVOList)) {
            return Collections.emptyList();
        }
        return pcsBaseTaxRateVOList;
    }
}

