/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuSalesPriceChangeStatusEnum;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCustomMadeService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuAuditRecordsVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuAuditVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCustomMadeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.dao.FpcsConsumableAllotMapper;
import com.thebeastshop.pegasus.service.purchase.dao.FpcsConsumableImportLogMapper;
import com.thebeastshop.pegasus.service.purchase.dao.FpcsSkuOrderMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.FpcsConsumableAllot;
import com.thebeastshop.pegasus.service.purchase.model.FpcsConsumableAllotKey;
import com.thebeastshop.pegasus.service.purchase.model.FpcsConsumableImportLog;
import com.thebeastshop.pegasus.service.purchase.model.FpcsSkuOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCustomMade;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuSalesPriceChange;
import com.thebeastshop.pegasus.service.purchase.service.FpcsSkuService;
import com.thebeastshop.pegasus.service.purchase.vo.FlowerSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.FpcsConsumableAllotSummaryVO;
import com.thebeastshop.pegasus.service.purchase.vo.FpcsConsumableAllotVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuProductVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="fpcsSkuServiceImpl")
public class FpcsSkuServiceImpl
implements FpcsSkuService,
CheckAble,
CodeAble {
    private final Logger log = LoggerFactory.getLogger(FpcsSkuServiceImpl.class);
    @Autowired
    private PcsSkuMapper pcsSkuMapper;
    @Autowired
    private FpcsSkuOrderMapper fpcsSkuOrderMapper;
    @Autowired
    private McPcsSkuSalesPriceChangeService mcPcsSkuSalesPriceChangeService;
    @Autowired
    private McPcsSkuCustomMadeService mcPcsSkuCustomMadeService;
    @Autowired
    private FpcsConsumableAllotMapper fpcsConsumableAllotMapper;
    @Autowired
    private FpcsConsumableImportLogMapper fpcsConsumableImportLogMapper;
    @Autowired
    private McPcsSkuService mcPcsSkuService;

    @Override
    public PcsSkuVO buildFromModel(PcsSku record) {
        if (NullUtil.isNull((Object)record)) {
            return null;
        }
        PcsSkuVO vo = new PcsSkuVO();
        BeanUtils.copyProperties((Object)record, (Object)vo);
        return vo;
    }

    @Override
    public FpcsSkuOrder bulidFromVO(FlowerSkuVO vo) {
        if (NullUtil.isNull((Object)vo)) {
            return null;
        }
        FpcsSkuOrder record = new FpcsSkuOrder();
        BeanUtils.copyProperties((Object)vo, (Object)record);
        return record;
    }

    @Override
    @Transactional
    public Long create(FpcsSkuOrder record) {
        block6: {
            if (!this.check(record).booleanValue() || !this.check(record, true).booleanValue()) break block6;
            this.initDefaultValue(record);
            try {
                FpcsSkuOrder queryCriterial = new FpcsSkuOrder();
                queryCriterial.setSkuCode(record.getSkuCode());
                FpcsSkuOrder oldFlowerSku = this.fpcsSkuOrderMapper.getFlowerSkuByQuery(queryCriterial);
                if (oldFlowerSku != null) {
                    record.setId(oldFlowerSku.getId());
                    this.fpcsSkuOrderMapper.updateByPrimaryKey(record);
                    return record.getId();
                }
                Long id = this.fpcsSkuOrderMapper.insertSelective(record);
                return id;
            }
            catch (Exception e) {
                try {
                    this.log.error(e.getMessage());
                }
                catch (Exception e2) {
                    this.log.error(e2.getMessage());
                }
            }
        }
        return null;
    }

    @Override
    @Transactional
    public List<Long> createSkus(List<FpcsSkuOrder> list) {
        this.fpcsSkuOrderMapper.deleteAllData();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (FpcsSkuOrder pcsSku : list) {
            ids.add(this.create(pcsSku));
        }
        return ids;
    }

    private void initDefaultValue(FpcsSkuOrder record) {
        record.setCreatTime(new Date());
    }

    @Override
    @Transactional
    public boolean update(FpcsSkuOrder record) {
        return false;
    }

    private void setNonField(PcsSku record) {
        record.setSalesPrice(null);
        record.setCode(null);
        record.setSkuType(null);
        record.setIsImported(null);
        record.setIsMadeBySelf(null);
    }

    @Override
    public Boolean canUpdateSalesPrice(String code) {
        List processingPriceList = this.mcPcsSkuService.findAuditRecordsByCodeAndStatus(code, PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (processingPriceList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean auditSkuSalesPriceChange(String code, Boolean isPass) {
        PcsSkuVO pcsSkuVO = this.findByCode(code);
        if (EmptyUtil.isEmpty((Object)pcsSkuVO)) {
            throw new PurchaseException("PC0001", "sku\u5b9e\u4f53\u4e3a\u7a7a");
        }
        if (!pcsSkuVO.getSkuStatus().equals(PcsSku.SKU_STATUS_WAITING_VERIFY)) {
            throw new PurchaseException("PC0002", "\u5fc5\u987b\u662f\u5f85\u5ba1\u6838\u72b6\u6001");
        }
        PcsSkuAuditVO skuAudit = new PcsSkuAuditVO();
        skuAudit.setApprovalOpinion("");
        skuAudit.setApprover(Long.valueOf(1L));
        skuAudit.setPass(isPass.booleanValue());
        skuAudit.setType(Integer.valueOf(0));
        this.mcPcsSkuService.auditSkuSalesPriceChange(skuAudit);
        PcsSkuAuditRecordsVO pcsSkuSalesPriceChange = this.mcPcsSkuService.findProcessingAuditBySkuCode(code);
        PcsSku pcsSku = new PcsSku();
        pcsSku.setId(pcsSkuVO.getId());
        if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_SUCCESS)) {
            pcsSku.setSkuStatus(PcsSku.SKU_STATUS_ABLE);
            pcsSku.setSalesPrice(pcsSkuSalesPriceChange.getNewSalePrice());
        } else if (pcsSkuSalesPriceChange.getChangeStatus().equals(PcsSkuSalesPriceChange.STATUS_REJECT)) {
            pcsSku.setSkuStatus(PcsSku.SKU_STATUS_REJECT);
        }
        this.pcsSkuMapper.updateByPrimaryKeySelective(pcsSku);
        return true;
    }

    @Override
    public PcsSkuAuditRecordsVO findSkuSalesPriceChangeByCodeAndProcessing(String code) {
        List pcsSkuAuditRecords = this.mcPcsSkuService.findAuditRecordsByCodeAndStatus(code, PcsSkuSalesPriceChangeStatusEnum.LEGAL_REVIEW.getStatus());
        return pcsSkuAuditRecords == null ? null : (PcsSkuAuditRecordsVO)pcsSkuAuditRecords.get(0);
    }

    @Override
    public List<PcsSku> findSkuByCodes(List<String> codes) {
        ArrayList<PcsSku> recordList = new ArrayList<PcsSku>();
        for (String code : codes) {
            PcsSku record = this.findSkuByCode(code);
            if (!EmptyUtil.isNotEmpty((Object)record) || !EmptyUtil.isNotEmpty((Object)record.getId())) continue;
            recordList.add(record);
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    @Transactional
    public Boolean convertSku(PcsSku sku, long skuCustomMadeId) {
        PcsSkuCustomMadeVO pcsSkuCustomMade = this.mcPcsSkuCustomMadeService.findById(skuCustomMadeId);
        sku.setIsJit(0);
        if (EmptyUtil.isNotEmpty((Object)pcsSkuCustomMade) && pcsSkuCustomMade.getSkuStatus().equals(PcsSkuCustomMade.SKU_STATUS_WAITING_CONVERT)) {
            pcsSkuCustomMade.setSkuStatus(PcsSkuCustomMade.SKU_STATUS_CONVERT);
            if (this.mcPcsSkuCustomMadeService.update(pcsSkuCustomMade)) {
                return true;
            }
            throw new PurchaseException("PC0010", "sku\u5b9a\u5236\u5355\u66f4\u65b0\u5931\u8d25");
        }
        throw new PurchaseException("PC0002", "\u72b6\u6001\u5fc5\u987b\u662f\u5f85\u8f6c\u6362");
    }

    private PcsSku findSkuByCode(String code) {
        PcsSkuExample example = new PcsSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSku> recordList = this.pcsSkuMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return null;
        }
        if (recordList.size() > 1) {
            throw new PurchaseException("PC0007", " \u6839\u636ecode[\" + code + \"]\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        return recordList.get(0);
    }

    @Override
    public PcsSku findById(long id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return this.pcsSkuMapper.selectByPrimaryKey(id);
    }

    @Override
    public PcsSkuVO findByCode(String code) {
        if (EmptyUtil.isEmpty((String)code)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        List<PcsSkuVO> voList = this.pcsSkuMapper.findSkuByCodes(Arrays.asList(code));
        if (CollectionUtils.isEmpty(voList)) {
            return null;
        }
        if (voList.size() > 1) {
            throw new PurchaseException("PC0007", " \u6839\u636ecode\u80fd\u67e5\u51fa2\u6761\u4ee5\u4e0a(\u542b\u4e24\u6761)\u8bb0\u5f55");
        }
        return voList.get(0);
    }

    @Override
    public List<PcsSkuVO> findByNameOrCode(String arg0) {
        if (EmptyUtil.isEmpty((String)arg0)) {
            return Collections.emptyList();
        }
        List<PcsSkuVO> voList = this.pcsSkuMapper.findSkuByNameOrCode(arg0);
        if (CollectionUtils.isEmpty(voList)) {
            return Collections.emptyList();
        }
        return voList;
    }

    @Override
    public List<PcsSkuVO> findByCond(PcsSkuCond cond) {
        return this.pcsSkuMapper.findSkuByCond(cond);
    }

    @Override
    public List<FpcsSkuOrder> getAllFlowerSkuInfo() {
        return this.fpcsSkuOrderMapper.getAllFlowerSkuInfo();
    }

    @Override
    public List<FpcsSkuOrder> getFlowerSkuInfo(Map<String, Object> params) {
        return this.fpcsSkuOrderMapper.getFlowerSkuInfo(params);
    }

    @Override
    public List<FpcsSkuOrder> getFlowerSkuByCondition(Date time, String code) {
        return this.fpcsSkuOrderMapper.getFlowerSkuByCondition(time, code);
    }

    public Boolean check(Object obj) {
        FpcsSkuOrder record = (FpcsSkuOrder)obj;
        if (EmptyUtil.isEmpty((Object)record)) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(FpcsSkuOrder record, Boolean isCreate) {
        if (isCreate.booleanValue() && EmptyUtil.isNotEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (!isCreate.booleanValue() && EmptyUtil.isEmpty((Object)record.getId())) {
            throw new PurchaseException("PC0001", "\u53c2\u6570\u5f02\u5e38");
        }
        return true;
    }

    private Boolean check(String code) {
        PcsSkuExample example = new PcsSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PcsSku> recordList = this.pcsSkuMapper.selectByExample(example);
        if (recordList.size() == 0) {
            return true;
        }
        return false;
    }

    public String generateCode(Object id) {
        return null;
    }

    @Override
    public List<PcsSkuVO> findByCodes(List<String> codes) {
        return EmptyUtil.isEmpty(codes) ? new ArrayList() : this.pcsSkuMapper.findSkuByCodes(codes);
    }

    @Override
    public List<PcsSkuInfoVO> allSkuInfo() {
        return this.pcsSkuMapper.allSkuInfo();
    }

    @Override
    public PcsSkuInfoVO findStockByCode(String skuCode) {
        return this.pcsSkuMapper.findStockByCode(skuCode);
    }

    @Override
    public FpcsSkuOrder findSkuById(long id) {
        return this.fpcsSkuOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    @Transactional
    public int saveConsumableAllot(List<FpcsConsumableAllot> consumableAllotList) {
        int i = 0;
        this.fpcsConsumableAllotMapper.deleteAllData();
        i = this.fpcsConsumableAllotMapper.insertConsumableList(consumableAllotList);
        return i;
    }

    @Override
    public List<FpcsConsumableAllotVO> getAllConsumableList(List<String> warehouseCodeList) {
        return this.fpcsConsumableAllotMapper.selectAllConsumableList(warehouseCodeList);
    }

    @Override
    public List<PcsSkuProductVO> findProductInfoBySkuCodes(List<String> skuCodes) {
        HashedMap params = new HashedMap();
        params.put("skuCodes", skuCodes);
        params.put("skuCodesStr", StringUtils.join(skuCodes, (String)","));
        return this.pcsSkuMapper.findProductInfoBySkuCodes((Map<String, Object>)params);
    }

    @Override
    public List<String> findProductCodesBySkuCodes(@Param(value="skuCodes") List<String> skuCodes) {
        return this.pcsSkuMapper.findProductCodesBySkuCodes(skuCodes);
    }

    @Override
    public List<FpcsConsumableAllotSummaryVO> findApplySummaryBySku(Integer type, String skuCode, List<String> warehouseCodeList) {
        return this.fpcsConsumableAllotMapper.selectApplySummaryBySku(type, skuCode, warehouseCodeList);
    }

    @Override
    public List<FpcsConsumableImportLog> findLastImportLogs() {
        return this.fpcsConsumableImportLogMapper.selectAll();
    }

    @Override
    public List<Integer> saveLastImportLogs(List<FpcsConsumableImportLog> importDatas) {
        this.fpcsConsumableImportLogMapper.deleteAll();
        this.fpcsConsumableImportLogMapper.batchInsert(importDatas);
        return null;
    }

    @Override
    public FpcsConsumableAllot findFpcsConsumableAllotBySkuCode(String skuCode) {
        FpcsConsumableAllotKey key = new FpcsConsumableAllotKey();
        key.setSkuCode(skuCode);
        return this.fpcsConsumableAllotMapper.selectByPrimaryKey(key);
    }
}

