/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.purchase;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.common.Pagination;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailAttachmentVO;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.SpringUtil;
import com.thebeastshop.pegasus.service.purchase.cond.PcsBaseTaxRateCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsCertificateFieldCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFinancePaymentCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerDeliveryCapacityCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerDeliveryCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerRecipePlanCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoCreditNoteCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoPlanCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoPlanCostCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoPlanLineCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseFlowerCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseFlowerSupplierCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseReturnCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuAutoApproveBgmCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCustomBckCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuFinanceAutoApproveRuleCond;
import com.thebeastshop.pegasus.service.purchase.cond.PoLogisticsBillCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcJobCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeMaterialCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeSkuCond;
import com.thebeastshop.pegasus.service.purchase.cond.PurchaseFlowerAchievementReportCond;
import com.thebeastshop.pegasus.service.purchase.cond.PurchaseFlowerPlanCond;
import com.thebeastshop.pegasus.service.purchase.cond.PurchaseFlowerReceiveOrderCond;
import com.thebeastshop.pegasus.service.purchase.cond.PurchaseFlowerSupplierReportCond;
import com.thebeastshop.pegasus.service.purchase.cond.SkuCerCond;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsOrderListForm;
import com.thebeastshop.pegasus.service.purchase.flower.model.FpcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.flower.service.FpcsActualPurchaseService;
import com.thebeastshop.pegasus.service.purchase.flower.service.FpcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualChannelItemVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualChannelVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsActualExcelVO;
import com.thebeastshop.pegasus.service.purchase.flower.vo.FpcsChannelQuantity;
import com.thebeastshop.pegasus.service.purchase.model.FpcsConsumableAllot;
import com.thebeastshop.pegasus.service.purchase.model.FpcsConsumableImportLog;
import com.thebeastshop.pegasus.service.purchase.model.FpcsSkuOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateField;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateSkuField;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTag;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTagField;
import com.thebeastshop.pegasus.service.purchase.model.PcsClPs;
import com.thebeastshop.pegasus.service.purchase.model.PcsCostAdjust;
import com.thebeastshop.pegasus.service.purchase.model.PcsCostCenter;
import com.thebeastshop.pegasus.service.purchase.model.PcsFinancePayment;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDelivery;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDeliveryDate;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDeliveryRecipe;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerMonthlyCapacityLog;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoCreditNote;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCost;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlower;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlowerAchievement;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseReturn;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseReturnSku;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuAutoApproveBgm;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificate;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificateExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCustomBck;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJob;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLine;
import com.thebeastshop.pegasus.service.purchase.model.PrdcPreJob;
import com.thebeastshop.pegasus.service.purchase.service.FpcsSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PcsBaseTaxRateService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCategoryCostCenterService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateSkuFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTagService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTplFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTplService;
import com.thebeastshop.pegasus.service.purchase.service.PcsClPsService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCostCenterService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCronService;
import com.thebeastshop.pegasus.service.purchase.service.PcsFinancePaymentService;
import com.thebeastshop.pegasus.service.purchase.service.PcsFlowerDeliveryService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLogisticsBillService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseFlowerAchievementService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseFlowerService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseFlowerSupplierService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuAutoApproveRuleService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCertificateService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCustomBckService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobLineService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcRecipeService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcRecipeSkuService;
import com.thebeastshop.pegasus.service.purchase.service.PurchaseFlowerPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PurchaseFlowerReceiveOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.FlowerRecipeMaterialVO;
import com.thebeastshop.pegasus.service.purchase.vo.FlowerSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.FpcsConsumableAllotSummaryVO;
import com.thebeastshop.pegasus.service.purchase.vo.FpcsConsumableAllotVO;
import com.thebeastshop.pegasus.service.purchase.vo.MaterailSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBaseTaxRateVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateSkuFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagEditVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagFieldValueVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldDicVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFinancePaymentVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerDeliveryRecipeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerDeliveryVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerMerchantibleVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerMonCapaLogVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerMonCapaSettingVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerRecipeSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerSkuStatisticsVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoCreditNoteVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoFieldEditableInfoVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanCostVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLogisticsBillVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoProgressTrackingDetailVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoProgressTrackingVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPreAllotVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseFlowerReceiveOrderVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseFlowerSupplierVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseFlowerVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderCostVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseOrderVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseReturnSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseReturnVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsRecipeSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuAutoApproveBgmVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCerInfoExcelVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCertificateFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCertificateVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCustomBckVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuFinanceAutoApproveRuleVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuProductVO;
import com.thebeastshop.pegasus.service.purchase.vo.PoLogisticsBillStatusTab;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobCountInfo;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcJobVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcPreJobDownloadVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcPreJobLineVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcPreJobVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeMaterialSimpleVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeMaterialVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintCerVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintSkuCerVO;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseFlowerPlanVO;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseFlowerReportVO;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseFlowerSupplierReportVO;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseSellStockReportVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.ExcelUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.importExcel.AdvancedParseExcelComponent;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;
import com.thebeastshop.pegasus.util.model.CommAudit;
import com.thebeastshop.pegasus.util.model.CommDictionary;
import com.thebeastshop.pegasus.util.model.CommEntityOpRcd;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.stock.dto.SFlowerMonthlyQueryDTO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
import com.thebeastshop.wms.vo.WhAllotRcdVO;
import com.thebeastshop.wms.vo.WhCommandVO;
import com.thebeastshop.wms.vo.WhInvOccupyVO;
import com.thebeastshop.wms.vo.WhPackageInvVO;
import com.thebeastshop.wms.vo.WhRecipeInvVO;
import com.thebeastshop.wms.vo.WhReleaseOccupationVO;
import com.thebeastshop.wms.vo.WhWmsPrdcJobTaskVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;

public class PegasusPurchaseServiceFacade {
    private static final Logger log = LoggerFactory.getLogger(PegasusPurchaseServiceFacade.class);
    private static PegasusPurchaseServiceFacade instance;
    @Autowired
    private PcsClPsService pcsClPsService;
    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;
    @Autowired
    private PcsPoLineService pcsPoLineService;
    @Autowired
    private PcsPoPlanService pcsPoPlanService;
    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;
    @Autowired
    private PrdcRecipeService prdcRecipeService;
    @Autowired
    private PrdcRecipeSkuService prdcRecipeSkuService;
    @Autowired
    private PrdcJobService prdcJobService;
    @Autowired
    private PrdcJobLineService prdcJobLineService;
    @Autowired
    private FpcsPurchaseOrderService fpcsPurchaseOrderService;
    @Autowired
    private FpcsSkuService fpcsSkuService;
    @Autowired
    private FpcsActualPurchaseService fpcsActualPurchaseService;
    @Autowired
    private PcsCategoryCostCenterService pcsCategoryCostCenterService;
    @Autowired
    private PcsCertificateFieldService pcsCertificateFieldService;
    @Autowired
    private PcsCertificateTplService pcsCertificateTplService;
    @Autowired
    private PcsCertificateTplFieldService pcsCertificateTplFieldService;
    @Autowired
    private PcsSkuCertificateService pcsSkuCertificateService;
    @Autowired
    private PcsCertificateSkuFieldService pcsCertificateSkuFieldService;
    private AdvancedParseExcelComponent advancedParseExcelComponent;
    @Autowired
    private PcsCertificateTagService pcsCertificateTagService;
    @Autowired
    private PcsFinancePaymentService pcsFinancePaymentService;
    @Autowired
    private PcsCostCenterService pcsCostCenterService;
    @Autowired
    private PcsFlowerDeliveryService pcsFlowerDeliveryService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private PcsCronService pcsCronService;
    @Autowired
    private PcsSkuCustomBckService pcsSkuCustomBckService;
    @Autowired
    private PcsSkuAutoApproveRuleService pcsSkuAutoApproveRuleService;
    @Autowired
    private PcsBaseTaxRateService pcsBaseTaxRateService;
    @Autowired
    private PcsPoLogisticsBillService pcsPoLogisticsBillService;
    @Autowired
    private PcsPurchaseFlowerService pcsPurchaseFlowerService;
    @Autowired
    private PurchaseFlowerPlanService purchaseFlowerPlanService;
    @Autowired
    private PcsPurchaseFlowerSupplierService pcsPurchaseFlowerSupplierService;
    @Autowired
    private PurchaseFlowerReceiveOrderService purchaseFlowerReceiveOrderService;
    @Autowired
    private PcsPurchaseFlowerAchievementService pcsPurchaseFlowerAchievementService;
    PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();

    private PegasusPurchaseServiceFacade() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PegasusPurchaseServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<PegasusFacadeLock> clazz = PegasusFacadeLock.class;
        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                log.info("[fasade init start] PegasusPurchaseServiceFacade");
                new ClassPathXmlApplicationContext("pegasus-service-purchase/spring.xml");
                log.info("[fasade init finish] PegasusPurchaseServiceFacade");
            }
            instance = (PegasusPurchaseServiceFacade)SpringUtil.getBean("pegasusPurchaseServiceFacade");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public PcsSkuVO fingPcsSkuByCode(String code) {
        return this.mcPcsSkuService.findByCode(code);
    }

    public static <T> T getBean(Class<T> requiredType) {
        return SpringUtil.getBean(requiredType);
    }

    public AdvancedParseExcelComponent getAdvancedParseExcelComponent() {
        return this.advancedParseExcelComponent;
    }

    public Long addPcsPoCreditNoteVO(PcsPoCreditNoteVO vo) {
        return this.pcsPurchaseOrderService.addPcsPoCreditNoteVO(vo);
    }

    public void deletePcsPoCreditNoteVO(PcsPoCreditNoteVO vo) {
        this.pcsPurchaseOrderService.deletePcsPoCreditNoteVO(vo);
    }

    public List<Long> createFlowerSkus(List<FlowerSkuVO> list) {
        ArrayList<FpcsSkuOrder> skuList = new ArrayList<FpcsSkuOrder>();
        for (FlowerSkuVO pcsSkuVO : list) {
            skuList.add(this.fpcsSkuService.bulidFromVO(pcsSkuVO));
        }
        return this.fpcsSkuService.createSkus(skuList);
    }

    public List<Long> createConsumableSkus(List<FlowerSkuVO> list) {
        ArrayList<FpcsSkuOrder> skuList = new ArrayList<FpcsSkuOrder>();
        for (FlowerSkuVO pcsSkuVO : list) {
            skuList.add(this.fpcsSkuService.bulidFromVO(pcsSkuVO));
        }
        return this.fpcsSkuService.createSkus(skuList);
    }

    public Long findPcsClPsMaxId() {
        return this.pcsClPsService.findMaxId();
    }

    public int addClPs(PcsClPs pcsClPs) {
        return this.pcsClPsService.add(pcsClPs);
    }

    public List<PcsClPs> findPcsClPsByMaxId(Long maxId) {
        return this.pcsClPsService.findByMaxId(maxId);
    }

    public boolean deletePcsClPsByMaxId(Long maxId) {
        return this.pcsClPsService.deleteByMaxId(maxId);
    }

    public Long createPurchaseOrderAndLine(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        Long id = this.pcsPurchaseOrderService.createPurchaseOrderAndLine(pcsPurchaseOrderVO);
        pcsPurchaseOrderVO.setId(id);
        return id;
    }

    public void checkPurchaseOrderBeforeEdit(PcsPurchaseOrderVO editVO) {
        this.pcsPurchaseOrderService.checkPurchaseOrderBeforeEdit(editVO);
    }

    public PcsPoFieldEditableInfoVO buildPoFieldEditableInfo(PcsPurchaseOrderVO info) {
        return this.pcsPurchaseOrderService.buildPoFieldEditableInfo(info);
    }

    public Boolean updatePurchaseOrderAndLine(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        ArrayList<PcsPoLine> pcsPoLineList = new ArrayList();
        if (CollectionUtils.isEmpty(pcsPurchaseOrderVO.getPcsPoLineVOList())) {
            pcsPoLineList = Collections.emptyList();
        } else {
            for (PcsPoLineVO pcsPoLineVO : pcsPurchaseOrderVO.getPcsPoLineVOList()) {
                PcsPoLine pcsPoLine = this.pcsPoLineService.buildFromVO(pcsPoLineVO);
                pcsPoLineList.add(pcsPoLine);
            }
        }
        return this.pcsPurchaseOrderService.updatePurchaseOrderAndLine(pcsPoLineList, pcsPurchaseOrderVO);
    }

    public Boolean updatePurchaseOrder(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        PcsPurchaseOrder pcsPurchaseOrder = new PcsPurchaseOrder();
        BeanUtils.copyProperties((Object)pcsPurchaseOrderVO, (Object)pcsPurchaseOrder);
        return this.pcsPurchaseOrderService.updatePurchaseOrder(pcsPurchaseOrder);
    }

    public Boolean updatePurchaseOrder(PcsPurchaseOrder pcsPurchaseOrder) {
        return this.pcsPurchaseOrderService.updatePurchaseOrder(pcsPurchaseOrder);
    }

    public PcsPurchaseOrderVO findPoVOById(long id) {
        return this.pcsPurchaseOrderService.findPoVOById(id);
    }

    public PcsPurchaseOrderVO findPoVOByCode(String code) {
        return this.pcsPurchaseOrderService.findPoVOByCode(code);
    }

    public PcsPurchaseOrder findPoByPoCode(String poCode) {
        return this.pcsPurchaseOrderService.findPoByCode(poCode);
    }

    public PcsPurchaseOrderVO findPurchaseOrderByCommandCode(String commandCode) {
        return this.pcsPurchaseOrderService.findPurchaseOrderByCommandCode(commandCode);
    }

    public List<PcsPoLineVO> findPoLineVOByPoId(long poId) {
        return this.pcsPoLineService.findPoLineVOByPoId(poId);
    }

    public List<PcsPoLineVO> findPoLineVOByPoIdForExcel(long poId) {
        return this.pcsPoLineService.findPoLineVOByPoIdForExcel(poId);
    }

    public List<PcsPoLineVO> findPoLineVOById(long id) {
        return this.pcsPoLineService.findPoLineVOById(id);
    }

    public List<PcsPoLineVO> findPackageNumBySku(PcsPoLineVO pcsPpLinevo) {
        return this.pcsPoLineService.findPackageNumBySku(pcsPpLinevo);
    }

    public List<PcsPoLineVO> findAutomaticTransferAllot(PcsPoPlan pcsPoPlan) {
        return this.pcsPoLineService.findAutomaticTransferAllot(pcsPoPlan);
    }

    public List<PcsPoLineVO> findPoSkuByPoId(long poId) {
        return this.pcsPoLineService.findPoSkuByPoId(poId);
    }

    public List<PcsPurchaseOrderVO> findPOVOByCond(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderService.findPOVOByCond(cond);
    }

    public PageInfo<PcsPurchaseOrderVO> pageQueryPOByCond(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderService.pageQueryPOByCond(cond);
    }

    public Map<String, Integer> countPoGroupByStatus(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderService.countPoGroupByStatus(cond);
    }

    public List<PcsPoLineVO> findFinancePoLineVOByParams(Map<String, Object> params) {
        return this.pcsPurchaseOrderService.findFinancePoLineVOByParams(params);
    }

    public Boolean closePurchaseOrder(long id) {
        return this.pcsPurchaseOrderService.closePurchaseOrder(id);
    }

    public List<String> findWarehouseCodeGroupFromPurchaseOrder() {
        return this.pcsPurchaseOrderService.findWarehouseCodeGroup();
    }

    public List<PcsPurchaseOrderVO> findPoInfoByWarehouseCodeGroup() {
        return this.pcsPurchaseOrderService.findPoInfoByWarehouseCodeGroup();
    }

    public Boolean auditPurchaseOrder(long id, Boolean isPass, Integer type) {
        return this.pcsPurchaseOrderService.auditPurchaseOrder(id, isPass, type);
    }

    public PcsPoPlanVO createPoPlanAndLine(PcsPoPlanVO pcsPoPlanVO) throws Exception {
        PcsPoPlan pcsPoPlan = this.pcsPoPlanService.buildFromVO(pcsPoPlanVO);
        ArrayList<PcsPoPlanLine> pcsPoPlanLineList = new ArrayList();
        this.excludeZeroLine(pcsPoPlanVO);
        if (CollectionUtils.isEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())) {
            pcsPoPlanLineList = Collections.emptyList();
        } else {
            for (PcsPoPlanLineVO pcsPoPlanLineVO : pcsPoPlanVO.getPcsPoPlanLineVOList()) {
                PcsPoPlanLine pcsPoPlanLine = this.pcsPoPlanLineService.buildFromVO(pcsPoPlanLineVO);
                pcsPoPlanLineList.add(pcsPoPlanLine);
            }
        }
        boolean result = this.pcsPoPlanService.createPoPlanAndLine(pcsPoPlan, pcsPoPlanLineList);
        if (result) {
            pcsPoPlanVO.setId(pcsPoPlan.getId());
            pcsPoPlanVO.setCode(pcsPoPlan.getCode());
            if (com.thebeastshop.pegasus.util.comm.EmptyUtil.isNotEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())) {
                block1: for (PcsPoPlanLineVO poPlanLineVO : pcsPoPlanVO.getPcsPoPlanLineVOList()) {
                    for (PcsPoPlanLine poPlanLine : pcsPoPlanLineList) {
                        if (!poPlanLine.getSkuCode().equals(poPlanLineVO.getSkuCode())) continue;
                        poPlanLineVO.setId(poPlanLine.getId());
                        continue block1;
                    }
                }
            }
        }
        return pcsPoPlanVO;
    }

    private void excludeZeroLine(PcsPoPlanVO pcsPoPlanVO) {
        List<PcsPoPlanLineVO> pcsPoPlanLineVOList = pcsPoPlanVO.getPcsPoPlanLineVOList();
        ArrayList<PcsPoPlanLineVO> newPcsPoPlanLineVOList = new ArrayList<PcsPoPlanLineVO>();
        for (PcsPoPlanLineVO planLineVO : pcsPoPlanLineVOList) {
            if (planLineVO.getQpb() <= 0) continue;
            newPcsPoPlanLineVOList.add(planLineVO);
        }
        pcsPoPlanVO.setPcsPoPlanLineVOList(newPcsPoPlanLineVOList);
    }

    public Boolean createPoPlanAndLineThenFinish(PcsPoPlanVO pcsPoPlanVO) throws Exception {
        PcsPoPlan pcsPoPlan = this.pcsPoPlanService.buildFromVO(pcsPoPlanVO);
        ArrayList<PcsPoPlanLine> pcsPoPlanLineList = new ArrayList();
        this.excludeZeroLine(pcsPoPlanVO);
        if (CollectionUtils.isEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())) {
            pcsPoPlanLineList = Collections.emptyList();
        } else {
            for (PcsPoPlanLineVO pcsPoPlanLineVO : pcsPoPlanVO.getPcsPoPlanLineVOList()) {
                PcsPoPlanLine pcsPoPlanLine = this.pcsPoPlanLineService.buildFromVO(pcsPoPlanLineVO);
                pcsPoPlanLineList.add(pcsPoPlanLine);
            }
        }
        return this.pcsPoPlanService.createPoPlanAndLineThenFinish(pcsPoPlan, pcsPoPlanLineList);
    }

    public List<PcsPoPlanVO> findPcsPoPlanVOByPoId(long poId) {
        List<PcsPoPlan> recordList = this.pcsPoPlanService.findPcsPoPlanByPoId(poId);
        ArrayList<PcsPoPlanVO> vos = new ArrayList<PcsPoPlanVO>(recordList.size());
        for (PcsPoPlan record : recordList) {
            PcsPoPlanVO vo = this.pcsPoPlanService.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    public List<PcsPoPlanVO> findPopVOsByCond(PcsPoPlanCond cond) {
        return this.pcsPoPlanService.findPopVOsByCond(cond);
    }

    public List<PcsPoPlanVO> findPcsPoPlanVOByPoIds(List<Long> poIds, boolean cascade) {
        return this.pcsPoPlanService.findPcsPoPlanByPoIds(poIds, cascade);
    }

    public List<PcsPoPlan> findPcsPoPlanByCond(PcsPoPlanCond cond) {
        return this.pcsPoPlanService.findPcsPoPlanByCond(cond);
    }

    public boolean updatePcsPoPlanById(long id, String date) {
        return this.pcsPoPlanService.updatePcsPoPlanById(id, date);
    }

    public boolean updatePcsPoPlanByPrimaryKey(PcsPoPlan pcsPoPlan) {
        return this.pcsPoPlanService.updatePcsPoPlanByPrimaryKey(pcsPoPlan);
    }

    public boolean updatePcsPoPlanLineByPrimaryKey(PcsPoPlanLineVO pcsPoPlanLineVO) {
        PcsPoPlanLine pcsPoPlanLine = this.pcsPoPlanLineService.buildFromVO(pcsPoPlanLineVO);
        return this.pcsPoPlanLineService.update(pcsPoPlanLine);
    }

    public boolean updatePcsPoPlanVO(PcsPoPlanVO pcsPoPlanVO) {
        boolean result = this.updatePcsPoPlanByPrimaryKey((PcsPoPlan)BeanUtil.buildFrom((Object)pcsPoPlanVO, PcsPoPlan.class));
        if (result && CollectionUtils.isNotEmpty(pcsPoPlanVO.getPcsPoPlanLineVOList())) {
            pcsPoPlanVO.getPcsPoPlanLineVOList().forEach(popLine -> this.updatePcsPoPlanLineByPrimaryKey((PcsPoPlanLineVO)popLine));
        }
        return true;
    }

    public boolean updatePcsPoPlanVOs(List<PcsPoPlanVO> pcsPoPlanVOs) {
        for (PcsPoPlanVO poPlanVO : pcsPoPlanVOs) {
            if (com.thebeastshop.pegasus.util.comm.EmptyUtil.isNotEmpty((String)poPlanVO.getBillOfLading())) {
                PcsPoPlan poPlan = new PcsPoPlan();
                poPlan.setId(poPlanVO.getId());
                poPlan.setBillOfLading(poPlanVO.getBillOfLading());
                PcsPoPlan oldPop = this.findPcsPoPlanById(poPlanVO.getId());
                if (!poPlanVO.getBillOfLading().equals(oldPop.getBillOfLading())) {
                    poPlanVO.setOldBillOfLading(oldPop.getBillOfLading());
                    this.updatePcsPoPlanByPrimaryKey(poPlan);
                } else {
                    poPlanVO.setBillOfLading(null);
                }
                this.batchCreatePoPlanFee(poPlanVO.getPcsPoPlanCosts());
                continue;
            }
            this.batchCreatePoPlanFee(poPlanVO.getPcsPoPlanCosts());
        }
        return true;
    }

    public boolean updatePcsPoPlanLineById(long id, Integer sign) {
        return this.pcsPoPlanService.updatePcsPoPlanLineById(id, sign);
    }

    public boolean updatePrdcJobById(long id, Integer sign) {
        return this.pcsPoPlanService.updatePrdcJobById(id, sign);
    }

    public Boolean deletePcsPoLine(long poId, long pcsPoLineId) {
        return this.pcsPurchaseOrderService.deletePcsPoLine(poId, pcsPoLineId);
    }

    public Boolean batchUpdatePcsPoLine(PcsPurchaseOrderVO pcsPoLineVOs, Long operatorId) {
        return this.pcsPurchaseOrderService.batchUpdatePcsPoLine(pcsPoLineVOs, operatorId);
    }

    public Boolean update(PcsPoPlanLine pcsPoPlanLine) {
        return this.pcsPoPlanLineService.update(pcsPoPlanLine);
    }

    public List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanId(long poPlanId) {
        return this.pcsPoPlanLineService.findPoPlanLineVOByPoPlanId(poPlanId);
    }

    public Pagination<PcsPoPlanLineVO> pagePcsPoPlanLineVOByCond(PcsPoPlanLineCond cond) {
        return this.pcsPoPlanLineService.pagePcsPoPlanLineVOByCond(cond);
    }

    public List<PcsPoPlanLineVO> listPcsPoPlanLineVOByCond(PcsPoPlanLineCond cond) {
        return this.pcsPoPlanLineService.listPcsPoPlanLineVOByCond(cond);
    }

    public List<PcsPoPlanLineVO> findPoPlanLineVO() {
        return this.pcsPoPlanLineService.findPoPlanLineVO(true);
    }

    public List<PrdcJobVO> findPrdcJobVO() {
        return this.prdcJobService.findPrdcJobVO(true);
    }

    public Long createRecipe(PrdcRecipeVO vo) {
        return this.prdcRecipeService.create(vo);
    }

    public Boolean updateRecipe(PrdcRecipeVO vo) {
        return this.prdcRecipeService.update(vo);
    }

    public Boolean updateRecipeHour(PrdcRecipeVO vo) {
        return this.prdcRecipeService.updateRecipeHour(vo);
    }

    public PrdcRecipeVO findRecipeVOById(Long id) {
        return this.prdcRecipeService.findRecipeVOById(id);
    }

    public List<PrdcRecipeVO> findRecipeVOByCond(PrdcRecipeCond cond, Boolean cascade) {
        return this.prdcRecipeService.findRecipeVOByCond(cond, cascade);
    }

    public List<PrdcRecipeVO> findRecipeVOByCond(String skuCode, Boolean cascade) {
        return this.prdcRecipeService.findRecipeVOBySkuCode(skuCode, cascade);
    }

    public List<PrdcRecipeMaterialVO> findRecipeMaterialVOBySkuCode(String skuCode, Boolean cascade) {
        return this.prdcRecipeService.findRecipeMaterialVOBySkuCode(skuCode, cascade);
    }

    public List<PrdcRecipeMaterialVO> findRecipeMaterialVOByCond(PrdcRecipeMaterialCond cond, Boolean cascade) {
        return this.prdcRecipeService.findRecipeMaterialVOByCond(cond, cascade);
    }

    public Boolean deleteRecipeMaterial(Long recipeId, Long recipeMaterialId) {
        return this.prdcRecipeService.deleteRecipeMaterial(recipeId, recipeMaterialId);
    }

    public Long createRecipeSku(PrdcRecipeSkuVO vo) {
        return this.prdcRecipeSkuService.create(vo);
    }

    public Boolean updateRecipeSku(PrdcRecipeSkuVO vo) {
        return this.prdcRecipeSkuService.update(vo);
    }

    public PrdcRecipeSkuVO findRecipeSkuVOById(Long id) {
        return this.prdcRecipeSkuService.findRecipeSkuVOById(id);
    }

    public List<PrdcRecipeSkuVO> findRecipeSkuVOByCond(PrdcRecipeSkuCond cond) {
        return this.prdcRecipeSkuService.findRecipeSkuVOByCond(cond);
    }

    public List<PrdcRecipeSkuVO> findRecipeSkuVOByCond(String skuCode, Long recipeId) {
        return this.prdcRecipeSkuService.findRecipeSkuVOByCond(skuCode, recipeId);
    }

    public Boolean deleteRecipeSku(String skuCode, Long recipeId) {
        return this.prdcRecipeSkuService.deleteRecipeSku(skuCode, recipeId);
    }

    public Boolean deleteRecipeSku(Long id) {
        return this.prdcRecipeSkuService.deleteRecipeSku(id);
    }

    public Long createJob(PrdcJobVO vo) {
        return this.prdcJobService.create(vo);
    }

    public Long createPrdcPreJob(PrdcPreJob vo) {
        return this.prdcJobService.createPrdcPreJob(vo);
    }

    public Integer updatePrdcPreJobByKey(PrdcPreJob prdcPreJob) {
        return this.prdcJobService.updatePrdcPreJobByKey(prdcPreJob);
    }

    public List<Long> batchCreate(List<PrdcJobVO> list) {
        return this.prdcJobService.batchCreate(list);
    }

    public List<Long> batchCreateForCustomization(List<PrdcJobVO> list, String allotCode) {
        if (com.thebeastshop.pegasus.util.comm.EmptyUtil.isNotEmpty(list)) {
            ArrayList<String> skuCodes = new ArrayList<String>();
            for (PrdcJobVO jobVO : list) {
                if (!com.thebeastshop.pegasus.util.comm.EmptyUtil.isEmpty(jobVO.getPrdcJobLineVOList())) continue;
                skuCodes.add(jobVO.getSkuCode());
            }
            Map<String, PrdcRecipeVO> recipeVOMap = this.getRecipeMap(skuCodes);
            for (PrdcJobVO jobVO : list) {
                if (!com.thebeastshop.pegasus.util.comm.EmptyUtil.isEmpty(jobVO.getPrdcJobLineVOList())) continue;
                PrdcRecipeVO recipeVO = recipeVOMap.get(jobVO.getSkuCode());
                if (NullUtil.isNull((Object)recipeVO)) {
                    throw new PurchaseException("PC0002", String.format("[%s]\u914d\u65b9\u4e0d\u5b58\u5728", jobVO.getSkuCode()));
                }
                this.prdcJobService.bulidJobLine(jobVO, recipeVO);
            }
        }
        return this.prdcJobService.batchCreate(list, allotCode);
    }

    public List<Long> batchCreateForCustomizationForKafka(List<PrdcJobVO> list) throws Exception {
        if (com.thebeastshop.pegasus.util.comm.EmptyUtil.isNotEmpty(list)) {
            ArrayList<String> skuCodes = new ArrayList<String>();
            for (PrdcJobVO jobVO : list) {
                if (!com.thebeastshop.pegasus.util.comm.EmptyUtil.isEmpty(jobVO.getPrdcJobLineVOList())) continue;
                skuCodes.add(jobVO.getSkuCode());
            }
            Map<String, PrdcRecipeVO> recipeVOMap = this.getRecipeMap(skuCodes);
            for (PrdcJobVO jobVO : list) {
                if (!com.thebeastshop.pegasus.util.comm.EmptyUtil.isEmpty(jobVO.getPrdcJobLineVOList())) continue;
                PrdcRecipeVO recipeVO = recipeVOMap.get(jobVO.getSkuCode());
                if (NullUtil.isNull((Object)recipeVO)) {
                    throw new PurchaseException("PC0008", String.format("[%s]\u914d\u65b9\u4e0d\u5b58\u5728", jobVO.getSkuCode()));
                }
                this.prdcJobService.bulidJobLine(jobVO, recipeVO);
            }
        }
        return this.prdcJobService.batchCreateAndFinishForKafka(list);
    }

    public boolean createAllotOrPrdcJob(List<WhPackageInvVO> packageInvList) throws Exception {
        ArrayList<PrdcJobVO> jobList = new ArrayList<PrdcJobVO>();
        ArrayList<WhAllotRcdVO> allotList = new ArrayList<WhAllotRcdVO>();
        this.prdcJobService.buildAllotOrPrdcJob(packageInvList, jobList, allotList);
        try {
            return this.prdcJobService.batchCreatePrdcJobOrAllot(jobList, allotList);
        }
        catch (Exception e) {
            RuntimeException re;
            if (e instanceof RuntimeException && com.thebeastshop.pegasus.util.comm.EmptyUtil.isNotEmpty((String)(re = (RuntimeException)e).getMessage()) && re.getMessage().contains("\u5e93\u5b58\u4e0d\u8db3")) {
                this.prdcJobService.sendCusShortMailEmail(packageInvList, re.getMessage());
            }
            throw e;
        }
    }

    public Map<String, PrdcRecipeVO> getRecipeMap(List<String> skuCodes) {
        HashMap<String, PrdcRecipeVO> recipeVOMap = new HashMap<String, PrdcRecipeVO>();
        if (com.thebeastshop.pegasus.util.comm.EmptyUtil.isNotEmpty(skuCodes)) {
            PrdcRecipeCond cond = new PrdcRecipeCond();
            cond.setSkuCodes(skuCodes);
            List<PrdcRecipeVO> recipeVOList = this.prdcRecipeService.findRecipeVOByCond(cond, true);
            if (com.thebeastshop.pegasus.util.comm.EmptyUtil.isNotEmpty(recipeVOList)) {
                for (PrdcRecipeVO recipeVO : recipeVOList) {
                    recipeVOMap.put(recipeVO.getSkuCode(), recipeVO);
                }
            }
        }
        return recipeVOMap;
    }

    public Boolean returnModifyJob(PrdcJobVO vo) {
        return this.prdcJobService.returnModify(vo);
    }

    public PrdcJobVO findJobVOById(Long id) {
        return this.prdcJobService.findJobVOById(id);
    }

    public PrdcJobVO findJobVOByCode(String code) {
        return this.prdcJobService.findJobVOByCode(code);
    }

    public Map<String, WhRecipeInvVO> caculateRecipeAmountForAssemble(List<String> skuCodes, String warehouseCode) {
        return this.prdcJobService.caculateRecipeAmountForAssemble(skuCodes, warehouseCode);
    }

    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond, Boolean cascade) {
        return this.prdcJobService.findJobVOByCond(cond, cascade);
    }

    public Pagination<PrdcJobVO> findJobVOByCondPage(PrdcJobCond cond) {
        return this.prdcJobService.findJobVOByCondPage(cond);
    }

    public PrdcJobCountInfo countPrdcJobByCond(PrdcJobCond cond) {
        return this.prdcJobService.countPrdcJobByCond(cond);
    }

    public List<PrdcPreJobVO> findPreJobListByCond(PrdcJobCond cond) {
        return this.prdcJobService.findPreJobListByCond(cond);
    }

    public List<PrdcPreJobLineVO> findPreJobListListByPreJobId(Long preJobId) {
        return this.prdcJobService.findPreJobListListByPreJobId(preJobId);
    }

    public List<PrdcPreJobDownloadVO> findPreJobDownListByCond(PrdcJobCond cond) {
        return this.prdcJobService.findPreJobDownListByCond(cond);
    }

    public Long processPrdcPreJob(PrdcPreJobVO vo) {
        return this.prdcJobService.processPrdcPreJob(vo);
    }

    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond) {
        return this.prdcJobService.findJobVOByCond(cond);
    }

    public Boolean deleteJobLine(Long jobId, Long jobLineId) {
        return this.prdcJobService.deleteJobLine(jobId, jobLineId);
    }

    public Boolean cancelJobForStatusReturnModify(Long jobId) {
        return this.prdcJobService.cancelJobForStatusReturnModify(jobId);
    }

    public List<PrdcJobLine> getPrdcJobLine(Long id) {
        return this.prdcJobLineService.getPrdcJobLineByJobId(id);
    }

    public Boolean startProduction(PrdcJobVO jobVO) {
        return this.prdcJobService.startProduction(jobVO);
    }

    public Boolean updateJobVO(PrdcJobVO jobVO) {
        return this.prdcJobService.updateJobVO(jobVO);
    }

    public Boolean updatePjJobVO(PrdcJobVO jobVO) {
        return this.prdcJobService.updatePjJobVO(jobVO);
    }

    public boolean updateProdJobById(long id, Integer sign) {
        return this.prdcJobService.updateProdJobById(id, sign);
    }

    public boolean updateJobConfirmToWmsReturnModify(String jobCode) {
        return this.prdcJobService.updateJobConfirmToWmsReturnModify(jobCode);
    }

    public Boolean releaseJobLineOccupyAndUpdate(PrdcJobVO jobVO, List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        return this.prdcJobService.releaseJobLineOccupyAndUpdate(jobVO, whReleaseOccupationVOList);
    }

    public Boolean createCommandsAfterReleaseThenFinishAndUpdate(PrdcJobVO jobVO, List<WhCommandVO> whCommands, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        return this.prdcJobService.createCommandsAfterReleaseThenFinishAndUpdate(jobVO, whCommands, whReleaseOccupationVOList);
    }

    public String getWarehouseName(String warehouseCode) {
        return this.prdcJobService.getWarehouseName(warehouseCode);
    }

    public List<Map<String, String>> getWarehouseList(List<String> warehouseCodeList) {
        return this.prdcJobService.getWarehouseList(warehouseCodeList);
    }

    public List<WhInvOccupyVO> buildWhOccupy(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, String warehouseCode, Integer occupyType) {
        return this.prdcJobService.buildWhOccupy(prdcJob, prdcJobLineList, warehouseCode, occupyType);
    }

    public List<WhReleaseOccupationVO> buildWhRelease(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, Integer occupyType) {
        return this.prdcJobService.buildWhRelease(prdcJob, prdcJobLineList, occupyType);
    }

    public List<WhCommandVO> buildPrdcCommands(PrdcJobVO jobVO) {
        return this.prdcJobService.buildPrdcCommands(jobVO);
    }

    public byte[] exportPoPlanStatusWaitingIn() {
        return this.pcsPoPlanService.exportPoPlanStatusWaitingIn();
    }

    public byte[] exportPoInfomation() {
        return this.pcsPoPlanService.exportPoInfomation();
    }

    public List<FpcsPurchaseOrder> selectFpcsPurchaseOrder(FpcsPurchaseOrder example) {
        return this.fpcsPurchaseOrderService.select(example);
    }

    public List<FpcsSkuOrder> getAllFlowerSkuInfo() throws Exception {
        return this.fpcsSkuService.getAllFlowerSkuInfo();
    }

    public List<FpcsSkuOrder> getFlowerSkuInfo(Map<String, Object> params) {
        return this.fpcsSkuService.getFlowerSkuInfo(params);
    }

    public List<FpcsSkuOrder> getFlowerSkuByCondition(Date time, String code) throws Exception {
        return this.fpcsSkuService.getFlowerSkuByCondition(time, code);
    }

    public int sumitOrder(FpcsOrderListForm example) {
        return this.fpcsPurchaseOrderService.sumitOrder(example);
    }

    public List<FpcsPurchaseOrder> findPurchaseOrderList(FpcsPurchaseOrder cond) {
        return this.fpcsPurchaseOrderService.getPurchaseOrderList(cond);
    }

    public List<FpcsPurchaseOrder> getCacheSkuOrderList(List<FpcsPurchaseOrder> fpcsPurchaseOrderList) {
        return this.fpcsPurchaseOrderService.getCacheSkuOrderList(fpcsPurchaseOrderList);
    }

    public Map<String, Object> detailPurchaseOrder(long id) {
        return this.fpcsPurchaseOrderService.getDetailPurchaseOrder(id);
    }

    public void acceptOrder(FpcsPurchaseOrder cond) {
        this.fpcsPurchaseOrderService.acceptOrder(cond);
    }

    public Map<String, List<List<String>>> exportPurchaseOrder(FpcsPurchaseOrder example) {
        return this.fpcsPurchaseOrderService.exportPurchaseOrder(example);
    }

    public List<FpcsActualExcelVO> queryActualPurchaseList(Map<String, Object> params) {
        return this.fpcsActualPurchaseService.queryActualPurchaseList(params);
    }

    public List<FpcsChannelQuantity> queryActualPruchaseChannelList(Map<String, Object> params) {
        return this.fpcsActualPurchaseService.queryActualPruchaseChannelList(params);
    }

    public Long addActualPurchaseLog(FpcsActualExcelVO actualExcelVO) {
        Long ret = this.fpcsActualPurchaseService.addActualPurchaseLog(actualExcelVO);
        if (ret > 0L) {
            List<FpcsChannelQuantity> channelQuantityList = actualExcelVO.getChannelQuantitiyList();
            int len = channelQuantityList.size();
            for (int i = 0; i < len; ++i) {
                FpcsChannelQuantity channelQuantity = channelQuantityList.get(i);
                if (channelQuantity.getQuantity() == null || channelQuantity.getQuantity() == 0 || channelQuantity.getSkuCode() == null) continue;
                channelQuantity.setActualPurchaseId(actualExcelVO.getId());
                this.fpcsActualPurchaseService.addActualPurhcaseChannel(channelQuantity);
            }
        }
        return ret;
    }

    public List<FpcsActualChannelVO> queryActualChannelList(Map<String, Object> params) {
        return this.fpcsActualPurchaseService.queryActualChannelList(params);
    }

    public List<FpcsActualChannelItemVO> queryActualChannelItemList(Map<String, Object> params) {
        return this.fpcsActualPurchaseService.queryActualChannelItemList(params);
    }

    public int saveConsumableAllot(List<PcsSkuVO> skuList, List<MaterailSkuVO> codeCategory) {
        int i = 0;
        if (skuList != null) {
            ArrayList<FpcsConsumableAllot> consumableAllotList = new ArrayList<FpcsConsumableAllot>();
            for (PcsSkuVO pcsSkuVO : skuList) {
                FpcsConsumableAllot fpcsConsumableAllot = new FpcsConsumableAllot();
                fpcsConsumableAllot.setCreatTime(new Date());
                fpcsConsumableAllot.setSkuCode(pcsSkuVO.getCode());
                fpcsConsumableAllot.setSkuName(pcsSkuVO.getName());
                fpcsConsumableAllot.setMaterial(pcsSkuVO.getMaterial());
                fpcsConsumableAllot.setSpecification(pcsSkuVO.getSpecification());
                fpcsConsumableAllot.setSize(pcsSkuVO.getSize());
                fpcsConsumableAllot.setMaxApplyNumber(pcsSkuVO.getStock());
                fpcsConsumableAllot.setApplyNumber(0);
                if (!CollectionUtils.isEmpty(codeCategory)) {
                    for (MaterailSkuVO materailSkuVO : codeCategory) {
                        if (!pcsSkuVO.getCode().endsWith(materailSkuVO.getSkuCode())) continue;
                        fpcsConsumableAllot.setCategory(materailSkuVO.getCategory());
                        fpcsConsumableAllot.setCanApply(materailSkuVO.getCanApply());
                        fpcsConsumableAllot.setWhetherQuantityControl(materailSkuVO.getWhetherQuantityControl());
                        fpcsConsumableAllot.setMinApplyNumber(materailSkuVO.getMinApplyNumber());
                    }
                }
                consumableAllotList.add(fpcsConsumableAllot);
            }
            i = this.fpcsSkuService.saveConsumableAllot(consumableAllotList);
        }
        return i;
    }

    public List<FpcsConsumableAllotVO> getAllConsumableList(List<String> warehouseCodeList) {
        return this.fpcsSkuService.getAllConsumableList(warehouseCodeList);
    }

    public boolean updatePoPlan(PcsPoPlan po) {
        return this.pcsPoPlanService.updatePoPlan(po);
    }

    public boolean updatePoPlanLine(PcsPoPlanLine line) {
        return this.pcsPoPlanService.updatePoPlanLine(line);
    }

    public Integer getJobLineRealConsumeAmount(Long id, String skuCode) {
        return this.prdcJobLineService.getJobLineRealConsumeAmount(id, skuCode);
    }

    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo) {
        return this.prdcJobService.getPrdcJobMaxTask(vo);
    }

    public boolean updatePrdcJobWhenTaskFinish(WhWmsPrdcJobTaskVO vo) {
        return this.prdcJobService.updatePrdcJobWhenTaskFinish(vo);
    }

    public void updatePrdcJobWhenTaskFinish() {
        CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("prdcJobFinishCheck");
        if (config == null) {
            return;
        }
        String value = config.getConfigValue();
        if (!StringUtils.isEmpty((Object)value) && "1".equals(value)) {
            this.prdcJobService.updatePrdcJobWhenTaskFinish(null);
        }
    }

    public List<PcsPoPlanLine> findPoPlanLineByPoPlanId(Long poPlandId) {
        return this.pcsPoPlanLineService.findPoPlanLineByPoPlanId(poPlandId);
    }

    public List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanIds(List<Long> poPlandIds) {
        return this.pcsPoPlanLineService.findPoPlanLineVOByPoPlanIds(poPlandIds);
    }

    public boolean isAllPoPlanFinished(Long poId) {
        return this.pcsPoPlanService.isAllPoPlanFinished(poId);
    }

    public boolean isAllReceivePo(Long poId) {
        return this.pcsPoPlanService.isAllReceivePo(poId);
    }

    public PcsPoPlan findPcsPoPlanByKey(Long id) {
        return this.pcsPoPlanService.findPoPlanById(id);
    }

    public PcsPoPlan findPcsPoPlanById(Long id) {
        return this.pcsPoPlanService.findPoPlanById(id);
    }

    public boolean updatePcsPurchaseOrderById(PcsPurchaseOrder pcsPurchaseOrder) {
        return this.pcsPurchaseOrderService.update(pcsPurchaseOrder);
    }

    public PcsPurchaseOrder findPcsPurchaseOrderById(Long id) {
        PcsPurchaseOrder pcsPurchaseOrder = this.pcsPurchaseOrderService.findPoById(id);
        return pcsPurchaseOrder;
    }

    public List<PcsPoCreditNoteVO> listPcsPoCreditNoteVOByCond(PcsPoCreditNoteCond cond) {
        List<PcsPoCreditNoteVO> creditNoteVOs = this.pcsPurchaseOrderService.listPcsPoCreditNoteVOByCond(cond);
        if (cond.isFetchAttachment() && CollectionUtils.isNotEmpty(creditNoteVOs)) {
            List refCodes = creditNoteVOs.stream().map(vo -> vo.getId().toString()).collect(Collectors.toList());
            CommFileRef commFileRefCond = new CommFileRef();
            commFileRefCond.setReferenceCodes(refCodes);
            commFileRefCond.setRefType(CommFileRef.CONTRACT_TYPE_CREDIT_NOTE);
            List<CommFileRef> commFileRefs = this.listCommFileRefs(commFileRefCond);
            this.buildAttachmentsCreditNote(creditNoteVOs, commFileRefs);
        }
        return creditNoteVOs;
    }

    public List<CommFileRef> listCommFileRefs(CommFileRef cond) {
        return this.pegasusUtilFacade.findCommFileRefByCond(cond);
    }

    private void buildAttachmentsCreditNote(List<PcsPoCreditNoteVO> creditNoteVOs, List<CommFileRef> commFileRefs) {
        if (CollectionUtils.isNotEmpty(creditNoteVOs) && CollectionUtils.isNotEmpty(commFileRefs)) {
            Map<String, List<CommFileRef>> map = commFileRefs.stream().collect(Collectors.groupingBy(CommFileRef::getReferenceCode));
            creditNoteVOs.forEach(cn -> {
                if (map.get(cn.getId().toString()) != null) {
                    cn.setAttachmentList((List)map.get(cn.getId().toString()));
                }
            });
        }
    }

    public List<PcsPoCreditNote> listPcsPoCreditNoteByCond(PcsPoCreditNoteCond cond) {
        return this.pcsPurchaseOrderService.listPcsPoCreditNoteByCond(cond);
    }

    public List<PcsPoCreditNoteVO> listSumPoCreditNoteVOByCond(PcsPoCreditNoteCond cond) {
        return this.pcsPurchaseOrderService.listSumPoCreditNoteVOByCond(cond);
    }

    public List<PcsPoCreditNoteVO> listSumPoCreditNoteVOByPoCode(String poCode) {
        PcsPoCreditNoteCond cond = new PcsPoCreditNoteCond();
        cond.setPoCode(poCode);
        return this.listSumPoCreditNoteVOByCond(cond);
    }

    public Boolean closePoPlanByPlanId(Long poPlandId) {
        return this.pcsPoPlanService.closePoPlanByPlanId(poPlandId);
    }

    public PcsPoPlan findPcsPoPlanByCode(String code) {
        return this.pcsPoPlanService.findPoPlanByCode(code);
    }

    public void processReceicePlan(String poPlanCode, Map<String, Integer> liangpinMap, Map<String, Integer> canciMap) {
        this.pcsPurchaseOrderService.processReceicePlan(poPlanCode, liangpinMap, canciMap);
    }

    public boolean createPcsCertificateField(PcsCertificateField field) {
        return this.pcsCertificateFieldService.create(field);
    }

    public boolean updatePcsCertificateField(PcsCertificateField field) {
        return this.pcsCertificateFieldService.update(field);
    }

    public boolean deletePcsCertificateFieldById(int id) {
        return this.pcsCertificateFieldService.deleteById(id);
    }

    public List<PcsCertificateFieldVO> findPcsCertificateField(PcsCertificateFieldCond cond) {
        return this.pcsCertificateFieldService.findPcsCertificateField(cond);
    }

    public List<PcsCertificateFieldVO> findPcsCertificateField(PcsCertificateFieldCond cond, boolean cascade) {
        return this.pcsCertificateFieldService.findPcsCertificateField(cond, cascade);
    }

    public PcsCertificateFieldVO findPcsCertificateFieldById(int id) {
        return this.pcsCertificateFieldService.findPcsCertificateFieldById(id);
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuField() {
        return this.pcsCertificateSkuFieldService.findAll();
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuFieldSku() {
        return this.pcsCertificateSkuFieldService.findAllSkuField();
    }

    public List<PcsCertificateSkuField> findAllPcsCertificateSkuFieldSys() {
        return this.pcsCertificateSkuFieldService.findAllSysField();
    }

    public String getFieldValueBySkuCode(PcsCertificateSkuFieldVO field, String skuCode) {
        return this.pcsCertificateSkuFieldService.getFieldValueBySkuCode(field, skuCode);
    }

    public boolean addPcsCertificateTag(PcsCertificateTagVO vo) {
        return this.pcsCertificateTagService.addPcsCertificateTag(vo);
    }

    public boolean addPcsCertificateTag(List<PcsCertificateTagVO> vos) {
        return this.pcsCertificateTagService.addPcsCertificateTag(vos);
    }

    public List<PcsCertificateTplVO> findAllCerTpl() {
        return this.pcsCertificateTplService.findAll();
    }

    public PcsCertificateTplVO findCerTplById(Long cerTplId, boolean cascade) {
        return this.pcsCertificateTplService.findById(cerTplId, cascade);
    }

    public PcsCertificateTplVO findCerTplVOByCond(PcsCertificateTplVO tplVO) {
        return this.pcsCertificateTplService.findCerTplVOsByCond(tplVO);
    }

    public List<PcsCertificateTplVO> listCerTplVOsByCond(PcsCertificateTplVO tplVO) {
        return this.pcsCertificateTplService.listCerTplVOsByCond(tplVO);
    }

    public PcsCertificateTplVO findCerTplByCategoryId(Long categoryId, boolean cascade) {
        return this.pcsCertificateTplService.findByCategoryId(categoryId, cascade);
    }

    public PcsCertificateTplVO findCommonUseTpl(boolean cascade) {
        return this.pcsCertificateTplService.findCommonUseTpl(cascade);
    }

    public List<Long> findUsedCategoryIds() {
        return this.pcsCertificateTplService.findUsedCategoryIds();
    }

    public void updateCerTpl(PcsCertificateTplVO cerTplVO) {
        this.pcsCertificateTplService.update(cerTplVO);
    }

    public void addCerTpl(PcsCertificateTplVO cerTplVO) {
        this.pcsCertificateTplService.save(cerTplVO);
    }

    public void copyCerTpl(PcsCertificateTplVO cerTplVO) {
        this.pcsCertificateTplService.copyCerTpl(cerTplVO);
    }

    public void fullCerTplDefaultValue(PcsCertificateTplVO cerTplVO, String skuCode) {
        this.pcsCertificateTplService.fullCerTplDefaultValue(cerTplVO, skuCode);
    }

    public PcsCertificateTplFieldVO findTplFieldVO(Long tplId, Long tplFieldId) {
        return this.pcsCertificateTplFieldService.findTplFieldVO(tplId, tplFieldId);
    }

    public void saveOrUpdateTplFieldVO(PcsCertificateTplFieldVO tplFieldVO) {
        this.pcsCertificateTplFieldService.saveOrUpdate(tplFieldVO);
    }

    public void deleteTplFieldVOById(Long tplFieldId) {
        this.pcsCertificateTplFieldService.deleteByTplFieldId(tplFieldId);
    }

    public List<PcsCertificateTplFieldDicVO> findAllCerTplFieldDic() {
        return this.pcsCertificateTplFieldService.findAllCerTplFieldDic();
    }

    public PcsCertificateTplFieldDicVO findTplFieldDicById(Long tplFieldDicId) {
        return this.pcsCertificateTplFieldService.findTplFieldDicById(tplFieldDicId);
    }

    public List<PcsSkuCertificateVO> findSkuCerByCond(SkuCerCond cond) {
        return this.pcsSkuCertificateService.findSkuCerByCond(cond);
    }

    public List<PcsSkuCertificateVO> findRecipeCerVOByCond(SkuCerCond cond) {
        return this.pcsSkuCertificateService.findRecipeCerVOByCond(cond);
    }

    public List<PcsSkuCerInfoExcelVO> findSkuCerExportInfoByCond(SkuCerCond cond) {
        return this.pcsSkuCertificateService.findSkuCerExportInfoByCond(cond);
    }

    public PcsSkuCertificateVO findCerBySkuCode(String skuCode) {
        return this.pcsSkuCertificateService.findBySkuCode(skuCode);
    }

    public PcsSkuCertificateVO findCerBySkuCode(String skuCode, boolean cascade) {
        return this.pcsSkuCertificateService.findBySkuCode(skuCode, cascade);
    }

    public List<PcsSkuCertificateVO> findCerBySkuCodes(List<String> skuCodeList, boolean cascade) {
        return this.pcsSkuCertificateService.findBySkuCodes(skuCodeList, cascade);
    }

    public List<PrintSkuCerVO> getPrintCerBySkuCodeBarCode(PrintCerVO cond) {
        return this.pcsSkuCertificateService.getPrintCerBySkuCodeBarCode(cond);
    }

    public void saveOrUpdateCer(PcsSkuCertificateVO cerVO) {
        this.pcsSkuCertificateService.saveOrUpdate(cerVO);
    }

    public boolean saveOrUpdateSkuCer(PcsSkuCertificateVO cerVO) {
        return this.pcsSkuCertificateService.saveOrUpdateSkuCer(cerVO);
    }

    public void saveOrUpdateCer(List<PcsSkuCertificateVO> cerList) {
        this.pcsSkuCertificateService.saveOrUpdate(cerList);
    }

    public void saveOrUpdateCerStatus(PcsSkuCertificateVO cerVO) {
        this.pcsSkuCertificateService.saveOrUpdateStatus(cerVO);
    }

    public boolean saveSkuCerMpCode(String skuCode, String mpCodeUrl) {
        return this.pcsSkuCertificateService.saveSkuCerMpCode(skuCode, mpCodeUrl);
    }

    public boolean batchSaveSkuCerMpCode(Map<String, String> skuCode_mpCodeUrl) {
        return this.pcsSkuCertificateService.batchSaveSkuCerMpCode(skuCode_mpCodeUrl);
    }

    public String findSkuCerMpCode(String skuCode) {
        return this.pcsSkuCertificateService.findSkuCerMpCode(skuCode);
    }

    public Map<String, String> findSkuCerMpCodeMap(List<String> skuCodes) {
        return this.pcsSkuCertificateService.findSkuCerMpCodeMap(skuCodes);
    }

    public List<String> findSkuCerWithSalesPriceField(List<String> skuCodes) {
        return this.pcsSkuCertificateService.findSkuCerWithSalesPriceField(skuCodes);
    }

    public List<String> findSkuSalesPriceChangePreDay() {
        return this.pcsSkuCertificateService.findSkuSalesPriceChangePreDay();
    }

    public Integer insertOrUpdateByExampleSelective(PcsSkuCertificate record, PcsSkuCertificateExample example) {
        return this.pcsSkuCertificateService.insertOrUpdateByExampleSelective(record, example);
    }

    public List<WhReleaseOccupationVO> buildWhRelease(List<PrdcJobLineVO> prdcJobLineVOList, Integer occupyType) {
        return this.prdcJobService.buildWhRelease(prdcJobLineVOList, occupyType);
    }

    public List<WhInvOccupyVO> buildWhOccupy(List<PrdcJobLineVO> prdcJobLineVOList, String warehouseCode, Integer occupyType) {
        return this.prdcJobService.buildWhOccupy(prdcJobLineVOList, warehouseCode, occupyType);
    }

    public Boolean checkOccupyAndUpdate(PrdcJobVO jobVO, List<WhInvOccupyVO> whInvOccupyList) {
        return this.prdcJobService.checkOccupyAndUpdate(jobVO, whInvOccupyList);
    }

    public PcsCertificateTagEditVO getTagAndSkuBySkuCode(String skuCode) {
        return this.pcsCertificateTagService.getTagAndSkuBySkuCode(skuCode);
    }

    public List<PcsCertificateTagFieldValueVO> getTagFieldsSkuBySkuCode(String skuCode) {
        return this.pcsCertificateTagService.getTagFieldsSkuBySkuCode(skuCode);
    }

    public int saveCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag) {
        return this.pcsCertificateTagService.saveCertificateTagBySkuCode(pcsCertificateTag);
    }

    public void updateCertificateTagBySkuCode(PcsCertificateTag pcsCertificateTag) {
        this.pcsCertificateTagService.updateCertificateTagBySkuCode(pcsCertificateTag);
    }

    public List<PcsCertificateTagVO> getCertificateTagBySkuCodes(List<String> skuCodes) {
        return this.pcsCertificateTagService.getCertificateTagBySkuCodes(skuCodes);
    }

    public List<PcsCertificateTagVO> getTagBySkuCodeBarCode(PrintCerVO cond) {
        return this.pcsCertificateTagService.getTagBySkuCodeBarCode(cond);
    }

    public void saveCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField) {
        this.pcsCertificateTagService.saveCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    public void updateCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField) {
        this.pcsCertificateTagService.updateCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    public void deleteCertificateTagFieldBySkuCode(PcsCertificateTagField pcsCertificateTagField) {
        this.pcsCertificateTagService.deleteCertificateTagFieldBySkuCode(pcsCertificateTagField);
    }

    public List<PcsCertificateFieldVO> getTagFieldsSkuByIds(List<Integer> ids) {
        return this.pcsCertificateTagService.getTagFieldsSkuByIds(ids);
    }

    public PcsCertificateTagVO searchTagBySkuCode(PcsCertificateTag pcsCertificateTag) {
        return this.pcsCertificateTagService.searchTagBySkuCode(pcsCertificateTag);
    }

    public List<PrdcJob> findSkuReportJobVO() {
        return this.prdcJobService.findSkuReportJobVO();
    }

    public List<PcsCertificateTagFieldValueVO> getTagsBySkuCode(List<String> skuCodes) {
        List<PcsCertificateTagFieldValueVO> list = this.pcsCertificateFieldService.getTagsBySkuCode(skuCodes);
        return list;
    }

    public int createPoPlanFee(PcsPoPlanCost pcsPoPlanCost) {
        return this.pcsPoPlanService.createPoPlanFee(pcsPoPlanCost);
    }

    public int batchCreatePoPlanFee(List<PcsPoPlanCost> pcsPoPlanCosts) {
        return this.pcsPoPlanService.batchCreatePoPlanFee(pcsPoPlanCosts);
    }

    public List<PcsPoPlanCost> selectCostByPoPlanId(Integer poPlanId) {
        return this.pcsPoPlanService.selectCostByPoPlanId(poPlanId);
    }

    public Pagination<PcsPoPlanCostVO> pagePoPlanCostVOs(PcsPoPlanCostCond cond) {
        return this.pcsPoPlanService.pagePoPlanCostVOs(cond);
    }

    public List<PcsPoPlanCostVO> listPoPlanCostVOsByGroup(PcsPoPlanCostCond cond) {
        return this.pcsPoPlanService.listPoPlanCostVOsByGroup(cond);
    }

    public List<PcsPoPlanCostVO> listPoPlanCostVOs(PcsPoPlanCostCond cond) {
        return this.pcsPoPlanService.listPoPlanCostVOs(cond);
    }

    public List<PcsPoPlanCost> findPoCostDetails(Integer poId) {
        return this.pcsPoPlanService.findPoCostDetails(poId);
    }

    public int updatePoPlanFee(PcsPoPlanCost pcsPoPlanCost, int optType) {
        return this.pcsPoPlanService.updatePoPlanFee(pcsPoPlanCost, optType);
    }

    public List<PcsFinancePaymentVO> findPoFinaceVOByPoId(long poId) {
        return this.findPoFinaceVOByPoId(poId, null);
    }

    public List<PcsFinancePaymentVO> findPoFinaceVOByPoId(long id, Integer type) {
        List<PcsFinancePayment> list = this.pcsFinancePaymentService.findPoFinaceVOByPoId(id, type);
        return BeanUtil.buildListFrom(list, PcsFinancePaymentVO.class);
    }

    public List<PcsFinancePaymentVO> findPcsFinancePaymentVOByPoId(long poId, Integer type) {
        PcsFinancePaymentCond cond = new PcsFinancePaymentCond();
        cond.setExternalId(poId);
        cond.setType(type);
        return this.findPcsFinancePaymentVOByCond(cond);
    }

    public List<PcsFinancePaymentVO> findPcsFinancePaymentVOByCond(PcsFinancePaymentCond cond) {
        List<PcsFinancePaymentVO> financePaymentVOs = this.pcsFinancePaymentService.findPcsFinancePaymentVOByCond(cond);
        this.buildFinancePaymentCostTypeName(financePaymentVOs);
        return financePaymentVOs;
    }

    public void buildFinancePaymentCostTypeName(List<PcsFinancePaymentVO> financePaymentVOs) {
        Map<String, Map<Integer, String>> allPoCostMap = this.mapAllPoCostMap();
        if (CollectionUtils.isNotEmpty(financePaymentVOs)) {
            financePaymentVOs.forEach(fp -> {
                if (com.thebeastshop.pegasus.util.comm.EmptyUtil.isNotEmpty((Map)((Map)allPoCostMap.get(fp.getPoCostTypeFlag())))) {
                    fp.setPoCostTypeName((String)((Map)allPoCostMap.get(fp.getPoCostTypeFlag())).get(fp.getPoCostType()));
                }
            });
        }
    }

    private Map<String, Map<Integer, String>> mapAllPoCostMap() {
        HashMap<String, Map<Integer, String>> allPoCostMap = new HashMap<String, Map<Integer, String>>();
        List allShipmentType = this.pegasusUtilFacade.findDictionaryByType("SHIPMENT_TYPE");
        Map<Integer, String> shipmentTypeMap = this.convertListToMap(allShipmentType);
        allPoCostMap.put("SHIPMENT_TYPE", shipmentTypeMap);
        List allTaxType = this.pegasusUtilFacade.findDictionaryByType("TAX_TYPE");
        Map<Integer, String> taxTypeMap = this.convertListToMap(allTaxType);
        allPoCostMap.put("TAX_TYPE", taxTypeMap);
        List allOtherFeeType = this.pegasusUtilFacade.findDictionaryByType("OTHER_FEE_TYPE");
        Map<Integer, String> otherFeeTypeMap = this.convertListToMap(allOtherFeeType);
        allPoCostMap.put("OTHER_FEE_TYPE", otherFeeTypeMap);
        allPoCostMap.put("PO_COST", PcsPurchaseOrderCostVO.PO_COST_TYPE_MAP);
        allPoCostMap.put("PO_COST_EXT", PcsPurchaseOrderCostVO.PO_COST_TYPE_EXT_MAP);
        return allPoCostMap;
    }

    private Map<Integer, String> convertListToMap(List<CommDictionary> commDictionaries) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (CommDictionary cd : commDictionaries) {
            map.put(Integer.parseInt(cd.getDictValue()), cd.getDictName());
        }
        return map;
    }

    public Long createFinancePayment(PcsFinancePaymentVO pcsFinancePaymentVO) {
        PcsFinancePaymentVO pcsFinancePayment = this.pcsFinancePaymentService.buildFromModel(pcsFinancePaymentVO);
        return this.pcsFinancePaymentService.createFinancePayment(pcsFinancePayment);
    }

    public Boolean updateFinancePayment(PcsFinancePaymentVO pcsFinancePaymentVO) {
        PcsFinancePayment pcsFinancePayment = new PcsFinancePayment();
        BeanUtils.copyProperties((Object)pcsFinancePaymentVO, (Object)pcsFinancePayment);
        return this.pcsFinancePaymentService.updateFinancePayment(pcsFinancePayment);
    }

    public Map<String, BigDecimal> getTotalPaymentAmount(Long externalId) {
        return this.pcsFinancePaymentService.getTotalPaymentAmount(externalId);
    }

    public PcsFinancePayment findByPrimaryKey(Long id) {
        return this.pcsFinancePaymentService.findByPrimaryKey(id);
    }

    public Long createPurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList, boolean saveDraft) throws Exception {
        return this.pcsPurchaseOrderService.createPurchaseReturnAndLine(pcsPurchaseReturn, returnSkuVOList, saveDraft);
    }

    public Boolean updatePurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList, boolean saveDraft) throws Exception {
        return this.pcsPurchaseOrderService.updatePurchaseReturnAndLine(pcsPurchaseReturn, returnSkuVOList, saveDraft);
    }

    public List<PcsPurchaseReturnVO> findPRVOByCond(PcsPurchaseReturnCond cond) {
        return this.pcsPurchaseOrderService.findPRVOByCond(cond);
    }

    public Integer countPRVOByCond(PcsPurchaseReturnCond cond) {
        return this.pcsPurchaseOrderService.countPRVOByCond(cond);
    }

    public PcsPurchaseReturnVO findPRVOById(Long id, boolean withLine) {
        return this.pcsPurchaseOrderService.findPRVOById(id, withLine);
    }

    public Boolean auditPurchaseReturn(CommAudit commAudit) throws Exception {
        return this.pcsPurchaseOrderService.auditPurchaseReturn(commAudit);
    }

    public Boolean closePurchaseReturn(Long id) {
        return this.pcsPurchaseOrderService.closePurchaseReturn(id);
    }

    public List<PcsPurchaseReturnSkuVO> findPrLineByCond(PcsPurchaseReturnSku cond) {
        return this.pcsPurchaseOrderService.findPrLineByCond(cond);
    }

    public List<PcsPurchaseOrderVO> findPOVOBySupplierId(Long supplierId) {
        return this.pcsPurchaseOrderService.findPOVOBySupplierId(supplierId);
    }

    public List<PcsSkuProductVO> findProductInfoBySkuCodes(List<String> skuCodes) {
        return this.fpcsSkuService.findProductInfoBySkuCodes(skuCodes);
    }

    public List<String> findProductCodesBySkuCodes(List<String> skuCodes) {
        return this.fpcsSkuService.findProductCodesBySkuCodes(skuCodes);
    }

    public List<PcsCostCenter> getAllSecondPcsCostCenters() {
        List<PcsCostCenter> date = this.pcsCostCenterService.getAllSecondPcsCostCenters();
        return date;
    }

    public List<PcsCostCenter> queryPcsCostCenterByParams(Map<String, Object> params) {
        return this.pcsCostCenterService.queryPcsCostCenterByParams(params);
    }

    public List<PcsPurchaseOrderVO> findPoCostById(Long id) {
        return this.pcsPurchaseOrderService.findPoCostById(id);
    }

    public boolean batchUpdatePcsPoCost(PcsPoPlanCostVO pcsPoCostVO, Long operatorId) {
        return this.pcsPurchaseOrderService.batchUpdatePcsPoCost(pcsPoCostVO, operatorId);
    }

    public List<PcsCostAdjust> findCostAjustByCostIds(List<Long> costIds, Integer costType) {
        return this.pcsPurchaseOrderService.findCostAjustByCostIds(costIds, costType);
    }

    public long getPurchaseOrderCount(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderService.countByCond(cond);
    }

    public List<PurchaseSellStockReportVO> findPssReportByCond(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderService.findPssReportByCond(cond);
    }

    public List<PurchaseSellStockReportVO> findPssReportByIds(List<Long> reportIds) {
        return this.pcsPurchaseOrderService.findPssReportByIds(reportIds);
    }

    public Pagination<PcsFlowerDeliveryVO> getFlowerDeliveryByCond(PcsFlowerDeliveryCond cond) {
        return this.pcsFlowerDeliveryService.getFlowerDeliveryByCond(cond);
    }

    public PcsFlowerDeliveryVO getFlowerDeliveryBySku(PcsFlowerDeliveryCond cond) {
        return this.pcsFlowerDeliveryService.getFlowerDeliveryBySku(cond);
    }

    public PcsFlowerDeliveryRecipe getFlowerDeliveryRecipeById(Long recipeId) {
        return this.pcsFlowerDeliveryService.getFlowerDeliveryRecipeById(recipeId);
    }

    public Map<Class<?>, List<?>> findFlowerDeliverySaleInfo(Long deliveryRecipeId, String skuCode) {
        return this.pcsFlowerDeliveryService.findFlowerDeliverySaleInfo(deliveryRecipeId, skuCode);
    }

    public List<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryRecipeByCond(PcsFlowerDeliveryCond cond) {
        return this.pcsFlowerDeliveryService.getFlowerDeliveryRecipeByCond(cond);
    }

    public Pagination<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryDetailByCond(PcsFlowerDeliveryCond cond) {
        return this.pcsFlowerDeliveryService.getFlowerDeliveryDetailByCond(cond);
    }

    public boolean saveFlowerDelivery(PcsFlowerDeliveryCond cond) {
        return this.pcsFlowerDeliveryService.saveFlowerDelivery(cond);
    }

    public List<String> getPackageDeliveryDate(Long packageId, Long salesOrderId) {
        return this.pcsFlowerDeliveryService.getPackageDeliveryDate(packageId, salesOrderId);
    }

    public List<PcsFlowerRecipeSkuVO> getFlowerRecipeSkuByCond(Long recipeId) {
        return this.pcsFlowerDeliveryService.getFlowerRecipeSkuByCond(recipeId);
    }

    public boolean addFlowerRecipeSku(PcsRecipeSkuVO pcsRecipeSkuVO) {
        return this.pcsFlowerDeliveryService.addFlowerRecipeSku(pcsRecipeSkuVO);
    }

    public boolean updateFlowerRecipeSku(PcsRecipeSkuVO pcsRecipeSkuVO) {
        return this.pcsFlowerDeliveryService.updateFlowerRecipeSku(pcsRecipeSkuVO);
    }

    public boolean updateFlowerRecipeById(PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe) {
        return this.pcsFlowerDeliveryService.updateFlowerRecipeById(pcsFlowerDeliveryRecipe);
    }

    public boolean updateFlowerDeliveryById(PcsFlowerDelivery pcsFlowerDelivery) {
        return this.pcsFlowerDeliveryService.updateFlowerDeliveryById(pcsFlowerDelivery);
    }

    public boolean updateFlowerDeliveryUseableById(PcsFlowerDelivery pcsFlowerDelivery) {
        return this.pcsFlowerDeliveryService.updateFlowerDeliveryUseableById(pcsFlowerDelivery);
    }

    public String createFlowerPrdcPreJob(PcsPreAllotVO vo) {
        return this.prdcJobService.createFlowerPrdcPreJob(vo);
    }

    public boolean isSplitBySkuCode(String skuCode) {
        return this.prdcJobService.isSplitBySkuCode(skuCode);
    }

    public PcsFlowerDeliveryDate getFlowerStockAndDate(SFlowerMonthlyQueryDTO monthlyQueryDTO, Date date, String channelCode) {
        return this.pcsFlowerDeliveryService.getFlowerStockAndDate(monthlyQueryDTO, date, channelCode);
    }

    List<PcsFlowerMerchantibleVO> getFlowerSellNumber() {
        return this.pcsFlowerDeliveryService.getFlowerSellNumber();
    }

    public List<PcsFlowerSkuStatisticsVO> requiredSuppliesStatistics(String startDate, String endDate) {
        return this.pcsFlowerDeliveryService.requiredSuppliesStatistics(startDate, endDate);
    }

    public void importFlowerRecipeMaterial(List<FlowerRecipeMaterialVO> list, String skuCode, int isCycle, String effectDate) {
        this.pcsFlowerDeliveryService.importFlowerRecipeMaterial(list, skuCode, isCycle, effectDate);
    }

    public Boolean updateFlowerPlanQuantity(PcsFlowerRecipePlanCond cond) throws Exception {
        return this.pcsFlowerDeliveryService.updateTmallFlowerPlanQuantity(cond);
    }

    public PcsPoPlanCost selectCostByCostId(Long costId) {
        return this.pcsPoPlanService.selectCostByCostId(costId);
    }

    public int delPoPlanFee(Long poPlanFeeId) {
        return this.pcsPoPlanService.delPoPlanFee(poPlanFeeId);
    }

    public List<FpcsConsumableAllotSummaryVO> findApplySummaryBySku(Integer type, String skuCode, List<String> warehouseCodeList) {
        return this.fpcsSkuService.findApplySummaryBySku(type, skuCode, warehouseCodeList);
    }

    public List<FpcsConsumableImportLog> findLastImportLogs() {
        return this.fpcsSkuService.findLastImportLogs();
    }

    public List<Integer> saveLastImportLogs(List<FpcsConsumableImportLog> importDatas) {
        return this.fpcsSkuService.saveLastImportLogs(importDatas);
    }

    public List<PcsCostCenter> selectPcsCategoryCostCenterByLoginId(Long loginUserId, Boolean isFindAll) {
        return this.pcsCategoryCostCenterService.selectPcsCategoryCostCenterByLoginId(loginUserId, isFindAll);
    }

    public Integer closePopPlanEndMonth() {
        return this.pcsPoPlanService.closePopPlanEndMonth();
    }

    public List<PcsPoPlanLineVO> findPcsPoPlanLineListByParams(Map<String, Object> params) {
        return this.pcsPoPlanLineService.findPcsPoPlanLineListByParams(params);
    }

    public List<PcsPoLineVO> findPoSkuByPoId1(long poId) {
        return this.pcsPoLineService.findPoSkuByPoId(poId);
    }

    public List<PcsPoLineVO> findSkuByPoCode(String poCode) {
        return this.pcsPoLineService.findSkuByPoCode(poCode);
    }

    public boolean updatePcsPoPlanWarnFlagByIds(List<Long> ids) {
        return this.pcsPoPlanService.updatePcsPoPlanWarnFlagByIds(ids);
    }

    public int reopenPurchaseOrder(Long poId, Date askDeliveryDate) {
        return this.pcsPurchaseOrderService.reopenPurchaseOrder(poId, askDeliveryDate);
    }

    public void closePop() {
        this.pcsCronService.closePop();
    }

    public List<Long> closePurchaseOrder() {
        return this.pcsCronService.closePurchaseOrder();
    }

    public List<Long> closePoAndPopOnEveryDayTiming(List<PcsPoPlan> poPlanList) {
        return this.pcsCronService.closePoAndPopOnEveryDayTiming(poPlanList);
    }

    public List<PcsPurchaseOrder> findNeedToClosedPO() {
        return this.pcsPurchaseOrderService.findNeedToClosedPO();
    }

    public List<PcsPurchaseOrderVO> findNearestPurchaseOrderBySkuCodes(List<String> skuCodes) {
        return this.pcsPurchaseOrderService.findNearestPurchaseOrderBySkuCodes(skuCodes);
    }

    public FpcsConsumableAllot findFpcsConsumableAllotBySkuCode(String skuCode) {
        return this.fpcsSkuService.findFpcsConsumableAllotBySkuCode(skuCode);
    }

    public void cronSendApprovalEmail() {
        log.info("[\u5b9a\u65f6\u53d1\u9001\u5f85\u5ba1\u6838\u4fe1\u606f]PcsPoPlanCron.cron begin at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        System.out.println("[\u5b9a\u65f6\u53d1\u9001\u5f85\u5ba1\u6838\u4fe1\u606f]PcsPoPlanCron.cron begin at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.pcsCronService.cronSendApprovalEmail();
        log.info("[\u5b9a\u65f6\u53d1\u9001\u5f85\u5ba1\u6838\u4fe1\u606f]PcsPoPlanCron.cron end at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    public void flowerStockWarning() {
        this.pcsCronService.flowerStockWarning();
    }

    public void flowerFinishStateChange() {
        this.pcsCronService.flowerFinishStateChange();
    }

    public void autoUpdateServiceLevel() {
        log.info("[\u5b9a\u65f6\u66f4\u65b0sku\u91cd\u8981\u7b49\u7ea7]PcsCron.cron begin at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.mcPcsSkuService.autoUpdateServiceLevel();
        log.info("[\u5b9a\u65f6\u66f4\u65b0sku\u91cd\u8981\u7b49\u7ea7]PcsCron.cron end at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    public void cronSynPoPlanAndLine() {
        log.debug("[\u540c\u6b65\u91c7\u8d2d\u5355\u6536\u8d27\u4fe1\u606f]PcsPoPlanCron.cron begin at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.pcsCronService.cronSynPoPlanAndLine();
        log.debug("[\u540c\u6b65\u91c7\u8d2d\u5355\u6536\u8d27\u4fe1\u606f]PcsPoPlanCron.cron end at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    public void updatePrdcJobWhenTaskFinishCron() {
        CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("prdcJobFinishCheck");
        if (config == null) {
            return;
        }
        String value = config.getConfigValue();
        if (!StringUtils.isEmpty((Object)value) && "1".equals(value)) {
            this.prdcJobService.updatePrdcJobWhenTaskFinish(null);
        }
    }

    public void autoCreatePrdcJobByPreJob() {
        PrdcJobCond cond = new PrdcJobCond();
        cond.setPagenum(999999);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(PrdcPreJob.PRE_JOB_STATUS_INIT);
        statusList.add(PrdcPreJob.PRE_JOB_STATUS_PROCESSING);
        cond.setPlanStatusList(statusList);
        List<PrdcPreJobVO> prdcPreJobVOs = this.prdcJobService.findPreJobListByCond(cond);
        Long prdcId = null;
        if (prdcPreJobVOs != null && prdcPreJobVOs.size() > 0) {
            for (int i = prdcPreJobVOs.size() - 1; i >= 0; --i) {
                try {
                    PrdcPreJobVO vo = prdcPreJobVOs.get(i);
                    prdcId = this.prdcJobService.processPrdcPreJob(vo);
                    if (NumberUtil.isNullOrZero((Number)prdcId)) continue;
                    this.saveScmEntityOperationLog("\u7cfb\u7edf\u81ea\u52a8\u521b\u5efa\u52a0\u5de5\u5355", "PrdcJob", prdcId + "");
                    continue;
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        }
    }

    public void saveScmEntityOperationLog(String operationDesc, String entityClazz, String entityId) {
        Integer operationType = CommEntityOpRcd.TYPE_ADD;
        Long operatorId = 1L;
        String operatorName = "\u7cfb\u7edf";
        CommEntityOpRcd commEntityOpRcd = new CommEntityOpRcd();
        commEntityOpRcd.setOperatorId(operatorId);
        commEntityOpRcd.setOperatorName(operatorName);
        commEntityOpRcd.setOperationType(operationType);
        commEntityOpRcd.setOperationDesc(operationDesc);
        commEntityOpRcd.setEntityName(entityClazz);
        commEntityOpRcd.setEntityId(entityId);
        this.pegasusUtilFacade.insertEntityOperationRcd(commEntityOpRcd);
    }

    public void sendPreJobDiffAlertDataToEmail() {
        log.info("[\u53d1\u9001\u9884\u52a0\u5de5\u5355\u5dee\u5f02\u63d0\u9192]PcsPrdcJobCron.sendPreJobDiffAlertDataToEmail begin at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        PrdcJobCond cond = new PrdcJobCond();
        String preDay = DateUtil.format((Date)DateUtil.addDay((Date)DateUtil.getNow(), (int)-1), (String)"yyyy-MM-dd");
        cond.setEstDoneDateBegin(preDay);
        cond.setEstDoneDateEnd(preDay);
        cond.setPlanStatus(PrdcPreJob.PRE_JOB_STATUS_FINISH);
        List<PrdcPreJobVO> prdcPreJobVOs = this.prdcJobService.findPreJobListByCond(cond);
        if (CollectionUtils.isNotEmpty(prdcPreJobVOs)) {
            for (PrdcPreJobVO preAllotRcdVO : prdcPreJobVOs) {
                if (preAllotRcdVO.getEstQuantity() != preAllotRcdVO.getFinishedQuantity()) {
                    preAllotRcdVO.setSendMailFlag(true);
                    continue;
                }
                preAllotRcdVO.setSendMailFlag(false);
            }
        }
        HashMap preAllotDiffAlertDatas = new HashMap();
        if (CollectionUtils.isNotEmpty(prdcPreJobVOs)) {
            for (PrdcPreJobVO prdcPreJobVO : prdcPreJobVOs) {
                if (!prdcPreJobVO.getSendMailFlag().booleanValue() || !com.thebeastshop.pegasus.util.comm.EmptyUtil.isNotEmpty((Object)prdcPreJobVO.getCreateOperatorId())) continue;
                prdcPreJobVO.setQuantityDiff((prdcPreJobVO.getEstQuantity() == null ? 0 : prdcPreJobVO.getEstQuantity()) - (prdcPreJobVO.getFinishedQuantity() == null ? 0 : prdcPreJobVO.getFinishedQuantity()));
                if (CollectionUtils.isNotEmpty((Collection)((Collection)preAllotDiffAlertDatas.get(prdcPreJobVO.getCreateOperatorId())))) {
                    ((List)preAllotDiffAlertDatas.get(prdcPreJobVO.getCreateOperatorId())).add(prdcPreJobVO);
                    continue;
                }
                ArrayList<PrdcPreJobVO> voList = new ArrayList<PrdcPreJobVO>();
                voList.add(prdcPreJobVO);
                preAllotDiffAlertDatas.put(prdcPreJobVO.getCreateOperatorId(), voList);
            }
        }
        if (com.thebeastshop.pegasus.util.comm.EmptyUtil.isNotEmpty(preAllotDiffAlertDatas)) {
            for (Map.Entry entry : preAllotDiffAlertDatas.entrySet()) {
                EmailVO emailVO = this.buildPreJobDiffAlertDataEmail((List)entry.getValue(), (Long)entry.getKey());
                if (com.thebeastshop.pegasus.util.comm.EmptyUtil.isEmpty((Object)emailVO)) {
                    log.info("\u9884\u52a0\u5de5\u5355\u5dee\u5f02\u63d0\u9192 :\u6ca1\u6709\u8981\u53d1\u9001\u7684\u5185\u5bb9");
                } else {
                    boolean tf = EmailUtil.getInstance().send(emailVO);
                    log.info("\u9884\u52a0\u5de5\u5355\u5dee\u5f02\u63d0\u9192  \u53d1\u9001: " + tf);
                }
                log.info("[\u53d1\u9001\u9884\u52a0\u5de5\u5355\u5dee\u5f02\u63d0\u9192]PcsPrdcJobCron.sendPreJobDiffAlertDataToEmail end at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
    }

    private EmailVO buildPreJobDiffAlertDataEmail(List<PrdcPreJobVO> preJobDiffAlertDatas, Long createUserId) {
        if (CollectionUtils.isEmpty(preJobDiffAlertDatas)) {
            return null;
        }
        String email = this.prdcJobService.findScmOperatorEmailByOperatorId(createUserId);
        if (com.thebeastshop.pegasus.util.comm.EmptyUtil.isEmpty((String)email)) {
            return null;
        }
        ArrayList lines = new ArrayList();
        ArrayList<String> head = new ArrayList<String>();
        head.add("\u9884\u52a0\u5de5\u5355\u53f7");
        head.add("\u751f\u4ea7\u52a0\u5de5\u4ed3");
        head.add("\u52a0\u5de5\u7c7b\u578b");
        head.add("\u6210\u54c1SKU");
        head.add("\u9884\u8ba1\u52a0\u5de5\u6570\u91cf");
        head.add("\u5df2\u52a0\u5de5\u6570\u91cf");
        head.add("\u5dee\u989d");
        lines.add(head);
        for (PrdcPreJobVO preJobRcdVO : preJobDiffAlertDatas) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(preJobRcdVO.getCode());
            row.add(preJobRcdVO.getWarehouseName());
            row.add(preJobRcdVO.getJobTypeStr());
            row.add("[" + preJobRcdVO.getSkuCode() + "]" + preJobRcdVO.getSkuName());
            row.add(preJobRcdVO.getEstQuantity() + "");
            row.add(preJobRcdVO.getFinishedQuantity() + "");
            row.add(preJobRcdVO.getQuantityDiff() + "");
            lines.add(row);
        }
        byte[] bytes = ExcelUtil.write((String)"\u9884\u52a0\u5de5\u5355\u5dee\u5f02\u63d0\u9192", lines, (boolean)true);
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(Arrays.asList(email));
        emailVO.setToCopyList(Arrays.asList(PegasusUtilFacade.getInstance().findConfigByKey("sendPreJobDiffAlertDataToEmail.copyAddress").getConfigValue().split(",")));
        String todayStr = DateUtil.format((Date)DateUtil.getNow(), (String)"yyyy-MM-dd HH:mm:ss");
        emailVO.setSubject("\u9884\u52a0\u5de5\u5355\u5dee\u5f02\u63d0\u9192-" + todayStr);
        emailVO.setContent("\u9884\u52a0\u5de5\u5355\u5dee\u5f02\u63d0\u9192-" + todayStr);
        ArrayList<EmailAttachmentVO> attachmentList = new ArrayList<EmailAttachmentVO>();
        attachmentList.add(new EmailAttachmentVO("\u9884\u52a0\u5de5\u5355\u5dee\u5f02\u63d0\u9192-" + todayStr + ".xls", bytes));
        emailVO.setAttachmentList(attachmentList);
        return emailVO;
    }

    public void autoSubmitCertificate() {
        log.info("[sku\u6807\u7b7e\u81ea\u52a8\u63d0\u4ea4]PcsSkuCertificateCron.autoSubmitCertificate begin at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        List<String> skuCodes = this.pcsSkuCertificateService.findSkuCodeNeedAutoSubmit();
        if (EmptyUtil.isEmpty(skuCodes)) {
            return;
        }
        PcsSkuCertificateVO defaultCerVO = this.buildEmptyCerSubmit();
        for (String skuCode : skuCodes) {
            try {
                defaultCerVO.setSkuCode(skuCode);
                this.pcsSkuCertificateService.save(defaultCerVO);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info(String.format("[%s]\u7b80\u6613\u6807\u7b7e\u751f\u6210\u5931\u8d25\uff01", skuCode));
            }
        }
        log.info("[sku\u6807\u7b7e\u81ea\u52a8\u63d0\u4ea4]PcsSkuCertificateCron.autoSubmitCertificate end at " + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    private PcsSkuCertificateVO buildEmptyCerSubmit() {
        PcsCertificateTplVO simpleTpl = this.pcsCertificateTplService.findById(16L, true);
        if (NullUtil.isNull((Object)simpleTpl)) {
            throw new PurchaseException("PC0002", "\u7b80\u6613\u6a21\u677f\u4e0d\u5b58\u5728\uff01");
        }
        if (EmptyUtil.isEmpty((String)simpleTpl.getAvaliableSize()) || !simpleTpl.getAvaliableSize().contains("18*48")) {
            throw new PurchaseException("PC0002", "\u7b80\u6613\u6a21\u677f\u4e0d\u652f\u630118*48\u5c3a\u5bf8\uff01");
        }
        PcsCertificateTplFieldVO tplField = this.getSkuNameCerField(simpleTpl);
        PcsSkuCertificateVO cerVO = new PcsSkuCertificateVO();
        Date now = DateUtil.getNow();
        cerVO.setIsHasTag(PcsSkuCertificateVO.HAS_TAG_NO);
        cerVO.setCheckStatus(PcsSkuCertificateVO.CHECK_STATUS_NOT_AUDITED);
        cerVO.setIsSubmit(PcsSkuCertificateVO.SUBMIT_STATUS_NOT_SUBMIT);
        cerVO.setNeedProdDate(PcsSkuCertificateVO.NEED_PROD_DATE_NO);
        cerVO.setCerType(PcsSkuCertificateVO.CER_TYPE_SIMPLE);
        cerVO.setCreateUserId(1L);
        cerVO.setCreateTime(now);
        cerVO.setLastUpdateUserId(null);
        cerVO.setLastUpdateTime(null);
        cerVO.setCertificateSize("18*48");
        cerVO.setCerTplId(simpleTpl.getId());
        ArrayList<PcsSkuCertificateFieldVO> cerFields = new ArrayList<PcsSkuCertificateFieldVO>();
        PcsSkuCertificateFieldVO cerField = new PcsSkuCertificateFieldVO();
        cerField.setCerTplFieldId(tplField.getId());
        cerField.setSortOrder(tplField.getSortOrder());
        cerField.setValue(null);
        cerFields.add(cerField);
        cerVO.setFieldList(cerFields);
        return cerVO;
    }

    private PcsCertificateTplFieldVO getSkuNameCerField(PcsCertificateTplVO tplVO) {
        PcsCertificateTplFieldVO skuNameCerField = null;
        if (EmptyUtil.isEmpty(tplVO.getTplFieldVOList())) {
            throw new PurchaseException("PC0002", "\u7b80\u6613\u6a21\u677f\u5b57\u6bb5\u4e3a\u7a7a\uff01");
        }
        for (PcsCertificateTplFieldVO cerField : tplVO.getTplFieldVOList()) {
            if (!"\u54c1\u540d".equals(cerField.getName())) continue;
            skuNameCerField = cerField;
            break;
        }
        if (NullUtil.isNull(skuNameCerField)) {
            throw new PurchaseException("PC0002", "\u54c1\u540d\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01");
        }
        return skuNameCerField;
    }

    public void cronSendEmailByWasteAterPopFinished() {
        this.pcsCronService.cronSendEmailByWasteAterPopFinished();
    }

    public void sendPopEmailByCond(PcsPoPlanVO cond) {
        this.pcsPoPlanService.sendPopEmailByCond(cond);
    }

    public List<PcsPoPlanVO> findWasteAfterPopFinished(PcsPoPlanVO cond) {
        return this.pcsPoPlanService.findWasteAfterPopFinished(cond);
    }

    public List<PrdcRecipeMaterialSimpleVO> findBottomMaterialByRecipeSkuCodes(List<String> skuCodes) {
        return this.prdcRecipeService.findBottomMaterialByRecipeSkuCodes(skuCodes);
    }

    public List<String> findPhyWhFlowerMonthyCapacitySeted(String skuCode) {
        return this.pcsFlowerDeliveryService.findPhyWhFlowerMonthyCapacitySeted(skuCode);
    }

    public PageInfo findCapacityByCond(PcsFlowerDeliveryCapacityCond cond) {
        return this.pcsFlowerDeliveryService.findCapacityByCond(cond);
    }

    public int saveOrUpdate(List<PcsFlowerMonCapaSettingVO> records) throws Exception {
        return this.pcsFlowerDeliveryService.saveOrUpdate(records);
    }

    public List<PcsFlowerMonCapaLogVO> findPcsFlowerMonCapaLogBySkuCode(String skuCode) {
        return this.pcsFlowerDeliveryService.findPcsFlowerMonCapaLogBySkuCode(skuCode);
    }

    public List<PcsFlowerMonCapaSettingVO> findCityCapacityByCond(PcsFlowerDeliveryCapacityCond cond) {
        return this.pcsFlowerDeliveryService.findCityCapacityByCond(cond);
    }

    public int saveCapacityChangeLogs(List<PcsFlowerMonthlyCapacityLog> logs) {
        return this.pcsFlowerDeliveryService.saveCapacityChangeLogs(logs);
    }

    public List<PcsFlowerMonCapaSettingVO> findCapacityByUniqueIndex(List<PcsFlowerDeliveryCapacityCond> conds) {
        return this.pcsFlowerDeliveryService.findCapacityByUniqueIndex(conds);
    }

    public Map<String, Integer> findCurrentTaskQuntity(String skuCode, List<Integer> cityIds, SFlowerProductionTypeEnum productionTypeEnum) {
        return this.pcsFlowerDeliveryService.findCurrentTaskQuntity(skuCode, cityIds, productionTypeEnum);
    }

    public List<PcsFlowerMonCapaSettingVO> findAllWhCapacityDataBySkucode(String skuCode) {
        return this.pcsFlowerDeliveryService.findAllWhCapacityDataBySkucode(skuCode);
    }

    public Map<String, PcsFlowerDeliveryDate> getFlowerStockAndDate(List<SFlowerMonthlyQueryDTO> queryList, Date date, String channelCode) {
        return this.pcsFlowerDeliveryService.getFlowerStockAndDate(queryList, date, channelCode);
    }

    public int batchInsert(List<PcsBaseTaxRateVO> taxRateList, List<PcsBaseTaxRateVO> newTaxRateList) {
        return this.pcsBaseTaxRateService.batchInsert(taxRateList, newTaxRateList);
    }

    public PageInfo<PcsBaseTaxRateVO> findPageBaseTaxRateByCond(PcsBaseTaxRateCond taxRateCond) {
        return this.pcsBaseTaxRateService.findPageBaseTaxRateByCond(taxRateCond);
    }

    public List<PcsBaseTaxRateVO> findBaseTaxRateByNameOrCode(String nameCode) {
        return this.pcsBaseTaxRateService.findBaseTaxRateByNameOrCode(nameCode);
    }

    public PcsBaseTaxRateVO findPcsBaseTaxRateById(String id) {
        return this.pcsBaseTaxRateService.findPcsBaseTaxRateById(id);
    }

    public PcsBaseTaxRateVO findBaseTaxRateByTaxId(String taxId) {
        return this.pcsBaseTaxRateService.findBaseTaxRateByTaxId(taxId);
    }

    public List<String> findAllTaxId() {
        return this.pcsBaseTaxRateService.findAllTaxId();
    }

    public Pagination<PcsSkuCustomBckVO> findPcsSkuCustomBckByCond(PcsSkuCustomBckCond cond) {
        return this.pcsSkuCustomBckService.findByCond(cond);
    }

    public Integer countByCond(PcsSkuCustomBckCond cond) {
        return this.pcsSkuCustomBckService.countByCond(cond);
    }

    public Integer approveOrRefuseSkuCustomBck(Integer id, Integer status, String customBckCode, String remark) {
        return this.pcsSkuCustomBckService.approveOrRefuseSkuCustomBck(id, status, customBckCode, remark);
    }

    public Integer insertWhenNotExist(PcsSkuCustomBck pcsSkuCustomBck) {
        return this.pcsSkuCustomBckService.insertWhenNotExist(pcsSkuCustomBck);
    }

    public int savePopLogisticsBill(PcsPoPlanLogisticsBillVO logisticsBill) {
        return this.pcsPoLogisticsBillService.savePopLogisticsBill(logisticsBill);
    }

    public PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillById(Integer billId) {
        return this.pcsPoLogisticsBillService.getPcsPoPlanLogisticsBillById(billId);
    }

    public PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillByPopCode(String popCode) {
        return this.pcsPoLogisticsBillService.getPcsPoPlanLogisticsBillByPopCode(popCode);
    }

    public PageInfo<PcsPoPlanLogisticsBillVO> listBillByCond(PoLogisticsBillCond cond) {
        return this.pcsPoLogisticsBillService.listBillByCond(cond);
    }

    public int savePopLogisticsBills(List<PcsPoPlanLogisticsBillVO> logisticsBills) {
        return this.pcsPoLogisticsBillService.savePopLogisticsBills(logisticsBills);
    }

    public List<PoLogisticsBillStatusTab> countGroupByBillstatus(PoLogisticsBillCond cond) {
        return this.pcsPoLogisticsBillService.countGroupByBillstatus(cond);
    }

    public int cancelPopLogisticsBill(Integer id) {
        return this.pcsPoLogisticsBillService.cancelPopLogisticsBill(id);
    }

    public List<PcsPoPlanLogisticsBillVO> listLogisticsBillByPoId(Long poId) {
        return this.pcsPoLogisticsBillService.listLogisticsBillByPoId(poId);
    }

    public Map<String, PrdcRecipeVO> mapRecipeVOBySkuCode(List<String> skuCodes) {
        return this.prdcRecipeService.mapRecipeVOBySkuCode(skuCodes);
    }

    public List<PrdcJobVO> findNearestJobBySkuCodes(List<String> skuCodes) {
        return this.prdcJobService.findNearestJobBySkuCodes(skuCodes);
    }

    public PageInfo<PcsPoProgressTrackingVO> pageQueryTrackingProgressByCond(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderService.pageQueryTrackingProgressByCond(cond);
    }

    public List<PcsPoLineVO> findPoLineByPoIds(List<Long> poIds) {
        return this.pcsPoLineService.findPoLineByPoIds(poIds);
    }

    public List<PcsPoPlanLineVO> sumPopSkuTotalQuantity(List<Long> popIds) {
        return this.pcsPoPlanLineService.sumPopSkuTotalQuantity(popIds);
    }

    public List<PcsPoProgressTrackingDetailVO> queryTrackingProgressDetailByCond(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderService.queryTrackingProgressDetailByCond(cond);
    }

    public Integer addOrEditPurchaseFlower(PcsPurchaseFlowerVO pcsPurchaseFlower) {
        return this.pcsPurchaseFlowerService.addOrEditPurchaseFlower(pcsPurchaseFlower);
    }

    public Pagination<PcsPurchaseFlowerVO> findByCond(PcsPurchaseFlowerCond cond) {
        return this.pcsPurchaseFlowerService.findByCond(cond);
    }

    public PcsPurchaseFlowerVO findById(Integer id) {
        return this.pcsPurchaseFlowerService.findById(id);
    }

    public List<PcsPurchaseFlowerVO> findByCondForExport(PcsPurchaseFlowerCond cond) {
        return this.pcsPurchaseFlowerService.findByCondForExport(cond);
    }

    public Integer updateByExample(PcsPurchaseFlowerVO pcsPurchaseFlowerVO) {
        return this.pcsPurchaseFlowerService.updateByExample(pcsPurchaseFlowerVO);
    }

    public Integer batchUpdateByCode(List<PcsPurchaseFlower> pcsPurchaseFlowers) {
        return this.pcsPurchaseFlowerService.batchUpdateByCode(pcsPurchaseFlowers);
    }

    public Integer batchInsertPurchaseFlower(List<PcsPurchaseFlower> pcsPurchaseFlowers) {
        return this.pcsPurchaseFlowerService.batchInsert(pcsPurchaseFlowers);
    }

    public List<PcsPurchaseFlowerVO> findPurchaseFlowerByNameOrCodeLike(String channelCode, String nameOrCode, Integer unitConfigId) {
        return this.pcsPurchaseFlowerService.findPurchaseFlowerByChannelCodeAndCodeOrName(channelCode, nameOrCode, unitConfigId);
    }

    public Pagination<PcsPurchaseFlowerSupplierVO> findPurchaseFlowerSupplierByCond(PcsPurchaseFlowerSupplierCond cond) {
        return this.pcsPurchaseFlowerSupplierService.findByCond(cond);
    }

    public Integer addOrEditPurchaseFlowerSupplier(PcsPurchaseFlowerSupplierVO pcsPurchaseFlowerSupplierVO) {
        return this.pcsPurchaseFlowerSupplierService.addOrEditPurchaseFlowerSupplier(pcsPurchaseFlowerSupplierVO);
    }

    public PcsPurchaseFlowerSupplierVO findPurchaseFlowerSupplierById(Integer id) {
        return this.pcsPurchaseFlowerSupplierService.findById(id);
    }

    public List<PcsPurchaseFlowerSupplierVO> findPurchaseFlowerSupplierByCondForExport(PcsPurchaseFlowerSupplierCond cond) {
        return this.pcsPurchaseFlowerSupplierService.findByCondForExport(cond);
    }

    public Integer updatePurchaseFlowerSupplierByExample(PcsPurchaseFlowerSupplierVO pcsPurchaseFlowerSupplierVO) {
        return this.pcsPurchaseFlowerSupplierService.updateByExample(pcsPurchaseFlowerSupplierVO);
    }

    public Integer batchUpdatePurchaseFlowerSupplierByCode(List<PcsPurchaseFlowerSupplierVO> pcsPurchaseFlowerSuppliers) {
        return this.pcsPurchaseFlowerSupplierService.batchUpdateByCode(pcsPurchaseFlowerSuppliers);
    }

    public Integer batchInsertPurchaseFlowerSupplier(List<PcsPurchaseFlowerSupplierVO> pcsPurchaseFlowerSuppliers) {
        return this.pcsPurchaseFlowerSupplierService.batchInsert(pcsPurchaseFlowerSuppliers);
    }

    public List<PcsPurchaseFlowerSupplierVO> findAllSupplier() {
        return this.pcsPurchaseFlowerSupplierService.findAllSupplier();
    }

    public List<PcsPurchaseFlowerSupplierVO> findSupplierByNameOrCodeLike(String term) {
        return this.pcsPurchaseFlowerSupplierService.findByNameOrCodeLike(term);
    }

    public Pagination<PurchaseFlowerPlanVO> findByCond(PurchaseFlowerPlanCond cond) {
        return this.purchaseFlowerPlanService.findByCond(cond);
    }

    public List<PurchaseFlowerPlanVO> findByCondForExportExcel(PurchaseFlowerPlanCond cond) {
        return this.purchaseFlowerPlanService.findByCondForExportExcel(cond);
    }

    public Integer addOrEditPurchaseFlowerPlan(PurchaseFlowerPlanVO purchaseFlowerPlanVO) {
        return this.purchaseFlowerPlanService.addOrEditPurchaseFlowerPlan(purchaseFlowerPlanVO);
    }

    public PurchaseFlowerPlanVO findPurchaseFlowerPlanById(Integer id) {
        return this.purchaseFlowerPlanService.findById(id);
    }

    public Pagination<PcsPurchaseFlowerReceiveOrderVO> findPurchaseFlowerReceiveOrderByCond(PurchaseFlowerReceiveOrderCond cond) {
        return this.purchaseFlowerReceiveOrderService.findByCond(cond);
    }

    public List<PcsPurchaseFlowerReceiveOrderVO> findByCondForExportExcel(PurchaseFlowerReceiveOrderCond cond) {
        return this.purchaseFlowerReceiveOrderService.findByCondForExportExcel(cond);
    }

    public Integer addOrEditPurchaseFlowerReceiveOrder(PcsPurchaseFlowerReceiveOrderVO vo) {
        return this.purchaseFlowerReceiveOrderService.addOrEditPurchaseFlowerReceiveOrder(vo);
    }

    public PcsPurchaseFlowerReceiveOrderVO findPurchaseFlowerReceiveOrderById(Integer id) {
        return this.purchaseFlowerReceiveOrderService.findById(id);
    }

    public Pagination<PurchaseFlowerReportVO> findPurchaseFlowerAchievementReportByCond(PurchaseFlowerAchievementReportCond cond) {
        return this.pcsPurchaseFlowerAchievementService.findPurchaseFlowerAchievementReportByCond(cond);
    }

    public Integer checkInAchievement(PcsPurchaseFlowerAchievement pcsPurchaseFlowerAchievement) {
        return this.pcsPurchaseFlowerAchievementService.checkInAchievement(pcsPurchaseFlowerAchievement);
    }

    public Pagination<PurchaseFlowerSupplierReportVO> findSupplierReportByCond(PurchaseFlowerSupplierReportCond cond) throws ParseException {
        return this.purchaseFlowerReceiveOrderService.findSupplierReportByCond(cond);
    }

    public String getOrCreateSkuCerMpCode(String skuCode) {
        return this.pcsSkuCertificateService.getOrCreateSkuCerMpCode(skuCode);
    }

    public boolean addOrEditPcsSkuAutoApproveRule(PcsSkuFinanceAutoApproveRuleVO ruleVO) {
        return this.pcsSkuAutoApproveRuleService.addOrEdit(ruleVO);
    }

    public PcsSkuFinanceAutoApproveRuleVO findPcsSkuFinanceAutoApproveRuleVO(PcsSkuFinanceAutoApproveRuleCond cond) {
        return this.pcsSkuAutoApproveRuleService.findPcsSkuFinanceAutoApproveRuleVO(cond);
    }

    public Map<Integer, BigDecimal> getPcsSkuFinanceAutoApproveRuleForCostRiseUnder() {
        return this.pcsSkuAutoApproveRuleService.getPcsSkuFinanceAutoApproveRuleForCostRiseUnder();
    }

    public List<PcsSkuAutoApproveBgmVO> listAllPcsSkuAutoApproveBgmVO() {
        return this.pcsSkuAutoApproveRuleService.listAllPcsSkuAutoApproveBgmVO();
    }

    public List<PcsSkuAutoApproveBgm> listPcsSkuAutoApproveBgmByCond(PcsSkuAutoApproveBgmCond cond) {
        return this.pcsSkuAutoApproveRuleService.listPcsSkuAutoApproveBgmByCond(cond);
    }

    public List<PcsSkuAutoApproveBgmVO> listAllFirstCategoryBgmVO() {
        return this.pcsSkuAutoApproveRuleService.listAllFirstCategoryBgmVO();
    }

    public List<PcsSkuAutoApproveBgmVO> listCategoryBgmVOByCond(PcsSkuAutoApproveBgmCond cond) {
        return this.pcsSkuAutoApproveRuleService.listCategoryBgmVOByCond(cond);
    }

    public boolean batchAddPcsSkuAutoApproveBgm(List<PcsSkuAutoApproveBgm> list, Boolean needEmpty) {
        return this.pcsSkuAutoApproveRuleService.batchAddPcsSkuAutoApproveBgm(list, needEmpty);
    }

    public int withdrawApproval(Long poId) {
        return this.pcsPurchaseOrderService.withdrawApproval(poId);
    }

    public List<PcsPoLineVO> findPoApprovalRecordLine(Long poId) {
        return this.pcsPurchaseOrderService.findPoApprovalRecordLine(poId);
    }

    public PcsPurchaseOrderVO findPoVOById(long id, boolean cascadeLine) {
        return this.pcsPurchaseOrderService.findPoVOById(id, cascadeLine);
    }

    public List<PcsPurchaseOrderVO> listPoVOByIds(List<Long> ids, boolean cascadeLine) {
        return this.pcsPurchaseOrderService.listPoVOByIds(ids, cascadeLine);
    }

    public PcsPurchaseOrderVO findPoVOForApprovalById(long id, boolean cascadeLine) {
        return this.pcsPurchaseOrderService.findPoVOForApprovalById(id, cascadeLine);
    }

    public PcsPurchaseOrderVO findPoVOByCond(PcsPurchaseOrderCond cond) {
        return this.pcsPurchaseOrderService.findPoVOByCond(cond);
    }

    public Map<String, Integer> computeRealityGoodQuantityByPoId(Long poId) {
        return this.pcsPurchaseOrderService.computeRealityGoodQuantityByPoId(poId);
    }

    public List<Long> findCanAutoCreatePopPoIds() {
        return this.pcsPurchaseOrderService.findCanAutoCreatePopPoIds();
    }

    public int savePopLines(List<PcsPoPlanLineVO> lineList) {
        return this.pcsPoPlanLineService.update(lineList);
    }

    public Map<String, Integer> mapRefundedGoodQuantityByPoIdAndSkuCode(Long poId) {
        return this.pcsPurchaseOrderService.mapRefundedGoodQuantityByPoIdAndSkuCode(poId);
    }

    public List<PcsFinancePaymentVO> selectNotNotifyPoPaymentInfo() {
        return this.pcsFinancePaymentService.selectNotNotifyPoPaymentInfo();
    }

    public int updatePoPaymentNotifyStatus(List<Integer> ids) {
        return this.pcsFinancePaymentService.updatePoPaymentNotifyStatus(ids);
    }

    public List<PcsPoPlanLineVO> listPopLineIncludeWaste(List<Long> poIds) {
        return this.pcsPoPlanLineService.listIncludeWaste(poIds);
    }
}

