package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlower;
import com.thebeastshop.pegasus.service.purchase.model.PurchaseFlowerPlan;
import com.thebeastshop.pegasus.service.purchase.model.PurchaseFlowerPlanItem;
import org.apache.commons.lang.StringUtils;

import java.text.SimpleDateFormat;
import java.util.List;

/**
 * @Author: ljj
 * @Description:${todo}(用一句话描述该文件做什么)
 * @Date: 2018/12/18 0:33
 * @Version 1.0
 */
public class PurchaseFlowerPlanVO extends PurchaseFlowerPlan {

    private String channelName;

    private String statusName;

    private String createOperatorName;

    private String planReceiveDateStr;

    private Integer placeOfOrigin;

    private String placeOfOriginName;

    private String season;

    private String seasonName;

    private List<PurchaseFlowerPlanItemVO> purchaseFlowerPlanItemVOS;

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getStatusName() {
        return getStatusName(getStatus());
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public static String getStatusName(Integer status){
        return WAIT_RECEIVE.equals(status)?"待收货":
                ALREADY_RECEIVE.equals(status)?"待审批":"";
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public String getPlanReceiveDateStr() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(getPlanReceiveDate());
    }

    public void setPlanReceiveDateStr(String planReceiveDateStr) {
        this.planReceiveDateStr = planReceiveDateStr;
    }

    public String getPlaceOfOriginName() {
        return getPlaceOfOriginName(placeOfOrigin);
    }

    public void setPlaceOfOriginName(String placeOfOriginName) {
        this.placeOfOriginName = placeOfOriginName;
    }

    public Integer getPlaceOfOrigin() {
        return placeOfOrigin;
    }

    public void setPlaceOfOrigin(Integer placeOfOrigin) {
        this.placeOfOrigin = placeOfOrigin;
    }

    public String getSeason() {
        return season;
    }

    public void setSeason(String season) {
        this.season = season;
    }

    public String getSeasonName() {
        return getSeasonName(getSeason());
    }

    public void setSeasonName(String seasonName) {
        this.seasonName = seasonName;
    }

    public static String getSeasonName(String season){
        String finaliyStr = "";
        StringBuilder sb = new StringBuilder("");
        if (StringUtils.isNotEmpty(season)) {
            String[] seasonsArray = season.split(",");
            if (seasonsArray.length>0) {
                for (String seasons : seasonsArray) {
                    if ("1".equals(seasons)) {
                        sb.append("春,");
                    } else if ("2".equals(seasons)) {
                        sb.append("夏,");
                    } else if ("3".equals(seasons)) {
                        sb.append("秋,");
                    } else if ("4".equals(seasons)) {
                        sb.append("冬,");
                    }
                }
                finaliyStr = sb.toString();
                finaliyStr = finaliyStr.substring(0,finaliyStr.length()-1);
            }
        }
        return finaliyStr;
    }

    public static String getPlaceOfOriginName(Integer placeOfOrigin){
        return placeOfOrigin == null ? "" :
                placeOfOrigin.equals(PcsPurchaseFlower.PLACE_OF_ORIGIN_MIC) ? "国产" :
                        placeOfOrigin.equals(PcsPurchaseFlower.PLACE_OF_ORIGIN_IMPORT) ? "进口" :"";
    }

    public List<PurchaseFlowerPlanItemVO> getPurchaseFlowerPlanItemVOS() {
        return purchaseFlowerPlanItemVOS;
    }

    public void setPurchaseFlowerPlanItemVOS(List<PurchaseFlowerPlanItemVO> purchaseFlowerPlanItemVOS) {
        this.purchaseFlowerPlanItemVOS = purchaseFlowerPlanItemVOS;
    }


    /**
     * 待收货
     */
    public static final Integer WAIT_RECEIVE = 0;

    /**
     * 已收货
     */
    public static final Integer ALREADY_RECEIVE = 1;

}
