package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlower;
import com.thebeastshop.pegasus.service.purchase.model.PurchaseFlowerPlanItem;
import org.apache.commons.lang.StringUtils;

/**
 * @Author: ljj
 * @Description:${todo}(用一句话描述该文件做什么)
 * @Date: 2018/12/18 0:49
 * @Version 1.0
 */
public class PurchaseFlowerPlanItemVO extends PurchaseFlowerPlanItem {

    private String flowerCode;

    private String nameCn;

    private String nameEn;

    private Integer unit;

    private String unitName;

    private Integer type;

    private String typeName;

    private String useChannelName;

    private Integer placeOfOrigin;

    private String placeOfOriginName;

    private String season;

    private String seasonName;

    private String tbIdStr;

    public String getFlowerCode() {
        return flowerCode;
    }

    public void setFlowerCode(String flowerCode) {
        this.flowerCode = flowerCode;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public String getNameEn() {
        return nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getUseChannelName() {
        return useChannelName;
    }

    public void setUseChannelName(String useChannelName) {
        this.useChannelName = useChannelName;
    }

    public Integer getPlaceOfOrigin() {
        return placeOfOrigin;
    }

    public void setPlaceOfOrigin(Integer placeOfOrigin) {
        this.placeOfOrigin = placeOfOrigin;
    }

    public String getPlaceOfOriginName() {
        if (StringUtils.isNotEmpty(placeOfOriginName)) {
            return placeOfOriginName;
        }
        return getPlaceOfOriginName(getPlaceOfOrigin());
    }

    public void setPlaceOfOriginName(String placeOfOriginName) {
        this.placeOfOriginName = placeOfOriginName;
    }

    public static String getPlaceOfOriginName(Integer placeOfOrigin) {
        return placeOfOrigin == null ? "" :
                placeOfOrigin.equals(PcsPurchaseFlower.PLACE_OF_ORIGIN_IMPORT) ? "进口" :
                        placeOfOrigin.equals(PcsPurchaseFlower.PLACE_OF_ORIGIN_MIC) ? "国产" : "";
    }

    public String getSeason() {
        return season;
    }

    public void setSeason(String season) {
        this.season = season;
    }

    public String getSeasonName() {
        if (StringUtils.isNotEmpty(seasonName)) {
            return seasonName;
        } else {
            return getSeasonName(season);
        }
    }

    public void setSeasonName(String seasonName) {
        this.seasonName = seasonName;
    }

    public static String getSeasonName(String season) {
        StringBuilder sb = new StringBuilder("");
        if (StringUtils.isNotEmpty(season)) {
            String[] seasonArray = season.split(",");
            for (String str : seasonArray) {
                Integer tmpSeason = Integer.parseInt(str);
                if (tmpSeason == PcsPurchaseFlower.SEASON_SPRING) {
                    sb.append("春,");
                } else if (tmpSeason == PcsPurchaseFlower.SEASON_SUMMER) {
                    sb.append("夏,");
                } else if (tmpSeason == PcsPurchaseFlower.SEASON_AUTUMN) {
                    sb.append("秋,");
                } else if (tmpSeason == PcsPurchaseFlower.SEASON_WINTER) {
                    sb.append("冬,");
                }
            }
            String completeSeasonStr = sb.toString();
            return completeSeasonStr.substring(0,completeSeasonStr.length()-1);
        } else {
            return "";
        }
    }

    public String getTbIdStr() {
        return tbIdStr;
    }

    public void setTbIdStr(String tbIdStr) {
        this.tbIdStr = tbIdStr;
    }
}
