/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipe;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeSku;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;

/**
 * @author Eric.Lou
 * @version $Id: PrdcRecipeVO.java, v 0.1 2015-12-30 17:02
 */
public class PrdcRecipeVO {

    @Deprecated
    final public static List<KeyValueVO> processingWarehouseList;

    static{
        processingWarehouseList = new ArrayList<>();
        processingWarehouseList.add(new KeyValueVO("WH02060001","颛兴路物理仓"));
        processingWarehouseList.add(new KeyValueVO("WH02060002","公司总部物理仓"));
    }

    // constructor
    public PrdcRecipeVO(){

    }

    // original
    private Long id;

    private String recipeName;

    private String recipeDesc;

    private Integer recipeStatus;

    private String skuCode;

    private Date createTime;

    private Long createUserId;

    // self
    private String skuName;

    private String createUserName;

    private String processingWarehouse;

    private Integer customization;


    private List<PrdcRecipeMaterialVO> recipeMaterialVOList;
    
    private Float productionHours;

    private Integer isSubmit;		// sku中文标签状态是否提交
    private Integer skuType;		// SKU类型，1原材料2半成品3成品
    private String categoryFullName;

    // 成品SKU 图片
    private String imageUrl;

    private List<PrdcRecipeSku> prdcRecipeSkus;

    private List<PrdcRecipeSkuVO> prdcRecipeSkuVOs;

    private String imageUrlTmp;

    private Map<String, BigDecimal> currencyMap;

    private String costRiseUnder;

	public Float getProductionHours() {
		return productionHours;
	}

	public void setProductionHours(Float productionHours) {
		this.productionHours = productionHours;
	}

	// manual generate
    public String getRecipeStatusName(){
        return recipeStatus==null?"error":
                recipeStatus.equals(PrdcRecipe.RECIPE_STATUS_AVAILABLE)?"可用":
                        recipeStatus.equals(PrdcRecipe.RECIPE_STATUS_UNAVAILABLE)?"禁用":"";
    }

    // auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRecipeName() {
        return recipeName;
    }

    public void setRecipeName(String recipeName) {
        this.recipeName = recipeName;
    }

    public String getRecipeDesc() {
        return recipeDesc;
    }

    public void setRecipeDesc(String recipeDesc) {
        this.recipeDesc = recipeDesc;
    }

    public Integer getRecipeStatus() {
        return recipeStatus;
    }

    public void setRecipeStatus(Integer recipeStatus) {
        this.recipeStatus = recipeStatus;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public List<PrdcRecipeMaterialVO> getRecipeMaterialVOList() {
        return recipeMaterialVOList;
    }

    public void setRecipeMaterialVOList(List<PrdcRecipeMaterialVO> recipeMaterialVOList) {
        this.recipeMaterialVOList = recipeMaterialVOList;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

	public Integer getIsSubmit() {
		return isSubmit;
	}

	public void setIsSubmit(Integer isSubmit) {
		this.isSubmit = isSubmit;
	}

    public Integer getCustomization() {
        return customization;
    }

    public static boolean isCustomization(Integer customization){
        if(NullUtil.isNotNull(customization) && PegasusConstants.YES == customization){
            return true;
        }
        return false;
    }

    public void setCustomization(Integer customization) {
        this.customization = customization;
    }

    public String getProcessingWarehouse() {
        return processingWarehouse;
    }

    public void setProcessingWarehouse(String processingWarehouse) {
        this.processingWarehouse = processingWarehouse;
    }

    public Integer getSkuType() {
		return skuType;
	}

	public void setSkuType(Integer skuType) {
		this.skuType = skuType;
	}

    public String getCategoryFullName() {
        return categoryFullName;
    }

    public void setCategoryFullName(String categoryFullName) {
        this.categoryFullName = categoryFullName;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public List<PrdcRecipeSku> getPrdcRecipeSkus() {
        return prdcRecipeSkus;
    }

    public void setPrdcRecipeSkus(List<PrdcRecipeSku> prdcRecipeSkus) {
        this.prdcRecipeSkus = prdcRecipeSkus;
    }

    public List<PrdcRecipeSkuVO> getPrdcRecipeSkuVOs() {
        return prdcRecipeSkuVOs;
    }

    public void setPrdcRecipeSkuVOs(List<PrdcRecipeSkuVO> prdcRecipeSkuVOs) {
        this.prdcRecipeSkuVOs = prdcRecipeSkuVOs;
    }

    public String getImageUrlTmp() {
        return imageUrlTmp;
    }

    public void setImageUrlTmp(String imageUrlTmp) {
        this.imageUrlTmp = imageUrlTmp;
    }

    public Map<String, BigDecimal> getCurrencyMap() {
        return currencyMap;
    }

    public void setCurrencyMap(Map<String, BigDecimal> currencyMap) {
        this.currencyMap = currencyMap;
    }

    public String getCostRiseUnder() {
        return costRiseUnder;
    }

    public void setCostRiseUnder(String costRiseUnder) {
        this.costRiseUnder = costRiseUnder;
    }
}