package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by admin on 2016/12/29.
 */
public class PrdcPreJobVO implements Serializable{
    private Long id;
    private String code;
    private String warehouseName;
    private String skuCode;
    private String skuName;
    private Integer estQuantity;
    private Integer finishedQuantity;
    // 预计生产数量与实际生产数量有差额
    private Integer quantityDiff;
    private Integer jobType;
    private String estStartDate;
    private String estDoneDate;
    private Integer planStatus;
    private String warehouseCode;
    private Integer minAmount;
    private Long recipeId;
    private String remark;
    private List<PrdcPreJobLineVO> jobLineVOList;
    private Long createOperatorId;
    private String createOperatorName;
    // 是否需要发送邮件
    private Boolean sendMailFlag;

    // 物理仓
    private String physicalWarehouseCode;
    private String physicalWarehouseName;

    /**
     * 优先级
     */
    private Integer priority;

    private String priorityStr;

    public static final Integer PRIORITY_LOW = 0;
    public static final Integer PRIORITY_MIDDLE = 1;
    public static final Integer PRIORITY_HIGH = 2;
    public static final Map<Integer,String> PRDC_JOB_PRIORITY_MAP = new HashMap(){{
        put(PRIORITY_LOW,"低");
        put(PRIORITY_MIDDLE,"中");
        put(PRIORITY_HIGH,"高");
    }};

    public String getJobTypeStr(){
        String returnStr = "";
        if(jobType != null){
            switch (jobType){
                case 1:returnStr="组装";break;
                case 2:returnStr="拆分";
            }
            return returnStr;
        }
        return "";
    }
    public String getPlanStatusStr(){
        String returnStr = "";
        if(planStatus != null ){
            switch (planStatus){
                case 1:returnStr="初始化";break;
                case 2:returnStr="加工中";break;
                case 3:returnStr="已完成";
            }
            return returnStr;
        }
        return "";
    }
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Integer getEstQuantity() {
        return estQuantity;
    }

    public void setEstQuantity(Integer estQuantity) {
        this.estQuantity = estQuantity;
    }

    public Integer getFinishedQuantity() {
        return finishedQuantity;
    }

    public void setFinishedQuantity(Integer finishedQuantity) {
        this.finishedQuantity = finishedQuantity;
    }

    public Integer getJobType() {
        return jobType;
    }

    public Integer getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(Integer minAmount) {
        this.minAmount = minAmount;
    }

    public Long getRecipeId() {
        return recipeId;
    }

    public void setRecipeId(Long recipeId) {
        this.recipeId = recipeId;
    }

    public void setJobType(Integer jobType) {
        this.jobType = jobType;
    }

    public String getEstStartDate() {
        return estStartDate;
    }

    public void setEstStartDate(String estStartDate) {
        this.estStartDate = estStartDate;
    }

    public String getEstDoneDate() {
        return estDoneDate;
    }

    public void setEstDoneDate(String estDoneDate) {
        this.estDoneDate = estDoneDate;
    }

    public Integer getPlanStatus() {
        return planStatus;
    }

    public void setPlanStatus(Integer planStatus) {
        this.planStatus = planStatus;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public List<PrdcPreJobLineVO> getJobLineVOList() {
        return jobLineVOList;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setJobLineVOList(List<PrdcPreJobLineVO> jobLineVOList) {
        this.jobLineVOList = jobLineVOList;
    }

    public Long getCreateOperatorId() {
        return createOperatorId;
    }

    public void setCreateOperatorId(Long createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public Integer getQuantityDiff() {
        return quantityDiff;
    }

    public void setQuantityDiff(Integer quantityDiff) {
        this.quantityDiff = quantityDiff;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public Boolean getSendMailFlag() {
        return sendMailFlag;
    }

    public void setSendMailFlag(Boolean sendMailFlag) {
        this.sendMailFlag = sendMailFlag;
    }

    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getPriorityStr() {
        if (EmptyUtil.isEmpty(priorityStr) && EmptyUtil.isNotEmpty(priority)){
            return PRDC_JOB_PRIORITY_MAP.get(priority);
        }
        return "";
    }

    public void setPriorityStr(String priorityStr) {
        this.priorityStr = priorityStr;
    }
}
