package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

/**
 * Created by admin on 2016/12/26.
 */
@ExcelTemplate
public class PrdcPreJobDownloadVO {
    @ExcelColumn(name="预加工单号")
    private String code;
    private Integer planStatus;
    @ExcelColumn(name="预加工单状态")
    private String planStatusName;
    @ExcelColumn(name="生产加工仓")
    private String warehouseName;
    @ExcelColumn(name="SKU")
    private String skuCode;
    @ExcelColumn(name="SKU名称")
    private String skuName;
    @ExcelColumn(name="预计加工数量")
    private Integer estQuantity;
    @ExcelColumn(name="已生成加工数量")
    private Integer finishedQuantity;
    private Integer jobType;
    @ExcelColumn(name="加工类型")
    private String jobTypeStr;
    @ExcelColumn(name="预计开始日期")
    private String estStartDate;
    @ExcelColumn(name="预计完成日期")
    private String estDoneDate;

    @ExcelColumn(name="最小加工数量")
    private Integer minQuantity;
    @ExcelColumn(name="耗材SKU_CODE")
    private String mSkuCode;
    @ExcelColumn(name="耗材SKU名称")
    private String mSkuName;
    private Integer materialType;
    @ExcelColumn(name="耗材类型")
    private String materialTypeStr;
    @ExcelColumn(name="预计变更数量")
    private Float estAmount;
    @ExcelColumn(name="需求数量")
    private Float realAmount;
    private String warehouseCode;

    @ExcelColumn(name="可用数量")
    private Float useAmount;

    @ExcelColumn(name="差额")
    private Float diff;

    @ExcelColumn(name="优先级")
    private Integer priority;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getPlanStatus() {
        return planStatus;
    }

    public void setPlanStatus(Integer planStatus) {
        this.planStatus = planStatus;
    }

    public String getPlanStatusName() {
        String returnStr = "";
        if(planStatus != null){
            switch (planStatus){
                case 1:returnStr = "初始化";break;
                case 2:returnStr = "加工中";break;
                case 3:returnStr = "已完成";
            }
        }
        return returnStr;
    }

    public void setPlanStatusName(String planStatusName) {
        this.planStatusName = planStatusName;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Integer getEstQuantity() {
        return estQuantity;
    }

    public void setEstQuantity(Integer estQuantity) {
        this.estQuantity = estQuantity;
    }

    public Integer getFinishedQuantity() {
        return finishedQuantity;
    }

    public void setFinishedQuantity(Integer finishedQuantity) {
        this.finishedQuantity = finishedQuantity;
    }

    public Integer getJobType() {
        return jobType;
    }

    public void setJobType(Integer jobType) {
        this.jobType = jobType;
    }

    public String getJobTypeStr() {
        String returnStr = "";
        if(jobType != null){
            switch (jobType){
                case 1 : returnStr = "组装";break;
                case 2 : returnStr = "拆分";break;
            }
        }
        return returnStr;
    }

    public void setJobTypeStr(String jobTypeStr) {
        this.jobTypeStr = jobTypeStr;
    }

    public String getEstStartDate() {
        return estStartDate;
    }

    public void setEstStartDate(String estStartDate) {
        this.estStartDate = estStartDate;
    }

    public String getEstDoneDate() {
        return estDoneDate;
    }

    public void setEstDoneDate(String estDoneDate) {
        this.estDoneDate = estDoneDate;
    }

    public Integer getMinQuantity() {
        return minQuantity;
    }

    public void setMinQuantity(Integer minQuantity) {
        this.minQuantity = minQuantity;
    }

    public String getMSkuCode() {
        return mSkuCode;
    }

    public void setMSkuCode(String mSkuCode) {
        this.mSkuCode = mSkuCode;
    }

    public String getMSkuName() {
        return mSkuName;
    }

    public void setMSkuName(String mSkuName) {
        this.mSkuName = mSkuName;
    }

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }

    public String getMaterialTypeStr() {
        String returnStr = "";
        if(materialType != null){
            switch (materialType){
                case 1 : returnStr = "主耗材";break;
                case 2 : returnStr = "辅耗材";break;
            }
        }
        return returnStr;
    }

    public void setMaterialTypeStr(String materialTypeStr) {
        this.materialTypeStr = materialTypeStr;
    }

    public Float getEstAmount() {
        return estAmount;
    }

    public void setEstAmount(Float estAmount) {
        this.estAmount = estAmount;
    }

    public Float getRealAmount() {
        return realAmount;
    }

    public void setRealAmount(Float realAmount) {
        this.realAmount = realAmount;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Float getUseAmount() {
        return useAmount;
    }

    public void setUseAmount(Float useAmount) {
        this.useAmount = useAmount;
    }

    public Float getDiff() {
        return diff;
    }

    public void setDiff(Float diff) {
        this.diff = diff;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }
}
