/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PrdcJob;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeSku;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;
import com.thebeastshop.wms.vo.WhJitPackageSkuReferenceVO;
import com.thebeastshop.wms.vo.WhPhysicalWarehouseVO;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotNull;

/**
 * @author Eric.Lou
 * @version $Id: PrdcJobVO.java, v 0.1 2016-01-04 上午10:34
 */
@ExcelTemplate
@ExcelSheet("生产任务管理")
public class PrdcJobVO extends PrdcJob implements Serializable {

    private Long id;

    public PrdcJobVO(){}

    private Integer planStatus;

    private String warehouseCode;

    //仓库名称
    @ExcelColumn(name="生产加工仓")
    @NotNull
    private String warehouseName;
    
    //加工类型中文描述
    @ExcelColumn(name="加工类型")
    @NotNull
    private String jobTypeCN;
    // self
    private String recipeName;
    private String skuName;
    private List<PrdcJobLineVO> prdcJobLineVOList;

    private List<PrdcRecipeSku> prdcRecipeSkus;

    private String referenceCode;

    private String customizationContent;

    private Long skuBuyerId;
    
    private Long packageSkuId;

    private String skuBuyerName;

    private String physicalWarehouseName;

    private WhPhysicalWarehouseVO whPhysicalWarehouse;
    // 配方创建人
    private String recipeCreateOperatorName;

    private List<WhJitPackageSkuReferenceVO> jitPackageSkuReferenceList;

    private String packageCode;
    
    private String skuCode;
    
    private Integer finishedQuantity;
    
    private Integer sign;

    private Integer priority;

    private Boolean physicalWhIsWarehouse;    //物理仓类型是否为仓库

    private Integer customization;//是否定制

	public Long getPackageSkuId() {
		return packageSkuId;
	}

	public void setPackageSkuId(Long packageSkuId) {
		this.packageSkuId = packageSkuId;
	}

	public String getPackageCode() {
		return packageCode;
	}

	public void setPackageCode(String packageCode) {
		this.packageCode = packageCode;
	}

	public String getSkuCode() {
		return skuCode;
	}

	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}

	public Integer getFinishedQuantity() {
		return finishedQuantity;
	}

	public void setFinishedQuantity(Integer finishedQuantity) {
		this.finishedQuantity = finishedQuantity;
	}

	public Integer getSign() {
		return sign;
	}

	public void setSign(Integer sign) {
		this.sign = sign;
	}

	public String getJobTypeCN() {
		return jobTypeCN;
	}

	public void setJobTypeCN(String jobTypeCN) {
		this.jobTypeCN = jobTypeCN;
	}

	public void setWarehouseName(String warehouseName) {
		this.warehouseName = warehouseName;
	}

    public String getReferenceCode() {
        return referenceCode;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public Long getSkuBuyerId() {
        return skuBuyerId;
    }

    public void setSkuBuyerId(Long skuBuyerId) {
        this.skuBuyerId = skuBuyerId;
    }

    public Integer getCustomization() {
        return customization;
    }

    public void setCustomization(Integer customization) {
        this.customization = customization;
    }

    public String getSkuBuyerName() {
        return skuBuyerName;
    }

    public void setSkuBuyerName(String skuBuyerName) {
        this.skuBuyerName = skuBuyerName;
    }
    // manual generate
    /**
     * 状态名称
     * @return
     */
    public String getPlanStatusName(){
        return planStatus==null?"error":
                planStatus.equals(PrdcJob.PLAN_STATUS_CANCEL)?"取消":
                        planStatus.equals(PrdcJob.PLAN_STATUS_CONFIRM)?"待确认":
                                planStatus.equals(PrdcJob.PLAN_STATUS_RETURN_MODIFY)?"待修改":
                                        planStatus.equals(PrdcJob.PLAN_STATUS_PROCESSING)?"执行中":
                        planStatus.equals(PrdcJob.PLAN_STATUS_FINISHED)?"完成":
                                planStatus.equals(PrdcJob.PLAN_STATUS_CANCEL)?"取消":
                                        planStatus.equals(PrdcJob.PLAN_STATUS_FINISHED)?"完成":
                                                planStatus.equals(PrdcJob.WMS_STATUS_RETURN_MODIFY)?"待加工":
                                                        planStatus.equals(PrdcJob.WMS_PLAN_STATUS_PROCESSING)?"加工中":
                                                                planStatus.equals(PrdcJob.WMS_PLAN_STATUS_PARTFINISHED)?"部分完成":
                                                                        planStatus.equals(PrdcJob.WMS_PLAN_STATUS_FINISHED)?"加工完成":"";
    }

    /**
     * 状态名称
     * @return
     */
    public String getWmsPlanStatusName(){
        return planStatus==null?"error":
                planStatus.equals(PrdcJob.PLAN_STATUS_CANCEL)?"取消":
                                                planStatus.equals(PrdcJob.PLAN_STATUS_FINISHED)?"完成":
                                                        planStatus.equals(PrdcJob.WMS_STATUS_RETURN_MODIFY)?"待加工":
                                                                planStatus.equals(PrdcJob.WMS_PLAN_STATUS_PROCESSING)?"加工中":
                                                                        planStatus.equals(PrdcJob.WMS_PLAN_STATUS_PARTFINISHED)?"部分完成":
                                                                                planStatus.equals(PrdcJob.WMS_PLAN_STATUS_FINISHED)?"加工完成":"";
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    @Override
    public Integer getPriority() {
        return priority;
    }

    @Override
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setPhysicalWhIsWarehouse(Boolean physicalWhIsWarehouse) {
        this.physicalWhIsWarehouse = physicalWhIsWarehouse;
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public WhPhysicalWarehouseVO getWhPhysicalWarehouse() {
        return whPhysicalWarehouse;
    }

    public void setWhPhysicalWarehouse(WhPhysicalWarehouseVO whPhysicalWarehouse) {
        this.whPhysicalWarehouse = whPhysicalWarehouse;
    }

    public Boolean getPhysicalWhIsWarehouse() {
        return physicalWhIsWarehouse;
    }

    public String getCustomizationContent() {
        return customizationContent;
    }

    public void setCustomizationContent(String customizationContent) {
        this.customizationContent = customizationContent;
    }

    public String getRecipeCreateOperatorName() {
        return recipeCreateOperatorName;
    }

    public void setRecipeCreateOperatorName(String recipeCreateOperatorName) {
        this.recipeCreateOperatorName = recipeCreateOperatorName;
    }

    @Override
    public Integer getPlanStatus() {
        return planStatus;
    }

    @Override
    public void setPlanStatus(Integer planStatus) {
        this.planStatus = planStatus;
    }

    @Override
    public String getWarehouseCode() {
        return warehouseCode;
    }

    @Override
    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getRecipeName() {
        return recipeName;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public void setRecipeName(String recipeName) {
        this.recipeName = recipeName;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public List<WhJitPackageSkuReferenceVO> getJitPackageSkuReferenceList() {
        return jitPackageSkuReferenceList;
    }

    public void setJitPackageSkuReferenceList(List<WhJitPackageSkuReferenceVO> jitPackageSkuReferenceList) {
        this.jitPackageSkuReferenceList = jitPackageSkuReferenceList;
    }

    public List<PrdcJobLineVO> getPrdcJobLineVOList() {
        return prdcJobLineVOList;
    }

    public void setPrdcJobLineVOList(List<PrdcJobLineVO> prdcJobLineVOList) {
        this.prdcJobLineVOList = prdcJobLineVOList;
    }

    public List<PrdcRecipeSku> getPrdcRecipeSkus() {
        return prdcRecipeSkus;
    }

    public void setPrdcRecipeSkus(List<PrdcRecipeSku> prdcRecipeSkus) {
        this.prdcRecipeSkus = prdcRecipeSkus;
    }
}
